// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::FileSystemAccessAccessHandleLockMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::FileSystemAccessWritableFileStreamLockMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileSystemAccessRegularFileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemAccessRegularFileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemAccessRegularFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::os_file(input)) in_os_file = Traits::os_file(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->os_file)::BaseType> os_file_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
        in_os_file,
        os_file_fragment);

      fragment->os_file.Set(
          os_file_fragment.is_null() ? nullptr : os_file_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->os_file.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null os_file in FileSystemAccessRegularFile struct");

      fragment->file_size = Traits::file_size(input);

      decltype(Traits::file_modification_host(input)) in_file_modification_host = Traits::file_modification_host(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileModificationHostInterfaceBase>>(
        in_file_modification_host,
        &fragment->file_modification_host,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->file_modification_host)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid file_modification_host in FileSystemAccessRegularFile struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileSystemAccessAccessHandleFileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FileSystemAccessAccessHandleFileDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FileSystemAccessAccessHandleFile_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FileSystemAccessAccessHandleFileDataView::Tag::kRegularFile: {
    decltype(Traits::regular_file(input))
    in_regular_file = Traits::regular_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regular_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FileSystemAccessRegularFileDataView, send_validation>(
  in_regular_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regular_file in FileSystemAccessAccessHandleFile union");
    fragment->data.f_regular_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::FileSystemAccessAccessHandleFileDataView::Tag::kIncognitoFileDelegate: {
    decltype(Traits::incognito_file_delegate(input))
    in_incognito_file_delegate = Traits::incognito_file_delegate(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileDelegateHostInterfaceBase>, send_validation>(
  in_incognito_file_delegate,
  &fragment->data.f_incognito_file_delegate,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_incognito_file_delegate)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null incognito_file_delegate in FileSystemAccessAccessHandleFile union");
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_HANDLE_MOJOM_SEND_VALIDATION_H_