// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

FileSystemAccessFileDelegateHost::IPCStableHashFunction FileSystemAccessFileDelegateHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessFileDelegateHost>(message.name())) {
    case messages::FileSystemAccessFileDelegateHost::kRead: {
      return &FileSystemAccessFileDelegateHost::Read_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileDelegateHost::kWrite: {
      return &FileSystemAccessFileDelegateHost::Write_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileDelegateHost::kGetLength: {
      return &FileSystemAccessFileDelegateHost::GetLength_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileDelegateHost::kSetLength: {
      return &FileSystemAccessFileDelegateHost::SetLength_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessFileDelegateHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessFileDelegateHost>(message.name())) {
      case messages::FileSystemAccessFileDelegateHost::kRead:
            return "Receive blink::mojom::FileSystemAccessFileDelegateHost::Read";
      case messages::FileSystemAccessFileDelegateHost::kWrite:
            return "Receive blink::mojom::FileSystemAccessFileDelegateHost::Write";
      case messages::FileSystemAccessFileDelegateHost::kGetLength:
            return "Receive blink::mojom::FileSystemAccessFileDelegateHost::GetLength";
      case messages::FileSystemAccessFileDelegateHost::kSetLength:
            return "Receive blink::mojom::FileSystemAccessFileDelegateHost::SetLength";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessFileDelegateHost>(message.name())) {
      case messages::FileSystemAccessFileDelegateHost::kRead:
            return "Receive reply blink::mojom::FileSystemAccessFileDelegateHost::Read";
      case messages::FileSystemAccessFileDelegateHost::kWrite:
            return "Receive reply blink::mojom::FileSystemAccessFileDelegateHost::Write";
      case messages::FileSystemAccessFileDelegateHost::kGetLength:
            return "Receive reply blink::mojom::FileSystemAccessFileDelegateHost::GetLength";
      case messages::FileSystemAccessFileDelegateHost::kSetLength:
            return "Receive reply blink::mojom::FileSystemAccessFileDelegateHost::SetLength";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessFileDelegateHost::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc48563db;  // IPCStableHash for blink::mojom::FileSystemAccessFileDelegateHost::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileDelegateHost::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3065d0e;  // IPCStableHash for blink::mojom::FileSystemAccessFileDelegateHost::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileDelegateHost::GetLength_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1dc8fcb4;  // IPCStableHash for blink::mojom::FileSystemAccessFileDelegateHost::GetLength
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileDelegateHost::SetLength_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2c44450;  // IPCStableHash for blink::mojom::FileSystemAccessFileDelegateHost::SetLength
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileSystemAccessFileDelegateHost::Read(int64_t offset, int32_t bytes_to_read, std::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read) {
  NOTREACHED();
}
bool FileSystemAccessFileDelegateHost::Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, ::base::File::Error* out_error, int32_t* out_bytes_written) {
  NOTREACHED();
}
bool FileSystemAccessFileDelegateHost::GetLength(::base::File::Error* out_error, int64_t* out_length) {
  NOTREACHED();
}
bool FileSystemAccessFileDelegateHost::SetLength(int64_t length, ::base::File::Error* out_error) {
  NOTREACHED();
}
class FileSystemAccessFileDelegateHost_Read_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Read_HandleSyncResponse(
      bool* result, std::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read)
      : result_(result), out_data_(out_data), out_error_(out_error), out_bytes_read_(out_bytes_read) {
    DCHECK(!*result_);
  }

  FileSystemAccessFileDelegateHost_Read_HandleSyncResponse(const FileSystemAccessFileDelegateHost_Read_HandleSyncResponse&) = delete;
  FileSystemAccessFileDelegateHost_Read_HandleSyncResponse& operator=(const FileSystemAccessFileDelegateHost_Read_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::optional<::mojo_base::BigBuffer>* out_data_;
  ::base::File::Error* out_error_;
  int32_t* out_bytes_read_;};

class FileSystemAccessFileDelegateHost_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Read_ForwardToCallback(
      FileSystemAccessFileDelegateHost::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileDelegateHost_Read_ForwardToCallback(const FileSystemAccessFileDelegateHost_Read_ForwardToCallback&) = delete;
  FileSystemAccessFileDelegateHost_Read_ForwardToCallback& operator=(const FileSystemAccessFileDelegateHost_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::ReadCallback callback_;
};
class FileSystemAccessFileDelegateHost_Write_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Write_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, int32_t* out_bytes_written)
      : result_(result), out_error_(out_error), out_bytes_written_(out_bytes_written) {
    DCHECK(!*result_);
  }

  FileSystemAccessFileDelegateHost_Write_HandleSyncResponse(const FileSystemAccessFileDelegateHost_Write_HandleSyncResponse&) = delete;
  FileSystemAccessFileDelegateHost_Write_HandleSyncResponse& operator=(const FileSystemAccessFileDelegateHost_Write_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  int32_t* out_bytes_written_;};

class FileSystemAccessFileDelegateHost_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Write_ForwardToCallback(
      FileSystemAccessFileDelegateHost::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileDelegateHost_Write_ForwardToCallback(const FileSystemAccessFileDelegateHost_Write_ForwardToCallback&) = delete;
  FileSystemAccessFileDelegateHost_Write_ForwardToCallback& operator=(const FileSystemAccessFileDelegateHost_Write_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::WriteCallback callback_;
};
class FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, int64_t* out_length)
      : result_(result), out_error_(out_error), out_length_(out_length) {
    DCHECK(!*result_);
  }

  FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse(const FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse&) = delete;
  FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse& operator=(const FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  int64_t* out_length_;};

class FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback(
      FileSystemAccessFileDelegateHost::GetLengthCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback(const FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback&) = delete;
  FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback& operator=(const FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::GetLengthCallback callback_;
};
class FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse(const FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse&) = delete;
  FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse& operator=(const FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback(
      FileSystemAccessFileDelegateHost::SetLengthCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback(const FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback&) = delete;
  FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback& operator=(const FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::SetLengthCallback callback_;
};

FileSystemAccessFileDelegateHostProxy::FileSystemAccessFileDelegateHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileSystemAccessFileDelegateHostProxy::Read(
    int64_t param_offset, int32_t param_bytes_to_read, std::optional<::mojo_base::BigBuffer>* out_param_data, ::base::File::Error* out_param_error, int32_t* out_param_bytes_read) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemAccessFileDelegateHost::Read (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), param_offset,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_to_read"), param_bytes_to_read,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemAccessFileDelegateHost::Read");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_Params_Data> params(
          message);
  params.Allocate();

  params->offset = param_offset;

  params->bytes_to_read = param_bytes_to_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Read_HandleSyncResponse(
          &result, out_param_data, out_param_error, out_param_bytes_read));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemAccessFileDelegateHost::Read", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_read"), out_param_bytes_read,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::Read(
    int64_t in_offset, int32_t in_bytes_to_read, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileDelegateHost::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_to_read"), in_bytes_to_read,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  params->bytes_to_read = in_bytes_to_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemAccessFileDelegateHostProxy::Write(
    int64_t param_offset, ::mojo::ScopedDataPipeConsumerHandle param_data, ::base::File::Error* out_param_error, int32_t* out_param_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemAccessFileDelegateHost::Write (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), param_offset,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), param_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemAccessFileDelegateHost::Write");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_Params_Data> params(
          message);
  params.Allocate();

  params->offset = param_offset;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    param_data,
    &params->data,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data in FileSystemAccessFileDelegateHost.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Write_HandleSyncResponse(
          &result, out_param_error, out_param_bytes_written));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemAccessFileDelegateHost::Write", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_written"), out_param_bytes_written,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::Write(
    int64_t in_offset, ::mojo::ScopedDataPipeConsumerHandle in_data, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileDelegateHost::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_data,
    &params->data,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data in FileSystemAccessFileDelegateHost.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Write_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemAccessFileDelegateHostProxy::GetLength(
    ::base::File::Error* out_param_error, int64_t* out_param_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call blink::mojom::FileSystemAccessFileDelegateHost::GetLength (sync)");
#else
  TRACE_EVENT0("mojom", "FileSystemAccessFileDelegateHost::GetLength");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kGetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("GetLength");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse(
          &result, out_param_error, out_param_length));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemAccessFileDelegateHost::GetLength", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), out_param_length,
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::GetLength(
    GetLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileDelegateHost::GetLength");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kGetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("GetLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemAccessFileDelegateHostProxy::SetLength(
    int64_t param_length, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemAccessFileDelegateHost::SetLength (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), param_length,
                        "<value of type int64_t>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemAccessFileDelegateHost::SetLength");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kSetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data> params(
          message);
  params.Allocate();

  params->length = param_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("SetLength");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemAccessFileDelegateHost::SetLength", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::SetLength(
    int64_t in_length, SetLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileDelegateHost::SetLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kSetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data> params(
          message);
  params.Allocate();

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("SetLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemAccessFileDelegateHost_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_Read_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileDelegateHost_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileDelegateHost::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_data, ::base::File::Error in_error, int32_t in_bytes_read);
};

bool FileSystemAccessFileDelegateHost_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.0
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_data{};
  ::base::File::Error p_error{};
  int32_t p_bytes_read{};
  FileSystemAccessFileDelegateHost_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_read = input_data_view.bytes_read();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data), 
std::move(p_error), 
std::move(p_bytes_read));
  }
  return true;
}

void FileSystemAccessFileDelegateHost_Read_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_data, ::base::File::Error in_error, int32_t in_bytes_read) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileDelegateHost::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_read"), in_bytes_read,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

  params->bytes_read = in_bytes_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_Read_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.0
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_data{};
  ::base::File::Error p_error{};
  int32_t p_bytes_read{};
  FileSystemAccessFileDelegateHost_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_read = input_data_view.bytes_read();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 0, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *out_error_ = std::move(p_error);
  *out_bytes_read_ = std::move(p_bytes_read);
  *result_ = true;
  return true;
}
class FileSystemAccessFileDelegateHost_Write_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::WriteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_Write_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_Write_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileDelegateHost_Write_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileDelegateHost::WriteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, int32_t in_bytes_written);
};

bool FileSystemAccessFileDelegateHost_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.1
  bool success = true;
  ::base::File::Error p_error{};
  int32_t p_bytes_written{};
  FileSystemAccessFileDelegateHost_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_bytes_written));
  }
  return true;
}

void FileSystemAccessFileDelegateHost_Write_ProxyToResponder::Run(
    ::base::File::Error in_error, int32_t in_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileDelegateHost::Write", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_written"), in_bytes_written,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

  params->bytes_written = in_bytes_written;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_Write_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.1
  bool success = true;
  ::base::File::Error p_error{};
  int32_t p_bytes_written{};
  FileSystemAccessFileDelegateHost_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 1, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_bytes_written_ = std::move(p_bytes_written);
  *result_ = true;
  return true;
}
class FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::GetLengthCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileDelegateHost::GetLengthCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, int64_t in_length);
};

bool FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.2
  bool success = true;
  ::base::File::Error p_error{};
  int64_t p_length{};
  FileSystemAccessFileDelegateHost_GetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_length));
  }
  return true;
}

void FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::Run(
    ::base::File::Error in_error, int64_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileDelegateHost::GetLength", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kGetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("GetLength");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_GetLength_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.2
  bool success = true;
  ::base::File::Error p_error{};
  int64_t p_length{};
  FileSystemAccessFileDelegateHost_GetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 2, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_length_ = std::move(p_length);
  *result_ = true;
  return true;
}
class FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::SetLengthCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileDelegateHost::SetLengthCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.3
  bool success = true;
  ::base::File::Error p_error{};
  FileSystemAccessFileDelegateHost_SetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileDelegateHost::SetLength", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileDelegateHost::kSetLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("SetLength");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_SetLength_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemAccessFileDelegateHost.3
  bool success = true;
  ::base::File::Error p_error{};
  FileSystemAccessFileDelegateHost_SetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 3, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}

// static
bool FileSystemAccessFileDelegateHostStubDispatch::Accept(
    FileSystemAccessFileDelegateHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessFileDelegateHost>(message->header()->name)) {
    case messages::FileSystemAccessFileDelegateHost::kRead: {
      break;
    }
    case messages::FileSystemAccessFileDelegateHost::kWrite: {
      break;
    }
    case messages::FileSystemAccessFileDelegateHost::kGetLength: {
      break;
    }
    case messages::FileSystemAccessFileDelegateHost::kSetLength: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileDelegateHostStubDispatch::AcceptWithResponder(
    FileSystemAccessFileDelegateHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessFileDelegateHost>(message->header()->name)) {
    case messages::FileSystemAccessFileDelegateHost::kRead: {
      internal::FileSystemAccessFileDelegateHost_Read_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileDelegateHost.0
      bool success = true;
      int64_t p_offset{};
      int32_t p_bytes_to_read{};
      FileSystemAccessFileDelegateHost_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_bytes_to_read = input_data_view.bytes_to_read();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileDelegateHost_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(        
        std::move(p_offset), 
        std::move(p_bytes_to_read), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileDelegateHost::kWrite: {
      internal::FileSystemAccessFileDelegateHost_Write_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_Write_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileDelegateHost.1
      bool success = true;
      int64_t p_offset{};
      ::mojo::ScopedDataPipeConsumerHandle p_data{};
      FileSystemAccessFileDelegateHost_Write_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_data = input_data_view.TakeData();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileDelegateHost_Write_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_offset), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileDelegateHost::kGetLength: {
      internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileDelegateHost.2
      bool success = true;
      FileSystemAccessFileDelegateHost_GetLength_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLength(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileDelegateHost::kSetLength: {
      internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileDelegateHost.3
      bool success = true;
      int64_t p_length{};
      FileSystemAccessFileDelegateHost_SetLength_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 3, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLength(        
        std::move(p_length), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessFileDelegateHostValidationInfo[] = {
    { &internal::FileSystemAccessFileDelegateHost_Read_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileDelegateHost_Write_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data::Validate},
};

bool FileSystemAccessFileDelegateHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessFileDelegateHost::Name_,
    kFileSystemAccessFileDelegateHostValidationInfo);
}

bool FileSystemAccessFileDelegateHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessFileDelegateHost::Name_,
    kFileSystemAccessFileDelegateHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileSystemAccessFileDelegateHostInterceptorForTesting::Read(int64_t offset, int32_t bytes_to_read, ReadCallback callback) {
  GetForwardingInterface()->Read(
    std::move(offset)
    , 
    std::move(bytes_to_read)
    , std::move(callback));
}
void FileSystemAccessFileDelegateHostInterceptorForTesting::Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, WriteCallback callback) {
  GetForwardingInterface()->Write(
    std::move(offset)
    , 
    std::move(data)
    , std::move(callback));
}
void FileSystemAccessFileDelegateHostInterceptorForTesting::GetLength(GetLengthCallback callback) {
  GetForwardingInterface()->GetLength(std::move(callback));
}
void FileSystemAccessFileDelegateHostInterceptorForTesting::SetLength(int64_t length, SetLengthCallback callback) {
  GetForwardingInterface()->SetLength(
    std::move(length)
    , std::move(callback));
}
FileSystemAccessFileDelegateHostAsyncWaiter::FileSystemAccessFileDelegateHostAsyncWaiter(
    FileSystemAccessFileDelegateHost* proxy) : proxy_(proxy) {}

FileSystemAccessFileDelegateHostAsyncWaiter::~FileSystemAccessFileDelegateHostAsyncWaiter() = default;


void FileSystemAccessFileDelegateHostAsyncWaiter::Read(
    int64_t offset, int32_t bytes_to_read, std::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read) {
  base::RunLoop loop;
  proxy_->Read(
      std::move(offset),
      std::move(bytes_to_read),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_data
,
             ::base::File::Error* out_error
,
             int32_t* out_bytes_read
,
             std::optional<::mojo_base::BigBuffer> data,
             ::base::File::Error error,
             int32_t bytes_read) {*out_data = std::move(data);*out_error = std::move(error);*out_bytes_read = std::move(bytes_read);
            loop->Quit();
          },
          &loop,
          out_data,
          out_error,
          out_bytes_read));
  loop.Run();
}



void FileSystemAccessFileDelegateHostAsyncWaiter::Write(
    int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, ::base::File::Error* out_error, int32_t* out_bytes_written) {
  base::RunLoop loop;
  proxy_->Write(
      std::move(offset),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             int32_t* out_bytes_written
,
             ::base::File::Error error,
             int32_t bytes_written) {*out_error = std::move(error);*out_bytes_written = std::move(bytes_written);
            loop->Quit();
          },
          &loop,
          out_error,
          out_bytes_written));
  loop.Run();
}



void FileSystemAccessFileDelegateHostAsyncWaiter::GetLength(
    ::base::File::Error* out_error, int64_t* out_length) {
  base::RunLoop loop;
  proxy_->GetLength(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             int64_t* out_length
,
             ::base::File::Error error,
             int64_t length) {*out_error = std::move(error);*out_length = std::move(length);
            loop->Quit();
          },
          &loop,
          out_error,
          out_length));
  loop.Run();
}



void FileSystemAccessFileDelegateHostAsyncWaiter::SetLength(
    int64_t length, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->SetLength(
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error FileSystemAccessFileDelegateHostAsyncWaiter::SetLength(
    int64_t length) {
  ::base::File::Error async_wait_result;
  SetLength(std::move(length),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif