// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"


namespace blink::mojom {
class FileSystemAccessEntryDataView;

class FileSystemAccessHandleDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessEntryDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemAccessHandleDataView> {
  using Data = ::blink::mojom::internal::FileSystemAccessHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class FileSystemAccessDirectoryEntriesListenerInterfaceBase {};

using FileSystemAccessDirectoryEntriesListenerPtrDataView =
    mojo::InterfacePtrDataView<FileSystemAccessDirectoryEntriesListenerInterfaceBase>;
using FileSystemAccessDirectoryEntriesListenerRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemAccessDirectoryEntriesListenerInterfaceBase>;
using FileSystemAccessDirectoryEntriesListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemAccessDirectoryEntriesListenerInterfaceBase>;
using FileSystemAccessDirectoryEntriesListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemAccessDirectoryEntriesListenerInterfaceBase>;
class FileSystemAccessDirectoryHandleInterfaceBase {};

using FileSystemAccessDirectoryHandlePtrDataView =
    mojo::InterfacePtrDataView<FileSystemAccessDirectoryHandleInterfaceBase>;
using FileSystemAccessDirectoryHandleRequestDataView =
    mojo::InterfaceRequestDataView<FileSystemAccessDirectoryHandleInterfaceBase>;
using FileSystemAccessDirectoryHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileSystemAccessDirectoryHandleInterfaceBase>;
using FileSystemAccessDirectoryHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileSystemAccessDirectoryHandleInterfaceBase>;


class FileSystemAccessEntryDataView {
 public:
  FileSystemAccessEntryDataView() = default;

  FileSystemAccessEntryDataView(
      internal::FileSystemAccessEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEntryHandleDataView(
      FileSystemAccessHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntryHandle(UserType* output) {
    
    auto* pointer = !data_->entry_handle.is_null() ? &data_->entry_handle : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FileSystemAccessHandleDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileSystemAccessEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemAccessHandleDataView {
 public:
  using Tag = internal::FileSystemAccessHandle_Data::FileSystemAccessHandle_Tag;

  FileSystemAccessHandleDataView() = default;

  FileSystemAccessHandleDataView(
      internal::FileSystemAccessHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file() const { return data_->tag == Tag::kFile; }
  template <typename UserType>
  UserType TakeFile() {
    CHECK(is_file());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessFileHandleInterfaceBase>>(
            &data_->data.f_file, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_directory() const { return data_->tag == Tag::kDirectory; }
  template <typename UserType>
  UserType TakeDirectory() {
    CHECK(is_directory());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
            &data_->data.f_directory, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::FileSystemAccessHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_DATA_VIEW_H_