// third_party/blink/public/mojom/file/file_utilities.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FileInfo as mojoBase_mojom_FileInfo,
  FileInfoSpec as mojoBase_mojom_FileInfoSpec
} from '../../../../../mojo/public/mojom/base/file_info.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileUtilitiesHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileUtilitiesHost', scope);
  }
}

/** @interface */
export class FileUtilitiesHostInterface {
  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: ?mojoBase_mojom_FileInfo,
   *  }>}
   */

  getFileInfo(path) {}
}

/**
 * @implements { FileUtilitiesHostInterface }
 */
export class FileUtilitiesHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileUtilitiesHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileUtilitiesHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileUtilitiesHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } path
   * @return {!Promise<{
        result: ?mojoBase_mojom_FileInfo,
   *  }>}
   */

  getFileInfo(
      path) {
    return this.proxy.sendMessage(
        0,
        FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileUtilitiesHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileUtilitiesHostReceiver {
  /**
   * @param {!FileUtilitiesHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileUtilitiesHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileUtilitiesHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileUtilitiesHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        impl.getFileInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileUtilitiesHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileUtilitiesHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileUtilitiesHostRemote}
   */
  static getRemote() {
    let remote = new FileUtilitiesHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileUtilitiesHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileUtilitiesHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileUtilitiesHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileUtilitiesHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
        FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
        this.getFileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileUtilitiesHost_GetFileInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileUtilitiesHost_GetFileInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileUtilitiesHost_GetFileInfo_ParamsSpec.$,
    'FileUtilitiesHost_GetFileInfo_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileUtilitiesHost_GetFileInfo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
  }
}



mojo.internal.Struct(
    FileUtilitiesHost_GetFileInfo_ResponseParamsSpec.$,
    'FileUtilitiesHost_GetFileInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_FileInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileUtilitiesHost_GetFileInfo_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_FileInfo|undefined) } */
    this.result;
  }
}

