// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/renderer/platform/loader/fetch/fetch_api_request_body_mojom_traits.h"


namespace blink::mojom::blink {
FetchAPIRequestHeaders::FetchAPIRequestHeaders()
    : headers() {}

FetchAPIRequestHeaders::FetchAPIRequestHeaders(
    const ::blink::HashMap<::blink::String, ::blink::String>& headers_in)
    : headers(std::move(headers_in)) {}

FetchAPIRequestHeaders::~FetchAPIRequestHeaders() = default;

void FetchAPIRequestHeaders::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::blink::String, ::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequestHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequestBody::FetchAPIRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info() {}

FetchAPIRequestBody::FetchAPIRequestBody(
    ::blink::Vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)) {}

FetchAPIRequestBody::~FetchAPIRequestBody() = default;

void FetchAPIRequestBody::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elements"), this->elements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::DataElement>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identifier"), this->identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_sensitive_info"), this->contains_sensitive_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequest::FetchAPIRequest()
    : mode(::network::mojom::blink::RequestMode::kNoCors),
      is_main_resource_load(false),
      destination(::network::mojom::blink::RequestDestination::kEmpty),
      frame_type(::blink::mojom::blink::RequestContextFrameType::kNone),
      url(),
      method(),
      headers(),
      blob(),
      body(),
      request_initiator(),
      navigation_redirect_chain(),
      referrer(),
      credentials_mode(::network::mojom::blink::CredentialsMode::kOmit),
      cache_mode(FetchCacheMode::kDefault),
      redirect_mode(::network::mojom::blink::RedirectMode::kFollow),
      integrity(),
      priority(mojo::internal::ConvertEnumValue<::network::mojom::blink::RequestPriority, ::net::RequestPriority>(::network::mojom::blink::RequestPriority::kIdle)),
      fetch_window_id(),
      keepalive(false),
      is_reload(false),
      is_history_navigation(false),
      devtools_stack_id(),
      trust_token_params(),
      target_address_space(::network::mojom::blink::IPAddressSpace::kUnknown),
      attribution_reporting_eligibility(::network::mojom::blink::AttributionReportingEligibility::kUnset),
      attribution_reporting_support(::network::mojom::blink::AttributionSupport::kUnset),
      service_worker_race_network_request_token() {}

FetchAPIRequest::FetchAPIRequest(
    ::network::mojom::blink::RequestMode mode_in,
    bool is_main_resource_load_in,
    ::network::mojom::blink::RequestDestination destination_in,
    ::blink::mojom::blink::RequestContextFrameType frame_type_in,
    const ::blink::KURL& url_in,
    const ::blink::String& method_in,
    ::blink::HashMap<::blink::String, ::blink::String, ::blink::CaseFoldingHashTraits<::blink::String>> headers_in,
    const ::scoped_refptr<::blink::BlobDataHandle>& blob_in,
    ::blink::ResourceRequestBody body_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator_in,
    ::blink::Vector<::blink::KURL> navigation_redirect_chain_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    ::network::mojom::blink::CredentialsMode credentials_mode_in,
    FetchCacheMode cache_mode_in,
    ::network::mojom::blink::RedirectMode redirect_mode_in,
    const ::blink::String& integrity_in,
    ::net::RequestPriority priority_in,
    const std::optional<::base::UnguessableToken>& fetch_window_id_in,
    bool keepalive_in,
    bool is_reload_in,
    bool is_history_navigation_in,
    const ::blink::String& devtools_stack_id_in,
    ::network::mojom::blink::TrustTokenParamsPtr trust_token_params_in,
    ::network::mojom::blink::IPAddressSpace target_address_space_in,
    ::network::mojom::blink::AttributionReportingEligibility attribution_reporting_eligibility_in,
    ::network::mojom::blink::AttributionSupport attribution_reporting_support_in,
    const std::optional<::base::UnguessableToken>& service_worker_race_network_request_token_in)
    : mode(std::move(mode_in)),
      is_main_resource_load(std::move(is_main_resource_load_in)),
      destination(std::move(destination_in)),
      frame_type(std::move(frame_type_in)),
      url(std::move(url_in)),
      method(std::move(method_in)),
      headers(std::move(headers_in)),
      blob(std::move(blob_in)),
      body(std::move(body_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      referrer(std::move(referrer_in)),
      credentials_mode(std::move(credentials_mode_in)),
      cache_mode(std::move(cache_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      integrity(std::move(integrity_in)),
      priority(std::move(priority_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      keepalive(std::move(keepalive_in)),
      is_reload(std::move(is_reload_in)),
      is_history_navigation(std::move(is_history_navigation_in)),
      devtools_stack_id(std::move(devtools_stack_id_in)),
      trust_token_params(std::move(trust_token_params_in)),
      target_address_space(std::move(target_address_space_in)),
      attribution_reporting_eligibility(std::move(attribution_reporting_eligibility_in)),
      attribution_reporting_support(std::move(attribution_reporting_support_in)),
      service_worker_race_network_request_token(std::move(service_worker_race_network_request_token_in)) {}

FetchAPIRequest::~FetchAPIRequest() = default;

void FetchAPIRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RequestMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_resource_load"), this->is_main_resource_load,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_type"), this->frame_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::RequestContextFrameType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::blink::String, ::blink::String, ::blink::CaseFoldingHashTraits<::blink::String>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob"), this->blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::ResourceRequestBody>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_initiator"), this->request_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_redirect_chain"), this->navigation_redirect_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials_mode"), this->credentials_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CredentialsMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_mode"), this->cache_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FetchCacheMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_mode"), this->redirect_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::RedirectMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity"), this->integrity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_window_id"), this->fetch_window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keepalive"), this->keepalive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_reload"), this->is_reload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_history_navigation"), this->is_history_navigation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_stack_id"), this->devtools_stack_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_address_space"), this->target_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_reporting_eligibility"), this->attribution_reporting_eligibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AttributionReportingEligibility>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_reporting_support"), this->attribution_reporting_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AttributionSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_race_network_request_token"), this->service_worker_race_network_request_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FetchAPIRequestHeaders::DataView, ::blink::mojom::blink::FetchAPIRequestHeadersPtr>::Read(
    ::blink::mojom::blink::FetchAPIRequestHeaders::DataView input,
    ::blink::mojom::blink::FetchAPIRequestHeadersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FetchAPIRequestHeadersPtr result(::blink::mojom::blink::FetchAPIRequestHeaders::New());
  
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FetchAPIRequestBody::DataView, ::blink::mojom::blink::FetchAPIRequestBodyPtr>::Read(
    ::blink::mojom::blink::FetchAPIRequestBody::DataView input,
    ::blink::mojom::blink::FetchAPIRequestBodyPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FetchAPIRequestBodyPtr result(::blink::mojom::blink::FetchAPIRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FetchAPIRequest::DataView, ::blink::mojom::blink::FetchAPIRequestPtr>::Read(
    ::blink::mojom::blink::FetchAPIRequest::DataView input,
    ::blink::mojom::blink::FetchAPIRequestPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FetchAPIRequestPtr result(::blink::mojom::blink::FetchAPIRequest::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->is_main_resource_load = input.is_main_resource_load();
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadFrameType(&result->frame_type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadBlob(&result->blob))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadCacheMode(&result->cache_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadIntegrity(&result->integrity))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->is_reload = input.is_reload();
      if (success)
        result->is_history_navigation = input.is_history_navigation();
      if (success && !input.ReadDevtoolsStackId(&result->devtools_stack_id))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadTargetAddressSpace(&result->target_address_space))
        success = false;
      if (success && !input.ReadAttributionReportingEligibility(&result->attribution_reporting_eligibility))
        success = false;
      if (success && !input.ReadAttributionReportingSupport(&result->attribution_reporting_support))
        success = false;
      if (success && !input.ReadServiceWorkerRaceNetworkRequestToken(&result->service_worker_race_network_request_token))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {




}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif