// third_party/blink/public/mojom/favicon/favicon_url.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT FaviconURL {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FaviconURL, T>::value>;
  using DataView = FaviconURLDataView;
  using Data_ = internal::FaviconURL_Data;

  template <typename... Args>
  static FaviconURLPtr New(Args&&... args) {
    return FaviconURLPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FaviconURLPtr From(const U& u) {
    return mojo::TypeConverter<FaviconURLPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FaviconURL>::Convert(*this);
  }


  FaviconURL();

  FaviconURL(
      const ::blink::KURL& icon_url,
      FaviconIconType icon_type,
      ::blink::Vector<::gfx::Size> icon_sizes,
      bool is_default_icon);


  ~FaviconURL();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FaviconURLPtr>
  FaviconURLPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FaviconURL::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FaviconURL::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FaviconURL::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FaviconURL_UnserializedMessageContext<
            UserType, FaviconURL::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FaviconURL::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FaviconURL::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FaviconURL_UnserializedMessageContext<
            UserType, FaviconURL::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FaviconURL::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL icon_url;
  
  FaviconIconType icon_type;
  
  ::blink::Vector<::gfx::Size> icon_sizes;
  
  bool is_default_icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FaviconURL::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FaviconURLPtr FaviconURL::Clone() const {
  return New(
      mojo::Clone(icon_url),
      mojo::Clone(icon_type),
      mojo::Clone(icon_sizes),
      mojo::Clone(is_default_icon)
  );
}

template <typename T, FaviconURL::EnableIfSame<T>*>
bool FaviconURL::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  if (!mojo::Equals(this->icon_type, other_struct.icon_type))
    return false;
  if (!mojo::Equals(this->icon_sizes, other_struct.icon_sizes))
    return false;
  if (!mojo::Equals(this->is_default_icon, other_struct.is_default_icon))
    return false;
  return true;
}

template <typename T, FaviconURL::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  if (lhs.icon_type < rhs.icon_type)
    return true;
  if (rhs.icon_type < lhs.icon_type)
    return false;
  if (lhs.icon_sizes < rhs.icon_sizes)
    return true;
  if (rhs.icon_sizes < lhs.icon_sizes)
    return false;
  if (lhs.is_default_icon < rhs.is_default_icon)
    return true;
  if (rhs.is_default_icon < lhs.is_default_icon)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FaviconURL::DataView,
                                         ::blink::mojom::blink::FaviconURLPtr> {
  static bool IsNull(const ::blink::mojom::blink::FaviconURLPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FaviconURLPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::FaviconURL::icon_url)& icon_url(
      const ::blink::mojom::blink::FaviconURLPtr& input) {
    return input->icon_url;
  }

  static decltype(::blink::mojom::blink::FaviconURL::icon_type) icon_type(
      const ::blink::mojom::blink::FaviconURLPtr& input) {
    return input->icon_type;
  }

  static const decltype(::blink::mojom::blink::FaviconURL::icon_sizes)& icon_sizes(
      const ::blink::mojom::blink::FaviconURLPtr& input) {
    return input->icon_sizes;
  }

  static decltype(::blink::mojom::blink::FaviconURL::is_default_icon) is_default_icon(
      const ::blink::mojom::blink::FaviconURLPtr& input) {
    return input->is_default_icon;
  }

  static bool Read(::blink::mojom::blink::FaviconURL::DataView input, ::blink::mojom::blink::FaviconURLPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_BLINK_H_