// third_party/blink/public/mojom/drag/drag.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/drag/drag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::AllowedDragOperationsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AllowedDragOperationsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AllowedDragOperations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->allow_copy = Traits::allow_copy(input);

      fragment->allow_link = Traits::allow_link(input);

      fragment->allow_move = Traits::allow_move(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragItemStringDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemStringDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemString_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::string_type(input)) in_string_type = Traits::string_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->string_type)::BaseType> string_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_string_type,
        string_type_fragment);

      fragment->string_type.Set(
          string_type_fragment.is_null() ? nullptr : string_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->string_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_type in DragItemString struct");

      decltype(Traits::string_data(input)) in_string_data = Traits::string_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->string_data)::BaseType> string_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView, send_validation>(
        in_string_data,
        string_data_fragment);

      fragment->string_data.Set(
          string_data_fragment.is_null() ? nullptr : string_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->string_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_data in DragItemString struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      decltype(Traits::base_url(input)) in_base_url = Traits::base_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->base_url)::BaseType> base_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_base_url,
        base_url_fragment);

      fragment->base_url.Set(
          base_url_fragment.is_null() ? nullptr : base_url_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragItemBinaryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemBinaryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemBinary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in DragItemBinary struct");

      fragment->is_image_accessible = Traits::is_image_accessible(input);

      decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_url)::BaseType> source_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_source_url,
        source_url_fragment);

      fragment->source_url.Set(
          source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in DragItemBinary struct");

      decltype(Traits::filename_extension(input)) in_filename_extension = Traits::filename_extension(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filename_extension)::BaseType> filename_extension_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_filename_extension,
        filename_extension_fragment);

      fragment->filename_extension.Set(
          filename_extension_fragment.is_null() ? nullptr : filename_extension_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filename_extension.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filename_extension in DragItemBinary struct");

      decltype(Traits::content_disposition(input)) in_content_disposition = Traits::content_disposition(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_disposition)::BaseType> content_disposition_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_disposition,
        content_disposition_fragment);

      fragment->content_disposition.Set(
          content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragItemFileSystemFileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemFileSystemFileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemFileSystemFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in DragItemFileSystemFile struct");

      fragment->size = Traits::size(input);

      decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_file_system_id,
        file_system_id_fragment);

      fragment->file_system_id.Set(
          file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());

      decltype(Traits::serialized_blob(input)) in_serialized_blob = Traits::serialized_blob(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serialized_blob)::BaseType> serialized_blob_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView, send_validation>(
        in_serialized_blob,
        serialized_blob_fragment);

      fragment->serialized_blob.Set(
          serialized_blob_fragment.is_null() ? nullptr : serialized_blob_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in DragData struct");

      decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_file_system_id,
        file_system_id_fragment);

      fragment->file_system_id.Set(
          file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());

      fragment->force_default_action = Traits::force_default_action(input);

      
      mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input),
        &fragment->referrer_policy);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragEventSourceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragEventSourceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragEventSourceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::location(input)) in_location = Traits::location(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->location)::BaseType> location_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_location,
        location_fragment);

      fragment->location.Set(
          location_fragment.is_null() ? nullptr : location_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->location.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in DragEventSourceInfo struct");

      
      mojo::internal::Serialize<::ui::mojom::DragEventSource>(
        Traits::source(input),
        &fragment->source);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::DragItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DragItemDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DragItem_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DragItemDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemStringDataView, send_validation>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in DragItem union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataTransferFileDataView, send_validation>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in DragItem union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kBinary: {
    decltype(Traits::binary(input))
    in_binary = Traits::binary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemBinaryDataView, send_validation>(
  in_binary,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary in DragItem union");
    fragment->data.f_binary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DragItemDataView::Tag::kFileSystemFile: {
    decltype(Traits::file_system_file(input))
    in_file_system_file = Traits::file_system_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_system_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DragItemFileSystemFileDataView, send_validation>(
  in_file_system_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_system_file in DragItem union");
    fragment->data.f_file_system_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SEND_VALIDATION_H_