// third_party/blink/public/mojom/drag/drag.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/drag/drag.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/drag/drag.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink-forward.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/page/drag_mojom_traits.h"
#include "third_party/blink/renderer/platform/mojo/drag_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT AllowedDragOperations {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AllowedDragOperations, T>::value>;
  using DataView = AllowedDragOperationsDataView;
  using Data_ = internal::AllowedDragOperations_Data;

  template <typename... Args>
  static AllowedDragOperationsPtr New(Args&&... args) {
    return AllowedDragOperationsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AllowedDragOperationsPtr From(const U& u) {
    return mojo::TypeConverter<AllowedDragOperationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllowedDragOperations>::Convert(*this);
  }


  AllowedDragOperations();

  AllowedDragOperations(
      bool allow_copy,
      bool allow_link,
      bool allow_move);


  ~AllowedDragOperations();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AllowedDragOperationsPtr>
  AllowedDragOperationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllowedDragOperations::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllowedDragOperations::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllowedDragOperations::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AllowedDragOperations_UnserializedMessageContext<
            UserType, AllowedDragOperations::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AllowedDragOperations::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AllowedDragOperations::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AllowedDragOperations_UnserializedMessageContext<
            UserType, AllowedDragOperations::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AllowedDragOperations::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_copy;
  
  bool allow_link;
  
  bool allow_move;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT DragItem {
 public:
  using DataView = DragItemDataView;
  using Data_ = internal::DragItem_Data;
  using Tag = Data_::DragItem_Tag;

  template <typename... Args>
  static DragItemPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |string|.
  static DragItemPtr NewString(
      DragItemStringPtr value);
  // Construct an instance holding |file|.
  static DragItemPtr NewFile(
      ::blink::mojom::blink::DataTransferFilePtr value);
  // Construct an instance holding |binary|.
  static DragItemPtr NewBinary(
      DragItemBinaryPtr value);
  // Construct an instance holding |file_system_file|.
  static DragItemPtr NewFileSystemFile(
      DragItemFileSystemFilePtr value);

  template <typename U>
  static DragItemPtr From(const U& u) {
    return mojo::TypeConverter<DragItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItem>::Convert(*this);
  }
  ~DragItem();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DragItem(const DragItem& other) = delete;
  DragItem& operator=(const DragItem& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DragItemPtr>
  DragItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DragItem>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DragItem>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_string() const { return tag_ == Tag::kString; }
  const DragItemStringPtr& get_string() const {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  DragItemStringPtr& get_string() {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  void set_string(DragItemStringPtr string);

  bool is_file() const { return tag_ == Tag::kFile; }
  const ::blink::mojom::blink::DataTransferFilePtr& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  ::blink::mojom::blink::DataTransferFilePtr& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(::blink::mojom::blink::DataTransferFilePtr file);

  bool is_binary() const { return tag_ == Tag::kBinary; }
  const DragItemBinaryPtr& get_binary() const {
    CHECK(tag_ == Tag::kBinary);
    return data_.binary;
  }
  DragItemBinaryPtr& get_binary() {
    CHECK(tag_ == Tag::kBinary);
    return data_.binary;
  }
  void set_binary(DragItemBinaryPtr binary);

  bool is_file_system_file() const { return tag_ == Tag::kFileSystemFile; }
  const DragItemFileSystemFilePtr& get_file_system_file() const {
    CHECK(tag_ == Tag::kFileSystemFile);
    return data_.file_system_file;
  }
  DragItemFileSystemFilePtr& get_file_system_file() {
    CHECK(tag_ == Tag::kFileSystemFile);
    return data_.file_system_file;
  }
  void set_file_system_file(DragItemFileSystemFilePtr file_system_file);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItem::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DragItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
        DragItemStringPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        ::blink::mojom::blink::DataTransferFilePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
        DragItemBinaryPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemFile)>,
        DragItemFileSystemFilePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    DragItemStringPtr string;
    ::blink::mojom::blink::DataTransferFilePtr file;
    DragItemBinaryPtr binary;
    DragItemFileSystemFilePtr file_system_file;
  };

  DragItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
      DragItemStringPtr value);
  DragItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      ::blink::mojom::blink::DataTransferFilePtr value);
  DragItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
      DragItemBinaryPtr value);
  DragItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemFile)>,
      DragItemFileSystemFilePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class PLATFORM_EXPORT DragItemString {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemString, T>::value>;
  using DataView = DragItemStringDataView;
  using Data_ = internal::DragItemString_Data;

  template <typename... Args>
  static DragItemStringPtr New(Args&&... args) {
    return DragItemStringPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemStringPtr From(const U& u) {
    return mojo::TypeConverter<DragItemStringPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemString>::Convert(*this);
  }


  DragItemString();

  DragItemString(
      const ::blink::String& string_type,
      const ::blink::String& string_data,
      const ::blink::String& title,
      const std::optional<::blink::KURL>& base_url);


  ~DragItemString();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemStringPtr>
  DragItemStringPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemString::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemString_UnserializedMessageContext<
            UserType, DragItemString::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragItemString::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragItemString::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemString_UnserializedMessageContext<
            UserType, DragItemString::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemString::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String string_type;
  
  ::blink::String string_data;
  
  ::blink::String title;
  
  std::optional<::blink::KURL> base_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemBinary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemBinary, T>::value>;
  using DataView = DragItemBinaryDataView;
  using Data_ = internal::DragItemBinary_Data;

  template <typename... Args>
  static DragItemBinaryPtr New(Args&&... args) {
    return DragItemBinaryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemBinaryPtr From(const U& u) {
    return mojo::TypeConverter<DragItemBinaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemBinary>::Convert(*this);
  }


  DragItemBinary();

  DragItemBinary(
      ::mojo_base::BigBuffer data,
      bool is_image_accessible,
      const ::blink::KURL& source_url,
      const ::base::FilePath& filename_extension,
      const ::blink::String& content_disposition);

DragItemBinary(const DragItemBinary&) = delete;
DragItemBinary& operator=(const DragItemBinary&) = delete;

  ~DragItemBinary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemBinaryPtr>
  DragItemBinaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemBinary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemBinary_UnserializedMessageContext<
            UserType, DragItemBinary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragItemBinary::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragItemBinary::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemBinary_UnserializedMessageContext<
            UserType, DragItemBinary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemBinary::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer data;
  
  bool is_image_accessible;
  
  ::blink::KURL source_url;
  
  ::base::FilePath filename_extension;
  
  ::blink::String content_disposition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemFileSystemFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemFileSystemFile, T>::value>;
  using DataView = DragItemFileSystemFileDataView;
  using Data_ = internal::DragItemFileSystemFile_Data;

  template <typename... Args>
  static DragItemFileSystemFilePtr New(Args&&... args) {
    return DragItemFileSystemFilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemFileSystemFilePtr From(const U& u) {
    return mojo::TypeConverter<DragItemFileSystemFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemFileSystemFile>::Convert(*this);
  }


  DragItemFileSystemFile();

  DragItemFileSystemFile(
      const ::blink::KURL& url,
      int64_t size,
      const ::blink::String& file_system_id,
      const ::scoped_refptr<::blink::BlobDataHandle>& serialized_blob);


  ~DragItemFileSystemFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemFileSystemFilePtr>
  DragItemFileSystemFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemFileSystemFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemFileSystemFile_UnserializedMessageContext<
            UserType, DragItemFileSystemFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragItemFileSystemFile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragItemFileSystemFile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemFileSystemFile_UnserializedMessageContext<
            UserType, DragItemFileSystemFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemFileSystemFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  int64_t size;
  
  ::blink::String file_system_id;
  
  ::scoped_refptr<::blink::BlobDataHandle> serialized_blob;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragData, T>::value>;
  using DataView = DragDataDataView;
  using Data_ = internal::DragData_Data;

  template <typename... Args>
  static DragDataPtr New(Args&&... args) {
    return DragDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragDataPtr From(const U& u) {
    return mojo::TypeConverter<DragDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragData>::Convert(*this);
  }


  DragData();

  DragData(
      ::blink::Vector<DragItemPtr> items,
      const ::blink::String& file_system_id,
      bool force_default_action,
      ::network::mojom::blink::ReferrerPolicy referrer_policy);

DragData(const DragData&) = delete;
DragData& operator=(const DragData&) = delete;

  ~DragData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragDataPtr>
  DragDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragData_UnserializedMessageContext<
            UserType, DragData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragData_UnserializedMessageContext<
            UserType, DragData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<DragItemPtr> items;
  
  ::blink::String file_system_id;
  
  bool force_default_action;
  
  ::network::mojom::blink::ReferrerPolicy referrer_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragEventSourceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragEventSourceInfo, T>::value>;
  using DataView = DragEventSourceInfoDataView;
  using Data_ = internal::DragEventSourceInfo_Data;

  template <typename... Args>
  static DragEventSourceInfoPtr New(Args&&... args) {
    return DragEventSourceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragEventSourceInfoPtr From(const U& u) {
    return mojo::TypeConverter<DragEventSourceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragEventSourceInfo>::Convert(*this);
  }


  DragEventSourceInfo();

  DragEventSourceInfo(
      const ::gfx::Point& location,
      ::ui::mojom::blink::DragEventSource source);


  ~DragEventSourceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragEventSourceInfoPtr>
  DragEventSourceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragEventSourceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragEventSourceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragEventSourceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragEventSourceInfo_UnserializedMessageContext<
            UserType, DragEventSourceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DragEventSourceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DragEventSourceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragEventSourceInfo_UnserializedMessageContext<
            UserType, DragEventSourceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragEventSourceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Point location;
  
  ::ui::mojom::blink::DragEventSource source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DragItemPtr DragItem::Clone() const {
  switch (tag_) {
    case Tag::kString:
      return NewString(
          mojo::Clone(data_.string));
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kBinary:
      return NewBinary(
          mojo::Clone(data_.binary));
    case Tag::kFileSystemFile:
      return NewFileSystemFile(
          mojo::Clone(data_.file_system_file));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DragItem>::value>::type*>
bool DragItem::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kString:
      return mojo::Equals(data_.string, other.data_.string);
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kBinary:
      return mojo::Equals(data_.binary, other.data_.binary);
    case Tag::kFileSystemFile:
      return mojo::Equals(data_.file_system_file, other.data_.file_system_file);
  }

  return false;
}
template <typename StructPtrType>
AllowedDragOperationsPtr AllowedDragOperations::Clone() const {
  return New(
      mojo::Clone(allow_copy),
      mojo::Clone(allow_link),
      mojo::Clone(allow_move)
  );
}

template <typename T, AllowedDragOperations::EnableIfSame<T>*>
bool AllowedDragOperations::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_copy, other_struct.allow_copy))
    return false;
  if (!mojo::Equals(this->allow_link, other_struct.allow_link))
    return false;
  if (!mojo::Equals(this->allow_move, other_struct.allow_move))
    return false;
  return true;
}

template <typename T, AllowedDragOperations::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_copy < rhs.allow_copy)
    return true;
  if (rhs.allow_copy < lhs.allow_copy)
    return false;
  if (lhs.allow_link < rhs.allow_link)
    return true;
  if (rhs.allow_link < lhs.allow_link)
    return false;
  if (lhs.allow_move < rhs.allow_move)
    return true;
  if (rhs.allow_move < lhs.allow_move)
    return false;
  return false;
}
template <typename StructPtrType>
DragItemStringPtr DragItemString::Clone() const {
  return New(
      mojo::Clone(string_type),
      mojo::Clone(string_data),
      mojo::Clone(title),
      mojo::Clone(base_url)
  );
}

template <typename T, DragItemString::EnableIfSame<T>*>
bool DragItemString::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->string_type, other_struct.string_type))
    return false;
  if (!mojo::Equals(this->string_data, other_struct.string_data))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->base_url, other_struct.base_url))
    return false;
  return true;
}

template <typename T, DragItemString::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.string_type < rhs.string_type)
    return true;
  if (rhs.string_type < lhs.string_type)
    return false;
  if (lhs.string_data < rhs.string_data)
    return true;
  if (rhs.string_data < lhs.string_data)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.base_url < rhs.base_url)
    return true;
  if (rhs.base_url < lhs.base_url)
    return false;
  return false;
}
template <typename StructPtrType>
DragItemBinaryPtr DragItemBinary::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(is_image_accessible),
      mojo::Clone(source_url),
      mojo::Clone(filename_extension),
      mojo::Clone(content_disposition)
  );
}

template <typename T, DragItemBinary::EnableIfSame<T>*>
bool DragItemBinary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->is_image_accessible, other_struct.is_image_accessible))
    return false;
  if (!mojo::Equals(this->source_url, other_struct.source_url))
    return false;
  if (!mojo::Equals(this->filename_extension, other_struct.filename_extension))
    return false;
  if (!mojo::Equals(this->content_disposition, other_struct.content_disposition))
    return false;
  return true;
}

template <typename T, DragItemBinary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.is_image_accessible < rhs.is_image_accessible)
    return true;
  if (rhs.is_image_accessible < lhs.is_image_accessible)
    return false;
  if (lhs.source_url < rhs.source_url)
    return true;
  if (rhs.source_url < lhs.source_url)
    return false;
  if (lhs.filename_extension < rhs.filename_extension)
    return true;
  if (rhs.filename_extension < lhs.filename_extension)
    return false;
  if (lhs.content_disposition < rhs.content_disposition)
    return true;
  if (rhs.content_disposition < lhs.content_disposition)
    return false;
  return false;
}
template <typename StructPtrType>
DragItemFileSystemFilePtr DragItemFileSystemFile::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(size),
      mojo::Clone(file_system_id),
      mojo::Clone(serialized_blob)
  );
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>*>
bool DragItemFileSystemFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->file_system_id, other_struct.file_system_id))
    return false;
  if (!mojo::Equals(this->serialized_blob, other_struct.serialized_blob))
    return false;
  return true;
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.file_system_id < rhs.file_system_id)
    return true;
  if (rhs.file_system_id < lhs.file_system_id)
    return false;
  if (lhs.serialized_blob < rhs.serialized_blob)
    return true;
  if (rhs.serialized_blob < lhs.serialized_blob)
    return false;
  return false;
}
template <typename StructPtrType>
DragDataPtr DragData::Clone() const {
  return New(
      mojo::Clone(items),
      mojo::Clone(file_system_id),
      mojo::Clone(force_default_action),
      mojo::Clone(referrer_policy)
  );
}

template <typename T, DragData::EnableIfSame<T>*>
bool DragData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  if (!mojo::Equals(this->file_system_id, other_struct.file_system_id))
    return false;
  if (!mojo::Equals(this->force_default_action, other_struct.force_default_action))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  return true;
}

template <typename T, DragData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  if (lhs.file_system_id < rhs.file_system_id)
    return true;
  if (rhs.file_system_id < lhs.file_system_id)
    return false;
  if (lhs.force_default_action < rhs.force_default_action)
    return true;
  if (rhs.force_default_action < lhs.force_default_action)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  return false;
}
template <typename StructPtrType>
DragEventSourceInfoPtr DragEventSourceInfo::Clone() const {
  return New(
      mojo::Clone(location),
      mojo::Clone(source)
  );
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>*>
bool DragEventSourceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AllowedDragOperations::DataView,
                                         ::blink::mojom::blink::AllowedDragOperationsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AllowedDragOperationsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AllowedDragOperationsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_copy) allow_copy(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_copy;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_link) allow_link(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_link;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_move) allow_move(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_move;
  }

  static bool Read(::blink::mojom::blink::AllowedDragOperations::DataView input, ::blink::mojom::blink::AllowedDragOperationsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemString::DataView,
                                         ::blink::mojom::blink::DragItemStringPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemStringPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemStringPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemString::string_type)& string_type(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->string_type;
  }

  static  decltype(::blink::mojom::blink::DragItemString::string_data)& string_data(
       ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->string_data;
  }

  static const decltype(::blink::mojom::blink::DragItemString::title)& title(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::blink::DragItemString::base_url)& base_url(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->base_url;
  }

  static bool Read(::blink::mojom::blink::DragItemString::DataView input, ::blink::mojom::blink::DragItemStringPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemBinary::DataView,
                                         ::blink::mojom::blink::DragItemBinaryPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemBinaryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemBinaryPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::DragItemBinary::data)& data(
       ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->data;
  }

  static decltype(::blink::mojom::blink::DragItemBinary::is_image_accessible) is_image_accessible(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->is_image_accessible;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::source_url)& source_url(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->source_url;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::filename_extension)& filename_extension(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->filename_extension;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::content_disposition)& content_disposition(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->content_disposition;
  }

  static bool Read(::blink::mojom::blink::DragItemBinary::DataView input, ::blink::mojom::blink::DragItemBinaryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemFileSystemFile::DataView,
                                         ::blink::mojom::blink::DragItemFileSystemFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemFileSystemFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemFileSystemFile::url)& url(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::DragItemFileSystemFile::size) size(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::blink::DragItemFileSystemFile::file_system_id)& file_system_id(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->file_system_id;
  }

  static  decltype(::blink::mojom::blink::DragItemFileSystemFile::serialized_blob)& serialized_blob(
       ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->serialized_blob;
  }

  static bool Read(::blink::mojom::blink::DragItemFileSystemFile::DataView input, ::blink::mojom::blink::DragItemFileSystemFilePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragData::DataView,
                                         ::blink::mojom::blink::DragDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragDataPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::DragData::items)& items(
       ::blink::mojom::blink::DragDataPtr& input) {
    return input->items;
  }

  static const decltype(::blink::mojom::blink::DragData::file_system_id)& file_system_id(
      const ::blink::mojom::blink::DragDataPtr& input) {
    return input->file_system_id;
  }

  static decltype(::blink::mojom::blink::DragData::force_default_action) force_default_action(
      const ::blink::mojom::blink::DragDataPtr& input) {
    return input->force_default_action;
  }

  static decltype(::blink::mojom::blink::DragData::referrer_policy) referrer_policy(
      const ::blink::mojom::blink::DragDataPtr& input) {
    return input->referrer_policy;
  }

  static bool Read(::blink::mojom::blink::DragData::DataView input, ::blink::mojom::blink::DragDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragEventSourceInfo::DataView,
                                         ::blink::mojom::blink::DragEventSourceInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragEventSourceInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragEventSourceInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragEventSourceInfo::location)& location(
      const ::blink::mojom::blink::DragEventSourceInfoPtr& input) {
    return input->location;
  }

  static decltype(::blink::mojom::blink::DragEventSourceInfo::source) source(
      const ::blink::mojom::blink::DragEventSourceInfoPtr& input) {
    return input->source;
  }

  static bool Read(::blink::mojom::blink::DragEventSourceInfo::DataView input, ::blink::mojom::blink::DragEventSourceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::DragItem::DataView,
                                        ::blink::mojom::blink::DragItemPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemPtr* output) { output->reset(); }

  static ::blink::mojom::blink::DragItem::Tag GetTag(const ::blink::mojom::blink::DragItemPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::DragItemStringPtr& string( ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_string();
  }

  static  ::blink::mojom::blink::DataTransferFilePtr& file( ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_file();
  }

  static  ::blink::mojom::blink::DragItemBinaryPtr& binary( ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_binary();
  }

  static  ::blink::mojom::blink::DragItemFileSystemFilePtr& file_system_file( ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_file_system_file();
  }

  static bool Read(::blink::mojom::blink::DragItem::DataView input, ::blink::mojom::blink::DragItemPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_BLINK_H_