// third_party/blink/public/mojom/dom_storage/storage_area.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT StorageAreaObserverInterceptorForTesting : public StorageAreaObserver {
  virtual StorageAreaObserver* GetForwardingInterface() = 0;
  void KeyChanged(const std::vector<uint8_t>& key, const std::vector<uint8_t>& new_value, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) override;
  void KeyChangeFailed(const std::vector<uint8_t>& key, const std::string& source) override;
  void KeyDeleted(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& old_value, const std::string& source) override;
  void AllDeleted(bool was_nonempty, const std::string& source) override;
  void ShouldSendOldValueOnMutations(bool value) override;
};
class BLINK_COMMON_EXPORT StorageAreaObserverAsyncWaiter {
 public:
  explicit StorageAreaObserverAsyncWaiter(StorageAreaObserver* proxy);

  StorageAreaObserverAsyncWaiter(const StorageAreaObserverAsyncWaiter&) = delete;
  StorageAreaObserverAsyncWaiter& operator=(const StorageAreaObserverAsyncWaiter&) = delete;

  ~StorageAreaObserverAsyncWaiter();

 private:
  StorageAreaObserver* const proxy_;
};


class BLINK_COMMON_EXPORT StorageAreaInterceptorForTesting : public StorageArea {
  virtual StorageArea* GetForwardingInterface() = 0;
  void AddObserver(::mojo::PendingRemote<StorageAreaObserver> observer) override;
  void Put(const std::vector<uint8_t>& key, const std::vector<uint8_t>& value, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, PutCallback callback) override;
  void Delete(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, DeleteCallback callback) override;
  void DeleteAll(const std::string& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, DeleteAllCallback callback) override;
  void Get(const std::vector<uint8_t>& key, GetCallback callback) override;
  void GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, GetAllCallback callback) override;
};
class BLINK_COMMON_EXPORT StorageAreaAsyncWaiter {
 public:
  explicit StorageAreaAsyncWaiter(StorageArea* proxy);

  StorageAreaAsyncWaiter(const StorageAreaAsyncWaiter&) = delete;
  StorageAreaAsyncWaiter& operator=(const StorageAreaAsyncWaiter&) = delete;

  ~StorageAreaAsyncWaiter();
  void Put(
      const std::vector<uint8_t>& key, const std::vector<uint8_t>& value, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, bool* out_success);
  bool Put(const std::vector<uint8_t>& key, const std::vector<uint8_t>& value, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source);
  void Delete(
      const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source, bool* out_success);
  bool Delete(const std::vector<uint8_t>& key, const std::optional<std::vector<uint8_t>>& client_old_value, const std::string& source);
  void DeleteAll(
      const std::string& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, bool* out_success);
  bool DeleteAll(const std::string& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer);
  void Get(
      const std::vector<uint8_t>& key, bool* out_success, std::vector<uint8_t>* out_value);
  
  void GetAll(
      ::mojo::PendingRemote<StorageAreaObserver> new_observer, std::vector<KeyValuePtr>* out_data);
  std::vector<KeyValuePtr> GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer);

 private:
  StorageArea* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_TEST_UTILS_H_