// third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-params-data.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
KeyValue::KeyValue()
    : key(),
      value() {}

KeyValue::KeyValue(
    ::blink::Vector<uint8_t> key_in,
    ::blink::Vector<uint8_t> value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

KeyValue::~KeyValue() = default;

void KeyValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

StorageAreaObserver::IPCStableHashFunction StorageAreaObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StorageAreaObserver>(message.name())) {
    case messages::StorageAreaObserver::kKeyChanged: {
      return &StorageAreaObserver::KeyChanged_Sym::IPCStableHash;
    }
    case messages::StorageAreaObserver::kKeyChangeFailed: {
      return &StorageAreaObserver::KeyChangeFailed_Sym::IPCStableHash;
    }
    case messages::StorageAreaObserver::kKeyDeleted: {
      return &StorageAreaObserver::KeyDeleted_Sym::IPCStableHash;
    }
    case messages::StorageAreaObserver::kAllDeleted: {
      return &StorageAreaObserver::AllDeleted_Sym::IPCStableHash;
    }
    case messages::StorageAreaObserver::kShouldSendOldValueOnMutations: {
      return &StorageAreaObserver::ShouldSendOldValueOnMutations_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StorageAreaObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StorageAreaObserver>(message.name())) {
      case messages::StorageAreaObserver::kKeyChanged:
            return "Receive blink::mojom::StorageAreaObserver::KeyChanged";
      case messages::StorageAreaObserver::kKeyChangeFailed:
            return "Receive blink::mojom::StorageAreaObserver::KeyChangeFailed";
      case messages::StorageAreaObserver::kKeyDeleted:
            return "Receive blink::mojom::StorageAreaObserver::KeyDeleted";
      case messages::StorageAreaObserver::kAllDeleted:
            return "Receive blink::mojom::StorageAreaObserver::AllDeleted";
      case messages::StorageAreaObserver::kShouldSendOldValueOnMutations:
            return "Receive blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations";
    }
  } else {
    switch (static_cast<messages::StorageAreaObserver>(message.name())) {
      case messages::StorageAreaObserver::kKeyChanged:
            return "Receive reply blink::mojom::StorageAreaObserver::KeyChanged";
      case messages::StorageAreaObserver::kKeyChangeFailed:
            return "Receive reply blink::mojom::StorageAreaObserver::KeyChangeFailed";
      case messages::StorageAreaObserver::kKeyDeleted:
            return "Receive reply blink::mojom::StorageAreaObserver::KeyDeleted";
      case messages::StorageAreaObserver::kAllDeleted:
            return "Receive reply blink::mojom::StorageAreaObserver::AllDeleted";
      case messages::StorageAreaObserver::kShouldSendOldValueOnMutations:
            return "Receive reply blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StorageAreaObserver::KeyChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49b18ec5;  // IPCStableHash for blink::mojom::StorageAreaObserver::KeyChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAreaObserver::KeyChangeFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23cd450f;  // IPCStableHash for blink::mojom::StorageAreaObserver::KeyChangeFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAreaObserver::KeyDeleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x090410cc;  // IPCStableHash for blink::mojom::StorageAreaObserver::KeyDeleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAreaObserver::AllDeleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed5febd0;  // IPCStableHash for blink::mojom::StorageAreaObserver::AllDeleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageAreaObserver::ShouldSendOldValueOnMutations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e3ff519;  // IPCStableHash for blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StorageAreaObserverProxy::StorageAreaObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAreaObserverProxy::KeyChanged(
    const ::blink::Vector<uint8_t>& in_key, const ::blink::Vector<uint8_t>& in_new_value, const std::optional<::blink::Vector<uint8_t>>& in_old_value, const ::blink::String& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAreaObserver::KeyChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_value"), in_new_value,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_value"), in_old_value,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAreaObserver::kKeyChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageAreaObserver.KeyChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_value)::BaseType>
      new_value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& new_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_new_value,
    new_value_fragment,
    &new_value_validate_params);

  params->new_value.Set(
      new_value_fragment.is_null() ? nullptr : new_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_value in StorageAreaObserver.KeyChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_value)::BaseType>
      old_value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& old_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_old_value,
    old_value_fragment,
    &old_value_validate_params);

  params->old_value.Set(
      old_value_fragment.is_null() ? nullptr : old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageAreaObserver.KeyChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAreaObserverProxy::KeyChangeFailed(
    const ::blink::Vector<uint8_t>& in_key, const ::blink::String& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAreaObserver::KeyChangeFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAreaObserver::kKeyChangeFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyChangeFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageAreaObserver.KeyChangeFailed request");
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageAreaObserver.KeyChangeFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyChangeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAreaObserverProxy::KeyDeleted(
    const ::blink::Vector<uint8_t>& in_key, const std::optional<::blink::Vector<uint8_t>>& in_old_value, const ::blink::String& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAreaObserver::KeyDeleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_value"), in_old_value,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAreaObserver::kKeyDeleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyDeleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageAreaObserver.KeyDeleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_value)::BaseType>
      old_value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& old_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_old_value,
    old_value_fragment,
    &old_value_validate_params);

  params->old_value.Set(
      old_value_fragment.is_null() ? nullptr : old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageAreaObserver.KeyDeleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAreaObserverProxy::AllDeleted(
    bool in_was_nonempty, const ::blink::String& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAreaObserver::AllDeleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_nonempty"), in_was_nonempty,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAreaObserver::kAllDeleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_AllDeleted_Params_Data> params(
          message);
  params.Allocate();

  params->was_nonempty = in_was_nonempty;
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageAreaObserver.AllDeleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("AllDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAreaObserverProxy::ShouldSendOldValueOnMutations(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageAreaObserver::kShouldSendOldValueOnMutations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("ShouldSendOldValueOnMutations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StorageAreaObserverStubDispatch::Accept(
    StorageAreaObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StorageAreaObserver>(message->header()->name)) {
    case messages::StorageAreaObserver::kKeyChanged: {
      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyChanged_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAreaObserver.0
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      ::blink::Vector<uint8_t> p_new_value{};
      std::optional<::blink::Vector<uint8_t>> p_old_value{};
      ::blink::String p_source{};
      StorageAreaObserver_KeyChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadNewValue(&p_new_value))
        success = false;
      if (success && !input_data_view.ReadOldValue(&p_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyChanged(        
        std::move(p_key), 
        std::move(p_new_value), 
        std::move(p_old_value), 
        std::move(p_source));
      return true;
    }
    case messages::StorageAreaObserver::kKeyChangeFailed: {
      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyChangeFailed_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyChangeFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAreaObserver.1
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      ::blink::String p_source{};
      StorageAreaObserver_KeyChangeFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyChangeFailed(        
        std::move(p_key), 
        std::move(p_source));
      return true;
    }
    case messages::StorageAreaObserver::kKeyDeleted: {
      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyDeleted_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyDeleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAreaObserver.2
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      std::optional<::blink::Vector<uint8_t>> p_old_value{};
      ::blink::String p_source{};
      StorageAreaObserver_KeyDeleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadOldValue(&p_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyDeleted(        
        std::move(p_key), 
        std::move(p_old_value), 
        std::move(p_source));
      return true;
    }
    case messages::StorageAreaObserver::kAllDeleted: {
      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_AllDeleted_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_AllDeleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAreaObserver.3
      bool success = true;
      bool p_was_nonempty{};
      ::blink::String p_source{};
      StorageAreaObserver_AllDeleted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_was_nonempty = input_data_view.was_nonempty();
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllDeleted(        
        std::move(p_was_nonempty), 
        std::move(p_source));
      return true;
    }
    case messages::StorageAreaObserver::kShouldSendOldValueOnMutations: {
      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageAreaObserver.4
      bool success = true;
      bool p_value{};
      StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldSendOldValueOnMutations(        
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool StorageAreaObserverStubDispatch::AcceptWithResponder(
    StorageAreaObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StorageAreaObserver>(message->header()->name)) {
    case messages::StorageAreaObserver::kKeyChanged: {
      break;
    }
    case messages::StorageAreaObserver::kKeyChangeFailed: {
      break;
    }
    case messages::StorageAreaObserver::kKeyDeleted: {
      break;
    }
    case messages::StorageAreaObserver::kAllDeleted: {
      break;
    }
    case messages::StorageAreaObserver::kShouldSendOldValueOnMutations: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStorageAreaObserverValidationInfo[] = {
    { &internal::StorageAreaObserver_KeyChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAreaObserver_KeyChangeFailed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAreaObserver_KeyDeleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAreaObserver_AllDeleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data::Validate,
     nullptr /* no response */},
};

bool StorageAreaObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::StorageAreaObserver::Name_,
    kStorageAreaObserverValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr uint32_t StorageArea::kPerStorageAreaQuota;
constexpr uint32_t StorageArea::kPerStorageAreaOverQuotaAllowance;

StorageArea::IPCStableHashFunction StorageArea::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StorageArea>(message.name())) {
    case messages::StorageArea::kAddObserver: {
      return &StorageArea::AddObserver_Sym::IPCStableHash;
    }
    case messages::StorageArea::kPut: {
      return &StorageArea::Put_Sym::IPCStableHash;
    }
    case messages::StorageArea::kDelete: {
      return &StorageArea::Delete_Sym::IPCStableHash;
    }
    case messages::StorageArea::kDeleteAll: {
      return &StorageArea::DeleteAll_Sym::IPCStableHash;
    }
    case messages::StorageArea::kGet: {
      return &StorageArea::Get_Sym::IPCStableHash;
    }
    case messages::StorageArea::kGetAll: {
      return &StorageArea::GetAll_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StorageArea::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StorageArea>(message.name())) {
      case messages::StorageArea::kAddObserver:
            return "Receive blink::mojom::StorageArea::AddObserver";
      case messages::StorageArea::kPut:
            return "Receive blink::mojom::StorageArea::Put";
      case messages::StorageArea::kDelete:
            return "Receive blink::mojom::StorageArea::Delete";
      case messages::StorageArea::kDeleteAll:
            return "Receive blink::mojom::StorageArea::DeleteAll";
      case messages::StorageArea::kGet:
            return "Receive blink::mojom::StorageArea::Get";
      case messages::StorageArea::kGetAll:
            return "Receive blink::mojom::StorageArea::GetAll";
    }
  } else {
    switch (static_cast<messages::StorageArea>(message.name())) {
      case messages::StorageArea::kAddObserver:
            return "Receive reply blink::mojom::StorageArea::AddObserver";
      case messages::StorageArea::kPut:
            return "Receive reply blink::mojom::StorageArea::Put";
      case messages::StorageArea::kDelete:
            return "Receive reply blink::mojom::StorageArea::Delete";
      case messages::StorageArea::kDeleteAll:
            return "Receive reply blink::mojom::StorageArea::DeleteAll";
      case messages::StorageArea::kGet:
            return "Receive reply blink::mojom::StorageArea::Get";
      case messages::StorageArea::kGetAll:
            return "Receive reply blink::mojom::StorageArea::GetAll";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StorageArea::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76daf671;  // IPCStableHash for blink::mojom::StorageArea::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageArea::Put_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2db3ea55;  // IPCStableHash for blink::mojom::StorageArea::Put
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageArea::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x910c7ee2;  // IPCStableHash for blink::mojom::StorageArea::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageArea::DeleteAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53807d96;  // IPCStableHash for blink::mojom::StorageArea::DeleteAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageArea::Get_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74c27953;  // IPCStableHash for blink::mojom::StorageArea::Get
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StorageArea::GetAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa130585;  // IPCStableHash for blink::mojom::StorageArea::GetAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool StorageArea::GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, ::blink::Vector<KeyValuePtr>* out_data) {
  NOTREACHED();
}

class StorageArea_Put_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Put_ForwardToCallback(
      StorageArea::PutCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageArea_Put_ForwardToCallback(const StorageArea_Put_ForwardToCallback&) = delete;
  StorageArea_Put_ForwardToCallback& operator=(const StorageArea_Put_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::PutCallback callback_;
};

class StorageArea_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Delete_ForwardToCallback(
      StorageArea::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageArea_Delete_ForwardToCallback(const StorageArea_Delete_ForwardToCallback&) = delete;
  StorageArea_Delete_ForwardToCallback& operator=(const StorageArea_Delete_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::DeleteCallback callback_;
};

class StorageArea_DeleteAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_DeleteAll_ForwardToCallback(
      StorageArea::DeleteAllCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageArea_DeleteAll_ForwardToCallback(const StorageArea_DeleteAll_ForwardToCallback&) = delete;
  StorageArea_DeleteAll_ForwardToCallback& operator=(const StorageArea_DeleteAll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::DeleteAllCallback callback_;
};

class StorageArea_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Get_ForwardToCallback(
      StorageArea::GetCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageArea_Get_ForwardToCallback(const StorageArea_Get_ForwardToCallback&) = delete;
  StorageArea_Get_ForwardToCallback& operator=(const StorageArea_Get_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::GetCallback callback_;
};
class StorageArea_GetAll_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  StorageArea_GetAll_HandleSyncResponse(
      bool* result, ::blink::Vector<KeyValuePtr>* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }

  StorageArea_GetAll_HandleSyncResponse(const StorageArea_GetAll_HandleSyncResponse&) = delete;
  StorageArea_GetAll_HandleSyncResponse& operator=(const StorageArea_GetAll_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<KeyValuePtr>* out_data_;};

class StorageArea_GetAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_GetAll_ForwardToCallback(
      StorageArea::GetAllCallback callback
      ) : callback_(std::move(callback)) {
  }

  StorageArea_GetAll_ForwardToCallback(const StorageArea_GetAll_ForwardToCallback&) = delete;
  StorageArea_GetAll_ForwardToCallback& operator=(const StorageArea_GetAll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::GetAllCallback callback_;
};

StorageAreaProxy::StorageAreaProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAreaProxy::AddObserver(
    ::mojo::PendingRemote<StorageAreaObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in StorageArea.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StorageAreaProxy::Put(
    const ::blink::Vector<uint8_t>& in_key, const ::blink::Vector<uint8_t>& in_value, const std::optional<::blink::Vector<uint8_t>>& in_client_old_value, const ::blink::String& in_source, PutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::Put", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_old_value"), in_client_old_value,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kPut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Put_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageArea.Put request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in StorageArea.Put request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_old_value)::BaseType>
      client_old_value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& client_old_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_client_old_value,
    client_old_value_fragment,
    &client_old_value_validate_params);

  params->client_old_value.Set(
      client_old_value_fragment.is_null() ? nullptr : client_old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageArea.Put request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Put");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Put_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StorageAreaProxy::Delete(
    const ::blink::Vector<uint8_t>& in_key, const std::optional<::blink::Vector<uint8_t>>& in_client_old_value, const ::blink::String& in_source, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_old_value"), in_client_old_value,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageArea.Delete request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_old_value)::BaseType>
      client_old_value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& client_old_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_client_old_value,
    client_old_value_fragment,
    &client_old_value_validate_params);

  params->client_old_value.Set(
      client_old_value_fragment.is_null() ? nullptr : client_old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageArea.Delete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Delete_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StorageAreaProxy::DeleteAll(
    const ::blink::String& in_source, ::mojo::PendingRemote<StorageAreaObserver> in_new_observer, DeleteAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::DeleteAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), in_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kDeleteAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_DeleteAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in StorageArea.DeleteAll request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
    in_new_observer,
    &params->new_observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("DeleteAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_DeleteAll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StorageAreaProxy::Get(
    const ::blink::Vector<uint8_t>& in_key, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::Get", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Get_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key,
    key_fragment,
    &key_validate_params);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in StorageArea.Get request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Get_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool StorageAreaProxy::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> param_new_observer, ::blink::Vector<KeyValuePtr>* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::StorageArea::GetAll (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), param_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#else
  TRACE_EVENT0("mojom", "StorageArea::GetAll");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kGetAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
    param_new_observer,
    &params->new_observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_GetAll_HandleSyncResponse(
          &result, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "StorageArea::GetAll", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type ::blink::Vector<KeyValuePtr>>");
   });
#endif
  return result;
}

void StorageAreaProxy::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> in_new_observer, GetAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::StorageArea::GetAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), in_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kGetAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
    in_new_observer,
    &params->new_observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_GetAll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class StorageArea_Put_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageArea::PutCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageArea_Put_ProxyToResponder> proxy(
        new StorageArea_Put_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageArea_Put_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Put_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageArea_Put_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageArea::PutCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool StorageArea_Put_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_Put_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Put_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageArea.1
  bool success = true;
  bool p_success{};
  StorageArea_Put_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void StorageArea_Put_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageArea::Put", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kPut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Put_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Put");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_Delete_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageArea::DeleteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageArea_Delete_ProxyToResponder> proxy(
        new StorageArea_Delete_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageArea_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageArea_Delete_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageArea::DeleteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool StorageArea_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageArea.2
  bool success = true;
  bool p_success{};
  StorageArea_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void StorageArea_Delete_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageArea::Delete", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_DeleteAll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageArea::DeleteAllCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageArea_DeleteAll_ProxyToResponder> proxy(
        new StorageArea_DeleteAll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageArea_DeleteAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_DeleteAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageArea_DeleteAll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageArea::DeleteAllCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool StorageArea_DeleteAll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_DeleteAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_DeleteAll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageArea.3
  bool success = true;
  bool p_success{};
  StorageArea_DeleteAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void StorageArea_DeleteAll_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageArea::DeleteAll", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kDeleteAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_DeleteAll_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("DeleteAll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_Get_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageArea::GetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageArea_Get_ProxyToResponder> proxy(
        new StorageArea_Get_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageArea_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageArea_Get_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageArea::GetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::Vector<uint8_t>& in_value);
};

bool StorageArea_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Get_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageArea.4
  bool success = true;
  bool p_success{};
  ::blink::Vector<uint8_t> p_value{};
  StorageArea_Get_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_value));
  }
  return true;
}

void StorageArea_Get_ProxyToResponder::Run(
    bool in_success, const ::blink::Vector<uint8_t>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageArea::Get", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Get_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_GetAll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StorageArea::GetAllCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StorageArea_GetAll_ProxyToResponder> proxy(
        new StorageArea_GetAll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StorageArea_GetAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_GetAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StorageArea_GetAll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "StorageArea::GetAllCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<KeyValuePtr> in_data);
};

bool StorageArea_GetAll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_GetAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_GetAll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for StorageArea.5
  bool success = true;
  ::blink::Vector<KeyValuePtr> p_data{};
  StorageArea_GetAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void StorageArea_GetAll_ProxyToResponder::Run(
    ::blink::Vector<KeyValuePtr> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::StorageArea::GetAll", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::blink::Vector<KeyValuePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StorageArea::kGetAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::KeyValueDataView>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool StorageArea_GetAll_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StorageArea_GetAll_ResponseParams_Data* params =
      reinterpret_cast<internal::StorageArea_GetAll_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for StorageArea.5
  bool success = true;
  ::blink::Vector<KeyValuePtr> p_data{};
  StorageArea_GetAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 5, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}

// static
bool StorageAreaStubDispatch::Accept(
    StorageArea* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StorageArea>(message->header()->name)) {
    case messages::StorageArea::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::StorageArea_AddObserver_Params_Data* params =
          reinterpret_cast<internal::StorageArea_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StorageArea.0
      bool success = true;
      ::mojo::PendingRemote<StorageAreaObserver> p_observer{};
      StorageArea_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::StorageArea::kPut: {
      break;
    }
    case messages::StorageArea::kDelete: {
      break;
    }
    case messages::StorageArea::kDeleteAll: {
      break;
    }
    case messages::StorageArea::kGet: {
      break;
    }
    case messages::StorageArea::kGetAll: {
      break;
    }
  }
  return false;
}

// static
bool StorageAreaStubDispatch::AcceptWithResponder(
    StorageArea* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StorageArea>(message->header()->name)) {
    case messages::StorageArea::kAddObserver: {
      break;
    }
    case messages::StorageArea::kPut: {
      internal::StorageArea_Put_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Put_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageArea.1
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      ::blink::Vector<uint8_t> p_value{};
      std::optional<::blink::Vector<uint8_t>> p_client_old_value{};
      ::blink::String p_source{};
      StorageArea_Put_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadClientOldValue(&p_client_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 1, false);
        return false;
      }
      auto callback =
          StorageArea_Put_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Put(        
        std::move(p_key), 
        std::move(p_value), 
        std::move(p_client_old_value), 
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::StorageArea::kDelete: {
      internal::StorageArea_Delete_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Delete_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageArea.2
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      std::optional<::blink::Vector<uint8_t>> p_client_old_value{};
      ::blink::String p_source{};
      StorageArea_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadClientOldValue(&p_client_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 2, false);
        return false;
      }
      auto callback =
          StorageArea_Delete_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        
        std::move(p_key), 
        std::move(p_client_old_value), 
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::StorageArea::kDeleteAll: {
      internal::StorageArea_DeleteAll_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_DeleteAll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageArea.3
      bool success = true;
      ::blink::String p_source{};
      ::mojo::PendingRemote<StorageAreaObserver> p_new_observer{};
      StorageArea_DeleteAll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_new_observer =
            input_data_view.TakeNewObserver<decltype(p_new_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 3, false);
        return false;
      }
      auto callback =
          StorageArea_DeleteAll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAll(        
        std::move(p_source), 
        std::move(p_new_observer), std::move(callback));
      return true;
    }
    case messages::StorageArea::kGet: {
      internal::StorageArea_Get_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Get_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageArea.4
      bool success = true;
      ::blink::Vector<uint8_t> p_key{};
      StorageArea_Get_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 4, false);
        return false;
      }
      auto callback =
          StorageArea_Get_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::StorageArea::kGetAll: {
      internal::StorageArea_GetAll_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_GetAll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for StorageArea.5
      bool success = true;
      ::mojo::PendingRemote<StorageAreaObserver> p_new_observer{};
      StorageArea_GetAll_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_new_observer =
            input_data_view.TakeNewObserver<decltype(p_new_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 5, false);
        return false;
      }
      auto callback =
          StorageArea_GetAll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAll(        
        std::move(p_new_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStorageAreaValidationInfo[] = {
    { &internal::StorageArea_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StorageArea_Put_Params_Data::Validate,
     &internal::StorageArea_Put_ResponseParams_Data::Validate},
    { &internal::StorageArea_Delete_Params_Data::Validate,
     &internal::StorageArea_Delete_ResponseParams_Data::Validate},
    { &internal::StorageArea_DeleteAll_Params_Data::Validate,
     &internal::StorageArea_DeleteAll_ResponseParams_Data::Validate},
    { &internal::StorageArea_Get_Params_Data::Validate,
     &internal::StorageArea_Get_ResponseParams_Data::Validate},
    { &internal::StorageArea_GetAll_Params_Data::Validate,
     &internal::StorageArea_GetAll_ResponseParams_Data::Validate},
};

bool StorageAreaRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::StorageArea::Name_,
    kStorageAreaValidationInfo);
}

bool StorageAreaResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::StorageArea::Name_,
    kStorageAreaValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::KeyValue::DataView, ::blink::mojom::blink::KeyValuePtr>::Read(
    ::blink::mojom::blink::KeyValue::DataView input,
    ::blink::mojom::blink::KeyValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::KeyValuePtr result(::blink::mojom::blink::KeyValue::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void StorageAreaObserverInterceptorForTesting::KeyChanged(const ::blink::Vector<uint8_t>& key, const ::blink::Vector<uint8_t>& new_value, const std::optional<::blink::Vector<uint8_t>>& old_value, const ::blink::String& source) {
  GetForwardingInterface()->KeyChanged(
    std::move(key)
    , 
    std::move(new_value)
    , 
    std::move(old_value)
    , 
    std::move(source)
    );
}
void StorageAreaObserverInterceptorForTesting::KeyChangeFailed(const ::blink::Vector<uint8_t>& key, const ::blink::String& source) {
  GetForwardingInterface()->KeyChangeFailed(
    std::move(key)
    , 
    std::move(source)
    );
}
void StorageAreaObserverInterceptorForTesting::KeyDeleted(const ::blink::Vector<uint8_t>& key, const std::optional<::blink::Vector<uint8_t>>& old_value, const ::blink::String& source) {
  GetForwardingInterface()->KeyDeleted(
    std::move(key)
    , 
    std::move(old_value)
    , 
    std::move(source)
    );
}
void StorageAreaObserverInterceptorForTesting::AllDeleted(bool was_nonempty, const ::blink::String& source) {
  GetForwardingInterface()->AllDeleted(
    std::move(was_nonempty)
    , 
    std::move(source)
    );
}
void StorageAreaObserverInterceptorForTesting::ShouldSendOldValueOnMutations(bool value) {
  GetForwardingInterface()->ShouldSendOldValueOnMutations(
    std::move(value)
    );
}
StorageAreaObserverAsyncWaiter::StorageAreaObserverAsyncWaiter(
    StorageAreaObserver* proxy) : proxy_(proxy) {}

StorageAreaObserverAsyncWaiter::~StorageAreaObserverAsyncWaiter() = default;





void StorageAreaInterceptorForTesting::AddObserver(::mojo::PendingRemote<StorageAreaObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void StorageAreaInterceptorForTesting::Put(const ::blink::Vector<uint8_t>& key, const ::blink::Vector<uint8_t>& value, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source, PutCallback callback) {
  GetForwardingInterface()->Put(
    std::move(key)
    , 
    std::move(value)
    , 
    std::move(client_old_value)
    , 
    std::move(source)
    , std::move(callback));
}
void StorageAreaInterceptorForTesting::Delete(const ::blink::Vector<uint8_t>& key, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source, DeleteCallback callback) {
  GetForwardingInterface()->Delete(
    std::move(key)
    , 
    std::move(client_old_value)
    , 
    std::move(source)
    , std::move(callback));
}
void StorageAreaInterceptorForTesting::DeleteAll(const ::blink::String& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, DeleteAllCallback callback) {
  GetForwardingInterface()->DeleteAll(
    std::move(source)
    , 
    std::move(new_observer)
    , std::move(callback));
}
void StorageAreaInterceptorForTesting::Get(const ::blink::Vector<uint8_t>& key, GetCallback callback) {
  GetForwardingInterface()->Get(
    std::move(key)
    , std::move(callback));
}
void StorageAreaInterceptorForTesting::GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, GetAllCallback callback) {
  GetForwardingInterface()->GetAll(
    std::move(new_observer)
    , std::move(callback));
}
StorageAreaAsyncWaiter::StorageAreaAsyncWaiter(
    StorageArea* proxy) : proxy_(proxy) {}

StorageAreaAsyncWaiter::~StorageAreaAsyncWaiter() = default;


void StorageAreaAsyncWaiter::Put(
    const ::blink::Vector<uint8_t>& key, const ::blink::Vector<uint8_t>& value, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source, bool* out_success) {
  base::RunLoop loop;
  proxy_->Put(
      std::move(key),
      std::move(value),
      std::move(client_old_value),
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool StorageAreaAsyncWaiter::Put(
    const ::blink::Vector<uint8_t>& key, const ::blink::Vector<uint8_t>& value, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source) {
  bool async_wait_result;
  Put(std::move(key),std::move(value),std::move(client_old_value),std::move(source),&async_wait_result);
  return async_wait_result;
}

void StorageAreaAsyncWaiter::Delete(
    const ::blink::Vector<uint8_t>& key, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source, bool* out_success) {
  base::RunLoop loop;
  proxy_->Delete(
      std::move(key),
      std::move(client_old_value),
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool StorageAreaAsyncWaiter::Delete(
    const ::blink::Vector<uint8_t>& key, const std::optional<::blink::Vector<uint8_t>>& client_old_value, const ::blink::String& source) {
  bool async_wait_result;
  Delete(std::move(key),std::move(client_old_value),std::move(source),&async_wait_result);
  return async_wait_result;
}

void StorageAreaAsyncWaiter::DeleteAll(
    const ::blink::String& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteAll(
      std::move(source),
      std::move(new_observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool StorageAreaAsyncWaiter::DeleteAll(
    const ::blink::String& source, ::mojo::PendingRemote<StorageAreaObserver> new_observer) {
  bool async_wait_result;
  DeleteAll(std::move(source),std::move(new_observer),&async_wait_result);
  return async_wait_result;
}

void StorageAreaAsyncWaiter::Get(
    const ::blink::Vector<uint8_t>& key, bool* out_success, ::blink::Vector<uint8_t>* out_value) {
  base::RunLoop loop;
  proxy_->Get(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::Vector<uint8_t>* out_value
,
             bool success,
             const ::blink::Vector<uint8_t>& value) {*out_success = std::move(success);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_success,
          out_value));
  loop.Run();
}



void StorageAreaAsyncWaiter::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> new_observer, ::blink::Vector<KeyValuePtr>* out_data) {
  base::RunLoop loop;
  proxy_->GetAll(
      std::move(new_observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<KeyValuePtr>* out_data
,
             ::blink::Vector<KeyValuePtr> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

::blink::Vector<KeyValuePtr> StorageAreaAsyncWaiter::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> new_observer) {
  ::blink::Vector<KeyValuePtr> async_wait_result;
  GetAll(std::move(new_observer),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif