// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"


namespace blink::mojom {
class DirectTCPSocketOptionsDataView;

class DirectConnectedUDPSocketOptionsDataView;

class DirectBoundUDPSocketOptionsDataView;

class DirectTCPServerSocketOptionsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DirectTCPSocketOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectTCPSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectConnectedUDPSocketOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectConnectedUDPSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectBoundUDPSocketOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectBoundUDPSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DirectTCPServerSocketOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectTCPServerSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class DirectSocketsServiceInterfaceBase {};

using DirectSocketsServicePtrDataView =
    mojo::InterfacePtrDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceRequestDataView =
    mojo::InterfaceRequestDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectSocketsServiceInterfaceBase>;


class DirectTCPSocketOptionsDataView {
 public:
  DirectTCPSocketOptionsDataView() = default;

  DirectTCPSocketOptionsDataView(
      internal::DirectTCPSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRemoteAddrDataView(
      ::network::mojom::HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteAddr(UserType* output) {
    
    auto* pointer = data_->remote_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> send_buffer_size() const {

    return data_->send_buffer_size_$flag
        ? std::make_optional(data_->send_buffer_size_$value)
        : std::nullopt;
  }
  std::optional<int32_t> receive_buffer_size() const {

    return data_->receive_buffer_size_$flag
        ? std::make_optional(data_->receive_buffer_size_$value)
        : std::nullopt;
  }
  bool no_delay() const {
    return data_->no_delay;
  }
  inline void GetKeepAliveOptionsDataView(
      ::network::mojom::TCPKeepAliveOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeepAliveOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TCPKeepAliveOptionsDataView, UserType>(),
    "Attempting to read the optional `keep_alive_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeepAliveOptions` instead "
    "of `ReadKeepAliveOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keep_alive_options.Get();
    return mojo::internal::Deserialize<::network::mojom::TCPKeepAliveOptionsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDnsQueryType(UserType* output) const {
    if (!data_->dns_query_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_->dns_query_type_$value, &output->emplace());
  }
  std::optional<::network::mojom::DnsQueryType> dns_query_type() const {
    if (!data_->dns_query_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->dns_query_type_$value));
  }
 private:
  internal::DirectTCPSocketOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectConnectedUDPSocketOptionsDataView {
 public:
  DirectConnectedUDPSocketOptionsDataView() = default;

  DirectConnectedUDPSocketOptionsDataView(
      internal::DirectConnectedUDPSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRemoteAddrDataView(
      ::network::mojom::HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteAddr(UserType* output) {
    
    auto* pointer = data_->remote_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> send_buffer_size() const {

    return data_->send_buffer_size_$flag
        ? std::make_optional(data_->send_buffer_size_$value)
        : std::nullopt;
  }
  std::optional<int32_t> receive_buffer_size() const {

    return data_->receive_buffer_size_$flag
        ? std::make_optional(data_->receive_buffer_size_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDnsQueryType(UserType* output) const {
    if (!data_->dns_query_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_->dns_query_type_$value, &output->emplace());
  }
  std::optional<::network::mojom::DnsQueryType> dns_query_type() const {
    if (!data_->dns_query_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->dns_query_type_$value));
  }
  std::optional<uint8_t> multicast_time_to_live() const {

    return data_->multicast_time_to_live_$flag
        ? std::make_optional(data_->multicast_time_to_live_$value)
        : std::nullopt;
  }
  std::optional<bool> multicast_loopback() const {

    return data_->multicast_loopback_$flag
        ? std::make_optional(!!data_->multicast_loopback_$value)
        : std::nullopt;
  }
 private:
  internal::DirectConnectedUDPSocketOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectBoundUDPSocketOptionsDataView {
 public:
  DirectBoundUDPSocketOptionsDataView() = default;

  DirectBoundUDPSocketOptionsDataView(
      internal::DirectBoundUDPSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalAddrDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalAddr(UserType* output) {
    
    auto* pointer = data_->local_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> send_buffer_size() const {

    return data_->send_buffer_size_$flag
        ? std::make_optional(data_->send_buffer_size_$value)
        : std::nullopt;
  }
  std::optional<int32_t> receive_buffer_size() const {

    return data_->receive_buffer_size_$flag
        ? std::make_optional(data_->receive_buffer_size_$value)
        : std::nullopt;
  }
  std::optional<bool> ipv6_only() const {

    return data_->ipv6_only_$flag
        ? std::make_optional(!!data_->ipv6_only_$value)
        : std::nullopt;
  }
  std::optional<bool> multicast_allow_address_sharing() const {

    return data_->multicast_allow_address_sharing_$flag
        ? std::make_optional(!!data_->multicast_allow_address_sharing_$value)
        : std::nullopt;
  }
  std::optional<uint8_t> multicast_time_to_live() const {

    return data_->multicast_time_to_live_$flag
        ? std::make_optional(data_->multicast_time_to_live_$value)
        : std::nullopt;
  }
  std::optional<bool> multicast_loopback() const {

    return data_->multicast_loopback_$flag
        ? std::make_optional(!!data_->multicast_loopback_$value)
        : std::nullopt;
  }
 private:
  internal::DirectBoundUDPSocketOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DirectTCPServerSocketOptionsDataView {
 public:
  DirectTCPServerSocketOptionsDataView() = default;

  DirectTCPServerSocketOptionsDataView(
      internal::DirectTCPServerSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalAddrDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalAddr(UserType* output) {
    
    auto* pointer = data_->local_addr.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  std::optional<bool> ipv6_only() const {

    return data_->ipv6_only_$flag
        ? std::make_optional(!!data_->ipv6_only_$value)
        : std::nullopt;
  }
  std::optional<uint32_t> backlog() const {

    return data_->backlog_$flag
        ? std::make_optional(data_->backlog_$value)
        : std::nullopt;
  }
 private:
  internal::DirectTCPServerSocketOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_DATA_VIEW_H_