// third_party/blink/public/mojom/devtools/inspector_issue.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');

goog.require('network.mojom.BlockedByResponseReason');
goog.require('blink.mojom.RequestContextType');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.InspectorIssueCode');
goog.provide('blink.mojom.InspectorIssueCodeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.InspectorIssueCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.InspectorIssueCode = {
  
  kCookieIssue: 0,
  kMixedContentIssue: 1,
  kBlockedByResponseIssue: 2,
  kContentSecurityPolicyIssue: 3,
  kSharedArrayBufferIssue: 4,
  kHeavyAdIssue: 5,
  kAttributionReportingIssue: 6,
  kLowTextContrastIssue: 7,
  kFederatedAuthRequestIssue: 8,
  kBounceTrackingIssue: 9,
  kCookieDeprecationMetadataIssue: 10,
  kGenericIssue: 11,
  kDeprecationIssue: 12,
  kFederatedAuthUserInfoRequestIssue: 13,
  kPartitioningBlobURLIssue: 14,
  kUserReidentificationIssue: 15,
  MIN_VALUE: 0,
  MAX_VALUE: 15,
};

goog.provide('blink.mojom.HeavyAdResolutionStatus');
goog.provide('blink.mojom.HeavyAdResolutionStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.HeavyAdResolutionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.HeavyAdResolutionStatus = {
  
  kHeavyAdBlocked: 0,
  kHeavyAdWarning: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.HeavyAdReason');
goog.provide('blink.mojom.HeavyAdReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.HeavyAdReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.HeavyAdReason = {
  
  kNetworkTotalLimit: 0,
  kCpuTotalLimit: 1,
  kCpuPeakLimit: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.AttributionReportingIssueType');
goog.provide('blink.mojom.AttributionReportingIssueTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AttributionReportingIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AttributionReportingIssueType = {
  
  kPermissionPolicyDisabled: 0,
  kUntrustworthyReportingOrigin: 1,
  kInsecureContext: 2,
  kInvalidRegisterSourceHeader: 3,
  kInvalidRegisterTriggerHeader: 4,
  kSourceAndTriggerHeaders: 5,
  kSourceIgnored: 6,
  kTriggerIgnored: 7,
  kOsSourceIgnored: 8,
  kOsTriggerIgnored: 9,
  kInvalidRegisterOsSourceHeader: 10,
  kInvalidRegisterOsTriggerHeader: 11,
  kWebAndOsHeaders: 12,
  kNoWebOrOsSupport: 13,
  kNavigationRegistrationWithoutTransientUserActivation: 14,
  kInvalidInfoHeader: 15,
  kNoRegisterSourceHeader: 16,
  kNoRegisterTriggerHeader: 17,
  kNoRegisterOsSourceHeader: 18,
  kNoRegisterOsTriggerHeader: 19,
  kNavigationRegistrationUniqueScopeAlreadySet: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};

goog.provide('blink.mojom.MixedContentResolutionStatus');
goog.provide('blink.mojom.MixedContentResolutionStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MixedContentResolutionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MixedContentResolutionStatus = {
  
  kMixedContentBlocked: 0,
  kMixedContentAutomaticallyUpgraded: 1,
  kMixedContentWarning: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.ContentSecurityPolicyViolationType');
goog.provide('blink.mojom.ContentSecurityPolicyViolationTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ContentSecurityPolicyViolationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ContentSecurityPolicyViolationType = {
  
  kInlineViolation: 0,
  kEvalViolation: 1,
  kURLViolation: 2,
  kSRIViolation: 3,
  kTrustedTypesSinkViolation: 4,
  kTrustedTypesPolicyViolation: 5,
  kWasmEvalViolation: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

goog.provide('blink.mojom.CookieOperation');
goog.provide('blink.mojom.CookieOperationSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CookieOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CookieOperation = {
  
  kSetCookie: 0,
  kReadCookie: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.CookieExclusionReason');
goog.provide('blink.mojom.CookieExclusionReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CookieExclusionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CookieExclusionReason = {
  
  kExcludeSameSiteUnspecifiedTreatedAsLax: 0,
  kExcludeSameSiteNoneInsecure: 1,
  kExcludeSameSiteLax: 2,
  kExcludeSameSiteStrict: 3,
  kExcludeDomainNonASCII: 4,
  kExcludeThirdPartyPhaseout: 5,
  kExcludePortMismatch: 6,
  kExcludeSchemeMismatch: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('blink.mojom.CookieWarningReason');
goog.provide('blink.mojom.CookieWarningReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CookieWarningReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CookieWarningReason = {
  
  kWarnSameSiteUnspecifiedCrossSiteContext: 0,
  kWarnSameSiteNoneInsecure: 1,
  kWarnSameSiteUnspecifiedLaxAllowUnsafe: 2,
  kWarnSameSiteStrictLaxDowngradeStrict: 3,
  kWarnSameSiteStrictCrossDowngradeStrict: 4,
  kWarnSameSiteStrictCrossDowngradeLax: 5,
  kWarnSameSiteLaxCrossDowngradeStrict: 6,
  kWarnSameSiteLaxCrossDowngradeLax: 7,
  kWarnAttributeValueExceedsMaxSize: 8,
  kWarnDomainNonASCII: 9,
  kWarnThirdPartyPhaseout: 10,
  kWarnCrossSiteRedirectDowngradeChangesInclusion: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

goog.provide('blink.mojom.SharedArrayBufferIssueType');
goog.provide('blink.mojom.SharedArrayBufferIssueTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SharedArrayBufferIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SharedArrayBufferIssueType = {
  
  kTransferIssue: 0,
  kCreationIssue: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.FederatedAuthRequestResult');
goog.provide('blink.mojom.FederatedAuthRequestResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FederatedAuthRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FederatedAuthRequestResult = {
  
  kSuccess: 0,
  kShouldEmbargo: 1,
  kIdpNotPotentiallyTrustworthy: 2,
  kDisabledInSettings: 3,
  kDisabledInFlags: 4,
  kTooManyRequests: 5,
  kWellKnownHttpNotFound: 6,
  kWellKnownNoResponse: 7,
  kWellKnownInvalidResponse: 8,
  kWellKnownListEmpty: 9,
  kWellKnownInvalidContentType: 10,
  kConfigNotInWellKnown: 11,
  kWellKnownTooBig: 12,
  kConfigHttpNotFound: 13,
  kConfigNoResponse: 14,
  kConfigInvalidResponse: 15,
  kConfigInvalidContentType: 16,
  kClientMetadataHttpNotFound: 17,
  kClientMetadataNoResponse: 18,
  kClientMetadataInvalidResponse: 19,
  kClientMetadataInvalidContentType: 20,
  kAccountsHttpNotFound: 21,
  kAccountsNoResponse: 22,
  kAccountsInvalidResponse: 23,
  kAccountsListEmpty: 24,
  kAccountsInvalidContentType: 25,
  kIdTokenHttpNotFound: 26,
  kIdTokenNoResponse: 27,
  kIdTokenInvalidResponse: 28,
  kIdTokenIdpErrorResponse: 29,
  kIdTokenCrossSiteIdpErrorResponse: 30,
  kIdTokenInvalidContentType: 31,
  kCanceled: 32,
  kRpPageNotVisible: 33,
  kSilentMediationFailure: 34,
  kThirdPartyCookiesBlocked: 35,
  kNotSignedInWithIdp: 36,
  kMissingTransientUserActivation: 37,
  kReplacedByActiveMode: 38,
  kInvalidFieldsSpecified: 39,
  kRelyingPartyOriginIsOpaque: 40,
  kTypeNotMatching: 41,
  kError: 42,
  kUiDismissedNoEmbargo: 43,
  kCorsError: 44,
  kSuppressedBySegmentationPlatform: 45,
  MIN_VALUE: 0,
  MAX_VALUE: 45,
};

goog.provide('blink.mojom.FederatedAuthUserInfoRequestResult');
goog.provide('blink.mojom.FederatedAuthUserInfoRequestResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FederatedAuthUserInfoRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FederatedAuthUserInfoRequestResult = {
  
  kSuccess: 0,
  kNotSameOrigin: 1,
  kNotIframe: 2,
  kNotPotentiallyTrustworthy: 3,
  kNoApiPermission: 4,
  kNotSignedInWithIdp: 5,
  kNoAccountSharingPermission: 6,
  kInvalidConfigOrWellKnown: 7,
  kInvalidAccountsResponse: 8,
  kNoReturningUserFromFetchedAccounts: 9,
  kUnhandledRequest: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

goog.provide('blink.mojom.PartitioningBlobURLInfo');
goog.provide('blink.mojom.PartitioningBlobURLInfoSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PartitioningBlobURLInfoSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PartitioningBlobURLInfo = {
  
  kBlockedCrossPartitionFetching: 0,
  kEnforceNoopenerForNavigation: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.GenericIssueErrorType');
goog.provide('blink.mojom.GenericIssueErrorTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GenericIssueErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.GenericIssueErrorType = {
  
  kFormLabelForNameError: 0,
  kFormDuplicateIdForInputError: 1,
  kFormInputWithNoLabelError: 2,
  kFormAutocompleteAttributeEmptyError: 3,
  kFormEmptyIdAndNameAttributesForInputError: 4,
  kFormAriaLabelledByToNonExistingId: 5,
  kFormInputAssignedAutocompleteValueToIdOrNameAttributeError: 6,
  kFormLabelHasNeitherForNorNestedInput: 7,
  kFormLabelForMatchesNonExistingIdError: 8,
  kFormInputHasWrongButWellIntendedAutocompleteValueError: 9,
  kResponseWasBlockedByORB: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

goog.provide('blink.mojom.DeprecationIssueType');
goog.provide('blink.mojom.DeprecationIssueTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DeprecationIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DeprecationIssueType = {
  
  kPrivacySandboxExtensionsAPI: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

goog.provide('blink.mojom.UserReidentificationIssueType');
goog.provide('blink.mojom.UserReidentificationIssueTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.UserReidentificationIssueTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.UserReidentificationIssueType = {
  
  kBlockedFrameNavigation: 0,
  kBlockedSubresource: 1,
  kNoisedCanvasReadback: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.AffectedCookieSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AffectedCookieSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AffectedRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AffectedRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AffectedFrameSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AffectedFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AffectedLocationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AffectedLocationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.BlockedByResponseIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BlockedByResponseIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.HeavyAdIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.HeavyAdIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AttributionReportingIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AttributionReportingIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MixedContentIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MixedContentIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentSecurityPolicyIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentSecurityPolicyIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CookieIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SharedArrayBufferIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedArrayBufferIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.LowTextContrastIssueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LowTextContrastIssueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FederatedAuthRequestIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthRequestIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FederatedAuthUserInfoRequestIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FederatedAuthUserInfoRequestIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.BounceTrackingIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BounceTrackingIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PartitioningBlobURLIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PartitioningBlobURLIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CookieDeprecationMetadataIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieDeprecationMetadataIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.GenericIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GenericIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeprecationIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeprecationIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.UserReidentificationIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.UserReidentificationIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.InspectorIssueDetailsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InspectorIssueDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.InspectorIssueInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.InspectorIssueInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AffectedCookieSpec.$,
    'AffectedCookie',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domain', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AffectedCookie');

/** @record */
blink.mojom.AffectedCookie = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.path;
    /** @export { !string } */
    this.domain;
  }
};



mojo.internal.Struct(
    blink.mojom.AffectedRequestSpec.$,
    'AffectedRequest',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AffectedRequest');

/** @record */
blink.mojom.AffectedRequest = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.requestId;
    /** @export { !string } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.AffectedFrameSpec.$,
    'AffectedFrame',
    [
      mojo.internal.StructField(
        'frameId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AffectedFrame');

/** @record */
blink.mojom.AffectedFrame = class {
  constructor() {
    /** @export { !string } */
    this.frameId;
  }
};



mojo.internal.Struct(
    blink.mojom.AffectedLocationSpec.$,
    'AffectedLocation',
    [
      mojo.internal.StructField(
        'scriptId', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'line', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'column', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AffectedLocation');

/** @record */
blink.mojom.AffectedLocation = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.scriptId;
    /** @export { (string|undefined) } */
    this.url;
    /** @export { !number } */
    this.line;
    /** @export { !number } */
    this.column;
  }
};



mojo.internal.Struct(
    blink.mojom.BlockedByResponseIssueDetailsSpec.$,
    'BlockedByResponseIssueDetails',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.AffectedRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parentFrame', 8,
        0,
        blink.mojom.AffectedFrameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockedFrame', 16,
        0,
        blink.mojom.AffectedFrameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 24,
        0,
        network.mojom.BlockedByResponseReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.BlockedByResponseIssueDetails');

/** @record */
blink.mojom.BlockedByResponseIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.AffectedRequest } */
    this.request;
    /** @export { (blink.mojom.AffectedFrame|undefined) } */
    this.parentFrame;
    /** @export { (blink.mojom.AffectedFrame|undefined) } */
    this.blockedFrame;
    /** @export { !network.mojom.BlockedByResponseReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.HeavyAdIssueDetailsSpec.$,
    'HeavyAdIssueDetails',
    [
      mojo.internal.StructField(
        'resolution', 0,
        0,
        blink.mojom.HeavyAdResolutionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        blink.mojom.HeavyAdReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frame', 8,
        0,
        blink.mojom.AffectedFrameSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.HeavyAdIssueDetails');

/** @record */
blink.mojom.HeavyAdIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.HeavyAdResolutionStatus } */
    this.resolution;
    /** @export { !blink.mojom.HeavyAdReason } */
    this.reason;
    /** @export { !blink.mojom.AffectedFrame } */
    this.frame;
  }
};



mojo.internal.Struct(
    blink.mojom.AttributionReportingIssueDetailsSpec.$,
    'AttributionReportingIssueDetails',
    [
      mojo.internal.StructField(
        'violationType', 0,
        0,
        blink.mojom.AttributionReportingIssueTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        blink.mojom.AffectedRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'invalidParameter', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AttributionReportingIssueDetails');

/** @record */
blink.mojom.AttributionReportingIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.AttributionReportingIssueType } */
    this.violationType;
    /** @export { (blink.mojom.AffectedRequest|undefined) } */
    this.request;
    /** @export { (string|undefined) } */
    this.invalidParameter;
  }
};



mojo.internal.Struct(
    blink.mojom.MixedContentIssueDetailsSpec.$,
    'MixedContentIssueDetails',
    [
      mojo.internal.StructField(
        'requestContext', 0,
        0,
        blink.mojom.RequestContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolutionStatus', 4,
        0,
        blink.mojom.MixedContentResolutionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'insecureUrl', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainResourceUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 24,
        0,
        blink.mojom.AffectedRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frame', 32,
        0,
        blink.mojom.AffectedFrameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.MixedContentIssueDetails');

/** @record */
blink.mojom.MixedContentIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.RequestContextType } */
    this.requestContext;
    /** @export { !blink.mojom.MixedContentResolutionStatus } */
    this.resolutionStatus;
    /** @export { !string } */
    this.insecureUrl;
    /** @export { !string } */
    this.mainResourceUrl;
    /** @export { (blink.mojom.AffectedRequest|undefined) } */
    this.request;
    /** @export { (blink.mojom.AffectedFrame|undefined) } */
    this.frame;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentSecurityPolicyIssueDetailsSpec.$,
    'ContentSecurityPolicyIssueDetails',
    [
      mojo.internal.StructField(
        'blockedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'violatedDirective', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isReportOnly', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentSecurityPolicyViolationType', 20,
        0,
        blink.mojom.ContentSecurityPolicyViolationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameAncestor', 24,
        0,
        blink.mojom.AffectedFrameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'affectedLocation', 32,
        0,
        blink.mojom.AffectedLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'violatingNodeId', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ContentSecurityPolicyIssueDetails');

/** @record */
blink.mojom.ContentSecurityPolicyIssueDetails = class {
  constructor() {
    /** @export { (url.mojom.Url|undefined) } */
    this.blockedUrl;
    /** @export { !string } */
    this.violatedDirective;
    /** @export { !boolean } */
    this.isReportOnly;
    /** @export { !blink.mojom.ContentSecurityPolicyViolationType } */
    this.contentSecurityPolicyViolationType;
    /** @export { (blink.mojom.AffectedFrame|undefined) } */
    this.frameAncestor;
    /** @export { (blink.mojom.AffectedLocation|undefined) } */
    this.affectedLocation;
    /** @export { !number } */
    this.violatingNodeId;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieIssueDetailsSpec.$,
    'CookieIssueDetails',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        blink.mojom.AffectedCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exclusionReason', 8,
        0,
        mojo.internal.Array(blink.mojom.CookieExclusionReasonSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'warningReason', 16,
        0,
        mojo.internal.Array(blink.mojom.CookieWarningReasonSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operation', 24,
        0,
        blink.mojom.CookieOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieUrl', 40,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 48,
        0,
        blink.mojom.AffectedRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.CookieIssueDetails');

/** @record */
blink.mojom.CookieIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.AffectedCookie } */
    this.cookie;
    /** @export { !Array<!blink.mojom.CookieExclusionReason> } */
    this.exclusionReason;
    /** @export { !Array<!blink.mojom.CookieWarningReason> } */
    this.warningReason;
    /** @export { !blink.mojom.CookieOperation } */
    this.operation;
    /** @export { (url.mojom.Url|undefined) } */
    this.siteForCookies;
    /** @export { (url.mojom.Url|undefined) } */
    this.cookieUrl;
    /** @export { (blink.mojom.AffectedRequest|undefined) } */
    this.request;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedArrayBufferIssueDetailsSpec.$,
    'SharedArrayBufferIssueDetails',
    [
      mojo.internal.StructField(
        'affectedLocation', 0,
        0,
        blink.mojom.AffectedLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWarning', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        blink.mojom.SharedArrayBufferIssueTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SharedArrayBufferIssueDetails');

/** @record */
blink.mojom.SharedArrayBufferIssueDetails = class {
  constructor() {
    /** @export { (blink.mojom.AffectedLocation|undefined) } */
    this.affectedLocation;
    /** @export { !boolean } */
    this.isWarning;
    /** @export { !blink.mojom.SharedArrayBufferIssueType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.LowTextContrastIssueSpec.$,
    'LowTextContrastIssue',
    [
      mojo.internal.StructField(
        'violatingNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'violatingNodeSelector', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contrastRatio', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'thresholdAa', 16,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'thresholdAaa', 20,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontSize', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontWeight', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.LowTextContrastIssue');

/** @record */
blink.mojom.LowTextContrastIssue = class {
  constructor() {
    /** @export { !number } */
    this.violatingNodeId;
    /** @export { !string } */
    this.violatingNodeSelector;
    /** @export { !number } */
    this.contrastRatio;
    /** @export { !number } */
    this.thresholdAa;
    /** @export { !number } */
    this.thresholdAaa;
    /** @export { !string } */
    this.fontSize;
    /** @export { !string } */
    this.fontWeight;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthRequestIssueDetailsSpec.$,
    'FederatedAuthRequestIssueDetails',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.FederatedAuthRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FederatedAuthRequestIssueDetails');

/** @record */
blink.mojom.FederatedAuthRequestIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.FederatedAuthRequestResult } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FederatedAuthUserInfoRequestIssueDetailsSpec.$,
    'FederatedAuthUserInfoRequestIssueDetails',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.FederatedAuthUserInfoRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FederatedAuthUserInfoRequestIssueDetails');

/** @record */
blink.mojom.FederatedAuthUserInfoRequestIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.FederatedAuthUserInfoRequestResult } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.BounceTrackingIssueDetailsSpec.$,
    'BounceTrackingIssueDetails',
    [
      mojo.internal.StructField(
        'trackingSites', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.BounceTrackingIssueDetails');

/** @record */
blink.mojom.BounceTrackingIssueDetails = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.trackingSites;
  }
};



mojo.internal.Struct(
    blink.mojom.PartitioningBlobURLIssueDetailsSpec.$,
    'PartitioningBlobURLIssueDetails',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'partitioningBlobUrlInfo', 8,
        0,
        blink.mojom.PartitioningBlobURLInfoSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.PartitioningBlobURLIssueDetails');

/** @record */
blink.mojom.PartitioningBlobURLIssueDetails = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !blink.mojom.PartitioningBlobURLInfo } */
    this.partitioningBlobUrlInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieDeprecationMetadataIssueDetailsSpec.$,
    'CookieDeprecationMetadataIssueDetails',
    [
      mojo.internal.StructField(
        'allowedSites', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'optOutPercentage', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isOptOutTopLevel', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operation', 16,
        0,
        blink.mojom.CookieOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.CookieDeprecationMetadataIssueDetails');

/** @record */
blink.mojom.CookieDeprecationMetadataIssueDetails = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.allowedSites;
    /** @export { !number } */
    this.optOutPercentage;
    /** @export { !boolean } */
    this.isOptOutTopLevel;
    /** @export { !blink.mojom.CookieOperation } */
    this.operation;
  }
};



mojo.internal.Struct(
    blink.mojom.GenericIssueDetailsSpec.$,
    'GenericIssueDetails',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        blink.mojom.GenericIssueErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'violatingNodeId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'violatingNodeAttribute', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.GenericIssueDetails');

/** @record */
blink.mojom.GenericIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.GenericIssueErrorType } */
    this.errorType;
    /** @export { (string|undefined) } */
    this.frameId;
    /** @export { !number } */
    this.violatingNodeId;
    /** @export { (string|undefined) } */
    this.violatingNodeAttribute;
  }
};



mojo.internal.Struct(
    blink.mojom.DeprecationIssueDetailsSpec.$,
    'DeprecationIssueDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.DeprecationIssueTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'affectedLocation', 8,
        0,
        blink.mojom.AffectedLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeprecationIssueDetails');

/** @record */
blink.mojom.DeprecationIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.DeprecationIssueType } */
    this.type;
    /** @export { !blink.mojom.AffectedLocation } */
    this.affectedLocation;
  }
};



mojo.internal.Struct(
    blink.mojom.UserReidentificationIssueDetailsSpec.$,
    'UserReidentificationIssueDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.UserReidentificationIssueTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        blink.mojom.AffectedRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceCodeLocation', 16,
        0,
        blink.mojom.AffectedLocationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.UserReidentificationIssueDetails');

/** @record */
blink.mojom.UserReidentificationIssueDetails = class {
  constructor() {
    /** @export { !blink.mojom.UserReidentificationIssueType } */
    this.type;
    /** @export { (blink.mojom.AffectedRequest|undefined) } */
    this.request;
    /** @export { (blink.mojom.AffectedLocation|undefined) } */
    this.sourceCodeLocation;
  }
};



mojo.internal.Struct(
    blink.mojom.InspectorIssueDetailsSpec.$,
    'InspectorIssueDetails',
    [
      mojo.internal.StructField(
        'cookieIssueDetails', 0,
        0,
        blink.mojom.CookieIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mixedContentIssueDetails', 8,
        0,
        blink.mojom.MixedContentIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockedByResponseIssueDetails', 16,
        0,
        blink.mojom.BlockedByResponseIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cspIssueDetails', 24,
        0,
        blink.mojom.ContentSecurityPolicyIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sabIssueDetails', 32,
        0,
        blink.mojom.SharedArrayBufferIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'heavyAdIssueDetails', 40,
        0,
        blink.mojom.HeavyAdIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributionReportingIssueDetails', 48,
        0,
        blink.mojom.AttributionReportingIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lowTextContrastDetails', 56,
        0,
        blink.mojom.LowTextContrastIssueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'federatedAuthRequestDetails', 64,
        0,
        blink.mojom.FederatedAuthRequestIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bounceTrackingIssueDetails', 72,
        0,
        blink.mojom.BounceTrackingIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'partitioningBlobUrlIssueDetails', 80,
        0,
        blink.mojom.PartitioningBlobURLIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieDeprecationMetadataIssueDetails', 88,
        0,
        blink.mojom.CookieDeprecationMetadataIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'genericIssueDetails', 96,
        0,
        blink.mojom.GenericIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecationIssueDetails', 104,
        0,
        blink.mojom.DeprecationIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'federatedAuthUserInfoRequestDetails', 112,
        0,
        blink.mojom.FederatedAuthUserInfoRequestIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userReidentificationIssueDetails', 120,
        0,
        blink.mojom.UserReidentificationIssueDetailsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'issueId', 128,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 144],]);



goog.provide('blink.mojom.InspectorIssueDetails');

/** @record */
blink.mojom.InspectorIssueDetails = class {
  constructor() {
    /** @export { (blink.mojom.CookieIssueDetails|undefined) } */
    this.cookieIssueDetails;
    /** @export { (blink.mojom.MixedContentIssueDetails|undefined) } */
    this.mixedContentIssueDetails;
    /** @export { (blink.mojom.BlockedByResponseIssueDetails|undefined) } */
    this.blockedByResponseIssueDetails;
    /** @export { (blink.mojom.ContentSecurityPolicyIssueDetails|undefined) } */
    this.cspIssueDetails;
    /** @export { (blink.mojom.SharedArrayBufferIssueDetails|undefined) } */
    this.sabIssueDetails;
    /** @export { (blink.mojom.HeavyAdIssueDetails|undefined) } */
    this.heavyAdIssueDetails;
    /** @export { (blink.mojom.AttributionReportingIssueDetails|undefined) } */
    this.attributionReportingIssueDetails;
    /** @export { (blink.mojom.LowTextContrastIssue|undefined) } */
    this.lowTextContrastDetails;
    /** @export { (blink.mojom.FederatedAuthRequestIssueDetails|undefined) } */
    this.federatedAuthRequestDetails;
    /** @export { (blink.mojom.BounceTrackingIssueDetails|undefined) } */
    this.bounceTrackingIssueDetails;
    /** @export { (blink.mojom.PartitioningBlobURLIssueDetails|undefined) } */
    this.partitioningBlobUrlIssueDetails;
    /** @export { (blink.mojom.CookieDeprecationMetadataIssueDetails|undefined) } */
    this.cookieDeprecationMetadataIssueDetails;
    /** @export { (blink.mojom.GenericIssueDetails|undefined) } */
    this.genericIssueDetails;
    /** @export { (blink.mojom.DeprecationIssueDetails|undefined) } */
    this.deprecationIssueDetails;
    /** @export { (blink.mojom.FederatedAuthUserInfoRequestIssueDetails|undefined) } */
    this.federatedAuthUserInfoRequestDetails;
    /** @export { (blink.mojom.UserReidentificationIssueDetails|undefined) } */
    this.userReidentificationIssueDetails;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.issueId;
  }
};



mojo.internal.Struct(
    blink.mojom.InspectorIssueInfoSpec.$,
    'InspectorIssueInfo',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        blink.mojom.InspectorIssueCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        blink.mojom.InspectorIssueDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.InspectorIssueInfo');

/** @record */
blink.mojom.InspectorIssueInfo = class {
  constructor() {
    /** @export { !blink.mojom.InspectorIssueCode } */
    this.code;
    /** @export { !blink.mojom.InspectorIssueDetails } */
    this.details;
  }
};

