// third_party/blink/public/mojom/device_posture/device_posture_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_POSTURE_DEVICE_POSTURE_PROVIDER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_POSTURE_DEVICE_POSTURE_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class DevicePostureProviderProxy;

template <typename ImplRefTraits>
class DevicePostureProviderStub;

class DevicePostureProviderRequestValidator;
class DevicePostureProviderResponseValidator;


class BLINK_COMMON_EXPORT DevicePostureProvider
    : public DevicePostureProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevicePostureProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevicePostureProviderInterfaceBase;
  using Proxy_ = DevicePostureProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevicePostureProviderStub<ImplRefTraits>;

  using RequestValidator_ = DevicePostureProviderRequestValidator;
  using ResponseValidator_ = DevicePostureProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddListenerAndGetCurrentPostureMinVersion = 0,
    kOverrideDevicePostureForEmulationMinVersion = 0,
    kDisableDevicePostureOverrideForEmulationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddListenerAndGetCurrentPosture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OverrideDevicePostureForEmulation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableDevicePostureOverrideForEmulation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevicePostureProvider() = default;

  using AddListenerAndGetCurrentPostureCallback = base::OnceCallback<void(DevicePostureType)>;
  using AddListenerAndGetCurrentPostureMojoCallback = base::OnceCallback<void(DevicePostureType)>;

  virtual void AddListenerAndGetCurrentPosture(::mojo::PendingRemote<DevicePostureClient> client, AddListenerAndGetCurrentPostureCallback callback) = 0;

  virtual void OverrideDevicePostureForEmulation(DevicePostureType posture) = 0;

  virtual void DisableDevicePostureOverrideForEmulation() = 0;
};

class DevicePostureClientProxy;

template <typename ImplRefTraits>
class DevicePostureClientStub;

class DevicePostureClientRequestValidator;


class BLINK_COMMON_EXPORT DevicePostureClient
    : public DevicePostureClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevicePostureClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevicePostureClientInterfaceBase;
  using Proxy_ = DevicePostureClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevicePostureClientStub<ImplRefTraits>;

  using RequestValidator_ = DevicePostureClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPostureChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPostureChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevicePostureClient() = default;

  virtual void OnPostureChanged(DevicePostureType posture) = 0;
};



class BLINK_COMMON_EXPORT DevicePostureProviderProxy
    : public DevicePostureProvider {
 public:
  using InterfaceType = DevicePostureProvider;

  explicit DevicePostureProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddListenerAndGetCurrentPosture(::mojo::PendingRemote<DevicePostureClient> client, AddListenerAndGetCurrentPostureCallback callback) final;
  
  void OverrideDevicePostureForEmulation(DevicePostureType posture) final;
  
  void DisableDevicePostureOverrideForEmulation() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DevicePostureClientProxy
    : public DevicePostureClient {
 public:
  using InterfaceType = DevicePostureClient;

  explicit DevicePostureClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPostureChanged(DevicePostureType posture) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DevicePostureProviderStubDispatch {
 public:
  static bool Accept(DevicePostureProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevicePostureProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevicePostureProvider>>
class DevicePostureProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevicePostureProviderStub() = default;
  ~DevicePostureProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePostureProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePostureProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevicePostureClientStubDispatch {
 public:
  static bool Accept(DevicePostureClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevicePostureClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevicePostureClient>>
class DevicePostureClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevicePostureClientStub() = default;
  ~DevicePostureClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePostureClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePostureClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevicePostureProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevicePostureClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevicePostureProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_POSTURE_DEVICE_POSTURE_PROVIDER_MOJOM_H_