// third_party/blink/public/mojom/content_index/content_index.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/content_index/content_index.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::ContentIndexError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ContentIndexError> {};

template <>
struct hash<::blink::mojom::ContentCategory>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ContentCategory> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentIndexError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ContentIndexError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ContentIndexError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentCategory, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ContentCategory, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ContentCategory>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentIconDefinitionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContentIconDefinitionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ContentIconDefinition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_src,
      src_fragment);

    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->src.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null src in ContentIconDefinition struct");

    decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sizes)::BaseType> sizes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sizes,
      sizes_fragment);

    fragment->sizes.Set(
        sizes_fragment.is_null() ? nullptr : sizes_fragment.data());

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ContentIconDefinition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContentIconDefinitionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContentDescriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ContentDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ContentDescription struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ContentDescription struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ContentDescription struct");

    
    mojo::internal::Serialize<::blink::mojom::ContentCategory>(
      Traits::category(input),
      &fragment->category);

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ContentIconDefinitionDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in ContentDescription struct");

    decltype(Traits::launch_url(input)) in_launch_url = Traits::launch_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->launch_url)::BaseType> launch_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_launch_url,
      launch_url_fragment);

    fragment->launch_url.Set(
        launch_url_fragment.is_null() ? nullptr : launch_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->launch_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null launch_url in ContentDescription struct");
  }

  static bool Deserialize(::blink::mojom::internal::ContentDescription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContentDescriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ContentIconDefinitionDataView::GetSrcDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->src.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentIconDefinitionDataView::GetSizesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sizes.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentIconDefinitionDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDescriptionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDescriptionDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDescriptionDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDescriptionDataView::GetIconsDataView(
    mojo::ArrayDataView<ContentIconDefinitionDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<ContentIconDefinitionDataView>(pointer, message_);
}
inline void ContentDescriptionDataView::GetLaunchUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->launch_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ContentIndexError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ContentIndexError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ContentCategory> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ContentCategory value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_SHARED_H_