// third_party/blink/public/mojom/content_index/content_index.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('skia.mojom.BitmapN32');
goog.require('gfx.mojom.Size');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.ContentIndexError');
goog.provide('blink.mojom.ContentIndexErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ContentIndexErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ContentIndexError = {
  
  NONE: 0,
  INVALID_PARAMETER: 1,
  STORAGE_ERROR: 2,
  NO_SERVICE_WORKER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.ContentCategory');
goog.provide('blink.mojom.ContentCategorySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ContentCategorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ContentCategory = {
  
  NONE: 0,
  HOME_PAGE: 1,
  ARTICLE: 2,
  VIDEO: 3,
  AUDIO: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('blink.mojom.ContentIndexService');
goog.provide('blink.mojom.ContentIndexServiceReceiver');
goog.provide('blink.mojom.ContentIndexServiceCallbackRouter');
goog.provide('blink.mojom.ContentIndexServiceInterface');
goog.provide('blink.mojom.ContentIndexServiceRemote');
goog.provide('blink.mojom.ContentIndexServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ContentIndexServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ContentIndexService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ContentIndexServiceInterface = class {
  
  /**
   * @param { !blink.mojom.ContentCategory } category
   * @return {!Promise<{
        iconSizes: !Array<!gfx.mojom.Size>,
   *  }>}
   */

  getIconSizes(category) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink.mojom.ContentDescription } description
   * @param { !Array<!skia.mojom.BitmapN32> } icon
   * @param { !url.mojom.Url } launchUrl
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
   *  }>}
   */

  add(serviceWorkerRegistrationId, description, icon, launchUrl) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } id
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
   *  }>}
   */

  delete(serviceWorkerRegistrationId, id) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
        descriptions: !Array<!blink.mojom.ContentDescription>,
   *  }>}
   */

  getDescriptions(serviceWorkerRegistrationId) {}
};

/**
 * @export
 * @implements { blink.mojom.ContentIndexServiceInterface }
 */
blink.mojom.ContentIndexServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ContentIndexServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ContentIndexServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ContentIndexServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ContentCategory } category
   * @return {!Promise<{
        iconSizes: !Array<!gfx.mojom.Size>,
   *  }>}
   */

  getIconSizes(
      category) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        [
          category
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !blink.mojom.ContentDescription } description
   * @param { !Array<!skia.mojom.BitmapN32> } icon
   * @param { !url.mojom.Url } launchUrl
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
   *  }>}
   */

  add(
      serviceWorkerRegistrationId,
      description,
      icon,
      launchUrl) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ContentIndexService_Add_ParamsSpec.$,
        blink.mojom.ContentIndexService_Add_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          description,
          icon,
          launchUrl
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } id
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
   *  }>}
   */

  delete(
      serviceWorkerRegistrationId,
      id) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ContentIndexService_Delete_ParamsSpec.$,
        blink.mojom.ContentIndexService_Delete_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          id
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !blink.mojom.ContentIndexError,
        descriptions: !Array<!blink.mojom.ContentDescription>,
   *  }>}
   */

  getDescriptions(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContentIndexService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ContentIndexServiceReceiver = class {
  /**
   * @param {!blink.mojom.ContentIndexServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ContentIndexServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ContentIndexServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContentIndexServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        impl.getIconSizes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ContentIndexService_Add_ParamsSpec.$,
        blink.mojom.ContentIndexService_Add_ResponseParamsSpec.$,
        impl.add.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ContentIndexService_Delete_ParamsSpec.$,
        blink.mojom.ContentIndexService_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        impl.getDescriptions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ContentIndexService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContentIndexService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ContentIndexServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ContentIndexServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContentIndexService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ContentIndexServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ContentIndexServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContentIndexServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIconSizes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        this.getIconSizes.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.add =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ContentIndexService_Add_ParamsSpec.$,
        blink.mojom.ContentIndexService_Add_ResponseParamsSpec.$,
        this.add.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ContentIndexService_Delete_ParamsSpec.$,
        blink.mojom.ContentIndexService_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDescriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec.$,
        blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        this.getDescriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ContentIconDefinitionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIconDefinitionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentDescriptionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentDescriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_Add_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_Add_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_Add_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_Add_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_Delete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_Delete_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ContentIconDefinitionSpec.$,
    'ContentIconDefinition',
    [
      mojo.internal.StructField(
        'src', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sizes', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ContentIconDefinition');

/** @record */
blink.mojom.ContentIconDefinition = class {
  constructor() {
    /** @export { !string } */
    this.src;
    /** @export { (string|undefined) } */
    this.sizes;
    /** @export { (string|undefined) } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentDescriptionSpec.$,
    'ContentDescription',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'category', 24,
        0,
        blink.mojom.ContentCategorySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icons', 32,
        0,
        mojo.internal.Array(blink.mojom.ContentIconDefinitionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'launchUrl', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ContentDescription');

/** @record */
blink.mojom.ContentDescription = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.title;
    /** @export { !string } */
    this.description;
    /** @export { !blink.mojom.ContentCategory } */
    this.category;
    /** @export { !Array<!blink.mojom.ContentIconDefinition> } */
    this.icons;
    /** @export { !string } */
    this.launchUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_GetIconSizes_ParamsSpec.$,
    'ContentIndexService_GetIconSizes_Params',
    [
      mojo.internal.StructField(
        'category', 0,
        0,
        blink.mojom.ContentCategorySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ContentIndexService_GetIconSizes_Params');

/** @record */
blink.mojom.ContentIndexService_GetIconSizes_Params = class {
  constructor() {
    /** @export { !blink.mojom.ContentCategory } */
    this.category;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
    'ContentIndexService_GetIconSizes_ResponseParams',
    [
      mojo.internal.StructField(
        'iconSizes', 0,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ContentIndexService_GetIconSizes_ResponseParams');

/** @record */
blink.mojom.ContentIndexService_GetIconSizes_ResponseParams = class {
  constructor() {
    /** @export { !Array<!gfx.mojom.Size> } */
    this.iconSizes;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_Add_ParamsSpec.$,
    'ContentIndexService_Add_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        blink.mojom.ContentDescriptionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 16,
        0,
        mojo.internal.Array(skia.mojom.BitmapN32Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'launchUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ContentIndexService_Add_Params');

/** @record */
blink.mojom.ContentIndexService_Add_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !blink.mojom.ContentDescription } */
    this.description;
    /** @export { !Array<!skia.mojom.BitmapN32> } */
    this.icon;
    /** @export { !url.mojom.Url } */
    this.launchUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_Add_ResponseParamsSpec.$,
    'ContentIndexService_Add_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ContentIndexErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ContentIndexService_Add_ResponseParams');

/** @record */
blink.mojom.ContentIndexService_Add_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ContentIndexError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_Delete_ParamsSpec.$,
    'ContentIndexService_Delete_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ContentIndexService_Delete_Params');

/** @record */
blink.mojom.ContentIndexService_Delete_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_Delete_ResponseParamsSpec.$,
    'ContentIndexService_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ContentIndexErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ContentIndexService_Delete_ResponseParams');

/** @record */
blink.mojom.ContentIndexService_Delete_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ContentIndexError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_GetDescriptions_ParamsSpec.$,
    'ContentIndexService_GetDescriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ContentIndexService_GetDescriptions_Params');

/** @record */
blink.mojom.ContentIndexService_GetDescriptions_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
  }
};



mojo.internal.Struct(
    blink.mojom.ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
    'ContentIndexService_GetDescriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ContentIndexErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'descriptions', 8,
        0,
        mojo.internal.Array(blink.mojom.ContentDescriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ContentIndexService_GetDescriptions_ResponseParams');

/** @record */
blink.mojom.ContentIndexService_GetDescriptions_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ContentIndexError } */
    this.error;
    /** @export { !Array<!blink.mojom.ContentDescription> } */
    this.descriptions;
  }
};

