// third_party/blink/public/mojom/content_extraction/inner_text.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class InnerTextAgentProxy;

template <typename ImplRefTraits>
class InnerTextAgentStub;

class InnerTextAgentRequestValidator;
class InnerTextAgentResponseValidator;


class BLINK_COMMON_EXPORT InnerTextAgent
    : public InnerTextAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.InnerTextAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = InnerTextAgentInterfaceBase;
  using Proxy_ = InnerTextAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = InnerTextAgentStub<ImplRefTraits>;

  using RequestValidator_ = InnerTextAgentRequestValidator;
  using ResponseValidator_ = InnerTextAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetInnerTextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetInnerText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~InnerTextAgent() = default;

  using GetInnerTextCallback = base::OnceCallback<void(InnerTextFramePtr)>;
  using GetInnerTextMojoCallback = base::OnceCallback<void(InnerTextFramePtr)>;

  virtual void GetInnerText(InnerTextParamsPtr params, GetInnerTextCallback callback) = 0;
};



class BLINK_COMMON_EXPORT InnerTextAgentProxy
    : public InnerTextAgent {
 public:
  using InterfaceType = InnerTextAgent;

  explicit InnerTextAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetInnerText(InnerTextParamsPtr params, GetInnerTextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT InnerTextAgentStubDispatch {
 public:
  static bool Accept(InnerTextAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InnerTextAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InnerTextAgent>>
class InnerTextAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InnerTextAgentStub() = default;
  ~InnerTextAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InnerTextAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InnerTextAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT InnerTextAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT InnerTextAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class BLINK_COMMON_EXPORT InnerTextSegment {
 public:
  using DataView = InnerTextSegmentDataView;
  using Data_ = internal::InnerTextSegment_Data;
  using Tag = Data_::InnerTextSegment_Tag;

  template <typename... Args>
  static InnerTextSegmentPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |node_location|.
  static InnerTextSegmentPtr NewNodeLocation(
      NodeLocationType value);
  // Construct an instance holding |text|.
  static InnerTextSegmentPtr NewText(
      const std::string& value);
  // Construct an instance holding |frame|.
  static InnerTextSegmentPtr NewFrame(
      InnerTextFramePtr value);

  template <typename U>
  static InnerTextSegmentPtr From(const U& u) {
    return mojo::TypeConverter<InnerTextSegmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InnerTextSegment>::Convert(*this);
  }
  ~InnerTextSegment();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  InnerTextSegment(const InnerTextSegment& other) = delete;
  InnerTextSegment& operator=(const InnerTextSegment& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = InnerTextSegmentPtr>
  InnerTextSegmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, InnerTextSegment>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, InnerTextSegment>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_node_location() const { return tag_ == Tag::kNodeLocation; }
  NodeLocationType get_node_location() const {
    CHECK(tag_ == Tag::kNodeLocation);
    return data_.node_location;
  }
  void set_node_location(NodeLocationType node_location);

  bool is_text() const { return tag_ == Tag::kText; }
  const std::string& get_text() const {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  std::string& get_text() {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  void set_text(const std::string& text);

  bool is_frame() const { return tag_ == Tag::kFrame; }
  const InnerTextFramePtr& get_frame() const {
    CHECK(tag_ == Tag::kFrame);
    return data_.frame;
  }
  InnerTextFramePtr& get_frame() {
    CHECK(tag_ == Tag::kFrame);
    return data_.frame;
  }
  void set_frame(InnerTextFramePtr frame);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InnerTextSegment::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<InnerTextSegment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNodeLocation)>,
        NodeLocationType value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
        InnerTextFramePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    NodeLocationType node_location;
    std::string text;
    InnerTextFramePtr frame;
  };

  InnerTextSegment(
      std::in_place_index_t<static_cast<size_t>(Tag::kNodeLocation)>,
      NodeLocationType value);
  InnerTextSegment(
      std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
      const std::string& value);
  InnerTextSegment(
      std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
      InnerTextFramePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT InnerTextFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InnerTextFrame, T>::value>;
  using DataView = InnerTextFrameDataView;
  using Data_ = internal::InnerTextFrame_Data;

  template <typename... Args>
  static InnerTextFramePtr New(Args&&... args) {
    return InnerTextFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InnerTextFramePtr From(const U& u) {
    return mojo::TypeConverter<InnerTextFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InnerTextFrame>::Convert(*this);
  }


  InnerTextFrame();

  InnerTextFrame(
      const ::blink::LocalFrameToken& token,
      std::vector<InnerTextSegmentPtr> segments);

InnerTextFrame(const InnerTextFrame&) = delete;
InnerTextFrame& operator=(const InnerTextFrame&) = delete;

  ~InnerTextFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InnerTextFramePtr>
  InnerTextFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InnerTextFrame::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InnerTextFrame::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InnerTextFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InnerTextFrame_UnserializedMessageContext<
            UserType, InnerTextFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InnerTextFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InnerTextFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InnerTextFrame_UnserializedMessageContext<
            UserType, InnerTextFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InnerTextFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::LocalFrameToken token;
  
  std::vector<InnerTextSegmentPtr> segments;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InnerTextFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT InnerTextParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InnerTextParams, T>::value>;
  using DataView = InnerTextParamsDataView;
  using Data_ = internal::InnerTextParams_Data;

  template <typename... Args>
  static InnerTextParamsPtr New(Args&&... args) {
    return InnerTextParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InnerTextParamsPtr From(const U& u) {
    return mojo::TypeConverter<InnerTextParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InnerTextParams>::Convert(*this);
  }


  InnerTextParams();

  InnerTextParams(
      std::optional<int32_t> node_id,
      std::optional<uint32_t> max_words_per_aggregate_passage,
      std::optional<bool> greedily_aggregate_sibling_nodes,
      uint32_t max_passages,
      std::optional<uint32_t> min_words_per_passage);


  ~InnerTextParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InnerTextParamsPtr>
  InnerTextParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InnerTextParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InnerTextParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InnerTextParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InnerTextParams_UnserializedMessageContext<
            UserType, InnerTextParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InnerTextParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InnerTextParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InnerTextParams_UnserializedMessageContext<
            UserType, InnerTextParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InnerTextParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<int32_t> node_id;
  
  std::optional<uint32_t> max_words_per_aggregate_passage;
  
  std::optional<bool> greedily_aggregate_sibling_nodes;
  
  uint32_t max_passages;
  
  std::optional<uint32_t> min_words_per_passage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InnerTextParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
InnerTextSegmentPtr InnerTextSegment::Clone() const {
  switch (tag_) {
    case Tag::kNodeLocation:
      return NewNodeLocation(
          mojo::Clone(data_.node_location));
    case Tag::kText:
      return NewText(
          mojo::Clone(data_.text));
    case Tag::kFrame:
      return NewFrame(
          mojo::Clone(data_.frame));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, InnerTextSegment>::value>::type*>
bool InnerTextSegment::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNodeLocation:
      return mojo::Equals(data_.node_location, other.data_.node_location);
    case Tag::kText:
      return mojo::Equals(data_.text, other.data_.text);
    case Tag::kFrame:
      return mojo::Equals(data_.frame, other.data_.frame);
  }

  return false;
}
template <typename StructPtrType>
InnerTextFramePtr InnerTextFrame::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(segments)
  );
}

template <typename T, InnerTextFrame::EnableIfSame<T>*>
bool InnerTextFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->segments, other_struct.segments))
    return false;
  return true;
}

template <typename T, InnerTextFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.segments < rhs.segments)
    return true;
  if (rhs.segments < lhs.segments)
    return false;
  return false;
}
template <typename StructPtrType>
InnerTextParamsPtr InnerTextParams::Clone() const {
  return New(
      mojo::Clone(node_id),
      mojo::Clone(max_words_per_aggregate_passage),
      mojo::Clone(greedily_aggregate_sibling_nodes),
      mojo::Clone(max_passages),
      mojo::Clone(min_words_per_passage)
  );
}

template <typename T, InnerTextParams::EnableIfSame<T>*>
bool InnerTextParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  if (!mojo::Equals(this->max_words_per_aggregate_passage, other_struct.max_words_per_aggregate_passage))
    return false;
  if (!mojo::Equals(this->greedily_aggregate_sibling_nodes, other_struct.greedily_aggregate_sibling_nodes))
    return false;
  if (!mojo::Equals(this->max_passages, other_struct.max_passages))
    return false;
  if (!mojo::Equals(this->min_words_per_passage, other_struct.min_words_per_passage))
    return false;
  return true;
}

template <typename T, InnerTextParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  if (lhs.max_words_per_aggregate_passage < rhs.max_words_per_aggregate_passage)
    return true;
  if (rhs.max_words_per_aggregate_passage < lhs.max_words_per_aggregate_passage)
    return false;
  if (lhs.greedily_aggregate_sibling_nodes < rhs.greedily_aggregate_sibling_nodes)
    return true;
  if (rhs.greedily_aggregate_sibling_nodes < lhs.greedily_aggregate_sibling_nodes)
    return false;
  if (lhs.max_passages < rhs.max_passages)
    return true;
  if (rhs.max_passages < lhs.max_passages)
    return false;
  if (lhs.min_words_per_passage < rhs.min_words_per_passage)
    return true;
  if (rhs.min_words_per_passage < lhs.min_words_per_passage)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::InnerTextFrame::DataView,
                                         ::blink::mojom::InnerTextFramePtr> {
  static bool IsNull(const ::blink::mojom::InnerTextFramePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::InnerTextFramePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::InnerTextFrame::token)& token(
      const ::blink::mojom::InnerTextFramePtr& input) {
    return input->token;
  }

  static const decltype(::blink::mojom::InnerTextFrame::segments)& segments(
      const ::blink::mojom::InnerTextFramePtr& input) {
    return input->segments;
  }

  static bool Read(::blink::mojom::InnerTextFrame::DataView input, ::blink::mojom::InnerTextFramePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::InnerTextParams::DataView,
                                         ::blink::mojom::InnerTextParamsPtr> {
  static bool IsNull(const ::blink::mojom::InnerTextParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::InnerTextParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::InnerTextParams::node_id) node_id(
      const ::blink::mojom::InnerTextParamsPtr& input) {
    return input->node_id;
  }

  static decltype(::blink::mojom::InnerTextParams::max_words_per_aggregate_passage) max_words_per_aggregate_passage(
      const ::blink::mojom::InnerTextParamsPtr& input) {
    return input->max_words_per_aggregate_passage;
  }

  static decltype(::blink::mojom::InnerTextParams::greedily_aggregate_sibling_nodes) greedily_aggregate_sibling_nodes(
      const ::blink::mojom::InnerTextParamsPtr& input) {
    return input->greedily_aggregate_sibling_nodes;
  }

  static decltype(::blink::mojom::InnerTextParams::max_passages) max_passages(
      const ::blink::mojom::InnerTextParamsPtr& input) {
    return input->max_passages;
  }

  static decltype(::blink::mojom::InnerTextParams::min_words_per_passage) min_words_per_passage(
      const ::blink::mojom::InnerTextParamsPtr& input) {
    return input->min_words_per_passage;
  }

  static bool Read(::blink::mojom::InnerTextParams::DataView input, ::blink::mojom::InnerTextParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::InnerTextSegment::DataView,
                                        ::blink::mojom::InnerTextSegmentPtr> {
  static bool IsNull(const ::blink::mojom::InnerTextSegmentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::InnerTextSegmentPtr* output) { output->reset(); }

  static ::blink::mojom::InnerTextSegment::Tag GetTag(const ::blink::mojom::InnerTextSegmentPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::NodeLocationType node_location(const ::blink::mojom::InnerTextSegmentPtr& input) {
    return input->get_node_location();
  }

  static const std::string& text(const ::blink::mojom::InnerTextSegmentPtr& input) {
    return input->get_text();
  }

  static const ::blink::mojom::InnerTextFramePtr& frame(const ::blink::mojom::InnerTextSegmentPtr& input) {
    return input->get_frame();
  }

  static bool Read(::blink::mojom::InnerTextSegment::DataView input, ::blink::mojom::InnerTextSegmentPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_H_