// third_party/blink/public/mojom/content_extraction/inner_html.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/inner_html.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function InnerHtmlAgent_GetInnerHtml_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerHtmlAgent_GetInnerHtml_Params.prototype.initDefaults_ = function() {
  };
  InnerHtmlAgent_GetInnerHtml_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerHtmlAgent_GetInnerHtml_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InnerHtmlAgent_GetInnerHtml_Params.encodedSize = codec.kStructHeaderSize + 0;

  InnerHtmlAgent_GetInnerHtml_Params.decode = function(decoder) {
    var packed;
    var val = new InnerHtmlAgent_GetInnerHtml_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InnerHtmlAgent_GetInnerHtml_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerHtmlAgent_GetInnerHtml_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InnerHtmlAgent_GetInnerHtml_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerHtmlAgent_GetInnerHtml_ResponseParams.prototype.initDefaults_ = function() {
    this.innerHtml = null;
  };
  InnerHtmlAgent_GetInnerHtml_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerHtmlAgent_GetInnerHtml_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InnerHtmlAgent_GetInnerHtml_ResponseParams.innerHtml
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InnerHtmlAgent_GetInnerHtml_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InnerHtmlAgent_GetInnerHtml_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InnerHtmlAgent_GetInnerHtml_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.innerHtml =
        decoder.decodeStruct(codec.String);
    return val;
  };

  InnerHtmlAgent_GetInnerHtml_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerHtmlAgent_GetInnerHtml_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.innerHtml);
  };
  var kInnerHtmlAgent_GetInnerHtml_Name = 0;

  function InnerHtmlAgentPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InnerHtmlAgent,
                                                   handleOrPtrInfo);
  }

  function InnerHtmlAgentAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InnerHtmlAgent, associatedInterfacePtrInfo);
  }

  InnerHtmlAgentAssociatedPtr.prototype =
      Object.create(InnerHtmlAgentPtr.prototype);
  InnerHtmlAgentAssociatedPtr.prototype.constructor =
      InnerHtmlAgentAssociatedPtr;

  function InnerHtmlAgentProxy(receiver) {
    this.receiver_ = receiver;
  }
  InnerHtmlAgentPtr.prototype.getInnerHtml = function() {
    return InnerHtmlAgentProxy.prototype.getInnerHtml
        .apply(this.ptr.getProxy(), arguments);
  };

  InnerHtmlAgentProxy.prototype.getInnerHtml = function() {
    var params_ = new InnerHtmlAgent_GetInnerHtml_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInnerHtmlAgent_GetInnerHtml_Name,
          codec.align(InnerHtmlAgent_GetInnerHtml_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InnerHtmlAgent_GetInnerHtml_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InnerHtmlAgent_GetInnerHtml_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InnerHtmlAgentStub(delegate) {
    this.delegate_ = delegate;
  }
  InnerHtmlAgentStub.prototype.getInnerHtml = function() {
    return this.delegate_ && this.delegate_.getInnerHtml && this.delegate_.getInnerHtml();
  }

  InnerHtmlAgentStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InnerHtmlAgentStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInnerHtmlAgent_GetInnerHtml_Name:
      var params = reader.decodeStruct(InnerHtmlAgent_GetInnerHtml_Params);
      this.getInnerHtml().then(function(response) {
        var responseParams =
            new InnerHtmlAgent_GetInnerHtml_ResponseParams();
        responseParams.innerHtml = response.innerHtml;
        var builder = new codec.MessageV1Builder(
            kInnerHtmlAgent_GetInnerHtml_Name,
            codec.align(InnerHtmlAgent_GetInnerHtml_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InnerHtmlAgent_GetInnerHtml_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInnerHtmlAgentRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInnerHtmlAgent_GetInnerHtml_Name:
        if (message.expectsResponse())
          paramsClass = InnerHtmlAgent_GetInnerHtml_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInnerHtmlAgentResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInnerHtmlAgent_GetInnerHtml_Name:
        if (message.isResponse())
          paramsClass = InnerHtmlAgent_GetInnerHtml_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InnerHtmlAgent = {
    name: 'blink.mojom.InnerHtmlAgent',
    kVersion: 0,
    ptrClass: InnerHtmlAgentPtr,
    proxyClass: InnerHtmlAgentProxy,
    stubClass: InnerHtmlAgentStub,
    validateRequest: validateInnerHtmlAgentRequest,
    validateResponse: validateInnerHtmlAgentResponse,
  };
  InnerHtmlAgentStub.prototype.validator = validateInnerHtmlAgentRequest;
  InnerHtmlAgentProxy.prototype.validator = validateInnerHtmlAgentResponse;
  exports.InnerHtmlAgent = InnerHtmlAgent;
  exports.InnerHtmlAgentPtr = InnerHtmlAgentPtr;
  exports.InnerHtmlAgentAssociatedPtr = InnerHtmlAgentAssociatedPtr;
})();