// third_party/blink/public/mojom/content_extraction/inner_html.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_extraction/inner_html.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/inner_html.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_extraction/inner_html.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_extraction/inner_html.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/content_extraction/inner_html.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

InnerHtmlAgent::IPCStableHashFunction InnerHtmlAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InnerHtmlAgent>(message.name())) {
    case messages::InnerHtmlAgent::kGetInnerHtml: {
      return &InnerHtmlAgent::GetInnerHtml_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InnerHtmlAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InnerHtmlAgent>(message.name())) {
      case messages::InnerHtmlAgent::kGetInnerHtml:
            return "Receive blink::mojom::InnerHtmlAgent::GetInnerHtml";
    }
  } else {
    switch (static_cast<messages::InnerHtmlAgent>(message.name())) {
      case messages::InnerHtmlAgent::kGetInnerHtml:
            return "Receive reply blink::mojom::InnerHtmlAgent::GetInnerHtml";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InnerHtmlAgent::GetInnerHtml_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8416700f;  // IPCStableHash for blink::mojom::InnerHtmlAgent::GetInnerHtml
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InnerHtmlAgent_GetInnerHtml_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InnerHtmlAgent_GetInnerHtml_ForwardToCallback(
      InnerHtmlAgent::GetInnerHtmlCallback callback
      ) : callback_(std::move(callback)) {
  }

  InnerHtmlAgent_GetInnerHtml_ForwardToCallback(const InnerHtmlAgent_GetInnerHtml_ForwardToCallback&) = delete;
  InnerHtmlAgent_GetInnerHtml_ForwardToCallback& operator=(const InnerHtmlAgent_GetInnerHtml_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InnerHtmlAgent::GetInnerHtmlCallback callback_;
};

InnerHtmlAgentProxy::InnerHtmlAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InnerHtmlAgentProxy::GetInnerHtml(
    GetInnerHtmlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::InnerHtmlAgent::GetInnerHtml");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InnerHtmlAgent::kGetInnerHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InnerHtmlAgent_GetInnerHtml_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InnerHtmlAgent::Name_);
  message.set_method_name("GetInnerHtml");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InnerHtmlAgent_GetInnerHtml_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InnerHtmlAgent_GetInnerHtml_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InnerHtmlAgent::GetInnerHtmlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InnerHtmlAgent_GetInnerHtml_ProxyToResponder> proxy(
        new InnerHtmlAgent_GetInnerHtml_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InnerHtmlAgent_GetInnerHtml_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InnerHtmlAgent_GetInnerHtml_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InnerHtmlAgent_GetInnerHtml_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "InnerHtmlAgent::GetInnerHtmlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_inner_html);
};

bool InnerHtmlAgent_GetInnerHtml_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InnerHtmlAgent_GetInnerHtml_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InnerHtmlAgent_GetInnerHtml_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InnerHtmlAgent.0
  bool success = true;
  ::blink::String p_inner_html{};
  InnerHtmlAgent_GetInnerHtml_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInnerHtml(&p_inner_html))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InnerHtmlAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_inner_html));
  }
  return true;
}

void InnerHtmlAgent_GetInnerHtml_ProxyToResponder::Run(
    const ::blink::String& in_inner_html) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::InnerHtmlAgent::GetInnerHtml", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inner_html"), in_inner_html,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InnerHtmlAgent::kGetInnerHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InnerHtmlAgent_GetInnerHtml_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inner_html)::BaseType> inner_html_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_inner_html,
    inner_html_fragment);

  params->inner_html.Set(
      inner_html_fragment.is_null() ? nullptr : inner_html_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->inner_html.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null inner_html in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InnerHtmlAgent::Name_);
  message.set_method_name("GetInnerHtml");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InnerHtmlAgentStubDispatch::Accept(
    InnerHtmlAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InnerHtmlAgent>(message->header()->name)) {
    case messages::InnerHtmlAgent::kGetInnerHtml: {
      break;
    }
  }
  return false;
}

// static
bool InnerHtmlAgentStubDispatch::AcceptWithResponder(
    InnerHtmlAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InnerHtmlAgent>(message->header()->name)) {
    case messages::InnerHtmlAgent::kGetInnerHtml: {
      internal::InnerHtmlAgent_GetInnerHtml_Params_Data* params =
          reinterpret_cast<
              internal::InnerHtmlAgent_GetInnerHtml_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InnerHtmlAgent.0
      bool success = true;
      InnerHtmlAgent_GetInnerHtml_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InnerHtmlAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          InnerHtmlAgent_GetInnerHtml_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInnerHtml(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kInnerHtmlAgentValidationInfo[] = {
    { &internal::InnerHtmlAgent_GetInnerHtml_Params_Data::Validate,
     &internal::InnerHtmlAgent_GetInnerHtml_ResponseParams_Data::Validate},
};

bool InnerHtmlAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::InnerHtmlAgent::Name_,
    kInnerHtmlAgentValidationInfo);
}

bool InnerHtmlAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::InnerHtmlAgent::Name_,
    kInnerHtmlAgentValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void InnerHtmlAgentInterceptorForTesting::GetInnerHtml(GetInnerHtmlCallback callback) {
  GetForwardingInterface()->GetInnerHtml(std::move(callback));
}
InnerHtmlAgentAsyncWaiter::InnerHtmlAgentAsyncWaiter(
    InnerHtmlAgent* proxy) : proxy_(proxy) {}

InnerHtmlAgentAsyncWaiter::~InnerHtmlAgentAsyncWaiter() = default;


void InnerHtmlAgentAsyncWaiter::GetInnerHtml(
    ::blink::String* out_inner_html) {
  base::RunLoop loop;
  proxy_->GetInnerHtml(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_inner_html
,
             const ::blink::String& inner_html) {*out_inner_html = std::move(inner_html);
            loop->Quit();
          },
          &loop,
          out_inner_html));
  loop.Run();
}

::blink::String InnerHtmlAgentAsyncWaiter::GetInnerHtml(
    ) {
  ::blink::String async_wait_result;
  GetInnerHtml(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif