// third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

PaidContentMetadataObserver::IPCStableHashFunction PaidContentMetadataObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaidContentMetadataObserver>(message.name())) {
    case messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged: {
      return &PaidContentMetadataObserver::OnPaidContentMetadataChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaidContentMetadataObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaidContentMetadataObserver>(message.name())) {
      case messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged:
            return "Receive blink::mojom::PaidContentMetadataObserver::OnPaidContentMetadataChanged";
    }
  } else {
    switch (static_cast<messages::PaidContentMetadataObserver>(message.name())) {
      case messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged:
            return "Receive reply blink::mojom::PaidContentMetadataObserver::OnPaidContentMetadataChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaidContentMetadataObserver::OnPaidContentMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1de6325a;  // IPCStableHash for blink::mojom::PaidContentMetadataObserver::OnPaidContentMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PaidContentMetadataObserverProxy::PaidContentMetadataObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaidContentMetadataObserverProxy::OnPaidContentMetadataChanged(
    bool in_has_paid_content) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PaidContentMetadataObserver::OnPaidContentMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_paid_content"), in_has_paid_content,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params_Data> params(
          message);
  params.Allocate();

  params->has_paid_content = in_has_paid_content;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaidContentMetadataObserver::Name_);
  message.set_method_name("OnPaidContentMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PaidContentMetadataObserverStubDispatch::Accept(
    PaidContentMetadataObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaidContentMetadataObserver>(message->header()->name)) {
    case messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PaidContentMetadataObserver.0
      bool success = true;
      bool p_has_paid_content{};
      PaidContentMetadataObserver_OnPaidContentMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_paid_content = input_data_view.has_paid_content();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaidContentMetadataObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaidContentMetadataChanged(        
        std::move(p_has_paid_content));
      return true;
    }
  }
  return false;
}

// static
bool PaidContentMetadataObserverStubDispatch::AcceptWithResponder(
    PaidContentMetadataObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaidContentMetadataObserver>(message->header()->name)) {
    case messages::PaidContentMetadataObserver::kOnPaidContentMetadataChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaidContentMetadataObserverValidationInfo[] = {
    { &internal::PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaidContentMetadataObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PaidContentMetadataObserver::Name_,
    kPaidContentMetadataObserverValidationInfo);
}

// The declaration includes the definition on other builds.

MetaTagsObserver::IPCStableHashFunction MetaTagsObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MetaTagsObserver>(message.name())) {
    case messages::MetaTagsObserver::kOnMetaTagsChanged: {
      return &MetaTagsObserver::OnMetaTagsChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MetaTagsObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MetaTagsObserver>(message.name())) {
      case messages::MetaTagsObserver::kOnMetaTagsChanged:
            return "Receive blink::mojom::MetaTagsObserver::OnMetaTagsChanged";
    }
  } else {
    switch (static_cast<messages::MetaTagsObserver>(message.name())) {
      case messages::MetaTagsObserver::kOnMetaTagsChanged:
            return "Receive reply blink::mojom::MetaTagsObserver::OnMetaTagsChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MetaTagsObserver::OnMetaTagsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a87efbb;  // IPCStableHash for blink::mojom::MetaTagsObserver::OnMetaTagsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MetaTagsObserverProxy::MetaTagsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MetaTagsObserverProxy::OnMetaTagsChanged(
    ::blink::Vector<::blink::mojom::blink::MetaTagPtr> in_meta_tags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MetaTagsObserver::OnMetaTagsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_tags"), in_meta_tags,
                        "<value of type ::blink::Vector<::blink::mojom::blink::MetaTagPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MetaTagsObserver::kOnMetaTagsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MetaTagsObserver_OnMetaTagsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->meta_tags)::BaseType>
      meta_tags_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& meta_tags_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MetaTagDataView>>(
    in_meta_tags,
    meta_tags_fragment,
    &meta_tags_validate_params);

  params->meta_tags.Set(
      meta_tags_fragment.is_null() ? nullptr : meta_tags_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->meta_tags.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null meta_tags in MetaTagsObserver.OnMetaTagsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MetaTagsObserver::Name_);
  message.set_method_name("OnMetaTagsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MetaTagsObserverStubDispatch::Accept(
    MetaTagsObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MetaTagsObserver>(message->header()->name)) {
    case messages::MetaTagsObserver::kOnMetaTagsChanged: {
      DCHECK(message->is_serialized());
      internal::MetaTagsObserver_OnMetaTagsChanged_Params_Data* params =
          reinterpret_cast<internal::MetaTagsObserver_OnMetaTagsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MetaTagsObserver.0
      bool success = true;
      ::blink::Vector<::blink::mojom::blink::MetaTagPtr> p_meta_tags{};
      MetaTagsObserver_OnMetaTagsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetaTags(&p_meta_tags))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MetaTagsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMetaTagsChanged(        
        std::move(p_meta_tags));
      return true;
    }
  }
  return false;
}

// static
bool MetaTagsObserverStubDispatch::AcceptWithResponder(
    MetaTagsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MetaTagsObserver>(message->header()->name)) {
    case messages::MetaTagsObserver::kOnMetaTagsChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMetaTagsObserverValidationInfo[] = {
    { &internal::MetaTagsObserver_OnMetaTagsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MetaTagsObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MetaTagsObserver::Name_,
    kMetaTagsObserverValidationInfo);
}

// The declaration includes the definition on other builds.

FrameMetadataObserverRegistry::IPCStableHashFunction FrameMetadataObserverRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameMetadataObserverRegistry>(message.name())) {
    case messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver: {
      return &FrameMetadataObserverRegistry::AddPaidContentMetadataObserver_Sym::IPCStableHash;
    }
    case messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver: {
      return &FrameMetadataObserverRegistry::AddMetaTagsObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameMetadataObserverRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameMetadataObserverRegistry>(message.name())) {
      case messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver:
            return "Receive blink::mojom::FrameMetadataObserverRegistry::AddPaidContentMetadataObserver";
      case messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver:
            return "Receive blink::mojom::FrameMetadataObserverRegistry::AddMetaTagsObserver";
    }
  } else {
    switch (static_cast<messages::FrameMetadataObserverRegistry>(message.name())) {
      case messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver:
            return "Receive reply blink::mojom::FrameMetadataObserverRegistry::AddPaidContentMetadataObserver";
      case messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver:
            return "Receive reply blink::mojom::FrameMetadataObserverRegistry::AddMetaTagsObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameMetadataObserverRegistry::AddPaidContentMetadataObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb018ab33;  // IPCStableHash for blink::mojom::FrameMetadataObserverRegistry::AddPaidContentMetadataObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameMetadataObserverRegistry::AddMetaTagsObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0775f207;  // IPCStableHash for blink::mojom::FrameMetadataObserverRegistry::AddMetaTagsObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameMetadataObserverRegistryProxy::FrameMetadataObserverRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameMetadataObserverRegistryProxy::AddPaidContentMetadataObserver(
    ::mojo::PendingRemote<PaidContentMetadataObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameMetadataObserverRegistry::AddPaidContentMetadataObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PaidContentMetadataObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PaidContentMetadataObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in FrameMetadataObserverRegistry.AddPaidContentMetadataObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameMetadataObserverRegistry::Name_);
  message.set_method_name("AddPaidContentMetadataObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameMetadataObserverRegistryProxy::AddMetaTagsObserver(
    const ::blink::Vector<::blink::String>& in_names, ::mojo::PendingRemote<MetaTagsObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameMetadataObserverRegistry::AddMetaTagsObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("names"), in_names,
                        "<value of type const ::blink::Vector<::blink::String>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MetaTagsObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameMetadataObserverRegistry_AddMetaTagsObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->names)::BaseType>
      names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_names,
    names_fragment,
    &names_validate_params);

  params->names.Set(
      names_fragment.is_null() ? nullptr : names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null names in FrameMetadataObserverRegistry.AddMetaTagsObserver request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MetaTagsObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in FrameMetadataObserverRegistry.AddMetaTagsObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameMetadataObserverRegistry::Name_);
  message.set_method_name("AddMetaTagsObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameMetadataObserverRegistryStubDispatch::Accept(
    FrameMetadataObserverRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameMetadataObserverRegistry>(message->header()->name)) {
    case messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver: {
      DCHECK(message->is_serialized());
      internal::FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params_Data* params =
          reinterpret_cast<internal::FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameMetadataObserverRegistry.0
      bool success = true;
      ::mojo::PendingRemote<PaidContentMetadataObserver> p_observer{};
      FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameMetadataObserverRegistry::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPaidContentMetadataObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver: {
      DCHECK(message->is_serialized());
      internal::FrameMetadataObserverRegistry_AddMetaTagsObserver_Params_Data* params =
          reinterpret_cast<internal::FrameMetadataObserverRegistry_AddMetaTagsObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameMetadataObserverRegistry.1
      bool success = true;
      ::blink::Vector<::blink::String> p_names{};
      ::mojo::PendingRemote<MetaTagsObserver> p_observer{};
      FrameMetadataObserverRegistry_AddMetaTagsObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNames(&p_names))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameMetadataObserverRegistry::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMetaTagsObserver(        
        std::move(p_names), 
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool FrameMetadataObserverRegistryStubDispatch::AcceptWithResponder(
    FrameMetadataObserverRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameMetadataObserverRegistry>(message->header()->name)) {
    case messages::FrameMetadataObserverRegistry::kAddPaidContentMetadataObserver: {
      break;
    }
    case messages::FrameMetadataObserverRegistry::kAddMetaTagsObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameMetadataObserverRegistryValidationInfo[] = {
    { &internal::FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameMetadataObserverRegistry_AddMetaTagsObserver_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameMetadataObserverRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FrameMetadataObserverRegistry::Name_,
    kFrameMetadataObserverRegistryValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PaidContentMetadataObserverInterceptorForTesting::OnPaidContentMetadataChanged(bool has_paid_content) {
  GetForwardingInterface()->OnPaidContentMetadataChanged(
    std::move(has_paid_content)
    );
}
PaidContentMetadataObserverAsyncWaiter::PaidContentMetadataObserverAsyncWaiter(
    PaidContentMetadataObserver* proxy) : proxy_(proxy) {}

PaidContentMetadataObserverAsyncWaiter::~PaidContentMetadataObserverAsyncWaiter() = default;





void MetaTagsObserverInterceptorForTesting::OnMetaTagsChanged(::blink::Vector<::blink::mojom::blink::MetaTagPtr> meta_tags) {
  GetForwardingInterface()->OnMetaTagsChanged(
    std::move(meta_tags)
    );
}
MetaTagsObserverAsyncWaiter::MetaTagsObserverAsyncWaiter(
    MetaTagsObserver* proxy) : proxy_(proxy) {}

MetaTagsObserverAsyncWaiter::~MetaTagsObserverAsyncWaiter() = default;





void FrameMetadataObserverRegistryInterceptorForTesting::AddPaidContentMetadataObserver(::mojo::PendingRemote<PaidContentMetadataObserver> observer) {
  GetForwardingInterface()->AddPaidContentMetadataObserver(
    std::move(observer)
    );
}
void FrameMetadataObserverRegistryInterceptorForTesting::AddMetaTagsObserver(const ::blink::Vector<::blink::String>& names, ::mojo::PendingRemote<MetaTagsObserver> observer) {
  GetForwardingInterface()->AddMetaTagsObserver(
    std::move(names)
    , 
    std::move(observer)
    );
}
FrameMetadataObserverRegistryAsyncWaiter::FrameMetadataObserverRegistryAsyncWaiter(
    FrameMetadataObserverRegistry* proxy) : proxy_(proxy) {}

FrameMetadataObserverRegistryAsyncWaiter::~FrameMetadataObserverRegistryAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif