// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/forms/form_control_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "ui/accessibility/ax_enums.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "third_party/blink/public/mojom/content_extraction/script_tools.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AIPageContentAgentProxy;

template <typename ImplRefTraits>
class AIPageContentAgentStub;

class AIPageContentAgentRequestValidator;
class AIPageContentAgentResponseValidator;


class PLATFORM_EXPORT AIPageContentAgent
    : public AIPageContentAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AIPageContentAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AIPageContentAgentInterfaceBase;
  using Proxy_ = AIPageContentAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = AIPageContentAgentStub<ImplRefTraits>;

  using RequestValidator_ = AIPageContentAgentRequestValidator;
  using ResponseValidator_ = AIPageContentAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAIPageContentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAIPageContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AIPageContentAgent() = default;

  using GetAIPageContentCallback = base::OnceCallback<void(AIPageContentPtr)>;
  using GetAIPageContentMojoCallback = base::OnceCallback<void(AIPageContentPtr)>;

  virtual void GetAIPageContent(AIPageContentOptionsPtr request, GetAIPageContentCallback callback) = 0;
};



class PLATFORM_EXPORT AIPageContentAgentProxy
    : public AIPageContentAgent {
 public:
  using InterfaceType = AIPageContentAgent;

  explicit AIPageContentAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAIPageContent(AIPageContentOptionsPtr request, GetAIPageContentCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AIPageContentAgentStubDispatch {
 public:
  static bool Accept(AIPageContentAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AIPageContentAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AIPageContentAgent>>
class AIPageContentAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AIPageContentAgentStub() = default;
  ~AIPageContentAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIPageContentAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIPageContentAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AIPageContentAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AIPageContentAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class PLATFORM_EXPORT AIPageContentTextStyle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentTextStyle, T>::value>;
  using DataView = AIPageContentTextStyleDataView;
  using Data_ = internal::AIPageContentTextStyle_Data;

  template <typename... Args>
  static AIPageContentTextStylePtr New(Args&&... args) {
    return AIPageContentTextStylePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentTextStylePtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentTextStylePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentTextStyle>::Convert(*this);
  }


  AIPageContentTextStyle();

  AIPageContentTextStyle(
      AIPageContentTextSize text_size,
      bool has_emphasis,
      uint32_t color);


  ~AIPageContentTextStyle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentTextStylePtr>
  AIPageContentTextStylePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTextStyle::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTextStyle::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentTextStyle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentTextStyle_UnserializedMessageContext<
            UserType, AIPageContentTextStyle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentTextStyle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentTextStyle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentTextStyle_UnserializedMessageContext<
            UserType, AIPageContentTextStyle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentTextStyle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentTextSize text_size;
  
  bool has_emphasis;
  
  uint32_t color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentTextStyle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT AIPageContentSVGData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentSVGData, T>::value>;
  using DataView = AIPageContentSVGDataDataView;
  using Data_ = internal::AIPageContentSVGData_Data;

  template <typename... Args>
  static AIPageContentSVGDataPtr New(Args&&... args) {
    return AIPageContentSVGDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentSVGDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentSVGDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentSVGData>::Convert(*this);
  }


  AIPageContentSVGData();

  explicit AIPageContentSVGData(
      const ::blink::String& inner_text);


  ~AIPageContentSVGData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentSVGDataPtr>
  AIPageContentSVGDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSVGData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSVGData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentSVGData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentSVGData_UnserializedMessageContext<
            UserType, AIPageContentSVGData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentSVGData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentSVGData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentSVGData_UnserializedMessageContext<
            UserType, AIPageContentSVGData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentSVGData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String inner_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentSVGData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT AIPageContentMeta {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentMeta, T>::value>;
  using DataView = AIPageContentMetaDataView;
  using Data_ = internal::AIPageContentMeta_Data;

  template <typename... Args>
  static AIPageContentMetaPtr New(Args&&... args) {
    return AIPageContentMetaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentMetaPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentMetaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentMeta>::Convert(*this);
  }


  AIPageContentMeta();

  AIPageContentMeta(
      const ::blink::String& name,
      const ::blink::String& content);


  ~AIPageContentMeta();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentMetaPtr>
  AIPageContentMetaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentMeta::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentMeta::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentMeta::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentMeta_UnserializedMessageContext<
            UserType, AIPageContentMeta::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentMeta::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentMeta::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentMeta_UnserializedMessageContext<
            UserType, AIPageContentMeta::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentMeta::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::String content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentMeta::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT RedactedFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RedactedFrameMetadata, T>::value>;
  using DataView = RedactedFrameMetadataDataView;
  using Data_ = internal::RedactedFrameMetadata_Data;
  using Reason = RedactedFrameMetadata_Reason;

  template <typename... Args>
  static RedactedFrameMetadataPtr New(Args&&... args) {
    return RedactedFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RedactedFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<RedactedFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RedactedFrameMetadata>::Convert(*this);
  }


  RedactedFrameMetadata();

  explicit RedactedFrameMetadata(
      RedactedFrameMetadata::Reason reason);


  ~RedactedFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RedactedFrameMetadataPtr>
  RedactedFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RedactedFrameMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RedactedFrameMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RedactedFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RedactedFrameMetadata_UnserializedMessageContext<
            UserType, RedactedFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RedactedFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RedactedFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RedactedFrameMetadata_UnserializedMessageContext<
            UserType, RedactedFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RedactedFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RedactedFrameMetadata::Reason reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RedactedFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AIPageContentTableData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentTableData, T>::value>;
  using DataView = AIPageContentTableDataDataView;
  using Data_ = internal::AIPageContentTableData_Data;

  template <typename... Args>
  static AIPageContentTableDataPtr New(Args&&... args) {
    return AIPageContentTableDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentTableDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentTableDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentTableData>::Convert(*this);
  }


  AIPageContentTableData();

  explicit AIPageContentTableData(
      const ::blink::String& table_name);


  ~AIPageContentTableData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentTableDataPtr>
  AIPageContentTableDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTableData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTableData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentTableData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentTableData_UnserializedMessageContext<
            UserType, AIPageContentTableData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentTableData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentTableData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentTableData_UnserializedMessageContext<
            UserType, AIPageContentTableData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentTableData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String table_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentTableData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentTableRowData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentTableRowData, T>::value>;
  using DataView = AIPageContentTableRowDataDataView;
  using Data_ = internal::AIPageContentTableRowData_Data;

  template <typename... Args>
  static AIPageContentTableRowDataPtr New(Args&&... args) {
    return AIPageContentTableRowDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentTableRowDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentTableRowDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentTableRowData>::Convert(*this);
  }


  AIPageContentTableRowData();

  explicit AIPageContentTableRowData(
      AIPageContentTableRowType row_type);


  ~AIPageContentTableRowData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentTableRowDataPtr>
  AIPageContentTableRowDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTableRowData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTableRowData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentTableRowData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentTableRowData_UnserializedMessageContext<
            UserType, AIPageContentTableRowData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentTableRowData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentTableRowData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentTableRowData_UnserializedMessageContext<
            UserType, AIPageContentTableRowData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentTableRowData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentTableRowType row_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentTableRowData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentFormData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentFormData, T>::value>;
  using DataView = AIPageContentFormDataDataView;
  using Data_ = internal::AIPageContentFormData_Data;

  template <typename... Args>
  static AIPageContentFormDataPtr New(Args&&... args) {
    return AIPageContentFormDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentFormDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentFormDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentFormData>::Convert(*this);
  }


  AIPageContentFormData();

  explicit AIPageContentFormData(
      const ::blink::String& form_name);


  ~AIPageContentFormData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentFormDataPtr>
  AIPageContentFormDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFormData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFormData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentFormData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentFormData_UnserializedMessageContext<
            UserType, AIPageContentFormData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentFormData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentFormData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentFormData_UnserializedMessageContext<
            UserType, AIPageContentFormData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentFormData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String form_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentFormData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentSelectOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentSelectOption, T>::value>;
  using DataView = AIPageContentSelectOptionDataView;
  using Data_ = internal::AIPageContentSelectOption_Data;

  template <typename... Args>
  static AIPageContentSelectOptionPtr New(Args&&... args) {
    return AIPageContentSelectOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentSelectOptionPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentSelectOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentSelectOption>::Convert(*this);
  }


  AIPageContentSelectOption();

  AIPageContentSelectOption(
      const ::blink::String& value,
      const ::blink::String& text,
      bool is_selected,
      bool disabled);


  ~AIPageContentSelectOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentSelectOptionPtr>
  AIPageContentSelectOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSelectOption::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSelectOption::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentSelectOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentSelectOption_UnserializedMessageContext<
            UserType, AIPageContentSelectOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentSelectOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentSelectOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentSelectOption_UnserializedMessageContext<
            UserType, AIPageContentSelectOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentSelectOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String value;
  
  ::blink::String text;
  
  bool is_selected;
  
  bool disabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentSelectOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT AIPageContentOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentOptions, T>::value>;
  using DataView = AIPageContentOptionsDataView;
  using Data_ = internal::AIPageContentOptions_Data;

  template <typename... Args>
  static AIPageContentOptionsPtr New(Args&&... args) {
    return AIPageContentOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentOptions>::Convert(*this);
  }


  AIPageContentOptions();

  AIPageContentOptions(
      AIPageContentMode mode,
      bool on_critical_path,
      int32_t max_meta_elements,
      bool include_same_site_only);


  ~AIPageContentOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentOptionsPtr>
  AIPageContentOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentOptions_UnserializedMessageContext<
            UserType, AIPageContentOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentOptions_UnserializedMessageContext<
            UserType, AIPageContentOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentMode mode;
  
  bool on_critical_path;
  
  int32_t max_meta_elements;
  
  bool include_same_site_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentIframeContent {
 public:
  using DataView = AIPageContentIframeContentDataView;
  using Data_ = internal::AIPageContentIframeContent_Data;
  using Tag = Data_::AIPageContentIframeContent_Tag;

  template <typename... Args>
  static AIPageContentIframeContentPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |local_frame_data|.
  static AIPageContentIframeContentPtr NewLocalFrameData(
      AIPageContentFrameDataPtr value);
  // Construct an instance holding |redacted_frame_metadata|.
  static AIPageContentIframeContentPtr NewRedactedFrameMetadata(
      RedactedFrameMetadataPtr value);

  template <typename U>
  static AIPageContentIframeContentPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentIframeContentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentIframeContent>::Convert(*this);
  }
  ~AIPageContentIframeContent();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AIPageContentIframeContent(const AIPageContentIframeContent& other) = delete;
  AIPageContentIframeContent& operator=(const AIPageContentIframeContent& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AIPageContentIframeContentPtr>
  AIPageContentIframeContentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AIPageContentIframeContent>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AIPageContentIframeContent>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_local_frame_data() const { return tag_ == Tag::kLocalFrameData; }
  const AIPageContentFrameDataPtr& get_local_frame_data() const {
    CHECK(tag_ == Tag::kLocalFrameData);
    return data_.local_frame_data;
  }
  AIPageContentFrameDataPtr& get_local_frame_data() {
    CHECK(tag_ == Tag::kLocalFrameData);
    return data_.local_frame_data;
  }
  void set_local_frame_data(AIPageContentFrameDataPtr local_frame_data);

  bool is_redacted_frame_metadata() const { return tag_ == Tag::kRedactedFrameMetadata; }
  const RedactedFrameMetadataPtr& get_redacted_frame_metadata() const {
    CHECK(tag_ == Tag::kRedactedFrameMetadata);
    return data_.redacted_frame_metadata;
  }
  RedactedFrameMetadataPtr& get_redacted_frame_metadata() {
    CHECK(tag_ == Tag::kRedactedFrameMetadata);
    return data_.redacted_frame_metadata;
  }
  void set_redacted_frame_metadata(RedactedFrameMetadataPtr redacted_frame_metadata);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentIframeContent::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AIPageContentIframeContent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameData)>,
        AIPageContentFrameDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
        RedactedFrameMetadataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    AIPageContentFrameDataPtr local_frame_data;
    RedactedFrameMetadataPtr redacted_frame_metadata;
  };

  AIPageContentIframeContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameData)>,
      AIPageContentFrameDataPtr value);
  AIPageContentIframeContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
      RedactedFrameMetadataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT AIPageContentGeometry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentGeometry, T>::value>;
  using DataView = AIPageContentGeometryDataView;
  using Data_ = internal::AIPageContentGeometry_Data;

  template <typename... Args>
  static AIPageContentGeometryPtr New(Args&&... args) {
    return AIPageContentGeometryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentGeometryPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentGeometryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentGeometry>::Convert(*this);
  }


  AIPageContentGeometry();

  AIPageContentGeometry(
      const ::gfx::Rect& outer_bounding_box,
      const ::gfx::Rect& visible_bounding_box,
      ::blink::Vector<::gfx::Rect> fragment_visible_bounding_boxes,
      bool is_fixed_or_sticky_position);


  ~AIPageContentGeometry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentGeometryPtr>
  AIPageContentGeometryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentGeometry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentGeometry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentGeometry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentGeometry_UnserializedMessageContext<
            UserType, AIPageContentGeometry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentGeometry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentGeometry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentGeometry_UnserializedMessageContext<
            UserType, AIPageContentGeometry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentGeometry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect outer_bounding_box;
  
  ::gfx::Rect visible_bounding_box;
  
  ::blink::Vector<::gfx::Rect> fragment_visible_bounding_boxes;
  
  bool is_fixed_or_sticky_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentGeometry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentSelection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentSelection, T>::value>;
  using DataView = AIPageContentSelectionDataView;
  using Data_ = internal::AIPageContentSelection_Data;

  template <typename... Args>
  static AIPageContentSelectionPtr New(Args&&... args) {
    return AIPageContentSelectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentSelectionPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentSelectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentSelection>::Convert(*this);
  }


  AIPageContentSelection();

  AIPageContentSelection(
      int32_t start_dom_node_id,
      int32_t start_offset,
      int32_t end_dom_node_id,
      int32_t end_offset,
      const ::blink::String& selected_text);


  ~AIPageContentSelection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentSelectionPtr>
  AIPageContentSelectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSelection::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentSelection::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentSelection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentSelection_UnserializedMessageContext<
            UserType, AIPageContentSelection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentSelection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentSelection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentSelection_UnserializedMessageContext<
            UserType, AIPageContentSelection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentSelection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t start_dom_node_id;
  
  int32_t start_offset;
  
  int32_t end_dom_node_id;
  
  int32_t end_offset;
  
  ::blink::String selected_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentSelection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentPageInteractionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentPageInteractionInfo, T>::value>;
  using DataView = AIPageContentPageInteractionInfoDataView;
  using Data_ = internal::AIPageContentPageInteractionInfo_Data;

  template <typename... Args>
  static AIPageContentPageInteractionInfoPtr New(Args&&... args) {
    return AIPageContentPageInteractionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentPageInteractionInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentPageInteractionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentPageInteractionInfo>::Convert(*this);
  }


  AIPageContentPageInteractionInfo();

  AIPageContentPageInteractionInfo(
      std::optional<int32_t> focused_dom_node_id,
      std::optional<int32_t> accessibility_focused_dom_node_id,
      const std::optional<::gfx::Point>& mouse_position);


  ~AIPageContentPageInteractionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentPageInteractionInfoPtr>
  AIPageContentPageInteractionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentPageInteractionInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentPageInteractionInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentPageInteractionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentPageInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentPageInteractionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentPageInteractionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentPageInteractionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentPageInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentPageInteractionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentPageInteractionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<int32_t> focused_dom_node_id;
  
  std::optional<int32_t> accessibility_focused_dom_node_id;
  
  std::optional<::gfx::Point> mouse_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentFrameInteractionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentFrameInteractionInfo, T>::value>;
  using DataView = AIPageContentFrameInteractionInfoDataView;
  using Data_ = internal::AIPageContentFrameInteractionInfo_Data;

  template <typename... Args>
  static AIPageContentFrameInteractionInfoPtr New(Args&&... args) {
    return AIPageContentFrameInteractionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentFrameInteractionInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentFrameInteractionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentFrameInteractionInfo>::Convert(*this);
  }


  AIPageContentFrameInteractionInfo();

  explicit AIPageContentFrameInteractionInfo(
      AIPageContentSelectionPtr selection);

AIPageContentFrameInteractionInfo(const AIPageContentFrameInteractionInfo&) = delete;
AIPageContentFrameInteractionInfo& operator=(const AIPageContentFrameInteractionInfo&) = delete;

  ~AIPageContentFrameInteractionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentFrameInteractionInfoPtr>
  AIPageContentFrameInteractionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFrameInteractionInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFrameInteractionInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentFrameInteractionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentFrameInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentFrameInteractionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentFrameInteractionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentFrameInteractionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentFrameInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentFrameInteractionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentFrameInteractionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentSelectionPtr selection;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentNodeInteractionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentNodeInteractionInfo, T>::value>;
  using DataView = AIPageContentNodeInteractionInfoDataView;
  using Data_ = internal::AIPageContentNodeInteractionInfo_Data;

  template <typename... Args>
  static AIPageContentNodeInteractionInfoPtr New(Args&&... args) {
    return AIPageContentNodeInteractionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentNodeInteractionInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentNodeInteractionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentNodeInteractionInfo>::Convert(*this);
  }


  AIPageContentNodeInteractionInfo();

  AIPageContentNodeInteractionInfo(
      AIPageContentScrollerInfoPtr scroller_info,
      bool is_focusable,
      bool is_clickable,
      std::optional<int32_t> document_scoped_z_order,
      ::blink::Vector<AIPageContentClickabilityReason> clickability_reasons);

AIPageContentNodeInteractionInfo(const AIPageContentNodeInteractionInfo&) = delete;
AIPageContentNodeInteractionInfo& operator=(const AIPageContentNodeInteractionInfo&) = delete;

  ~AIPageContentNodeInteractionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentNodeInteractionInfoPtr>
  AIPageContentNodeInteractionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentNodeInteractionInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentNodeInteractionInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentNodeInteractionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentNodeInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentNodeInteractionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentNodeInteractionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentNodeInteractionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentNodeInteractionInfo_UnserializedMessageContext<
            UserType, AIPageContentNodeInteractionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentNodeInteractionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentScrollerInfoPtr scroller_info;
  
  bool is_focusable;
  
  bool is_clickable;
  
  std::optional<int32_t> document_scoped_z_order;
  
  ::blink::Vector<AIPageContentClickabilityReason> clickability_reasons;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentScrollerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentScrollerInfo, T>::value>;
  using DataView = AIPageContentScrollerInfoDataView;
  using Data_ = internal::AIPageContentScrollerInfo_Data;

  template <typename... Args>
  static AIPageContentScrollerInfoPtr New(Args&&... args) {
    return AIPageContentScrollerInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentScrollerInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentScrollerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentScrollerInfo>::Convert(*this);
  }


  AIPageContentScrollerInfo();

  AIPageContentScrollerInfo(
      const ::gfx::Size& scrolling_bounds,
      const ::gfx::Rect& visible_area,
      bool user_scrollable_horizontal,
      bool user_scrollable_vertical);


  ~AIPageContentScrollerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentScrollerInfoPtr>
  AIPageContentScrollerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentScrollerInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentScrollerInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentScrollerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentScrollerInfo_UnserializedMessageContext<
            UserType, AIPageContentScrollerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentScrollerInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentScrollerInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentScrollerInfo_UnserializedMessageContext<
            UserType, AIPageContentScrollerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentScrollerInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size scrolling_bounds;
  
  ::gfx::Rect visible_area;
  
  bool user_scrollable_horizontal;
  
  bool user_scrollable_vertical;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AIPageContentTextInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentTextInfo, T>::value>;
  using DataView = AIPageContentTextInfoDataView;
  using Data_ = internal::AIPageContentTextInfo_Data;

  template <typename... Args>
  static AIPageContentTextInfoPtr New(Args&&... args) {
    return AIPageContentTextInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentTextInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentTextInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentTextInfo>::Convert(*this);
  }


  AIPageContentTextInfo();

  AIPageContentTextInfo(
      const ::blink::String& text_content,
      AIPageContentTextStylePtr text_style);

AIPageContentTextInfo(const AIPageContentTextInfo&) = delete;
AIPageContentTextInfo& operator=(const AIPageContentTextInfo&) = delete;

  ~AIPageContentTextInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentTextInfoPtr>
  AIPageContentTextInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTextInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentTextInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentTextInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentTextInfo_UnserializedMessageContext<
            UserType, AIPageContentTextInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentTextInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentTextInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentTextInfo_UnserializedMessageContext<
            UserType, AIPageContentTextInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentTextInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String text_content;
  
  AIPageContentTextStylePtr text_style;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentTextInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentAnchorData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentAnchorData, T>::value>;
  using DataView = AIPageContentAnchorDataDataView;
  using Data_ = internal::AIPageContentAnchorData_Data;

  template <typename... Args>
  static AIPageContentAnchorDataPtr New(Args&&... args) {
    return AIPageContentAnchorDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentAnchorDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentAnchorDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentAnchorData>::Convert(*this);
  }


  AIPageContentAnchorData();

  AIPageContentAnchorData(
      const ::blink::KURL& url,
      ::blink::Vector<AIPageContentAnchorRel> rel);


  ~AIPageContentAnchorData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentAnchorDataPtr>
  AIPageContentAnchorDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentAnchorData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentAnchorData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentAnchorData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentAnchorData_UnserializedMessageContext<
            UserType, AIPageContentAnchorData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentAnchorData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentAnchorData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentAnchorData_UnserializedMessageContext<
            UserType, AIPageContentAnchorData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentAnchorData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::Vector<AIPageContentAnchorRel> rel;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentAnchorData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentImageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentImageInfo, T>::value>;
  using DataView = AIPageContentImageInfoDataView;
  using Data_ = internal::AIPageContentImageInfo_Data;

  template <typename... Args>
  static AIPageContentImageInfoPtr New(Args&&... args) {
    return AIPageContentImageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentImageInfoPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentImageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentImageInfo>::Convert(*this);
  }


  AIPageContentImageInfo();

  AIPageContentImageInfo(
      const ::blink::String& image_caption,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin);


  ~AIPageContentImageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentImageInfoPtr>
  AIPageContentImageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentImageInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentImageInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentImageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentImageInfo_UnserializedMessageContext<
            UserType, AIPageContentImageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentImageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentImageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentImageInfo_UnserializedMessageContext<
            UserType, AIPageContentImageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentImageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String image_caption;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> source_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentImageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AIPageContentCanvasData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentCanvasData, T>::value>;
  using DataView = AIPageContentCanvasDataDataView;
  using Data_ = internal::AIPageContentCanvasData_Data;

  template <typename... Args>
  static AIPageContentCanvasDataPtr New(Args&&... args) {
    return AIPageContentCanvasDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentCanvasDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentCanvasDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentCanvasData>::Convert(*this);
  }


  AIPageContentCanvasData();

  explicit AIPageContentCanvasData(
      const ::gfx::Size& layout_size);


  ~AIPageContentCanvasData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentCanvasDataPtr>
  AIPageContentCanvasDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentCanvasData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentCanvasData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentCanvasData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentCanvasData_UnserializedMessageContext<
            UserType, AIPageContentCanvasData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentCanvasData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentCanvasData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentCanvasData_UnserializedMessageContext<
            UserType, AIPageContentCanvasData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentCanvasData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size layout_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentCanvasData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentVideoData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentVideoData, T>::value>;
  using DataView = AIPageContentVideoDataDataView;
  using Data_ = internal::AIPageContentVideoData_Data;

  template <typename... Args>
  static AIPageContentVideoDataPtr New(Args&&... args) {
    return AIPageContentVideoDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentVideoDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentVideoDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentVideoData>::Convert(*this);
  }


  AIPageContentVideoData();

  AIPageContentVideoData(
      const ::blink::KURL& url,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin);


  ~AIPageContentVideoData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentVideoDataPtr>
  AIPageContentVideoDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentVideoData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentVideoData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentVideoData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentVideoData_UnserializedMessageContext<
            UserType, AIPageContentVideoData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentVideoData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentVideoData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentVideoData_UnserializedMessageContext<
            UserType, AIPageContentVideoData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentVideoData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> source_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentVideoData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AIPageContentFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentFrameData, T>::value>;
  using DataView = AIPageContentFrameDataDataView;
  using Data_ = internal::AIPageContentFrameData_Data;

  template <typename... Args>
  static AIPageContentFrameDataPtr New(Args&&... args) {
    return AIPageContentFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentFrameData>::Convert(*this);
  }


  AIPageContentFrameData();

  AIPageContentFrameData(
      AIPageContentFrameInteractionInfoPtr frame_interaction_info,
      ::blink::Vector<AIPageContentMetaPtr> meta_data,
      const ::blink::String& title,
      std::optional<bool> contains_paid_content,
      ::blink::Vector<::blink::mojom::blink::ScriptToolPtr> script_tools);

AIPageContentFrameData(const AIPageContentFrameData&) = delete;
AIPageContentFrameData& operator=(const AIPageContentFrameData&) = delete;

  ~AIPageContentFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentFrameDataPtr>
  AIPageContentFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFrameData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFrameData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentFrameData_UnserializedMessageContext<
            UserType, AIPageContentFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentFrameData_UnserializedMessageContext<
            UserType, AIPageContentFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentFrameInteractionInfoPtr frame_interaction_info;
  
  ::blink::Vector<AIPageContentMetaPtr> meta_data;
  
  ::blink::String title;
  
  std::optional<bool> contains_paid_content;
  
  ::blink::Vector<::blink::mojom::blink::ScriptToolPtr> script_tools;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT AIPageContentIframeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentIframeData, T>::value>;
  using DataView = AIPageContentIframeDataDataView;
  using Data_ = internal::AIPageContentIframeData_Data;

  template <typename... Args>
  static AIPageContentIframeDataPtr New(Args&&... args) {
    return AIPageContentIframeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentIframeDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentIframeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentIframeData>::Convert(*this);
  }


  AIPageContentIframeData();

  AIPageContentIframeData(
      const ::blink::FrameToken& frame_token,
      bool likely_ad_frame,
      AIPageContentIframeContentPtr content);

AIPageContentIframeData(const AIPageContentIframeData&) = delete;
AIPageContentIframeData& operator=(const AIPageContentIframeData&) = delete;

  ~AIPageContentIframeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentIframeDataPtr>
  AIPageContentIframeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentIframeData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentIframeData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentIframeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentIframeData_UnserializedMessageContext<
            UserType, AIPageContentIframeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentIframeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentIframeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentIframeData_UnserializedMessageContext<
            UserType, AIPageContentIframeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentIframeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::FrameToken frame_token;
  
  bool likely_ad_frame;
  
  AIPageContentIframeContentPtr content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentIframeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT AIPageContentFormControlData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentFormControlData, T>::value>;
  using DataView = AIPageContentFormControlDataDataView;
  using Data_ = internal::AIPageContentFormControlData_Data;

  template <typename... Args>
  static AIPageContentFormControlDataPtr New(Args&&... args) {
    return AIPageContentFormControlDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentFormControlDataPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentFormControlDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentFormControlData>::Convert(*this);
  }


  AIPageContentFormControlData();

  AIPageContentFormControlData(
      ::blink::mojom::blink::FormControlType form_control_type,
      const ::blink::String& field_name,
      const ::blink::String& field_value,
      ::blink::Vector<AIPageContentSelectOptionPtr> select_options,
      const ::blink::String& placeholder,
      bool is_checked,
      bool is_required,
      AIPageContentRedactionDecision redaction_decision);

AIPageContentFormControlData(const AIPageContentFormControlData&) = delete;
AIPageContentFormControlData& operator=(const AIPageContentFormControlData&) = delete;

  ~AIPageContentFormControlData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentFormControlDataPtr>
  AIPageContentFormControlDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFormControlData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentFormControlData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentFormControlData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentFormControlData_UnserializedMessageContext<
            UserType, AIPageContentFormControlData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentFormControlData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentFormControlData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentFormControlData_UnserializedMessageContext<
            UserType, AIPageContentFormControlData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentFormControlData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::FormControlType form_control_type;
  
  ::blink::String field_name;
  
  ::blink::String field_value;
  
  ::blink::Vector<AIPageContentSelectOptionPtr> select_options;
  
  ::blink::String placeholder;
  
  bool is_checked;
  
  bool is_required;
  
  AIPageContentRedactionDecision redaction_decision;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentFormControlData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentAttributes, T>::value>;
  using DataView = AIPageContentAttributesDataView;
  using Data_ = internal::AIPageContentAttributes_Data;

  template <typename... Args>
  static AIPageContentAttributesPtr New(Args&&... args) {
    return AIPageContentAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentAttributesPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentAttributes>::Convert(*this);
  }


  AIPageContentAttributes();

  AIPageContentAttributes(
      std::optional<int32_t> dom_node_id,
      AIPageContentAttributeType attribute_type,
      AIPageContentGeometryPtr geometry,
      AIPageContentNodeInteractionInfoPtr node_interaction_info,
      AIPageContentTextInfoPtr text_info,
      AIPageContentImageInfoPtr image_info,
      AIPageContentSVGDataPtr svg_data,
      AIPageContentCanvasDataPtr canvas_data,
      AIPageContentVideoDataPtr video_data,
      AIPageContentAnchorDataPtr anchor_data,
      AIPageContentFormDataPtr form_data,
      AIPageContentFormControlDataPtr form_control_data,
      AIPageContentTableDataPtr table_data,
      AIPageContentIframeDataPtr iframe_data,
      AIPageContentTableRowDataPtr table_row_data,
      ::blink::Vector<AIPageContentAnnotatedRole> annotated_roles,
      const ::blink::String& label,
      std::optional<::ax::mojom::blink::Role> aria_role,
      std::optional<int32_t> label_for_dom_node_id);

AIPageContentAttributes(const AIPageContentAttributes&) = delete;
AIPageContentAttributes& operator=(const AIPageContentAttributes&) = delete;

  ~AIPageContentAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentAttributesPtr>
  AIPageContentAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentAttributes::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentAttributes::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentAttributes_UnserializedMessageContext<
            UserType, AIPageContentAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentAttributes_UnserializedMessageContext<
            UserType, AIPageContentAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<int32_t> dom_node_id;
  
  AIPageContentAttributeType attribute_type;
  
  AIPageContentGeometryPtr geometry;
  
  AIPageContentNodeInteractionInfoPtr node_interaction_info;
  
  AIPageContentTextInfoPtr text_info;
  
  AIPageContentImageInfoPtr image_info;
  
  AIPageContentSVGDataPtr svg_data;
  
  AIPageContentCanvasDataPtr canvas_data;
  
  AIPageContentVideoDataPtr video_data;
  
  AIPageContentAnchorDataPtr anchor_data;
  
  AIPageContentFormDataPtr form_data;
  
  AIPageContentFormControlDataPtr form_control_data;
  
  AIPageContentTableDataPtr table_data;
  
  AIPageContentIframeDataPtr iframe_data;
  
  AIPageContentTableRowDataPtr table_row_data;
  
  ::blink::Vector<AIPageContentAnnotatedRole> annotated_roles;
  
  ::blink::String label;
  
  std::optional<::ax::mojom::blink::Role> aria_role;
  
  std::optional<int32_t> label_for_dom_node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContentNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContentNode, T>::value>;
  using DataView = AIPageContentNodeDataView;
  using Data_ = internal::AIPageContentNode_Data;

  template <typename... Args>
  static AIPageContentNodePtr New(Args&&... args) {
    return AIPageContentNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentNodePtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContentNode>::Convert(*this);
  }


  AIPageContentNode();

  AIPageContentNode(
      ::blink::Vector<AIPageContentNodePtr> children_nodes,
      AIPageContentAttributesPtr content_attributes);

AIPageContentNode(const AIPageContentNode&) = delete;
AIPageContentNode& operator=(const AIPageContentNode&) = delete;

  ~AIPageContentNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentNodePtr>
  AIPageContentNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentNode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContentNode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContentNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContentNode_UnserializedMessageContext<
            UserType, AIPageContentNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContentNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContentNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContentNode_UnserializedMessageContext<
            UserType, AIPageContentNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContentNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<AIPageContentNodePtr> children_nodes;
  
  AIPageContentAttributesPtr content_attributes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContentNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AIPageContent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIPageContent, T>::value>;
  using DataView = AIPageContentDataView;
  using Data_ = internal::AIPageContent_Data;

  template <typename... Args>
  static AIPageContentPtr New(Args&&... args) {
    return AIPageContentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIPageContentPtr From(const U& u) {
    return mojo::TypeConverter<AIPageContentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIPageContent>::Convert(*this);
  }


  AIPageContent();

  AIPageContent(
      AIPageContentNodePtr root_node,
      AIPageContentPageInteractionInfoPtr page_interaction_info,
      AIPageContentFrameDataPtr frame_data);

AIPageContent(const AIPageContent&) = delete;
AIPageContent& operator=(const AIPageContent&) = delete;

  ~AIPageContent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIPageContentPtr>
  AIPageContentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContent::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIPageContent::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIPageContent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIPageContent_UnserializedMessageContext<
            UserType, AIPageContent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIPageContent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIPageContent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIPageContent_UnserializedMessageContext<
            UserType, AIPageContent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIPageContent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AIPageContentNodePtr root_node;
  
  AIPageContentPageInteractionInfoPtr page_interaction_info;
  
  AIPageContentFrameDataPtr frame_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIPageContent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
AIPageContentIframeContentPtr AIPageContentIframeContent::Clone() const {
  switch (tag_) {
    case Tag::kLocalFrameData:
      return NewLocalFrameData(
          mojo::Clone(data_.local_frame_data));
    case Tag::kRedactedFrameMetadata:
      return NewRedactedFrameMetadata(
          mojo::Clone(data_.redacted_frame_metadata));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AIPageContentIframeContent>::value>::type*>
bool AIPageContentIframeContent::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kLocalFrameData:
      return mojo::Equals(data_.local_frame_data, other.data_.local_frame_data);
    case Tag::kRedactedFrameMetadata:
      return mojo::Equals(data_.redacted_frame_metadata, other.data_.redacted_frame_metadata);
  }

  return false;
}
template <typename StructPtrType>
AIPageContentGeometryPtr AIPageContentGeometry::Clone() const {
  return New(
      mojo::Clone(outer_bounding_box),
      mojo::Clone(visible_bounding_box),
      mojo::Clone(fragment_visible_bounding_boxes),
      mojo::Clone(is_fixed_or_sticky_position)
  );
}

template <typename T, AIPageContentGeometry::EnableIfSame<T>*>
bool AIPageContentGeometry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->outer_bounding_box, other_struct.outer_bounding_box))
    return false;
  if (!mojo::Equals(this->visible_bounding_box, other_struct.visible_bounding_box))
    return false;
  if (!mojo::Equals(this->fragment_visible_bounding_boxes, other_struct.fragment_visible_bounding_boxes))
    return false;
  if (!mojo::Equals(this->is_fixed_or_sticky_position, other_struct.is_fixed_or_sticky_position))
    return false;
  return true;
}

template <typename T, AIPageContentGeometry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.outer_bounding_box < rhs.outer_bounding_box)
    return true;
  if (rhs.outer_bounding_box < lhs.outer_bounding_box)
    return false;
  if (lhs.visible_bounding_box < rhs.visible_bounding_box)
    return true;
  if (rhs.visible_bounding_box < lhs.visible_bounding_box)
    return false;
  if (lhs.fragment_visible_bounding_boxes < rhs.fragment_visible_bounding_boxes)
    return true;
  if (rhs.fragment_visible_bounding_boxes < lhs.fragment_visible_bounding_boxes)
    return false;
  if (lhs.is_fixed_or_sticky_position < rhs.is_fixed_or_sticky_position)
    return true;
  if (rhs.is_fixed_or_sticky_position < lhs.is_fixed_or_sticky_position)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentSelectionPtr AIPageContentSelection::Clone() const {
  return New(
      mojo::Clone(start_dom_node_id),
      mojo::Clone(start_offset),
      mojo::Clone(end_dom_node_id),
      mojo::Clone(end_offset),
      mojo::Clone(selected_text)
  );
}

template <typename T, AIPageContentSelection::EnableIfSame<T>*>
bool AIPageContentSelection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_dom_node_id, other_struct.start_dom_node_id))
    return false;
  if (!mojo::Equals(this->start_offset, other_struct.start_offset))
    return false;
  if (!mojo::Equals(this->end_dom_node_id, other_struct.end_dom_node_id))
    return false;
  if (!mojo::Equals(this->end_offset, other_struct.end_offset))
    return false;
  if (!mojo::Equals(this->selected_text, other_struct.selected_text))
    return false;
  return true;
}

template <typename T, AIPageContentSelection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start_dom_node_id < rhs.start_dom_node_id)
    return true;
  if (rhs.start_dom_node_id < lhs.start_dom_node_id)
    return false;
  if (lhs.start_offset < rhs.start_offset)
    return true;
  if (rhs.start_offset < lhs.start_offset)
    return false;
  if (lhs.end_dom_node_id < rhs.end_dom_node_id)
    return true;
  if (rhs.end_dom_node_id < lhs.end_dom_node_id)
    return false;
  if (lhs.end_offset < rhs.end_offset)
    return true;
  if (rhs.end_offset < lhs.end_offset)
    return false;
  if (lhs.selected_text < rhs.selected_text)
    return true;
  if (rhs.selected_text < lhs.selected_text)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentPageInteractionInfoPtr AIPageContentPageInteractionInfo::Clone() const {
  return New(
      mojo::Clone(focused_dom_node_id),
      mojo::Clone(accessibility_focused_dom_node_id),
      mojo::Clone(mouse_position)
  );
}

template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>*>
bool AIPageContentPageInteractionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->focused_dom_node_id, other_struct.focused_dom_node_id))
    return false;
  if (!mojo::Equals(this->accessibility_focused_dom_node_id, other_struct.accessibility_focused_dom_node_id))
    return false;
  if (!mojo::Equals(this->mouse_position, other_struct.mouse_position))
    return false;
  return true;
}

template <typename T, AIPageContentPageInteractionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.focused_dom_node_id < rhs.focused_dom_node_id)
    return true;
  if (rhs.focused_dom_node_id < lhs.focused_dom_node_id)
    return false;
  if (lhs.accessibility_focused_dom_node_id < rhs.accessibility_focused_dom_node_id)
    return true;
  if (rhs.accessibility_focused_dom_node_id < lhs.accessibility_focused_dom_node_id)
    return false;
  if (lhs.mouse_position < rhs.mouse_position)
    return true;
  if (rhs.mouse_position < lhs.mouse_position)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentFrameInteractionInfoPtr AIPageContentFrameInteractionInfo::Clone() const {
  return New(
      mojo::Clone(selection)
  );
}

template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>*>
bool AIPageContentFrameInteractionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->selection, other_struct.selection))
    return false;
  return true;
}

template <typename T, AIPageContentFrameInteractionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.selection < rhs.selection)
    return true;
  if (rhs.selection < lhs.selection)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentNodeInteractionInfoPtr AIPageContentNodeInteractionInfo::Clone() const {
  return New(
      mojo::Clone(scroller_info),
      mojo::Clone(is_focusable),
      mojo::Clone(is_clickable),
      mojo::Clone(document_scoped_z_order),
      mojo::Clone(clickability_reasons)
  );
}

template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>*>
bool AIPageContentNodeInteractionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroller_info, other_struct.scroller_info))
    return false;
  if (!mojo::Equals(this->is_focusable, other_struct.is_focusable))
    return false;
  if (!mojo::Equals(this->is_clickable, other_struct.is_clickable))
    return false;
  if (!mojo::Equals(this->document_scoped_z_order, other_struct.document_scoped_z_order))
    return false;
  if (!mojo::Equals(this->clickability_reasons, other_struct.clickability_reasons))
    return false;
  return true;
}

template <typename T, AIPageContentNodeInteractionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroller_info < rhs.scroller_info)
    return true;
  if (rhs.scroller_info < lhs.scroller_info)
    return false;
  if (lhs.is_focusable < rhs.is_focusable)
    return true;
  if (rhs.is_focusable < lhs.is_focusable)
    return false;
  if (lhs.is_clickable < rhs.is_clickable)
    return true;
  if (rhs.is_clickable < lhs.is_clickable)
    return false;
  if (lhs.document_scoped_z_order < rhs.document_scoped_z_order)
    return true;
  if (rhs.document_scoped_z_order < lhs.document_scoped_z_order)
    return false;
  if (lhs.clickability_reasons < rhs.clickability_reasons)
    return true;
  if (rhs.clickability_reasons < lhs.clickability_reasons)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentScrollerInfoPtr AIPageContentScrollerInfo::Clone() const {
  return New(
      mojo::Clone(scrolling_bounds),
      mojo::Clone(visible_area),
      mojo::Clone(user_scrollable_horizontal),
      mojo::Clone(user_scrollable_vertical)
  );
}

template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>*>
bool AIPageContentScrollerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scrolling_bounds, other_struct.scrolling_bounds))
    return false;
  if (!mojo::Equals(this->visible_area, other_struct.visible_area))
    return false;
  if (!mojo::Equals(this->user_scrollable_horizontal, other_struct.user_scrollable_horizontal))
    return false;
  if (!mojo::Equals(this->user_scrollable_vertical, other_struct.user_scrollable_vertical))
    return false;
  return true;
}

template <typename T, AIPageContentScrollerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scrolling_bounds < rhs.scrolling_bounds)
    return true;
  if (rhs.scrolling_bounds < lhs.scrolling_bounds)
    return false;
  if (lhs.visible_area < rhs.visible_area)
    return true;
  if (rhs.visible_area < lhs.visible_area)
    return false;
  if (lhs.user_scrollable_horizontal < rhs.user_scrollable_horizontal)
    return true;
  if (rhs.user_scrollable_horizontal < lhs.user_scrollable_horizontal)
    return false;
  if (lhs.user_scrollable_vertical < rhs.user_scrollable_vertical)
    return true;
  if (rhs.user_scrollable_vertical < lhs.user_scrollable_vertical)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentTextStylePtr AIPageContentTextStyle::Clone() const {
  return New(
      mojo::Clone(text_size),
      mojo::Clone(has_emphasis),
      mojo::Clone(color)
  );
}

template <typename T, AIPageContentTextStyle::EnableIfSame<T>*>
bool AIPageContentTextStyle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_size, other_struct.text_size))
    return false;
  if (!mojo::Equals(this->has_emphasis, other_struct.has_emphasis))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  return true;
}

template <typename T, AIPageContentTextStyle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_size < rhs.text_size)
    return true;
  if (rhs.text_size < lhs.text_size)
    return false;
  if (lhs.has_emphasis < rhs.has_emphasis)
    return true;
  if (rhs.has_emphasis < lhs.has_emphasis)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentTextInfoPtr AIPageContentTextInfo::Clone() const {
  return New(
      mojo::Clone(text_content),
      mojo::Clone(text_style)
  );
}

template <typename T, AIPageContentTextInfo::EnableIfSame<T>*>
bool AIPageContentTextInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_content, other_struct.text_content))
    return false;
  if (!mojo::Equals(this->text_style, other_struct.text_style))
    return false;
  return true;
}

template <typename T, AIPageContentTextInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_content < rhs.text_content)
    return true;
  if (rhs.text_content < lhs.text_content)
    return false;
  if (lhs.text_style < rhs.text_style)
    return true;
  if (rhs.text_style < lhs.text_style)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentAnchorDataPtr AIPageContentAnchorData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(rel)
  );
}

template <typename T, AIPageContentAnchorData::EnableIfSame<T>*>
bool AIPageContentAnchorData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->rel, other_struct.rel))
    return false;
  return true;
}

template <typename T, AIPageContentAnchorData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.rel < rhs.rel)
    return true;
  if (rhs.rel < lhs.rel)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentImageInfoPtr AIPageContentImageInfo::Clone() const {
  return New(
      mojo::Clone(image_caption),
      mojo::Clone(source_origin)
  );
}

template <typename T, AIPageContentImageInfo::EnableIfSame<T>*>
bool AIPageContentImageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_caption, other_struct.image_caption))
    return false;
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  return true;
}

template <typename T, AIPageContentImageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_caption < rhs.image_caption)
    return true;
  if (rhs.image_caption < lhs.image_caption)
    return false;
  if (lhs.source_origin < rhs.source_origin)
    return true;
  if (rhs.source_origin < lhs.source_origin)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentSVGDataPtr AIPageContentSVGData::Clone() const {
  return New(
      mojo::Clone(inner_text)
  );
}

template <typename T, AIPageContentSVGData::EnableIfSame<T>*>
bool AIPageContentSVGData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->inner_text, other_struct.inner_text))
    return false;
  return true;
}

template <typename T, AIPageContentSVGData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.inner_text < rhs.inner_text)
    return true;
  if (rhs.inner_text < lhs.inner_text)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentCanvasDataPtr AIPageContentCanvasData::Clone() const {
  return New(
      mojo::Clone(layout_size)
  );
}

template <typename T, AIPageContentCanvasData::EnableIfSame<T>*>
bool AIPageContentCanvasData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layout_size, other_struct.layout_size))
    return false;
  return true;
}

template <typename T, AIPageContentCanvasData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layout_size < rhs.layout_size)
    return true;
  if (rhs.layout_size < lhs.layout_size)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentVideoDataPtr AIPageContentVideoData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(source_origin)
  );
}

template <typename T, AIPageContentVideoData::EnableIfSame<T>*>
bool AIPageContentVideoData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  return true;
}

template <typename T, AIPageContentVideoData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.source_origin < rhs.source_origin)
    return true;
  if (rhs.source_origin < lhs.source_origin)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentMetaPtr AIPageContentMeta::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(content)
  );
}

template <typename T, AIPageContentMeta::EnableIfSame<T>*>
bool AIPageContentMeta::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  return true;
}

template <typename T, AIPageContentMeta::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentFrameDataPtr AIPageContentFrameData::Clone() const {
  return New(
      mojo::Clone(frame_interaction_info),
      mojo::Clone(meta_data),
      mojo::Clone(title),
      mojo::Clone(contains_paid_content),
      mojo::Clone(script_tools)
  );
}

template <typename T, AIPageContentFrameData::EnableIfSame<T>*>
bool AIPageContentFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_interaction_info, other_struct.frame_interaction_info))
    return false;
  if (!mojo::Equals(this->meta_data, other_struct.meta_data))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->contains_paid_content, other_struct.contains_paid_content))
    return false;
  if (!mojo::Equals(this->script_tools, other_struct.script_tools))
    return false;
  return true;
}

template <typename T, AIPageContentFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_interaction_info < rhs.frame_interaction_info)
    return true;
  if (rhs.frame_interaction_info < lhs.frame_interaction_info)
    return false;
  if (lhs.meta_data < rhs.meta_data)
    return true;
  if (rhs.meta_data < lhs.meta_data)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.contains_paid_content < rhs.contains_paid_content)
    return true;
  if (rhs.contains_paid_content < lhs.contains_paid_content)
    return false;
  if (lhs.script_tools < rhs.script_tools)
    return true;
  if (rhs.script_tools < lhs.script_tools)
    return false;
  return false;
}
template <typename StructPtrType>
RedactedFrameMetadataPtr RedactedFrameMetadata::Clone() const {
  return New(
      mojo::Clone(reason)
  );
}

template <typename T, RedactedFrameMetadata::EnableIfSame<T>*>
bool RedactedFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  return true;
}

template <typename T, RedactedFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reason < rhs.reason)
    return true;
  if (rhs.reason < lhs.reason)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentIframeDataPtr AIPageContentIframeData::Clone() const {
  return New(
      mojo::Clone(frame_token),
      mojo::Clone(likely_ad_frame),
      mojo::Clone(content)
  );
}

template <typename T, AIPageContentIframeData::EnableIfSame<T>*>
bool AIPageContentIframeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->likely_ad_frame, other_struct.likely_ad_frame))
    return false;
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  return true;
}

template <typename T, AIPageContentIframeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_token < rhs.frame_token)
    return true;
  if (rhs.frame_token < lhs.frame_token)
    return false;
  if (lhs.likely_ad_frame < rhs.likely_ad_frame)
    return true;
  if (rhs.likely_ad_frame < lhs.likely_ad_frame)
    return false;
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentTableDataPtr AIPageContentTableData::Clone() const {
  return New(
      mojo::Clone(table_name)
  );
}

template <typename T, AIPageContentTableData::EnableIfSame<T>*>
bool AIPageContentTableData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->table_name, other_struct.table_name))
    return false;
  return true;
}

template <typename T, AIPageContentTableData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.table_name < rhs.table_name)
    return true;
  if (rhs.table_name < lhs.table_name)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentTableRowDataPtr AIPageContentTableRowData::Clone() const {
  return New(
      mojo::Clone(row_type)
  );
}

template <typename T, AIPageContentTableRowData::EnableIfSame<T>*>
bool AIPageContentTableRowData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->row_type, other_struct.row_type))
    return false;
  return true;
}

template <typename T, AIPageContentTableRowData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.row_type < rhs.row_type)
    return true;
  if (rhs.row_type < lhs.row_type)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentFormDataPtr AIPageContentFormData::Clone() const {
  return New(
      mojo::Clone(form_name)
  );
}

template <typename T, AIPageContentFormData::EnableIfSame<T>*>
bool AIPageContentFormData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->form_name, other_struct.form_name))
    return false;
  return true;
}

template <typename T, AIPageContentFormData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.form_name < rhs.form_name)
    return true;
  if (rhs.form_name < lhs.form_name)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentSelectOptionPtr AIPageContentSelectOption::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(text),
      mojo::Clone(is_selected),
      mojo::Clone(disabled)
  );
}

template <typename T, AIPageContentSelectOption::EnableIfSame<T>*>
bool AIPageContentSelectOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->is_selected, other_struct.is_selected))
    return false;
  if (!mojo::Equals(this->disabled, other_struct.disabled))
    return false;
  return true;
}

template <typename T, AIPageContentSelectOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.is_selected < rhs.is_selected)
    return true;
  if (rhs.is_selected < lhs.is_selected)
    return false;
  if (lhs.disabled < rhs.disabled)
    return true;
  if (rhs.disabled < lhs.disabled)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentFormControlDataPtr AIPageContentFormControlData::Clone() const {
  return New(
      mojo::Clone(form_control_type),
      mojo::Clone(field_name),
      mojo::Clone(field_value),
      mojo::Clone(select_options),
      mojo::Clone(placeholder),
      mojo::Clone(is_checked),
      mojo::Clone(is_required),
      mojo::Clone(redaction_decision)
  );
}

template <typename T, AIPageContentFormControlData::EnableIfSame<T>*>
bool AIPageContentFormControlData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->form_control_type, other_struct.form_control_type))
    return false;
  if (!mojo::Equals(this->field_name, other_struct.field_name))
    return false;
  if (!mojo::Equals(this->field_value, other_struct.field_value))
    return false;
  if (!mojo::Equals(this->select_options, other_struct.select_options))
    return false;
  if (!mojo::Equals(this->placeholder, other_struct.placeholder))
    return false;
  if (!mojo::Equals(this->is_checked, other_struct.is_checked))
    return false;
  if (!mojo::Equals(this->is_required, other_struct.is_required))
    return false;
  if (!mojo::Equals(this->redaction_decision, other_struct.redaction_decision))
    return false;
  return true;
}

template <typename T, AIPageContentFormControlData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.form_control_type < rhs.form_control_type)
    return true;
  if (rhs.form_control_type < lhs.form_control_type)
    return false;
  if (lhs.field_name < rhs.field_name)
    return true;
  if (rhs.field_name < lhs.field_name)
    return false;
  if (lhs.field_value < rhs.field_value)
    return true;
  if (rhs.field_value < lhs.field_value)
    return false;
  if (lhs.select_options < rhs.select_options)
    return true;
  if (rhs.select_options < lhs.select_options)
    return false;
  if (lhs.placeholder < rhs.placeholder)
    return true;
  if (rhs.placeholder < lhs.placeholder)
    return false;
  if (lhs.is_checked < rhs.is_checked)
    return true;
  if (rhs.is_checked < lhs.is_checked)
    return false;
  if (lhs.is_required < rhs.is_required)
    return true;
  if (rhs.is_required < lhs.is_required)
    return false;
  if (lhs.redaction_decision < rhs.redaction_decision)
    return true;
  if (rhs.redaction_decision < lhs.redaction_decision)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentAttributesPtr AIPageContentAttributes::Clone() const {
  return New(
      mojo::Clone(dom_node_id),
      mojo::Clone(attribute_type),
      mojo::Clone(geometry),
      mojo::Clone(node_interaction_info),
      mojo::Clone(text_info),
      mojo::Clone(image_info),
      mojo::Clone(svg_data),
      mojo::Clone(canvas_data),
      mojo::Clone(video_data),
      mojo::Clone(anchor_data),
      mojo::Clone(form_data),
      mojo::Clone(form_control_data),
      mojo::Clone(table_data),
      mojo::Clone(iframe_data),
      mojo::Clone(table_row_data),
      mojo::Clone(annotated_roles),
      mojo::Clone(label),
      mojo::Clone(aria_role),
      mojo::Clone(label_for_dom_node_id)
  );
}

template <typename T, AIPageContentAttributes::EnableIfSame<T>*>
bool AIPageContentAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dom_node_id, other_struct.dom_node_id))
    return false;
  if (!mojo::Equals(this->attribute_type, other_struct.attribute_type))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  if (!mojo::Equals(this->node_interaction_info, other_struct.node_interaction_info))
    return false;
  if (!mojo::Equals(this->text_info, other_struct.text_info))
    return false;
  if (!mojo::Equals(this->image_info, other_struct.image_info))
    return false;
  if (!mojo::Equals(this->svg_data, other_struct.svg_data))
    return false;
  if (!mojo::Equals(this->canvas_data, other_struct.canvas_data))
    return false;
  if (!mojo::Equals(this->video_data, other_struct.video_data))
    return false;
  if (!mojo::Equals(this->anchor_data, other_struct.anchor_data))
    return false;
  if (!mojo::Equals(this->form_data, other_struct.form_data))
    return false;
  if (!mojo::Equals(this->form_control_data, other_struct.form_control_data))
    return false;
  if (!mojo::Equals(this->table_data, other_struct.table_data))
    return false;
  if (!mojo::Equals(this->iframe_data, other_struct.iframe_data))
    return false;
  if (!mojo::Equals(this->table_row_data, other_struct.table_row_data))
    return false;
  if (!mojo::Equals(this->annotated_roles, other_struct.annotated_roles))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->aria_role, other_struct.aria_role))
    return false;
  if (!mojo::Equals(this->label_for_dom_node_id, other_struct.label_for_dom_node_id))
    return false;
  return true;
}

template <typename T, AIPageContentAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dom_node_id < rhs.dom_node_id)
    return true;
  if (rhs.dom_node_id < lhs.dom_node_id)
    return false;
  if (lhs.attribute_type < rhs.attribute_type)
    return true;
  if (rhs.attribute_type < lhs.attribute_type)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  if (lhs.node_interaction_info < rhs.node_interaction_info)
    return true;
  if (rhs.node_interaction_info < lhs.node_interaction_info)
    return false;
  if (lhs.text_info < rhs.text_info)
    return true;
  if (rhs.text_info < lhs.text_info)
    return false;
  if (lhs.image_info < rhs.image_info)
    return true;
  if (rhs.image_info < lhs.image_info)
    return false;
  if (lhs.svg_data < rhs.svg_data)
    return true;
  if (rhs.svg_data < lhs.svg_data)
    return false;
  if (lhs.canvas_data < rhs.canvas_data)
    return true;
  if (rhs.canvas_data < lhs.canvas_data)
    return false;
  if (lhs.video_data < rhs.video_data)
    return true;
  if (rhs.video_data < lhs.video_data)
    return false;
  if (lhs.anchor_data < rhs.anchor_data)
    return true;
  if (rhs.anchor_data < lhs.anchor_data)
    return false;
  if (lhs.form_data < rhs.form_data)
    return true;
  if (rhs.form_data < lhs.form_data)
    return false;
  if (lhs.form_control_data < rhs.form_control_data)
    return true;
  if (rhs.form_control_data < lhs.form_control_data)
    return false;
  if (lhs.table_data < rhs.table_data)
    return true;
  if (rhs.table_data < lhs.table_data)
    return false;
  if (lhs.iframe_data < rhs.iframe_data)
    return true;
  if (rhs.iframe_data < lhs.iframe_data)
    return false;
  if (lhs.table_row_data < rhs.table_row_data)
    return true;
  if (rhs.table_row_data < lhs.table_row_data)
    return false;
  if (lhs.annotated_roles < rhs.annotated_roles)
    return true;
  if (rhs.annotated_roles < lhs.annotated_roles)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.aria_role < rhs.aria_role)
    return true;
  if (rhs.aria_role < lhs.aria_role)
    return false;
  if (lhs.label_for_dom_node_id < rhs.label_for_dom_node_id)
    return true;
  if (rhs.label_for_dom_node_id < lhs.label_for_dom_node_id)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentNodePtr AIPageContentNode::Clone() const {
  return New(
      mojo::Clone(children_nodes),
      mojo::Clone(content_attributes)
  );
}

template <typename T, AIPageContentNode::EnableIfSame<T>*>
bool AIPageContentNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->children_nodes, other_struct.children_nodes))
    return false;
  if (!mojo::Equals(this->content_attributes, other_struct.content_attributes))
    return false;
  return true;
}

template <typename T, AIPageContentNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.children_nodes < rhs.children_nodes)
    return true;
  if (rhs.children_nodes < lhs.children_nodes)
    return false;
  if (lhs.content_attributes < rhs.content_attributes)
    return true;
  if (rhs.content_attributes < lhs.content_attributes)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentPtr AIPageContent::Clone() const {
  return New(
      mojo::Clone(root_node),
      mojo::Clone(page_interaction_info),
      mojo::Clone(frame_data)
  );
}

template <typename T, AIPageContent::EnableIfSame<T>*>
bool AIPageContent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->root_node, other_struct.root_node))
    return false;
  if (!mojo::Equals(this->page_interaction_info, other_struct.page_interaction_info))
    return false;
  if (!mojo::Equals(this->frame_data, other_struct.frame_data))
    return false;
  return true;
}

template <typename T, AIPageContent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.root_node < rhs.root_node)
    return true;
  if (rhs.root_node < lhs.root_node)
    return false;
  if (lhs.page_interaction_info < rhs.page_interaction_info)
    return true;
  if (rhs.page_interaction_info < lhs.page_interaction_info)
    return false;
  if (lhs.frame_data < rhs.frame_data)
    return true;
  if (rhs.frame_data < lhs.frame_data)
    return false;
  return false;
}
template <typename StructPtrType>
AIPageContentOptionsPtr AIPageContentOptions::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(on_critical_path),
      mojo::Clone(max_meta_elements),
      mojo::Clone(include_same_site_only)
  );
}

template <typename T, AIPageContentOptions::EnableIfSame<T>*>
bool AIPageContentOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->on_critical_path, other_struct.on_critical_path))
    return false;
  if (!mojo::Equals(this->max_meta_elements, other_struct.max_meta_elements))
    return false;
  if (!mojo::Equals(this->include_same_site_only, other_struct.include_same_site_only))
    return false;
  return true;
}

template <typename T, AIPageContentOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.on_critical_path < rhs.on_critical_path)
    return true;
  if (rhs.on_critical_path < lhs.on_critical_path)
    return false;
  if (lhs.max_meta_elements < rhs.max_meta_elements)
    return true;
  if (rhs.max_meta_elements < lhs.max_meta_elements)
    return false;
  if (lhs.include_same_site_only < rhs.include_same_site_only)
    return true;
  if (rhs.include_same_site_only < lhs.include_same_site_only)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentGeometry::DataView,
                                         ::blink::mojom::blink::AIPageContentGeometryPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentGeometryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentGeometryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentGeometry::outer_bounding_box)& outer_bounding_box(
      const ::blink::mojom::blink::AIPageContentGeometryPtr& input) {
    return input->outer_bounding_box;
  }

  static const decltype(::blink::mojom::blink::AIPageContentGeometry::visible_bounding_box)& visible_bounding_box(
      const ::blink::mojom::blink::AIPageContentGeometryPtr& input) {
    return input->visible_bounding_box;
  }

  static const decltype(::blink::mojom::blink::AIPageContentGeometry::fragment_visible_bounding_boxes)& fragment_visible_bounding_boxes(
      const ::blink::mojom::blink::AIPageContentGeometryPtr& input) {
    return input->fragment_visible_bounding_boxes;
  }

  static decltype(::blink::mojom::blink::AIPageContentGeometry::is_fixed_or_sticky_position) is_fixed_or_sticky_position(
      const ::blink::mojom::blink::AIPageContentGeometryPtr& input) {
    return input->is_fixed_or_sticky_position;
  }

  static bool Read(::blink::mojom::blink::AIPageContentGeometry::DataView input, ::blink::mojom::blink::AIPageContentGeometryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentSelection::DataView,
                                         ::blink::mojom::blink::AIPageContentSelectionPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentSelectionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentSelectionPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentSelection::start_dom_node_id) start_dom_node_id(
      const ::blink::mojom::blink::AIPageContentSelectionPtr& input) {
    return input->start_dom_node_id;
  }

  static decltype(::blink::mojom::blink::AIPageContentSelection::start_offset) start_offset(
      const ::blink::mojom::blink::AIPageContentSelectionPtr& input) {
    return input->start_offset;
  }

  static decltype(::blink::mojom::blink::AIPageContentSelection::end_dom_node_id) end_dom_node_id(
      const ::blink::mojom::blink::AIPageContentSelectionPtr& input) {
    return input->end_dom_node_id;
  }

  static decltype(::blink::mojom::blink::AIPageContentSelection::end_offset) end_offset(
      const ::blink::mojom::blink::AIPageContentSelectionPtr& input) {
    return input->end_offset;
  }

  static const decltype(::blink::mojom::blink::AIPageContentSelection::selected_text)& selected_text(
      const ::blink::mojom::blink::AIPageContentSelectionPtr& input) {
    return input->selected_text;
  }

  static bool Read(::blink::mojom::blink::AIPageContentSelection::DataView input, ::blink::mojom::blink::AIPageContentSelectionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentPageInteractionInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentPageInteractionInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentPageInteractionInfo::focused_dom_node_id) focused_dom_node_id(
      const ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr& input) {
    return input->focused_dom_node_id;
  }

  static decltype(::blink::mojom::blink::AIPageContentPageInteractionInfo::accessibility_focused_dom_node_id) accessibility_focused_dom_node_id(
      const ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr& input) {
    return input->accessibility_focused_dom_node_id;
  }

  static const decltype(::blink::mojom::blink::AIPageContentPageInteractionInfo::mouse_position)& mouse_position(
      const ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr& input) {
    return input->mouse_position;
  }

  static bool Read(::blink::mojom::blink::AIPageContentPageInteractionInfo::DataView input, ::blink::mojom::blink::AIPageContentPageInteractionInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentFrameInteractionInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentFrameInteractionInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentFrameInteractionInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentFrameInteractionInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentFrameInteractionInfo::selection)& selection(
      const ::blink::mojom::blink::AIPageContentFrameInteractionInfoPtr& input) {
    return input->selection;
  }

  static bool Read(::blink::mojom::blink::AIPageContentFrameInteractionInfo::DataView input, ::blink::mojom::blink::AIPageContentFrameInteractionInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentNodeInteractionInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentNodeInteractionInfo::scroller_info)& scroller_info(
      const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) {
    return input->scroller_info;
  }

  static decltype(::blink::mojom::blink::AIPageContentNodeInteractionInfo::is_focusable) is_focusable(
      const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) {
    return input->is_focusable;
  }

  static decltype(::blink::mojom::blink::AIPageContentNodeInteractionInfo::is_clickable) is_clickable(
      const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) {
    return input->is_clickable;
  }

  static decltype(::blink::mojom::blink::AIPageContentNodeInteractionInfo::document_scoped_z_order) document_scoped_z_order(
      const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) {
    return input->document_scoped_z_order;
  }

  static const decltype(::blink::mojom::blink::AIPageContentNodeInteractionInfo::clickability_reasons)& clickability_reasons(
      const ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr& input) {
    return input->clickability_reasons;
  }

  static bool Read(::blink::mojom::blink::AIPageContentNodeInteractionInfo::DataView input, ::blink::mojom::blink::AIPageContentNodeInteractionInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentScrollerInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentScrollerInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentScrollerInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentScrollerInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentScrollerInfo::scrolling_bounds)& scrolling_bounds(
      const ::blink::mojom::blink::AIPageContentScrollerInfoPtr& input) {
    return input->scrolling_bounds;
  }

  static const decltype(::blink::mojom::blink::AIPageContentScrollerInfo::visible_area)& visible_area(
      const ::blink::mojom::blink::AIPageContentScrollerInfoPtr& input) {
    return input->visible_area;
  }

  static decltype(::blink::mojom::blink::AIPageContentScrollerInfo::user_scrollable_horizontal) user_scrollable_horizontal(
      const ::blink::mojom::blink::AIPageContentScrollerInfoPtr& input) {
    return input->user_scrollable_horizontal;
  }

  static decltype(::blink::mojom::blink::AIPageContentScrollerInfo::user_scrollable_vertical) user_scrollable_vertical(
      const ::blink::mojom::blink::AIPageContentScrollerInfoPtr& input) {
    return input->user_scrollable_vertical;
  }

  static bool Read(::blink::mojom::blink::AIPageContentScrollerInfo::DataView input, ::blink::mojom::blink::AIPageContentScrollerInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentTextStyle::DataView,
                                         ::blink::mojom::blink::AIPageContentTextStylePtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentTextStylePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentTextStylePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentTextStyle::text_size) text_size(
      const ::blink::mojom::blink::AIPageContentTextStylePtr& input) {
    return input->text_size;
  }

  static decltype(::blink::mojom::blink::AIPageContentTextStyle::has_emphasis) has_emphasis(
      const ::blink::mojom::blink::AIPageContentTextStylePtr& input) {
    return input->has_emphasis;
  }

  static decltype(::blink::mojom::blink::AIPageContentTextStyle::color) color(
      const ::blink::mojom::blink::AIPageContentTextStylePtr& input) {
    return input->color;
  }

  static bool Read(::blink::mojom::blink::AIPageContentTextStyle::DataView input, ::blink::mojom::blink::AIPageContentTextStylePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentTextInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentTextInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentTextInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentTextInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentTextInfo::text_content)& text_content(
      const ::blink::mojom::blink::AIPageContentTextInfoPtr& input) {
    return input->text_content;
  }

  static const decltype(::blink::mojom::blink::AIPageContentTextInfo::text_style)& text_style(
      const ::blink::mojom::blink::AIPageContentTextInfoPtr& input) {
    return input->text_style;
  }

  static bool Read(::blink::mojom::blink::AIPageContentTextInfo::DataView input, ::blink::mojom::blink::AIPageContentTextInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentAnchorData::DataView,
                                         ::blink::mojom::blink::AIPageContentAnchorDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentAnchorDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentAnchorDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentAnchorData::url)& url(
      const ::blink::mojom::blink::AIPageContentAnchorDataPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAnchorData::rel)& rel(
      const ::blink::mojom::blink::AIPageContentAnchorDataPtr& input) {
    return input->rel;
  }

  static bool Read(::blink::mojom::blink::AIPageContentAnchorData::DataView input, ::blink::mojom::blink::AIPageContentAnchorDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentImageInfo::DataView,
                                         ::blink::mojom::blink::AIPageContentImageInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentImageInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentImageInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentImageInfo::image_caption)& image_caption(
      const ::blink::mojom::blink::AIPageContentImageInfoPtr& input) {
    return input->image_caption;
  }

  static const decltype(::blink::mojom::blink::AIPageContentImageInfo::source_origin)& source_origin(
      const ::blink::mojom::blink::AIPageContentImageInfoPtr& input) {
    return input->source_origin;
  }

  static bool Read(::blink::mojom::blink::AIPageContentImageInfo::DataView input, ::blink::mojom::blink::AIPageContentImageInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentSVGData::DataView,
                                         ::blink::mojom::blink::AIPageContentSVGDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentSVGDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentSVGDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentSVGData::inner_text)& inner_text(
      const ::blink::mojom::blink::AIPageContentSVGDataPtr& input) {
    return input->inner_text;
  }

  static bool Read(::blink::mojom::blink::AIPageContentSVGData::DataView input, ::blink::mojom::blink::AIPageContentSVGDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentCanvasData::DataView,
                                         ::blink::mojom::blink::AIPageContentCanvasDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentCanvasDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentCanvasDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentCanvasData::layout_size)& layout_size(
      const ::blink::mojom::blink::AIPageContentCanvasDataPtr& input) {
    return input->layout_size;
  }

  static bool Read(::blink::mojom::blink::AIPageContentCanvasData::DataView input, ::blink::mojom::blink::AIPageContentCanvasDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentVideoData::DataView,
                                         ::blink::mojom::blink::AIPageContentVideoDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentVideoDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentVideoDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentVideoData::url)& url(
      const ::blink::mojom::blink::AIPageContentVideoDataPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::AIPageContentVideoData::source_origin)& source_origin(
      const ::blink::mojom::blink::AIPageContentVideoDataPtr& input) {
    return input->source_origin;
  }

  static bool Read(::blink::mojom::blink::AIPageContentVideoData::DataView input, ::blink::mojom::blink::AIPageContentVideoDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentMeta::DataView,
                                         ::blink::mojom::blink::AIPageContentMetaPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentMetaPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentMetaPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentMeta::name)& name(
      const ::blink::mojom::blink::AIPageContentMetaPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::AIPageContentMeta::content)& content(
      const ::blink::mojom::blink::AIPageContentMetaPtr& input) {
    return input->content;
  }

  static bool Read(::blink::mojom::blink::AIPageContentMeta::DataView input, ::blink::mojom::blink::AIPageContentMetaPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentFrameData::DataView,
                                         ::blink::mojom::blink::AIPageContentFrameDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentFrameDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentFrameData::frame_interaction_info)& frame_interaction_info(
      const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) {
    return input->frame_interaction_info;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFrameData::meta_data)& meta_data(
      const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) {
    return input->meta_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFrameData::title)& title(
      const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) {
    return input->title;
  }

  static decltype(::blink::mojom::blink::AIPageContentFrameData::contains_paid_content) contains_paid_content(
      const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) {
    return input->contains_paid_content;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFrameData::script_tools)& script_tools(
      const ::blink::mojom::blink::AIPageContentFrameDataPtr& input) {
    return input->script_tools;
  }

  static bool Read(::blink::mojom::blink::AIPageContentFrameData::DataView input, ::blink::mojom::blink::AIPageContentFrameDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::RedactedFrameMetadata::DataView,
                                         ::blink::mojom::blink::RedactedFrameMetadataPtr> {
  static bool IsNull(const ::blink::mojom::blink::RedactedFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::RedactedFrameMetadataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::RedactedFrameMetadata::reason) reason(
      const ::blink::mojom::blink::RedactedFrameMetadataPtr& input) {
    return input->reason;
  }

  static bool Read(::blink::mojom::blink::RedactedFrameMetadata::DataView input, ::blink::mojom::blink::RedactedFrameMetadataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentIframeData::DataView,
                                         ::blink::mojom::blink::AIPageContentIframeDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentIframeDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentIframeDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentIframeData::frame_token)& frame_token(
      const ::blink::mojom::blink::AIPageContentIframeDataPtr& input) {
    return input->frame_token;
  }

  static decltype(::blink::mojom::blink::AIPageContentIframeData::likely_ad_frame) likely_ad_frame(
      const ::blink::mojom::blink::AIPageContentIframeDataPtr& input) {
    return input->likely_ad_frame;
  }

  static const decltype(::blink::mojom::blink::AIPageContentIframeData::content)& content(
      const ::blink::mojom::blink::AIPageContentIframeDataPtr& input) {
    return input->content;
  }

  static bool Read(::blink::mojom::blink::AIPageContentIframeData::DataView input, ::blink::mojom::blink::AIPageContentIframeDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentTableData::DataView,
                                         ::blink::mojom::blink::AIPageContentTableDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentTableDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentTableDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentTableData::table_name)& table_name(
      const ::blink::mojom::blink::AIPageContentTableDataPtr& input) {
    return input->table_name;
  }

  static bool Read(::blink::mojom::blink::AIPageContentTableData::DataView input, ::blink::mojom::blink::AIPageContentTableDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentTableRowData::DataView,
                                         ::blink::mojom::blink::AIPageContentTableRowDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentTableRowDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentTableRowDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentTableRowData::row_type) row_type(
      const ::blink::mojom::blink::AIPageContentTableRowDataPtr& input) {
    return input->row_type;
  }

  static bool Read(::blink::mojom::blink::AIPageContentTableRowData::DataView input, ::blink::mojom::blink::AIPageContentTableRowDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentFormData::DataView,
                                         ::blink::mojom::blink::AIPageContentFormDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentFormDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentFormDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentFormData::form_name)& form_name(
      const ::blink::mojom::blink::AIPageContentFormDataPtr& input) {
    return input->form_name;
  }

  static bool Read(::blink::mojom::blink::AIPageContentFormData::DataView input, ::blink::mojom::blink::AIPageContentFormDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentSelectOption::DataView,
                                         ::blink::mojom::blink::AIPageContentSelectOptionPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentSelectOptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentSelectOptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentSelectOption::value)& value(
      const ::blink::mojom::blink::AIPageContentSelectOptionPtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::blink::AIPageContentSelectOption::text)& text(
      const ::blink::mojom::blink::AIPageContentSelectOptionPtr& input) {
    return input->text;
  }

  static decltype(::blink::mojom::blink::AIPageContentSelectOption::is_selected) is_selected(
      const ::blink::mojom::blink::AIPageContentSelectOptionPtr& input) {
    return input->is_selected;
  }

  static decltype(::blink::mojom::blink::AIPageContentSelectOption::disabled) disabled(
      const ::blink::mojom::blink::AIPageContentSelectOptionPtr& input) {
    return input->disabled;
  }

  static bool Read(::blink::mojom::blink::AIPageContentSelectOption::DataView input, ::blink::mojom::blink::AIPageContentSelectOptionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentFormControlData::DataView,
                                         ::blink::mojom::blink::AIPageContentFormControlDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentFormControlDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentFormControlData::form_control_type) form_control_type(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->form_control_type;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFormControlData::field_name)& field_name(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->field_name;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFormControlData::field_value)& field_value(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->field_value;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFormControlData::select_options)& select_options(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->select_options;
  }

  static const decltype(::blink::mojom::blink::AIPageContentFormControlData::placeholder)& placeholder(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->placeholder;
  }

  static decltype(::blink::mojom::blink::AIPageContentFormControlData::is_checked) is_checked(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->is_checked;
  }

  static decltype(::blink::mojom::blink::AIPageContentFormControlData::is_required) is_required(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->is_required;
  }

  static decltype(::blink::mojom::blink::AIPageContentFormControlData::redaction_decision) redaction_decision(
      const ::blink::mojom::blink::AIPageContentFormControlDataPtr& input) {
    return input->redaction_decision;
  }

  static bool Read(::blink::mojom::blink::AIPageContentFormControlData::DataView input, ::blink::mojom::blink::AIPageContentFormControlDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentAttributes::DataView,
                                         ::blink::mojom::blink::AIPageContentAttributesPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentAttributesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentAttributes::dom_node_id) dom_node_id(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->dom_node_id;
  }

  static decltype(::blink::mojom::blink::AIPageContentAttributes::attribute_type) attribute_type(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->attribute_type;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::geometry)& geometry(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->geometry;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::node_interaction_info)& node_interaction_info(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->node_interaction_info;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::text_info)& text_info(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->text_info;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::image_info)& image_info(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->image_info;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::svg_data)& svg_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->svg_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::canvas_data)& canvas_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->canvas_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::video_data)& video_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->video_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::anchor_data)& anchor_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->anchor_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::form_data)& form_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->form_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::form_control_data)& form_control_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->form_control_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::table_data)& table_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->table_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::iframe_data)& iframe_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->iframe_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::table_row_data)& table_row_data(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->table_row_data;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::annotated_roles)& annotated_roles(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->annotated_roles;
  }

  static const decltype(::blink::mojom::blink::AIPageContentAttributes::label)& label(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->label;
  }

  static decltype(::blink::mojom::blink::AIPageContentAttributes::aria_role) aria_role(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->aria_role;
  }

  static decltype(::blink::mojom::blink::AIPageContentAttributes::label_for_dom_node_id) label_for_dom_node_id(
      const ::blink::mojom::blink::AIPageContentAttributesPtr& input) {
    return input->label_for_dom_node_id;
  }

  static bool Read(::blink::mojom::blink::AIPageContentAttributes::DataView input, ::blink::mojom::blink::AIPageContentAttributesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentNode::DataView,
                                         ::blink::mojom::blink::AIPageContentNodePtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentNodePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentNodePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContentNode::children_nodes)& children_nodes(
      const ::blink::mojom::blink::AIPageContentNodePtr& input) {
    return input->children_nodes;
  }

  static const decltype(::blink::mojom::blink::AIPageContentNode::content_attributes)& content_attributes(
      const ::blink::mojom::blink::AIPageContentNodePtr& input) {
    return input->content_attributes;
  }

  static bool Read(::blink::mojom::blink::AIPageContentNode::DataView input, ::blink::mojom::blink::AIPageContentNodePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContent::DataView,
                                         ::blink::mojom::blink::AIPageContentPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AIPageContent::root_node)& root_node(
      const ::blink::mojom::blink::AIPageContentPtr& input) {
    return input->root_node;
  }

  static const decltype(::blink::mojom::blink::AIPageContent::page_interaction_info)& page_interaction_info(
      const ::blink::mojom::blink::AIPageContentPtr& input) {
    return input->page_interaction_info;
  }

  static const decltype(::blink::mojom::blink::AIPageContent::frame_data)& frame_data(
      const ::blink::mojom::blink::AIPageContentPtr& input) {
    return input->frame_data;
  }

  static bool Read(::blink::mojom::blink::AIPageContent::DataView input, ::blink::mojom::blink::AIPageContentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AIPageContentOptions::DataView,
                                         ::blink::mojom::blink::AIPageContentOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AIPageContentOptions::mode) mode(
      const ::blink::mojom::blink::AIPageContentOptionsPtr& input) {
    return input->mode;
  }

  static decltype(::blink::mojom::blink::AIPageContentOptions::on_critical_path) on_critical_path(
      const ::blink::mojom::blink::AIPageContentOptionsPtr& input) {
    return input->on_critical_path;
  }

  static decltype(::blink::mojom::blink::AIPageContentOptions::max_meta_elements) max_meta_elements(
      const ::blink::mojom::blink::AIPageContentOptionsPtr& input) {
    return input->max_meta_elements;
  }

  static decltype(::blink::mojom::blink::AIPageContentOptions::include_same_site_only) include_same_site_only(
      const ::blink::mojom::blink::AIPageContentOptionsPtr& input) {
    return input->include_same_site_only;
  }

  static bool Read(::blink::mojom::blink::AIPageContentOptions::DataView input, ::blink::mojom::blink::AIPageContentOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AIPageContentIframeContent::DataView,
                                        ::blink::mojom::blink::AIPageContentIframeContentPtr> {
  static bool IsNull(const ::blink::mojom::blink::AIPageContentIframeContentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AIPageContentIframeContentPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AIPageContentIframeContent::Tag GetTag(const ::blink::mojom::blink::AIPageContentIframeContentPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::AIPageContentFrameDataPtr& local_frame_data(const ::blink::mojom::blink::AIPageContentIframeContentPtr& input) {
    return input->get_local_frame_data();
  }

  static const ::blink::mojom::blink::RedactedFrameMetadataPtr& redacted_frame_metadata(const ::blink::mojom::blink::AIPageContentIframeContentPtr& input) {
    return input->get_redacted_frame_metadata();
  }

  static bool Read(::blink::mojom::blink::AIPageContentIframeContent::DataView input, ::blink::mojom::blink::AIPageContentIframeContentPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_AI_PAGE_CONTENT_MOJOM_BLINK_H_