// third_party/blink/public/mojom/choosers/popup_menu.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"


namespace blink::mojom {
class MenuItemDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MenuItemDataView> {
  using Data = ::blink::mojom::internal::MenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class MenuItem_Type : int32_t {
  
  kOption = 0,
  
  kCheckableOption = 1,
  
  kGroup = 2,
  
  kSeparator = 3,
  
  kSubMenu = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MenuItem_Type value);
inline bool IsKnownEnumValue(MenuItem_Type value) {
  return internal::MenuItem_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PopupMenuClientInterfaceBase {};

using PopupMenuClientPtrDataView =
    mojo::InterfacePtrDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientRequestDataView =
    mojo::InterfaceRequestDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PopupMenuClientInterfaceBase>;


class MenuItemDataView {
 public:
  MenuItemDataView() = default;

  MenuItemDataView(
      internal::MenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLabel` instead "
    "of `ReadLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetToolTipDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToolTip(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `tool_tip` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadToolTip` instead "
    "of `ReadToolTip if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tool_tip.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MenuItem_Type>(
        data_value, output);
  }
  MenuItem_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MenuItem_Type>(data_->type));
  }
  uint32_t action() const {
    return data_->action;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection text_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction));
  }
  bool has_text_direction_override() const {
    return data_->has_text_direction_override;
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool checked() const {
    return data_->checked;
  }
 private:
  internal::MenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_DATA_VIEW_H_