// third_party/blink/public/mojom/choosers/file_chooser.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileChooserPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileChooser', scope);
  }
}

/** @interface */
export class FileChooserInterface {
  
  /**
   * @param { !FileChooserParams } params
   * @return {!Promise<{
        result: ?FileChooserResult,
   *  }>}
   */

  openFileChooser(params) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } directoryPath
   * @return {!Promise<{
        result: ?FileChooserResult,
   *  }>}
   */

  enumerateChosenDirectory(directoryPath) {}
}

/**
 * @implements { FileChooserInterface }
 */
export class FileChooserRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !FileChooserParams } params
   * @return {!Promise<{
        result: ?FileChooserResult,
   *  }>}
   */

  openFileChooser(
      params) {
    return this.proxy.sendMessage(
        0,
        FileChooser_OpenFileChooser_ParamsSpec.$,
        FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } directoryPath
   * @return {!Promise<{
        result: ?FileChooserResult,
   *  }>}
   */

  enumerateChosenDirectory(
      directoryPath) {
    return this.proxy.sendMessage(
        1,
        FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        [
          directoryPath
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileChooserReceiver {
  /**
   * @param {!FileChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileChooser_OpenFileChooser_ParamsSpec.$,
        FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        impl.openFileChooser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        impl.enumerateChosenDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileChooser {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileChooserRemote}
   */
  static getRemote() {
    let remote = new FileChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileChooserCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileChooser_OpenFileChooser_ParamsSpec.$,
        FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        this.openFileChooser.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateChosenDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        this.enumerateChosenDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooserParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NativeFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooserResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooser_OpenFileChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooser_OpenFileChooser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooser_EnumerateChosenDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileChooser_EnumerateChosenDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FileChooserFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FileChooserParams_ModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FileChooserParams_Mode = {
  
  kOpen: 0,
  kOpenMultiple: 1,
  kUploadFolder: 2,
  kOpenDirectory: 3,
  kSave: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


mojo.internal.Struct(
    FileChooserParamsSpec.$,
    'FileChooserParams',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        FileChooserParams_ModeSpec.$,
        FileChooserParams_Mode.kOpen,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultFileName', 16,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedFiles', 24,
        0,
        mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'acceptTypes', 32,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needLocalPath', 4,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useMediaCapture', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openWritable', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestor', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class FileChooserParams {
  constructor() {
    /** @type { !FileChooserParams_Mode } */
    this.mode;
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
    /** @type { !mojoBase_mojom_FilePath } */
    this.defaultFileName;
    /** @type { !Array<!mojoBase_mojom_FilePath> } */
    this.selectedFiles;
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.acceptTypes;
    /** @type { !boolean } */
    this.needLocalPath;
    /** @type { !boolean } */
    this.useMediaCapture;
    /** @type { !boolean } */
    this.openWritable;
    /** @type { !url_mojom_Url } */
    this.requestor;
  }
}



mojo.internal.Struct(
    NativeFileInfoSpec.$,
    'NativeFileInfo',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'baseSubdirs', 16,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NativeFileInfo {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.filePath;
    /** @type { !mojoBase_mojom_String16 } */
    this.displayName;
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.baseSubdirs;
  }
}



mojo.internal.Struct(
    FileSystemFileInfoSpec.$,
    'FileSystemFileInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modificationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        mojo.internal.Int64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemFileInfo {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_Time } */
    this.modificationTime;
    /** @type { !bigint } */
    this.length;
  }
}



mojo.internal.Struct(
    FileChooserResultSpec.$,
    'FileChooserResult',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(FileChooserFileInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'baseDirectory', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileChooserResult {
  constructor() {
    /** @type { !Array<!FileChooserFileInfo> } */
    this.files;
    /** @type { !mojoBase_mojom_FilePath } */
    this.baseDirectory;
  }
}



mojo.internal.Struct(
    FileChooser_OpenFileChooser_ParamsSpec.$,
    'FileChooser_OpenFileChooser_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        FileChooserParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileChooser_OpenFileChooser_Params {
  constructor() {
    /** @type { !FileChooserParams } */
    this.params;
  }
}



mojo.internal.Struct(
    FileChooser_OpenFileChooser_ResponseParamsSpec.$,
    'FileChooser_OpenFileChooser_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        FileChooserResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileChooser_OpenFileChooser_ResponseParams {
  constructor() {
    /** @type { (FileChooserResult|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
    'FileChooser_EnumerateChosenDirectory_Params',
    [
      mojo.internal.StructField(
        'directoryPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileChooser_EnumerateChosenDirectory_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.directoryPath;
  }
}



mojo.internal.Struct(
    FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
    'FileChooser_EnumerateChosenDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        FileChooserResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileChooser_EnumerateChosenDirectory_ResponseParams {
  constructor() {
    /** @type { (FileChooserResult|undefined) } */
    this.result;
  }
}

mojo.internal.Union(
    FileChooserFileInfoSpec.$, 'FileChooserFileInfo',
    {
      'nativeFile': {
        'ordinal': 0,
        'type': NativeFileInfoSpec.$,
      },
      'fileSystem': {
        'ordinal': 1,
        'type': FileSystemFileInfoSpec.$,
      },
    });

/**
 * @typedef { {
 *   nativeFile: (!NativeFileInfo|undefined),
 *   fileSystem: (!FileSystemFileInfo|undefined),
 * } }
 */
export const FileChooserFileInfo = {};
