// third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-params-data.h"
#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

CallStackGenerator::IPCStableHashFunction CallStackGenerator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CallStackGenerator>(message.name())) {
    case messages::CallStackGenerator::kCollectJavaScriptCallStack: {
      return &CallStackGenerator::CollectJavaScriptCallStack_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CallStackGenerator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CallStackGenerator>(message.name())) {
      case messages::CallStackGenerator::kCollectJavaScriptCallStack:
            return "Receive blink::mojom::CallStackGenerator::CollectJavaScriptCallStack";
    }
  } else {
    switch (static_cast<messages::CallStackGenerator>(message.name())) {
      case messages::CallStackGenerator::kCollectJavaScriptCallStack:
            return "Receive reply blink::mojom::CallStackGenerator::CollectJavaScriptCallStack";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CallStackGenerator::CollectJavaScriptCallStack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0882bbcf;  // IPCStableHash for blink::mojom::CallStackGenerator::CollectJavaScriptCallStack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback(
      CallStackGenerator::CollectJavaScriptCallStackCallback callback
      ) : callback_(std::move(callback)) {
  }

  CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback(const CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback&) = delete;
  CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback& operator=(const CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CallStackGenerator::CollectJavaScriptCallStackCallback callback_;
};

CallStackGeneratorProxy::CallStackGeneratorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CallStackGeneratorProxy::CollectJavaScriptCallStack(
    CollectJavaScriptCallStackCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::CallStackGenerator::CollectJavaScriptCallStack");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CallStackGenerator::kCollectJavaScriptCallStack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CallStackGenerator_CollectJavaScriptCallStack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CallStackGenerator::Name_);
  message.set_method_name("CollectJavaScriptCallStack");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CallStackGenerator::CollectJavaScriptCallStackCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder> proxy(
        new CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CallStackGenerator::CollectJavaScriptCallStackCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_javascript_call_stack, const std::optional<::blink::LocalFrameToken>& in_frame_token);
};

bool CallStackGenerator_CollectJavaScriptCallStack_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CallStackGenerator_CollectJavaScriptCallStack_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CallStackGenerator_CollectJavaScriptCallStack_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CallStackGenerator.0
  bool success = true;
  ::blink::String p_javascript_call_stack{};
  std::optional<::blink::LocalFrameToken> p_frame_token{};
  CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadJavascriptCallStack(&p_javascript_call_stack))
    success = false;
  if (success && !input_data_view.ReadFrameToken(&p_frame_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CallStackGenerator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_javascript_call_stack), 
std::move(p_frame_token));
  }
  return true;
}

void CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder::Run(
    const ::blink::String& in_javascript_call_stack, const std::optional<::blink::LocalFrameToken>& in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CallStackGenerator::CollectJavaScriptCallStack", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("javascript_call_stack"), in_javascript_call_stack,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const std::optional<::blink::LocalFrameToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CallStackGenerator::kCollectJavaScriptCallStack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CallStackGenerator_CollectJavaScriptCallStack_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->javascript_call_stack)::BaseType> javascript_call_stack_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_javascript_call_stack,
    javascript_call_stack_fragment);

  params->javascript_call_stack.Set(
      javascript_call_stack_fragment.is_null() ? nullptr : javascript_call_stack_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->javascript_call_stack.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null javascript_call_stack in ");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CallStackGenerator::Name_);
  message.set_method_name("CollectJavaScriptCallStack");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CallStackGeneratorStubDispatch::Accept(
    CallStackGenerator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CallStackGenerator>(message->header()->name)) {
    case messages::CallStackGenerator::kCollectJavaScriptCallStack: {
      break;
    }
  }
  return false;
}

// static
bool CallStackGeneratorStubDispatch::AcceptWithResponder(
    CallStackGenerator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CallStackGenerator>(message->header()->name)) {
    case messages::CallStackGenerator::kCollectJavaScriptCallStack: {
      internal::CallStackGenerator_CollectJavaScriptCallStack_Params_Data* params =
          reinterpret_cast<
              internal::CallStackGenerator_CollectJavaScriptCallStack_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CallStackGenerator.0
      bool success = true;
      CallStackGenerator_CollectJavaScriptCallStack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CallStackGenerator::Name_, 0, false);
        return false;
      }
      auto callback =
          CallStackGenerator_CollectJavaScriptCallStack_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CollectJavaScriptCallStack(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCallStackGeneratorValidationInfo[] = {
    { &internal::CallStackGenerator_CollectJavaScriptCallStack_Params_Data::Validate,
     &internal::CallStackGenerator_CollectJavaScriptCallStack_ResponseParams_Data::Validate},
};

bool CallStackGeneratorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::CallStackGenerator::Name_,
    kCallStackGeneratorValidationInfo);
}

bool CallStackGeneratorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::CallStackGenerator::Name_,
    kCallStackGeneratorValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void CallStackGeneratorInterceptorForTesting::CollectJavaScriptCallStack(CollectJavaScriptCallStackCallback callback) {
  GetForwardingInterface()->CollectJavaScriptCallStack(std::move(callback));
}
CallStackGeneratorAsyncWaiter::CallStackGeneratorAsyncWaiter(
    CallStackGenerator* proxy) : proxy_(proxy) {}

CallStackGeneratorAsyncWaiter::~CallStackGeneratorAsyncWaiter() = default;


void CallStackGeneratorAsyncWaiter::CollectJavaScriptCallStack(
    ::blink::String* out_javascript_call_stack, std::optional<::blink::LocalFrameToken>* out_frame_token) {
  base::RunLoop loop;
  proxy_->CollectJavaScriptCallStack(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_javascript_call_stack
,
             std::optional<::blink::LocalFrameToken>* out_frame_token
,
             const ::blink::String& javascript_call_stack,
             const std::optional<::blink::LocalFrameToken>& frame_token) {*out_javascript_call_stack = std::move(javascript_call_stack);*out_frame_token = std::move(frame_token);
            loop->Quit();
          },
          &loop,
          out_javascript_call_stack,
          out_frame_token));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif