// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-params-data.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/renderer/platform/loader/fetch/fetch_api_request_body_mojom_traits.h"


namespace blink::mojom::blink {
CacheStorageVerboseError::CacheStorageVerboseError()
    : value(),
      message() {}

CacheStorageVerboseError::CacheStorageVerboseError(
    CacheStorageError value_in,
    const ::blink::String& message_in)
    : value(std::move(value_in)),
      message(std::move(message_in)) {}

CacheStorageVerboseError::~CacheStorageVerboseError() = default;

void CacheStorageVerboseError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CacheStorageError>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CacheStorageVerboseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CacheQueryOptions::CacheQueryOptions()
    : ignore_search(false),
      ignore_method(false),
      ignore_vary(false) {}

CacheQueryOptions::CacheQueryOptions(
    bool ignore_search_in,
    bool ignore_method_in,
    bool ignore_vary_in)
    : ignore_search(std::move(ignore_search_in)),
      ignore_method(std::move(ignore_method_in)),
      ignore_vary(std::move(ignore_vary_in)) {}

CacheQueryOptions::~CacheQueryOptions() = default;
size_t CacheQueryOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->ignore_search);
  seed = mojo::internal::WTFHash(seed, this->ignore_method);
  seed = mojo::internal::WTFHash(seed, this->ignore_vary);
  return seed;
}

void CacheQueryOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_search"), this->ignore_search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_method"), this->ignore_method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_vary"), this->ignore_vary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CacheQueryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MultiCacheQueryOptions::MultiCacheQueryOptions()
    : query_options(),
      cache_name() {}

MultiCacheQueryOptions::MultiCacheQueryOptions(
    CacheQueryOptionsPtr query_options_in,
    const ::blink::String& cache_name_in)
    : query_options(std::move(query_options_in)),
      cache_name(std::move(cache_name_in)) {}

MultiCacheQueryOptions::~MultiCacheQueryOptions() = default;

void MultiCacheQueryOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query_options"), this->query_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CacheQueryOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_name"), this->cache_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MultiCacheQueryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BatchOperation::BatchOperation()
    : operation_type(),
      request(),
      response(),
      match_options() {}

BatchOperation::BatchOperation(
    OperationType operation_type_in,
    ::blink::mojom::blink::FetchAPIRequestPtr request_in,
    ::blink::mojom::blink::FetchAPIResponsePtr response_in,
    CacheQueryOptionsPtr match_options_in)
    : operation_type(std::move(operation_type_in)),
      request(std::move(request_in)),
      response(std::move(response_in)),
      match_options(std::move(match_options_in)) {}

BatchOperation::~BatchOperation() = default;

void BatchOperation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation_type"), this->operation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OperationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_options"), this->match_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CacheQueryOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BatchOperation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EagerResponse::EagerResponse()
    : response(),
      pipe(),
      client_receiver() {}

EagerResponse::EagerResponse(
    ::blink::mojom::blink::FetchAPIResponsePtr response_in,
    ::mojo::ScopedDataPipeConsumerHandle pipe_in,
    ::mojo::PendingReceiver<::blink::mojom::blink::BlobReaderClient> client_receiver_in)
    : response(std::move(response_in)),
      pipe(std::move(pipe_in)),
      client_receiver(std::move(client_receiver_in)) {}

EagerResponse::~EagerResponse() = default;

void EagerResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pipe"), this->pipe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::BlobReaderClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EagerResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CacheEntry::CacheEntry()
    : request(),
      response() {}

CacheEntry::CacheEntry(
    ::blink::mojom::blink::FetchAPIRequestPtr request_in,
    ::blink::mojom::blink::FetchAPIResponsePtr response_in)
    : request(std::move(request_in)),
      response(std::move(response_in)) {}

CacheEntry::~CacheEntry() = default;

void CacheEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::FetchAPIResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CacheEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MatchResponsePtr
MatchResponse::NewResponse(
    ::blink::mojom::blink::FetchAPIResponsePtr value) {
  return MatchResponsePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kResponse)>,
      std::move(value));
}

MatchResponsePtr
MatchResponse::NewEagerResponse(
    EagerResponsePtr value) {
  return MatchResponsePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEagerResponse)>,
      std::move(value));
}

MatchResponse::MatchResponse(
    std::in_place_index_t<static_cast<size_t>(Tag::kResponse)>,
    ::blink::mojom::blink::FetchAPIResponsePtr value)
    : tag_(Tag::kResponse),
      data_(std::in_place_index<static_cast<size_t>(Tag::kResponse)>,
            std::move(value)) {}

MatchResponse::MatchResponse(
    std::in_place_index_t<static_cast<size_t>(Tag::kEagerResponse)>,
    EagerResponsePtr value)
    : tag_(Tag::kEagerResponse),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEagerResponse)>,
            std::move(value)) {}
MatchResponse::~MatchResponse() {
  DestroyActive();
}

void MatchResponse::set_response(::blink::mojom::blink::FetchAPIResponsePtr response) {
  if (tag_ == Tag::kResponse) {
    data_.response = std::move(response);
  } else {
    DestroyActive();
    tag_ = Tag::kResponse;
    new (&data_.response) ::blink::mojom::blink::FetchAPIResponsePtr(
        std::move(response));
  }
}

void MatchResponse::set_eager_response(EagerResponsePtr eager_response) {
  if (tag_ == Tag::kEagerResponse) {
    data_.eager_response = std::move(eager_response);
  } else {
    DestroyActive();
    tag_ = Tag::kEagerResponse;
    new (&data_.eager_response) EagerResponsePtr(
        std::move(eager_response));
  }
}


MatchResponse::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kResponse)>,
    ::blink::mojom::blink::FetchAPIResponsePtr value)
    : response(std::move(value)) {}

MatchResponse::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEagerResponse)>,
    EagerResponsePtr value)
    : eager_response(std::move(value)) {}

void MatchResponse::DestroyActive() {
  switch (tag_) {

    case Tag::kResponse:
      std::destroy_at(&data_.response);
      break;
    case Tag::kEagerResponse:
      std::destroy_at(&data_.eager_response);
      break;
  }
}

bool MatchResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorageCache_Match_ResponseParam_ResultPtr
CacheStorageCache_Match_ResponseParam_Result::NewSuccess(
    MatchResponsePtr value) {
  return CacheStorageCache_Match_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorageCache_Match_ResponseParam_ResultPtr
CacheStorageCache_Match_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorageCache_Match_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorageCache_Match_ResponseParam_Result::CacheStorageCache_Match_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    MatchResponsePtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorageCache_Match_ResponseParam_Result::CacheStorageCache_Match_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorageCache_Match_ResponseParam_Result::~CacheStorageCache_Match_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorageCache_Match_ResponseParam_Result::set_success(MatchResponsePtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) MatchResponsePtr(
        std::move(success));
  }
}

void CacheStorageCache_Match_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorageCache_Match_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    MatchResponsePtr value)
    : success(std::move(value)) {}

CacheStorageCache_Match_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorageCache_Match_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorageCache_Match_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorageCache_MatchAll_ResponseParam_ResultPtr
CacheStorageCache_MatchAll_ResponseParam_Result::NewSuccess(
    ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value) {
  return CacheStorageCache_MatchAll_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorageCache_MatchAll_ResponseParam_ResultPtr
CacheStorageCache_MatchAll_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorageCache_MatchAll_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorageCache_MatchAll_ResponseParam_Result::CacheStorageCache_MatchAll_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorageCache_MatchAll_ResponseParam_Result::CacheStorageCache_MatchAll_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorageCache_MatchAll_ResponseParam_Result::~CacheStorageCache_MatchAll_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorageCache_MatchAll_ResponseParam_Result::set_success(::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>(
        std::move(success));
  }
}

void CacheStorageCache_MatchAll_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorageCache_MatchAll_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value)
    : success(std::move(value)) {}

CacheStorageCache_MatchAll_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorageCache_MatchAll_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorageCache_MatchAll_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr
CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::NewSuccess(
    ::blink::Vector<CacheEntryPtr> value) {
  return CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr
CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<CacheEntryPtr> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::~CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::set_success(::blink::Vector<CacheEntryPtr> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::Vector<CacheEntryPtr>(
        std::move(success));
  }
}

void CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<CacheEntryPtr> value)
    : success(std::move(value)) {}

CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorageCache_Keys_ResponseParam_ResultPtr
CacheStorageCache_Keys_ResponseParam_Result::NewSuccess(
    ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value) {
  return CacheStorageCache_Keys_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorageCache_Keys_ResponseParam_ResultPtr
CacheStorageCache_Keys_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorageCache_Keys_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorageCache_Keys_ResponseParam_Result::CacheStorageCache_Keys_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorageCache_Keys_ResponseParam_Result::CacheStorageCache_Keys_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorageCache_Keys_ResponseParam_Result::~CacheStorageCache_Keys_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorageCache_Keys_ResponseParam_Result::set_success(::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>(
        std::move(success));
  }
}

void CacheStorageCache_Keys_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorageCache_Keys_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value)
    : success(std::move(value)) {}

CacheStorageCache_Keys_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorageCache_Keys_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorageCache_Keys_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorage_Match_ResponseParam_ResultPtr
CacheStorage_Match_ResponseParam_Result::NewSuccess(
    MatchResponsePtr value) {
  return CacheStorage_Match_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorage_Match_ResponseParam_ResultPtr
CacheStorage_Match_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorage_Match_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorage_Match_ResponseParam_Result::CacheStorage_Match_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    MatchResponsePtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorage_Match_ResponseParam_Result::CacheStorage_Match_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorage_Match_ResponseParam_Result::~CacheStorage_Match_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorage_Match_ResponseParam_Result::set_success(MatchResponsePtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) MatchResponsePtr(
        std::move(success));
  }
}

void CacheStorage_Match_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorage_Match_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    MatchResponsePtr value)
    : success(std::move(value)) {}

CacheStorage_Match_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorage_Match_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorage_Match_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheStorage_Open_ResponseParam_ResultPtr
CacheStorage_Open_ResponseParam_Result::NewSuccess(
    ::mojo::PendingAssociatedRemote<CacheStorageCache> value) {
  return CacheStorage_Open_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CacheStorage_Open_ResponseParam_ResultPtr
CacheStorage_Open_ResponseParam_Result::NewFailure(
    CacheStorageError value) {
  return CacheStorage_Open_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CacheStorage_Open_ResponseParam_Result::CacheStorage_Open_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::mojo::PendingAssociatedRemote<CacheStorageCache> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CacheStorage_Open_ResponseParam_Result::CacheStorage_Open_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
CacheStorage_Open_ResponseParam_Result::~CacheStorage_Open_ResponseParam_Result() {
  DestroyActive();
}

void CacheStorage_Open_ResponseParam_Result::set_success(::mojo::PendingAssociatedRemote<CacheStorageCache> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::mojo::PendingAssociatedRemote<CacheStorageCache>(
        std::move(success));
  }
}

void CacheStorage_Open_ResponseParam_Result::set_failure(CacheStorageError failure) {
  if (tag_ != Tag::kFailure) {
    DestroyActive();
    tag_ = Tag::kFailure;
  }
  data_.failure = failure;
}


CacheStorage_Open_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::mojo::PendingAssociatedRemote<CacheStorageCache> value)
    : success(std::move(value)) {}

CacheStorage_Open_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    CacheStorageError value)
    : failure(std::move(value)) {}

void CacheStorage_Open_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool CacheStorage_Open_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

CacheStorageCache::IPCStableHashFunction CacheStorageCache::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CacheStorageCache>(message.name())) {
    case messages::CacheStorageCache::kMatch: {
      return &CacheStorageCache::Match_Sym::IPCStableHash;
    }
    case messages::CacheStorageCache::kMatchAll: {
      return &CacheStorageCache::MatchAll_Sym::IPCStableHash;
    }
    case messages::CacheStorageCache::kGetAllMatchedEntries: {
      return &CacheStorageCache::GetAllMatchedEntries_Sym::IPCStableHash;
    }
    case messages::CacheStorageCache::kKeys: {
      return &CacheStorageCache::Keys_Sym::IPCStableHash;
    }
    case messages::CacheStorageCache::kBatch: {
      return &CacheStorageCache::Batch_Sym::IPCStableHash;
    }
    case messages::CacheStorageCache::kWriteSideData: {
      return &CacheStorageCache::WriteSideData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CacheStorageCache::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CacheStorageCache>(message.name())) {
      case messages::CacheStorageCache::kMatch:
            return "Receive blink::mojom::CacheStorageCache::Match";
      case messages::CacheStorageCache::kMatchAll:
            return "Receive blink::mojom::CacheStorageCache::MatchAll";
      case messages::CacheStorageCache::kGetAllMatchedEntries:
            return "Receive blink::mojom::CacheStorageCache::GetAllMatchedEntries";
      case messages::CacheStorageCache::kKeys:
            return "Receive blink::mojom::CacheStorageCache::Keys";
      case messages::CacheStorageCache::kBatch:
            return "Receive blink::mojom::CacheStorageCache::Batch";
      case messages::CacheStorageCache::kWriteSideData:
            return "Receive blink::mojom::CacheStorageCache::WriteSideData";
    }
  } else {
    switch (static_cast<messages::CacheStorageCache>(message.name())) {
      case messages::CacheStorageCache::kMatch:
            return "Receive reply blink::mojom::CacheStorageCache::Match";
      case messages::CacheStorageCache::kMatchAll:
            return "Receive reply blink::mojom::CacheStorageCache::MatchAll";
      case messages::CacheStorageCache::kGetAllMatchedEntries:
            return "Receive reply blink::mojom::CacheStorageCache::GetAllMatchedEntries";
      case messages::CacheStorageCache::kKeys:
            return "Receive reply blink::mojom::CacheStorageCache::Keys";
      case messages::CacheStorageCache::kBatch:
            return "Receive reply blink::mojom::CacheStorageCache::Batch";
      case messages::CacheStorageCache::kWriteSideData:
            return "Receive reply blink::mojom::CacheStorageCache::WriteSideData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CacheStorageCache::Match_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9161ec8;  // IPCStableHash for blink::mojom::CacheStorageCache::Match
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageCache::MatchAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3b36e70;  // IPCStableHash for blink::mojom::CacheStorageCache::MatchAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageCache::GetAllMatchedEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce6e6f4c;  // IPCStableHash for blink::mojom::CacheStorageCache::GetAllMatchedEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageCache::Keys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d4d4401;  // IPCStableHash for blink::mojom::CacheStorageCache::Keys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageCache::Batch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c2bf9aa;  // IPCStableHash for blink::mojom::CacheStorageCache::Batch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageCache::WriteSideData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x267291ee;  // IPCStableHash for blink::mojom::CacheStorageCache::WriteSideData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CacheStorageCache_Match_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Match_ForwardToCallback(
      CacheStorageCache::MatchCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_Match_ForwardToCallback(const CacheStorageCache_Match_ForwardToCallback&) = delete;
  CacheStorageCache_Match_ForwardToCallback& operator=(const CacheStorageCache_Match_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::MatchCallback callback_;
};

class CacheStorageCache_MatchAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_MatchAll_ForwardToCallback(
      CacheStorageCache::MatchAllCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_MatchAll_ForwardToCallback(const CacheStorageCache_MatchAll_ForwardToCallback&) = delete;
  CacheStorageCache_MatchAll_ForwardToCallback& operator=(const CacheStorageCache_MatchAll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::MatchAllCallback callback_;
};

class CacheStorageCache_GetAllMatchedEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_GetAllMatchedEntries_ForwardToCallback(
      CacheStorageCache::GetAllMatchedEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_GetAllMatchedEntries_ForwardToCallback(const CacheStorageCache_GetAllMatchedEntries_ForwardToCallback&) = delete;
  CacheStorageCache_GetAllMatchedEntries_ForwardToCallback& operator=(const CacheStorageCache_GetAllMatchedEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::GetAllMatchedEntriesCallback callback_;
};

class CacheStorageCache_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Keys_ForwardToCallback(
      CacheStorageCache::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_Keys_ForwardToCallback(const CacheStorageCache_Keys_ForwardToCallback&) = delete;
  CacheStorageCache_Keys_ForwardToCallback& operator=(const CacheStorageCache_Keys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::KeysCallback callback_;
};

class CacheStorageCache_Batch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Batch_ForwardToCallback(
      CacheStorageCache::BatchCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_Batch_ForwardToCallback(const CacheStorageCache_Batch_ForwardToCallback&) = delete;
  CacheStorageCache_Batch_ForwardToCallback& operator=(const CacheStorageCache_Batch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::BatchCallback callback_;
};

class CacheStorageCache_WriteSideData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_WriteSideData_ForwardToCallback(
      CacheStorageCache::WriteSideDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorageCache_WriteSideData_ForwardToCallback(const CacheStorageCache_WriteSideData_ForwardToCallback&) = delete;
  CacheStorageCache_WriteSideData_ForwardToCallback& operator=(const CacheStorageCache_WriteSideData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::WriteSideDataCallback callback_;
};

CacheStorageCacheProxy::CacheStorageCacheProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageCacheProxy::Match(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, bool in_in_related_fetch_event, bool in_in_range_fetch_event, int64_t in_trace_id, MatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::Match", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_options"), in_query_options,
                        "<value of type CacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_related_fetch_event"), in_in_related_fetch_event,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_range_fetch_event"), in_in_range_fetch_event,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Match_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in CacheStorageCache.Match request");
  mojo::internal::MessageFragment<
      typename decltype(params->query_options)::BaseType> query_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
    in_query_options,
    query_options_fragment);

  params->query_options.Set(
      query_options_fragment.is_null() ? nullptr : query_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query_options in CacheStorageCache.Match request");

  params->in_related_fetch_event = in_in_related_fetch_event;

  params->in_range_fetch_event = in_in_range_fetch_event;

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Match");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Match_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageCacheProxy::MatchAll(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, int64_t in_trace_id, MatchAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::MatchAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_options"), in_query_options,
                        "<value of type CacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kMatchAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_MatchAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->query_options)::BaseType> query_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
    in_query_options,
    query_options_fragment);

  params->query_options.Set(
      query_options_fragment.is_null() ? nullptr : query_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query_options in CacheStorageCache.MatchAll request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("MatchAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_MatchAll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageCacheProxy::GetAllMatchedEntries(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, int64_t in_trace_id, GetAllMatchedEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::GetAllMatchedEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_options"), in_query_options,
                        "<value of type CacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kGetAllMatchedEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_GetAllMatchedEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->query_options)::BaseType> query_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
    in_query_options,
    query_options_fragment);

  params->query_options.Set(
      query_options_fragment.is_null() ? nullptr : query_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query_options in CacheStorageCache.GetAllMatchedEntries request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("GetAllMatchedEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_GetAllMatchedEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageCacheProxy::Keys(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, int64_t in_trace_id, KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::Keys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_options"), in_query_options,
                        "<value of type CacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Keys_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->query_options)::BaseType> query_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
    in_query_options,
    query_options_fragment);

  params->query_options.Set(
      query_options_fragment.is_null() ? nullptr : query_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query_options in CacheStorageCache.Keys request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Keys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageCacheProxy::Batch(
    ::blink::Vector<BatchOperationPtr> in_batch_operations, int64_t in_trace_id, BatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::Batch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("batch_operations"), in_batch_operations,
                        "<value of type ::blink::Vector<BatchOperationPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kBatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Batch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->batch_operations)::BaseType>
      batch_operations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& batch_operations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::BatchOperationDataView>>(
    in_batch_operations,
    batch_operations_fragment,
    &batch_operations_validate_params);

  params->batch_operations.Set(
      batch_operations_fragment.is_null() ? nullptr : batch_operations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->batch_operations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null batch_operations in CacheStorageCache.Batch request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Batch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Batch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageCacheProxy::WriteSideData(
    const ::blink::KURL& in_url, ::base::Time in_expected_response_time, ::mojo_base::BigBuffer in_data, int64_t in_trace_id, WriteSideDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorageCache::WriteSideData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_response_time"), in_expected_response_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kWriteSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_WriteSideData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CacheStorageCache.WriteSideData request");
  mojo::internal::MessageFragment<
      typename decltype(params->expected_response_time)::BaseType> expected_response_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expected_response_time,
    expected_response_time_fragment);

  params->expected_response_time.Set(
      expected_response_time_fragment.is_null() ? nullptr : expected_response_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->expected_response_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null expected_response_time in CacheStorageCache.WriteSideData request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in CacheStorageCache.WriteSideData request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("WriteSideData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_WriteSideData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CacheStorageCache_Match_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::MatchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_Match_ProxyToResponder> proxy(
        new CacheStorageCache_Match_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorageCache_Match_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorageCache_Match_ResponseParam_ResultPtr Transform(base::expected<
  MatchResponsePtr,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorageCache_Match_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_Match_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::MatchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageCache_Match_ResponseParam_ResultPtr in_result);
};

bool CacheStorageCache_Match_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Match_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Match_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.0
  bool success = true;
  CacheStorageCache_Match_ResponseParam_ResultPtr p_result{};
  CacheStorageCache_Match_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorageCache_Match_ProxyToResponder::Run(
    CacheStorageCache_Match_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::Match", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageCache_Match_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Match_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorageCache_Match_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Match");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_MatchAll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::MatchAllCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_MatchAll_ProxyToResponder> proxy(
        new CacheStorageCache_MatchAll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorageCache_MatchAll_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorageCache_MatchAll_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorageCache_MatchAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_MatchAll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::MatchAllCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageCache_MatchAll_ResponseParam_ResultPtr in_result);
};

bool CacheStorageCache_MatchAll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_MatchAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_MatchAll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.1
  bool success = true;
  CacheStorageCache_MatchAll_ResponseParam_ResultPtr p_result{};
  CacheStorageCache_MatchAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorageCache_MatchAll_ProxyToResponder::Run(
    CacheStorageCache_MatchAll_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::MatchAll", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageCache_MatchAll_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kMatchAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_MatchAll_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorageCache_MatchAll_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("MatchAll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_GetAllMatchedEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::GetAllMatchedEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_GetAllMatchedEntries_ProxyToResponder> proxy(
        new CacheStorageCache_GetAllMatchedEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorageCache_GetAllMatchedEntries_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::Vector<CacheEntryPtr>,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorageCache_GetAllMatchedEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_GetAllMatchedEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::GetAllMatchedEntriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr in_result);
};

bool CacheStorageCache_GetAllMatchedEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.2
  bool success = true;
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr p_result{};
  CacheStorageCache_GetAllMatchedEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorageCache_GetAllMatchedEntries_ProxyToResponder::Run(
    CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::GetAllMatchedEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kGetAllMatchedEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("GetAllMatchedEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_Keys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::KeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_Keys_ProxyToResponder> proxy(
        new CacheStorageCache_Keys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorageCache_Keys_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorageCache_Keys_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorageCache_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_Keys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::KeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageCache_Keys_ResponseParam_ResultPtr in_result);
};

bool CacheStorageCache_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.3
  bool success = true;
  CacheStorageCache_Keys_ResponseParam_ResultPtr p_result{};
  CacheStorageCache_Keys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorageCache_Keys_ProxyToResponder::Run(
    CacheStorageCache_Keys_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::Keys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageCache_Keys_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Keys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorageCache_Keys_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_Batch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::BatchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_Batch_ProxyToResponder> proxy(
        new CacheStorageCache_Batch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CacheStorageCache_Batch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_Batch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_Batch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::BatchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageVerboseErrorPtr in_result);
};

bool CacheStorageCache_Batch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Batch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Batch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.4
  bool success = true;
  CacheStorageVerboseErrorPtr p_result{};
  CacheStorageCache_Batch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CacheStorageCache_Batch_ProxyToResponder::Run(
    CacheStorageVerboseErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::Batch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageVerboseErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kBatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_Batch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CacheStorageVerboseErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Batch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_WriteSideData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorageCache::WriteSideDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorageCache_WriteSideData_ProxyToResponder> proxy(
        new CacheStorageCache_WriteSideData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CacheStorageCache_WriteSideData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_WriteSideData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorageCache_WriteSideData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorageCache::WriteSideDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageError in_result);
};

bool CacheStorageCache_WriteSideData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorageCache_WriteSideData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_WriteSideData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorageCache.5
  bool success = true;
  CacheStorageError p_result{};
  CacheStorageCache_WriteSideData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CacheStorageCache_WriteSideData_ProxyToResponder::Run(
    CacheStorageError in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorageCache::WriteSideData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageCache::kWriteSideData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorageCache_WriteSideData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("WriteSideData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CacheStorageCacheStubDispatch::Accept(
    CacheStorageCache* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CacheStorageCache>(message->header()->name)) {
    case messages::CacheStorageCache::kMatch: {
      break;
    }
    case messages::CacheStorageCache::kMatchAll: {
      break;
    }
    case messages::CacheStorageCache::kGetAllMatchedEntries: {
      break;
    }
    case messages::CacheStorageCache::kKeys: {
      break;
    }
    case messages::CacheStorageCache::kBatch: {
      break;
    }
    case messages::CacheStorageCache::kWriteSideData: {
      break;
    }
  }
  return false;
}

// static
bool CacheStorageCacheStubDispatch::AcceptWithResponder(
    CacheStorageCache* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CacheStorageCache>(message->header()->name)) {
    case messages::CacheStorageCache::kMatch: {
      internal::CacheStorageCache_Match_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Match_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.0
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      bool p_in_related_fetch_event{};
      bool p_in_range_fetch_event{};
      int64_t p_trace_id{};
      CacheStorageCache_Match_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_in_related_fetch_event = input_data_view.in_related_fetch_event();
      if (success)
        p_in_range_fetch_event = input_data_view.in_range_fetch_event();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 0, false);
        return false;
      }
      auto callback =
          CacheStorageCache_Match_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Match(        
        std::move(p_request), 
        std::move(p_query_options), 
        std::move(p_in_related_fetch_event), 
        std::move(p_in_range_fetch_event), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorageCache::kMatchAll: {
      internal::CacheStorageCache_MatchAll_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_MatchAll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.1
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      int64_t p_trace_id{};
      CacheStorageCache_MatchAll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 1, false);
        return false;
      }
      auto callback =
          CacheStorageCache_MatchAll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchAll(        
        std::move(p_request), 
        std::move(p_query_options), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorageCache::kGetAllMatchedEntries: {
      internal::CacheStorageCache_GetAllMatchedEntries_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_GetAllMatchedEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.2
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      int64_t p_trace_id{};
      CacheStorageCache_GetAllMatchedEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 2, false);
        return false;
      }
      auto callback =
          CacheStorageCache_GetAllMatchedEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllMatchedEntries(        
        std::move(p_request), 
        std::move(p_query_options), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorageCache::kKeys: {
      internal::CacheStorageCache_Keys_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Keys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.3
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      int64_t p_trace_id{};
      CacheStorageCache_Keys_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 3, false);
        return false;
      }
      auto callback =
          CacheStorageCache_Keys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(        
        std::move(p_request), 
        std::move(p_query_options), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorageCache::kBatch: {
      internal::CacheStorageCache_Batch_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Batch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.4
      bool success = true;
      ::blink::Vector<BatchOperationPtr> p_batch_operations{};
      int64_t p_trace_id{};
      CacheStorageCache_Batch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBatchOperations(&p_batch_operations))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 4, false);
        return false;
      }
      auto callback =
          CacheStorageCache_Batch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Batch(        
        std::move(p_batch_operations), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorageCache::kWriteSideData: {
      internal::CacheStorageCache_WriteSideData_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_WriteSideData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorageCache.5
      bool success = true;
      ::blink::KURL p_url{};
      ::base::Time p_expected_response_time{};
      ::mojo_base::BigBuffer p_data{};
      int64_t p_trace_id{};
      CacheStorageCache_WriteSideData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadExpectedResponseTime(&p_expected_response_time))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 5, false);
        return false;
      }
      auto callback =
          CacheStorageCache_WriteSideData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSideData(        
        std::move(p_url), 
        std::move(p_expected_response_time), 
        std::move(p_data), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCacheStorageCacheValidationInfo[] = {
    { &internal::CacheStorageCache_Match_Params_Data::Validate,
     &internal::CacheStorageCache_Match_ResponseParams_Data::Validate},
    { &internal::CacheStorageCache_MatchAll_Params_Data::Validate,
     &internal::CacheStorageCache_MatchAll_ResponseParams_Data::Validate},
    { &internal::CacheStorageCache_GetAllMatchedEntries_Params_Data::Validate,
     &internal::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data::Validate},
    { &internal::CacheStorageCache_Keys_Params_Data::Validate,
     &internal::CacheStorageCache_Keys_ResponseParams_Data::Validate},
    { &internal::CacheStorageCache_Batch_Params_Data::Validate,
     &internal::CacheStorageCache_Batch_ResponseParams_Data::Validate},
    { &internal::CacheStorageCache_WriteSideData_Params_Data::Validate,
     &internal::CacheStorageCache_WriteSideData_ResponseParams_Data::Validate},
};

bool CacheStorageCacheRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::CacheStorageCache::Name_,
    kCacheStorageCacheValidationInfo);
}

bool CacheStorageCacheResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::CacheStorageCache::Name_,
    kCacheStorageCacheValidationInfo);
}
// The declaration includes the definition on other builds.

CacheStorage::IPCStableHashFunction CacheStorage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CacheStorage>(message.name())) {
    case messages::CacheStorage::kHas: {
      return &CacheStorage::Has_Sym::IPCStableHash;
    }
    case messages::CacheStorage::kDelete: {
      return &CacheStorage::Delete_Sym::IPCStableHash;
    }
    case messages::CacheStorage::kKeys: {
      return &CacheStorage::Keys_Sym::IPCStableHash;
    }
    case messages::CacheStorage::kMatch: {
      return &CacheStorage::Match_Sym::IPCStableHash;
    }
    case messages::CacheStorage::kOpen: {
      return &CacheStorage::Open_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CacheStorage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CacheStorage>(message.name())) {
      case messages::CacheStorage::kHas:
            return "Receive blink::mojom::CacheStorage::Has";
      case messages::CacheStorage::kDelete:
            return "Receive blink::mojom::CacheStorage::Delete";
      case messages::CacheStorage::kKeys:
            return "Receive blink::mojom::CacheStorage::Keys";
      case messages::CacheStorage::kMatch:
            return "Receive blink::mojom::CacheStorage::Match";
      case messages::CacheStorage::kOpen:
            return "Receive blink::mojom::CacheStorage::Open";
    }
  } else {
    switch (static_cast<messages::CacheStorage>(message.name())) {
      case messages::CacheStorage::kHas:
            return "Receive reply blink::mojom::CacheStorage::Has";
      case messages::CacheStorage::kDelete:
            return "Receive reply blink::mojom::CacheStorage::Delete";
      case messages::CacheStorage::kKeys:
            return "Receive reply blink::mojom::CacheStorage::Keys";
      case messages::CacheStorage::kMatch:
            return "Receive reply blink::mojom::CacheStorage::Match";
      case messages::CacheStorage::kOpen:
            return "Receive reply blink::mojom::CacheStorage::Open";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CacheStorage::Has_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ae7cc7c;  // IPCStableHash for blink::mojom::CacheStorage::Has
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorage::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab990669;  // IPCStableHash for blink::mojom::CacheStorage::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorage::Keys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e2fad8b;  // IPCStableHash for blink::mojom::CacheStorage::Keys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorage::Match_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd5f8095;  // IPCStableHash for blink::mojom::CacheStorage::Match
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorage::Open_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa409f1e0;  // IPCStableHash for blink::mojom::CacheStorage::Open
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CacheStorage_Has_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Has_ForwardToCallback(
      CacheStorage::HasCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorage_Has_ForwardToCallback(const CacheStorage_Has_ForwardToCallback&) = delete;
  CacheStorage_Has_ForwardToCallback& operator=(const CacheStorage_Has_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::HasCallback callback_;
};

class CacheStorage_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Delete_ForwardToCallback(
      CacheStorage::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorage_Delete_ForwardToCallback(const CacheStorage_Delete_ForwardToCallback&) = delete;
  CacheStorage_Delete_ForwardToCallback& operator=(const CacheStorage_Delete_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::DeleteCallback callback_;
};

class CacheStorage_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Keys_ForwardToCallback(
      CacheStorage::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorage_Keys_ForwardToCallback(const CacheStorage_Keys_ForwardToCallback&) = delete;
  CacheStorage_Keys_ForwardToCallback& operator=(const CacheStorage_Keys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::KeysCallback callback_;
};

class CacheStorage_Match_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Match_ForwardToCallback(
      CacheStorage::MatchCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorage_Match_ForwardToCallback(const CacheStorage_Match_ForwardToCallback&) = delete;
  CacheStorage_Match_ForwardToCallback& operator=(const CacheStorage_Match_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::MatchCallback callback_;
};

class CacheStorage_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Open_ForwardToCallback(
      CacheStorage::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }

  CacheStorage_Open_ForwardToCallback(const CacheStorage_Open_ForwardToCallback&) = delete;
  CacheStorage_Open_ForwardToCallback& operator=(const CacheStorage_Open_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::OpenCallback callback_;
};

CacheStorageProxy::CacheStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageProxy::Has(
    const ::blink::String& in_cache_name, int64_t in_trace_id, HasCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorage::Has", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_name"), in_cache_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kHas), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Has_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cache_name)::BaseType> cache_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_cache_name,
    cache_name_fragment);

  params->cache_name.Set(
      cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_name in CacheStorage.Has request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Has");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Has_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageProxy::Delete(
    const ::blink::String& in_cache_name, int64_t in_trace_id, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorage::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_name"), in_cache_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cache_name)::BaseType> cache_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_cache_name,
    cache_name_fragment);

  params->cache_name.Set(
      cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_name in CacheStorage.Delete request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Delete_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageProxy::Keys(
    int64_t in_trace_id, KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorage::Keys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Keys_Params_Data> params(
          message);
  params.Allocate();

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Keys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageProxy::Match(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, MultiCacheQueryOptionsPtr in_match_options, bool in_in_related_fetch_event, bool in_in_range_fetch_event, int64_t in_trace_id, MatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorage::Match", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::blink::mojom::blink::FetchAPIRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("match_options"), in_match_options,
                        "<value of type MultiCacheQueryOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_related_fetch_event"), in_in_related_fetch_event,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_range_fetch_event"), in_in_range_fetch_event,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Match_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in CacheStorage.Match request");
  mojo::internal::MessageFragment<
      typename decltype(params->match_options)::BaseType> match_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MultiCacheQueryOptionsDataView>(
    in_match_options,
    match_options_fragment);

  params->match_options.Set(
      match_options_fragment.is_null() ? nullptr : match_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->match_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null match_options in CacheStorage.Match request");

  params->in_related_fetch_event = in_in_related_fetch_event;

  params->in_range_fetch_event = in_in_range_fetch_event;

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Match");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Match_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CacheStorageProxy::Open(
    const ::blink::String& in_cache_name, int64_t in_trace_id, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CacheStorage::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_name"), in_cache_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Open_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cache_name)::BaseType> cache_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_cache_name,
    cache_name_fragment);

  params->cache_name.Set(
      cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_name in CacheStorage.Open request");

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Open_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CacheStorage_Has_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorage::HasCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorage_Has_ProxyToResponder> proxy(
        new CacheStorage_Has_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CacheStorage_Has_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Has_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorage_Has_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorage::HasCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageError in_result);
};

bool CacheStorage_Has_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorage_Has_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Has_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorage.0
  bool success = true;
  CacheStorageError p_result{};
  CacheStorage_Has_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CacheStorage_Has_ProxyToResponder::Run(
    CacheStorageError in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorage::Has", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kHas), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Has_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Has");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Delete_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorage::DeleteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorage_Delete_ProxyToResponder> proxy(
        new CacheStorage_Delete_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CacheStorage_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorage_Delete_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorage::DeleteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageError in_result);
};

bool CacheStorage_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorage_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorage.1
  bool success = true;
  CacheStorageError p_result{};
  CacheStorage_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CacheStorage_Delete_ProxyToResponder::Run(
    CacheStorageError in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorage::Delete", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorageError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Keys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorage::KeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorage_Keys_ProxyToResponder> proxy(
        new CacheStorage_Keys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CacheStorage_Keys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorage_Keys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorage::KeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_keys);
};

bool CacheStorage_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorage_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorage.2
  bool success = true;
  ::blink::Vector<::blink::String> p_keys{};
  CacheStorage_Keys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_keys));
  }
  return true;
}

void CacheStorage_Keys_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorage::Keys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Keys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Match_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorage::MatchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorage_Match_ProxyToResponder> proxy(
        new CacheStorage_Match_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorage_Match_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorage_Match_ResponseParam_ResultPtr Transform(base::expected<
  MatchResponsePtr,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorage_Match_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorage_Match_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorage::MatchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorage_Match_ResponseParam_ResultPtr in_result);
};

bool CacheStorage_Match_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorage_Match_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Match_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorage.3
  bool success = true;
  CacheStorage_Match_ResponseParam_ResultPtr p_result{};
  CacheStorage_Match_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorage_Match_ProxyToResponder::Run(
    CacheStorage_Match_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorage::Match", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorage_Match_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Match_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorage_Match_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Match");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Open_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CacheStorage::OpenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CacheStorage_Open_ProxyToResponder> proxy(
        new CacheStorage_Open_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&CacheStorage_Open_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static CacheStorage_Open_ResponseParam_ResultPtr Transform(base::expected<
  ::mojo::PendingAssociatedRemote<CacheStorageCache>,
  CacheStorageError> in) {
    return in.has_value() ? ::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~CacheStorage_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CacheStorage_Open_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CacheStorage::OpenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorage_Open_ResponseParam_ResultPtr in_result);
};

bool CacheStorage_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CacheStorage_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Open_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CacheStorage.4
  bool success = true;
  CacheStorage_Open_ResponseParam_ResultPtr p_result{};
  CacheStorage_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void CacheStorage_Open_ProxyToResponder::Run(
    CacheStorage_Open_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::CacheStorage::Open", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CacheStorage_Open_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorage::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CacheStorage_Open_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CacheStorage_Open_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CacheStorageStubDispatch::Accept(
    CacheStorage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CacheStorage>(message->header()->name)) {
    case messages::CacheStorage::kHas: {
      break;
    }
    case messages::CacheStorage::kDelete: {
      break;
    }
    case messages::CacheStorage::kKeys: {
      break;
    }
    case messages::CacheStorage::kMatch: {
      break;
    }
    case messages::CacheStorage::kOpen: {
      break;
    }
  }
  return false;
}

// static
bool CacheStorageStubDispatch::AcceptWithResponder(
    CacheStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CacheStorage>(message->header()->name)) {
    case messages::CacheStorage::kHas: {
      internal::CacheStorage_Has_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Has_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorage.0
      bool success = true;
      ::blink::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Has_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 0, false);
        return false;
      }
      auto callback =
          CacheStorage_Has_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Has(        
        std::move(p_cache_name), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorage::kDelete: {
      internal::CacheStorage_Delete_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Delete_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorage.1
      bool success = true;
      ::blink::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 1, false);
        return false;
      }
      auto callback =
          CacheStorage_Delete_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        
        std::move(p_cache_name), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorage::kKeys: {
      internal::CacheStorage_Keys_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Keys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorage.2
      bool success = true;
      int64_t p_trace_id{};
      CacheStorage_Keys_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 2, false);
        return false;
      }
      auto callback =
          CacheStorage_Keys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(        
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorage::kMatch: {
      internal::CacheStorage_Match_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Match_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorage.3
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      MultiCacheQueryOptionsPtr p_match_options{};
      bool p_in_related_fetch_event{};
      bool p_in_range_fetch_event{};
      int64_t p_trace_id{};
      CacheStorage_Match_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadMatchOptions(&p_match_options))
        success = false;
      if (success)
        p_in_related_fetch_event = input_data_view.in_related_fetch_event();
      if (success)
        p_in_range_fetch_event = input_data_view.in_range_fetch_event();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 3, false);
        return false;
      }
      auto callback =
          CacheStorage_Match_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Match(        
        std::move(p_request), 
        std::move(p_match_options), 
        std::move(p_in_related_fetch_event), 
        std::move(p_in_range_fetch_event), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::CacheStorage::kOpen: {
      internal::CacheStorage_Open_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Open_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CacheStorage.4
      bool success = true;
      ::blink::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Open_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 4, false);
        return false;
      }
      auto callback =
          CacheStorage_Open_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(        
        std::move(p_cache_name), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCacheStorageValidationInfo[] = {
    { &internal::CacheStorage_Has_Params_Data::Validate,
     &internal::CacheStorage_Has_ResponseParams_Data::Validate},
    { &internal::CacheStorage_Delete_Params_Data::Validate,
     &internal::CacheStorage_Delete_ResponseParams_Data::Validate},
    { &internal::CacheStorage_Keys_Params_Data::Validate,
     &internal::CacheStorage_Keys_ResponseParams_Data::Validate},
    { &internal::CacheStorage_Match_Params_Data::Validate,
     &internal::CacheStorage_Match_ResponseParams_Data::Validate},
    { &internal::CacheStorage_Open_Params_Data::Validate,
     &internal::CacheStorage_Open_ResponseParams_Data::Validate},
};

bool CacheStorageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::CacheStorage::Name_,
    kCacheStorageValidationInfo);
}

bool CacheStorageResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::CacheStorage::Name_,
    kCacheStorageValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::CacheStorageVerboseError::DataView, ::blink::mojom::blink::CacheStorageVerboseErrorPtr>::Read(
    ::blink::mojom::blink::CacheStorageVerboseError::DataView input,
    ::blink::mojom::blink::CacheStorageVerboseErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CacheStorageVerboseErrorPtr result(::blink::mojom::blink::CacheStorageVerboseError::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CacheQueryOptions::DataView, ::blink::mojom::blink::CacheQueryOptionsPtr>::Read(
    ::blink::mojom::blink::CacheQueryOptions::DataView input,
    ::blink::mojom::blink::CacheQueryOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CacheQueryOptionsPtr result(::blink::mojom::blink::CacheQueryOptions::New());
  
      if (success)
        result->ignore_search = input.ignore_search();
      if (success)
        result->ignore_method = input.ignore_method();
      if (success)
        result->ignore_vary = input.ignore_vary();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MultiCacheQueryOptions::DataView, ::blink::mojom::blink::MultiCacheQueryOptionsPtr>::Read(
    ::blink::mojom::blink::MultiCacheQueryOptions::DataView input,
    ::blink::mojom::blink::MultiCacheQueryOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::MultiCacheQueryOptionsPtr result(::blink::mojom::blink::MultiCacheQueryOptions::New());
  
      if (success && !input.ReadQueryOptions(&result->query_options))
        success = false;
      if (success && !input.ReadCacheName(&result->cache_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BatchOperation::DataView, ::blink::mojom::blink::BatchOperationPtr>::Read(
    ::blink::mojom::blink::BatchOperation::DataView input,
    ::blink::mojom::blink::BatchOperationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BatchOperationPtr result(::blink::mojom::blink::BatchOperation::New());
  
      if (success && !input.ReadOperationType(&result->operation_type))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success && !input.ReadMatchOptions(&result->match_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::EagerResponse::DataView, ::blink::mojom::blink::EagerResponsePtr>::Read(
    ::blink::mojom::blink::EagerResponse::DataView input,
    ::blink::mojom::blink::EagerResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::EagerResponsePtr result(::blink::mojom::blink::EagerResponse::New());
  
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success)
        result->pipe = input.TakePipe();
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CacheEntry::DataView, ::blink::mojom::blink::CacheEntryPtr>::Read(
    ::blink::mojom::blink::CacheEntry::DataView input,
    ::blink::mojom::blink::CacheEntryPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CacheEntryPtr result(::blink::mojom::blink::CacheEntry::New());
  
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::MatchResponse::DataView, ::blink::mojom::blink::MatchResponsePtr>::Read(
    ::blink::mojom::blink::MatchResponse::DataView input,
    ::blink::mojom::blink::MatchResponsePtr* output) {
  using UnionType = ::blink::mojom::blink::MatchResponse;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kResponse: {
      ::blink::mojom::blink::FetchAPIResponsePtr result_response{};
      if (!input.ReadResponse(&result_response))
        return false;

      *output = UnionType::NewResponse(
          std::move(result_response));
      break;
    }
    case Tag::kEagerResponse: {
      ::blink::mojom::blink::EagerResponsePtr result_eager_response{};
      if (!input.ReadEagerResponse(&result_eager_response))
        return false;

      *output = UnionType::NewEagerResponse(
          std::move(result_eager_response));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::mojom::blink::MatchResponsePtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::Vector<::blink::mojom::blink::CacheEntryPtr> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::mojom::blink::MatchResponsePtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::DataView, ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      *output = UnionType::NewSuccess(
          input.TakeSuccess<::mojo::PendingAssociatedRemote<::blink::mojom::blink::CacheStorageCache>>());
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::CacheStorageError result_failure;
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(result_failure);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void CacheStorageCacheInterceptorForTesting::Match(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) {
  GetForwardingInterface()->Match(
    std::move(request)
    , 
    std::move(query_options)
    , 
    std::move(in_related_fetch_event)
    , 
    std::move(in_range_fetch_event)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageCacheInterceptorForTesting::MatchAll(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) {
  GetForwardingInterface()->MatchAll(
    std::move(request)
    , 
    std::move(query_options)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageCacheInterceptorForTesting::GetAllMatchedEntries(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) {
  GetForwardingInterface()->GetAllMatchedEntries(
    std::move(request)
    , 
    std::move(query_options)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageCacheInterceptorForTesting::Keys(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) {
  GetForwardingInterface()->Keys(
    std::move(request)
    , 
    std::move(query_options)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageCacheInterceptorForTesting::Batch(::blink::Vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) {
  GetForwardingInterface()->Batch(
    std::move(batch_operations)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageCacheInterceptorForTesting::WriteSideData(const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) {
  GetForwardingInterface()->WriteSideData(
    std::move(url)
    , 
    std::move(expected_response_time)
    , 
    std::move(data)
    , 
    std::move(trace_id)
    , std::move(callback));
}
CacheStorageCacheAsyncWaiter::CacheStorageCacheAsyncWaiter(
    CacheStorageCache* proxy) : proxy_(proxy) {}

CacheStorageCacheAsyncWaiter::~CacheStorageCacheAsyncWaiter() = default;


void CacheStorageCacheAsyncWaiter::Batch(
    ::blink::Vector<BatchOperationPtr> batch_operations, int64_t trace_id, CacheStorageVerboseErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Batch(
      std::move(batch_operations),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CacheStorageVerboseErrorPtr* out_result
,
             CacheStorageVerboseErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CacheStorageVerboseErrorPtr CacheStorageCacheAsyncWaiter::Batch(
    ::blink::Vector<BatchOperationPtr> batch_operations, int64_t trace_id) {
  CacheStorageVerboseErrorPtr async_wait_result;
  Batch(std::move(batch_operations),std::move(trace_id),&async_wait_result);
  return async_wait_result;
}

void CacheStorageCacheAsyncWaiter::WriteSideData(
    const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, CacheStorageError* out_result) {
  base::RunLoop loop;
  proxy_->WriteSideData(
      std::move(url),
      std::move(expected_response_time),
      std::move(data),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CacheStorageError* out_result
,
             CacheStorageError result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CacheStorageError CacheStorageCacheAsyncWaiter::WriteSideData(
    const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id) {
  CacheStorageError async_wait_result;
  WriteSideData(std::move(url),std::move(expected_response_time),std::move(data),std::move(trace_id),&async_wait_result);
  return async_wait_result;
}




void CacheStorageInterceptorForTesting::Has(const ::blink::String& cache_name, int64_t trace_id, HasCallback callback) {
  GetForwardingInterface()->Has(
    std::move(cache_name)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageInterceptorForTesting::Delete(const ::blink::String& cache_name, int64_t trace_id, DeleteCallback callback) {
  GetForwardingInterface()->Delete(
    std::move(cache_name)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageInterceptorForTesting::Keys(int64_t trace_id, KeysCallback callback) {
  GetForwardingInterface()->Keys(
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageInterceptorForTesting::Match(::blink::mojom::blink::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) {
  GetForwardingInterface()->Match(
    std::move(request)
    , 
    std::move(match_options)
    , 
    std::move(in_related_fetch_event)
    , 
    std::move(in_range_fetch_event)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void CacheStorageInterceptorForTesting::Open(const ::blink::String& cache_name, int64_t trace_id, OpenCallback callback) {
  GetForwardingInterface()->Open(
    std::move(cache_name)
    , 
    std::move(trace_id)
    , std::move(callback));
}
CacheStorageAsyncWaiter::CacheStorageAsyncWaiter(
    CacheStorage* proxy) : proxy_(proxy) {}

CacheStorageAsyncWaiter::~CacheStorageAsyncWaiter() = default;


void CacheStorageAsyncWaiter::Has(
    const ::blink::String& cache_name, int64_t trace_id, CacheStorageError* out_result) {
  base::RunLoop loop;
  proxy_->Has(
      std::move(cache_name),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CacheStorageError* out_result
,
             CacheStorageError result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CacheStorageError CacheStorageAsyncWaiter::Has(
    const ::blink::String& cache_name, int64_t trace_id) {
  CacheStorageError async_wait_result;
  Has(std::move(cache_name),std::move(trace_id),&async_wait_result);
  return async_wait_result;
}

void CacheStorageAsyncWaiter::Delete(
    const ::blink::String& cache_name, int64_t trace_id, CacheStorageError* out_result) {
  base::RunLoop loop;
  proxy_->Delete(
      std::move(cache_name),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CacheStorageError* out_result
,
             CacheStorageError result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CacheStorageError CacheStorageAsyncWaiter::Delete(
    const ::blink::String& cache_name, int64_t trace_id) {
  CacheStorageError async_wait_result;
  Delete(std::move(cache_name),std::move(trace_id),&async_wait_result);
  return async_wait_result;
}

void CacheStorageAsyncWaiter::Keys(
    int64_t trace_id, ::blink::Vector<::blink::String>* out_keys) {
  base::RunLoop loop;
  proxy_->Keys(
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_keys
,
             const ::blink::Vector<::blink::String>& keys) {*out_keys = std::move(keys);
            loop->Quit();
          },
          &loop,
          out_keys));
  loop.Run();
}

::blink::Vector<::blink::String> CacheStorageAsyncWaiter::Keys(
    int64_t trace_id) {
  ::blink::Vector<::blink::String> async_wait_result;
  Keys(std::move(trace_id),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif