// third_party/blink/public/mojom/browser_interface_broker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  GenericPendingReceiver as mojoBase_mojom_GenericPendingReceiver,
  GenericPendingReceiverSpec as mojoBase_mojom_GenericPendingReceiverSpec
} from '../../../../mojo/public/mojom/base/generic_pending_receiver.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BrowserInterfaceBrokerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BrowserInterfaceBroker', scope);
  }
}

/** @interface */
export class BrowserInterfaceBrokerInterface {
  
  /**
   * @param { !mojoBase_mojom_GenericPendingReceiver } receiver
   */

  getInterface(receiver) {}
}

/**
 * @implements { BrowserInterfaceBrokerInterface }
 */
export class BrowserInterfaceBrokerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BrowserInterfaceBrokerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BrowserInterfaceBrokerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BrowserInterfaceBrokerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_GenericPendingReceiver } receiver
   */

  getInterface(
      receiver) {
    this.proxy.sendMessage(
        0,
        BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BrowserInterfaceBroker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BrowserInterfaceBrokerReceiver {
  /**
   * @param {!BrowserInterfaceBrokerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BrowserInterfaceBrokerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BrowserInterfaceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BrowserInterfaceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        impl.getInterface.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BrowserInterfaceBroker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BrowserInterfaceBroker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BrowserInterfaceBrokerRemote}
   */
  static getRemote() {
    let remote = new BrowserInterfaceBrokerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BrowserInterfaceBroker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BrowserInterfaceBrokerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BrowserInterfaceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BrowserInterfaceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        this.getInterface.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BrowserInterfaceBroker_GetInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
    'BrowserInterfaceBroker_GetInterface_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojoBase_mojom_GenericPendingReceiverSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BrowserInterfaceBroker_GetInterface_Params {
  constructor() {
    /** @type { !mojoBase_mojom_GenericPendingReceiver } */
    this.receiver;
  }
}

