// third_party/blink/public/mojom/browser_interface_broker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.GenericPendingReceiver');






goog.provide('blink.mojom.BrowserInterfaceBroker');
goog.provide('blink.mojom.BrowserInterfaceBrokerReceiver');
goog.provide('blink.mojom.BrowserInterfaceBrokerCallbackRouter');
goog.provide('blink.mojom.BrowserInterfaceBrokerInterface');
goog.provide('blink.mojom.BrowserInterfaceBrokerRemote');
goog.provide('blink.mojom.BrowserInterfaceBrokerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BrowserInterfaceBrokerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BrowserInterfaceBroker.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.BrowserInterfaceBrokerInterface = class {
  
  /**
   * @param { !mojoBase.mojom.GenericPendingReceiver } receiver
   */

  getInterface(receiver) {}
};

/**
 * @export
 * @implements { blink.mojom.BrowserInterfaceBrokerInterface }
 */
blink.mojom.BrowserInterfaceBrokerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BrowserInterfaceBrokerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BrowserInterfaceBrokerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BrowserInterfaceBrokerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.GenericPendingReceiver } receiver
   */

  getInterface(
      receiver) {
    this.proxy.sendMessage(
        0,
        blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BrowserInterfaceBroker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BrowserInterfaceBrokerReceiver = class {
  /**
   * @param {!blink.mojom.BrowserInterfaceBrokerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BrowserInterfaceBrokerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BrowserInterfaceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BrowserInterfaceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        impl.getInterface.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BrowserInterfaceBroker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BrowserInterfaceBroker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BrowserInterfaceBrokerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BrowserInterfaceBrokerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BrowserInterfaceBroker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BrowserInterfaceBrokerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BrowserInterfaceBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BrowserInterfaceBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
        null,
        this.getInterface.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BrowserInterfaceBroker_GetInterface_ParamsSpec.$,
    'BrowserInterfaceBroker_GetInterface_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojoBase.mojom.GenericPendingReceiverSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.BrowserInterfaceBroker_GetInterface_Params');

/** @record */
blink.mojom.BrowserInterfaceBroker_GetInterface_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.GenericPendingReceiver } */
    this.receiver;
  }
};

