// third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  CloneableMessage as blink_mojom_CloneableMessage,
  CloneableMessageSpec as blink_mojom_CloneableMessageSpec
} from '../messaging/cloneable_message.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BroadcastChannelClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BroadcastChannelClient', scope);
  }
}

/** @interface */
export class BroadcastChannelClientInterface {
  
  /**
   * @param { !blink_mojom_CloneableMessage } message
   */

  onMessage(message) {}
}

/**
 * @implements { BroadcastChannelClientInterface }
 */
export class BroadcastChannelClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BroadcastChannelClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BroadcastChannelClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BroadcastChannelClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_CloneableMessage } message
   */

  onMessage(
      message) {
    this.proxy.sendMessage(
        0,
        BroadcastChannelClient_OnMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BroadcastChannelClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BroadcastChannelClientReceiver {
  /**
   * @param {!BroadcastChannelClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BroadcastChannelClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BroadcastChannelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BroadcastChannelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BroadcastChannelClient_OnMessage_ParamsSpec.$,
        null,
        impl.onMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BroadcastChannelClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BroadcastChannelClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BroadcastChannelClientRemote}
   */
  static getRemote() {
    let remote = new BroadcastChannelClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BroadcastChannelClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BroadcastChannelClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BroadcastChannelClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BroadcastChannelClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BroadcastChannelClient_OnMessage_ParamsSpec.$,
        null,
        this.onMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BroadcastChannelProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BroadcastChannelProvider', scope);
  }
}

/** @interface */
export class BroadcastChannelProviderInterface {
  
  /**
   * @param { !string } name
   * @param { !Object } client
   * @param { !Object } connection
   */

  connectToChannel(name, client, connection) {}
}

/**
 * @implements { BroadcastChannelProviderInterface }
 */
export class BroadcastChannelProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BroadcastChannelProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BroadcastChannelProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BroadcastChannelProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !Object } client
   * @param { !Object } connection
   */

  connectToChannel(
      name,
      client,
      connection) {
    this.proxy.sendMessage(
        0,
        BroadcastChannelProvider_ConnectToChannel_ParamsSpec.$,
        null,
        [
          name,
          client,
          connection
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BroadcastChannelProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BroadcastChannelProviderReceiver {
  /**
   * @param {!BroadcastChannelProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BroadcastChannelProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BroadcastChannelProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BroadcastChannelProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BroadcastChannelProvider_ConnectToChannel_ParamsSpec.$,
        null,
        impl.connectToChannel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BroadcastChannelProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BroadcastChannelProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BroadcastChannelProviderRemote}
   */
  static getRemote() {
    let remote = new BroadcastChannelProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BroadcastChannelProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BroadcastChannelProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BroadcastChannelProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BroadcastChannelProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connectToChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BroadcastChannelProvider_ConnectToChannel_ParamsSpec.$,
        null,
        this.connectToChannel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BroadcastChannelClient_OnMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BroadcastChannelProvider_ConnectToChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BroadcastChannelClient_OnMessage_ParamsSpec.$,
    'BroadcastChannelClient_OnMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink_mojom_CloneableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BroadcastChannelClient_OnMessage_Params {
  constructor() {
    /** @type { !blink_mojom_CloneableMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    BroadcastChannelProvider_ConnectToChannel_ParamsSpec.$,
    'BroadcastChannelProvider_ConnectToChannel_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(BroadcastChannelClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connection', 16,
        0,
        mojo.internal.AssociatedInterfaceRequest(BroadcastChannelClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BroadcastChannelProvider_ConnectToChannel_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !Object } */
    this.client;
    /** @type { !Object } */
    this.connection;
  }
}

