// third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileBackedBlobFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileBackedBlobFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FileBackedBlobFactoryInterface }
 */
blink.mojom.FileBackedBlobFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileBackedBlobFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileBackedBlobFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileBackedBlobFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink.mojom.DataElementFile } file
   */

  registerBlob(
      blob,
      uuid,
      contentType,
      file) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        [
          blob,
          uuid,
          contentType,
          file
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink.mojom.DataElementFile } file
   * @return {!Promise}
   */

  registerBlobSync(
      blob,
      uuid,
      contentType,
      file) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        [
          blob,
          uuid,
          contentType,
          file
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileBackedBlobFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileBackedBlobFactoryReceiver = class {
  /**
   * @param {!blink.mojom.FileBackedBlobFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileBackedBlobFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileBackedBlobFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileBackedBlobFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        impl.registerBlob.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        impl.registerBlobSync.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileBackedBlobFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileBackedBlobFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileBackedBlobFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileBackedBlobFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileBackedBlobFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileBackedBlobFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileBackedBlobFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileBackedBlobFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerBlob =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        this.registerBlob.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerBlobSync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        this.registerBlobSync.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileBackedBlobFactory_RegisterBlob_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlob_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.BlobPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uuid', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentType', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        blink.mojom.DataElementFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.FileBackedBlobFactory_RegisterBlob_Params = class {
  constructor() {
    /** @export { !blink.mojom.BlobPendingReceiver } */
    this.blob;
    /** @export { !string } */
    this.uuid;
    /** @export { !string } */
    this.contentType;
    /** @export { !blink.mojom.DataElementFile } */
    this.file;
  }
};



mojo.internal.Struct(
    blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlobSync_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.BlobPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uuid', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentType', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        blink.mojom.DataElementFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.FileBackedBlobFactory_RegisterBlobSync_Params = class {
  constructor() {
    /** @export { !blink.mojom.BlobPendingReceiver } */
    this.blob;
    /** @export { !string } */
    this.uuid;
    /** @export { !string } */
    this.contentType;
    /** @export { !blink.mojom.DataElementFile } */
    this.file;
  }
};



mojo.internal.Struct(
    blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlobSync_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FileBackedBlobFactory_RegisterBlobSync_ResponseParams = class {
  constructor() {
  }
};

