// third_party/blink/public/mojom/autoplay/autoplay.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';


/**
 * @const { !number }
 */
export const AUTOPLAY_FLAG_NONE = 0x00000;


/**
 * @const { !number }
 */
export const AUTOPLAY_FLAG_HIGH_MEDIA_ENGAGEMENT = 0x00001;


/**
 * @const { !number }
 */
export const AUTOPLAY_FLAG_FORCE_ALLOW = 0x00002;


/**
 * @const { !number }
 */
export const AUTOPLAY_FLAG_USER_EXCEPTION = 0x00004;




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AutoplayConfigurationClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AutoplayConfigurationClient', scope);
  }
}

/** @interface */
export class AutoplayConfigurationClientInterface {
  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !number } flags
   */

  addAutoplayFlags(origin, flags) {}
}

/**
 * @implements { AutoplayConfigurationClientInterface }
 */
export class AutoplayConfigurationClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AutoplayConfigurationClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AutoplayConfigurationClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AutoplayConfigurationClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @param { !number } flags
   */

  addAutoplayFlags(
      origin,
      flags) {
    this.proxy.sendMessage(
        0,
        AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        [
          origin,
          flags
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AutoplayConfigurationClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AutoplayConfigurationClientReceiver {
  /**
   * @param {!AutoplayConfigurationClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AutoplayConfigurationClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AutoplayConfigurationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AutoplayConfigurationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        impl.addAutoplayFlags.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AutoplayConfigurationClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AutoplayConfigurationClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AutoplayConfigurationClientRemote}
   */
  static getRemote() {
    let remote = new AutoplayConfigurationClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AutoplayConfigurationClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AutoplayConfigurationClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AutoplayConfigurationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AutoplayConfigurationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAutoplayFlags =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
        null,
        this.addAutoplayFlags.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AutoplayConfigurationClient_AddAutoplayFlags_ParamsSpec.$,
    'AutoplayConfigurationClient_AddAutoplayFlags_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AutoplayConfigurationClient_AddAutoplayFlags_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !number } */
    this.flags;
  }
}

