// third_party/blink/public/mojom/ai/model_streaming_responder.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/model_streaming_responder.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }


  var ModelStreamingResponseStatus = {};
  ModelStreamingResponseStatus.kOngoing = 0;
  ModelStreamingResponseStatus.kComplete = 1;
  ModelStreamingResponseStatus.kErrorUnknown = 2;
  ModelStreamingResponseStatus.kErrorInvalidRequest = 3;
  ModelStreamingResponseStatus.kErrorRequestThrottled = 4;
  ModelStreamingResponseStatus.kErrorPermissionDenied = 5;
  ModelStreamingResponseStatus.kErrorGenericFailure = 6;
  ModelStreamingResponseStatus.kErrorRetryableError = 7;
  ModelStreamingResponseStatus.kErrorNonRetryableError = 8;
  ModelStreamingResponseStatus.kErrorUnsupportedLanguage = 9;
  ModelStreamingResponseStatus.kErrorFiltered = 10;
  ModelStreamingResponseStatus.kErrorDisabled = 11;
  ModelStreamingResponseStatus.kErrorCancelled = 12;
  ModelStreamingResponseStatus.kErrorSessionDestroyed = 13;
  ModelStreamingResponseStatus.kErrorInputTooLarge = 14;
  ModelStreamingResponseStatus.kErrorResponseLowQuality = 15;
  ModelStreamingResponseStatus.MIN_VALUE = 0;
  ModelStreamingResponseStatus.MAX_VALUE = 15;

  ModelStreamingResponseStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return true;
    }
    return false;
  };

  ModelStreamingResponseStatus.toKnownEnumValue = function(value) {
    return value;
  };

  ModelStreamingResponseStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ModelExecutionContextInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelExecutionContextInfo.prototype.initDefaults_ = function() {
    this.currentTokens = 0;
  };
  ModelExecutionContextInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelExecutionContextInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ModelExecutionContextInfo.encodedSize = codec.kStructHeaderSize + 8;

  ModelExecutionContextInfo.decode = function(decoder) {
    var packed;
    var val = new ModelExecutionContextInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentTokens =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ModelExecutionContextInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelExecutionContextInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.currentTokens);
  };
  function ModelStreamingResponder_OnCompletion_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelStreamingResponder_OnCompletion_Params.prototype.initDefaults_ = function() {
    this.contextInfo = null;
  };
  ModelStreamingResponder_OnCompletion_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelStreamingResponder_OnCompletion_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelStreamingResponder_OnCompletion_Params.contextInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ModelExecutionContextInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ModelStreamingResponder_OnCompletion_Params.encodedSize = codec.kStructHeaderSize + 8;

  ModelStreamingResponder_OnCompletion_Params.decode = function(decoder) {
    var packed;
    var val = new ModelStreamingResponder_OnCompletion_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contextInfo =
        decoder.decodeStructPointer(ModelExecutionContextInfo);
    return val;
  };

  ModelStreamingResponder_OnCompletion_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelStreamingResponder_OnCompletion_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ModelExecutionContextInfo, val.contextInfo);
  };
  function ModelStreamingResponder_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelStreamingResponder_OnError_Params.prototype.initDefaults_ = function() {
    this.status = 0;
    this.quotaErrorInfo = null;
  };
  ModelStreamingResponder_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelStreamingResponder_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelStreamingResponder_OnError_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ModelStreamingResponseStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelStreamingResponder_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ModelStreamingResponder_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  ModelStreamingResponder_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new ModelStreamingResponder_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(ModelStreamingResponseStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  ModelStreamingResponder_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelStreamingResponder_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function ModelStreamingResponder_OnStreaming_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelStreamingResponder_OnStreaming_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  ModelStreamingResponder_OnStreaming_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelStreamingResponder_OnStreaming_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ModelStreamingResponder_OnStreaming_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ModelStreamingResponder_OnStreaming_Params.encodedSize = codec.kStructHeaderSize + 8;

  ModelStreamingResponder_OnStreaming_Params.decode = function(decoder) {
    var packed;
    var val = new ModelStreamingResponder_OnStreaming_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ModelStreamingResponder_OnStreaming_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelStreamingResponder_OnStreaming_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function ModelStreamingResponder_OnQuotaOverflow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelStreamingResponder_OnQuotaOverflow_Params.prototype.initDefaults_ = function() {
  };
  ModelStreamingResponder_OnQuotaOverflow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelStreamingResponder_OnQuotaOverflow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ModelStreamingResponder_OnQuotaOverflow_Params.encodedSize = codec.kStructHeaderSize + 0;

  ModelStreamingResponder_OnQuotaOverflow_Params.decode = function(decoder) {
    var packed;
    var val = new ModelStreamingResponder_OnQuotaOverflow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ModelStreamingResponder_OnQuotaOverflow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelStreamingResponder_OnQuotaOverflow_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kModelStreamingResponder_OnCompletion_Name = 0;
  var kModelStreamingResponder_OnError_Name = 1;
  var kModelStreamingResponder_OnStreaming_Name = 2;
  var kModelStreamingResponder_OnQuotaOverflow_Name = 3;

  function ModelStreamingResponderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ModelStreamingResponder,
                                                   handleOrPtrInfo);
  }

  function ModelStreamingResponderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ModelStreamingResponder, associatedInterfacePtrInfo);
  }

  ModelStreamingResponderAssociatedPtr.prototype =
      Object.create(ModelStreamingResponderPtr.prototype);
  ModelStreamingResponderAssociatedPtr.prototype.constructor =
      ModelStreamingResponderAssociatedPtr;

  function ModelStreamingResponderProxy(receiver) {
    this.receiver_ = receiver;
  }
  ModelStreamingResponderPtr.prototype.onCompletion = function() {
    return ModelStreamingResponderProxy.prototype.onCompletion
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelStreamingResponderProxy.prototype.onCompletion = function(contextInfo) {
    var params_ = new ModelStreamingResponder_OnCompletion_Params();
    params_.contextInfo = contextInfo;
    var builder = new codec.MessageV0Builder(
        kModelStreamingResponder_OnCompletion_Name,
        codec.align(ModelStreamingResponder_OnCompletion_Params.encodedSize));
    builder.encodeStruct(ModelStreamingResponder_OnCompletion_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ModelStreamingResponderPtr.prototype.onError = function() {
    return ModelStreamingResponderProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelStreamingResponderProxy.prototype.onError = function(status, quotaErrorInfo) {
    var params_ = new ModelStreamingResponder_OnError_Params();
    params_.status = status;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kModelStreamingResponder_OnError_Name,
        codec.align(ModelStreamingResponder_OnError_Params.encodedSize));
    builder.encodeStruct(ModelStreamingResponder_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ModelStreamingResponderPtr.prototype.onStreaming = function() {
    return ModelStreamingResponderProxy.prototype.onStreaming
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelStreamingResponderProxy.prototype.onStreaming = function(text) {
    var params_ = new ModelStreamingResponder_OnStreaming_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kModelStreamingResponder_OnStreaming_Name,
        codec.align(ModelStreamingResponder_OnStreaming_Params.encodedSize));
    builder.encodeStruct(ModelStreamingResponder_OnStreaming_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ModelStreamingResponderPtr.prototype.onQuotaOverflow = function() {
    return ModelStreamingResponderProxy.prototype.onQuotaOverflow
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelStreamingResponderProxy.prototype.onQuotaOverflow = function() {
    var params_ = new ModelStreamingResponder_OnQuotaOverflow_Params();
    var builder = new codec.MessageV0Builder(
        kModelStreamingResponder_OnQuotaOverflow_Name,
        codec.align(ModelStreamingResponder_OnQuotaOverflow_Params.encodedSize));
    builder.encodeStruct(ModelStreamingResponder_OnQuotaOverflow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ModelStreamingResponderStub(delegate) {
    this.delegate_ = delegate;
  }
  ModelStreamingResponderStub.prototype.onCompletion = function(contextInfo) {
    return this.delegate_ && this.delegate_.onCompletion && this.delegate_.onCompletion(contextInfo);
  }
  ModelStreamingResponderStub.prototype.onError = function(status, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(status, quotaErrorInfo);
  }
  ModelStreamingResponderStub.prototype.onStreaming = function(text) {
    return this.delegate_ && this.delegate_.onStreaming && this.delegate_.onStreaming(text);
  }
  ModelStreamingResponderStub.prototype.onQuotaOverflow = function() {
    return this.delegate_ && this.delegate_.onQuotaOverflow && this.delegate_.onQuotaOverflow();
  }

  ModelStreamingResponderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kModelStreamingResponder_OnCompletion_Name:
      var params = reader.decodeStruct(ModelStreamingResponder_OnCompletion_Params);
      this.onCompletion(params.contextInfo);
      return true;
    case kModelStreamingResponder_OnError_Name:
      var params = reader.decodeStruct(ModelStreamingResponder_OnError_Params);
      this.onError(params.status, params.quotaErrorInfo);
      return true;
    case kModelStreamingResponder_OnStreaming_Name:
      var params = reader.decodeStruct(ModelStreamingResponder_OnStreaming_Params);
      this.onStreaming(params.text);
      return true;
    case kModelStreamingResponder_OnQuotaOverflow_Name:
      var params = reader.decodeStruct(ModelStreamingResponder_OnQuotaOverflow_Params);
      this.onQuotaOverflow();
      return true;
    default:
      return false;
    }
  };

  ModelStreamingResponderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateModelStreamingResponderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kModelStreamingResponder_OnCompletion_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ModelStreamingResponder_OnCompletion_Params;
      break;
      case kModelStreamingResponder_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ModelStreamingResponder_OnError_Params;
      break;
      case kModelStreamingResponder_OnStreaming_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ModelStreamingResponder_OnStreaming_Params;
      break;
      case kModelStreamingResponder_OnQuotaOverflow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ModelStreamingResponder_OnQuotaOverflow_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateModelStreamingResponderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ModelStreamingResponder = {
    name: 'blink.mojom.ModelStreamingResponder',
    kVersion: 0,
    ptrClass: ModelStreamingResponderPtr,
    proxyClass: ModelStreamingResponderProxy,
    stubClass: ModelStreamingResponderStub,
    validateRequest: validateModelStreamingResponderRequest,
    validateResponse: null,
  };
  ModelStreamingResponderStub.prototype.validator = validateModelStreamingResponderRequest;
  ModelStreamingResponderProxy.prototype.validator = null;
  exports.ModelStreamingResponseStatus = ModelStreamingResponseStatus;
  exports.ModelExecutionContextInfo = ModelExecutionContextInfo;
  exports.ModelStreamingResponder = ModelStreamingResponder;
  exports.ModelStreamingResponderPtr = ModelStreamingResponderPtr;
  exports.ModelStreamingResponderAssociatedPtr = ModelStreamingResponderAssociatedPtr;
})();