// third_party/blink/public/mojom/ai/ai_proofreader.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AILanguageCode as blink_mojom_AILanguageCode,
  AILanguageCodeSpec as blink_mojom_AILanguageCodeSpec
} from './ai_common.mojom.m.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from './model_streaming_responder.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIProofreaderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIProofreader', scope);
  }
}

/** @interface */
export class AIProofreaderInterface {
  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  proofread(input, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } correctedInput
   * @param { !string } correctionInstruction
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  getCorrectionType(input, correctedInput, correctionInstruction, pendingResponder) {}
}

/**
 * @implements { AIProofreaderInterface }
 */
export class AIProofreaderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIProofreaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIProofreaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIProofreaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  proofread(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        AIProofreader_Proofread_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } correctedInput
   * @param { !string } correctionInstruction
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  getCorrectionType(
      input,
      correctedInput,
      correctionInstruction,
      pendingResponder) {
    this.proxy.sendMessage(
        1,
        AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        [
          input,
          correctedInput,
          correctionInstruction,
          pendingResponder
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIProofreader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIProofreaderReceiver {
  /**
   * @param {!AIProofreaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIProofreaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIProofreaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIProofreaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIProofreader_Proofread_ParamsSpec.$,
        null,
        impl.proofread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        impl.getCorrectionType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIProofreader {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIProofreader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIProofreaderRemote}
   */
  static getRemote() {
    let remote = new AIProofreaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIProofreader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIProofreaderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIProofreaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIProofreaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.proofread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIProofreader_Proofread_ParamsSpec.$,
        null,
        this.proofread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCorrectionType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIProofreader_GetCorrectionType_ParamsSpec.$,
        null,
        this.getCorrectionType.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIProofreaderCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIProofreader_Proofread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIProofreader_GetCorrectionType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AIProofreaderCreateOptionsSpec.$,
    'AIProofreaderCreateOptions',
    [
      mojo.internal.StructField(
        'includeCorrectionTypes', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeCorrectionExplanations', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'correctionExplanationLanguage', 8,
        0,
        blink_mojom_AILanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 16,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIProofreaderCreateOptions {
  constructor() {
    /** @type { !boolean } */
    this.includeCorrectionTypes;
    /** @type { !boolean } */
    this.includeCorrectionExplanations;
    /** @type { !blink_mojom_AILanguageCode } */
    this.correctionExplanationLanguage;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedInputLanguages;
  }
}



mojo.internal.Struct(
    AIProofreader_Proofread_ParamsSpec.$,
    'AIProofreader_Proofread_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIProofreader_Proofread_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    AIProofreader_GetCorrectionType_ParamsSpec.$,
    'AIProofreader_GetCorrectionType_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'correctedInput', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'correctionInstruction', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 24,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AIProofreader_GetCorrectionType_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !string } */
    this.correctedInput;
    /** @type { !string } */
    this.correctionInstruction;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}

