// third_party/blink/public/mojom/ai/ai_proofreader.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-params-data.h"
#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
AIProofreaderCreateOptions::AIProofreaderCreateOptions()
    : include_correction_types(),
      include_correction_explanations(),
      correction_explanation_language(),
      expected_input_languages() {}

AIProofreaderCreateOptions::AIProofreaderCreateOptions(
    bool include_correction_types_in,
    bool include_correction_explanations_in,
    ::blink::mojom::blink::AILanguageCodePtr correction_explanation_language_in,
    ::blink::Vector<::blink::mojom::blink::AILanguageCodePtr> expected_input_languages_in)
    : include_correction_types(std::move(include_correction_types_in)),
      include_correction_explanations(std::move(include_correction_explanations_in)),
      correction_explanation_language(std::move(correction_explanation_language_in)),
      expected_input_languages(std::move(expected_input_languages_in)) {}

AIProofreaderCreateOptions::~AIProofreaderCreateOptions() = default;

void AIProofreaderCreateOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_correction_types"), this->include_correction_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_correction_explanations"), this->include_correction_explanations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "correction_explanation_language"), this->correction_explanation_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::AILanguageCodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_input_languages"), this->expected_input_languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::blink::mojom::blink::AILanguageCodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIProofreaderCreateOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AIProofreader::IPCStableHashFunction AIProofreader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIProofreader>(message.name())) {
    case messages::AIProofreader::kProofread: {
      return &AIProofreader::Proofread_Sym::IPCStableHash;
    }
    case messages::AIProofreader::kGetCorrectionType: {
      return &AIProofreader::GetCorrectionType_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIProofreader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIProofreader>(message.name())) {
      case messages::AIProofreader::kProofread:
            return "Receive blink::mojom::AIProofreader::Proofread";
      case messages::AIProofreader::kGetCorrectionType:
            return "Receive blink::mojom::AIProofreader::GetCorrectionType";
    }
  } else {
    switch (static_cast<messages::AIProofreader>(message.name())) {
      case messages::AIProofreader::kProofread:
            return "Receive reply blink::mojom::AIProofreader::Proofread";
      case messages::AIProofreader::kGetCorrectionType:
            return "Receive reply blink::mojom::AIProofreader::GetCorrectionType";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIProofreader::Proofread_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff46f65c;  // IPCStableHash for blink::mojom::AIProofreader::Proofread
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIProofreader::GetCorrectionType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20f0ebe1;  // IPCStableHash for blink::mojom::AIProofreader::GetCorrectionType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIProofreaderProxy::AIProofreaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIProofreaderProxy::Proofread(
    const ::blink::String& in_input, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIProofreader::Proofread", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIProofreader::kProofread), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIProofreader_Proofread_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AIProofreader.Proofread request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in AIProofreader.Proofread request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIProofreader::Name_);
  message.set_method_name("Proofread");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIProofreaderProxy::GetCorrectionType(
    const ::blink::String& in_input, const ::blink::String& in_corrected_input, const ::blink::String& in_correction_instruction, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIProofreader::GetCorrectionType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("corrected_input"), in_corrected_input,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("correction_instruction"), in_correction_instruction,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIProofreader::kGetCorrectionType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIProofreader_GetCorrectionType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AIProofreader.GetCorrectionType request");
  mojo::internal::MessageFragment<
      typename decltype(params->corrected_input)::BaseType> corrected_input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_corrected_input,
    corrected_input_fragment);

  params->corrected_input.Set(
      corrected_input_fragment.is_null() ? nullptr : corrected_input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->corrected_input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null corrected_input in AIProofreader.GetCorrectionType request");
  mojo::internal::MessageFragment<
      typename decltype(params->correction_instruction)::BaseType> correction_instruction_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_correction_instruction,
    correction_instruction_fragment);

  params->correction_instruction.Set(
      correction_instruction_fragment.is_null() ? nullptr : correction_instruction_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->correction_instruction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null correction_instruction in AIProofreader.GetCorrectionType request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in AIProofreader.GetCorrectionType request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIProofreader::Name_);
  message.set_method_name("GetCorrectionType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIProofreaderStubDispatch::Accept(
    AIProofreader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIProofreader>(message->header()->name)) {
    case messages::AIProofreader::kProofread: {
      DCHECK(message->is_serialized());
      internal::AIProofreader_Proofread_Params_Data* params =
          reinterpret_cast<internal::AIProofreader_Proofread_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIProofreader.0
      bool success = true;
      ::blink::String p_input{};
      ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> p_pending_responder{};
      AIProofreader_Proofread_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIProofreader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Proofread(        
        std::move(p_input), 
        std::move(p_pending_responder));
      return true;
    }
    case messages::AIProofreader::kGetCorrectionType: {
      DCHECK(message->is_serialized());
      internal::AIProofreader_GetCorrectionType_Params_Data* params =
          reinterpret_cast<internal::AIProofreader_GetCorrectionType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIProofreader.1
      bool success = true;
      ::blink::String p_input{};
      ::blink::String p_corrected_input{};
      ::blink::String p_correction_instruction{};
      ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> p_pending_responder{};
      AIProofreader_GetCorrectionType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success && !input_data_view.ReadCorrectedInput(&p_corrected_input))
        success = false;
      if (success && !input_data_view.ReadCorrectionInstruction(&p_correction_instruction))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIProofreader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCorrectionType(        
        std::move(p_input), 
        std::move(p_corrected_input), 
        std::move(p_correction_instruction), 
        std::move(p_pending_responder));
      return true;
    }
  }
  return false;
}

// static
bool AIProofreaderStubDispatch::AcceptWithResponder(
    AIProofreader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIProofreader>(message->header()->name)) {
    case messages::AIProofreader::kProofread: {
      break;
    }
    case messages::AIProofreader::kGetCorrectionType: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIProofreaderValidationInfo[] = {
    { &internal::AIProofreader_Proofread_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIProofreader_GetCorrectionType_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIProofreaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AIProofreader::Name_,
    kAIProofreaderValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AIProofreaderCreateOptions::DataView, ::blink::mojom::blink::AIProofreaderCreateOptionsPtr>::Read(
    ::blink::mojom::blink::AIProofreaderCreateOptions::DataView input,
    ::blink::mojom::blink::AIProofreaderCreateOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AIProofreaderCreateOptionsPtr result(::blink::mojom::blink::AIProofreaderCreateOptions::New());
  
      if (success)
        result->include_correction_types = input.include_correction_types();
      if (success)
        result->include_correction_explanations = input.include_correction_explanations();
      if (success && !input.ReadCorrectionExplanationLanguage(&result->correction_explanation_language))
        success = false;
      if (success && !input.ReadExpectedInputLanguages(&result->expected_input_languages))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AIProofreaderInterceptorForTesting::Proofread(const ::blink::String& input, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->Proofread(
    std::move(input)
    , 
    std::move(pending_responder)
    );
}
void AIProofreaderInterceptorForTesting::GetCorrectionType(const ::blink::String& input, const ::blink::String& corrected_input, const ::blink::String& correction_instruction, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->GetCorrectionType(
    std::move(input)
    , 
    std::move(corrected_input)
    , 
    std::move(correction_instruction)
    , 
    std::move(pending_responder)
    );
}
AIProofreaderAsyncWaiter::AIProofreaderAsyncWaiter(
    AIProofreader* proxy) : proxy_(proxy) {}

AIProofreaderAsyncWaiter::~AIProofreaderAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif