// third_party/blink/public/mojom/ai/ai_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/ai/ai_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/ai/ai_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/ai/ai_manager.mojom-import-headers.h"
#include "third_party/blink/public/mojom/ai/ai_manager.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

AIManagerCreateWriterClient::IPCStableHashFunction AIManagerCreateWriterClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManagerCreateWriterClient>(message.name())) {
    case messages::AIManagerCreateWriterClient::kOnResult: {
      return &AIManagerCreateWriterClient::OnResult_Sym::IPCStableHash;
    }
    case messages::AIManagerCreateWriterClient::kOnError: {
      return &AIManagerCreateWriterClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManagerCreateWriterClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManagerCreateWriterClient>(message.name())) {
      case messages::AIManagerCreateWriterClient::kOnResult:
            return "Receive blink::mojom::AIManagerCreateWriterClient::OnResult";
      case messages::AIManagerCreateWriterClient::kOnError:
            return "Receive blink::mojom::AIManagerCreateWriterClient::OnError";
    }
  } else {
    switch (static_cast<messages::AIManagerCreateWriterClient>(message.name())) {
      case messages::AIManagerCreateWriterClient::kOnResult:
            return "Receive reply blink::mojom::AIManagerCreateWriterClient::OnResult";
      case messages::AIManagerCreateWriterClient::kOnError:
            return "Receive reply blink::mojom::AIManagerCreateWriterClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManagerCreateWriterClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8cc8a8fa;  // IPCStableHash for blink::mojom::AIManagerCreateWriterClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManagerCreateWriterClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x093d33ab;  // IPCStableHash for blink::mojom::AIManagerCreateWriterClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIManagerCreateWriterClientProxy::AIManagerCreateWriterClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerCreateWriterClientProxy::OnResult(
    ::mojo::PendingRemote<::blink::mojom::AIWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateWriterClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::AIWriter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateWriterClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateWriterClient_OnResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIWriterInterfaceBase>>(
    in_writer,
    &params->writer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->writer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid writer in AIManagerCreateWriterClient.OnResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateWriterClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerCreateWriterClientProxy::OnError(
    ::blink::mojom::AIManagerCreateClientError in_error, ::blink::mojom::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateWriterClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::AIManagerCreateClientError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateWriterClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateWriterClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AIManagerCreateClientError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateWriterClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIManagerCreateWriterClientStubDispatch::Accept(
    AIManagerCreateWriterClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManagerCreateWriterClient>(message->header()->name)) {
    case messages::AIManagerCreateWriterClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateWriterClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateWriterClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateWriterClient.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::AIWriter> p_writer{};
      AIManagerCreateWriterClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_writer =
            input_data_view.TakeWriter<decltype(p_writer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateWriterClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_writer));
      return true;
    }
    case messages::AIManagerCreateWriterClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateWriterClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateWriterClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateWriterClient.1
      bool success = true;
      ::blink::mojom::AIManagerCreateClientError p_error{};
      ::blink::mojom::QuotaErrorInfoPtr p_quota_error_info{};
      AIManagerCreateWriterClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateWriterClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_quota_error_info));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerCreateWriterClientStubDispatch::AcceptWithResponder(
    AIManagerCreateWriterClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManagerCreateWriterClient>(message->header()->name)) {
    case messages::AIManagerCreateWriterClient::kOnResult: {
      break;
    }
    case messages::AIManagerCreateWriterClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerCreateWriterClientValidationInfo[] = {
    { &internal::AIManagerCreateWriterClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManagerCreateWriterClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerCreateWriterClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIManagerCreateWriterClient::Name_,
    kAIManagerCreateWriterClientValidationInfo);
}

// The declaration includes the definition on other builds.

AIManagerCreateRewriterClient::IPCStableHashFunction AIManagerCreateRewriterClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManagerCreateRewriterClient>(message.name())) {
    case messages::AIManagerCreateRewriterClient::kOnResult: {
      return &AIManagerCreateRewriterClient::OnResult_Sym::IPCStableHash;
    }
    case messages::AIManagerCreateRewriterClient::kOnError: {
      return &AIManagerCreateRewriterClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManagerCreateRewriterClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManagerCreateRewriterClient>(message.name())) {
      case messages::AIManagerCreateRewriterClient::kOnResult:
            return "Receive blink::mojom::AIManagerCreateRewriterClient::OnResult";
      case messages::AIManagerCreateRewriterClient::kOnError:
            return "Receive blink::mojom::AIManagerCreateRewriterClient::OnError";
    }
  } else {
    switch (static_cast<messages::AIManagerCreateRewriterClient>(message.name())) {
      case messages::AIManagerCreateRewriterClient::kOnResult:
            return "Receive reply blink::mojom::AIManagerCreateRewriterClient::OnResult";
      case messages::AIManagerCreateRewriterClient::kOnError:
            return "Receive reply blink::mojom::AIManagerCreateRewriterClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManagerCreateRewriterClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce21c917;  // IPCStableHash for blink::mojom::AIManagerCreateRewriterClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManagerCreateRewriterClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fd47e99;  // IPCStableHash for blink::mojom::AIManagerCreateRewriterClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIManagerCreateRewriterClientProxy::AIManagerCreateRewriterClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerCreateRewriterClientProxy::OnResult(
    ::mojo::PendingRemote<::blink::mojom::AIRewriter> in_rewriter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateRewriterClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rewriter"), in_rewriter,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::AIRewriter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateRewriterClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateRewriterClient_OnResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIRewriterInterfaceBase>>(
    in_rewriter,
    &params->rewriter,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->rewriter)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid rewriter in AIManagerCreateRewriterClient.OnResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateRewriterClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerCreateRewriterClientProxy::OnError(
    ::blink::mojom::AIManagerCreateClientError in_error, ::blink::mojom::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateRewriterClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::AIManagerCreateClientError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateRewriterClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateRewriterClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AIManagerCreateClientError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateRewriterClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIManagerCreateRewriterClientStubDispatch::Accept(
    AIManagerCreateRewriterClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManagerCreateRewriterClient>(message->header()->name)) {
    case messages::AIManagerCreateRewriterClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateRewriterClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateRewriterClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateRewriterClient.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::AIRewriter> p_rewriter{};
      AIManagerCreateRewriterClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_rewriter =
            input_data_view.TakeRewriter<decltype(p_rewriter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateRewriterClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_rewriter));
      return true;
    }
    case messages::AIManagerCreateRewriterClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateRewriterClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateRewriterClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateRewriterClient.1
      bool success = true;
      ::blink::mojom::AIManagerCreateClientError p_error{};
      ::blink::mojom::QuotaErrorInfoPtr p_quota_error_info{};
      AIManagerCreateRewriterClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateRewriterClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_quota_error_info));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerCreateRewriterClientStubDispatch::AcceptWithResponder(
    AIManagerCreateRewriterClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManagerCreateRewriterClient>(message->header()->name)) {
    case messages::AIManagerCreateRewriterClient::kOnResult: {
      break;
    }
    case messages::AIManagerCreateRewriterClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerCreateRewriterClientValidationInfo[] = {
    { &internal::AIManagerCreateRewriterClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManagerCreateRewriterClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerCreateRewriterClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIManagerCreateRewriterClient::Name_,
    kAIManagerCreateRewriterClientValidationInfo);
}

// The declaration includes the definition on other builds.

AIManagerCreateSummarizerClient::IPCStableHashFunction AIManagerCreateSummarizerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManagerCreateSummarizerClient>(message.name())) {
    case messages::AIManagerCreateSummarizerClient::kOnResult: {
      return &AIManagerCreateSummarizerClient::OnResult_Sym::IPCStableHash;
    }
    case messages::AIManagerCreateSummarizerClient::kOnError: {
      return &AIManagerCreateSummarizerClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManagerCreateSummarizerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManagerCreateSummarizerClient>(message.name())) {
      case messages::AIManagerCreateSummarizerClient::kOnResult:
            return "Receive blink::mojom::AIManagerCreateSummarizerClient::OnResult";
      case messages::AIManagerCreateSummarizerClient::kOnError:
            return "Receive blink::mojom::AIManagerCreateSummarizerClient::OnError";
    }
  } else {
    switch (static_cast<messages::AIManagerCreateSummarizerClient>(message.name())) {
      case messages::AIManagerCreateSummarizerClient::kOnResult:
            return "Receive reply blink::mojom::AIManagerCreateSummarizerClient::OnResult";
      case messages::AIManagerCreateSummarizerClient::kOnError:
            return "Receive reply blink::mojom::AIManagerCreateSummarizerClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManagerCreateSummarizerClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a9321f3;  // IPCStableHash for blink::mojom::AIManagerCreateSummarizerClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManagerCreateSummarizerClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45cead58;  // IPCStableHash for blink::mojom::AIManagerCreateSummarizerClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIManagerCreateSummarizerClientProxy::AIManagerCreateSummarizerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerCreateSummarizerClientProxy::OnResult(
    ::mojo::PendingRemote<::blink::mojom::AISummarizer> in_summarizer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateSummarizerClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("summarizer"), in_summarizer,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::AISummarizer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateSummarizerClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateSummarizerClient_OnResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AISummarizerInterfaceBase>>(
    in_summarizer,
    &params->summarizer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->summarizer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid summarizer in AIManagerCreateSummarizerClient.OnResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateSummarizerClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerCreateSummarizerClientProxy::OnError(
    ::blink::mojom::AIManagerCreateClientError in_error, ::blink::mojom::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateSummarizerClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::AIManagerCreateClientError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateSummarizerClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateSummarizerClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AIManagerCreateClientError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateSummarizerClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIManagerCreateSummarizerClientStubDispatch::Accept(
    AIManagerCreateSummarizerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManagerCreateSummarizerClient>(message->header()->name)) {
    case messages::AIManagerCreateSummarizerClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateSummarizerClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateSummarizerClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateSummarizerClient.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::AISummarizer> p_summarizer{};
      AIManagerCreateSummarizerClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_summarizer =
            input_data_view.TakeSummarizer<decltype(p_summarizer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateSummarizerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_summarizer));
      return true;
    }
    case messages::AIManagerCreateSummarizerClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateSummarizerClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateSummarizerClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateSummarizerClient.1
      bool success = true;
      ::blink::mojom::AIManagerCreateClientError p_error{};
      ::blink::mojom::QuotaErrorInfoPtr p_quota_error_info{};
      AIManagerCreateSummarizerClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateSummarizerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_quota_error_info));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerCreateSummarizerClientStubDispatch::AcceptWithResponder(
    AIManagerCreateSummarizerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManagerCreateSummarizerClient>(message->header()->name)) {
    case messages::AIManagerCreateSummarizerClient::kOnResult: {
      break;
    }
    case messages::AIManagerCreateSummarizerClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerCreateSummarizerClientValidationInfo[] = {
    { &internal::AIManagerCreateSummarizerClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManagerCreateSummarizerClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerCreateSummarizerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIManagerCreateSummarizerClient::Name_,
    kAIManagerCreateSummarizerClientValidationInfo);
}

// The declaration includes the definition on other builds.

AIManagerCreateProofreaderClient::IPCStableHashFunction AIManagerCreateProofreaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManagerCreateProofreaderClient>(message.name())) {
    case messages::AIManagerCreateProofreaderClient::kOnResult: {
      return &AIManagerCreateProofreaderClient::OnResult_Sym::IPCStableHash;
    }
    case messages::AIManagerCreateProofreaderClient::kOnError: {
      return &AIManagerCreateProofreaderClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManagerCreateProofreaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManagerCreateProofreaderClient>(message.name())) {
      case messages::AIManagerCreateProofreaderClient::kOnResult:
            return "Receive blink::mojom::AIManagerCreateProofreaderClient::OnResult";
      case messages::AIManagerCreateProofreaderClient::kOnError:
            return "Receive blink::mojom::AIManagerCreateProofreaderClient::OnError";
    }
  } else {
    switch (static_cast<messages::AIManagerCreateProofreaderClient>(message.name())) {
      case messages::AIManagerCreateProofreaderClient::kOnResult:
            return "Receive reply blink::mojom::AIManagerCreateProofreaderClient::OnResult";
      case messages::AIManagerCreateProofreaderClient::kOnError:
            return "Receive reply blink::mojom::AIManagerCreateProofreaderClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManagerCreateProofreaderClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7d75033;  // IPCStableHash for blink::mojom::AIManagerCreateProofreaderClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManagerCreateProofreaderClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1be867f;  // IPCStableHash for blink::mojom::AIManagerCreateProofreaderClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIManagerCreateProofreaderClientProxy::AIManagerCreateProofreaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerCreateProofreaderClientProxy::OnResult(
    ::mojo::PendingRemote<::blink::mojom::AIProofreader> in_proofreader) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateProofreaderClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proofreader"), in_proofreader,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::AIProofreader>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateProofreaderClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateProofreaderClient_OnResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIProofreaderInterfaceBase>>(
    in_proofreader,
    &params->proofreader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->proofreader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid proofreader in AIManagerCreateProofreaderClient.OnResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateProofreaderClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerCreateProofreaderClientProxy::OnError(
    ::blink::mojom::AIManagerCreateClientError in_error, ::blink::mojom::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateProofreaderClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::AIManagerCreateClientError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateProofreaderClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateProofreaderClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AIManagerCreateClientError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateProofreaderClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIManagerCreateProofreaderClientStubDispatch::Accept(
    AIManagerCreateProofreaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManagerCreateProofreaderClient>(message->header()->name)) {
    case messages::AIManagerCreateProofreaderClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateProofreaderClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateProofreaderClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateProofreaderClient.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::AIProofreader> p_proofreader{};
      AIManagerCreateProofreaderClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_proofreader =
            input_data_view.TakeProofreader<decltype(p_proofreader)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateProofreaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_proofreader));
      return true;
    }
    case messages::AIManagerCreateProofreaderClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateProofreaderClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateProofreaderClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateProofreaderClient.1
      bool success = true;
      ::blink::mojom::AIManagerCreateClientError p_error{};
      ::blink::mojom::QuotaErrorInfoPtr p_quota_error_info{};
      AIManagerCreateProofreaderClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateProofreaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_quota_error_info));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerCreateProofreaderClientStubDispatch::AcceptWithResponder(
    AIManagerCreateProofreaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManagerCreateProofreaderClient>(message->header()->name)) {
    case messages::AIManagerCreateProofreaderClient::kOnResult: {
      break;
    }
    case messages::AIManagerCreateProofreaderClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerCreateProofreaderClientValidationInfo[] = {
    { &internal::AIManagerCreateProofreaderClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManagerCreateProofreaderClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerCreateProofreaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIManagerCreateProofreaderClient::Name_,
    kAIManagerCreateProofreaderClientValidationInfo);
}

// The declaration includes the definition on other builds.

AIManager::IPCStableHashFunction AIManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManager>(message.name())) {
    case messages::AIManager::kCanCreateLanguageModel: {
      return &AIManager::CanCreateLanguageModel_Sym::IPCStableHash;
    }
    case messages::AIManager::kCreateLanguageModel: {
      return &AIManager::CreateLanguageModel_Sym::IPCStableHash;
    }
    case messages::AIManager::kCanCreateSummarizer: {
      return &AIManager::CanCreateSummarizer_Sym::IPCStableHash;
    }
    case messages::AIManager::kCreateSummarizer: {
      return &AIManager::CreateSummarizer_Sym::IPCStableHash;
    }
    case messages::AIManager::kGetLanguageModelParams: {
      return &AIManager::GetLanguageModelParams_Sym::IPCStableHash;
    }
    case messages::AIManager::kCanCreateWriter: {
      return &AIManager::CanCreateWriter_Sym::IPCStableHash;
    }
    case messages::AIManager::kCreateWriter: {
      return &AIManager::CreateWriter_Sym::IPCStableHash;
    }
    case messages::AIManager::kCanCreateRewriter: {
      return &AIManager::CanCreateRewriter_Sym::IPCStableHash;
    }
    case messages::AIManager::kCreateRewriter: {
      return &AIManager::CreateRewriter_Sym::IPCStableHash;
    }
    case messages::AIManager::kCanCreateProofreader: {
      return &AIManager::CanCreateProofreader_Sym::IPCStableHash;
    }
    case messages::AIManager::kCreateProofreader: {
      return &AIManager::CreateProofreader_Sym::IPCStableHash;
    }
    case messages::AIManager::kAddModelDownloadProgressObserver: {
      return &AIManager::AddModelDownloadProgressObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManager>(message.name())) {
      case messages::AIManager::kCanCreateLanguageModel:
            return "Receive blink::mojom::AIManager::CanCreateLanguageModel";
      case messages::AIManager::kCreateLanguageModel:
            return "Receive blink::mojom::AIManager::CreateLanguageModel";
      case messages::AIManager::kCanCreateSummarizer:
            return "Receive blink::mojom::AIManager::CanCreateSummarizer";
      case messages::AIManager::kCreateSummarizer:
            return "Receive blink::mojom::AIManager::CreateSummarizer";
      case messages::AIManager::kGetLanguageModelParams:
            return "Receive blink::mojom::AIManager::GetLanguageModelParams";
      case messages::AIManager::kCanCreateWriter:
            return "Receive blink::mojom::AIManager::CanCreateWriter";
      case messages::AIManager::kCreateWriter:
            return "Receive blink::mojom::AIManager::CreateWriter";
      case messages::AIManager::kCanCreateRewriter:
            return "Receive blink::mojom::AIManager::CanCreateRewriter";
      case messages::AIManager::kCreateRewriter:
            return "Receive blink::mojom::AIManager::CreateRewriter";
      case messages::AIManager::kCanCreateProofreader:
            return "Receive blink::mojom::AIManager::CanCreateProofreader";
      case messages::AIManager::kCreateProofreader:
            return "Receive blink::mojom::AIManager::CreateProofreader";
      case messages::AIManager::kAddModelDownloadProgressObserver:
            return "Receive blink::mojom::AIManager::AddModelDownloadProgressObserver";
    }
  } else {
    switch (static_cast<messages::AIManager>(message.name())) {
      case messages::AIManager::kCanCreateLanguageModel:
            return "Receive reply blink::mojom::AIManager::CanCreateLanguageModel";
      case messages::AIManager::kCreateLanguageModel:
            return "Receive reply blink::mojom::AIManager::CreateLanguageModel";
      case messages::AIManager::kCanCreateSummarizer:
            return "Receive reply blink::mojom::AIManager::CanCreateSummarizer";
      case messages::AIManager::kCreateSummarizer:
            return "Receive reply blink::mojom::AIManager::CreateSummarizer";
      case messages::AIManager::kGetLanguageModelParams:
            return "Receive reply blink::mojom::AIManager::GetLanguageModelParams";
      case messages::AIManager::kCanCreateWriter:
            return "Receive reply blink::mojom::AIManager::CanCreateWriter";
      case messages::AIManager::kCreateWriter:
            return "Receive reply blink::mojom::AIManager::CreateWriter";
      case messages::AIManager::kCanCreateRewriter:
            return "Receive reply blink::mojom::AIManager::CanCreateRewriter";
      case messages::AIManager::kCreateRewriter:
            return "Receive reply blink::mojom::AIManager::CreateRewriter";
      case messages::AIManager::kCanCreateProofreader:
            return "Receive reply blink::mojom::AIManager::CanCreateProofreader";
      case messages::AIManager::kCreateProofreader:
            return "Receive reply blink::mojom::AIManager::CreateProofreader";
      case messages::AIManager::kAddModelDownloadProgressObserver:
            return "Receive reply blink::mojom::AIManager::AddModelDownloadProgressObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManager::CanCreateLanguageModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41a85b25;  // IPCStableHash for blink::mojom::AIManager::CanCreateLanguageModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CreateLanguageModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0811a218;  // IPCStableHash for blink::mojom::AIManager::CreateLanguageModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CanCreateSummarizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb260acbd;  // IPCStableHash for blink::mojom::AIManager::CanCreateSummarizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CreateSummarizer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa05aa58e;  // IPCStableHash for blink::mojom::AIManager::CreateSummarizer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::GetLanguageModelParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73639337;  // IPCStableHash for blink::mojom::AIManager::GetLanguageModelParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CanCreateWriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6c9dc16;  // IPCStableHash for blink::mojom::AIManager::CanCreateWriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CreateWriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa0c88de;  // IPCStableHash for blink::mojom::AIManager::CreateWriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CanCreateRewriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0893c556;  // IPCStableHash for blink::mojom::AIManager::CanCreateRewriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CreateRewriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccc1c949;  // IPCStableHash for blink::mojom::AIManager::CreateRewriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CanCreateProofreader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x525453f4;  // IPCStableHash for blink::mojom::AIManager::CanCreateProofreader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::CreateProofreader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5292db20;  // IPCStableHash for blink::mojom::AIManager::CreateProofreader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManager::AddModelDownloadProgressObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93ded7e6;  // IPCStableHash for blink::mojom::AIManager::AddModelDownloadProgressObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AIManager_CanCreateLanguageModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_CanCreateLanguageModel_ForwardToCallback(
      AIManager::CanCreateLanguageModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_CanCreateLanguageModel_ForwardToCallback(const AIManager_CanCreateLanguageModel_ForwardToCallback&) = delete;
  AIManager_CanCreateLanguageModel_ForwardToCallback& operator=(const AIManager_CanCreateLanguageModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::CanCreateLanguageModelCallback callback_;
};

class AIManager_CanCreateSummarizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_CanCreateSummarizer_ForwardToCallback(
      AIManager::CanCreateSummarizerCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_CanCreateSummarizer_ForwardToCallback(const AIManager_CanCreateSummarizer_ForwardToCallback&) = delete;
  AIManager_CanCreateSummarizer_ForwardToCallback& operator=(const AIManager_CanCreateSummarizer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::CanCreateSummarizerCallback callback_;
};

class AIManager_GetLanguageModelParams_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_GetLanguageModelParams_ForwardToCallback(
      AIManager::GetLanguageModelParamsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_GetLanguageModelParams_ForwardToCallback(const AIManager_GetLanguageModelParams_ForwardToCallback&) = delete;
  AIManager_GetLanguageModelParams_ForwardToCallback& operator=(const AIManager_GetLanguageModelParams_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::GetLanguageModelParamsCallback callback_;
};

class AIManager_CanCreateWriter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_CanCreateWriter_ForwardToCallback(
      AIManager::CanCreateWriterCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_CanCreateWriter_ForwardToCallback(const AIManager_CanCreateWriter_ForwardToCallback&) = delete;
  AIManager_CanCreateWriter_ForwardToCallback& operator=(const AIManager_CanCreateWriter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::CanCreateWriterCallback callback_;
};

class AIManager_CanCreateRewriter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_CanCreateRewriter_ForwardToCallback(
      AIManager::CanCreateRewriterCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_CanCreateRewriter_ForwardToCallback(const AIManager_CanCreateRewriter_ForwardToCallback&) = delete;
  AIManager_CanCreateRewriter_ForwardToCallback& operator=(const AIManager_CanCreateRewriter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::CanCreateRewriterCallback callback_;
};

class AIManager_CanCreateProofreader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIManager_CanCreateProofreader_ForwardToCallback(
      AIManager::CanCreateProofreaderCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIManager_CanCreateProofreader_ForwardToCallback(const AIManager_CanCreateProofreader_ForwardToCallback&) = delete;
  AIManager_CanCreateProofreader_ForwardToCallback& operator=(const AIManager_CanCreateProofreader_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIManager::CanCreateProofreaderCallback callback_;
};

AIManagerProxy::AIManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerProxy::CanCreateLanguageModel(
    ::blink::mojom::AILanguageModelCreateOptionsPtr in_options, CanCreateLanguageModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CanCreateLanguageModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AILanguageModelCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateLanguageModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateLanguageModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AILanguageModelCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CanCreateLanguageModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateLanguageModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_CanCreateLanguageModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CreateLanguageModel(
    ::mojo::PendingRemote<::blink::mojom::AIManagerCreateLanguageModelClient> in_client, ::blink::mojom::AILanguageModelCreateOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CreateLanguageModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::AIManagerCreateLanguageModelClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AILanguageModelCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCreateLanguageModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CreateLanguageModel_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateLanguageModelClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AIManager.CreateLanguageModel request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AILanguageModelCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CreateLanguageModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CreateLanguageModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerProxy::CanCreateSummarizer(
    ::blink::mojom::AISummarizerCreateOptionsPtr in_options, CanCreateSummarizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CanCreateSummarizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AISummarizerCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateSummarizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateSummarizer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AISummarizerCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateSummarizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_CanCreateSummarizer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CreateSummarizer(
    ::mojo::PendingRemote<AIManagerCreateSummarizerClient> in_client, ::blink::mojom::AISummarizerCreateOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CreateSummarizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AIManagerCreateSummarizerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AISummarizerCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCreateSummarizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CreateSummarizer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateSummarizerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AIManager.CreateSummarizer request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AISummarizerCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CreateSummarizer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CreateSummarizer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerProxy::GetLanguageModelParams(
    GetLanguageModelParamsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AIManager::GetLanguageModelParams");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kGetLanguageModelParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_GetLanguageModelParams_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("GetLanguageModelParams");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_GetLanguageModelParams_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CanCreateWriter(
    ::blink::mojom::AIWriterCreateOptionsPtr in_options, CanCreateWriterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CanCreateWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIWriterCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateWriter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIWriterCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CanCreateWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateWriter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_CanCreateWriter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CreateWriter(
    ::mojo::PendingRemote<AIManagerCreateWriterClient> in_client, ::blink::mojom::AIWriterCreateOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CreateWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AIManagerCreateWriterClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIWriterCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCreateWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CreateWriter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateWriterClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AIManager.CreateWriter request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIWriterCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CreateWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CreateWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerProxy::CanCreateRewriter(
    ::blink::mojom::AIRewriterCreateOptionsPtr in_options, CanCreateRewriterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CanCreateRewriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIRewriterCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateRewriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateRewriter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIRewriterCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CanCreateRewriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateRewriter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_CanCreateRewriter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CreateRewriter(
    ::mojo::PendingRemote<AIManagerCreateRewriterClient> in_client, ::blink::mojom::AIRewriterCreateOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CreateRewriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AIManagerCreateRewriterClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIRewriterCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCreateRewriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CreateRewriter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateRewriterClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AIManager.CreateRewriter request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIRewriterCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CreateRewriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CreateRewriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerProxy::CanCreateProofreader(
    ::blink::mojom::AIProofreaderCreateOptionsPtr in_options, CanCreateProofreaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CanCreateProofreader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIProofreaderCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateProofreader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateProofreader_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIProofreaderCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CanCreateProofreader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateProofreader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIManager_CanCreateProofreader_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AIManagerProxy::CreateProofreader(
    ::mojo::PendingRemote<AIManagerCreateProofreaderClient> in_client, ::blink::mojom::AIProofreaderCreateOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::CreateProofreader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AIManagerCreateProofreaderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::AIProofreaderCreateOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCreateProofreader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CreateProofreader_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateProofreaderClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AIManager.CreateProofreader request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIProofreaderCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AIManager.CreateProofreader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CreateProofreader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerProxy::AddModelDownloadProgressObserver(
    ::mojo::PendingRemote<::blink::mojom::ModelDownloadProgressObserver> in_observer_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManager::AddModelDownloadProgressObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer_remote"), in_observer_remote,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::ModelDownloadProgressObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kAddModelDownloadProgressObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_AddModelDownloadProgressObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelDownloadProgressObserverInterfaceBase>>(
    in_observer_remote,
    &params->observer_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer_remote in AIManager.AddModelDownloadProgressObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("AddModelDownloadProgressObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AIManager_CanCreateLanguageModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::CanCreateLanguageModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_CanCreateLanguageModel_ProxyToResponder> proxy(
        new AIManager_CanCreateLanguageModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_CanCreateLanguageModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_CanCreateLanguageModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_CanCreateLanguageModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::CanCreateLanguageModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ModelAvailabilityCheckResult in_result);
};

bool AIManager_CanCreateLanguageModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_CanCreateLanguageModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_CanCreateLanguageModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.0
  bool success = true;
  ModelAvailabilityCheckResult p_result{};
  AIManager_CanCreateLanguageModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AIManager_CanCreateLanguageModel_ProxyToResponder::Run(
    ModelAvailabilityCheckResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::CanCreateLanguageModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ModelAvailabilityCheckResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateLanguageModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateLanguageModel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelAvailabilityCheckResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateLanguageModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AIManager_CanCreateSummarizer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::CanCreateSummarizerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_CanCreateSummarizer_ProxyToResponder> proxy(
        new AIManager_CanCreateSummarizer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_CanCreateSummarizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_CanCreateSummarizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_CanCreateSummarizer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::CanCreateSummarizerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ModelAvailabilityCheckResult in_result);
};

bool AIManager_CanCreateSummarizer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_CanCreateSummarizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_CanCreateSummarizer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.2
  bool success = true;
  ModelAvailabilityCheckResult p_result{};
  AIManager_CanCreateSummarizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AIManager_CanCreateSummarizer_ProxyToResponder::Run(
    ModelAvailabilityCheckResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::CanCreateSummarizer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ModelAvailabilityCheckResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateSummarizer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateSummarizer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelAvailabilityCheckResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateSummarizer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AIManager_GetLanguageModelParams_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::GetLanguageModelParamsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_GetLanguageModelParams_ProxyToResponder> proxy(
        new AIManager_GetLanguageModelParams_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_GetLanguageModelParams_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_GetLanguageModelParams_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_GetLanguageModelParams_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::GetLanguageModelParamsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::AILanguageModelParamsPtr in_language_model_params);
};

bool AIManager_GetLanguageModelParams_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_GetLanguageModelParams_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_GetLanguageModelParams_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.4
  bool success = true;
  ::blink::mojom::AILanguageModelParamsPtr p_language_model_params{};
  AIManager_GetLanguageModelParams_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLanguageModelParams(&p_language_model_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_language_model_params));
  }
  return true;
}

void AIManager_GetLanguageModelParams_ProxyToResponder::Run(
    ::blink::mojom::AILanguageModelParamsPtr in_language_model_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::GetLanguageModelParams", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language_model_params"), in_language_model_params,
                        "<value of type ::blink::mojom::AILanguageModelParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kGetLanguageModelParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_GetLanguageModelParams_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language_model_params)::BaseType> language_model_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AILanguageModelParamsDataView>(
    in_language_model_params,
    language_model_params_fragment);

  params->language_model_params.Set(
      language_model_params_fragment.is_null() ? nullptr : language_model_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("GetLanguageModelParams");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AIManager_CanCreateWriter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::CanCreateWriterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_CanCreateWriter_ProxyToResponder> proxy(
        new AIManager_CanCreateWriter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_CanCreateWriter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_CanCreateWriter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_CanCreateWriter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::CanCreateWriterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ModelAvailabilityCheckResult in_result);
};

bool AIManager_CanCreateWriter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_CanCreateWriter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_CanCreateWriter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.5
  bool success = true;
  ModelAvailabilityCheckResult p_result{};
  AIManager_CanCreateWriter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AIManager_CanCreateWriter_ProxyToResponder::Run(
    ModelAvailabilityCheckResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::CanCreateWriter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ModelAvailabilityCheckResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateWriter_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelAvailabilityCheckResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateWriter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AIManager_CanCreateRewriter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::CanCreateRewriterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_CanCreateRewriter_ProxyToResponder> proxy(
        new AIManager_CanCreateRewriter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_CanCreateRewriter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_CanCreateRewriter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_CanCreateRewriter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::CanCreateRewriterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ModelAvailabilityCheckResult in_result);
};

bool AIManager_CanCreateRewriter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_CanCreateRewriter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_CanCreateRewriter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.7
  bool success = true;
  ModelAvailabilityCheckResult p_result{};
  AIManager_CanCreateRewriter_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AIManager_CanCreateRewriter_ProxyToResponder::Run(
    ModelAvailabilityCheckResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::CanCreateRewriter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ModelAvailabilityCheckResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateRewriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateRewriter_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelAvailabilityCheckResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateRewriter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AIManager_CanCreateProofreader_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIManager::CanCreateProofreaderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIManager_CanCreateProofreader_ProxyToResponder> proxy(
        new AIManager_CanCreateProofreader_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIManager_CanCreateProofreader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIManager_CanCreateProofreader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIManager_CanCreateProofreader_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIManager::CanCreateProofreaderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ModelAvailabilityCheckResult in_result);
};

bool AIManager_CanCreateProofreader_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIManager_CanCreateProofreader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIManager_CanCreateProofreader_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIManager.9
  bool success = true;
  ModelAvailabilityCheckResult p_result{};
  AIManager_CanCreateProofreader_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIManager::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AIManager_CanCreateProofreader_ProxyToResponder::Run(
    ModelAvailabilityCheckResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIManager::CanCreateProofreader", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ModelAvailabilityCheckResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManager::kCanCreateProofreader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManager_CanCreateProofreader_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelAvailabilityCheckResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManager::Name_);
  message.set_method_name("CanCreateProofreader");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AIManagerStubDispatch::Accept(
    AIManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManager>(message->header()->name)) {
    case messages::AIManager::kCanCreateLanguageModel: {
      break;
    }
    case messages::AIManager::kCreateLanguageModel: {
      DCHECK(message->is_serialized());
      internal::AIManager_CreateLanguageModel_Params_Data* params =
          reinterpret_cast<internal::AIManager_CreateLanguageModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.1
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::AIManagerCreateLanguageModelClient> p_client{};
      ::blink::mojom::AILanguageModelCreateOptionsPtr p_options{};
      AIManager_CreateLanguageModel_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLanguageModel(        
        std::move(p_client), 
        std::move(p_options));
      return true;
    }
    case messages::AIManager::kCanCreateSummarizer: {
      break;
    }
    case messages::AIManager::kCreateSummarizer: {
      DCHECK(message->is_serialized());
      internal::AIManager_CreateSummarizer_Params_Data* params =
          reinterpret_cast<internal::AIManager_CreateSummarizer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.3
      bool success = true;
      ::mojo::PendingRemote<AIManagerCreateSummarizerClient> p_client{};
      ::blink::mojom::AISummarizerCreateOptionsPtr p_options{};
      AIManager_CreateSummarizer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSummarizer(        
        std::move(p_client), 
        std::move(p_options));
      return true;
    }
    case messages::AIManager::kGetLanguageModelParams: {
      break;
    }
    case messages::AIManager::kCanCreateWriter: {
      break;
    }
    case messages::AIManager::kCreateWriter: {
      DCHECK(message->is_serialized());
      internal::AIManager_CreateWriter_Params_Data* params =
          reinterpret_cast<internal::AIManager_CreateWriter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.6
      bool success = true;
      ::mojo::PendingRemote<AIManagerCreateWriterClient> p_client{};
      ::blink::mojom::AIWriterCreateOptionsPtr p_options{};
      AIManager_CreateWriter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWriter(        
        std::move(p_client), 
        std::move(p_options));
      return true;
    }
    case messages::AIManager::kCanCreateRewriter: {
      break;
    }
    case messages::AIManager::kCreateRewriter: {
      DCHECK(message->is_serialized());
      internal::AIManager_CreateRewriter_Params_Data* params =
          reinterpret_cast<internal::AIManager_CreateRewriter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.8
      bool success = true;
      ::mojo::PendingRemote<AIManagerCreateRewriterClient> p_client{};
      ::blink::mojom::AIRewriterCreateOptionsPtr p_options{};
      AIManager_CreateRewriter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRewriter(        
        std::move(p_client), 
        std::move(p_options));
      return true;
    }
    case messages::AIManager::kCanCreateProofreader: {
      break;
    }
    case messages::AIManager::kCreateProofreader: {
      DCHECK(message->is_serialized());
      internal::AIManager_CreateProofreader_Params_Data* params =
          reinterpret_cast<internal::AIManager_CreateProofreader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.10
      bool success = true;
      ::mojo::PendingRemote<AIManagerCreateProofreaderClient> p_client{};
      ::blink::mojom::AIProofreaderCreateOptionsPtr p_options{};
      AIManager_CreateProofreader_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProofreader(        
        std::move(p_client), 
        std::move(p_options));
      return true;
    }
    case messages::AIManager::kAddModelDownloadProgressObserver: {
      DCHECK(message->is_serialized());
      internal::AIManager_AddModelDownloadProgressObserver_Params_Data* params =
          reinterpret_cast<internal::AIManager_AddModelDownloadProgressObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManager.11
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::ModelDownloadProgressObserver> p_observer_remote{};
      AIManager_AddModelDownloadProgressObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer_remote =
            input_data_view.TakeObserverRemote<decltype(p_observer_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddModelDownloadProgressObserver(        
        std::move(p_observer_remote));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerStubDispatch::AcceptWithResponder(
    AIManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManager>(message->header()->name)) {
    case messages::AIManager::kCanCreateLanguageModel: {
      internal::AIManager_CanCreateLanguageModel_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_CanCreateLanguageModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.0
      bool success = true;
      ::blink::mojom::AILanguageModelCreateOptionsPtr p_options{};
      AIManager_CanCreateLanguageModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 0, false);
        return false;
      }
      auto callback =
          AIManager_CanCreateLanguageModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanCreateLanguageModel(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::AIManager::kCreateLanguageModel: {
      break;
    }
    case messages::AIManager::kCanCreateSummarizer: {
      internal::AIManager_CanCreateSummarizer_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_CanCreateSummarizer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.2
      bool success = true;
      ::blink::mojom::AISummarizerCreateOptionsPtr p_options{};
      AIManager_CanCreateSummarizer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 2, false);
        return false;
      }
      auto callback =
          AIManager_CanCreateSummarizer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanCreateSummarizer(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::AIManager::kCreateSummarizer: {
      break;
    }
    case messages::AIManager::kGetLanguageModelParams: {
      internal::AIManager_GetLanguageModelParams_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_GetLanguageModelParams_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.4
      bool success = true;
      AIManager_GetLanguageModelParams_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 4, false);
        return false;
      }
      auto callback =
          AIManager_GetLanguageModelParams_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLanguageModelParams(std::move(callback));
      return true;
    }
    case messages::AIManager::kCanCreateWriter: {
      internal::AIManager_CanCreateWriter_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_CanCreateWriter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.5
      bool success = true;
      ::blink::mojom::AIWriterCreateOptionsPtr p_options{};
      AIManager_CanCreateWriter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 5, false);
        return false;
      }
      auto callback =
          AIManager_CanCreateWriter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanCreateWriter(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::AIManager::kCreateWriter: {
      break;
    }
    case messages::AIManager::kCanCreateRewriter: {
      internal::AIManager_CanCreateRewriter_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_CanCreateRewriter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.7
      bool success = true;
      ::blink::mojom::AIRewriterCreateOptionsPtr p_options{};
      AIManager_CanCreateRewriter_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 7, false);
        return false;
      }
      auto callback =
          AIManager_CanCreateRewriter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanCreateRewriter(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::AIManager::kCreateRewriter: {
      break;
    }
    case messages::AIManager::kCanCreateProofreader: {
      internal::AIManager_CanCreateProofreader_Params_Data* params =
          reinterpret_cast<
              internal::AIManager_CanCreateProofreader_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIManager.9
      bool success = true;
      ::blink::mojom::AIProofreaderCreateOptionsPtr p_options{};
      AIManager_CanCreateProofreader_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManager::Name_, 9, false);
        return false;
      }
      auto callback =
          AIManager_CanCreateProofreader_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanCreateProofreader(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::AIManager::kCreateProofreader: {
      break;
    }
    case messages::AIManager::kAddModelDownloadProgressObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerValidationInfo[] = {
    { &internal::AIManager_CanCreateLanguageModel_Params_Data::Validate,
     &internal::AIManager_CanCreateLanguageModel_ResponseParams_Data::Validate},
    { &internal::AIManager_CreateLanguageModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManager_CanCreateSummarizer_Params_Data::Validate,
     &internal::AIManager_CanCreateSummarizer_ResponseParams_Data::Validate},
    { &internal::AIManager_CreateSummarizer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManager_GetLanguageModelParams_Params_Data::Validate,
     &internal::AIManager_GetLanguageModelParams_ResponseParams_Data::Validate},
    { &internal::AIManager_CanCreateWriter_Params_Data::Validate,
     &internal::AIManager_CanCreateWriter_ResponseParams_Data::Validate},
    { &internal::AIManager_CreateWriter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManager_CanCreateRewriter_Params_Data::Validate,
     &internal::AIManager_CanCreateRewriter_ResponseParams_Data::Validate},
    { &internal::AIManager_CreateRewriter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManager_CanCreateProofreader_Params_Data::Validate,
     &internal::AIManager_CanCreateProofreader_ResponseParams_Data::Validate},
    { &internal::AIManager_CreateProofreader_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManager_AddModelDownloadProgressObserver_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIManager::Name_,
    kAIManagerValidationInfo);
}

bool AIManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::AIManager::Name_,
    kAIManagerValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AIManagerCreateWriterClientInterceptorForTesting::OnResult(::mojo::PendingRemote<::blink::mojom::AIWriter> writer) {
  GetForwardingInterface()->OnResult(
    std::move(writer)
    );
}
void AIManagerCreateWriterClientInterceptorForTesting::OnError(::blink::mojom::AIManagerCreateClientError error, ::blink::mojom::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(quota_error_info)
    );
}
AIManagerCreateWriterClientAsyncWaiter::AIManagerCreateWriterClientAsyncWaiter(
    AIManagerCreateWriterClient* proxy) : proxy_(proxy) {}

AIManagerCreateWriterClientAsyncWaiter::~AIManagerCreateWriterClientAsyncWaiter() = default;





void AIManagerCreateRewriterClientInterceptorForTesting::OnResult(::mojo::PendingRemote<::blink::mojom::AIRewriter> rewriter) {
  GetForwardingInterface()->OnResult(
    std::move(rewriter)
    );
}
void AIManagerCreateRewriterClientInterceptorForTesting::OnError(::blink::mojom::AIManagerCreateClientError error, ::blink::mojom::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(quota_error_info)
    );
}
AIManagerCreateRewriterClientAsyncWaiter::AIManagerCreateRewriterClientAsyncWaiter(
    AIManagerCreateRewriterClient* proxy) : proxy_(proxy) {}

AIManagerCreateRewriterClientAsyncWaiter::~AIManagerCreateRewriterClientAsyncWaiter() = default;





void AIManagerCreateSummarizerClientInterceptorForTesting::OnResult(::mojo::PendingRemote<::blink::mojom::AISummarizer> summarizer) {
  GetForwardingInterface()->OnResult(
    std::move(summarizer)
    );
}
void AIManagerCreateSummarizerClientInterceptorForTesting::OnError(::blink::mojom::AIManagerCreateClientError error, ::blink::mojom::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(quota_error_info)
    );
}
AIManagerCreateSummarizerClientAsyncWaiter::AIManagerCreateSummarizerClientAsyncWaiter(
    AIManagerCreateSummarizerClient* proxy) : proxy_(proxy) {}

AIManagerCreateSummarizerClientAsyncWaiter::~AIManagerCreateSummarizerClientAsyncWaiter() = default;





void AIManagerCreateProofreaderClientInterceptorForTesting::OnResult(::mojo::PendingRemote<::blink::mojom::AIProofreader> proofreader) {
  GetForwardingInterface()->OnResult(
    std::move(proofreader)
    );
}
void AIManagerCreateProofreaderClientInterceptorForTesting::OnError(::blink::mojom::AIManagerCreateClientError error, ::blink::mojom::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(quota_error_info)
    );
}
AIManagerCreateProofreaderClientAsyncWaiter::AIManagerCreateProofreaderClientAsyncWaiter(
    AIManagerCreateProofreaderClient* proxy) : proxy_(proxy) {}

AIManagerCreateProofreaderClientAsyncWaiter::~AIManagerCreateProofreaderClientAsyncWaiter() = default;





void AIManagerInterceptorForTesting::CanCreateLanguageModel(::blink::mojom::AILanguageModelCreateOptionsPtr options, CanCreateLanguageModelCallback callback) {
  GetForwardingInterface()->CanCreateLanguageModel(
    std::move(options)
    , std::move(callback));
}
void AIManagerInterceptorForTesting::CreateLanguageModel(::mojo::PendingRemote<::blink::mojom::AIManagerCreateLanguageModelClient> client, ::blink::mojom::AILanguageModelCreateOptionsPtr options) {
  GetForwardingInterface()->CreateLanguageModel(
    std::move(client)
    , 
    std::move(options)
    );
}
void AIManagerInterceptorForTesting::CanCreateSummarizer(::blink::mojom::AISummarizerCreateOptionsPtr options, CanCreateSummarizerCallback callback) {
  GetForwardingInterface()->CanCreateSummarizer(
    std::move(options)
    , std::move(callback));
}
void AIManagerInterceptorForTesting::CreateSummarizer(::mojo::PendingRemote<AIManagerCreateSummarizerClient> client, ::blink::mojom::AISummarizerCreateOptionsPtr options) {
  GetForwardingInterface()->CreateSummarizer(
    std::move(client)
    , 
    std::move(options)
    );
}
void AIManagerInterceptorForTesting::GetLanguageModelParams(GetLanguageModelParamsCallback callback) {
  GetForwardingInterface()->GetLanguageModelParams(std::move(callback));
}
void AIManagerInterceptorForTesting::CanCreateWriter(::blink::mojom::AIWriterCreateOptionsPtr options, CanCreateWriterCallback callback) {
  GetForwardingInterface()->CanCreateWriter(
    std::move(options)
    , std::move(callback));
}
void AIManagerInterceptorForTesting::CreateWriter(::mojo::PendingRemote<AIManagerCreateWriterClient> client, ::blink::mojom::AIWriterCreateOptionsPtr options) {
  GetForwardingInterface()->CreateWriter(
    std::move(client)
    , 
    std::move(options)
    );
}
void AIManagerInterceptorForTesting::CanCreateRewriter(::blink::mojom::AIRewriterCreateOptionsPtr options, CanCreateRewriterCallback callback) {
  GetForwardingInterface()->CanCreateRewriter(
    std::move(options)
    , std::move(callback));
}
void AIManagerInterceptorForTesting::CreateRewriter(::mojo::PendingRemote<AIManagerCreateRewriterClient> client, ::blink::mojom::AIRewriterCreateOptionsPtr options) {
  GetForwardingInterface()->CreateRewriter(
    std::move(client)
    , 
    std::move(options)
    );
}
void AIManagerInterceptorForTesting::CanCreateProofreader(::blink::mojom::AIProofreaderCreateOptionsPtr options, CanCreateProofreaderCallback callback) {
  GetForwardingInterface()->CanCreateProofreader(
    std::move(options)
    , std::move(callback));
}
void AIManagerInterceptorForTesting::CreateProofreader(::mojo::PendingRemote<AIManagerCreateProofreaderClient> client, ::blink::mojom::AIProofreaderCreateOptionsPtr options) {
  GetForwardingInterface()->CreateProofreader(
    std::move(client)
    , 
    std::move(options)
    );
}
void AIManagerInterceptorForTesting::AddModelDownloadProgressObserver(::mojo::PendingRemote<::blink::mojom::ModelDownloadProgressObserver> observer_remote) {
  GetForwardingInterface()->AddModelDownloadProgressObserver(
    std::move(observer_remote)
    );
}
AIManagerAsyncWaiter::AIManagerAsyncWaiter(
    AIManager* proxy) : proxy_(proxy) {}

AIManagerAsyncWaiter::~AIManagerAsyncWaiter() = default;


void AIManagerAsyncWaiter::CanCreateLanguageModel(
    ::blink::mojom::AILanguageModelCreateOptionsPtr options, ModelAvailabilityCheckResult* out_result) {
  base::RunLoop loop;
  proxy_->CanCreateLanguageModel(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ModelAvailabilityCheckResult* out_result
,
             ModelAvailabilityCheckResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ModelAvailabilityCheckResult AIManagerAsyncWaiter::CanCreateLanguageModel(
    ::blink::mojom::AILanguageModelCreateOptionsPtr options) {
  ModelAvailabilityCheckResult async_wait_result;
  CanCreateLanguageModel(std::move(options),&async_wait_result);
  return async_wait_result;
}

void AIManagerAsyncWaiter::CanCreateSummarizer(
    ::blink::mojom::AISummarizerCreateOptionsPtr options, ModelAvailabilityCheckResult* out_result) {
  base::RunLoop loop;
  proxy_->CanCreateSummarizer(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ModelAvailabilityCheckResult* out_result
,
             ModelAvailabilityCheckResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ModelAvailabilityCheckResult AIManagerAsyncWaiter::CanCreateSummarizer(
    ::blink::mojom::AISummarizerCreateOptionsPtr options) {
  ModelAvailabilityCheckResult async_wait_result;
  CanCreateSummarizer(std::move(options),&async_wait_result);
  return async_wait_result;
}

void AIManagerAsyncWaiter::GetLanguageModelParams(
    ::blink::mojom::AILanguageModelParamsPtr* out_language_model_params) {
  base::RunLoop loop;
  proxy_->GetLanguageModelParams(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::AILanguageModelParamsPtr* out_language_model_params
,
             ::blink::mojom::AILanguageModelParamsPtr language_model_params) {*out_language_model_params = std::move(language_model_params);
            loop->Quit();
          },
          &loop,
          out_language_model_params));
  loop.Run();
}

::blink::mojom::AILanguageModelParamsPtr AIManagerAsyncWaiter::GetLanguageModelParams(
    ) {
  ::blink::mojom::AILanguageModelParamsPtr async_wait_result;
  GetLanguageModelParams(&async_wait_result);
  return async_wait_result;
}

void AIManagerAsyncWaiter::CanCreateWriter(
    ::blink::mojom::AIWriterCreateOptionsPtr options, ModelAvailabilityCheckResult* out_result) {
  base::RunLoop loop;
  proxy_->CanCreateWriter(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ModelAvailabilityCheckResult* out_result
,
             ModelAvailabilityCheckResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ModelAvailabilityCheckResult AIManagerAsyncWaiter::CanCreateWriter(
    ::blink::mojom::AIWriterCreateOptionsPtr options) {
  ModelAvailabilityCheckResult async_wait_result;
  CanCreateWriter(std::move(options),&async_wait_result);
  return async_wait_result;
}

void AIManagerAsyncWaiter::CanCreateRewriter(
    ::blink::mojom::AIRewriterCreateOptionsPtr options, ModelAvailabilityCheckResult* out_result) {
  base::RunLoop loop;
  proxy_->CanCreateRewriter(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ModelAvailabilityCheckResult* out_result
,
             ModelAvailabilityCheckResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ModelAvailabilityCheckResult AIManagerAsyncWaiter::CanCreateRewriter(
    ::blink::mojom::AIRewriterCreateOptionsPtr options) {
  ModelAvailabilityCheckResult async_wait_result;
  CanCreateRewriter(std::move(options),&async_wait_result);
  return async_wait_result;
}

void AIManagerAsyncWaiter::CanCreateProofreader(
    ::blink::mojom::AIProofreaderCreateOptionsPtr options, ModelAvailabilityCheckResult* out_result) {
  base::RunLoop loop;
  proxy_->CanCreateProofreader(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ModelAvailabilityCheckResult* out_result
,
             ModelAvailabilityCheckResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ModelAvailabilityCheckResult AIManagerAsyncWaiter::CanCreateProofreader(
    ::blink::mojom::AIProofreaderCreateOptionsPtr options) {
  ModelAvailabilityCheckResult async_wait_result;
  CanCreateProofreader(std::move(options),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif