// third_party/blink/public/mojom/ai/ai_language_model.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared-internal.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/ai/ai_common.mojom-shared.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.h"


namespace blink::mojom {
class AILanguageModelSamplingParamsDataView;

class AILanguageModelParamsDataView;

class AILanguageModelInstanceInfoDataView;

class AILanguageModelExpectedDataView;

class AILanguageModelPromptDataView;

class AILanguageModelCreateOptionsDataView;

class AILanguageModelPromptContentDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelSamplingParamsDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelSamplingParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelParamsDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelInstanceInfoDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelInstanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelExpectedDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelExpected_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelPromptDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelPrompt_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelCreateOptionsDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelCreateOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageModelPromptContentDataView> {
  using Data = ::blink::mojom::internal::AILanguageModelPromptContent_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AILanguageModelPromptRole : int32_t {
  
  kSystem = 0,
  
  kUser = 1,
  
  kAssistant = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AILanguageModelPromptRole value);
inline bool IsKnownEnumValue(AILanguageModelPromptRole value) {
  return internal::AILanguageModelPromptRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AILanguageModelPromptType : int32_t {
  
  kText = 0,
  
  kImage = 1,
  
  kAudio = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AILanguageModelPromptType value);
inline bool IsKnownEnumValue(AILanguageModelPromptType value) {
  return internal::AILanguageModelPromptType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AIManagerCreateLanguageModelClientInterfaceBase {};

using AIManagerCreateLanguageModelClientPtrDataView =
    mojo::InterfacePtrDataView<AIManagerCreateLanguageModelClientInterfaceBase>;
using AIManagerCreateLanguageModelClientRequestDataView =
    mojo::InterfaceRequestDataView<AIManagerCreateLanguageModelClientInterfaceBase>;
using AIManagerCreateLanguageModelClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AIManagerCreateLanguageModelClientInterfaceBase>;
using AIManagerCreateLanguageModelClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AIManagerCreateLanguageModelClientInterfaceBase>;
class AILanguageModelInterfaceBase {};

using AILanguageModelPtrDataView =
    mojo::InterfacePtrDataView<AILanguageModelInterfaceBase>;
using AILanguageModelRequestDataView =
    mojo::InterfaceRequestDataView<AILanguageModelInterfaceBase>;
using AILanguageModelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AILanguageModelInterfaceBase>;
using AILanguageModelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AILanguageModelInterfaceBase>;


class AILanguageModelSamplingParamsDataView {
 public:
  AILanguageModelSamplingParamsDataView() = default;

  AILanguageModelSamplingParamsDataView(
      internal::AILanguageModelSamplingParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t top_k() const {
    return data_->top_k;
  }
  float temperature() const {
    return data_->temperature;
  }
 private:
  internal::AILanguageModelSamplingParams_Data* data_ = nullptr;
};


class AILanguageModelParamsDataView {
 public:
  AILanguageModelParamsDataView() = default;

  AILanguageModelParamsDataView(
      internal::AILanguageModelParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDefaultSamplingParamsDataView(
      AILanguageModelSamplingParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultSamplingParams(UserType* output) {
    
    auto* pointer = data_->default_sampling_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
        pointer, output, message_);
  }
  inline void GetMaxSamplingParamsDataView(
      AILanguageModelSamplingParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxSamplingParams(UserType* output) {
    
    auto* pointer = data_->max_sampling_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AILanguageModelParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AILanguageModelInstanceInfoDataView {
 public:
  AILanguageModelInstanceInfoDataView() = default;

  AILanguageModelInstanceInfoDataView(
      internal::AILanguageModelInstanceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t input_quota() const {
    return data_->input_quota;
  }
  uint64_t input_usage() const {
    return data_->input_usage;
  }
  inline void GetSamplingParamsDataView(
      AILanguageModelSamplingParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSamplingParams(UserType* output) {
    
    auto* pointer = data_->sampling_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
        pointer, output, message_);
  }
  inline void GetInputTypesDataView(
      mojo::ArrayDataView<AILanguageModelPromptType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptType>, UserType>(),
    "Attempting to read the optional `input_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputTypes` instead "
    "of `ReadInputTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptType>>(
        pointer, output, message_);
  }
 private:
  internal::AILanguageModelInstanceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AILanguageModelExpectedDataView {
 public:
  AILanguageModelExpectedDataView() = default;

  AILanguageModelExpectedDataView(
      internal::AILanguageModelExpected_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelPromptType>(
        data_value, output);
  }
  AILanguageModelPromptType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AILanguageModelPromptType>(data_->type));
  }
  inline void GetLanguagesDataView(
      mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguages(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>, UserType>(),
    "Attempting to read the optional `languages` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLanguages` instead "
    "of `ReadLanguages if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->languages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AILanguageModelExpected_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AILanguageModelPromptDataView {
 public:
  AILanguageModelPromptDataView() = default;

  AILanguageModelPromptDataView(
      internal::AILanguageModelPrompt_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelPromptRole>(
        data_value, output);
  }
  AILanguageModelPromptRole role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AILanguageModelPromptRole>(data_->role));
  }
  inline void GetContentDataView(
      mojo::ArrayDataView<AILanguageModelPromptContentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptContentDataView>>(
        pointer, output, message_);
  }
  bool is_prefix() const {
    return data_->is_prefix;
  }
 private:
  internal::AILanguageModelPrompt_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AILanguageModelCreateOptionsDataView {
 public:
  AILanguageModelCreateOptionsDataView() = default;

  AILanguageModelCreateOptionsDataView(
      internal::AILanguageModelCreateOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSamplingParamsDataView(
      AILanguageModelSamplingParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSamplingParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AILanguageModelSamplingParamsDataView, UserType>(),
    "Attempting to read the optional `sampling_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSamplingParams` instead "
    "of `ReadSamplingParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sampling_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
        pointer, output, message_);
  }
  inline void GetInitialPromptsDataView(
      mojo::ArrayDataView<AILanguageModelPromptDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialPrompts(UserType* output) {
    
    auto* pointer = data_->initial_prompts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptDataView>>(
        pointer, output, message_);
  }
  inline void GetExpectedInputsDataView(
      mojo::ArrayDataView<AILanguageModelExpectedDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedInputs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>, UserType>(),
    "Attempting to read the optional `expected_inputs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpectedInputs` instead "
    "of `ReadExpectedInputs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expected_inputs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>>(
        pointer, output, message_);
  }
  inline void GetExpectedOutputsDataView(
      mojo::ArrayDataView<AILanguageModelExpectedDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedOutputs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>, UserType>(),
    "Attempting to read the optional `expected_outputs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpectedOutputs` instead "
    "of `ReadExpectedOutputs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expected_outputs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AILanguageModelCreateOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AILanguageModelPromptContentDataView {
 public:
  using Tag = internal::AILanguageModelPromptContent_Data::AILanguageModelPromptContent_Tag;

  AILanguageModelPromptContentDataView() = default;

  AILanguageModelPromptContentDataView(
      internal::AILanguageModelPromptContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_text() const { return data_->tag == Tag::kText; }
  inline void GetTextDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) const {
    
    CHECK(is_text());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_text.Get(), output, message_);
  }
  bool is_bitmap() const { return data_->tag == Tag::kBitmap; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapN32DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) const {
    
    CHECK(is_bitmap());
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        data_->data.f_bitmap.Get(), output, message_);
  }
  bool is_audio() const { return data_->tag == Tag::kAudio; }
  inline void GetAudioDataView(
      ::on_device_model::mojom::AudioDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAudio(UserType* output) const {
    
    CHECK(is_audio());
    return mojo::internal::Deserialize<::on_device_model::mojom::AudioDataDataView>(
        data_->data.f_audio.Get(), output, message_);
  }

 private:
  internal::AILanguageModelPromptContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_DATA_VIEW_H_