// third_party/blink/public/mojom/ai/ai_language_model.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-params-data.h"
#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
AILanguageModelSamplingParams::AILanguageModelSamplingParams()
    : top_k(),
      temperature() {}

AILanguageModelSamplingParams::AILanguageModelSamplingParams(
    uint32_t top_k_in,
    float temperature_in)
    : top_k(std::move(top_k_in)),
      temperature(std::move(temperature_in)) {}

AILanguageModelSamplingParams::~AILanguageModelSamplingParams() = default;
size_t AILanguageModelSamplingParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->top_k);
  seed = mojo::internal::WTFHash(seed, this->temperature);
  return seed;
}

void AILanguageModelSamplingParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_k"), this->top_k,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temperature"), this->temperature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelSamplingParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelParams::AILanguageModelParams()
    : default_sampling_params(),
      max_sampling_params() {}

AILanguageModelParams::AILanguageModelParams(
    AILanguageModelSamplingParamsPtr default_sampling_params_in,
    AILanguageModelSamplingParamsPtr max_sampling_params_in)
    : default_sampling_params(std::move(default_sampling_params_in)),
      max_sampling_params(std::move(max_sampling_params_in)) {}

AILanguageModelParams::~AILanguageModelParams() = default;
size_t AILanguageModelParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->default_sampling_params);
  seed = mojo::internal::WTFHash(seed, this->max_sampling_params);
  return seed;
}

void AILanguageModelParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_sampling_params"), this->default_sampling_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelSamplingParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_sampling_params"), this->max_sampling_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelSamplingParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelInstanceInfo::AILanguageModelInstanceInfo()
    : input_quota(),
      input_usage(),
      sampling_params(),
      input_types() {}

AILanguageModelInstanceInfo::AILanguageModelInstanceInfo(
    uint64_t input_quota_in,
    uint64_t input_usage_in,
    AILanguageModelSamplingParamsPtr sampling_params_in,
    std::optional<::blink::Vector<AILanguageModelPromptType>> input_types_in)
    : input_quota(std::move(input_quota_in)),
      input_usage(std::move(input_usage_in)),
      sampling_params(std::move(sampling_params_in)),
      input_types(std::move(input_types_in)) {}

AILanguageModelInstanceInfo::~AILanguageModelInstanceInfo() = default;

void AILanguageModelInstanceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_quota"), this->input_quota,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_usage"), this->input_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampling_params"), this->sampling_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelSamplingParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_types"), this->input_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<AILanguageModelPromptType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelInstanceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelExpected::AILanguageModelExpected()
    : type(),
      languages() {}

AILanguageModelExpected::AILanguageModelExpected(
    AILanguageModelPromptType type_in,
    std::optional<::blink::Vector<::blink::mojom::blink::AILanguageCodePtr>> languages_in)
    : type(std::move(type_in)),
      languages(std::move(languages_in)) {}

AILanguageModelExpected::~AILanguageModelExpected() = default;

void AILanguageModelExpected::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelPromptType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "languages"), this->languages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<::blink::mojom::blink::AILanguageCodePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelExpected::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelPrompt::AILanguageModelPrompt()
    : role(),
      content(),
      is_prefix(false) {}

AILanguageModelPrompt::AILanguageModelPrompt(
    AILanguageModelPromptRole role_in,
    ::blink::Vector<AILanguageModelPromptContentPtr> content_in,
    bool is_prefix_in)
    : role(std::move(role_in)),
      content(std::move(content_in)),
      is_prefix(std::move(is_prefix_in)) {}

AILanguageModelPrompt::~AILanguageModelPrompt() = default;

void AILanguageModelPrompt::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "role"), this->role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelPromptRole>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AILanguageModelPromptContentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_prefix"), this->is_prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelPrompt::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelCreateOptions::AILanguageModelCreateOptions()
    : sampling_params(),
      initial_prompts(),
      expected_inputs(),
      expected_outputs() {}

AILanguageModelCreateOptions::AILanguageModelCreateOptions(
    AILanguageModelSamplingParamsPtr sampling_params_in,
    ::blink::Vector<AILanguageModelPromptPtr> initial_prompts_in,
    std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_inputs_in,
    std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_outputs_in)
    : sampling_params(std::move(sampling_params_in)),
      initial_prompts(std::move(initial_prompts_in)),
      expected_inputs(std::move(expected_inputs_in)),
      expected_outputs(std::move(expected_outputs_in)) {}

AILanguageModelCreateOptions::~AILanguageModelCreateOptions() = default;

void AILanguageModelCreateOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampling_params"), this->sampling_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AILanguageModelSamplingParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_prompts"), this->initial_prompts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AILanguageModelPromptPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_inputs"), this->expected_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<AILanguageModelExpectedPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_outputs"), this->expected_outputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<AILanguageModelExpectedPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AILanguageModelCreateOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AILanguageModelPromptContentPtr
AILanguageModelPromptContent::NewText(
    const ::blink::String& value) {
  return AILanguageModelPromptContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kText)>,
      std::move(value));
}

AILanguageModelPromptContentPtr
AILanguageModelPromptContent::NewBitmap(
    const ::SkBitmap& value) {
  return AILanguageModelPromptContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
      std::move(value));
}

AILanguageModelPromptContentPtr
AILanguageModelPromptContent::NewAudio(
    ::on_device_model::mojom::blink::AudioDataPtr value) {
  return AILanguageModelPromptContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAudio)>,
      std::move(value));
}

AILanguageModelPromptContent::AILanguageModelPromptContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const ::blink::String& value)
    : tag_(Tag::kText),
      data_(std::in_place_index<static_cast<size_t>(Tag::kText)>,
            std::move(value)) {}

AILanguageModelPromptContent::AILanguageModelPromptContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : tag_(Tag::kBitmap),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
            std::move(value)) {}

AILanguageModelPromptContent::AILanguageModelPromptContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
    ::on_device_model::mojom::blink::AudioDataPtr value)
    : tag_(Tag::kAudio),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAudio)>,
            std::move(value)) {}
AILanguageModelPromptContent::~AILanguageModelPromptContent() {
  DestroyActive();
}

void AILanguageModelPromptContent::set_text(const ::blink::String& text) {
  if (tag_ == Tag::kText) {
    data_.text = std::move(text);
  } else {
    DestroyActive();
    tag_ = Tag::kText;
    new (&data_.text) ::blink::String(
        std::move(text));
  }
}

void AILanguageModelPromptContent::set_bitmap(const ::SkBitmap& bitmap) {
  if (tag_ == Tag::kBitmap) {
    data_.bitmap = std::move(bitmap);
  } else {
    DestroyActive();
    tag_ = Tag::kBitmap;
    new (&data_.bitmap) ::SkBitmap(
        std::move(bitmap));
  }
}

void AILanguageModelPromptContent::set_audio(::on_device_model::mojom::blink::AudioDataPtr audio) {
  if (tag_ == Tag::kAudio) {
    data_.audio = std::move(audio);
  } else {
    DestroyActive();
    tag_ = Tag::kAudio;
    new (&data_.audio) ::on_device_model::mojom::blink::AudioDataPtr(
        std::move(audio));
  }
}


AILanguageModelPromptContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const ::blink::String& value)
    : text(std::move(value)) {}

AILanguageModelPromptContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : bitmap(std::move(value)) {}

AILanguageModelPromptContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
    ::on_device_model::mojom::blink::AudioDataPtr value)
    : audio(std::move(value)) {}

void AILanguageModelPromptContent::DestroyActive() {
  switch (tag_) {

    case Tag::kText:
      std::destroy_at(&data_.text);
      break;
    case Tag::kBitmap:
      std::destroy_at(&data_.bitmap);
      break;
    case Tag::kAudio:
      std::destroy_at(&data_.audio);
      break;
  }
}

bool AILanguageModelPromptContent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

AIManagerCreateLanguageModelClient::IPCStableHashFunction AIManagerCreateLanguageModelClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIManagerCreateLanguageModelClient>(message.name())) {
    case messages::AIManagerCreateLanguageModelClient::kOnResult: {
      return &AIManagerCreateLanguageModelClient::OnResult_Sym::IPCStableHash;
    }
    case messages::AIManagerCreateLanguageModelClient::kOnError: {
      return &AIManagerCreateLanguageModelClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIManagerCreateLanguageModelClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIManagerCreateLanguageModelClient>(message.name())) {
      case messages::AIManagerCreateLanguageModelClient::kOnResult:
            return "Receive blink::mojom::AIManagerCreateLanguageModelClient::OnResult";
      case messages::AIManagerCreateLanguageModelClient::kOnError:
            return "Receive blink::mojom::AIManagerCreateLanguageModelClient::OnError";
    }
  } else {
    switch (static_cast<messages::AIManagerCreateLanguageModelClient>(message.name())) {
      case messages::AIManagerCreateLanguageModelClient::kOnResult:
            return "Receive reply blink::mojom::AIManagerCreateLanguageModelClient::OnResult";
      case messages::AIManagerCreateLanguageModelClient::kOnError:
            return "Receive reply blink::mojom::AIManagerCreateLanguageModelClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIManagerCreateLanguageModelClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6266b81e;  // IPCStableHash for blink::mojom::AIManagerCreateLanguageModelClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AIManagerCreateLanguageModelClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31f41c55;  // IPCStableHash for blink::mojom::AIManagerCreateLanguageModelClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AIManagerCreateLanguageModelClientProxy::AIManagerCreateLanguageModelClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIManagerCreateLanguageModelClientProxy::OnResult(
    ::mojo::PendingRemote<AILanguageModel> in_language_model_remote, AILanguageModelInstanceInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateLanguageModelClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language_model_remote"), in_language_model_remote,
                        "<value of type ::mojo::PendingRemote<AILanguageModel>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type AILanguageModelInstanceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateLanguageModelClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateLanguageModelClient_OnResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AILanguageModelInterfaceBase>>(
    in_language_model_remote,
    &params->language_model_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->language_model_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid language_model_remote in AIManagerCreateLanguageModelClient.OnResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AILanguageModelInstanceInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in AIManagerCreateLanguageModelClient.OnResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateLanguageModelClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AIManagerCreateLanguageModelClientProxy::OnError(
    ::blink::mojom::blink::AIManagerCreateClientError in_error, ::blink::mojom::blink::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIManagerCreateLanguageModelClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::AIManagerCreateClientError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::blink::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIManagerCreateLanguageModelClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIManagerCreateLanguageModelClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AIManagerCreateClientError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIManagerCreateLanguageModelClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AIManagerCreateLanguageModelClientStubDispatch::Accept(
    AIManagerCreateLanguageModelClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIManagerCreateLanguageModelClient>(message->header()->name)) {
    case messages::AIManagerCreateLanguageModelClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateLanguageModelClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateLanguageModelClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateLanguageModelClient.0
      bool success = true;
      ::mojo::PendingRemote<AILanguageModel> p_language_model_remote{};
      AILanguageModelInstanceInfoPtr p_info{};
      AIManagerCreateLanguageModelClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_language_model_remote =
            input_data_view.TakeLanguageModelRemote<decltype(p_language_model_remote)>();
      }
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateLanguageModelClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_language_model_remote), 
        std::move(p_info));
      return true;
    }
    case messages::AIManagerCreateLanguageModelClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AIManagerCreateLanguageModelClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AIManagerCreateLanguageModelClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AIManagerCreateLanguageModelClient.1
      bool success = true;
      ::blink::mojom::blink::AIManagerCreateClientError p_error{};
      ::blink::mojom::blink::QuotaErrorInfoPtr p_quota_error_info{};
      AIManagerCreateLanguageModelClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIManagerCreateLanguageModelClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_quota_error_info));
      return true;
    }
  }
  return false;
}

// static
bool AIManagerCreateLanguageModelClientStubDispatch::AcceptWithResponder(
    AIManagerCreateLanguageModelClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIManagerCreateLanguageModelClient>(message->header()->name)) {
    case messages::AIManagerCreateLanguageModelClient::kOnResult: {
      break;
    }
    case messages::AIManagerCreateLanguageModelClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIManagerCreateLanguageModelClientValidationInfo[] = {
    { &internal::AIManagerCreateLanguageModelClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AIManagerCreateLanguageModelClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool AIManagerCreateLanguageModelClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AIManagerCreateLanguageModelClient::Name_,
    kAIManagerCreateLanguageModelClientValidationInfo);
}

// The declaration includes the definition on other builds.

AILanguageModel::IPCStableHashFunction AILanguageModel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AILanguageModel>(message.name())) {
    case messages::AILanguageModel::kPrompt: {
      return &AILanguageModel::Prompt_Sym::IPCStableHash;
    }
    case messages::AILanguageModel::kAppend: {
      return &AILanguageModel::Append_Sym::IPCStableHash;
    }
    case messages::AILanguageModel::kFork: {
      return &AILanguageModel::Fork_Sym::IPCStableHash;
    }
    case messages::AILanguageModel::kDestroy: {
      return &AILanguageModel::Destroy_Sym::IPCStableHash;
    }
    case messages::AILanguageModel::kMeasureInputUsage: {
      return &AILanguageModel::MeasureInputUsage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AILanguageModel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AILanguageModel>(message.name())) {
      case messages::AILanguageModel::kPrompt:
            return "Receive blink::mojom::AILanguageModel::Prompt";
      case messages::AILanguageModel::kAppend:
            return "Receive blink::mojom::AILanguageModel::Append";
      case messages::AILanguageModel::kFork:
            return "Receive blink::mojom::AILanguageModel::Fork";
      case messages::AILanguageModel::kDestroy:
            return "Receive blink::mojom::AILanguageModel::Destroy";
      case messages::AILanguageModel::kMeasureInputUsage:
            return "Receive blink::mojom::AILanguageModel::MeasureInputUsage";
    }
  } else {
    switch (static_cast<messages::AILanguageModel>(message.name())) {
      case messages::AILanguageModel::kPrompt:
            return "Receive reply blink::mojom::AILanguageModel::Prompt";
      case messages::AILanguageModel::kAppend:
            return "Receive reply blink::mojom::AILanguageModel::Append";
      case messages::AILanguageModel::kFork:
            return "Receive reply blink::mojom::AILanguageModel::Fork";
      case messages::AILanguageModel::kDestroy:
            return "Receive reply blink::mojom::AILanguageModel::Destroy";
      case messages::AILanguageModel::kMeasureInputUsage:
            return "Receive reply blink::mojom::AILanguageModel::MeasureInputUsage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AILanguageModel::Prompt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4e23c0f;  // IPCStableHash for blink::mojom::AILanguageModel::Prompt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AILanguageModel::Append_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4574e47f;  // IPCStableHash for blink::mojom::AILanguageModel::Append
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AILanguageModel::Fork_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69f22cdb;  // IPCStableHash for blink::mojom::AILanguageModel::Fork
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AILanguageModel::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ef7b444;  // IPCStableHash for blink::mojom::AILanguageModel::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AILanguageModel::MeasureInputUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5bfbb717;  // IPCStableHash for blink::mojom::AILanguageModel::MeasureInputUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AILanguageModel_MeasureInputUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AILanguageModel_MeasureInputUsage_ForwardToCallback(
      AILanguageModel::MeasureInputUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  AILanguageModel_MeasureInputUsage_ForwardToCallback(const AILanguageModel_MeasureInputUsage_ForwardToCallback&) = delete;
  AILanguageModel_MeasureInputUsage_ForwardToCallback& operator=(const AILanguageModel_MeasureInputUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AILanguageModel::MeasureInputUsageCallback callback_;
};

AILanguageModelProxy::AILanguageModelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AILanguageModelProxy::Prompt(
    ::blink::Vector<AILanguageModelPromptPtr> in_prompts, ::on_device_model::mojom::blink::ResponseConstraintPtr in_constraint, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> in_pending_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AILanguageModel::Prompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompts"), in_prompts,
                        "<value of type ::blink::Vector<AILanguageModelPromptPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraint"), in_constraint,
                        "<value of type ::on_device_model::mojom::blink::ResponseConstraintPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_responder"), in_pending_responder,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kPrompt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_Prompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prompts)::BaseType>
      prompts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptDataView>>(
    in_prompts,
    prompts_fragment,
    &prompts_validate_params);

  params->prompts.Set(
      prompts_fragment.is_null() ? nullptr : prompts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prompts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prompts in AILanguageModel.Prompt request");
  mojo::internal::MessageFragment<decltype(params->constraint)>
      constraint_fragment(params.message());
  constraint_fragment.Claim(&params->constraint);
  
  mojo::internal::Serialize<::on_device_model::mojom::ResponseConstraintDataView>(
    in_constraint,
    constraint_fragment,
    true);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_pending_responder,
    &params->pending_responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pending_responder in AILanguageModel.Prompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("Prompt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AILanguageModelProxy::Append(
    ::blink::Vector<AILanguageModelPromptPtr> in_prompts, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AILanguageModel::Append", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompts"), in_prompts,
                        "<value of type ::blink::Vector<AILanguageModelPromptPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kAppend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_Append_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prompts)::BaseType>
      prompts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& prompts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptDataView>>(
    in_prompts,
    prompts_fragment,
    &prompts_validate_params);

  params->prompts.Set(
      prompts_fragment.is_null() ? nullptr : prompts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prompts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prompts in AILanguageModel.Append request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelStreamingResponderInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AILanguageModel.Append request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("Append");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AILanguageModelProxy::Fork(
    ::mojo::PendingRemote<AIManagerCreateLanguageModelClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AILanguageModel::Fork", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<AIManagerCreateLanguageModelClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kFork), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_Fork_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AIManagerCreateLanguageModelClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AILanguageModel.Fork request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("Fork");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AILanguageModelProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AILanguageModel::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AILanguageModelProxy::MeasureInputUsage(
    ::blink::Vector<AILanguageModelPromptPtr> in_input, MeasureInputUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AILanguageModel::MeasureInputUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type ::blink::Vector<AILanguageModelPromptPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kMeasureInputUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_MeasureInputUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType>
      input_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptDataView>>(
    in_input,
    input_fragment,
    &input_validate_params);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AILanguageModel.MeasureInputUsage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("MeasureInputUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AILanguageModel_MeasureInputUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AILanguageModel_MeasureInputUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AILanguageModel::MeasureInputUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AILanguageModel_MeasureInputUsage_ProxyToResponder> proxy(
        new AILanguageModel_MeasureInputUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AILanguageModel_MeasureInputUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AILanguageModel_MeasureInputUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AILanguageModel_MeasureInputUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AILanguageModel::MeasureInputUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_number_of_tokens);
};

bool AILanguageModel_MeasureInputUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AILanguageModel_MeasureInputUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AILanguageModel_MeasureInputUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AILanguageModel.4
  bool success = true;
  std::optional<uint32_t> p_number_of_tokens{};
  AILanguageModel_MeasureInputUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_number_of_tokens = input_data_view.number_of_tokens();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AILanguageModel::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_number_of_tokens));
  }
  return true;
}

void AILanguageModel_MeasureInputUsage_ProxyToResponder::Run(
    std::optional<uint32_t> in_number_of_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AILanguageModel::MeasureInputUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_of_tokens"), in_number_of_tokens,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AILanguageModel::kMeasureInputUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AILanguageModel_MeasureInputUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->number_of_tokens_$flag = in_number_of_tokens.has_value();
  if (in_number_of_tokens.has_value()) {
    params->number_of_tokens_$value = in_number_of_tokens.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AILanguageModel::Name_);
  message.set_method_name("MeasureInputUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AILanguageModelStubDispatch::Accept(
    AILanguageModel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AILanguageModel>(message->header()->name)) {
    case messages::AILanguageModel::kPrompt: {
      DCHECK(message->is_serialized());
      internal::AILanguageModel_Prompt_Params_Data* params =
          reinterpret_cast<internal::AILanguageModel_Prompt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AILanguageModel.0
      bool success = true;
      ::blink::Vector<AILanguageModelPromptPtr> p_prompts{};
      ::on_device_model::mojom::blink::ResponseConstraintPtr p_constraint{};
      ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> p_pending_responder{};
      AILanguageModel_Prompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrompts(&p_prompts))
        success = false;
      if (success && !input_data_view.ReadConstraint(&p_constraint))
        success = false;
      if (success) {
        p_pending_responder =
            input_data_view.TakePendingResponder<decltype(p_pending_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AILanguageModel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Prompt(        
        std::move(p_prompts), 
        std::move(p_constraint), 
        std::move(p_pending_responder));
      return true;
    }
    case messages::AILanguageModel::kAppend: {
      DCHECK(message->is_serialized());
      internal::AILanguageModel_Append_Params_Data* params =
          reinterpret_cast<internal::AILanguageModel_Append_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AILanguageModel.1
      bool success = true;
      ::blink::Vector<AILanguageModelPromptPtr> p_prompts{};
      ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> p_client{};
      AILanguageModel_Append_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrompts(&p_prompts))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AILanguageModel::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Append(        
        std::move(p_prompts), 
        std::move(p_client));
      return true;
    }
    case messages::AILanguageModel::kFork: {
      DCHECK(message->is_serialized());
      internal::AILanguageModel_Fork_Params_Data* params =
          reinterpret_cast<internal::AILanguageModel_Fork_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AILanguageModel.2
      bool success = true;
      ::mojo::PendingRemote<AIManagerCreateLanguageModelClient> p_client{};
      AILanguageModel_Fork_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AILanguageModel::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Fork(        
        std::move(p_client));
      return true;
    }
    case messages::AILanguageModel::kDestroy: {
      DCHECK(message->is_serialized());
      internal::AILanguageModel_Destroy_Params_Data* params =
          reinterpret_cast<internal::AILanguageModel_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AILanguageModel.3
      bool success = true;
      AILanguageModel_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AILanguageModel::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
    case messages::AILanguageModel::kMeasureInputUsage: {
      break;
    }
  }
  return false;
}

// static
bool AILanguageModelStubDispatch::AcceptWithResponder(
    AILanguageModel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AILanguageModel>(message->header()->name)) {
    case messages::AILanguageModel::kPrompt: {
      break;
    }
    case messages::AILanguageModel::kAppend: {
      break;
    }
    case messages::AILanguageModel::kFork: {
      break;
    }
    case messages::AILanguageModel::kDestroy: {
      break;
    }
    case messages::AILanguageModel::kMeasureInputUsage: {
      internal::AILanguageModel_MeasureInputUsage_Params_Data* params =
          reinterpret_cast<
              internal::AILanguageModel_MeasureInputUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AILanguageModel.4
      bool success = true;
      ::blink::Vector<AILanguageModelPromptPtr> p_input{};
      AILanguageModel_MeasureInputUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AILanguageModel::Name_, 4, false);
        return false;
      }
      auto callback =
          AILanguageModel_MeasureInputUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MeasureInputUsage(        
        std::move(p_input), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAILanguageModelValidationInfo[] = {
    { &internal::AILanguageModel_Prompt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AILanguageModel_Append_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AILanguageModel_Fork_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AILanguageModel_Destroy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AILanguageModel_MeasureInputUsage_Params_Data::Validate,
     &internal::AILanguageModel_MeasureInputUsage_ResponseParams_Data::Validate},
};

bool AILanguageModelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AILanguageModel::Name_,
    kAILanguageModelValidationInfo);
}

bool AILanguageModelResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::AILanguageModel::Name_,
    kAILanguageModelValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelSamplingParams::DataView, ::blink::mojom::blink::AILanguageModelSamplingParamsPtr>::Read(
    ::blink::mojom::blink::AILanguageModelSamplingParams::DataView input,
    ::blink::mojom::blink::AILanguageModelSamplingParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelSamplingParamsPtr result(::blink::mojom::blink::AILanguageModelSamplingParams::New());
  
      if (success)
        result->top_k = input.top_k();
      if (success)
        result->temperature = input.temperature();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelParams::DataView, ::blink::mojom::blink::AILanguageModelParamsPtr>::Read(
    ::blink::mojom::blink::AILanguageModelParams::DataView input,
    ::blink::mojom::blink::AILanguageModelParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelParamsPtr result(::blink::mojom::blink::AILanguageModelParams::New());
  
      if (success && !input.ReadDefaultSamplingParams(&result->default_sampling_params))
        success = false;
      if (success && !input.ReadMaxSamplingParams(&result->max_sampling_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelInstanceInfo::DataView, ::blink::mojom::blink::AILanguageModelInstanceInfoPtr>::Read(
    ::blink::mojom::blink::AILanguageModelInstanceInfo::DataView input,
    ::blink::mojom::blink::AILanguageModelInstanceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelInstanceInfoPtr result(::blink::mojom::blink::AILanguageModelInstanceInfo::New());
  
      if (success)
        result->input_quota = input.input_quota();
      if (success)
        result->input_usage = input.input_usage();
      if (success && !input.ReadSamplingParams(&result->sampling_params))
        success = false;
      if (success && !input.ReadInputTypes(&result->input_types))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelExpected::DataView, ::blink::mojom::blink::AILanguageModelExpectedPtr>::Read(
    ::blink::mojom::blink::AILanguageModelExpected::DataView input,
    ::blink::mojom::blink::AILanguageModelExpectedPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelExpectedPtr result(::blink::mojom::blink::AILanguageModelExpected::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadLanguages(&result->languages))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelPrompt::DataView, ::blink::mojom::blink::AILanguageModelPromptPtr>::Read(
    ::blink::mojom::blink::AILanguageModelPrompt::DataView input,
    ::blink::mojom::blink::AILanguageModelPromptPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelPromptPtr result(::blink::mojom::blink::AILanguageModelPrompt::New());
  
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->is_prefix = input.is_prefix();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AILanguageModelCreateOptions::DataView, ::blink::mojom::blink::AILanguageModelCreateOptionsPtr>::Read(
    ::blink::mojom::blink::AILanguageModelCreateOptions::DataView input,
    ::blink::mojom::blink::AILanguageModelCreateOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AILanguageModelCreateOptionsPtr result(::blink::mojom::blink::AILanguageModelCreateOptions::New());
  
      if (success && !input.ReadSamplingParams(&result->sampling_params))
        success = false;
      if (success && !input.ReadInitialPrompts(&result->initial_prompts))
        success = false;
      if (success && !input.ReadExpectedInputs(&result->expected_inputs))
        success = false;
      if (success && !input.ReadExpectedOutputs(&result->expected_outputs))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::AILanguageModelPromptContent::DataView, ::blink::mojom::blink::AILanguageModelPromptContentPtr>::Read(
    ::blink::mojom::blink::AILanguageModelPromptContent::DataView input,
    ::blink::mojom::blink::AILanguageModelPromptContentPtr* output) {
  using UnionType = ::blink::mojom::blink::AILanguageModelPromptContent;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kText: {
      ::blink::String result_text{};
      if (!input.ReadText(&result_text))
        return false;

      *output = UnionType::NewText(
          std::move(result_text));
      break;
    }
    case Tag::kBitmap: {
      ::SkBitmap result_bitmap{};
      if (!input.ReadBitmap(&result_bitmap))
        return false;

      *output = UnionType::NewBitmap(
          std::move(result_bitmap));
      break;
    }
    case Tag::kAudio: {
      ::on_device_model::mojom::blink::AudioDataPtr result_audio{};
      if (!input.ReadAudio(&result_audio))
        return false;

      *output = UnionType::NewAudio(
          std::move(result_audio));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AIManagerCreateLanguageModelClientInterceptorForTesting::OnResult(::mojo::PendingRemote<AILanguageModel> language_model_remote, AILanguageModelInstanceInfoPtr info) {
  GetForwardingInterface()->OnResult(
    std::move(language_model_remote)
    , 
    std::move(info)
    );
}
void AIManagerCreateLanguageModelClientInterceptorForTesting::OnError(::blink::mojom::blink::AIManagerCreateClientError error, ::blink::mojom::blink::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(quota_error_info)
    );
}
AIManagerCreateLanguageModelClientAsyncWaiter::AIManagerCreateLanguageModelClientAsyncWaiter(
    AIManagerCreateLanguageModelClient* proxy) : proxy_(proxy) {}

AIManagerCreateLanguageModelClientAsyncWaiter::~AIManagerCreateLanguageModelClientAsyncWaiter() = default;





void AILanguageModelInterceptorForTesting::Prompt(::blink::Vector<AILanguageModelPromptPtr> prompts, ::on_device_model::mojom::blink::ResponseConstraintPtr constraint, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> pending_responder) {
  GetForwardingInterface()->Prompt(
    std::move(prompts)
    , 
    std::move(constraint)
    , 
    std::move(pending_responder)
    );
}
void AILanguageModelInterceptorForTesting::Append(::blink::Vector<AILanguageModelPromptPtr> prompts, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> client) {
  GetForwardingInterface()->Append(
    std::move(prompts)
    , 
    std::move(client)
    );
}
void AILanguageModelInterceptorForTesting::Fork(::mojo::PendingRemote<AIManagerCreateLanguageModelClient> client) {
  GetForwardingInterface()->Fork(
    std::move(client)
    );
}
void AILanguageModelInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
void AILanguageModelInterceptorForTesting::MeasureInputUsage(::blink::Vector<AILanguageModelPromptPtr> input, MeasureInputUsageCallback callback) {
  GetForwardingInterface()->MeasureInputUsage(
    std::move(input)
    , std::move(callback));
}
AILanguageModelAsyncWaiter::AILanguageModelAsyncWaiter(
    AILanguageModel* proxy) : proxy_(proxy) {}

AILanguageModelAsyncWaiter::~AILanguageModelAsyncWaiter() = default;


void AILanguageModelAsyncWaiter::MeasureInputUsage(
    ::blink::Vector<AILanguageModelPromptPtr> input, std::optional<uint32_t>* out_number_of_tokens) {
  base::RunLoop loop;
  proxy_->MeasureInputUsage(
      std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_number_of_tokens
,
             std::optional<uint32_t> number_of_tokens) {*out_number_of_tokens = std::move(number_of_tokens);
            loop->Quit();
          },
          &loop,
          out_number_of_tokens));
  loop.Run();
}

std::optional<uint32_t> AILanguageModelAsyncWaiter::MeasureInputUsage(
    ::blink::Vector<AILanguageModelPromptPtr> input) {
  std::optional<uint32_t> async_wait_result;
  MeasureInputUsage(std::move(input),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif