// third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AD_TAGGING_AD_EVIDENCE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AD_TAGGING_AD_EVIDENCE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/frame/frame_ad_evidence_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT FrameAdEvidence {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameAdEvidence, T>::value>;
  using DataView = FrameAdEvidenceDataView;
  using Data_ = internal::FrameAdEvidence_Data;

  template <typename... Args>
  static FrameAdEvidencePtr New(Args&&... args) {
    return FrameAdEvidencePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameAdEvidencePtr From(const U& u) {
    return mojo::TypeConverter<FrameAdEvidencePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameAdEvidence>::Convert(*this);
  }


  FrameAdEvidence();

  FrameAdEvidence(
      bool is_complete,
      bool parent_is_ad,
      FilterListResult latest_filter_list_result,
      FilterListResult most_restrictive_filter_list_result,
      FrameCreationStackEvidence created_by_ad_script);


  ~FrameAdEvidence();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameAdEvidencePtr>
  FrameAdEvidencePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameAdEvidence::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameAdEvidence::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameAdEvidence::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameAdEvidence_UnserializedMessageContext<
            UserType, FrameAdEvidence::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameAdEvidence::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameAdEvidence::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameAdEvidence_UnserializedMessageContext<
            UserType, FrameAdEvidence::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameAdEvidence::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_complete;
  
  bool parent_is_ad;
  
  FilterListResult latest_filter_list_result;
  
  FilterListResult most_restrictive_filter_list_result;
  
  FrameCreationStackEvidence created_by_ad_script;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameAdEvidence::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameAdEvidencePtr FrameAdEvidence::Clone() const {
  return New(
      mojo::Clone(is_complete),
      mojo::Clone(parent_is_ad),
      mojo::Clone(latest_filter_list_result),
      mojo::Clone(most_restrictive_filter_list_result),
      mojo::Clone(created_by_ad_script)
  );
}

template <typename T, FrameAdEvidence::EnableIfSame<T>*>
bool FrameAdEvidence::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_complete, other_struct.is_complete))
    return false;
  if (!mojo::Equals(this->parent_is_ad, other_struct.parent_is_ad))
    return false;
  if (!mojo::Equals(this->latest_filter_list_result, other_struct.latest_filter_list_result))
    return false;
  if (!mojo::Equals(this->most_restrictive_filter_list_result, other_struct.most_restrictive_filter_list_result))
    return false;
  if (!mojo::Equals(this->created_by_ad_script, other_struct.created_by_ad_script))
    return false;
  return true;
}

template <typename T, FrameAdEvidence::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_complete < rhs.is_complete)
    return true;
  if (rhs.is_complete < lhs.is_complete)
    return false;
  if (lhs.parent_is_ad < rhs.parent_is_ad)
    return true;
  if (rhs.parent_is_ad < lhs.parent_is_ad)
    return false;
  if (lhs.latest_filter_list_result < rhs.latest_filter_list_result)
    return true;
  if (rhs.latest_filter_list_result < lhs.latest_filter_list_result)
    return false;
  if (lhs.most_restrictive_filter_list_result < rhs.most_restrictive_filter_list_result)
    return true;
  if (rhs.most_restrictive_filter_list_result < lhs.most_restrictive_filter_list_result)
    return false;
  if (lhs.created_by_ad_script < rhs.created_by_ad_script)
    return true;
  if (rhs.created_by_ad_script < lhs.created_by_ad_script)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FrameAdEvidence::DataView,
                                         ::blink::mojom::blink::FrameAdEvidencePtr> {
  static bool IsNull(const ::blink::mojom::blink::FrameAdEvidencePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FrameAdEvidencePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FrameAdEvidence::is_complete) is_complete(
      const ::blink::mojom::blink::FrameAdEvidencePtr& input) {
    return input->is_complete;
  }

  static decltype(::blink::mojom::blink::FrameAdEvidence::parent_is_ad) parent_is_ad(
      const ::blink::mojom::blink::FrameAdEvidencePtr& input) {
    return input->parent_is_ad;
  }

  static decltype(::blink::mojom::blink::FrameAdEvidence::latest_filter_list_result) latest_filter_list_result(
      const ::blink::mojom::blink::FrameAdEvidencePtr& input) {
    return input->latest_filter_list_result;
  }

  static decltype(::blink::mojom::blink::FrameAdEvidence::most_restrictive_filter_list_result) most_restrictive_filter_list_result(
      const ::blink::mojom::blink::FrameAdEvidencePtr& input) {
    return input->most_restrictive_filter_list_result;
  }

  static decltype(::blink::mojom::blink::FrameAdEvidence::created_by_ad_script) created_by_ad_script(
      const ::blink::mojom::blink::FrameAdEvidencePtr& input) {
    return input->created_by_ad_script;
  }

  static bool Read(::blink::mojom::blink::FrameAdEvidence::DataView input, ::blink::mojom::blink::FrameAdEvidencePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AD_TAGGING_AD_EVIDENCE_MOJOM_BLINK_H_