// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/policy_helper_public.cc.tmpl
// and input files:
//   ../../services/network/public/cpp/permissions_policy/permissions_policy_features.json5


#include "third_party/blink/public/common/permissions_policy/policy_helper_public.h"

#include "base/no_destructor.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom.h"

namespace blink {

// Unlike the private version (which lives in
// blink/renderer/core/permissions_policy/), these maps will include all
// features, regardless of whether or not they depend on a blink runtime enabled
// feature that is enabled/disabled. Features which are shipping as part of an
// origin trial add their feature names to this map unconditionally, as the
// trial token could be added after the HTTP header needs to be parsed. This
// also means that top-level documents which simply want to embed another page
// which uses an origin trial feature, without using the feature themselves, can
// use permissions policy to allow use of the feature in subframes (The framed
// document will still require a valid origin trial token to use the feature in
// this scenario).

const PermissionsPolicyNameToFeatureMap&
GetPermissionsPolicyNameToFeatureMap() {
  static const PermissionsPolicyNameToFeatureMap default_feature_name_map = {
    {"accelerometer",
        network::mojom::PermissionsPolicyFeature::kAccelerometer},
    {"all-screens-capture",
        network::mojom::PermissionsPolicyFeature::kAllScreensCapture},
    {"ambient-light-sensor",
        network::mojom::PermissionsPolicyFeature::kAmbientLightSensor},
    {"aria-notify",
        network::mojom::PermissionsPolicyFeature::kAriaNotify},
    {"attribution-reporting",
        network::mojom::PermissionsPolicyFeature::kAttributionReporting},
    {"autoplay",
        network::mojom::PermissionsPolicyFeature::kAutoplay},
    {"bluetooth",
        network::mojom::PermissionsPolicyFeature::kBluetooth},
    {"browsing-topics",
        network::mojom::PermissionsPolicyFeature::kBrowsingTopics},
    {"interest-cohort",
        network::mojom::PermissionsPolicyFeature::kBrowsingTopicsBackwardCompatible},
    {"camera",
        network::mojom::PermissionsPolicyFeature::kCamera},
    {"captured-surface-control",
        network::mojom::PermissionsPolicyFeature::kCapturedSurfaceControl},
    {"ch-dpr",
        network::mojom::PermissionsPolicyFeature::kClientHintDPR},
    {"ch-device-memory",
        network::mojom::PermissionsPolicyFeature::kClientHintDeviceMemory},
    {"ch-downlink",
        network::mojom::PermissionsPolicyFeature::kClientHintDownlink},
    {"ch-ect",
        network::mojom::PermissionsPolicyFeature::kClientHintECT},
    {"ch-prefers-color-scheme",
        network::mojom::PermissionsPolicyFeature::kClientHintPrefersColorScheme},
    {"ch-prefers-reduced-motion",
        network::mojom::PermissionsPolicyFeature::kClientHintPrefersReducedMotion},
    {"ch-prefers-reduced-transparency",
        network::mojom::PermissionsPolicyFeature::kClientHintPrefersReducedTransparency},
    {"ch-rtt",
        network::mojom::PermissionsPolicyFeature::kClientHintRTT},
    {"ch-save-data",
        network::mojom::PermissionsPolicyFeature::kClientHintSaveData},
    {"ch-ua",
        network::mojom::PermissionsPolicyFeature::kClientHintUA},
    {"ch-ua-arch",
        network::mojom::PermissionsPolicyFeature::kClientHintUAArch},
    {"ch-ua-bitness",
        network::mojom::PermissionsPolicyFeature::kClientHintUABitness},
    {"ch-ua-form-factors",
        network::mojom::PermissionsPolicyFeature::kClientHintUAFormFactors},
    {"ch-ua-high-entropy-values",
        network::mojom::PermissionsPolicyFeature::kClientHintUAHighEntropyValues},
    {"ch-ua-platform",
        network::mojom::PermissionsPolicyFeature::kClientHintUAPlatform},
    {"ch-ua-model",
        network::mojom::PermissionsPolicyFeature::kClientHintUAModel},
    {"ch-ua-mobile",
        network::mojom::PermissionsPolicyFeature::kClientHintUAMobile},
    {"ch-ua-full-version",
        network::mojom::PermissionsPolicyFeature::kClientHintUAFullVersion},
    {"ch-ua-full-version-list",
        network::mojom::PermissionsPolicyFeature::kClientHintUAFullVersionList},
    {"ch-ua-platform-version",
        network::mojom::PermissionsPolicyFeature::kClientHintUAPlatformVersion},
    {"ch-ua-wow64",
        network::mojom::PermissionsPolicyFeature::kClientHintUAWoW64},
    {"ch-viewport-height",
        network::mojom::PermissionsPolicyFeature::kClientHintViewportHeight},
    {"ch-viewport-width",
        network::mojom::PermissionsPolicyFeature::kClientHintViewportWidth},
    {"ch-width",
        network::mojom::PermissionsPolicyFeature::kClientHintWidth},
    {"clipboard-read",
        network::mojom::PermissionsPolicyFeature::kClipboardRead},
    {"clipboard-write",
        network::mojom::PermissionsPolicyFeature::kClipboardWrite},
    {"compute-pressure",
        network::mojom::PermissionsPolicyFeature::kComputePressure},
    {"controlled-frame",
        network::mojom::PermissionsPolicyFeature::kControlledFrame},
    {"cross-origin-isolated",
        network::mojom::PermissionsPolicyFeature::kCrossOriginIsolated},
    {"deferred-fetch",
        network::mojom::PermissionsPolicyFeature::kDeferredFetch},
    {"deferred-fetch-minimal",
        network::mojom::PermissionsPolicyFeature::kDeferredFetchMinimal},
    {"device-attributes",
        network::mojom::PermissionsPolicyFeature::kDeviceAttributes},
    {"digital-credentials-create",
        network::mojom::PermissionsPolicyFeature::kDigitalCredentialsCreate},
    {"digital-credentials-get",
        network::mojom::PermissionsPolicyFeature::kDigitalCredentialsGet},
    {"direct-sockets",
        network::mojom::PermissionsPolicyFeature::kDirectSockets},
    {"direct-sockets-private",
        network::mojom::PermissionsPolicyFeature::kDirectSocketsPrivate},
    {"display-capture",
        network::mojom::PermissionsPolicyFeature::kDisplayCapture},
    {"encrypted-media",
        network::mojom::PermissionsPolicyFeature::kEncryptedMedia},
    {"execution-while-out-of-viewport",
        network::mojom::PermissionsPolicyFeature::kExecutionWhileOutOfViewport},
    {"execution-while-not-rendered",
        network::mojom::PermissionsPolicyFeature::kExecutionWhileNotRendered},
    {"fenced-unpartitioned-storage-read",
        network::mojom::PermissionsPolicyFeature::kFencedUnpartitionedStorageRead},
    {"focus-without-user-activation",
        network::mojom::PermissionsPolicyFeature::kFocusWithoutUserActivation},
    {"fullscreen",
        network::mojom::PermissionsPolicyFeature::kFullscreen},
    {"frobulate",
        network::mojom::PermissionsPolicyFeature::kFrobulate},
    {"gamepad",
        network::mojom::PermissionsPolicyFeature::kGamepad},
    {"geolocation",
        network::mojom::PermissionsPolicyFeature::kGeolocation},
    {"gyroscope",
        network::mojom::PermissionsPolicyFeature::kGyroscope},
    {"hid",
        network::mojom::PermissionsPolicyFeature::kHid},
    {"identity-credentials-get",
        network::mojom::PermissionsPolicyFeature::kIdentityCredentialsGet},
    {"idle-detection",
        network::mojom::PermissionsPolicyFeature::kIdleDetection},
    {"join-ad-interest-group",
        network::mojom::PermissionsPolicyFeature::kJoinAdInterestGroup},
    {"keyboard-map",
        network::mojom::PermissionsPolicyFeature::kKeyboardMap},
    {"language-detector",
        network::mojom::PermissionsPolicyFeature::kLanguageDetector},
    {"language-model",
        network::mojom::PermissionsPolicyFeature::kLanguageModel},
    {"local-fonts",
        network::mojom::PermissionsPolicyFeature::kLocalFonts},
    {"local-network-access",
        network::mojom::PermissionsPolicyFeature::kLocalNetworkAccess},
    {"magnetometer",
        network::mojom::PermissionsPolicyFeature::kMagnetometer},
    {"media-playback-while-not-visible",
        network::mojom::PermissionsPolicyFeature::kMediaPlaybackWhileNotVisible},
    {"microphone",
        network::mojom::PermissionsPolicyFeature::kMicrophone},
    {"midi",
        network::mojom::PermissionsPolicyFeature::kMidiFeature},
    {"direct-sockets-multicast",
        network::mojom::PermissionsPolicyFeature::kMulticastInDirectSockets},
    {"on-device-speech-recognition",
        network::mojom::PermissionsPolicyFeature::kOnDeviceSpeechRecognition},
    {"otp-credentials",
        network::mojom::PermissionsPolicyFeature::kOTPCredentials},
    {"popins",
        network::mojom::PermissionsPolicyFeature::kPartitionedPopins},
    {"payment",
        network::mojom::PermissionsPolicyFeature::kPayment},
    {"picture-in-picture",
        network::mojom::PermissionsPolicyFeature::kPictureInPicture},
    {"private-aggregation",
        network::mojom::PermissionsPolicyFeature::kPrivateAggregation},
    {"private-state-token-issuance",
        network::mojom::PermissionsPolicyFeature::kPrivateStateTokenIssuance},
    {"publickey-credentials-create",
        network::mojom::PermissionsPolicyFeature::kPublicKeyCredentialsCreate},
    {"publickey-credentials-get",
        network::mojom::PermissionsPolicyFeature::kPublicKeyCredentialsGet},
    {"record-ad-auction-events",
        network::mojom::PermissionsPolicyFeature::kRecordAdAuctionEvents},
    {"rewriter",
        network::mojom::PermissionsPolicyFeature::kRewriter},
    {"run-ad-auction",
        network::mojom::PermissionsPolicyFeature::kRunAdAuction},
    {"screen-wake-lock",
        network::mojom::PermissionsPolicyFeature::kScreenWakeLock},
    {"serial",
        network::mojom::PermissionsPolicyFeature::kSerial},
    {"shared-autofill",
        network::mojom::PermissionsPolicyFeature::kSharedAutofill},
    {"shared-storage",
        network::mojom::PermissionsPolicyFeature::kSharedStorage},
    {"shared-storage-select-url",
        network::mojom::PermissionsPolicyFeature::kSharedStorageSelectUrl},
    {"smart-card",
        network::mojom::PermissionsPolicyFeature::kSmartCard},
    {"speaker-selection",
        network::mojom::PermissionsPolicyFeature::kSpeakerSelection},
    {"storage-access",
        network::mojom::PermissionsPolicyFeature::kStorageAccessAPI},
    {"sub-apps",
        network::mojom::PermissionsPolicyFeature::kSubApps},
    {"summarizer",
        network::mojom::PermissionsPolicyFeature::kSummarizer},
    {"sync-xhr",
        network::mojom::PermissionsPolicyFeature::kSyncXHR},
    {"translator",
        network::mojom::PermissionsPolicyFeature::kTranslator},
    {"private-state-token-redemption",
        network::mojom::PermissionsPolicyFeature::kTrustTokenRedemption},
    {"usb",
        network::mojom::PermissionsPolicyFeature::kUsb},
    {"usb-unrestricted",
        network::mojom::PermissionsPolicyFeature::kUsbUnrestricted},
    {"unload",
        network::mojom::PermissionsPolicyFeature::kUnload},
    {"vertical-scroll",
        network::mojom::PermissionsPolicyFeature::kVerticalScroll},
    {"web-app-installation",
        network::mojom::PermissionsPolicyFeature::kWebAppInstallation},
    {"web-printing",
        network::mojom::PermissionsPolicyFeature::kWebPrinting},
    {"web-share",
        network::mojom::PermissionsPolicyFeature::kWebShare},
    {"xr-spatial-tracking",
        network::mojom::PermissionsPolicyFeature::kWebXr},
    {"window-management",
        network::mojom::PermissionsPolicyFeature::kWindowManagement},
    {"writer",
        network::mojom::PermissionsPolicyFeature::kWriter},
  };

  return default_feature_name_map;
}

const PermissionsPolicyFeatureToNameMap&
GetPermissionsPolicyFeatureToNameMap() {
  static const PermissionsPolicyFeatureToNameMap default_feature_to_name_map = {
    {network::mojom::PermissionsPolicyFeature::kAccelerometer,
        "accelerometer"},
    {network::mojom::PermissionsPolicyFeature::kAllScreensCapture,
        "all-screens-capture"},
    {network::mojom::PermissionsPolicyFeature::kAmbientLightSensor,
        "ambient-light-sensor"},
    {network::mojom::PermissionsPolicyFeature::kAriaNotify,
        "aria-notify"},
    {network::mojom::PermissionsPolicyFeature::kAttributionReporting,
        "attribution-reporting"},
    {network::mojom::PermissionsPolicyFeature::kAutoplay,
        "autoplay"},
    {network::mojom::PermissionsPolicyFeature::kBluetooth,
        "bluetooth"},
    {network::mojom::PermissionsPolicyFeature::kBrowsingTopics,
        "browsing-topics"},
    {network::mojom::PermissionsPolicyFeature::kBrowsingTopicsBackwardCompatible,
        "interest-cohort"},
    {network::mojom::PermissionsPolicyFeature::kCamera,
        "camera"},
    {network::mojom::PermissionsPolicyFeature::kCapturedSurfaceControl,
        "captured-surface-control"},
    {network::mojom::PermissionsPolicyFeature::kClientHintDPR,
        "ch-dpr"},
    {network::mojom::PermissionsPolicyFeature::kClientHintDeviceMemory,
        "ch-device-memory"},
    {network::mojom::PermissionsPolicyFeature::kClientHintDownlink,
        "ch-downlink"},
    {network::mojom::PermissionsPolicyFeature::kClientHintECT,
        "ch-ect"},
    {network::mojom::PermissionsPolicyFeature::kClientHintPrefersColorScheme,
        "ch-prefers-color-scheme"},
    {network::mojom::PermissionsPolicyFeature::kClientHintPrefersReducedMotion,
        "ch-prefers-reduced-motion"},
    {network::mojom::PermissionsPolicyFeature::kClientHintPrefersReducedTransparency,
        "ch-prefers-reduced-transparency"},
    {network::mojom::PermissionsPolicyFeature::kClientHintRTT,
        "ch-rtt"},
    {network::mojom::PermissionsPolicyFeature::kClientHintSaveData,
        "ch-save-data"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUA,
        "ch-ua"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAArch,
        "ch-ua-arch"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUABitness,
        "ch-ua-bitness"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAFormFactors,
        "ch-ua-form-factors"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAHighEntropyValues,
        "ch-ua-high-entropy-values"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAPlatform,
        "ch-ua-platform"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAModel,
        "ch-ua-model"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAMobile,
        "ch-ua-mobile"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAFullVersion,
        "ch-ua-full-version"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAFullVersionList,
        "ch-ua-full-version-list"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAPlatformVersion,
        "ch-ua-platform-version"},
    {network::mojom::PermissionsPolicyFeature::kClientHintUAWoW64,
        "ch-ua-wow64"},
    {network::mojom::PermissionsPolicyFeature::kClientHintViewportHeight,
        "ch-viewport-height"},
    {network::mojom::PermissionsPolicyFeature::kClientHintViewportWidth,
        "ch-viewport-width"},
    {network::mojom::PermissionsPolicyFeature::kClientHintWidth,
        "ch-width"},
    {network::mojom::PermissionsPolicyFeature::kClipboardRead,
        "clipboard-read"},
    {network::mojom::PermissionsPolicyFeature::kClipboardWrite,
        "clipboard-write"},
    {network::mojom::PermissionsPolicyFeature::kComputePressure,
        "compute-pressure"},
    {network::mojom::PermissionsPolicyFeature::kControlledFrame,
        "controlled-frame"},
    {network::mojom::PermissionsPolicyFeature::kCrossOriginIsolated,
        "cross-origin-isolated"},
    {network::mojom::PermissionsPolicyFeature::kDeferredFetch,
        "deferred-fetch"},
    {network::mojom::PermissionsPolicyFeature::kDeferredFetchMinimal,
        "deferred-fetch-minimal"},
    {network::mojom::PermissionsPolicyFeature::kDeviceAttributes,
        "device-attributes"},
    {network::mojom::PermissionsPolicyFeature::kDigitalCredentialsCreate,
        "digital-credentials-create"},
    {network::mojom::PermissionsPolicyFeature::kDigitalCredentialsGet,
        "digital-credentials-get"},
    {network::mojom::PermissionsPolicyFeature::kDirectSockets,
        "direct-sockets"},
    {network::mojom::PermissionsPolicyFeature::kDirectSocketsPrivate,
        "direct-sockets-private"},
    {network::mojom::PermissionsPolicyFeature::kDisplayCapture,
        "display-capture"},
    {network::mojom::PermissionsPolicyFeature::kEncryptedMedia,
        "encrypted-media"},
    {network::mojom::PermissionsPolicyFeature::kExecutionWhileOutOfViewport,
        "execution-while-out-of-viewport"},
    {network::mojom::PermissionsPolicyFeature::kExecutionWhileNotRendered,
        "execution-while-not-rendered"},
    {network::mojom::PermissionsPolicyFeature::kFencedUnpartitionedStorageRead,
        "fenced-unpartitioned-storage-read"},
    {network::mojom::PermissionsPolicyFeature::kFocusWithoutUserActivation,
        "focus-without-user-activation"},
    {network::mojom::PermissionsPolicyFeature::kFullscreen,
        "fullscreen"},
    {network::mojom::PermissionsPolicyFeature::kFrobulate,
        "frobulate"},
    {network::mojom::PermissionsPolicyFeature::kGamepad,
        "gamepad"},
    {network::mojom::PermissionsPolicyFeature::kGeolocation,
        "geolocation"},
    {network::mojom::PermissionsPolicyFeature::kGyroscope,
        "gyroscope"},
    {network::mojom::PermissionsPolicyFeature::kHid,
        "hid"},
    {network::mojom::PermissionsPolicyFeature::kIdentityCredentialsGet,
        "identity-credentials-get"},
    {network::mojom::PermissionsPolicyFeature::kIdleDetection,
        "idle-detection"},
    {network::mojom::PermissionsPolicyFeature::kJoinAdInterestGroup,
        "join-ad-interest-group"},
    {network::mojom::PermissionsPolicyFeature::kKeyboardMap,
        "keyboard-map"},
    {network::mojom::PermissionsPolicyFeature::kLanguageDetector,
        "language-detector"},
    {network::mojom::PermissionsPolicyFeature::kLanguageModel,
        "language-model"},
    {network::mojom::PermissionsPolicyFeature::kLocalFonts,
        "local-fonts"},
    {network::mojom::PermissionsPolicyFeature::kLocalNetworkAccess,
        "local-network-access"},
    {network::mojom::PermissionsPolicyFeature::kMagnetometer,
        "magnetometer"},
    {network::mojom::PermissionsPolicyFeature::kMediaPlaybackWhileNotVisible,
        "media-playback-while-not-visible"},
    {network::mojom::PermissionsPolicyFeature::kMicrophone,
        "microphone"},
    {network::mojom::PermissionsPolicyFeature::kMidiFeature,
        "midi"},
    {network::mojom::PermissionsPolicyFeature::kMulticastInDirectSockets,
        "direct-sockets-multicast"},
    {network::mojom::PermissionsPolicyFeature::kOnDeviceSpeechRecognition,
        "on-device-speech-recognition"},
    {network::mojom::PermissionsPolicyFeature::kOTPCredentials,
        "otp-credentials"},
    {network::mojom::PermissionsPolicyFeature::kPartitionedPopins,
        "popins"},
    {network::mojom::PermissionsPolicyFeature::kPayment,
        "payment"},
    {network::mojom::PermissionsPolicyFeature::kPictureInPicture,
        "picture-in-picture"},
    {network::mojom::PermissionsPolicyFeature::kPrivateAggregation,
        "private-aggregation"},
    {network::mojom::PermissionsPolicyFeature::kPrivateStateTokenIssuance,
        "private-state-token-issuance"},
    {network::mojom::PermissionsPolicyFeature::kPublicKeyCredentialsCreate,
        "publickey-credentials-create"},
    {network::mojom::PermissionsPolicyFeature::kPublicKeyCredentialsGet,
        "publickey-credentials-get"},
    {network::mojom::PermissionsPolicyFeature::kRecordAdAuctionEvents,
        "record-ad-auction-events"},
    {network::mojom::PermissionsPolicyFeature::kRewriter,
        "rewriter"},
    {network::mojom::PermissionsPolicyFeature::kRunAdAuction,
        "run-ad-auction"},
    {network::mojom::PermissionsPolicyFeature::kScreenWakeLock,
        "screen-wake-lock"},
    {network::mojom::PermissionsPolicyFeature::kSerial,
        "serial"},
    {network::mojom::PermissionsPolicyFeature::kSharedAutofill,
        "shared-autofill"},
    {network::mojom::PermissionsPolicyFeature::kSharedStorage,
        "shared-storage"},
    {network::mojom::PermissionsPolicyFeature::kSharedStorageSelectUrl,
        "shared-storage-select-url"},
    {network::mojom::PermissionsPolicyFeature::kSmartCard,
        "smart-card"},
    {network::mojom::PermissionsPolicyFeature::kSpeakerSelection,
        "speaker-selection"},
    {network::mojom::PermissionsPolicyFeature::kStorageAccessAPI,
        "storage-access"},
    {network::mojom::PermissionsPolicyFeature::kSubApps,
        "sub-apps"},
    {network::mojom::PermissionsPolicyFeature::kSummarizer,
        "summarizer"},
    {network::mojom::PermissionsPolicyFeature::kSyncXHR,
        "sync-xhr"},
    {network::mojom::PermissionsPolicyFeature::kTranslator,
        "translator"},
    {network::mojom::PermissionsPolicyFeature::kTrustTokenRedemption,
        "private-state-token-redemption"},
    {network::mojom::PermissionsPolicyFeature::kUsb,
        "usb"},
    {network::mojom::PermissionsPolicyFeature::kUsbUnrestricted,
        "usb-unrestricted"},
    {network::mojom::PermissionsPolicyFeature::kUnload,
        "unload"},
    {network::mojom::PermissionsPolicyFeature::kVerticalScroll,
        "vertical-scroll"},
    {network::mojom::PermissionsPolicyFeature::kWebAppInstallation,
        "web-app-installation"},
    {network::mojom::PermissionsPolicyFeature::kWebPrinting,
        "web-printing"},
    {network::mojom::PermissionsPolicyFeature::kWebShare,
        "web-share"},
    {network::mojom::PermissionsPolicyFeature::kWebXr,
        "xr-spatial-tracking"},
    {network::mojom::PermissionsPolicyFeature::kWindowManagement,
        "window-management"},
    {network::mojom::PermissionsPolicyFeature::kWriter,
        "writer"},
  };
  return default_feature_to_name_map;
}

}  // namespace blink
