// services/webnn/public/mojom/webnn_tensor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_tensor.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_tensor.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/sync_token.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "services/webnn/public/mojom/webnn_graph.mojom.h"
#include "services/webnn/public/mojom/webnn_error.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"
#include "services/webnn/public/mojom/context_properties_mojom_traits.h"
#include "services/webnn/public/mojom/data_type_limits_mojom_traits.h"
#include "services/webnn/public/mojom/number_mojom_traits.h"
#include "services/webnn/public/mojom/operand_descriptor_mojom_traits.h"
#include "services/webnn/public/mojom/operand_id_mojom_traits.h"
#include "services/webnn/public/mojom/range_traits.h"
#include "services/webnn/public/mojom/supported_data_types_mojom_traits.h"
#include "services/webnn/public/mojom/supported_tensors_mojom_traits.h"
#include "services/webnn/public/mojom/tensor_usage_mojom_traits.h"
#include "base/component_export.h"




namespace webnn::mojom {

class WebNNTensorProxy;

template <typename ImplRefTraits>
class WebNNTensorStub;

class WebNNTensorRequestValidator;
class WebNNTensorResponseValidator;


class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensor
    : public WebNNTensorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webnn.mojom.WebNNTensor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebNNTensorInterfaceBase;
  using Proxy_ = WebNNTensorProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebNNTensorStub<ImplRefTraits>;

  using RequestValidator_ = WebNNTensorRequestValidator;
  using ResponseValidator_ = WebNNTensorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadTensorMinVersion = 0,
    kWriteTensorMinVersion = 0,
    kExportTensorMinVersion = 0,
    kImportTensorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReadTensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteTensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExportTensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportTensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebNNTensor() = default;

  using ReadTensorCallback = base::OnceCallback<void(ReadTensorResultPtr)>;
  using ReadTensorMojoCallback = base::OnceCallback<void(ReadTensorResultPtr)>;

  virtual void ReadTensor(ReadTensorCallback callback) = 0;

  virtual void WriteTensor(::mojo_base::BigBuffer src_buffer) = 0;

  using ExportTensorCallback = base::OnceCallback<void(base::expected<
  ::gpu::SyncToken,
  ::webnn::mojom::ErrorPtr>)>;
  using ExportTensorResult = base::expected<
  ::gpu::SyncToken,
  ::webnn::mojom::ErrorPtr>;
  using ExportTensorMojoCallback = base::OnceCallback<void(WebNNTensor_ExportTensor_ResponseParam_ResultPtr)>;

  virtual void ExportTensor(ExportTensorCallback callback) = 0;

  virtual void ImportTensor(const ::gpu::SyncToken& fence) = 0;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensorProxy
    : public WebNNTensor {
 public:
  using InterfaceType = WebNNTensor;

  explicit WebNNTensorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadTensor(ReadTensorCallback callback) final;
  
  void WriteTensor(::mojo_base::BigBuffer src_buffer) final;
  
  void ExportTensor(ExportTensorCallback callback) final;
  
  void ImportTensor(const ::gpu::SyncToken& fence) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensorStubDispatch {
 public:
  static bool Accept(WebNNTensor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebNNTensor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebNNTensor>>
class WebNNTensorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebNNTensorStub() = default;
  ~WebNNTensorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNTensorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNTensorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(WEBNN_MOJOM) TensorUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TensorUsage, T>::value>;
  using DataView = TensorUsageDataView;
  using Data_ = internal::TensorUsage_Data;

  template <typename... Args>
  static TensorUsagePtr New(Args&&... args) {
    return TensorUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TensorUsagePtr From(const U& u) {
    return mojo::TypeConverter<TensorUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TensorUsage>::Convert(*this);
  }


  TensorUsage();

  TensorUsage(
      bool web_gpu_interop,
      bool read,
      bool write,
      bool graph_constant);


  ~TensorUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TensorUsagePtr>
  TensorUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TensorUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TensorUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TensorUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TensorUsage_UnserializedMessageContext<
            UserType, TensorUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TensorUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TensorUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TensorUsage_UnserializedMessageContext<
            UserType, TensorUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TensorUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool web_gpu_interop;
  
  bool read;
  
  bool write;
  
  bool graph_constant;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TensorUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM) ReadTensorResult {
 public:
  using DataView = ReadTensorResultDataView;
  using Data_ = internal::ReadTensorResult_Data;
  using Tag = Data_::ReadTensorResult_Tag;

  template <typename... Args>
  static ReadTensorResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |buffer|.
  static ReadTensorResultPtr NewBuffer(
      ::mojo_base::BigBuffer value);
  // Construct an instance holding |error|.
  static ReadTensorResultPtr NewError(
      ::webnn::mojom::ErrorPtr value);

  template <typename U>
  static ReadTensorResultPtr From(const U& u) {
    return mojo::TypeConverter<ReadTensorResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadTensorResult>::Convert(*this);
  }
  ~ReadTensorResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ReadTensorResult(const ReadTensorResult& other) = delete;
  ReadTensorResult& operator=(const ReadTensorResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ReadTensorResultPtr>
  ReadTensorResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ReadTensorResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ReadTensorResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_buffer() const { return tag_ == Tag::kBuffer; }
  const ::mojo_base::BigBuffer& get_buffer() const {
    CHECK(tag_ == Tag::kBuffer);
    return data_.buffer;
  }
  ::mojo_base::BigBuffer& get_buffer() {
    CHECK(tag_ == Tag::kBuffer);
    return data_.buffer;
  }
  void set_buffer(::mojo_base::BigBuffer buffer);

  bool is_error() const { return tag_ == Tag::kError; }
  const ::webnn::mojom::ErrorPtr& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  ::webnn::mojom::ErrorPtr& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(::webnn::mojom::ErrorPtr error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadTensorResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ReadTensorResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
        ::mojo_base::BigBuffer value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        ::webnn::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo_base::BigBuffer buffer;
    ::webnn::mojom::ErrorPtr error;
  };

  ReadTensorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
      ::mojo_base::BigBuffer value);
  ReadTensorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      ::webnn::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNTensor_ExportTensor_ResponseParam_Result {
 public:
  using DataView = WebNNTensor_ExportTensor_ResponseParam_ResultDataView;
  using Data_ = internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data;
  using Tag = Data_::WebNNTensor_ExportTensor_ResponseParam_Result_Tag;

  template <typename... Args>
  static WebNNTensor_ExportTensor_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static WebNNTensor_ExportTensor_ResponseParam_ResultPtr NewSuccess(
      const ::gpu::SyncToken& value);
  // Construct an instance holding |failure|.
  static WebNNTensor_ExportTensor_ResponseParam_ResultPtr NewFailure(
      ::webnn::mojom::ErrorPtr value);

  template <typename U>
  static WebNNTensor_ExportTensor_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<WebNNTensor_ExportTensor_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebNNTensor_ExportTensor_ResponseParam_Result>::Convert(*this);
  }
  ~WebNNTensor_ExportTensor_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebNNTensor_ExportTensor_ResponseParam_Result(const WebNNTensor_ExportTensor_ResponseParam_Result& other) = delete;
  WebNNTensor_ExportTensor_ResponseParam_Result& operator=(const WebNNTensor_ExportTensor_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebNNTensor_ExportTensor_ResponseParam_ResultPtr>
  WebNNTensor_ExportTensor_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebNNTensor_ExportTensor_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebNNTensor_ExportTensor_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::gpu::SyncToken& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::gpu::SyncToken& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::gpu::SyncToken& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::webnn::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::webnn::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::webnn::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebNNTensor_ExportTensor_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebNNTensor_ExportTensor_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::gpu::SyncToken& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::webnn::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::gpu::SyncToken success;
    ::webnn::mojom::ErrorPtr failure;
  };

  WebNNTensor_ExportTensor_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::gpu::SyncToken& value);
  WebNNTensor_ExportTensor_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::webnn::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class COMPONENT_EXPORT(WEBNN_MOJOM) TensorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TensorInfo, T>::value>;
  using DataView = TensorInfoDataView;
  using Data_ = internal::TensorInfo_Data;

  template <typename... Args>
  static TensorInfoPtr New(Args&&... args) {
    return TensorInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TensorInfoPtr From(const U& u) {
    return mojo::TypeConverter<TensorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TensorInfo>::Convert(*this);
  }


  TensorInfo();

  TensorInfo(
      const ::webnn::OperandDescriptor& descriptor,
      ::webnn::MLTensorUsage usage);


  ~TensorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TensorInfoPtr>
  TensorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TensorInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TensorInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TensorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TensorInfo_UnserializedMessageContext<
            UserType, TensorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TensorInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TensorInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TensorInfo_UnserializedMessageContext<
            UserType, TensorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TensorInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandDescriptor descriptor;
  
  ::webnn::MLTensorUsage usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TensorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ReadTensorResultPtr ReadTensorResult::Clone() const {
  switch (tag_) {
    case Tag::kBuffer:
      return NewBuffer(
          mojo::Clone(data_.buffer));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ReadTensorResult>::value>::type*>
bool ReadTensorResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBuffer:
      return mojo::Equals(data_.buffer, other.data_.buffer);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
WebNNTensor_ExportTensor_ResponseParam_ResultPtr WebNNTensor_ExportTensor_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebNNTensor_ExportTensor_ResponseParam_Result>::value>::type*>
bool WebNNTensor_ExportTensor_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
TensorUsagePtr TensorUsage::Clone() const {
  return New(
      mojo::Clone(web_gpu_interop),
      mojo::Clone(read),
      mojo::Clone(write),
      mojo::Clone(graph_constant)
  );
}

template <typename T, TensorUsage::EnableIfSame<T>*>
bool TensorUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_gpu_interop, other_struct.web_gpu_interop))
    return false;
  if (!mojo::Equals(this->read, other_struct.read))
    return false;
  if (!mojo::Equals(this->write, other_struct.write))
    return false;
  if (!mojo::Equals(this->graph_constant, other_struct.graph_constant))
    return false;
  return true;
}

template <typename T, TensorUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_gpu_interop < rhs.web_gpu_interop)
    return true;
  if (rhs.web_gpu_interop < lhs.web_gpu_interop)
    return false;
  if (lhs.read < rhs.read)
    return true;
  if (rhs.read < lhs.read)
    return false;
  if (lhs.write < rhs.write)
    return true;
  if (rhs.write < lhs.write)
    return false;
  if (lhs.graph_constant < rhs.graph_constant)
    return true;
  if (rhs.graph_constant < lhs.graph_constant)
    return false;
  return false;
}
template <typename StructPtrType>
TensorInfoPtr TensorInfo::Clone() const {
  return New(
      mojo::Clone(descriptor),
      mojo::Clone(usage)
  );
}

template <typename T, TensorInfo::EnableIfSame<T>*>
bool TensorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->descriptor, other_struct.descriptor))
    return false;
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  return true;
}

template <typename T, TensorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.descriptor < rhs.descriptor)
    return true;
  if (rhs.descriptor < lhs.descriptor)
    return false;
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  return false;
}


}  // webnn::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::TensorUsage::DataView,
                                         ::webnn::mojom::TensorUsagePtr> {
  static bool IsNull(const ::webnn::mojom::TensorUsagePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TensorUsagePtr* output) { output->reset(); }

  static decltype(::webnn::mojom::TensorUsage::web_gpu_interop) web_gpu_interop(
      const ::webnn::mojom::TensorUsagePtr& input) {
    return input->web_gpu_interop;
  }

  static decltype(::webnn::mojom::TensorUsage::read) read(
      const ::webnn::mojom::TensorUsagePtr& input) {
    return input->read;
  }

  static decltype(::webnn::mojom::TensorUsage::write) write(
      const ::webnn::mojom::TensorUsagePtr& input) {
    return input->write;
  }

  static decltype(::webnn::mojom::TensorUsage::graph_constant) graph_constant(
      const ::webnn::mojom::TensorUsagePtr& input) {
    return input->graph_constant;
  }

  static bool Read(::webnn::mojom::TensorUsage::DataView input, ::webnn::mojom::TensorUsagePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::TensorInfo::DataView,
                                         ::webnn::mojom::TensorInfoPtr> {
  static bool IsNull(const ::webnn::mojom::TensorInfoPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TensorInfoPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::TensorInfo::descriptor)& descriptor(
      const ::webnn::mojom::TensorInfoPtr& input) {
    return input->descriptor;
  }

  static const decltype(::webnn::mojom::TensorInfo::usage)& usage(
      const ::webnn::mojom::TensorInfoPtr& input) {
    return input->usage;
  }

  static bool Read(::webnn::mojom::TensorInfo::DataView input, ::webnn::mojom::TensorInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::ReadTensorResult::DataView,
                                        ::webnn::mojom::ReadTensorResultPtr> {
  static bool IsNull(const ::webnn::mojom::ReadTensorResultPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReadTensorResultPtr* output) { output->reset(); }

  static ::webnn::mojom::ReadTensorResult::Tag GetTag(const ::webnn::mojom::ReadTensorResultPtr& input) {
    return input->which();
  }

  static  ::mojo_base::BigBuffer& buffer( ::webnn::mojom::ReadTensorResultPtr& input) {
    return input->get_buffer();
  }

  static const ::webnn::mojom::ErrorPtr& error(const ::webnn::mojom::ReadTensorResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::webnn::mojom::ReadTensorResult::DataView input, ::webnn::mojom::ReadTensorResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_Result::DataView,
                                        ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr> {
  static bool IsNull(const ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_Result::Tag GetTag(const ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::gpu::SyncToken& success(const ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::webnn::mojom::ErrorPtr& failure(const ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_Result::DataView input, ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_H_