// services/webnn/public/mojom/webnn_graph.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_graph.mojom-forward.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context_properties.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/webnn/public/mojom/context_properties_mojom_traits.h"
#include "services/webnn/public/mojom/data_type_limits_mojom_traits.h"
#include "services/webnn/public/mojom/number_mojom_traits.h"
#include "services/webnn/public/mojom/operand_descriptor_mojom_traits.h"
#include "services/webnn/public/mojom/operand_id_mojom_traits.h"
#include "services/webnn/public/mojom/range_traits.h"
#include "services/webnn/public/mojom/supported_data_types_mojom_traits.h"
#include "services/webnn/public/mojom/supported_tensors_mojom_traits.h"
#include "services/webnn/public/mojom/tensor_usage_mojom_traits.h"
#include "base/component_export.h"




namespace webnn::mojom {

class WebNNGraphProxy;

template <typename ImplRefTraits>
class WebNNGraphStub;

class WebNNGraphRequestValidator;


class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraph
    : public WebNNGraphInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webnn.mojom.WebNNGraph";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebNNGraphInterfaceBase;
  using Proxy_ = WebNNGraphProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebNNGraphStub<ImplRefTraits>;

  using RequestValidator_ = WebNNGraphRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Dispatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebNNGraph() = default;

  virtual void Dispatch(const base::flat_map<std::string, ::blink::WebNNTensorToken>& named_inputs, const base::flat_map<std::string, ::blink::WebNNTensorToken>& named_outputs) = 0;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphProxy
    : public WebNNGraph {
 public:
  using InterfaceType = WebNNGraph;

  explicit WebNNGraphProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Dispatch(const base::flat_map<std::string, ::blink::WebNNTensorToken>& named_inputs, const base::flat_map<std::string, ::blink::WebNNTensorToken>& named_outputs) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphStubDispatch {
 public:
  static bool Accept(WebNNGraph* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebNNGraph* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebNNGraph>>
class WebNNGraphStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebNNGraphStub() = default;
  ~WebNNGraphStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNGraphStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNGraphStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNGraphRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(WEBNN_MOJOM) OperandId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OperandId, T>::value>;
  using DataView = OperandIdDataView;
  using Data_ = internal::OperandId_Data;

  template <typename... Args>
  static OperandIdPtr New(Args&&... args) {
    return OperandIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OperandIdPtr From(const U& u) {
    return mojo::TypeConverter<OperandIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OperandId>::Convert(*this);
  }


  OperandId();

  explicit OperandId(
      uint32_t id);


  ~OperandId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OperandIdPtr>
  OperandIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OperandId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OperandId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OperandId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OperandId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OperandId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OperandId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OperandId_UnserializedMessageContext<
            UserType, OperandId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OperandId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OperandId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OperandId_UnserializedMessageContext<
            UserType, OperandId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OperandId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OperandId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OperandId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OperandId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OperandId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(WEBNN_MOJOM) Size2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Size2d, T>::value>;
  using DataView = Size2dDataView;
  using Data_ = internal::Size2d_Data;

  template <typename... Args>
  static Size2dPtr New(Args&&... args) {
    return Size2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Size2dPtr From(const U& u) {
    return mojo::TypeConverter<Size2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Size2d>::Convert(*this);
  }


  Size2d();

  Size2d(
      uint32_t height,
      uint32_t width);


  ~Size2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Size2dPtr>
  Size2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Size2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Size2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Size2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Size2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Size2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Size2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Size2d_UnserializedMessageContext<
            UserType, Size2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Size2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Size2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Size2d_UnserializedMessageContext<
            UserType, Size2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Size2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t height;
  
  uint32_t width;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Size2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Size2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Size2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Size2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class COMPONENT_EXPORT(WEBNN_MOJOM) EdgePadding {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EdgePadding, T>::value>;
  using DataView = EdgePaddingDataView;
  using Data_ = internal::EdgePadding_Data;

  template <typename... Args>
  static EdgePaddingPtr New(Args&&... args) {
    return EdgePaddingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EdgePaddingPtr From(const U& u) {
    return mojo::TypeConverter<EdgePaddingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EdgePadding>::Convert(*this);
  }


  EdgePadding();


  ~EdgePadding();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EdgePaddingPtr>
  EdgePaddingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EdgePadding::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EdgePadding::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EdgePadding::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EdgePadding_UnserializedMessageContext<
            UserType, EdgePadding::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EdgePadding::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EdgePadding::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EdgePadding_UnserializedMessageContext<
            UserType, EdgePadding::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EdgePadding::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EdgePadding::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ReflectionPadding {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReflectionPadding, T>::value>;
  using DataView = ReflectionPaddingDataView;
  using Data_ = internal::ReflectionPadding_Data;

  template <typename... Args>
  static ReflectionPaddingPtr New(Args&&... args) {
    return ReflectionPaddingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReflectionPaddingPtr From(const U& u) {
    return mojo::TypeConverter<ReflectionPaddingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReflectionPadding>::Convert(*this);
  }


  ReflectionPadding();


  ~ReflectionPadding();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReflectionPaddingPtr>
  ReflectionPaddingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReflectionPadding::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReflectionPadding::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReflectionPadding::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReflectionPadding_UnserializedMessageContext<
            UserType, ReflectionPadding::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReflectionPadding::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReflectionPadding::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReflectionPadding_UnserializedMessageContext<
            UserType, ReflectionPadding::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReflectionPadding::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReflectionPadding::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(WEBNN_MOJOM) Range {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Range, T>::value>;
  using DataView = RangeDataView;
  using Data_ = internal::Range_Data;

  template <typename... Args>
  static RangePtr New(Args&&... args) {
    return RangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RangePtr From(const U& u) {
    return mojo::TypeConverter<RangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Range>::Convert(*this);
  }


  Range();

  Range(
      uint32_t start,
      uint32_t size,
      uint32_t stride);


  ~Range();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RangePtr>
  RangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Range::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Range::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Range::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Range_UnserializedMessageContext<
            UserType, Range::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Range::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Range::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Range_UnserializedMessageContext<
            UserType, Range::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Range::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t start;
  
  uint32_t size;
  
  uint32_t stride;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








































class COMPONENT_EXPORT(WEBNN_MOJOM) Number {
 public:
  using DataView = NumberDataView;
  using Data_ = internal::Number_Data;
  using Tag = Data_::Number_Tag;

  template <typename... Args>
  static NumberPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |floating_point|.
  static NumberPtr NewFloatingPoint(
      double value);
  // Construct an instance holding |signed_integer|.
  static NumberPtr NewSignedInteger(
      int64_t value);
  // Construct an instance holding |unsigned_integer|.
  static NumberPtr NewUnsignedInteger(
      uint64_t value);

  template <typename U>
  static NumberPtr From(const U& u) {
    return mojo::TypeConverter<NumberPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Number>::Convert(*this);
  }
  ~Number();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NumberPtr>
  NumberPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Number>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Number>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_floating_point() const { return tag_ == Tag::kFloatingPoint; }
  double get_floating_point() const {
    CHECK(tag_ == Tag::kFloatingPoint);
    return data_.floating_point;
  }
  void set_floating_point(double floating_point);

  bool is_signed_integer() const { return tag_ == Tag::kSignedInteger; }
  int64_t get_signed_integer() const {
    CHECK(tag_ == Tag::kSignedInteger);
    return data_.signed_integer;
  }
  void set_signed_integer(int64_t signed_integer);

  bool is_unsigned_integer() const { return tag_ == Tag::kUnsignedInteger; }
  uint64_t get_unsigned_integer() const {
    CHECK(tag_ == Tag::kUnsignedInteger);
    return data_.unsigned_integer;
  }
  void set_unsigned_integer(uint64_t unsigned_integer);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Number::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Number::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFloatingPoint)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSignedInteger)>,
        int64_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnsignedInteger)>,
        uint64_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    double floating_point;
    int64_t signed_integer;
    uint64_t unsigned_integer;
  };

  Number(
      std::in_place_index_t<static_cast<size_t>(Tag::kFloatingPoint)>,
      double value);
  Number(
      std::in_place_index_t<static_cast<size_t>(Tag::kSignedInteger)>,
      int64_t value);
  Number(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnsignedInteger)>,
      uint64_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) PaddingMode {
 public:
  using DataView = PaddingModeDataView;
  using Data_ = internal::PaddingMode_Data;
  using Tag = Data_::PaddingMode_Tag;

  template <typename... Args>
  static PaddingModePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |constant|.
  static PaddingModePtr NewConstant(
      ConstantPaddingPtr value);
  // Construct an instance holding |edge|.
  static PaddingModePtr NewEdge(
      EdgePaddingPtr value);
  // Construct an instance holding |reflection|.
  static PaddingModePtr NewReflection(
      ReflectionPaddingPtr value);

  template <typename U>
  static PaddingModePtr From(const U& u) {
    return mojo::TypeConverter<PaddingModePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaddingMode>::Convert(*this);
  }
  ~PaddingMode();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PaddingMode(const PaddingMode& other) = delete;
  PaddingMode& operator=(const PaddingMode& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PaddingModePtr>
  PaddingModePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PaddingMode>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PaddingMode>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_constant() const { return tag_ == Tag::kConstant; }
  const ConstantPaddingPtr& get_constant() const {
    CHECK(tag_ == Tag::kConstant);
    return data_.constant;
  }
  ConstantPaddingPtr& get_constant() {
    CHECK(tag_ == Tag::kConstant);
    return data_.constant;
  }
  void set_constant(ConstantPaddingPtr constant);

  bool is_edge() const { return tag_ == Tag::kEdge; }
  const EdgePaddingPtr& get_edge() const {
    CHECK(tag_ == Tag::kEdge);
    return data_.edge;
  }
  EdgePaddingPtr& get_edge() {
    CHECK(tag_ == Tag::kEdge);
    return data_.edge;
  }
  void set_edge(EdgePaddingPtr edge);

  bool is_reflection() const { return tag_ == Tag::kReflection; }
  const ReflectionPaddingPtr& get_reflection() const {
    CHECK(tag_ == Tag::kReflection);
    return data_.reflection;
  }
  ReflectionPaddingPtr& get_reflection() {
    CHECK(tag_ == Tag::kReflection);
    return data_.reflection;
  }
  void set_reflection(ReflectionPaddingPtr reflection);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaddingMode::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PaddingMode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
        ConstantPaddingPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEdge)>,
        EdgePaddingPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReflection)>,
        ReflectionPaddingPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ConstantPaddingPtr constant;
    EdgePaddingPtr edge;
    ReflectionPaddingPtr reflection;
  };

  PaddingMode(
      std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
      ConstantPaddingPtr value);
  PaddingMode(
      std::in_place_index_t<static_cast<size_t>(Tag::kEdge)>,
      EdgePaddingPtr value);
  PaddingMode(
      std::in_place_index_t<static_cast<size_t>(Tag::kReflection)>,
      ReflectionPaddingPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) Operation {
 public:
  using DataView = OperationDataView;
  using Data_ = internal::Operation_Data;
  using Tag = Data_::Operation_Tag;

  template <typename... Args>
  static OperationPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |arg_min_max|.
  static OperationPtr NewArgMinMax(
      ArgMinMaxPtr value);
  // Construct an instance holding |batch_normalization|.
  static OperationPtr NewBatchNormalization(
      BatchNormalizationPtr value);
  // Construct an instance holding |clamp|.
  static OperationPtr NewClamp(
      ClampPtr value);
  // Construct an instance holding |concat|.
  static OperationPtr NewConcat(
      ConcatPtr value);
  // Construct an instance holding |conv2d|.
  static OperationPtr NewConv2d(
      Conv2dPtr value);
  // Construct an instance holding |cumulative_sum|.
  static OperationPtr NewCumulativeSum(
      CumulativeSumPtr value);
  // Construct an instance holding |dequantize_linear|.
  static OperationPtr NewDequantizeLinear(
      DequantizeLinearPtr value);
  // Construct an instance holding |element_wise_binary|.
  static OperationPtr NewElementWiseBinary(
      ElementWiseBinaryPtr value);
  // Construct an instance holding |elu|.
  static OperationPtr NewElu(
      EluPtr value);
  // Construct an instance holding |element_wise_unary|.
  static OperationPtr NewElementWiseUnary(
      ElementWiseUnaryPtr value);
  // Construct an instance holding |expand|.
  static OperationPtr NewExpand(
      ExpandPtr value);
  // Construct an instance holding |gather|.
  static OperationPtr NewGather(
      GatherPtr value);
  // Construct an instance holding |gather_elements|.
  static OperationPtr NewGatherElements(
      GatherElementsPtr value);
  // Construct an instance holding |gather_nd|.
  static OperationPtr NewGatherNd(
      GatherNDPtr value);
  // Construct an instance holding |gelu|.
  static OperationPtr NewGelu(
      GeluPtr value);
  // Construct an instance holding |gemm|.
  static OperationPtr NewGemm(
      GemmPtr value);
  // Construct an instance holding |gru|.
  static OperationPtr NewGru(
      GruPtr value);
  // Construct an instance holding |gru_cell|.
  static OperationPtr NewGruCell(
      GruCellPtr value);
  // Construct an instance holding |hard_sigmoid|.
  static OperationPtr NewHardSigmoid(
      HardSigmoidPtr value);
  // Construct an instance holding |hard_swish|.
  static OperationPtr NewHardSwish(
      HardSwishPtr value);
  // Construct an instance holding |layer_normalization|.
  static OperationPtr NewLayerNormalization(
      LayerNormalizationPtr value);
  // Construct an instance holding |instance_normalization|.
  static OperationPtr NewInstanceNormalization(
      InstanceNormalizationPtr value);
  // Construct an instance holding |leaky_relu|.
  static OperationPtr NewLeakyRelu(
      LeakyReluPtr value);
  // Construct an instance holding |linear|.
  static OperationPtr NewLinear(
      LinearPtr value);
  // Construct an instance holding |lstm|.
  static OperationPtr NewLstm(
      LstmPtr value);
  // Construct an instance holding |lstm_cell|.
  static OperationPtr NewLstmCell(
      LstmCellPtr value);
  // Construct an instance holding |matmul|.
  static OperationPtr NewMatmul(
      MatmulPtr value);
  // Construct an instance holding |pad|.
  static OperationPtr NewPad(
      PadPtr value);
  // Construct an instance holding |pool2d|.
  static OperationPtr NewPool2d(
      Pool2dPtr value);
  // Construct an instance holding |prelu|.
  static OperationPtr NewPrelu(
      PreluPtr value);
  // Construct an instance holding |quantize_linear|.
  static OperationPtr NewQuantizeLinear(
      QuantizeLinearPtr value);
  // Construct an instance holding |reduce|.
  static OperationPtr NewReduce(
      ReducePtr value);
  // Construct an instance holding |relu|.
  static OperationPtr NewRelu(
      ReluPtr value);
  // Construct an instance holding |resample2d|.
  static OperationPtr NewResample2d(
      Resample2dPtr value);
  // Construct an instance holding |reshape|.
  static OperationPtr NewReshape(
      ReshapePtr value);
  // Construct an instance holding |reverse|.
  static OperationPtr NewReverse(
      ReversePtr value);
  // Construct an instance holding |scatter_elements|.
  static OperationPtr NewScatterElements(
      ScatterElementsPtr value);
  // Construct an instance holding |scatter_nd|.
  static OperationPtr NewScatterNd(
      ScatterNDPtr value);
  // Construct an instance holding |sigmoid|.
  static OperationPtr NewSigmoid(
      SigmoidPtr value);
  // Construct an instance holding |slice|.
  static OperationPtr NewSlice(
      SlicePtr value);
  // Construct an instance holding |softmax|.
  static OperationPtr NewSoftmax(
      SoftmaxPtr value);
  // Construct an instance holding |softplus|.
  static OperationPtr NewSoftplus(
      SoftplusPtr value);
  // Construct an instance holding |softsign|.
  static OperationPtr NewSoftsign(
      SoftsignPtr value);
  // Construct an instance holding |split|.
  static OperationPtr NewSplit(
      SplitPtr value);
  // Construct an instance holding |tanh|.
  static OperationPtr NewTanh(
      TanhPtr value);
  // Construct an instance holding |tile|.
  static OperationPtr NewTile(
      TilePtr value);
  // Construct an instance holding |transpose|.
  static OperationPtr NewTranspose(
      TransposePtr value);
  // Construct an instance holding |triangular|.
  static OperationPtr NewTriangular(
      TriangularPtr value);
  // Construct an instance holding |where|.
  static OperationPtr NewWhere(
      WherePtr value);

  template <typename U>
  static OperationPtr From(const U& u) {
    return mojo::TypeConverter<OperationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Operation>::Convert(*this);
  }
  ~Operation();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Operation(const Operation& other) = delete;
  Operation& operator=(const Operation& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = OperationPtr>
  OperationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Operation>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Operation>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_arg_min_max() const { return tag_ == Tag::kArgMinMax; }
  const ArgMinMaxPtr& get_arg_min_max() const {
    CHECK(tag_ == Tag::kArgMinMax);
    return data_.arg_min_max;
  }
  ArgMinMaxPtr& get_arg_min_max() {
    CHECK(tag_ == Tag::kArgMinMax);
    return data_.arg_min_max;
  }
  void set_arg_min_max(ArgMinMaxPtr arg_min_max);

  bool is_batch_normalization() const { return tag_ == Tag::kBatchNormalization; }
  const BatchNormalizationPtr& get_batch_normalization() const {
    CHECK(tag_ == Tag::kBatchNormalization);
    return data_.batch_normalization;
  }
  BatchNormalizationPtr& get_batch_normalization() {
    CHECK(tag_ == Tag::kBatchNormalization);
    return data_.batch_normalization;
  }
  void set_batch_normalization(BatchNormalizationPtr batch_normalization);

  bool is_clamp() const { return tag_ == Tag::kClamp; }
  const ClampPtr& get_clamp() const {
    CHECK(tag_ == Tag::kClamp);
    return data_.clamp;
  }
  ClampPtr& get_clamp() {
    CHECK(tag_ == Tag::kClamp);
    return data_.clamp;
  }
  void set_clamp(ClampPtr clamp);

  bool is_concat() const { return tag_ == Tag::kConcat; }
  const ConcatPtr& get_concat() const {
    CHECK(tag_ == Tag::kConcat);
    return data_.concat;
  }
  ConcatPtr& get_concat() {
    CHECK(tag_ == Tag::kConcat);
    return data_.concat;
  }
  void set_concat(ConcatPtr concat);

  bool is_conv2d() const { return tag_ == Tag::kConv2d; }
  const Conv2dPtr& get_conv2d() const {
    CHECK(tag_ == Tag::kConv2d);
    return data_.conv2d;
  }
  Conv2dPtr& get_conv2d() {
    CHECK(tag_ == Tag::kConv2d);
    return data_.conv2d;
  }
  void set_conv2d(Conv2dPtr conv2d);

  bool is_cumulative_sum() const { return tag_ == Tag::kCumulativeSum; }
  const CumulativeSumPtr& get_cumulative_sum() const {
    CHECK(tag_ == Tag::kCumulativeSum);
    return data_.cumulative_sum;
  }
  CumulativeSumPtr& get_cumulative_sum() {
    CHECK(tag_ == Tag::kCumulativeSum);
    return data_.cumulative_sum;
  }
  void set_cumulative_sum(CumulativeSumPtr cumulative_sum);

  bool is_dequantize_linear() const { return tag_ == Tag::kDequantizeLinear; }
  const DequantizeLinearPtr& get_dequantize_linear() const {
    CHECK(tag_ == Tag::kDequantizeLinear);
    return data_.dequantize_linear;
  }
  DequantizeLinearPtr& get_dequantize_linear() {
    CHECK(tag_ == Tag::kDequantizeLinear);
    return data_.dequantize_linear;
  }
  void set_dequantize_linear(DequantizeLinearPtr dequantize_linear);

  bool is_element_wise_binary() const { return tag_ == Tag::kElementWiseBinary; }
  const ElementWiseBinaryPtr& get_element_wise_binary() const {
    CHECK(tag_ == Tag::kElementWiseBinary);
    return data_.element_wise_binary;
  }
  ElementWiseBinaryPtr& get_element_wise_binary() {
    CHECK(tag_ == Tag::kElementWiseBinary);
    return data_.element_wise_binary;
  }
  void set_element_wise_binary(ElementWiseBinaryPtr element_wise_binary);

  bool is_elu() const { return tag_ == Tag::kElu; }
  const EluPtr& get_elu() const {
    CHECK(tag_ == Tag::kElu);
    return data_.elu;
  }
  EluPtr& get_elu() {
    CHECK(tag_ == Tag::kElu);
    return data_.elu;
  }
  void set_elu(EluPtr elu);

  bool is_element_wise_unary() const { return tag_ == Tag::kElementWiseUnary; }
  const ElementWiseUnaryPtr& get_element_wise_unary() const {
    CHECK(tag_ == Tag::kElementWiseUnary);
    return data_.element_wise_unary;
  }
  ElementWiseUnaryPtr& get_element_wise_unary() {
    CHECK(tag_ == Tag::kElementWiseUnary);
    return data_.element_wise_unary;
  }
  void set_element_wise_unary(ElementWiseUnaryPtr element_wise_unary);

  bool is_expand() const { return tag_ == Tag::kExpand; }
  const ExpandPtr& get_expand() const {
    CHECK(tag_ == Tag::kExpand);
    return data_.expand;
  }
  ExpandPtr& get_expand() {
    CHECK(tag_ == Tag::kExpand);
    return data_.expand;
  }
  void set_expand(ExpandPtr expand);

  bool is_gather() const { return tag_ == Tag::kGather; }
  const GatherPtr& get_gather() const {
    CHECK(tag_ == Tag::kGather);
    return data_.gather;
  }
  GatherPtr& get_gather() {
    CHECK(tag_ == Tag::kGather);
    return data_.gather;
  }
  void set_gather(GatherPtr gather);

  bool is_gather_elements() const { return tag_ == Tag::kGatherElements; }
  const GatherElementsPtr& get_gather_elements() const {
    CHECK(tag_ == Tag::kGatherElements);
    return data_.gather_elements;
  }
  GatherElementsPtr& get_gather_elements() {
    CHECK(tag_ == Tag::kGatherElements);
    return data_.gather_elements;
  }
  void set_gather_elements(GatherElementsPtr gather_elements);

  bool is_gather_nd() const { return tag_ == Tag::kGatherNd; }
  const GatherNDPtr& get_gather_nd() const {
    CHECK(tag_ == Tag::kGatherNd);
    return data_.gather_nd;
  }
  GatherNDPtr& get_gather_nd() {
    CHECK(tag_ == Tag::kGatherNd);
    return data_.gather_nd;
  }
  void set_gather_nd(GatherNDPtr gather_nd);

  bool is_gelu() const { return tag_ == Tag::kGelu; }
  const GeluPtr& get_gelu() const {
    CHECK(tag_ == Tag::kGelu);
    return data_.gelu;
  }
  GeluPtr& get_gelu() {
    CHECK(tag_ == Tag::kGelu);
    return data_.gelu;
  }
  void set_gelu(GeluPtr gelu);

  bool is_gemm() const { return tag_ == Tag::kGemm; }
  const GemmPtr& get_gemm() const {
    CHECK(tag_ == Tag::kGemm);
    return data_.gemm;
  }
  GemmPtr& get_gemm() {
    CHECK(tag_ == Tag::kGemm);
    return data_.gemm;
  }
  void set_gemm(GemmPtr gemm);

  bool is_gru() const { return tag_ == Tag::kGru; }
  const GruPtr& get_gru() const {
    CHECK(tag_ == Tag::kGru);
    return data_.gru;
  }
  GruPtr& get_gru() {
    CHECK(tag_ == Tag::kGru);
    return data_.gru;
  }
  void set_gru(GruPtr gru);

  bool is_gru_cell() const { return tag_ == Tag::kGruCell; }
  const GruCellPtr& get_gru_cell() const {
    CHECK(tag_ == Tag::kGruCell);
    return data_.gru_cell;
  }
  GruCellPtr& get_gru_cell() {
    CHECK(tag_ == Tag::kGruCell);
    return data_.gru_cell;
  }
  void set_gru_cell(GruCellPtr gru_cell);

  bool is_hard_sigmoid() const { return tag_ == Tag::kHardSigmoid; }
  const HardSigmoidPtr& get_hard_sigmoid() const {
    CHECK(tag_ == Tag::kHardSigmoid);
    return data_.hard_sigmoid;
  }
  HardSigmoidPtr& get_hard_sigmoid() {
    CHECK(tag_ == Tag::kHardSigmoid);
    return data_.hard_sigmoid;
  }
  void set_hard_sigmoid(HardSigmoidPtr hard_sigmoid);

  bool is_hard_swish() const { return tag_ == Tag::kHardSwish; }
  const HardSwishPtr& get_hard_swish() const {
    CHECK(tag_ == Tag::kHardSwish);
    return data_.hard_swish;
  }
  HardSwishPtr& get_hard_swish() {
    CHECK(tag_ == Tag::kHardSwish);
    return data_.hard_swish;
  }
  void set_hard_swish(HardSwishPtr hard_swish);

  bool is_layer_normalization() const { return tag_ == Tag::kLayerNormalization; }
  const LayerNormalizationPtr& get_layer_normalization() const {
    CHECK(tag_ == Tag::kLayerNormalization);
    return data_.layer_normalization;
  }
  LayerNormalizationPtr& get_layer_normalization() {
    CHECK(tag_ == Tag::kLayerNormalization);
    return data_.layer_normalization;
  }
  void set_layer_normalization(LayerNormalizationPtr layer_normalization);

  bool is_instance_normalization() const { return tag_ == Tag::kInstanceNormalization; }
  const InstanceNormalizationPtr& get_instance_normalization() const {
    CHECK(tag_ == Tag::kInstanceNormalization);
    return data_.instance_normalization;
  }
  InstanceNormalizationPtr& get_instance_normalization() {
    CHECK(tag_ == Tag::kInstanceNormalization);
    return data_.instance_normalization;
  }
  void set_instance_normalization(InstanceNormalizationPtr instance_normalization);

  bool is_leaky_relu() const { return tag_ == Tag::kLeakyRelu; }
  const LeakyReluPtr& get_leaky_relu() const {
    CHECK(tag_ == Tag::kLeakyRelu);
    return data_.leaky_relu;
  }
  LeakyReluPtr& get_leaky_relu() {
    CHECK(tag_ == Tag::kLeakyRelu);
    return data_.leaky_relu;
  }
  void set_leaky_relu(LeakyReluPtr leaky_relu);

  bool is_linear() const { return tag_ == Tag::kLinear; }
  const LinearPtr& get_linear() const {
    CHECK(tag_ == Tag::kLinear);
    return data_.linear;
  }
  LinearPtr& get_linear() {
    CHECK(tag_ == Tag::kLinear);
    return data_.linear;
  }
  void set_linear(LinearPtr linear);

  bool is_lstm() const { return tag_ == Tag::kLstm; }
  const LstmPtr& get_lstm() const {
    CHECK(tag_ == Tag::kLstm);
    return data_.lstm;
  }
  LstmPtr& get_lstm() {
    CHECK(tag_ == Tag::kLstm);
    return data_.lstm;
  }
  void set_lstm(LstmPtr lstm);

  bool is_lstm_cell() const { return tag_ == Tag::kLstmCell; }
  const LstmCellPtr& get_lstm_cell() const {
    CHECK(tag_ == Tag::kLstmCell);
    return data_.lstm_cell;
  }
  LstmCellPtr& get_lstm_cell() {
    CHECK(tag_ == Tag::kLstmCell);
    return data_.lstm_cell;
  }
  void set_lstm_cell(LstmCellPtr lstm_cell);

  bool is_matmul() const { return tag_ == Tag::kMatmul; }
  const MatmulPtr& get_matmul() const {
    CHECK(tag_ == Tag::kMatmul);
    return data_.matmul;
  }
  MatmulPtr& get_matmul() {
    CHECK(tag_ == Tag::kMatmul);
    return data_.matmul;
  }
  void set_matmul(MatmulPtr matmul);

  bool is_pad() const { return tag_ == Tag::kPad; }
  const PadPtr& get_pad() const {
    CHECK(tag_ == Tag::kPad);
    return data_.pad;
  }
  PadPtr& get_pad() {
    CHECK(tag_ == Tag::kPad);
    return data_.pad;
  }
  void set_pad(PadPtr pad);

  bool is_pool2d() const { return tag_ == Tag::kPool2d; }
  const Pool2dPtr& get_pool2d() const {
    CHECK(tag_ == Tag::kPool2d);
    return data_.pool2d;
  }
  Pool2dPtr& get_pool2d() {
    CHECK(tag_ == Tag::kPool2d);
    return data_.pool2d;
  }
  void set_pool2d(Pool2dPtr pool2d);

  bool is_prelu() const { return tag_ == Tag::kPrelu; }
  const PreluPtr& get_prelu() const {
    CHECK(tag_ == Tag::kPrelu);
    return data_.prelu;
  }
  PreluPtr& get_prelu() {
    CHECK(tag_ == Tag::kPrelu);
    return data_.prelu;
  }
  void set_prelu(PreluPtr prelu);

  bool is_quantize_linear() const { return tag_ == Tag::kQuantizeLinear; }
  const QuantizeLinearPtr& get_quantize_linear() const {
    CHECK(tag_ == Tag::kQuantizeLinear);
    return data_.quantize_linear;
  }
  QuantizeLinearPtr& get_quantize_linear() {
    CHECK(tag_ == Tag::kQuantizeLinear);
    return data_.quantize_linear;
  }
  void set_quantize_linear(QuantizeLinearPtr quantize_linear);

  bool is_reduce() const { return tag_ == Tag::kReduce; }
  const ReducePtr& get_reduce() const {
    CHECK(tag_ == Tag::kReduce);
    return data_.reduce;
  }
  ReducePtr& get_reduce() {
    CHECK(tag_ == Tag::kReduce);
    return data_.reduce;
  }
  void set_reduce(ReducePtr reduce);

  bool is_relu() const { return tag_ == Tag::kRelu; }
  const ReluPtr& get_relu() const {
    CHECK(tag_ == Tag::kRelu);
    return data_.relu;
  }
  ReluPtr& get_relu() {
    CHECK(tag_ == Tag::kRelu);
    return data_.relu;
  }
  void set_relu(ReluPtr relu);

  bool is_resample2d() const { return tag_ == Tag::kResample2d; }
  const Resample2dPtr& get_resample2d() const {
    CHECK(tag_ == Tag::kResample2d);
    return data_.resample2d;
  }
  Resample2dPtr& get_resample2d() {
    CHECK(tag_ == Tag::kResample2d);
    return data_.resample2d;
  }
  void set_resample2d(Resample2dPtr resample2d);

  bool is_reshape() const { return tag_ == Tag::kReshape; }
  const ReshapePtr& get_reshape() const {
    CHECK(tag_ == Tag::kReshape);
    return data_.reshape;
  }
  ReshapePtr& get_reshape() {
    CHECK(tag_ == Tag::kReshape);
    return data_.reshape;
  }
  void set_reshape(ReshapePtr reshape);

  bool is_reverse() const { return tag_ == Tag::kReverse; }
  const ReversePtr& get_reverse() const {
    CHECK(tag_ == Tag::kReverse);
    return data_.reverse;
  }
  ReversePtr& get_reverse() {
    CHECK(tag_ == Tag::kReverse);
    return data_.reverse;
  }
  void set_reverse(ReversePtr reverse);

  bool is_scatter_elements() const { return tag_ == Tag::kScatterElements; }
  const ScatterElementsPtr& get_scatter_elements() const {
    CHECK(tag_ == Tag::kScatterElements);
    return data_.scatter_elements;
  }
  ScatterElementsPtr& get_scatter_elements() {
    CHECK(tag_ == Tag::kScatterElements);
    return data_.scatter_elements;
  }
  void set_scatter_elements(ScatterElementsPtr scatter_elements);

  bool is_scatter_nd() const { return tag_ == Tag::kScatterNd; }
  const ScatterNDPtr& get_scatter_nd() const {
    CHECK(tag_ == Tag::kScatterNd);
    return data_.scatter_nd;
  }
  ScatterNDPtr& get_scatter_nd() {
    CHECK(tag_ == Tag::kScatterNd);
    return data_.scatter_nd;
  }
  void set_scatter_nd(ScatterNDPtr scatter_nd);

  bool is_sigmoid() const { return tag_ == Tag::kSigmoid; }
  const SigmoidPtr& get_sigmoid() const {
    CHECK(tag_ == Tag::kSigmoid);
    return data_.sigmoid;
  }
  SigmoidPtr& get_sigmoid() {
    CHECK(tag_ == Tag::kSigmoid);
    return data_.sigmoid;
  }
  void set_sigmoid(SigmoidPtr sigmoid);

  bool is_slice() const { return tag_ == Tag::kSlice; }
  const SlicePtr& get_slice() const {
    CHECK(tag_ == Tag::kSlice);
    return data_.slice;
  }
  SlicePtr& get_slice() {
    CHECK(tag_ == Tag::kSlice);
    return data_.slice;
  }
  void set_slice(SlicePtr slice);

  bool is_softmax() const { return tag_ == Tag::kSoftmax; }
  const SoftmaxPtr& get_softmax() const {
    CHECK(tag_ == Tag::kSoftmax);
    return data_.softmax;
  }
  SoftmaxPtr& get_softmax() {
    CHECK(tag_ == Tag::kSoftmax);
    return data_.softmax;
  }
  void set_softmax(SoftmaxPtr softmax);

  bool is_softplus() const { return tag_ == Tag::kSoftplus; }
  const SoftplusPtr& get_softplus() const {
    CHECK(tag_ == Tag::kSoftplus);
    return data_.softplus;
  }
  SoftplusPtr& get_softplus() {
    CHECK(tag_ == Tag::kSoftplus);
    return data_.softplus;
  }
  void set_softplus(SoftplusPtr softplus);

  bool is_softsign() const { return tag_ == Tag::kSoftsign; }
  const SoftsignPtr& get_softsign() const {
    CHECK(tag_ == Tag::kSoftsign);
    return data_.softsign;
  }
  SoftsignPtr& get_softsign() {
    CHECK(tag_ == Tag::kSoftsign);
    return data_.softsign;
  }
  void set_softsign(SoftsignPtr softsign);

  bool is_split() const { return tag_ == Tag::kSplit; }
  const SplitPtr& get_split() const {
    CHECK(tag_ == Tag::kSplit);
    return data_.split;
  }
  SplitPtr& get_split() {
    CHECK(tag_ == Tag::kSplit);
    return data_.split;
  }
  void set_split(SplitPtr split);

  bool is_tanh() const { return tag_ == Tag::kTanh; }
  const TanhPtr& get_tanh() const {
    CHECK(tag_ == Tag::kTanh);
    return data_.tanh;
  }
  TanhPtr& get_tanh() {
    CHECK(tag_ == Tag::kTanh);
    return data_.tanh;
  }
  void set_tanh(TanhPtr tanh);

  bool is_tile() const { return tag_ == Tag::kTile; }
  const TilePtr& get_tile() const {
    CHECK(tag_ == Tag::kTile);
    return data_.tile;
  }
  TilePtr& get_tile() {
    CHECK(tag_ == Tag::kTile);
    return data_.tile;
  }
  void set_tile(TilePtr tile);

  bool is_transpose() const { return tag_ == Tag::kTranspose; }
  const TransposePtr& get_transpose() const {
    CHECK(tag_ == Tag::kTranspose);
    return data_.transpose;
  }
  TransposePtr& get_transpose() {
    CHECK(tag_ == Tag::kTranspose);
    return data_.transpose;
  }
  void set_transpose(TransposePtr transpose);

  bool is_triangular() const { return tag_ == Tag::kTriangular; }
  const TriangularPtr& get_triangular() const {
    CHECK(tag_ == Tag::kTriangular);
    return data_.triangular;
  }
  TriangularPtr& get_triangular() {
    CHECK(tag_ == Tag::kTriangular);
    return data_.triangular;
  }
  void set_triangular(TriangularPtr triangular);

  bool is_where() const { return tag_ == Tag::kWhere; }
  const WherePtr& get_where() const {
    CHECK(tag_ == Tag::kWhere);
    return data_.where;
  }
  WherePtr& get_where() {
    CHECK(tag_ == Tag::kWhere);
    return data_.where;
  }
  void set_where(WherePtr where);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Operation::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Operation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kArgMinMax)>,
        ArgMinMaxPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBatchNormalization)>,
        BatchNormalizationPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kClamp)>,
        ClampPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kConcat)>,
        ConcatPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kConv2d)>,
        Conv2dPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCumulativeSum)>,
        CumulativeSumPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDequantizeLinear)>,
        DequantizeLinearPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseBinary)>,
        ElementWiseBinaryPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kElu)>,
        EluPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseUnary)>,
        ElementWiseUnaryPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kExpand)>,
        ExpandPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGather)>,
        GatherPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGatherElements)>,
        GatherElementsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGatherNd)>,
        GatherNDPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGelu)>,
        GeluPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGemm)>,
        GemmPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGru)>,
        GruPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGruCell)>,
        GruCellPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHardSigmoid)>,
        HardSigmoidPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHardSwish)>,
        HardSwishPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLayerNormalization)>,
        LayerNormalizationPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInstanceNormalization)>,
        InstanceNormalizationPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLeakyRelu)>,
        LeakyReluPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
        LinearPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLstm)>,
        LstmPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLstmCell)>,
        LstmCellPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMatmul)>,
        MatmulPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPad)>,
        PadPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPool2d)>,
        Pool2dPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPrelu)>,
        PreluPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kQuantizeLinear)>,
        QuantizeLinearPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReduce)>,
        ReducePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRelu)>,
        ReluPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kResample2d)>,
        Resample2dPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReshape)>,
        ReshapePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReverse)>,
        ReversePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScatterElements)>,
        ScatterElementsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScatterNd)>,
        ScatterNDPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSigmoid)>,
        SigmoidPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSlice)>,
        SlicePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSoftmax)>,
        SoftmaxPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSoftplus)>,
        SoftplusPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSoftsign)>,
        SoftsignPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSplit)>,
        SplitPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTanh)>,
        TanhPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTile)>,
        TilePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTranspose)>,
        TransposePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTriangular)>,
        TriangularPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kWhere)>,
        WherePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ArgMinMaxPtr arg_min_max;
    BatchNormalizationPtr batch_normalization;
    ClampPtr clamp;
    ConcatPtr concat;
    Conv2dPtr conv2d;
    CumulativeSumPtr cumulative_sum;
    DequantizeLinearPtr dequantize_linear;
    ElementWiseBinaryPtr element_wise_binary;
    EluPtr elu;
    ElementWiseUnaryPtr element_wise_unary;
    ExpandPtr expand;
    GatherPtr gather;
    GatherElementsPtr gather_elements;
    GatherNDPtr gather_nd;
    GeluPtr gelu;
    GemmPtr gemm;
    GruPtr gru;
    GruCellPtr gru_cell;
    HardSigmoidPtr hard_sigmoid;
    HardSwishPtr hard_swish;
    LayerNormalizationPtr layer_normalization;
    InstanceNormalizationPtr instance_normalization;
    LeakyReluPtr leaky_relu;
    LinearPtr linear;
    LstmPtr lstm;
    LstmCellPtr lstm_cell;
    MatmulPtr matmul;
    PadPtr pad;
    Pool2dPtr pool2d;
    PreluPtr prelu;
    QuantizeLinearPtr quantize_linear;
    ReducePtr reduce;
    ReluPtr relu;
    Resample2dPtr resample2d;
    ReshapePtr reshape;
    ReversePtr reverse;
    ScatterElementsPtr scatter_elements;
    ScatterNDPtr scatter_nd;
    SigmoidPtr sigmoid;
    SlicePtr slice;
    SoftmaxPtr softmax;
    SoftplusPtr softplus;
    SoftsignPtr softsign;
    SplitPtr split;
    TanhPtr tanh;
    TilePtr tile;
    TransposePtr transpose;
    TriangularPtr triangular;
    WherePtr where;
  };

  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kArgMinMax)>,
      ArgMinMaxPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kBatchNormalization)>,
      BatchNormalizationPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kClamp)>,
      ClampPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kConcat)>,
      ConcatPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kConv2d)>,
      Conv2dPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kCumulativeSum)>,
      CumulativeSumPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kDequantizeLinear)>,
      DequantizeLinearPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseBinary)>,
      ElementWiseBinaryPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kElu)>,
      EluPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseUnary)>,
      ElementWiseUnaryPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kExpand)>,
      ExpandPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGather)>,
      GatherPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGatherElements)>,
      GatherElementsPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGatherNd)>,
      GatherNDPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGelu)>,
      GeluPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGemm)>,
      GemmPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGru)>,
      GruPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kGruCell)>,
      GruCellPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kHardSigmoid)>,
      HardSigmoidPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kHardSwish)>,
      HardSwishPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kLayerNormalization)>,
      LayerNormalizationPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kInstanceNormalization)>,
      InstanceNormalizationPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kLeakyRelu)>,
      LeakyReluPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
      LinearPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kLstm)>,
      LstmPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kLstmCell)>,
      LstmCellPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kMatmul)>,
      MatmulPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kPad)>,
      PadPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kPool2d)>,
      Pool2dPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kPrelu)>,
      PreluPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kQuantizeLinear)>,
      QuantizeLinearPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kReduce)>,
      ReducePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kRelu)>,
      ReluPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kResample2d)>,
      Resample2dPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kReshape)>,
      ReshapePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kReverse)>,
      ReversePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kScatterElements)>,
      ScatterElementsPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kScatterNd)>,
      ScatterNDPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSigmoid)>,
      SigmoidPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSlice)>,
      SlicePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSoftmax)>,
      SoftmaxPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSoftplus)>,
      SoftplusPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSoftsign)>,
      SoftsignPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kSplit)>,
      SplitPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kTanh)>,
      TanhPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kTile)>,
      TilePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kTranspose)>,
      TransposePtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kTriangular)>,
      TriangularPtr value);
  Operation(
      std::in_place_index_t<static_cast<size_t>(Tag::kWhere)>,
      WherePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(WEBNN_MOJOM) OperandDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OperandDescriptor, T>::value>;
  using DataView = OperandDescriptorDataView;
  using Data_ = internal::OperandDescriptor_Data;

  template <typename... Args>
  static OperandDescriptorPtr New(Args&&... args) {
    return OperandDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OperandDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<OperandDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OperandDescriptor>::Convert(*this);
  }


  OperandDescriptor();

  OperandDescriptor(
      ::webnn::OperandDataType data_type,
      std::vector<uint32_t> shape,
      std::vector<uint32_t> pending_permutation);


  ~OperandDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OperandDescriptorPtr>
  OperandDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OperandDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OperandDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OperandDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OperandDescriptor_UnserializedMessageContext<
            UserType, OperandDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OperandDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OperandDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OperandDescriptor_UnserializedMessageContext<
            UserType, OperandDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OperandDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandDataType data_type;
  
  std::vector<uint32_t> shape;
  
  std::vector<uint32_t> pending_permutation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OperandDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM) Operand {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Operand, T>::value>;
  using DataView = OperandDataView;
  using Data_ = internal::Operand_Data;
  using Kind = Operand_Kind;

  template <typename... Args>
  static OperandPtr New(Args&&... args) {
    return OperandPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OperandPtr From(const U& u) {
    return mojo::TypeConverter<OperandPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Operand>::Convert(*this);
  }


  Operand();

  Operand(
      Operand::Kind kind,
      const ::webnn::OperandDescriptor& descriptor,
      const std::optional<std::string>& name);


  ~Operand();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OperandPtr>
  OperandPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Operand::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Operand::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Operand::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Operand::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Operand::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Operand::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Operand_UnserializedMessageContext<
            UserType, Operand::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Operand::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Operand::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Operand_UnserializedMessageContext<
            UserType, Operand::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Operand::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Operand::Kind kind;
  
  ::webnn::OperandDescriptor descriptor;
  
  std::optional<std::string> name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Operand::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Operand::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Operand::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Operand::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ArgMinMax {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ArgMinMax, T>::value>;
  using DataView = ArgMinMaxDataView;
  using Data_ = internal::ArgMinMax_Data;
  using Kind = ArgMinMax_Kind;

  template <typename... Args>
  static ArgMinMaxPtr New(Args&&... args) {
    return ArgMinMaxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ArgMinMaxPtr From(const U& u) {
    return mojo::TypeConverter<ArgMinMaxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ArgMinMax>::Convert(*this);
  }


  ArgMinMax();

  ArgMinMax(
      ArgMinMax::Kind kind,
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      bool keep_dimensions,
      const std::string& label);


  ~ArgMinMax();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ArgMinMaxPtr>
  ArgMinMaxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ArgMinMax::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ArgMinMax::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ArgMinMax::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ArgMinMax_UnserializedMessageContext<
            UserType, ArgMinMax::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ArgMinMax::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ArgMinMax::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ArgMinMax_UnserializedMessageContext<
            UserType, ArgMinMax::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ArgMinMax::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ArgMinMax::Kind kind;
  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  bool keep_dimensions;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ArgMinMax::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) BatchNormalization {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatchNormalization, T>::value>;
  using DataView = BatchNormalizationDataView;
  using Data_ = internal::BatchNormalization_Data;

  template <typename... Args>
  static BatchNormalizationPtr New(Args&&... args) {
    return BatchNormalizationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatchNormalizationPtr From(const U& u) {
    return mojo::TypeConverter<BatchNormalizationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatchNormalization>::Convert(*this);
  }


  BatchNormalization();

  BatchNormalization(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& mean_operand_id,
      const ::webnn::OperandId& variance_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::optional<::webnn::OperandId>& scale_operand_id,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      uint32_t axis,
      float epsilon,
      const std::string& label);


  ~BatchNormalization();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatchNormalizationPtr>
  BatchNormalizationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchNormalization::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchNormalization::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatchNormalization::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatchNormalization_UnserializedMessageContext<
            UserType, BatchNormalization::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatchNormalization::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatchNormalization::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatchNormalization_UnserializedMessageContext<
            UserType, BatchNormalization::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatchNormalization::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId mean_operand_id;
  
  ::webnn::OperandId variance_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::optional<::webnn::OperandId> scale_operand_id;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  uint32_t axis;
  
  float epsilon;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatchNormalization::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Clamp {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Clamp, T>::value>;
  using DataView = ClampDataView;
  using Data_ = internal::Clamp_Data;

  template <typename... Args>
  static ClampPtr New(Args&&... args) {
    return ClampPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClampPtr From(const U& u) {
    return mojo::TypeConverter<ClampPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Clamp>::Convert(*this);
  }


  Clamp();

  Clamp(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const ::webnn::MLNumber& min_value,
      const ::webnn::MLNumber& max_value,
      const std::string& label);


  ~Clamp();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClampPtr>
  ClampPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Clamp::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Clamp::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Clamp::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Clamp::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Clamp::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Clamp::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Clamp_UnserializedMessageContext<
            UserType, Clamp::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Clamp::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Clamp::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Clamp_UnserializedMessageContext<
            UserType, Clamp::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Clamp::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  ::webnn::MLNumber min_value;
  
  ::webnn::MLNumber max_value;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Clamp::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Clamp::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Clamp::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Clamp::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Concat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Concat, T>::value>;
  using DataView = ConcatDataView;
  using Data_ = internal::Concat_Data;

  template <typename... Args>
  static ConcatPtr New(Args&&... args) {
    return ConcatPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConcatPtr From(const U& u) {
    return mojo::TypeConverter<ConcatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Concat>::Convert(*this);
  }


  Concat();

  Concat(
      std::vector<::webnn::OperandId> input_operand_ids,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      const std::string& label);


  ~Concat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConcatPtr>
  ConcatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Concat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Concat::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Concat::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Concat::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Concat::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Concat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Concat_UnserializedMessageContext<
            UserType, Concat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Concat::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Concat::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Concat_UnserializedMessageContext<
            UserType, Concat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Concat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::webnn::OperandId> input_operand_ids;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Concat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Concat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Concat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Concat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM) Padding2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Padding2d, T>::value>;
  using DataView = Padding2dDataView;
  using Data_ = internal::Padding2d_Data;

  template <typename... Args>
  static Padding2dPtr New(Args&&... args) {
    return Padding2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Padding2dPtr From(const U& u) {
    return mojo::TypeConverter<Padding2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Padding2d>::Convert(*this);
  }


  Padding2d();

  Padding2d(
      Size2dPtr beginning,
      Size2dPtr ending);

Padding2d(const Padding2d&) = delete;
Padding2d& operator=(const Padding2d&) = delete;

  ~Padding2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Padding2dPtr>
  Padding2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Padding2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Padding2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Padding2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Padding2d_UnserializedMessageContext<
            UserType, Padding2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Padding2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Padding2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Padding2d_UnserializedMessageContext<
            UserType, Padding2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Padding2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Size2dPtr beginning;
  
  Size2dPtr ending;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Padding2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Conv2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Conv2d, T>::value>;
  using DataView = Conv2dDataView;
  using Data_ = internal::Conv2d_Data;
  using Kind = Conv2d_Kind;

  template <typename... Args>
  static Conv2dPtr New(Args&&... args) {
    return Conv2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Conv2dPtr From(const U& u) {
    return mojo::TypeConverter<Conv2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Conv2d>::Convert(*this);
  }


  Conv2d();

  Conv2d(
      Conv2d::Kind kind,
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& filter_operand_id,
      const ::webnn::OperandId& output_operand_id,
      Padding2dPtr padding,
      Size2dPtr strides,
      Size2dPtr dilations,
      uint32_t groups,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      const std::string& label);

Conv2d(const Conv2d&) = delete;
Conv2d& operator=(const Conv2d&) = delete;

  ~Conv2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Conv2dPtr>
  Conv2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Conv2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Conv2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Conv2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Conv2d_UnserializedMessageContext<
            UserType, Conv2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Conv2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Conv2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Conv2d_UnserializedMessageContext<
            UserType, Conv2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Conv2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Conv2d::Kind kind;
  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId filter_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  Padding2dPtr padding;
  
  Size2dPtr strides;
  
  Size2dPtr dilations;
  
  uint32_t groups;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Conv2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) CumulativeSum {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CumulativeSum, T>::value>;
  using DataView = CumulativeSumDataView;
  using Data_ = internal::CumulativeSum_Data;

  template <typename... Args>
  static CumulativeSumPtr New(Args&&... args) {
    return CumulativeSumPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CumulativeSumPtr From(const U& u) {
    return mojo::TypeConverter<CumulativeSumPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CumulativeSum>::Convert(*this);
  }


  CumulativeSum();

  CumulativeSum(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      bool exclusive,
      bool reversed,
      const std::string& label);


  ~CumulativeSum();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CumulativeSumPtr>
  CumulativeSumPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CumulativeSum::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CumulativeSum::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CumulativeSum::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CumulativeSum_UnserializedMessageContext<
            UserType, CumulativeSum::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CumulativeSum::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CumulativeSum::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CumulativeSum_UnserializedMessageContext<
            UserType, CumulativeSum::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CumulativeSum::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  bool exclusive;
  
  bool reversed;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CumulativeSum::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) DequantizeLinear {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DequantizeLinear, T>::value>;
  using DataView = DequantizeLinearDataView;
  using Data_ = internal::DequantizeLinear_Data;

  template <typename... Args>
  static DequantizeLinearPtr New(Args&&... args) {
    return DequantizeLinearPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DequantizeLinearPtr From(const U& u) {
    return mojo::TypeConverter<DequantizeLinearPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DequantizeLinear>::Convert(*this);
  }


  DequantizeLinear();

  DequantizeLinear(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& scale_operand_id,
      const ::webnn::OperandId& zero_point_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~DequantizeLinear();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DequantizeLinearPtr>
  DequantizeLinearPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DequantizeLinear::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DequantizeLinear::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DequantizeLinear::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DequantizeLinear_UnserializedMessageContext<
            UserType, DequantizeLinear::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DequantizeLinear::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DequantizeLinear::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DequantizeLinear_UnserializedMessageContext<
            UserType, DequantizeLinear::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DequantizeLinear::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId scale_operand_id;
  
  ::webnn::OperandId zero_point_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DequantizeLinear::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ElementWiseBinary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ElementWiseBinary, T>::value>;
  using DataView = ElementWiseBinaryDataView;
  using Data_ = internal::ElementWiseBinary_Data;
  using Kind = ElementWiseBinary_Kind;

  template <typename... Args>
  static ElementWiseBinaryPtr New(Args&&... args) {
    return ElementWiseBinaryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ElementWiseBinaryPtr From(const U& u) {
    return mojo::TypeConverter<ElementWiseBinaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ElementWiseBinary>::Convert(*this);
  }


  ElementWiseBinary();

  ElementWiseBinary(
      ElementWiseBinary::Kind kind,
      const ::webnn::OperandId& lhs_operand_id,
      const ::webnn::OperandId& rhs_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~ElementWiseBinary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ElementWiseBinaryPtr>
  ElementWiseBinaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ElementWiseBinary::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ElementWiseBinary::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ElementWiseBinary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ElementWiseBinary_UnserializedMessageContext<
            UserType, ElementWiseBinary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ElementWiseBinary::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ElementWiseBinary::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ElementWiseBinary_UnserializedMessageContext<
            UserType, ElementWiseBinary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ElementWiseBinary::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ElementWiseBinary::Kind kind;
  
  ::webnn::OperandId lhs_operand_id;
  
  ::webnn::OperandId rhs_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ElementWiseBinary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ElementWiseUnary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ElementWiseUnary, T>::value>;
  using DataView = ElementWiseUnaryDataView;
  using Data_ = internal::ElementWiseUnary_Data;
  using Kind = ElementWiseUnary_Kind;

  template <typename... Args>
  static ElementWiseUnaryPtr New(Args&&... args) {
    return ElementWiseUnaryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ElementWiseUnaryPtr From(const U& u) {
    return mojo::TypeConverter<ElementWiseUnaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ElementWiseUnary>::Convert(*this);
  }


  ElementWiseUnary();

  ElementWiseUnary(
      ElementWiseUnary::Kind kind,
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~ElementWiseUnary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ElementWiseUnaryPtr>
  ElementWiseUnaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ElementWiseUnary::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ElementWiseUnary::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ElementWiseUnary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ElementWiseUnary_UnserializedMessageContext<
            UserType, ElementWiseUnary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ElementWiseUnary::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ElementWiseUnary::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ElementWiseUnary_UnserializedMessageContext<
            UserType, ElementWiseUnary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ElementWiseUnary::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ElementWiseUnary::Kind kind;
  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ElementWiseUnary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Expand {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Expand, T>::value>;
  using DataView = ExpandDataView;
  using Data_ = internal::Expand_Data;

  template <typename... Args>
  static ExpandPtr New(Args&&... args) {
    return ExpandPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExpandPtr From(const U& u) {
    return mojo::TypeConverter<ExpandPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Expand>::Convert(*this);
  }


  Expand();

  Expand(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Expand();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExpandPtr>
  ExpandPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Expand::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Expand::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Expand::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Expand::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Expand::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Expand::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Expand_UnserializedMessageContext<
            UserType, Expand::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Expand::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Expand::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Expand_UnserializedMessageContext<
            UserType, Expand::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Expand::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Expand::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Expand::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Expand::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Expand::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ConstantPadding {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConstantPadding, T>::value>;
  using DataView = ConstantPaddingDataView;
  using Data_ = internal::ConstantPadding_Data;

  template <typename... Args>
  static ConstantPaddingPtr New(Args&&... args) {
    return ConstantPaddingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConstantPaddingPtr From(const U& u) {
    return mojo::TypeConverter<ConstantPaddingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConstantPadding>::Convert(*this);
  }


  ConstantPadding();

  explicit ConstantPadding(
      const ::webnn::MLNumber& value);


  ~ConstantPadding();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConstantPaddingPtr>
  ConstantPaddingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConstantPadding::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConstantPadding::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConstantPadding::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConstantPadding_UnserializedMessageContext<
            UserType, ConstantPadding::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConstantPadding::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConstantPadding::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConstantPadding_UnserializedMessageContext<
            UserType, ConstantPadding::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConstantPadding::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::MLNumber value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConstantPadding::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(WEBNN_MOJOM) InstanceNormalization {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InstanceNormalization, T>::value>;
  using DataView = InstanceNormalizationDataView;
  using Data_ = internal::InstanceNormalization_Data;

  template <typename... Args>
  static InstanceNormalizationPtr New(Args&&... args) {
    return InstanceNormalizationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InstanceNormalizationPtr From(const U& u) {
    return mojo::TypeConverter<InstanceNormalizationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InstanceNormalization>::Convert(*this);
  }


  InstanceNormalization();

  InstanceNormalization(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::optional<::webnn::OperandId>& scale_operand_id,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      float epsilon,
      const std::string& label);


  ~InstanceNormalization();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InstanceNormalizationPtr>
  InstanceNormalizationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstanceNormalization::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InstanceNormalization::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InstanceNormalization::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InstanceNormalization_UnserializedMessageContext<
            UserType, InstanceNormalization::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InstanceNormalization::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InstanceNormalization::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InstanceNormalization_UnserializedMessageContext<
            UserType, InstanceNormalization::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InstanceNormalization::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::optional<::webnn::OperandId> scale_operand_id;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  float epsilon;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InstanceNormalization::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Matmul {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Matmul, T>::value>;
  using DataView = MatmulDataView;
  using Data_ = internal::Matmul_Data;

  template <typename... Args>
  static MatmulPtr New(Args&&... args) {
    return MatmulPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MatmulPtr From(const U& u) {
    return mojo::TypeConverter<MatmulPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Matmul>::Convert(*this);
  }


  Matmul();

  Matmul(
      const ::webnn::OperandId& a_operand_id,
      const ::webnn::OperandId& b_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Matmul();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MatmulPtr>
  MatmulPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Matmul::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Matmul::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Matmul::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Matmul::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Matmul::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Matmul::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Matmul_UnserializedMessageContext<
            UserType, Matmul::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Matmul::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Matmul::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Matmul_UnserializedMessageContext<
            UserType, Matmul::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Matmul::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId a_operand_id;
  
  ::webnn::OperandId b_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Matmul::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Matmul::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Matmul::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Matmul::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Pad {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Pad, T>::value>;
  using DataView = PadDataView;
  using Data_ = internal::Pad_Data;

  template <typename... Args>
  static PadPtr New(Args&&... args) {
    return PadPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PadPtr From(const U& u) {
    return mojo::TypeConverter<PadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Pad>::Convert(*this);
  }


  Pad();

  Pad(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<uint32_t> beginning_padding,
      std::vector<uint32_t> ending_padding,
      PaddingModePtr mode,
      const std::string& label);

Pad(const Pad&) = delete;
Pad& operator=(const Pad&) = delete;

  ~Pad();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PadPtr>
  PadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Pad::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Pad::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Pad::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pad::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pad::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Pad::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Pad_UnserializedMessageContext<
            UserType, Pad::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Pad::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Pad::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Pad_UnserializedMessageContext<
            UserType, Pad::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Pad::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<uint32_t> beginning_padding;
  
  std::vector<uint32_t> ending_padding;
  
  PaddingModePtr mode;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Pad::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Pad::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Pad::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Pad::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Reduce {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Reduce, T>::value>;
  using DataView = ReduceDataView;
  using Data_ = internal::Reduce_Data;
  using Kind = Reduce_Kind;

  template <typename... Args>
  static ReducePtr New(Args&&... args) {
    return ReducePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReducePtr From(const U& u) {
    return mojo::TypeConverter<ReducePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Reduce>::Convert(*this);
  }


  Reduce();

  Reduce(
      Reduce::Kind kind,
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<uint32_t> axes,
      bool keep_dimensions,
      const std::string& label);


  ~Reduce();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReducePtr>
  ReducePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Reduce::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Reduce::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Reduce::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reduce::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reduce::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Reduce::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Reduce_UnserializedMessageContext<
            UserType, Reduce::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Reduce::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Reduce::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Reduce_UnserializedMessageContext<
            UserType, Reduce::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Reduce::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Reduce::Kind kind;
  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<uint32_t> axes;
  
  bool keep_dimensions;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Reduce::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Reduce::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Reduce::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Reduce::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Pool2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Pool2d, T>::value>;
  using DataView = Pool2dDataView;
  using Data_ = internal::Pool2d_Data;
  using Kind = Pool2d_Kind;

  template <typename... Args>
  static Pool2dPtr New(Args&&... args) {
    return Pool2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Pool2dPtr From(const U& u) {
    return mojo::TypeConverter<Pool2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Pool2d>::Convert(*this);
  }


  Pool2d();

  Pool2d(
      Pool2d::Kind kind,
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      Size2dPtr window_dimensions,
      Padding2dPtr padding,
      Size2dPtr strides,
      Size2dPtr dilations,
      const std::string& label);

Pool2d(const Pool2d&) = delete;
Pool2d& operator=(const Pool2d&) = delete;

  ~Pool2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Pool2dPtr>
  Pool2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pool2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pool2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Pool2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Pool2d_UnserializedMessageContext<
            UserType, Pool2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Pool2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Pool2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Pool2d_UnserializedMessageContext<
            UserType, Pool2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Pool2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Pool2d::Kind kind;
  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  Size2dPtr window_dimensions;
  
  Padding2dPtr padding;
  
  Size2dPtr strides;
  
  Size2dPtr dilations;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Pool2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM) Slice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Slice, T>::value>;
  using DataView = SliceDataView;
  using Data_ = internal::Slice_Data;

  template <typename... Args>
  static SlicePtr New(Args&&... args) {
    return SlicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SlicePtr From(const U& u) {
    return mojo::TypeConverter<SlicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Slice>::Convert(*this);
  }


  Slice();

  Slice(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<::webnn::Range> ranges,
      const std::string& label);


  ~Slice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SlicePtr>
  SlicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Slice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Slice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Slice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Slice::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Slice::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Slice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Slice_UnserializedMessageContext<
            UserType, Slice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Slice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Slice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Slice_UnserializedMessageContext<
            UserType, Slice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Slice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<::webnn::Range> ranges;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Slice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Slice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Slice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Slice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Elu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Elu, T>::value>;
  using DataView = EluDataView;
  using Data_ = internal::Elu_Data;

  template <typename... Args>
  static EluPtr New(Args&&... args) {
    return EluPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EluPtr From(const U& u) {
    return mojo::TypeConverter<EluPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Elu>::Convert(*this);
  }


  Elu();

  Elu(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      float alpha,
      const std::string& label);


  ~Elu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EluPtr>
  EluPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Elu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Elu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Elu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Elu::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Elu::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Elu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Elu_UnserializedMessageContext<
            UserType, Elu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Elu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Elu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Elu_UnserializedMessageContext<
            UserType, Elu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Elu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  float alpha;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Elu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Elu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Elu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Elu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Gather {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Gather, T>::value>;
  using DataView = GatherDataView;
  using Data_ = internal::Gather_Data;

  template <typename... Args>
  static GatherPtr New(Args&&... args) {
    return GatherPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GatherPtr From(const U& u) {
    return mojo::TypeConverter<GatherPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Gather>::Convert(*this);
  }


  Gather();

  Gather(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& indices_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      const std::string& label);


  ~Gather();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GatherPtr>
  GatherPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Gather::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Gather::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Gather::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gather::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gather::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Gather::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Gather_UnserializedMessageContext<
            UserType, Gather::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Gather::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Gather::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Gather_UnserializedMessageContext<
            UserType, Gather::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Gather::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId indices_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Gather::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Gather::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Gather::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Gather::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) GatherElements {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GatherElements, T>::value>;
  using DataView = GatherElementsDataView;
  using Data_ = internal::GatherElements_Data;

  template <typename... Args>
  static GatherElementsPtr New(Args&&... args) {
    return GatherElementsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GatherElementsPtr From(const U& u) {
    return mojo::TypeConverter<GatherElementsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GatherElements>::Convert(*this);
  }


  GatherElements();

  GatherElements(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& indices_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      const std::string& label);


  ~GatherElements();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GatherElementsPtr>
  GatherElementsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GatherElements::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GatherElements::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GatherElements::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GatherElements_UnserializedMessageContext<
            UserType, GatherElements::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GatherElements::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GatherElements::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GatherElements_UnserializedMessageContext<
            UserType, GatherElements::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GatherElements::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId indices_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GatherElements::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) GatherND {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GatherND, T>::value>;
  using DataView = GatherNDDataView;
  using Data_ = internal::GatherND_Data;

  template <typename... Args>
  static GatherNDPtr New(Args&&... args) {
    return GatherNDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GatherNDPtr From(const U& u) {
    return mojo::TypeConverter<GatherNDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GatherND>::Convert(*this);
  }


  GatherND();

  GatherND(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& indices_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~GatherND();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GatherNDPtr>
  GatherNDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GatherND::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GatherND::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GatherND::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GatherND::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GatherND::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GatherND::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GatherND_UnserializedMessageContext<
            UserType, GatherND::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GatherND::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GatherND::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GatherND_UnserializedMessageContext<
            UserType, GatherND::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GatherND::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId indices_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GatherND::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GatherND::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GatherND::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GatherND::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Gelu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Gelu, T>::value>;
  using DataView = GeluDataView;
  using Data_ = internal::Gelu_Data;

  template <typename... Args>
  static GeluPtr New(Args&&... args) {
    return GeluPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeluPtr From(const U& u) {
    return mojo::TypeConverter<GeluPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Gelu>::Convert(*this);
  }


  Gelu();

  Gelu(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Gelu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeluPtr>
  GeluPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Gelu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Gelu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Gelu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gelu::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gelu::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Gelu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Gelu_UnserializedMessageContext<
            UserType, Gelu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Gelu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Gelu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Gelu_UnserializedMessageContext<
            UserType, Gelu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Gelu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Gelu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Gelu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Gelu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Gelu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Gru {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Gru, T>::value>;
  using DataView = GruDataView;
  using Data_ = internal::Gru_Data;

  template <typename... Args>
  static GruPtr New(Args&&... args) {
    return GruPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GruPtr From(const U& u) {
    return mojo::TypeConverter<GruPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Gru>::Convert(*this);
  }


  Gru();

  Gru(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& weight_operand_id,
      const ::webnn::OperandId& recurrent_weight_operand_id,
      uint32_t steps,
      uint32_t hidden_size,
      std::vector<::webnn::OperandId> output_operand_ids,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      const std::optional<::webnn::OperandId>& recurrent_bias_operand_id,
      const std::optional<::webnn::OperandId>& initial_hidden_state_operand_id,
      bool reset_after,
      bool return_sequence,
      RecurrentNetworkDirection direction,
      GruWeightLayout layout,
      std::vector<RecurrentNetworkActivation> activations,
      const std::string& label);


  ~Gru();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GruPtr>
  GruPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Gru::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Gru::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Gru::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gru::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gru::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Gru::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Gru_UnserializedMessageContext<
            UserType, Gru::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Gru::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Gru::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Gru_UnserializedMessageContext<
            UserType, Gru::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Gru::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId weight_operand_id;
  
  ::webnn::OperandId recurrent_weight_operand_id;
  
  uint32_t steps;
  
  uint32_t hidden_size;
  
  std::vector<::webnn::OperandId> output_operand_ids;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::optional<::webnn::OperandId> recurrent_bias_operand_id;
  
  std::optional<::webnn::OperandId> initial_hidden_state_operand_id;
  
  bool reset_after;
  
  bool return_sequence;
  
  RecurrentNetworkDirection direction;
  
  GruWeightLayout layout;
  
  std::vector<RecurrentNetworkActivation> activations;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Gru::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Gru::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Gru::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Gru::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) GruCell {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GruCell, T>::value>;
  using DataView = GruCellDataView;
  using Data_ = internal::GruCell_Data;

  template <typename... Args>
  static GruCellPtr New(Args&&... args) {
    return GruCellPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GruCellPtr From(const U& u) {
    return mojo::TypeConverter<GruCellPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GruCell>::Convert(*this);
  }


  GruCell();

  GruCell(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& weight_operand_id,
      const ::webnn::OperandId& recurrent_weight_operand_id,
      const ::webnn::OperandId& hidden_state_operand_id,
      uint32_t hidden_size,
      const ::webnn::OperandId& output_operand_id,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      const std::optional<::webnn::OperandId>& recurrent_bias_operand_id,
      bool reset_after,
      GruWeightLayout layout,
      std::vector<RecurrentNetworkActivation> activations,
      const std::string& label);


  ~GruCell();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GruCellPtr>
  GruCellPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GruCell::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GruCell::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GruCell::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GruCell::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GruCell::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GruCell::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GruCell_UnserializedMessageContext<
            UserType, GruCell::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GruCell::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GruCell::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GruCell_UnserializedMessageContext<
            UserType, GruCell::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GruCell::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId weight_operand_id;
  
  ::webnn::OperandId recurrent_weight_operand_id;
  
  ::webnn::OperandId hidden_state_operand_id;
  
  uint32_t hidden_size;
  
  ::webnn::OperandId output_operand_id;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::optional<::webnn::OperandId> recurrent_bias_operand_id;
  
  bool reset_after;
  
  GruWeightLayout layout;
  
  std::vector<RecurrentNetworkActivation> activations;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GruCell::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GruCell::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GruCell::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GruCell::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Gemm {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Gemm, T>::value>;
  using DataView = GemmDataView;
  using Data_ = internal::Gemm_Data;

  template <typename... Args>
  static GemmPtr New(Args&&... args) {
    return GemmPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GemmPtr From(const U& u) {
    return mojo::TypeConverter<GemmPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Gemm>::Convert(*this);
  }


  Gemm();

  Gemm(
      const ::webnn::OperandId& a_operand_id,
      const ::webnn::OperandId& b_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::optional<::webnn::OperandId>& c_operand_id,
      float alpha,
      float beta,
      bool a_transpose,
      bool b_transpose,
      const std::string& label);


  ~Gemm();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GemmPtr>
  GemmPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Gemm::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Gemm::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Gemm::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gemm::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Gemm::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Gemm::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Gemm_UnserializedMessageContext<
            UserType, Gemm::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Gemm::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Gemm::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Gemm_UnserializedMessageContext<
            UserType, Gemm::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Gemm::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId a_operand_id;
  
  ::webnn::OperandId b_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::optional<::webnn::OperandId> c_operand_id;
  
  float alpha;
  
  float beta;
  
  bool a_transpose;
  
  bool b_transpose;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Gemm::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Gemm::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Gemm::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Gemm::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) HardSigmoid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HardSigmoid, T>::value>;
  using DataView = HardSigmoidDataView;
  using Data_ = internal::HardSigmoid_Data;

  template <typename... Args>
  static HardSigmoidPtr New(Args&&... args) {
    return HardSigmoidPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HardSigmoidPtr From(const U& u) {
    return mojo::TypeConverter<HardSigmoidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HardSigmoid>::Convert(*this);
  }


  HardSigmoid();

  HardSigmoid(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      float alpha,
      float beta,
      const std::string& label);


  ~HardSigmoid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HardSigmoidPtr>
  HardSigmoidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HardSigmoid::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HardSigmoid::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HardSigmoid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HardSigmoid_UnserializedMessageContext<
            UserType, HardSigmoid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HardSigmoid::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HardSigmoid::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HardSigmoid_UnserializedMessageContext<
            UserType, HardSigmoid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HardSigmoid::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  float alpha;
  
  float beta;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HardSigmoid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) HardSwish {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HardSwish, T>::value>;
  using DataView = HardSwishDataView;
  using Data_ = internal::HardSwish_Data;

  template <typename... Args>
  static HardSwishPtr New(Args&&... args) {
    return HardSwishPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HardSwishPtr From(const U& u) {
    return mojo::TypeConverter<HardSwishPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HardSwish>::Convert(*this);
  }


  HardSwish();

  HardSwish(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~HardSwish();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HardSwishPtr>
  HardSwishPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HardSwish::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HardSwish::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HardSwish::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HardSwish_UnserializedMessageContext<
            UserType, HardSwish::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HardSwish::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HardSwish::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HardSwish_UnserializedMessageContext<
            UserType, HardSwish::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HardSwish::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HardSwish::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) LayerNormalization {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerNormalization, T>::value>;
  using DataView = LayerNormalizationDataView;
  using Data_ = internal::LayerNormalization_Data;

  template <typename... Args>
  static LayerNormalizationPtr New(Args&&... args) {
    return LayerNormalizationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerNormalizationPtr From(const U& u) {
    return mojo::TypeConverter<LayerNormalizationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerNormalization>::Convert(*this);
  }


  LayerNormalization();

  LayerNormalization(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::optional<::webnn::OperandId>& scale_operand_id,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      std::vector<uint32_t> axes,
      float epsilon,
      const std::string& label);


  ~LayerNormalization();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerNormalizationPtr>
  LayerNormalizationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerNormalization::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerNormalization::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerNormalization::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerNormalization_UnserializedMessageContext<
            UserType, LayerNormalization::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerNormalization::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerNormalization::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerNormalization_UnserializedMessageContext<
            UserType, LayerNormalization::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerNormalization::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::optional<::webnn::OperandId> scale_operand_id;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::vector<uint32_t> axes;
  
  float epsilon;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerNormalization::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) LeakyRelu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LeakyRelu, T>::value>;
  using DataView = LeakyReluDataView;
  using Data_ = internal::LeakyRelu_Data;

  template <typename... Args>
  static LeakyReluPtr New(Args&&... args) {
    return LeakyReluPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LeakyReluPtr From(const U& u) {
    return mojo::TypeConverter<LeakyReluPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LeakyRelu>::Convert(*this);
  }


  LeakyRelu();

  LeakyRelu(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      float alpha,
      const std::string& label);


  ~LeakyRelu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LeakyReluPtr>
  LeakyReluPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LeakyRelu::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LeakyRelu::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LeakyRelu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LeakyRelu_UnserializedMessageContext<
            UserType, LeakyRelu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LeakyRelu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LeakyRelu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LeakyRelu_UnserializedMessageContext<
            UserType, LeakyRelu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LeakyRelu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  float alpha;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LeakyRelu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Linear {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Linear, T>::value>;
  using DataView = LinearDataView;
  using Data_ = internal::Linear_Data;

  template <typename... Args>
  static LinearPtr New(Args&&... args) {
    return LinearPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LinearPtr From(const U& u) {
    return mojo::TypeConverter<LinearPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Linear>::Convert(*this);
  }


  Linear();

  Linear(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      float alpha,
      float beta,
      const std::string& label);


  ~Linear();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LinearPtr>
  LinearPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Linear::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Linear::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Linear::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Linear::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Linear::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Linear::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Linear_UnserializedMessageContext<
            UserType, Linear::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Linear::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Linear::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Linear_UnserializedMessageContext<
            UserType, Linear::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Linear::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  float alpha;
  
  float beta;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Linear::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Linear::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Linear::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Linear::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Lstm {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Lstm, T>::value>;
  using DataView = LstmDataView;
  using Data_ = internal::Lstm_Data;

  template <typename... Args>
  static LstmPtr New(Args&&... args) {
    return LstmPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LstmPtr From(const U& u) {
    return mojo::TypeConverter<LstmPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Lstm>::Convert(*this);
  }


  Lstm();

  Lstm(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& weight_operand_id,
      const ::webnn::OperandId& recurrent_weight_operand_id,
      std::vector<::webnn::OperandId> output_operand_ids,
      uint32_t steps,
      uint32_t hidden_size,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      const std::optional<::webnn::OperandId>& recurrent_bias_operand_id,
      const std::optional<::webnn::OperandId>& peephole_weight_operand_id,
      const std::optional<::webnn::OperandId>& initial_hidden_state_operand_id,
      const std::optional<::webnn::OperandId>& initial_cell_state_operand_id,
      bool return_sequence,
      RecurrentNetworkDirection direction,
      LstmWeightLayout layout,
      std::vector<RecurrentNetworkActivation> activations,
      const std::string& label);


  ~Lstm();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LstmPtr>
  LstmPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Lstm::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Lstm::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Lstm::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Lstm::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Lstm::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Lstm::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Lstm_UnserializedMessageContext<
            UserType, Lstm::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Lstm::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Lstm::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Lstm_UnserializedMessageContext<
            UserType, Lstm::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Lstm::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId weight_operand_id;
  
  ::webnn::OperandId recurrent_weight_operand_id;
  
  std::vector<::webnn::OperandId> output_operand_ids;
  
  uint32_t steps;
  
  uint32_t hidden_size;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::optional<::webnn::OperandId> recurrent_bias_operand_id;
  
  std::optional<::webnn::OperandId> peephole_weight_operand_id;
  
  std::optional<::webnn::OperandId> initial_hidden_state_operand_id;
  
  std::optional<::webnn::OperandId> initial_cell_state_operand_id;
  
  bool return_sequence;
  
  RecurrentNetworkDirection direction;
  
  LstmWeightLayout layout;
  
  std::vector<RecurrentNetworkActivation> activations;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Lstm::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Lstm::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Lstm::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Lstm::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) LstmCell {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LstmCell, T>::value>;
  using DataView = LstmCellDataView;
  using Data_ = internal::LstmCell_Data;

  template <typename... Args>
  static LstmCellPtr New(Args&&... args) {
    return LstmCellPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LstmCellPtr From(const U& u) {
    return mojo::TypeConverter<LstmCellPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LstmCell>::Convert(*this);
  }


  LstmCell();

  LstmCell(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& weight_operand_id,
      const ::webnn::OperandId& recurrent_weight_operand_id,
      const ::webnn::OperandId& hidden_state_operand_id,
      const ::webnn::OperandId& cell_state_operand_id,
      std::vector<::webnn::OperandId> output_operand_ids,
      uint32_t hidden_size,
      const std::optional<::webnn::OperandId>& bias_operand_id,
      const std::optional<::webnn::OperandId>& recurrent_bias_operand_id,
      const std::optional<::webnn::OperandId>& peephole_weight_operand_id,
      LstmWeightLayout layout,
      std::vector<RecurrentNetworkActivation> activations,
      const std::string& label);


  ~LstmCell();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LstmCellPtr>
  LstmCellPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LstmCell::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LstmCell::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LstmCell::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LstmCell_UnserializedMessageContext<
            UserType, LstmCell::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LstmCell::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LstmCell::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LstmCell_UnserializedMessageContext<
            UserType, LstmCell::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LstmCell::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId weight_operand_id;
  
  ::webnn::OperandId recurrent_weight_operand_id;
  
  ::webnn::OperandId hidden_state_operand_id;
  
  ::webnn::OperandId cell_state_operand_id;
  
  std::vector<::webnn::OperandId> output_operand_ids;
  
  uint32_t hidden_size;
  
  std::optional<::webnn::OperandId> bias_operand_id;
  
  std::optional<::webnn::OperandId> recurrent_bias_operand_id;
  
  std::optional<::webnn::OperandId> peephole_weight_operand_id;
  
  LstmWeightLayout layout;
  
  std::vector<RecurrentNetworkActivation> activations;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LstmCell::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Prelu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Prelu, T>::value>;
  using DataView = PreluDataView;
  using Data_ = internal::Prelu_Data;

  template <typename... Args>
  static PreluPtr New(Args&&... args) {
    return PreluPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PreluPtr From(const U& u) {
    return mojo::TypeConverter<PreluPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Prelu>::Convert(*this);
  }


  Prelu();

  Prelu(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& slope_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Prelu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PreluPtr>
  PreluPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Prelu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Prelu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Prelu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Prelu::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Prelu::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Prelu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Prelu_UnserializedMessageContext<
            UserType, Prelu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Prelu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Prelu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Prelu_UnserializedMessageContext<
            UserType, Prelu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Prelu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId slope_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Prelu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Prelu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Prelu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Prelu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) QuantizeLinear {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QuantizeLinear, T>::value>;
  using DataView = QuantizeLinearDataView;
  using Data_ = internal::QuantizeLinear_Data;

  template <typename... Args>
  static QuantizeLinearPtr New(Args&&... args) {
    return QuantizeLinearPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuantizeLinearPtr From(const U& u) {
    return mojo::TypeConverter<QuantizeLinearPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QuantizeLinear>::Convert(*this);
  }


  QuantizeLinear();

  QuantizeLinear(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& scale_operand_id,
      const ::webnn::OperandId& zero_point_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~QuantizeLinear();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuantizeLinearPtr>
  QuantizeLinearPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuantizeLinear::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuantizeLinear::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QuantizeLinear::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QuantizeLinear_UnserializedMessageContext<
            UserType, QuantizeLinear::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QuantizeLinear::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QuantizeLinear::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QuantizeLinear_UnserializedMessageContext<
            UserType, QuantizeLinear::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QuantizeLinear::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId scale_operand_id;
  
  ::webnn::OperandId zero_point_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QuantizeLinear::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Relu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Relu, T>::value>;
  using DataView = ReluDataView;
  using Data_ = internal::Relu_Data;

  template <typename... Args>
  static ReluPtr New(Args&&... args) {
    return ReluPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReluPtr From(const U& u) {
    return mojo::TypeConverter<ReluPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Relu>::Convert(*this);
  }


  Relu();

  Relu(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Relu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReluPtr>
  ReluPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Relu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Relu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Relu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Relu::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Relu::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Relu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Relu_UnserializedMessageContext<
            UserType, Relu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Relu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Relu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Relu_UnserializedMessageContext<
            UserType, Relu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Relu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Relu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Relu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Relu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Relu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Reshape {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Reshape, T>::value>;
  using DataView = ReshapeDataView;
  using Data_ = internal::Reshape_Data;

  template <typename... Args>
  static ReshapePtr New(Args&&... args) {
    return ReshapePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReshapePtr From(const U& u) {
    return mojo::TypeConverter<ReshapePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Reshape>::Convert(*this);
  }


  Reshape();

  Reshape(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Reshape();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReshapePtr>
  ReshapePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Reshape::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Reshape::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Reshape::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reshape::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reshape::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Reshape::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Reshape_UnserializedMessageContext<
            UserType, Reshape::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Reshape::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Reshape::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Reshape_UnserializedMessageContext<
            UserType, Reshape::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Reshape::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Reshape::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Reshape::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Reshape::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Reshape::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Reverse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Reverse, T>::value>;
  using DataView = ReverseDataView;
  using Data_ = internal::Reverse_Data;

  template <typename... Args>
  static ReversePtr New(Args&&... args) {
    return ReversePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReversePtr From(const U& u) {
    return mojo::TypeConverter<ReversePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Reverse>::Convert(*this);
  }


  Reverse();

  Reverse(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<uint32_t> axes,
      const std::string& label);


  ~Reverse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReversePtr>
  ReversePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Reverse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Reverse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Reverse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reverse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Reverse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Reverse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Reverse_UnserializedMessageContext<
            UserType, Reverse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Reverse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Reverse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Reverse_UnserializedMessageContext<
            UserType, Reverse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Reverse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<uint32_t> axes;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Reverse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Reverse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Reverse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Reverse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ScatterElements {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScatterElements, T>::value>;
  using DataView = ScatterElementsDataView;
  using Data_ = internal::ScatterElements_Data;

  template <typename... Args>
  static ScatterElementsPtr New(Args&&... args) {
    return ScatterElementsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScatterElementsPtr From(const U& u) {
    return mojo::TypeConverter<ScatterElementsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScatterElements>::Convert(*this);
  }


  ScatterElements();

  ScatterElements(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& indices_operand_id,
      const ::webnn::OperandId& updates_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      const std::string& label);


  ~ScatterElements();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScatterElementsPtr>
  ScatterElementsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScatterElements::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScatterElements::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScatterElements::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScatterElements_UnserializedMessageContext<
            UserType, ScatterElements::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScatterElements::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScatterElements::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScatterElements_UnserializedMessageContext<
            UserType, ScatterElements::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScatterElements::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId indices_operand_id;
  
  ::webnn::OperandId updates_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScatterElements::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) ScatterND {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScatterND, T>::value>;
  using DataView = ScatterNDDataView;
  using Data_ = internal::ScatterND_Data;

  template <typename... Args>
  static ScatterNDPtr New(Args&&... args) {
    return ScatterNDPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScatterNDPtr From(const U& u) {
    return mojo::TypeConverter<ScatterNDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScatterND>::Convert(*this);
  }


  ScatterND();

  ScatterND(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& indices_operand_id,
      const ::webnn::OperandId& updates_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~ScatterND();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScatterNDPtr>
  ScatterNDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScatterND::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScatterND::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScatterND::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScatterND_UnserializedMessageContext<
            UserType, ScatterND::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScatterND::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScatterND::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScatterND_UnserializedMessageContext<
            UserType, ScatterND::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScatterND::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId indices_operand_id;
  
  ::webnn::OperandId updates_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScatterND::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Sigmoid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Sigmoid, T>::value>;
  using DataView = SigmoidDataView;
  using Data_ = internal::Sigmoid_Data;

  template <typename... Args>
  static SigmoidPtr New(Args&&... args) {
    return SigmoidPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SigmoidPtr From(const U& u) {
    return mojo::TypeConverter<SigmoidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Sigmoid>::Convert(*this);
  }


  Sigmoid();

  Sigmoid(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Sigmoid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SigmoidPtr>
  SigmoidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Sigmoid::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Sigmoid::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Sigmoid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Sigmoid_UnserializedMessageContext<
            UserType, Sigmoid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Sigmoid::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Sigmoid::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Sigmoid_UnserializedMessageContext<
            UserType, Sigmoid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Sigmoid::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Sigmoid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Softmax {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Softmax, T>::value>;
  using DataView = SoftmaxDataView;
  using Data_ = internal::Softmax_Data;

  template <typename... Args>
  static SoftmaxPtr New(Args&&... args) {
    return SoftmaxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SoftmaxPtr From(const U& u) {
    return mojo::TypeConverter<SoftmaxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Softmax>::Convert(*this);
  }


  Softmax();

  Softmax(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      uint32_t axis,
      const std::string& label);


  ~Softmax();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SoftmaxPtr>
  SoftmaxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Softmax::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Softmax::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Softmax::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softmax::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softmax::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Softmax::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Softmax_UnserializedMessageContext<
            UserType, Softmax::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Softmax::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Softmax::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Softmax_UnserializedMessageContext<
            UserType, Softmax::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Softmax::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Softmax::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Softmax::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Softmax::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Softmax::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Softplus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Softplus, T>::value>;
  using DataView = SoftplusDataView;
  using Data_ = internal::Softplus_Data;

  template <typename... Args>
  static SoftplusPtr New(Args&&... args) {
    return SoftplusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SoftplusPtr From(const U& u) {
    return mojo::TypeConverter<SoftplusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Softplus>::Convert(*this);
  }


  Softplus();

  Softplus(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Softplus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SoftplusPtr>
  SoftplusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Softplus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Softplus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Softplus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softplus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softplus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Softplus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Softplus_UnserializedMessageContext<
            UserType, Softplus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Softplus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Softplus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Softplus_UnserializedMessageContext<
            UserType, Softplus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Softplus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Softplus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Softplus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Softplus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Softplus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Softsign {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Softsign, T>::value>;
  using DataView = SoftsignDataView;
  using Data_ = internal::Softsign_Data;

  template <typename... Args>
  static SoftsignPtr New(Args&&... args) {
    return SoftsignPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SoftsignPtr From(const U& u) {
    return mojo::TypeConverter<SoftsignPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Softsign>::Convert(*this);
  }


  Softsign();

  Softsign(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Softsign();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SoftsignPtr>
  SoftsignPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Softsign::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Softsign::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Softsign::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softsign::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Softsign::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Softsign::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Softsign_UnserializedMessageContext<
            UserType, Softsign::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Softsign::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Softsign::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Softsign_UnserializedMessageContext<
            UserType, Softsign::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Softsign::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Softsign::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Softsign::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Softsign::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Softsign::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Split {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Split, T>::value>;
  using DataView = SplitDataView;
  using Data_ = internal::Split_Data;

  template <typename... Args>
  static SplitPtr New(Args&&... args) {
    return SplitPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SplitPtr From(const U& u) {
    return mojo::TypeConverter<SplitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Split>::Convert(*this);
  }


  Split();

  Split(
      const ::webnn::OperandId& input_operand_id,
      std::vector<::webnn::OperandId> output_operand_ids,
      uint32_t axis,
      const std::string& label);


  ~Split();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SplitPtr>
  SplitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Split::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Split::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Split::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Split::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Split::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Split::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Split_UnserializedMessageContext<
            UserType, Split::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Split::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Split::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Split_UnserializedMessageContext<
            UserType, Split::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Split::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  std::vector<::webnn::OperandId> output_operand_ids;
  
  uint32_t axis;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Split::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Split::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Split::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Split::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Tanh {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tanh, T>::value>;
  using DataView = TanhDataView;
  using Data_ = internal::Tanh_Data;

  template <typename... Args>
  static TanhPtr New(Args&&... args) {
    return TanhPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TanhPtr From(const U& u) {
    return mojo::TypeConverter<TanhPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tanh>::Convert(*this);
  }


  Tanh();

  Tanh(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Tanh();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TanhPtr>
  TanhPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tanh::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tanh::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tanh::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tanh::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tanh::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tanh::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tanh_UnserializedMessageContext<
            UserType, Tanh::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tanh::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tanh::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tanh_UnserializedMessageContext<
            UserType, Tanh::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tanh::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tanh::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tanh::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tanh::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tanh::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Tile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tile, T>::value>;
  using DataView = TileDataView;
  using Data_ = internal::Tile_Data;

  template <typename... Args>
  static TilePtr New(Args&&... args) {
    return TilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TilePtr From(const U& u) {
    return mojo::TypeConverter<TilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tile>::Convert(*this);
  }


  Tile();

  Tile(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<uint32_t> repetitions,
      const std::string& label);


  ~Tile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TilePtr>
  TilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tile::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tile::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tile_UnserializedMessageContext<
            UserType, Tile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tile_UnserializedMessageContext<
            UserType, Tile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<uint32_t> repetitions;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Transpose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Transpose, T>::value>;
  using DataView = TransposeDataView;
  using Data_ = internal::Transpose_Data;

  template <typename... Args>
  static TransposePtr New(Args&&... args) {
    return TransposePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransposePtr From(const U& u) {
    return mojo::TypeConverter<TransposePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Transpose>::Convert(*this);
  }


  Transpose();

  Transpose(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      std::vector<uint32_t> permutation,
      const std::string& label);


  ~Transpose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransposePtr>
  TransposePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Transpose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Transpose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Transpose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transpose::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transpose::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Transpose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Transpose_UnserializedMessageContext<
            UserType, Transpose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Transpose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Transpose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Transpose_UnserializedMessageContext<
            UserType, Transpose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Transpose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::vector<uint32_t> permutation;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Transpose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Transpose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Transpose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Transpose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Triangular {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Triangular, T>::value>;
  using DataView = TriangularDataView;
  using Data_ = internal::Triangular_Data;

  template <typename... Args>
  static TriangularPtr New(Args&&... args) {
    return TriangularPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TriangularPtr From(const U& u) {
    return mojo::TypeConverter<TriangularPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Triangular>::Convert(*this);
  }


  Triangular();

  Triangular(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      bool upper,
      int32_t diagonal,
      const std::string& label);


  ~Triangular();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TriangularPtr>
  TriangularPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Triangular::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Triangular::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Triangular::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Triangular::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Triangular::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Triangular::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Triangular_UnserializedMessageContext<
            UserType, Triangular::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Triangular::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Triangular::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Triangular_UnserializedMessageContext<
            UserType, Triangular::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Triangular::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  bool upper;
  
  int32_t diagonal;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Triangular::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Triangular::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Triangular::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Triangular::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Resample2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Resample2d, T>::value>;
  using DataView = Resample2dDataView;
  using Data_ = internal::Resample2d_Data;
  using InterpolationMode = Resample2d_InterpolationMode;

  template <typename... Args>
  static Resample2dPtr New(Args&&... args) {
    return Resample2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Resample2dPtr From(const U& u) {
    return mojo::TypeConverter<Resample2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Resample2d>::Convert(*this);
  }


  Resample2d();

  Resample2d(
      const ::webnn::OperandId& input_operand_id,
      const ::webnn::OperandId& output_operand_id,
      Resample2d::InterpolationMode mode,
      std::optional<std::vector<float>> scales,
      std::vector<uint32_t> axes,
      const std::string& label);


  ~Resample2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Resample2dPtr>
  Resample2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Resample2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Resample2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Resample2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Resample2d_UnserializedMessageContext<
            UserType, Resample2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Resample2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Resample2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Resample2d_UnserializedMessageContext<
            UserType, Resample2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Resample2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId input_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  Resample2d::InterpolationMode mode;
  
  std::optional<std::vector<float>> scales;
  
  std::vector<uint32_t> axes;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Resample2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) Where {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Where, T>::value>;
  using DataView = WhereDataView;
  using Data_ = internal::Where_Data;

  template <typename... Args>
  static WherePtr New(Args&&... args) {
    return WherePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WherePtr From(const U& u) {
    return mojo::TypeConverter<WherePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Where>::Convert(*this);
  }


  Where();

  Where(
      const ::webnn::OperandId& condition_operand_id,
      const ::webnn::OperandId& true_value_operand_id,
      const ::webnn::OperandId& false_value_operand_id,
      const ::webnn::OperandId& output_operand_id,
      const std::string& label);


  ~Where();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WherePtr>
  WherePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Where::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Where::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Where::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Where::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Where::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Where::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Where_UnserializedMessageContext<
            UserType, Where::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Where::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Where::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Where_UnserializedMessageContext<
            UserType, Where::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Where::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::OperandId condition_operand_id;
  
  ::webnn::OperandId true_value_operand_id;
  
  ::webnn::OperandId false_value_operand_id;
  
  ::webnn::OperandId output_operand_id;
  
  std::string label;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Where::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Where::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Where::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Where::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(WEBNN_MOJOM) GraphInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GraphInfo, T>::value>;
  using DataView = GraphInfoDataView;
  using Data_ = internal::GraphInfo_Data;

  template <typename... Args>
  static GraphInfoPtr New(Args&&... args) {
    return GraphInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GraphInfoPtr From(const U& u) {
    return mojo::TypeConverter<GraphInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GraphInfo>::Convert(*this);
  }


  GraphInfo();

  GraphInfo(
      std::vector<OperandPtr> operands,
      std::vector<::webnn::OperandId> input_operands,
      std::vector<::webnn::OperandId> output_operands,
      std::vector<OperationPtr> operations,
      const base::flat_map<::webnn::OperandId, ::blink::WebNNPendingConstantToken>& constant_operand_ids_to_handles,
      const base::flat_map<::webnn::OperandId, ::blink::WebNNTensorToken>& id_to_constant_tensor_operand_map);

GraphInfo(const GraphInfo&) = delete;
GraphInfo& operator=(const GraphInfo&) = delete;

  ~GraphInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GraphInfoPtr>
  GraphInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GraphInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GraphInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GraphInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GraphInfo_UnserializedMessageContext<
            UserType, GraphInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GraphInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GraphInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GraphInfo_UnserializedMessageContext<
            UserType, GraphInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GraphInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<OperandPtr> operands;
  
  std::vector<::webnn::OperandId> input_operands;
  
  std::vector<::webnn::OperandId> output_operands;
  
  std::vector<OperationPtr> operations;
  
  base::flat_map<::webnn::OperandId, ::blink::WebNNPendingConstantToken> constant_operand_ids_to_handles;
  
  base::flat_map<::webnn::OperandId, ::blink::WebNNTensorToken> id_to_constant_tensor_operand_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GraphInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
NumberPtr Number::Clone() const {
  switch (tag_) {
    case Tag::kFloatingPoint:
      return NewFloatingPoint(
          mojo::Clone(data_.floating_point));
    case Tag::kSignedInteger:
      return NewSignedInteger(
          mojo::Clone(data_.signed_integer));
    case Tag::kUnsignedInteger:
      return NewUnsignedInteger(
          mojo::Clone(data_.unsigned_integer));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Number>::value>::type*>
bool Number::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFloatingPoint:
      return mojo::Equals(data_.floating_point, other.data_.floating_point);
    case Tag::kSignedInteger:
      return mojo::Equals(data_.signed_integer, other.data_.signed_integer);
    case Tag::kUnsignedInteger:
      return mojo::Equals(data_.unsigned_integer, other.data_.unsigned_integer);
  }

  return false;
}
template <typename UnionPtrType>
PaddingModePtr PaddingMode::Clone() const {
  switch (tag_) {
    case Tag::kConstant:
      return NewConstant(
          mojo::Clone(data_.constant));
    case Tag::kEdge:
      return NewEdge(
          mojo::Clone(data_.edge));
    case Tag::kReflection:
      return NewReflection(
          mojo::Clone(data_.reflection));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PaddingMode>::value>::type*>
bool PaddingMode::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kConstant:
      return mojo::Equals(data_.constant, other.data_.constant);
    case Tag::kEdge:
      return mojo::Equals(data_.edge, other.data_.edge);
    case Tag::kReflection:
      return mojo::Equals(data_.reflection, other.data_.reflection);
  }

  return false;
}
template <typename UnionPtrType>
OperationPtr Operation::Clone() const {
  switch (tag_) {
    case Tag::kArgMinMax:
      return NewArgMinMax(
          mojo::Clone(data_.arg_min_max));
    case Tag::kBatchNormalization:
      return NewBatchNormalization(
          mojo::Clone(data_.batch_normalization));
    case Tag::kClamp:
      return NewClamp(
          mojo::Clone(data_.clamp));
    case Tag::kConcat:
      return NewConcat(
          mojo::Clone(data_.concat));
    case Tag::kConv2d:
      return NewConv2d(
          mojo::Clone(data_.conv2d));
    case Tag::kCumulativeSum:
      return NewCumulativeSum(
          mojo::Clone(data_.cumulative_sum));
    case Tag::kDequantizeLinear:
      return NewDequantizeLinear(
          mojo::Clone(data_.dequantize_linear));
    case Tag::kElementWiseBinary:
      return NewElementWiseBinary(
          mojo::Clone(data_.element_wise_binary));
    case Tag::kElu:
      return NewElu(
          mojo::Clone(data_.elu));
    case Tag::kElementWiseUnary:
      return NewElementWiseUnary(
          mojo::Clone(data_.element_wise_unary));
    case Tag::kExpand:
      return NewExpand(
          mojo::Clone(data_.expand));
    case Tag::kGather:
      return NewGather(
          mojo::Clone(data_.gather));
    case Tag::kGatherElements:
      return NewGatherElements(
          mojo::Clone(data_.gather_elements));
    case Tag::kGatherNd:
      return NewGatherNd(
          mojo::Clone(data_.gather_nd));
    case Tag::kGelu:
      return NewGelu(
          mojo::Clone(data_.gelu));
    case Tag::kGemm:
      return NewGemm(
          mojo::Clone(data_.gemm));
    case Tag::kGru:
      return NewGru(
          mojo::Clone(data_.gru));
    case Tag::kGruCell:
      return NewGruCell(
          mojo::Clone(data_.gru_cell));
    case Tag::kHardSigmoid:
      return NewHardSigmoid(
          mojo::Clone(data_.hard_sigmoid));
    case Tag::kHardSwish:
      return NewHardSwish(
          mojo::Clone(data_.hard_swish));
    case Tag::kLayerNormalization:
      return NewLayerNormalization(
          mojo::Clone(data_.layer_normalization));
    case Tag::kInstanceNormalization:
      return NewInstanceNormalization(
          mojo::Clone(data_.instance_normalization));
    case Tag::kLeakyRelu:
      return NewLeakyRelu(
          mojo::Clone(data_.leaky_relu));
    case Tag::kLinear:
      return NewLinear(
          mojo::Clone(data_.linear));
    case Tag::kLstm:
      return NewLstm(
          mojo::Clone(data_.lstm));
    case Tag::kLstmCell:
      return NewLstmCell(
          mojo::Clone(data_.lstm_cell));
    case Tag::kMatmul:
      return NewMatmul(
          mojo::Clone(data_.matmul));
    case Tag::kPad:
      return NewPad(
          mojo::Clone(data_.pad));
    case Tag::kPool2d:
      return NewPool2d(
          mojo::Clone(data_.pool2d));
    case Tag::kPrelu:
      return NewPrelu(
          mojo::Clone(data_.prelu));
    case Tag::kQuantizeLinear:
      return NewQuantizeLinear(
          mojo::Clone(data_.quantize_linear));
    case Tag::kReduce:
      return NewReduce(
          mojo::Clone(data_.reduce));
    case Tag::kRelu:
      return NewRelu(
          mojo::Clone(data_.relu));
    case Tag::kResample2d:
      return NewResample2d(
          mojo::Clone(data_.resample2d));
    case Tag::kReshape:
      return NewReshape(
          mojo::Clone(data_.reshape));
    case Tag::kReverse:
      return NewReverse(
          mojo::Clone(data_.reverse));
    case Tag::kScatterElements:
      return NewScatterElements(
          mojo::Clone(data_.scatter_elements));
    case Tag::kScatterNd:
      return NewScatterNd(
          mojo::Clone(data_.scatter_nd));
    case Tag::kSigmoid:
      return NewSigmoid(
          mojo::Clone(data_.sigmoid));
    case Tag::kSlice:
      return NewSlice(
          mojo::Clone(data_.slice));
    case Tag::kSoftmax:
      return NewSoftmax(
          mojo::Clone(data_.softmax));
    case Tag::kSoftplus:
      return NewSoftplus(
          mojo::Clone(data_.softplus));
    case Tag::kSoftsign:
      return NewSoftsign(
          mojo::Clone(data_.softsign));
    case Tag::kSplit:
      return NewSplit(
          mojo::Clone(data_.split));
    case Tag::kTanh:
      return NewTanh(
          mojo::Clone(data_.tanh));
    case Tag::kTile:
      return NewTile(
          mojo::Clone(data_.tile));
    case Tag::kTranspose:
      return NewTranspose(
          mojo::Clone(data_.transpose));
    case Tag::kTriangular:
      return NewTriangular(
          mojo::Clone(data_.triangular));
    case Tag::kWhere:
      return NewWhere(
          mojo::Clone(data_.where));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Operation>::value>::type*>
bool Operation::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kArgMinMax:
      return mojo::Equals(data_.arg_min_max, other.data_.arg_min_max);
    case Tag::kBatchNormalization:
      return mojo::Equals(data_.batch_normalization, other.data_.batch_normalization);
    case Tag::kClamp:
      return mojo::Equals(data_.clamp, other.data_.clamp);
    case Tag::kConcat:
      return mojo::Equals(data_.concat, other.data_.concat);
    case Tag::kConv2d:
      return mojo::Equals(data_.conv2d, other.data_.conv2d);
    case Tag::kCumulativeSum:
      return mojo::Equals(data_.cumulative_sum, other.data_.cumulative_sum);
    case Tag::kDequantizeLinear:
      return mojo::Equals(data_.dequantize_linear, other.data_.dequantize_linear);
    case Tag::kElementWiseBinary:
      return mojo::Equals(data_.element_wise_binary, other.data_.element_wise_binary);
    case Tag::kElu:
      return mojo::Equals(data_.elu, other.data_.elu);
    case Tag::kElementWiseUnary:
      return mojo::Equals(data_.element_wise_unary, other.data_.element_wise_unary);
    case Tag::kExpand:
      return mojo::Equals(data_.expand, other.data_.expand);
    case Tag::kGather:
      return mojo::Equals(data_.gather, other.data_.gather);
    case Tag::kGatherElements:
      return mojo::Equals(data_.gather_elements, other.data_.gather_elements);
    case Tag::kGatherNd:
      return mojo::Equals(data_.gather_nd, other.data_.gather_nd);
    case Tag::kGelu:
      return mojo::Equals(data_.gelu, other.data_.gelu);
    case Tag::kGemm:
      return mojo::Equals(data_.gemm, other.data_.gemm);
    case Tag::kGru:
      return mojo::Equals(data_.gru, other.data_.gru);
    case Tag::kGruCell:
      return mojo::Equals(data_.gru_cell, other.data_.gru_cell);
    case Tag::kHardSigmoid:
      return mojo::Equals(data_.hard_sigmoid, other.data_.hard_sigmoid);
    case Tag::kHardSwish:
      return mojo::Equals(data_.hard_swish, other.data_.hard_swish);
    case Tag::kLayerNormalization:
      return mojo::Equals(data_.layer_normalization, other.data_.layer_normalization);
    case Tag::kInstanceNormalization:
      return mojo::Equals(data_.instance_normalization, other.data_.instance_normalization);
    case Tag::kLeakyRelu:
      return mojo::Equals(data_.leaky_relu, other.data_.leaky_relu);
    case Tag::kLinear:
      return mojo::Equals(data_.linear, other.data_.linear);
    case Tag::kLstm:
      return mojo::Equals(data_.lstm, other.data_.lstm);
    case Tag::kLstmCell:
      return mojo::Equals(data_.lstm_cell, other.data_.lstm_cell);
    case Tag::kMatmul:
      return mojo::Equals(data_.matmul, other.data_.matmul);
    case Tag::kPad:
      return mojo::Equals(data_.pad, other.data_.pad);
    case Tag::kPool2d:
      return mojo::Equals(data_.pool2d, other.data_.pool2d);
    case Tag::kPrelu:
      return mojo::Equals(data_.prelu, other.data_.prelu);
    case Tag::kQuantizeLinear:
      return mojo::Equals(data_.quantize_linear, other.data_.quantize_linear);
    case Tag::kReduce:
      return mojo::Equals(data_.reduce, other.data_.reduce);
    case Tag::kRelu:
      return mojo::Equals(data_.relu, other.data_.relu);
    case Tag::kResample2d:
      return mojo::Equals(data_.resample2d, other.data_.resample2d);
    case Tag::kReshape:
      return mojo::Equals(data_.reshape, other.data_.reshape);
    case Tag::kReverse:
      return mojo::Equals(data_.reverse, other.data_.reverse);
    case Tag::kScatterElements:
      return mojo::Equals(data_.scatter_elements, other.data_.scatter_elements);
    case Tag::kScatterNd:
      return mojo::Equals(data_.scatter_nd, other.data_.scatter_nd);
    case Tag::kSigmoid:
      return mojo::Equals(data_.sigmoid, other.data_.sigmoid);
    case Tag::kSlice:
      return mojo::Equals(data_.slice, other.data_.slice);
    case Tag::kSoftmax:
      return mojo::Equals(data_.softmax, other.data_.softmax);
    case Tag::kSoftplus:
      return mojo::Equals(data_.softplus, other.data_.softplus);
    case Tag::kSoftsign:
      return mojo::Equals(data_.softsign, other.data_.softsign);
    case Tag::kSplit:
      return mojo::Equals(data_.split, other.data_.split);
    case Tag::kTanh:
      return mojo::Equals(data_.tanh, other.data_.tanh);
    case Tag::kTile:
      return mojo::Equals(data_.tile, other.data_.tile);
    case Tag::kTranspose:
      return mojo::Equals(data_.transpose, other.data_.transpose);
    case Tag::kTriangular:
      return mojo::Equals(data_.triangular, other.data_.triangular);
    case Tag::kWhere:
      return mojo::Equals(data_.where, other.data_.where);
  }

  return false;
}
template <typename StructPtrType>
OperandDescriptorPtr OperandDescriptor::Clone() const {
  return New(
      mojo::Clone(data_type),
      mojo::Clone(shape),
      mojo::Clone(pending_permutation)
  );
}

template <typename T, OperandDescriptor::EnableIfSame<T>*>
bool OperandDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_type, other_struct.data_type))
    return false;
  if (!mojo::Equals(this->shape, other_struct.shape))
    return false;
  if (!mojo::Equals(this->pending_permutation, other_struct.pending_permutation))
    return false;
  return true;
}

template <typename T, OperandDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_type < rhs.data_type)
    return true;
  if (rhs.data_type < lhs.data_type)
    return false;
  if (lhs.shape < rhs.shape)
    return true;
  if (rhs.shape < lhs.shape)
    return false;
  if (lhs.pending_permutation < rhs.pending_permutation)
    return true;
  if (rhs.pending_permutation < lhs.pending_permutation)
    return false;
  return false;
}
template <typename StructPtrType>
OperandIdPtr OperandId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, OperandId::EnableIfSame<T>*>
bool OperandId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, OperandId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
OperandPtr Operand::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(descriptor),
      mojo::Clone(name)
  );
}

template <typename T, Operand::EnableIfSame<T>*>
bool Operand::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->descriptor, other_struct.descriptor))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, Operand::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.descriptor < rhs.descriptor)
    return true;
  if (rhs.descriptor < lhs.descriptor)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
ArgMinMaxPtr ArgMinMax::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(keep_dimensions),
      mojo::Clone(label)
  );
}

template <typename T, ArgMinMax::EnableIfSame<T>*>
bool ArgMinMax::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->keep_dimensions, other_struct.keep_dimensions))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ArgMinMax::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.keep_dimensions < rhs.keep_dimensions)
    return true;
  if (rhs.keep_dimensions < lhs.keep_dimensions)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
BatchNormalizationPtr BatchNormalization::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(mean_operand_id),
      mojo::Clone(variance_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(scale_operand_id),
      mojo::Clone(bias_operand_id),
      mojo::Clone(axis),
      mojo::Clone(epsilon),
      mojo::Clone(label)
  );
}

template <typename T, BatchNormalization::EnableIfSame<T>*>
bool BatchNormalization::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->mean_operand_id, other_struct.mean_operand_id))
    return false;
  if (!mojo::Equals(this->variance_operand_id, other_struct.variance_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->scale_operand_id, other_struct.scale_operand_id))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->epsilon, other_struct.epsilon))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, BatchNormalization::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.mean_operand_id < rhs.mean_operand_id)
    return true;
  if (rhs.mean_operand_id < lhs.mean_operand_id)
    return false;
  if (lhs.variance_operand_id < rhs.variance_operand_id)
    return true;
  if (rhs.variance_operand_id < lhs.variance_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.scale_operand_id < rhs.scale_operand_id)
    return true;
  if (rhs.scale_operand_id < lhs.scale_operand_id)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.epsilon < rhs.epsilon)
    return true;
  if (rhs.epsilon < lhs.epsilon)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ClampPtr Clamp::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(min_value),
      mojo::Clone(max_value),
      mojo::Clone(label)
  );
}

template <typename T, Clamp::EnableIfSame<T>*>
bool Clamp::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->min_value, other_struct.min_value))
    return false;
  if (!mojo::Equals(this->max_value, other_struct.max_value))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Clamp::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.min_value < rhs.min_value)
    return true;
  if (rhs.min_value < lhs.min_value)
    return false;
  if (lhs.max_value < rhs.max_value)
    return true;
  if (rhs.max_value < lhs.max_value)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ConcatPtr Concat::Clone() const {
  return New(
      mojo::Clone(input_operand_ids),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, Concat::EnableIfSame<T>*>
bool Concat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_ids, other_struct.input_operand_ids))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Concat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_ids < rhs.input_operand_ids)
    return true;
  if (rhs.input_operand_ids < lhs.input_operand_ids)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
Size2dPtr Size2d::Clone() const {
  return New(
      mojo::Clone(height),
      mojo::Clone(width)
  );
}

template <typename T, Size2d::EnableIfSame<T>*>
bool Size2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  return true;
}

template <typename T, Size2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  return false;
}
template <typename StructPtrType>
Padding2dPtr Padding2d::Clone() const {
  return New(
      mojo::Clone(beginning),
      mojo::Clone(ending)
  );
}

template <typename T, Padding2d::EnableIfSame<T>*>
bool Padding2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->beginning, other_struct.beginning))
    return false;
  if (!mojo::Equals(this->ending, other_struct.ending))
    return false;
  return true;
}

template <typename T, Padding2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.beginning < rhs.beginning)
    return true;
  if (rhs.beginning < lhs.beginning)
    return false;
  if (lhs.ending < rhs.ending)
    return true;
  if (rhs.ending < lhs.ending)
    return false;
  return false;
}
template <typename StructPtrType>
Conv2dPtr Conv2d::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(input_operand_id),
      mojo::Clone(filter_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(padding),
      mojo::Clone(strides),
      mojo::Clone(dilations),
      mojo::Clone(groups),
      mojo::Clone(bias_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Conv2d::EnableIfSame<T>*>
bool Conv2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->filter_operand_id, other_struct.filter_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->padding, other_struct.padding))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  if (!mojo::Equals(this->dilations, other_struct.dilations))
    return false;
  if (!mojo::Equals(this->groups, other_struct.groups))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Conv2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.filter_operand_id < rhs.filter_operand_id)
    return true;
  if (rhs.filter_operand_id < lhs.filter_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.padding < rhs.padding)
    return true;
  if (rhs.padding < lhs.padding)
    return false;
  if (lhs.strides < rhs.strides)
    return true;
  if (rhs.strides < lhs.strides)
    return false;
  if (lhs.dilations < rhs.dilations)
    return true;
  if (rhs.dilations < lhs.dilations)
    return false;
  if (lhs.groups < rhs.groups)
    return true;
  if (rhs.groups < lhs.groups)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
CumulativeSumPtr CumulativeSum::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(exclusive),
      mojo::Clone(reversed),
      mojo::Clone(label)
  );
}

template <typename T, CumulativeSum::EnableIfSame<T>*>
bool CumulativeSum::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->exclusive, other_struct.exclusive))
    return false;
  if (!mojo::Equals(this->reversed, other_struct.reversed))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, CumulativeSum::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.exclusive < rhs.exclusive)
    return true;
  if (rhs.exclusive < lhs.exclusive)
    return false;
  if (lhs.reversed < rhs.reversed)
    return true;
  if (rhs.reversed < lhs.reversed)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
DequantizeLinearPtr DequantizeLinear::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(scale_operand_id),
      mojo::Clone(zero_point_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, DequantizeLinear::EnableIfSame<T>*>
bool DequantizeLinear::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->scale_operand_id, other_struct.scale_operand_id))
    return false;
  if (!mojo::Equals(this->zero_point_operand_id, other_struct.zero_point_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, DequantizeLinear::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.scale_operand_id < rhs.scale_operand_id)
    return true;
  if (rhs.scale_operand_id < lhs.scale_operand_id)
    return false;
  if (lhs.zero_point_operand_id < rhs.zero_point_operand_id)
    return true;
  if (rhs.zero_point_operand_id < lhs.zero_point_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ElementWiseBinaryPtr ElementWiseBinary::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(lhs_operand_id),
      mojo::Clone(rhs_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, ElementWiseBinary::EnableIfSame<T>*>
bool ElementWiseBinary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->lhs_operand_id, other_struct.lhs_operand_id))
    return false;
  if (!mojo::Equals(this->rhs_operand_id, other_struct.rhs_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ElementWiseBinary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.lhs_operand_id < rhs.lhs_operand_id)
    return true;
  if (rhs.lhs_operand_id < lhs.lhs_operand_id)
    return false;
  if (lhs.rhs_operand_id < rhs.rhs_operand_id)
    return true;
  if (rhs.rhs_operand_id < lhs.rhs_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ElementWiseUnaryPtr ElementWiseUnary::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, ElementWiseUnary::EnableIfSame<T>*>
bool ElementWiseUnary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ElementWiseUnary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ExpandPtr Expand::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Expand::EnableIfSame<T>*>
bool Expand::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Expand::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ConstantPaddingPtr ConstantPadding::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, ConstantPadding::EnableIfSame<T>*>
bool ConstantPadding::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ConstantPadding::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
EdgePaddingPtr EdgePadding::Clone() const {
  return New(
  );
}

template <typename T, EdgePadding::EnableIfSame<T>*>
bool EdgePadding::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EdgePadding::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ReflectionPaddingPtr ReflectionPadding::Clone() const {
  return New(
  );
}

template <typename T, ReflectionPadding::EnableIfSame<T>*>
bool ReflectionPadding::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ReflectionPadding::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
InstanceNormalizationPtr InstanceNormalization::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(scale_operand_id),
      mojo::Clone(bias_operand_id),
      mojo::Clone(epsilon),
      mojo::Clone(label)
  );
}

template <typename T, InstanceNormalization::EnableIfSame<T>*>
bool InstanceNormalization::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->scale_operand_id, other_struct.scale_operand_id))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->epsilon, other_struct.epsilon))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, InstanceNormalization::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.scale_operand_id < rhs.scale_operand_id)
    return true;
  if (rhs.scale_operand_id < lhs.scale_operand_id)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.epsilon < rhs.epsilon)
    return true;
  if (rhs.epsilon < lhs.epsilon)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
MatmulPtr Matmul::Clone() const {
  return New(
      mojo::Clone(a_operand_id),
      mojo::Clone(b_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Matmul::EnableIfSame<T>*>
bool Matmul::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->a_operand_id, other_struct.a_operand_id))
    return false;
  if (!mojo::Equals(this->b_operand_id, other_struct.b_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Matmul::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.a_operand_id < rhs.a_operand_id)
    return true;
  if (rhs.a_operand_id < lhs.a_operand_id)
    return false;
  if (lhs.b_operand_id < rhs.b_operand_id)
    return true;
  if (rhs.b_operand_id < lhs.b_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
PadPtr Pad::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(beginning_padding),
      mojo::Clone(ending_padding),
      mojo::Clone(mode),
      mojo::Clone(label)
  );
}

template <typename T, Pad::EnableIfSame<T>*>
bool Pad::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->beginning_padding, other_struct.beginning_padding))
    return false;
  if (!mojo::Equals(this->ending_padding, other_struct.ending_padding))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Pad::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.beginning_padding < rhs.beginning_padding)
    return true;
  if (rhs.beginning_padding < lhs.beginning_padding)
    return false;
  if (lhs.ending_padding < rhs.ending_padding)
    return true;
  if (rhs.ending_padding < lhs.ending_padding)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ReducePtr Reduce::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axes),
      mojo::Clone(keep_dimensions),
      mojo::Clone(label)
  );
}

template <typename T, Reduce::EnableIfSame<T>*>
bool Reduce::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axes, other_struct.axes))
    return false;
  if (!mojo::Equals(this->keep_dimensions, other_struct.keep_dimensions))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Reduce::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axes < rhs.axes)
    return true;
  if (rhs.axes < lhs.axes)
    return false;
  if (lhs.keep_dimensions < rhs.keep_dimensions)
    return true;
  if (rhs.keep_dimensions < lhs.keep_dimensions)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
Pool2dPtr Pool2d::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(window_dimensions),
      mojo::Clone(padding),
      mojo::Clone(strides),
      mojo::Clone(dilations),
      mojo::Clone(label)
  );
}

template <typename T, Pool2d::EnableIfSame<T>*>
bool Pool2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->window_dimensions, other_struct.window_dimensions))
    return false;
  if (!mojo::Equals(this->padding, other_struct.padding))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  if (!mojo::Equals(this->dilations, other_struct.dilations))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Pool2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.window_dimensions < rhs.window_dimensions)
    return true;
  if (rhs.window_dimensions < lhs.window_dimensions)
    return false;
  if (lhs.padding < rhs.padding)
    return true;
  if (rhs.padding < lhs.padding)
    return false;
  if (lhs.strides < rhs.strides)
    return true;
  if (rhs.strides < lhs.strides)
    return false;
  if (lhs.dilations < rhs.dilations)
    return true;
  if (rhs.dilations < lhs.dilations)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
RangePtr Range::Clone() const {
  return New(
      mojo::Clone(start),
      mojo::Clone(size),
      mojo::Clone(stride)
  );
}

template <typename T, Range::EnableIfSame<T>*>
bool Range::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start, other_struct.start))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->stride, other_struct.stride))
    return false;
  return true;
}

template <typename T, Range::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start < rhs.start)
    return true;
  if (rhs.start < lhs.start)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.stride < rhs.stride)
    return true;
  if (rhs.stride < lhs.stride)
    return false;
  return false;
}
template <typename StructPtrType>
SlicePtr Slice::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(ranges),
      mojo::Clone(label)
  );
}

template <typename T, Slice::EnableIfSame<T>*>
bool Slice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->ranges, other_struct.ranges))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Slice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.ranges < rhs.ranges)
    return true;
  if (rhs.ranges < lhs.ranges)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
EluPtr Elu::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(alpha),
      mojo::Clone(label)
  );
}

template <typename T, Elu::EnableIfSame<T>*>
bool Elu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Elu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GatherPtr Gather::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(indices_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, Gather::EnableIfSame<T>*>
bool Gather::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->indices_operand_id, other_struct.indices_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Gather::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.indices_operand_id < rhs.indices_operand_id)
    return true;
  if (rhs.indices_operand_id < lhs.indices_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GatherElementsPtr GatherElements::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(indices_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, GatherElements::EnableIfSame<T>*>
bool GatherElements::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->indices_operand_id, other_struct.indices_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, GatherElements::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.indices_operand_id < rhs.indices_operand_id)
    return true;
  if (rhs.indices_operand_id < lhs.indices_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GatherNDPtr GatherND::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(indices_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, GatherND::EnableIfSame<T>*>
bool GatherND::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->indices_operand_id, other_struct.indices_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, GatherND::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.indices_operand_id < rhs.indices_operand_id)
    return true;
  if (rhs.indices_operand_id < lhs.indices_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GeluPtr Gelu::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Gelu::EnableIfSame<T>*>
bool Gelu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Gelu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GruPtr Gru::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(weight_operand_id),
      mojo::Clone(recurrent_weight_operand_id),
      mojo::Clone(steps),
      mojo::Clone(hidden_size),
      mojo::Clone(output_operand_ids),
      mojo::Clone(bias_operand_id),
      mojo::Clone(recurrent_bias_operand_id),
      mojo::Clone(initial_hidden_state_operand_id),
      mojo::Clone(reset_after),
      mojo::Clone(return_sequence),
      mojo::Clone(direction),
      mojo::Clone(layout),
      mojo::Clone(activations),
      mojo::Clone(label)
  );
}

template <typename T, Gru::EnableIfSame<T>*>
bool Gru::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->weight_operand_id, other_struct.weight_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_weight_operand_id, other_struct.recurrent_weight_operand_id))
    return false;
  if (!mojo::Equals(this->steps, other_struct.steps))
    return false;
  if (!mojo::Equals(this->hidden_size, other_struct.hidden_size))
    return false;
  if (!mojo::Equals(this->output_operand_ids, other_struct.output_operand_ids))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_bias_operand_id, other_struct.recurrent_bias_operand_id))
    return false;
  if (!mojo::Equals(this->initial_hidden_state_operand_id, other_struct.initial_hidden_state_operand_id))
    return false;
  if (!mojo::Equals(this->reset_after, other_struct.reset_after))
    return false;
  if (!mojo::Equals(this->return_sequence, other_struct.return_sequence))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->activations, other_struct.activations))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Gru::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.weight_operand_id < rhs.weight_operand_id)
    return true;
  if (rhs.weight_operand_id < lhs.weight_operand_id)
    return false;
  if (lhs.recurrent_weight_operand_id < rhs.recurrent_weight_operand_id)
    return true;
  if (rhs.recurrent_weight_operand_id < lhs.recurrent_weight_operand_id)
    return false;
  if (lhs.steps < rhs.steps)
    return true;
  if (rhs.steps < lhs.steps)
    return false;
  if (lhs.hidden_size < rhs.hidden_size)
    return true;
  if (rhs.hidden_size < lhs.hidden_size)
    return false;
  if (lhs.output_operand_ids < rhs.output_operand_ids)
    return true;
  if (rhs.output_operand_ids < lhs.output_operand_ids)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.recurrent_bias_operand_id < rhs.recurrent_bias_operand_id)
    return true;
  if (rhs.recurrent_bias_operand_id < lhs.recurrent_bias_operand_id)
    return false;
  if (lhs.initial_hidden_state_operand_id < rhs.initial_hidden_state_operand_id)
    return true;
  if (rhs.initial_hidden_state_operand_id < lhs.initial_hidden_state_operand_id)
    return false;
  if (lhs.reset_after < rhs.reset_after)
    return true;
  if (rhs.reset_after < lhs.reset_after)
    return false;
  if (lhs.return_sequence < rhs.return_sequence)
    return true;
  if (rhs.return_sequence < lhs.return_sequence)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.activations < rhs.activations)
    return true;
  if (rhs.activations < lhs.activations)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GruCellPtr GruCell::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(weight_operand_id),
      mojo::Clone(recurrent_weight_operand_id),
      mojo::Clone(hidden_state_operand_id),
      mojo::Clone(hidden_size),
      mojo::Clone(output_operand_id),
      mojo::Clone(bias_operand_id),
      mojo::Clone(recurrent_bias_operand_id),
      mojo::Clone(reset_after),
      mojo::Clone(layout),
      mojo::Clone(activations),
      mojo::Clone(label)
  );
}

template <typename T, GruCell::EnableIfSame<T>*>
bool GruCell::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->weight_operand_id, other_struct.weight_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_weight_operand_id, other_struct.recurrent_weight_operand_id))
    return false;
  if (!mojo::Equals(this->hidden_state_operand_id, other_struct.hidden_state_operand_id))
    return false;
  if (!mojo::Equals(this->hidden_size, other_struct.hidden_size))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_bias_operand_id, other_struct.recurrent_bias_operand_id))
    return false;
  if (!mojo::Equals(this->reset_after, other_struct.reset_after))
    return false;
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->activations, other_struct.activations))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, GruCell::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.weight_operand_id < rhs.weight_operand_id)
    return true;
  if (rhs.weight_operand_id < lhs.weight_operand_id)
    return false;
  if (lhs.recurrent_weight_operand_id < rhs.recurrent_weight_operand_id)
    return true;
  if (rhs.recurrent_weight_operand_id < lhs.recurrent_weight_operand_id)
    return false;
  if (lhs.hidden_state_operand_id < rhs.hidden_state_operand_id)
    return true;
  if (rhs.hidden_state_operand_id < lhs.hidden_state_operand_id)
    return false;
  if (lhs.hidden_size < rhs.hidden_size)
    return true;
  if (rhs.hidden_size < lhs.hidden_size)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.recurrent_bias_operand_id < rhs.recurrent_bias_operand_id)
    return true;
  if (rhs.recurrent_bias_operand_id < lhs.recurrent_bias_operand_id)
    return false;
  if (lhs.reset_after < rhs.reset_after)
    return true;
  if (rhs.reset_after < lhs.reset_after)
    return false;
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.activations < rhs.activations)
    return true;
  if (rhs.activations < lhs.activations)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GemmPtr Gemm::Clone() const {
  return New(
      mojo::Clone(a_operand_id),
      mojo::Clone(b_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(c_operand_id),
      mojo::Clone(alpha),
      mojo::Clone(beta),
      mojo::Clone(a_transpose),
      mojo::Clone(b_transpose),
      mojo::Clone(label)
  );
}

template <typename T, Gemm::EnableIfSame<T>*>
bool Gemm::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->a_operand_id, other_struct.a_operand_id))
    return false;
  if (!mojo::Equals(this->b_operand_id, other_struct.b_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->c_operand_id, other_struct.c_operand_id))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  if (!mojo::Equals(this->beta, other_struct.beta))
    return false;
  if (!mojo::Equals(this->a_transpose, other_struct.a_transpose))
    return false;
  if (!mojo::Equals(this->b_transpose, other_struct.b_transpose))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Gemm::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.a_operand_id < rhs.a_operand_id)
    return true;
  if (rhs.a_operand_id < lhs.a_operand_id)
    return false;
  if (lhs.b_operand_id < rhs.b_operand_id)
    return true;
  if (rhs.b_operand_id < lhs.b_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.c_operand_id < rhs.c_operand_id)
    return true;
  if (rhs.c_operand_id < lhs.c_operand_id)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  if (lhs.beta < rhs.beta)
    return true;
  if (rhs.beta < lhs.beta)
    return false;
  if (lhs.a_transpose < rhs.a_transpose)
    return true;
  if (rhs.a_transpose < lhs.a_transpose)
    return false;
  if (lhs.b_transpose < rhs.b_transpose)
    return true;
  if (rhs.b_transpose < lhs.b_transpose)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
HardSigmoidPtr HardSigmoid::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(alpha),
      mojo::Clone(beta),
      mojo::Clone(label)
  );
}

template <typename T, HardSigmoid::EnableIfSame<T>*>
bool HardSigmoid::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  if (!mojo::Equals(this->beta, other_struct.beta))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, HardSigmoid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  if (lhs.beta < rhs.beta)
    return true;
  if (rhs.beta < lhs.beta)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
HardSwishPtr HardSwish::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, HardSwish::EnableIfSame<T>*>
bool HardSwish::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, HardSwish::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
LayerNormalizationPtr LayerNormalization::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(scale_operand_id),
      mojo::Clone(bias_operand_id),
      mojo::Clone(axes),
      mojo::Clone(epsilon),
      mojo::Clone(label)
  );
}

template <typename T, LayerNormalization::EnableIfSame<T>*>
bool LayerNormalization::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->scale_operand_id, other_struct.scale_operand_id))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->axes, other_struct.axes))
    return false;
  if (!mojo::Equals(this->epsilon, other_struct.epsilon))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, LayerNormalization::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.scale_operand_id < rhs.scale_operand_id)
    return true;
  if (rhs.scale_operand_id < lhs.scale_operand_id)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.axes < rhs.axes)
    return true;
  if (rhs.axes < lhs.axes)
    return false;
  if (lhs.epsilon < rhs.epsilon)
    return true;
  if (rhs.epsilon < lhs.epsilon)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
LeakyReluPtr LeakyRelu::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(alpha),
      mojo::Clone(label)
  );
}

template <typename T, LeakyRelu::EnableIfSame<T>*>
bool LeakyRelu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, LeakyRelu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
LinearPtr Linear::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(alpha),
      mojo::Clone(beta),
      mojo::Clone(label)
  );
}

template <typename T, Linear::EnableIfSame<T>*>
bool Linear::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  if (!mojo::Equals(this->beta, other_struct.beta))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Linear::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  if (lhs.beta < rhs.beta)
    return true;
  if (rhs.beta < lhs.beta)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
LstmPtr Lstm::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(weight_operand_id),
      mojo::Clone(recurrent_weight_operand_id),
      mojo::Clone(output_operand_ids),
      mojo::Clone(steps),
      mojo::Clone(hidden_size),
      mojo::Clone(bias_operand_id),
      mojo::Clone(recurrent_bias_operand_id),
      mojo::Clone(peephole_weight_operand_id),
      mojo::Clone(initial_hidden_state_operand_id),
      mojo::Clone(initial_cell_state_operand_id),
      mojo::Clone(return_sequence),
      mojo::Clone(direction),
      mojo::Clone(layout),
      mojo::Clone(activations),
      mojo::Clone(label)
  );
}

template <typename T, Lstm::EnableIfSame<T>*>
bool Lstm::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->weight_operand_id, other_struct.weight_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_weight_operand_id, other_struct.recurrent_weight_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_ids, other_struct.output_operand_ids))
    return false;
  if (!mojo::Equals(this->steps, other_struct.steps))
    return false;
  if (!mojo::Equals(this->hidden_size, other_struct.hidden_size))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_bias_operand_id, other_struct.recurrent_bias_operand_id))
    return false;
  if (!mojo::Equals(this->peephole_weight_operand_id, other_struct.peephole_weight_operand_id))
    return false;
  if (!mojo::Equals(this->initial_hidden_state_operand_id, other_struct.initial_hidden_state_operand_id))
    return false;
  if (!mojo::Equals(this->initial_cell_state_operand_id, other_struct.initial_cell_state_operand_id))
    return false;
  if (!mojo::Equals(this->return_sequence, other_struct.return_sequence))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->activations, other_struct.activations))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Lstm::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.weight_operand_id < rhs.weight_operand_id)
    return true;
  if (rhs.weight_operand_id < lhs.weight_operand_id)
    return false;
  if (lhs.recurrent_weight_operand_id < rhs.recurrent_weight_operand_id)
    return true;
  if (rhs.recurrent_weight_operand_id < lhs.recurrent_weight_operand_id)
    return false;
  if (lhs.output_operand_ids < rhs.output_operand_ids)
    return true;
  if (rhs.output_operand_ids < lhs.output_operand_ids)
    return false;
  if (lhs.steps < rhs.steps)
    return true;
  if (rhs.steps < lhs.steps)
    return false;
  if (lhs.hidden_size < rhs.hidden_size)
    return true;
  if (rhs.hidden_size < lhs.hidden_size)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.recurrent_bias_operand_id < rhs.recurrent_bias_operand_id)
    return true;
  if (rhs.recurrent_bias_operand_id < lhs.recurrent_bias_operand_id)
    return false;
  if (lhs.peephole_weight_operand_id < rhs.peephole_weight_operand_id)
    return true;
  if (rhs.peephole_weight_operand_id < lhs.peephole_weight_operand_id)
    return false;
  if (lhs.initial_hidden_state_operand_id < rhs.initial_hidden_state_operand_id)
    return true;
  if (rhs.initial_hidden_state_operand_id < lhs.initial_hidden_state_operand_id)
    return false;
  if (lhs.initial_cell_state_operand_id < rhs.initial_cell_state_operand_id)
    return true;
  if (rhs.initial_cell_state_operand_id < lhs.initial_cell_state_operand_id)
    return false;
  if (lhs.return_sequence < rhs.return_sequence)
    return true;
  if (rhs.return_sequence < lhs.return_sequence)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.activations < rhs.activations)
    return true;
  if (rhs.activations < lhs.activations)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
LstmCellPtr LstmCell::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(weight_operand_id),
      mojo::Clone(recurrent_weight_operand_id),
      mojo::Clone(hidden_state_operand_id),
      mojo::Clone(cell_state_operand_id),
      mojo::Clone(output_operand_ids),
      mojo::Clone(hidden_size),
      mojo::Clone(bias_operand_id),
      mojo::Clone(recurrent_bias_operand_id),
      mojo::Clone(peephole_weight_operand_id),
      mojo::Clone(layout),
      mojo::Clone(activations),
      mojo::Clone(label)
  );
}

template <typename T, LstmCell::EnableIfSame<T>*>
bool LstmCell::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->weight_operand_id, other_struct.weight_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_weight_operand_id, other_struct.recurrent_weight_operand_id))
    return false;
  if (!mojo::Equals(this->hidden_state_operand_id, other_struct.hidden_state_operand_id))
    return false;
  if (!mojo::Equals(this->cell_state_operand_id, other_struct.cell_state_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_ids, other_struct.output_operand_ids))
    return false;
  if (!mojo::Equals(this->hidden_size, other_struct.hidden_size))
    return false;
  if (!mojo::Equals(this->bias_operand_id, other_struct.bias_operand_id))
    return false;
  if (!mojo::Equals(this->recurrent_bias_operand_id, other_struct.recurrent_bias_operand_id))
    return false;
  if (!mojo::Equals(this->peephole_weight_operand_id, other_struct.peephole_weight_operand_id))
    return false;
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->activations, other_struct.activations))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, LstmCell::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.weight_operand_id < rhs.weight_operand_id)
    return true;
  if (rhs.weight_operand_id < lhs.weight_operand_id)
    return false;
  if (lhs.recurrent_weight_operand_id < rhs.recurrent_weight_operand_id)
    return true;
  if (rhs.recurrent_weight_operand_id < lhs.recurrent_weight_operand_id)
    return false;
  if (lhs.hidden_state_operand_id < rhs.hidden_state_operand_id)
    return true;
  if (rhs.hidden_state_operand_id < lhs.hidden_state_operand_id)
    return false;
  if (lhs.cell_state_operand_id < rhs.cell_state_operand_id)
    return true;
  if (rhs.cell_state_operand_id < lhs.cell_state_operand_id)
    return false;
  if (lhs.output_operand_ids < rhs.output_operand_ids)
    return true;
  if (rhs.output_operand_ids < lhs.output_operand_ids)
    return false;
  if (lhs.hidden_size < rhs.hidden_size)
    return true;
  if (rhs.hidden_size < lhs.hidden_size)
    return false;
  if (lhs.bias_operand_id < rhs.bias_operand_id)
    return true;
  if (rhs.bias_operand_id < lhs.bias_operand_id)
    return false;
  if (lhs.recurrent_bias_operand_id < rhs.recurrent_bias_operand_id)
    return true;
  if (rhs.recurrent_bias_operand_id < lhs.recurrent_bias_operand_id)
    return false;
  if (lhs.peephole_weight_operand_id < rhs.peephole_weight_operand_id)
    return true;
  if (rhs.peephole_weight_operand_id < lhs.peephole_weight_operand_id)
    return false;
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.activations < rhs.activations)
    return true;
  if (rhs.activations < lhs.activations)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
PreluPtr Prelu::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(slope_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Prelu::EnableIfSame<T>*>
bool Prelu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->slope_operand_id, other_struct.slope_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Prelu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.slope_operand_id < rhs.slope_operand_id)
    return true;
  if (rhs.slope_operand_id < lhs.slope_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
QuantizeLinearPtr QuantizeLinear::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(scale_operand_id),
      mojo::Clone(zero_point_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, QuantizeLinear::EnableIfSame<T>*>
bool QuantizeLinear::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->scale_operand_id, other_struct.scale_operand_id))
    return false;
  if (!mojo::Equals(this->zero_point_operand_id, other_struct.zero_point_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, QuantizeLinear::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.scale_operand_id < rhs.scale_operand_id)
    return true;
  if (rhs.scale_operand_id < lhs.scale_operand_id)
    return false;
  if (lhs.zero_point_operand_id < rhs.zero_point_operand_id)
    return true;
  if (rhs.zero_point_operand_id < lhs.zero_point_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ReluPtr Relu::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Relu::EnableIfSame<T>*>
bool Relu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Relu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ReshapePtr Reshape::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Reshape::EnableIfSame<T>*>
bool Reshape::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Reshape::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ReversePtr Reverse::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axes),
      mojo::Clone(label)
  );
}

template <typename T, Reverse::EnableIfSame<T>*>
bool Reverse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axes, other_struct.axes))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Reverse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axes < rhs.axes)
    return true;
  if (rhs.axes < lhs.axes)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ScatterElementsPtr ScatterElements::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(indices_operand_id),
      mojo::Clone(updates_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, ScatterElements::EnableIfSame<T>*>
bool ScatterElements::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->indices_operand_id, other_struct.indices_operand_id))
    return false;
  if (!mojo::Equals(this->updates_operand_id, other_struct.updates_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ScatterElements::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.indices_operand_id < rhs.indices_operand_id)
    return true;
  if (rhs.indices_operand_id < lhs.indices_operand_id)
    return false;
  if (lhs.updates_operand_id < rhs.updates_operand_id)
    return true;
  if (rhs.updates_operand_id < lhs.updates_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
ScatterNDPtr ScatterND::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(indices_operand_id),
      mojo::Clone(updates_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, ScatterND::EnableIfSame<T>*>
bool ScatterND::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->indices_operand_id, other_struct.indices_operand_id))
    return false;
  if (!mojo::Equals(this->updates_operand_id, other_struct.updates_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, ScatterND::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.indices_operand_id < rhs.indices_operand_id)
    return true;
  if (rhs.indices_operand_id < lhs.indices_operand_id)
    return false;
  if (lhs.updates_operand_id < rhs.updates_operand_id)
    return true;
  if (rhs.updates_operand_id < lhs.updates_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
SigmoidPtr Sigmoid::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Sigmoid::EnableIfSame<T>*>
bool Sigmoid::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Sigmoid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
SoftmaxPtr Softmax::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, Softmax::EnableIfSame<T>*>
bool Softmax::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Softmax::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
SoftplusPtr Softplus::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Softplus::EnableIfSame<T>*>
bool Softplus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Softplus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
SoftsignPtr Softsign::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Softsign::EnableIfSame<T>*>
bool Softsign::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Softsign::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
SplitPtr Split::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_ids),
      mojo::Clone(axis),
      mojo::Clone(label)
  );
}

template <typename T, Split::EnableIfSame<T>*>
bool Split::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_ids, other_struct.output_operand_ids))
    return false;
  if (!mojo::Equals(this->axis, other_struct.axis))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Split::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_ids < rhs.output_operand_ids)
    return true;
  if (rhs.output_operand_ids < lhs.output_operand_ids)
    return false;
  if (lhs.axis < rhs.axis)
    return true;
  if (rhs.axis < lhs.axis)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
TanhPtr Tanh::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Tanh::EnableIfSame<T>*>
bool Tanh::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Tanh::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
TilePtr Tile::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(repetitions),
      mojo::Clone(label)
  );
}

template <typename T, Tile::EnableIfSame<T>*>
bool Tile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->repetitions, other_struct.repetitions))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Tile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.repetitions < rhs.repetitions)
    return true;
  if (rhs.repetitions < lhs.repetitions)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
TransposePtr Transpose::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(permutation),
      mojo::Clone(label)
  );
}

template <typename T, Transpose::EnableIfSame<T>*>
bool Transpose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->permutation, other_struct.permutation))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Transpose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.permutation < rhs.permutation)
    return true;
  if (rhs.permutation < lhs.permutation)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
TriangularPtr Triangular::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(upper),
      mojo::Clone(diagonal),
      mojo::Clone(label)
  );
}

template <typename T, Triangular::EnableIfSame<T>*>
bool Triangular::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->upper, other_struct.upper))
    return false;
  if (!mojo::Equals(this->diagonal, other_struct.diagonal))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Triangular::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.upper < rhs.upper)
    return true;
  if (rhs.upper < lhs.upper)
    return false;
  if (lhs.diagonal < rhs.diagonal)
    return true;
  if (rhs.diagonal < lhs.diagonal)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
Resample2dPtr Resample2d::Clone() const {
  return New(
      mojo::Clone(input_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(mode),
      mojo::Clone(scales),
      mojo::Clone(axes),
      mojo::Clone(label)
  );
}

template <typename T, Resample2d::EnableIfSame<T>*>
bool Resample2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_operand_id, other_struct.input_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->scales, other_struct.scales))
    return false;
  if (!mojo::Equals(this->axes, other_struct.axes))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Resample2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_operand_id < rhs.input_operand_id)
    return true;
  if (rhs.input_operand_id < lhs.input_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.scales < rhs.scales)
    return true;
  if (rhs.scales < lhs.scales)
    return false;
  if (lhs.axes < rhs.axes)
    return true;
  if (rhs.axes < lhs.axes)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
WherePtr Where::Clone() const {
  return New(
      mojo::Clone(condition_operand_id),
      mojo::Clone(true_value_operand_id),
      mojo::Clone(false_value_operand_id),
      mojo::Clone(output_operand_id),
      mojo::Clone(label)
  );
}

template <typename T, Where::EnableIfSame<T>*>
bool Where::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->condition_operand_id, other_struct.condition_operand_id))
    return false;
  if (!mojo::Equals(this->true_value_operand_id, other_struct.true_value_operand_id))
    return false;
  if (!mojo::Equals(this->false_value_operand_id, other_struct.false_value_operand_id))
    return false;
  if (!mojo::Equals(this->output_operand_id, other_struct.output_operand_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, Where::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.condition_operand_id < rhs.condition_operand_id)
    return true;
  if (rhs.condition_operand_id < lhs.condition_operand_id)
    return false;
  if (lhs.true_value_operand_id < rhs.true_value_operand_id)
    return true;
  if (rhs.true_value_operand_id < lhs.true_value_operand_id)
    return false;
  if (lhs.false_value_operand_id < rhs.false_value_operand_id)
    return true;
  if (rhs.false_value_operand_id < lhs.false_value_operand_id)
    return false;
  if (lhs.output_operand_id < rhs.output_operand_id)
    return true;
  if (rhs.output_operand_id < lhs.output_operand_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  return false;
}
template <typename StructPtrType>
GraphInfoPtr GraphInfo::Clone() const {
  return New(
      mojo::Clone(operands),
      mojo::Clone(input_operands),
      mojo::Clone(output_operands),
      mojo::Clone(operations),
      mojo::Clone(constant_operand_ids_to_handles),
      mojo::Clone(id_to_constant_tensor_operand_map)
  );
}

template <typename T, GraphInfo::EnableIfSame<T>*>
bool GraphInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->operands, other_struct.operands))
    return false;
  if (!mojo::Equals(this->input_operands, other_struct.input_operands))
    return false;
  if (!mojo::Equals(this->output_operands, other_struct.output_operands))
    return false;
  if (!mojo::Equals(this->operations, other_struct.operations))
    return false;
  if (!mojo::Equals(this->constant_operand_ids_to_handles, other_struct.constant_operand_ids_to_handles))
    return false;
  if (!mojo::Equals(this->id_to_constant_tensor_operand_map, other_struct.id_to_constant_tensor_operand_map))
    return false;
  return true;
}

template <typename T, GraphInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.operands < rhs.operands)
    return true;
  if (rhs.operands < lhs.operands)
    return false;
  if (lhs.input_operands < rhs.input_operands)
    return true;
  if (rhs.input_operands < lhs.input_operands)
    return false;
  if (lhs.output_operands < rhs.output_operands)
    return true;
  if (rhs.output_operands < lhs.output_operands)
    return false;
  if (lhs.operations < rhs.operations)
    return true;
  if (rhs.operations < lhs.operations)
    return false;
  if (lhs.constant_operand_ids_to_handles < rhs.constant_operand_ids_to_handles)
    return true;
  if (rhs.constant_operand_ids_to_handles < lhs.constant_operand_ids_to_handles)
    return false;
  if (lhs.id_to_constant_tensor_operand_map < rhs.id_to_constant_tensor_operand_map)
    return true;
  if (rhs.id_to_constant_tensor_operand_map < lhs.id_to_constant_tensor_operand_map)
    return false;
  return false;
}


}  // webnn::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::OperandDescriptor::DataView,
                                         ::webnn::mojom::OperandDescriptorPtr> {
  static bool IsNull(const ::webnn::mojom::OperandDescriptorPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::OperandDescriptorPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::OperandDescriptor::data_type) data_type(
      const ::webnn::mojom::OperandDescriptorPtr& input) {
    return input->data_type;
  }

  static const decltype(::webnn::mojom::OperandDescriptor::shape)& shape(
      const ::webnn::mojom::OperandDescriptorPtr& input) {
    return input->shape;
  }

  static const decltype(::webnn::mojom::OperandDescriptor::pending_permutation)& pending_permutation(
      const ::webnn::mojom::OperandDescriptorPtr& input) {
    return input->pending_permutation;
  }

  static bool Read(::webnn::mojom::OperandDescriptor::DataView input, ::webnn::mojom::OperandDescriptorPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::OperandId::DataView,
                                         ::webnn::mojom::OperandIdPtr> {
  static bool IsNull(const ::webnn::mojom::OperandIdPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::OperandIdPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::OperandId::id) id(
      const ::webnn::mojom::OperandIdPtr& input) {
    return input->id;
  }

  static bool Read(::webnn::mojom::OperandId::DataView input, ::webnn::mojom::OperandIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Operand::DataView,
                                         ::webnn::mojom::OperandPtr> {
  static bool IsNull(const ::webnn::mojom::OperandPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::OperandPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Operand::kind) kind(
      const ::webnn::mojom::OperandPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::Operand::descriptor)& descriptor(
      const ::webnn::mojom::OperandPtr& input) {
    return input->descriptor;
  }

  static const decltype(::webnn::mojom::Operand::name)& name(
      const ::webnn::mojom::OperandPtr& input) {
    return input->name;
  }

  static bool Read(::webnn::mojom::Operand::DataView input, ::webnn::mojom::OperandPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ArgMinMax::DataView,
                                         ::webnn::mojom::ArgMinMaxPtr> {
  static bool IsNull(const ::webnn::mojom::ArgMinMaxPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ArgMinMaxPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::ArgMinMax::kind) kind(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::ArgMinMax::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::ArgMinMax::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::ArgMinMax::axis) axis(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->axis;
  }

  static decltype(::webnn::mojom::ArgMinMax::keep_dimensions) keep_dimensions(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->keep_dimensions;
  }

  static const decltype(::webnn::mojom::ArgMinMax::label)& label(
      const ::webnn::mojom::ArgMinMaxPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::ArgMinMax::DataView input, ::webnn::mojom::ArgMinMaxPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::BatchNormalization::DataView,
                                         ::webnn::mojom::BatchNormalizationPtr> {
  static bool IsNull(const ::webnn::mojom::BatchNormalizationPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::BatchNormalizationPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::BatchNormalization::input_operand_id)& input_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::BatchNormalization::mean_operand_id)& mean_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->mean_operand_id;
  }

  static const decltype(::webnn::mojom::BatchNormalization::variance_operand_id)& variance_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->variance_operand_id;
  }

  static const decltype(::webnn::mojom::BatchNormalization::output_operand_id)& output_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::BatchNormalization::scale_operand_id)& scale_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->scale_operand_id;
  }

  static const decltype(::webnn::mojom::BatchNormalization::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->bias_operand_id;
  }

  static decltype(::webnn::mojom::BatchNormalization::axis) axis(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->axis;
  }

  static decltype(::webnn::mojom::BatchNormalization::epsilon) epsilon(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->epsilon;
  }

  static const decltype(::webnn::mojom::BatchNormalization::label)& label(
      const ::webnn::mojom::BatchNormalizationPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::BatchNormalization::DataView input, ::webnn::mojom::BatchNormalizationPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Clamp::DataView,
                                         ::webnn::mojom::ClampPtr> {
  static bool IsNull(const ::webnn::mojom::ClampPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ClampPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Clamp::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ClampPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Clamp::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ClampPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Clamp::min_value)& min_value(
      const ::webnn::mojom::ClampPtr& input) {
    return input->min_value;
  }

  static const decltype(::webnn::mojom::Clamp::max_value)& max_value(
      const ::webnn::mojom::ClampPtr& input) {
    return input->max_value;
  }

  static const decltype(::webnn::mojom::Clamp::label)& label(
      const ::webnn::mojom::ClampPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Clamp::DataView input, ::webnn::mojom::ClampPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Concat::DataView,
                                         ::webnn::mojom::ConcatPtr> {
  static bool IsNull(const ::webnn::mojom::ConcatPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ConcatPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Concat::input_operand_ids)& input_operand_ids(
      const ::webnn::mojom::ConcatPtr& input) {
    return input->input_operand_ids;
  }

  static const decltype(::webnn::mojom::Concat::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ConcatPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Concat::axis) axis(
      const ::webnn::mojom::ConcatPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::Concat::label)& label(
      const ::webnn::mojom::ConcatPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Concat::DataView input, ::webnn::mojom::ConcatPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Size2d::DataView,
                                         ::webnn::mojom::Size2dPtr> {
  static bool IsNull(const ::webnn::mojom::Size2dPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::Size2dPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Size2d::height) height(
      const ::webnn::mojom::Size2dPtr& input) {
    return input->height;
  }

  static decltype(::webnn::mojom::Size2d::width) width(
      const ::webnn::mojom::Size2dPtr& input) {
    return input->width;
  }

  static bool Read(::webnn::mojom::Size2d::DataView input, ::webnn::mojom::Size2dPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Padding2d::DataView,
                                         ::webnn::mojom::Padding2dPtr> {
  static bool IsNull(const ::webnn::mojom::Padding2dPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::Padding2dPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Padding2d::beginning)& beginning(
      const ::webnn::mojom::Padding2dPtr& input) {
    return input->beginning;
  }

  static const decltype(::webnn::mojom::Padding2d::ending)& ending(
      const ::webnn::mojom::Padding2dPtr& input) {
    return input->ending;
  }

  static bool Read(::webnn::mojom::Padding2d::DataView input, ::webnn::mojom::Padding2dPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Conv2d::DataView,
                                         ::webnn::mojom::Conv2dPtr> {
  static bool IsNull(const ::webnn::mojom::Conv2dPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::Conv2dPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Conv2d::kind) kind(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::Conv2d::input_operand_id)& input_operand_id(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Conv2d::filter_operand_id)& filter_operand_id(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->filter_operand_id;
  }

  static const decltype(::webnn::mojom::Conv2d::output_operand_id)& output_operand_id(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Conv2d::padding)& padding(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->padding;
  }

  static const decltype(::webnn::mojom::Conv2d::strides)& strides(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->strides;
  }

  static const decltype(::webnn::mojom::Conv2d::dilations)& dilations(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->dilations;
  }

  static decltype(::webnn::mojom::Conv2d::groups) groups(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->groups;
  }

  static const decltype(::webnn::mojom::Conv2d::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::Conv2d::label)& label(
      const ::webnn::mojom::Conv2dPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Conv2d::DataView input, ::webnn::mojom::Conv2dPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::CumulativeSum::DataView,
                                         ::webnn::mojom::CumulativeSumPtr> {
  static bool IsNull(const ::webnn::mojom::CumulativeSumPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::CumulativeSumPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::CumulativeSum::input_operand_id)& input_operand_id(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::CumulativeSum::output_operand_id)& output_operand_id(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::CumulativeSum::axis) axis(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->axis;
  }

  static decltype(::webnn::mojom::CumulativeSum::exclusive) exclusive(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->exclusive;
  }

  static decltype(::webnn::mojom::CumulativeSum::reversed) reversed(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->reversed;
  }

  static const decltype(::webnn::mojom::CumulativeSum::label)& label(
      const ::webnn::mojom::CumulativeSumPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::CumulativeSum::DataView input, ::webnn::mojom::CumulativeSumPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::DequantizeLinear::DataView,
                                         ::webnn::mojom::DequantizeLinearPtr> {
  static bool IsNull(const ::webnn::mojom::DequantizeLinearPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::DequantizeLinearPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::DequantizeLinear::input_operand_id)& input_operand_id(
      const ::webnn::mojom::DequantizeLinearPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::DequantizeLinear::scale_operand_id)& scale_operand_id(
      const ::webnn::mojom::DequantizeLinearPtr& input) {
    return input->scale_operand_id;
  }

  static const decltype(::webnn::mojom::DequantizeLinear::zero_point_operand_id)& zero_point_operand_id(
      const ::webnn::mojom::DequantizeLinearPtr& input) {
    return input->zero_point_operand_id;
  }

  static const decltype(::webnn::mojom::DequantizeLinear::output_operand_id)& output_operand_id(
      const ::webnn::mojom::DequantizeLinearPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::DequantizeLinear::label)& label(
      const ::webnn::mojom::DequantizeLinearPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::DequantizeLinear::DataView input, ::webnn::mojom::DequantizeLinearPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ElementWiseBinary::DataView,
                                         ::webnn::mojom::ElementWiseBinaryPtr> {
  static bool IsNull(const ::webnn::mojom::ElementWiseBinaryPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ElementWiseBinaryPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::ElementWiseBinary::kind) kind(
      const ::webnn::mojom::ElementWiseBinaryPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::ElementWiseBinary::lhs_operand_id)& lhs_operand_id(
      const ::webnn::mojom::ElementWiseBinaryPtr& input) {
    return input->lhs_operand_id;
  }

  static const decltype(::webnn::mojom::ElementWiseBinary::rhs_operand_id)& rhs_operand_id(
      const ::webnn::mojom::ElementWiseBinaryPtr& input) {
    return input->rhs_operand_id;
  }

  static const decltype(::webnn::mojom::ElementWiseBinary::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ElementWiseBinaryPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::ElementWiseBinary::label)& label(
      const ::webnn::mojom::ElementWiseBinaryPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::ElementWiseBinary::DataView input, ::webnn::mojom::ElementWiseBinaryPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ElementWiseUnary::DataView,
                                         ::webnn::mojom::ElementWiseUnaryPtr> {
  static bool IsNull(const ::webnn::mojom::ElementWiseUnaryPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ElementWiseUnaryPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::ElementWiseUnary::kind) kind(
      const ::webnn::mojom::ElementWiseUnaryPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::ElementWiseUnary::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ElementWiseUnaryPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::ElementWiseUnary::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ElementWiseUnaryPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::ElementWiseUnary::label)& label(
      const ::webnn::mojom::ElementWiseUnaryPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::ElementWiseUnary::DataView input, ::webnn::mojom::ElementWiseUnaryPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Expand::DataView,
                                         ::webnn::mojom::ExpandPtr> {
  static bool IsNull(const ::webnn::mojom::ExpandPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ExpandPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Expand::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ExpandPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Expand::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ExpandPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Expand::label)& label(
      const ::webnn::mojom::ExpandPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Expand::DataView input, ::webnn::mojom::ExpandPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ConstantPadding::DataView,
                                         ::webnn::mojom::ConstantPaddingPtr> {
  static bool IsNull(const ::webnn::mojom::ConstantPaddingPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ConstantPaddingPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::ConstantPadding::value)& value(
      const ::webnn::mojom::ConstantPaddingPtr& input) {
    return input->value;
  }

  static bool Read(::webnn::mojom::ConstantPadding::DataView input, ::webnn::mojom::ConstantPaddingPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::EdgePadding::DataView,
                                         ::webnn::mojom::EdgePaddingPtr> {
  static bool IsNull(const ::webnn::mojom::EdgePaddingPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::EdgePaddingPtr* output) { output->reset(); }

  static bool Read(::webnn::mojom::EdgePadding::DataView input, ::webnn::mojom::EdgePaddingPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ReflectionPadding::DataView,
                                         ::webnn::mojom::ReflectionPaddingPtr> {
  static bool IsNull(const ::webnn::mojom::ReflectionPaddingPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReflectionPaddingPtr* output) { output->reset(); }

  static bool Read(::webnn::mojom::ReflectionPadding::DataView input, ::webnn::mojom::ReflectionPaddingPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::InstanceNormalization::DataView,
                                         ::webnn::mojom::InstanceNormalizationPtr> {
  static bool IsNull(const ::webnn::mojom::InstanceNormalizationPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::InstanceNormalizationPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::InstanceNormalization::input_operand_id)& input_operand_id(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::InstanceNormalization::output_operand_id)& output_operand_id(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::InstanceNormalization::scale_operand_id)& scale_operand_id(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->scale_operand_id;
  }

  static const decltype(::webnn::mojom::InstanceNormalization::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->bias_operand_id;
  }

  static decltype(::webnn::mojom::InstanceNormalization::epsilon) epsilon(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->epsilon;
  }

  static const decltype(::webnn::mojom::InstanceNormalization::label)& label(
      const ::webnn::mojom::InstanceNormalizationPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::InstanceNormalization::DataView input, ::webnn::mojom::InstanceNormalizationPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Matmul::DataView,
                                         ::webnn::mojom::MatmulPtr> {
  static bool IsNull(const ::webnn::mojom::MatmulPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::MatmulPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Matmul::a_operand_id)& a_operand_id(
      const ::webnn::mojom::MatmulPtr& input) {
    return input->a_operand_id;
  }

  static const decltype(::webnn::mojom::Matmul::b_operand_id)& b_operand_id(
      const ::webnn::mojom::MatmulPtr& input) {
    return input->b_operand_id;
  }

  static const decltype(::webnn::mojom::Matmul::output_operand_id)& output_operand_id(
      const ::webnn::mojom::MatmulPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Matmul::label)& label(
      const ::webnn::mojom::MatmulPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Matmul::DataView input, ::webnn::mojom::MatmulPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Pad::DataView,
                                         ::webnn::mojom::PadPtr> {
  static bool IsNull(const ::webnn::mojom::PadPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::PadPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Pad::input_operand_id)& input_operand_id(
      const ::webnn::mojom::PadPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Pad::output_operand_id)& output_operand_id(
      const ::webnn::mojom::PadPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Pad::beginning_padding)& beginning_padding(
      const ::webnn::mojom::PadPtr& input) {
    return input->beginning_padding;
  }

  static const decltype(::webnn::mojom::Pad::ending_padding)& ending_padding(
      const ::webnn::mojom::PadPtr& input) {
    return input->ending_padding;
  }

  static const decltype(::webnn::mojom::Pad::mode)& mode(
      const ::webnn::mojom::PadPtr& input) {
    return input->mode;
  }

  static const decltype(::webnn::mojom::Pad::label)& label(
      const ::webnn::mojom::PadPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Pad::DataView input, ::webnn::mojom::PadPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Reduce::DataView,
                                         ::webnn::mojom::ReducePtr> {
  static bool IsNull(const ::webnn::mojom::ReducePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReducePtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Reduce::kind) kind(
      const ::webnn::mojom::ReducePtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::Reduce::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ReducePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Reduce::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ReducePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Reduce::axes)& axes(
      const ::webnn::mojom::ReducePtr& input) {
    return input->axes;
  }

  static decltype(::webnn::mojom::Reduce::keep_dimensions) keep_dimensions(
      const ::webnn::mojom::ReducePtr& input) {
    return input->keep_dimensions;
  }

  static const decltype(::webnn::mojom::Reduce::label)& label(
      const ::webnn::mojom::ReducePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Reduce::DataView input, ::webnn::mojom::ReducePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Pool2d::DataView,
                                         ::webnn::mojom::Pool2dPtr> {
  static bool IsNull(const ::webnn::mojom::Pool2dPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::Pool2dPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Pool2d::kind) kind(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->kind;
  }

  static const decltype(::webnn::mojom::Pool2d::input_operand_id)& input_operand_id(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Pool2d::output_operand_id)& output_operand_id(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Pool2d::window_dimensions)& window_dimensions(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->window_dimensions;
  }

  static const decltype(::webnn::mojom::Pool2d::padding)& padding(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->padding;
  }

  static const decltype(::webnn::mojom::Pool2d::strides)& strides(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->strides;
  }

  static const decltype(::webnn::mojom::Pool2d::dilations)& dilations(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->dilations;
  }

  static const decltype(::webnn::mojom::Pool2d::label)& label(
      const ::webnn::mojom::Pool2dPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Pool2d::DataView input, ::webnn::mojom::Pool2dPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Range::DataView,
                                         ::webnn::mojom::RangePtr> {
  static bool IsNull(const ::webnn::mojom::RangePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::RangePtr* output) { output->reset(); }

  static decltype(::webnn::mojom::Range::start) start(
      const ::webnn::mojom::RangePtr& input) {
    return input->start;
  }

  static decltype(::webnn::mojom::Range::size) size(
      const ::webnn::mojom::RangePtr& input) {
    return input->size;
  }

  static decltype(::webnn::mojom::Range::stride) stride(
      const ::webnn::mojom::RangePtr& input) {
    return input->stride;
  }

  static bool Read(::webnn::mojom::Range::DataView input, ::webnn::mojom::RangePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Slice::DataView,
                                         ::webnn::mojom::SlicePtr> {
  static bool IsNull(const ::webnn::mojom::SlicePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SlicePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Slice::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SlicePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Slice::output_operand_id)& output_operand_id(
      const ::webnn::mojom::SlicePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Slice::ranges)& ranges(
      const ::webnn::mojom::SlicePtr& input) {
    return input->ranges;
  }

  static const decltype(::webnn::mojom::Slice::label)& label(
      const ::webnn::mojom::SlicePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Slice::DataView input, ::webnn::mojom::SlicePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Elu::DataView,
                                         ::webnn::mojom::EluPtr> {
  static bool IsNull(const ::webnn::mojom::EluPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::EluPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Elu::input_operand_id)& input_operand_id(
      const ::webnn::mojom::EluPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Elu::output_operand_id)& output_operand_id(
      const ::webnn::mojom::EluPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Elu::alpha) alpha(
      const ::webnn::mojom::EluPtr& input) {
    return input->alpha;
  }

  static const decltype(::webnn::mojom::Elu::label)& label(
      const ::webnn::mojom::EluPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Elu::DataView input, ::webnn::mojom::EluPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Gather::DataView,
                                         ::webnn::mojom::GatherPtr> {
  static bool IsNull(const ::webnn::mojom::GatherPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GatherPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Gather::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GatherPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Gather::indices_operand_id)& indices_operand_id(
      const ::webnn::mojom::GatherPtr& input) {
    return input->indices_operand_id;
  }

  static const decltype(::webnn::mojom::Gather::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GatherPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Gather::axis) axis(
      const ::webnn::mojom::GatherPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::Gather::label)& label(
      const ::webnn::mojom::GatherPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Gather::DataView input, ::webnn::mojom::GatherPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::GatherElements::DataView,
                                         ::webnn::mojom::GatherElementsPtr> {
  static bool IsNull(const ::webnn::mojom::GatherElementsPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GatherElementsPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::GatherElements::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GatherElementsPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::GatherElements::indices_operand_id)& indices_operand_id(
      const ::webnn::mojom::GatherElementsPtr& input) {
    return input->indices_operand_id;
  }

  static const decltype(::webnn::mojom::GatherElements::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GatherElementsPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::GatherElements::axis) axis(
      const ::webnn::mojom::GatherElementsPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::GatherElements::label)& label(
      const ::webnn::mojom::GatherElementsPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::GatherElements::DataView input, ::webnn::mojom::GatherElementsPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::GatherND::DataView,
                                         ::webnn::mojom::GatherNDPtr> {
  static bool IsNull(const ::webnn::mojom::GatherNDPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GatherNDPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::GatherND::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GatherNDPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::GatherND::indices_operand_id)& indices_operand_id(
      const ::webnn::mojom::GatherNDPtr& input) {
    return input->indices_operand_id;
  }

  static const decltype(::webnn::mojom::GatherND::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GatherNDPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::GatherND::label)& label(
      const ::webnn::mojom::GatherNDPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::GatherND::DataView input, ::webnn::mojom::GatherNDPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Gelu::DataView,
                                         ::webnn::mojom::GeluPtr> {
  static bool IsNull(const ::webnn::mojom::GeluPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GeluPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Gelu::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GeluPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Gelu::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GeluPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Gelu::label)& label(
      const ::webnn::mojom::GeluPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Gelu::DataView input, ::webnn::mojom::GeluPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Gru::DataView,
                                         ::webnn::mojom::GruPtr> {
  static bool IsNull(const ::webnn::mojom::GruPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GruPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Gru::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Gru::weight_operand_id)& weight_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->weight_operand_id;
  }

  static const decltype(::webnn::mojom::Gru::recurrent_weight_operand_id)& recurrent_weight_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->recurrent_weight_operand_id;
  }

  static decltype(::webnn::mojom::Gru::steps) steps(
      const ::webnn::mojom::GruPtr& input) {
    return input->steps;
  }

  static decltype(::webnn::mojom::Gru::hidden_size) hidden_size(
      const ::webnn::mojom::GruPtr& input) {
    return input->hidden_size;
  }

  static const decltype(::webnn::mojom::Gru::output_operand_ids)& output_operand_ids(
      const ::webnn::mojom::GruPtr& input) {
    return input->output_operand_ids;
  }

  static const decltype(::webnn::mojom::Gru::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::Gru::recurrent_bias_operand_id)& recurrent_bias_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->recurrent_bias_operand_id;
  }

  static const decltype(::webnn::mojom::Gru::initial_hidden_state_operand_id)& initial_hidden_state_operand_id(
      const ::webnn::mojom::GruPtr& input) {
    return input->initial_hidden_state_operand_id;
  }

  static decltype(::webnn::mojom::Gru::reset_after) reset_after(
      const ::webnn::mojom::GruPtr& input) {
    return input->reset_after;
  }

  static decltype(::webnn::mojom::Gru::return_sequence) return_sequence(
      const ::webnn::mojom::GruPtr& input) {
    return input->return_sequence;
  }

  static decltype(::webnn::mojom::Gru::direction) direction(
      const ::webnn::mojom::GruPtr& input) {
    return input->direction;
  }

  static decltype(::webnn::mojom::Gru::layout) layout(
      const ::webnn::mojom::GruPtr& input) {
    return input->layout;
  }

  static const decltype(::webnn::mojom::Gru::activations)& activations(
      const ::webnn::mojom::GruPtr& input) {
    return input->activations;
  }

  static const decltype(::webnn::mojom::Gru::label)& label(
      const ::webnn::mojom::GruPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Gru::DataView input, ::webnn::mojom::GruPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::GruCell::DataView,
                                         ::webnn::mojom::GruCellPtr> {
  static bool IsNull(const ::webnn::mojom::GruCellPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GruCellPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::GruCell::input_operand_id)& input_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::GruCell::weight_operand_id)& weight_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->weight_operand_id;
  }

  static const decltype(::webnn::mojom::GruCell::recurrent_weight_operand_id)& recurrent_weight_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->recurrent_weight_operand_id;
  }

  static const decltype(::webnn::mojom::GruCell::hidden_state_operand_id)& hidden_state_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->hidden_state_operand_id;
  }

  static decltype(::webnn::mojom::GruCell::hidden_size) hidden_size(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->hidden_size;
  }

  static const decltype(::webnn::mojom::GruCell::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::GruCell::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::GruCell::recurrent_bias_operand_id)& recurrent_bias_operand_id(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->recurrent_bias_operand_id;
  }

  static decltype(::webnn::mojom::GruCell::reset_after) reset_after(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->reset_after;
  }

  static decltype(::webnn::mojom::GruCell::layout) layout(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->layout;
  }

  static const decltype(::webnn::mojom::GruCell::activations)& activations(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->activations;
  }

  static const decltype(::webnn::mojom::GruCell::label)& label(
      const ::webnn::mojom::GruCellPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::GruCell::DataView input, ::webnn::mojom::GruCellPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Gemm::DataView,
                                         ::webnn::mojom::GemmPtr> {
  static bool IsNull(const ::webnn::mojom::GemmPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GemmPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Gemm::a_operand_id)& a_operand_id(
      const ::webnn::mojom::GemmPtr& input) {
    return input->a_operand_id;
  }

  static const decltype(::webnn::mojom::Gemm::b_operand_id)& b_operand_id(
      const ::webnn::mojom::GemmPtr& input) {
    return input->b_operand_id;
  }

  static const decltype(::webnn::mojom::Gemm::output_operand_id)& output_operand_id(
      const ::webnn::mojom::GemmPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Gemm::c_operand_id)& c_operand_id(
      const ::webnn::mojom::GemmPtr& input) {
    return input->c_operand_id;
  }

  static decltype(::webnn::mojom::Gemm::alpha) alpha(
      const ::webnn::mojom::GemmPtr& input) {
    return input->alpha;
  }

  static decltype(::webnn::mojom::Gemm::beta) beta(
      const ::webnn::mojom::GemmPtr& input) {
    return input->beta;
  }

  static decltype(::webnn::mojom::Gemm::a_transpose) a_transpose(
      const ::webnn::mojom::GemmPtr& input) {
    return input->a_transpose;
  }

  static decltype(::webnn::mojom::Gemm::b_transpose) b_transpose(
      const ::webnn::mojom::GemmPtr& input) {
    return input->b_transpose;
  }

  static const decltype(::webnn::mojom::Gemm::label)& label(
      const ::webnn::mojom::GemmPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Gemm::DataView input, ::webnn::mojom::GemmPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::HardSigmoid::DataView,
                                         ::webnn::mojom::HardSigmoidPtr> {
  static bool IsNull(const ::webnn::mojom::HardSigmoidPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::HardSigmoidPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::HardSigmoid::input_operand_id)& input_operand_id(
      const ::webnn::mojom::HardSigmoidPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::HardSigmoid::output_operand_id)& output_operand_id(
      const ::webnn::mojom::HardSigmoidPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::HardSigmoid::alpha) alpha(
      const ::webnn::mojom::HardSigmoidPtr& input) {
    return input->alpha;
  }

  static decltype(::webnn::mojom::HardSigmoid::beta) beta(
      const ::webnn::mojom::HardSigmoidPtr& input) {
    return input->beta;
  }

  static const decltype(::webnn::mojom::HardSigmoid::label)& label(
      const ::webnn::mojom::HardSigmoidPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::HardSigmoid::DataView input, ::webnn::mojom::HardSigmoidPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::HardSwish::DataView,
                                         ::webnn::mojom::HardSwishPtr> {
  static bool IsNull(const ::webnn::mojom::HardSwishPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::HardSwishPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::HardSwish::input_operand_id)& input_operand_id(
      const ::webnn::mojom::HardSwishPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::HardSwish::output_operand_id)& output_operand_id(
      const ::webnn::mojom::HardSwishPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::HardSwish::label)& label(
      const ::webnn::mojom::HardSwishPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::HardSwish::DataView input, ::webnn::mojom::HardSwishPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::LayerNormalization::DataView,
                                         ::webnn::mojom::LayerNormalizationPtr> {
  static bool IsNull(const ::webnn::mojom::LayerNormalizationPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::LayerNormalizationPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::LayerNormalization::input_operand_id)& input_operand_id(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::LayerNormalization::output_operand_id)& output_operand_id(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::LayerNormalization::scale_operand_id)& scale_operand_id(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->scale_operand_id;
  }

  static const decltype(::webnn::mojom::LayerNormalization::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::LayerNormalization::axes)& axes(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->axes;
  }

  static decltype(::webnn::mojom::LayerNormalization::epsilon) epsilon(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->epsilon;
  }

  static const decltype(::webnn::mojom::LayerNormalization::label)& label(
      const ::webnn::mojom::LayerNormalizationPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::LayerNormalization::DataView input, ::webnn::mojom::LayerNormalizationPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::LeakyRelu::DataView,
                                         ::webnn::mojom::LeakyReluPtr> {
  static bool IsNull(const ::webnn::mojom::LeakyReluPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::LeakyReluPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::LeakyRelu::input_operand_id)& input_operand_id(
      const ::webnn::mojom::LeakyReluPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::LeakyRelu::output_operand_id)& output_operand_id(
      const ::webnn::mojom::LeakyReluPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::LeakyRelu::alpha) alpha(
      const ::webnn::mojom::LeakyReluPtr& input) {
    return input->alpha;
  }

  static const decltype(::webnn::mojom::LeakyRelu::label)& label(
      const ::webnn::mojom::LeakyReluPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::LeakyRelu::DataView input, ::webnn::mojom::LeakyReluPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Linear::DataView,
                                         ::webnn::mojom::LinearPtr> {
  static bool IsNull(const ::webnn::mojom::LinearPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::LinearPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Linear::input_operand_id)& input_operand_id(
      const ::webnn::mojom::LinearPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Linear::output_operand_id)& output_operand_id(
      const ::webnn::mojom::LinearPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Linear::alpha) alpha(
      const ::webnn::mojom::LinearPtr& input) {
    return input->alpha;
  }

  static decltype(::webnn::mojom::Linear::beta) beta(
      const ::webnn::mojom::LinearPtr& input) {
    return input->beta;
  }

  static const decltype(::webnn::mojom::Linear::label)& label(
      const ::webnn::mojom::LinearPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Linear::DataView input, ::webnn::mojom::LinearPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Lstm::DataView,
                                         ::webnn::mojom::LstmPtr> {
  static bool IsNull(const ::webnn::mojom::LstmPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::LstmPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Lstm::input_operand_id)& input_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::weight_operand_id)& weight_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->weight_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::recurrent_weight_operand_id)& recurrent_weight_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->recurrent_weight_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::output_operand_ids)& output_operand_ids(
      const ::webnn::mojom::LstmPtr& input) {
    return input->output_operand_ids;
  }

  static decltype(::webnn::mojom::Lstm::steps) steps(
      const ::webnn::mojom::LstmPtr& input) {
    return input->steps;
  }

  static decltype(::webnn::mojom::Lstm::hidden_size) hidden_size(
      const ::webnn::mojom::LstmPtr& input) {
    return input->hidden_size;
  }

  static const decltype(::webnn::mojom::Lstm::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::recurrent_bias_operand_id)& recurrent_bias_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->recurrent_bias_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::peephole_weight_operand_id)& peephole_weight_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->peephole_weight_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::initial_hidden_state_operand_id)& initial_hidden_state_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->initial_hidden_state_operand_id;
  }

  static const decltype(::webnn::mojom::Lstm::initial_cell_state_operand_id)& initial_cell_state_operand_id(
      const ::webnn::mojom::LstmPtr& input) {
    return input->initial_cell_state_operand_id;
  }

  static decltype(::webnn::mojom::Lstm::return_sequence) return_sequence(
      const ::webnn::mojom::LstmPtr& input) {
    return input->return_sequence;
  }

  static decltype(::webnn::mojom::Lstm::direction) direction(
      const ::webnn::mojom::LstmPtr& input) {
    return input->direction;
  }

  static decltype(::webnn::mojom::Lstm::layout) layout(
      const ::webnn::mojom::LstmPtr& input) {
    return input->layout;
  }

  static const decltype(::webnn::mojom::Lstm::activations)& activations(
      const ::webnn::mojom::LstmPtr& input) {
    return input->activations;
  }

  static const decltype(::webnn::mojom::Lstm::label)& label(
      const ::webnn::mojom::LstmPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Lstm::DataView input, ::webnn::mojom::LstmPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::LstmCell::DataView,
                                         ::webnn::mojom::LstmCellPtr> {
  static bool IsNull(const ::webnn::mojom::LstmCellPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::LstmCellPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::LstmCell::input_operand_id)& input_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::weight_operand_id)& weight_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->weight_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::recurrent_weight_operand_id)& recurrent_weight_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->recurrent_weight_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::hidden_state_operand_id)& hidden_state_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->hidden_state_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::cell_state_operand_id)& cell_state_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->cell_state_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::output_operand_ids)& output_operand_ids(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->output_operand_ids;
  }

  static decltype(::webnn::mojom::LstmCell::hidden_size) hidden_size(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->hidden_size;
  }

  static const decltype(::webnn::mojom::LstmCell::bias_operand_id)& bias_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->bias_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::recurrent_bias_operand_id)& recurrent_bias_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->recurrent_bias_operand_id;
  }

  static const decltype(::webnn::mojom::LstmCell::peephole_weight_operand_id)& peephole_weight_operand_id(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->peephole_weight_operand_id;
  }

  static decltype(::webnn::mojom::LstmCell::layout) layout(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->layout;
  }

  static const decltype(::webnn::mojom::LstmCell::activations)& activations(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->activations;
  }

  static const decltype(::webnn::mojom::LstmCell::label)& label(
      const ::webnn::mojom::LstmCellPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::LstmCell::DataView input, ::webnn::mojom::LstmCellPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Prelu::DataView,
                                         ::webnn::mojom::PreluPtr> {
  static bool IsNull(const ::webnn::mojom::PreluPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::PreluPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Prelu::input_operand_id)& input_operand_id(
      const ::webnn::mojom::PreluPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Prelu::slope_operand_id)& slope_operand_id(
      const ::webnn::mojom::PreluPtr& input) {
    return input->slope_operand_id;
  }

  static const decltype(::webnn::mojom::Prelu::output_operand_id)& output_operand_id(
      const ::webnn::mojom::PreluPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Prelu::label)& label(
      const ::webnn::mojom::PreluPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Prelu::DataView input, ::webnn::mojom::PreluPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::QuantizeLinear::DataView,
                                         ::webnn::mojom::QuantizeLinearPtr> {
  static bool IsNull(const ::webnn::mojom::QuantizeLinearPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::QuantizeLinearPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::QuantizeLinear::input_operand_id)& input_operand_id(
      const ::webnn::mojom::QuantizeLinearPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::QuantizeLinear::scale_operand_id)& scale_operand_id(
      const ::webnn::mojom::QuantizeLinearPtr& input) {
    return input->scale_operand_id;
  }

  static const decltype(::webnn::mojom::QuantizeLinear::zero_point_operand_id)& zero_point_operand_id(
      const ::webnn::mojom::QuantizeLinearPtr& input) {
    return input->zero_point_operand_id;
  }

  static const decltype(::webnn::mojom::QuantizeLinear::output_operand_id)& output_operand_id(
      const ::webnn::mojom::QuantizeLinearPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::QuantizeLinear::label)& label(
      const ::webnn::mojom::QuantizeLinearPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::QuantizeLinear::DataView input, ::webnn::mojom::QuantizeLinearPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Relu::DataView,
                                         ::webnn::mojom::ReluPtr> {
  static bool IsNull(const ::webnn::mojom::ReluPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReluPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Relu::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ReluPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Relu::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ReluPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Relu::label)& label(
      const ::webnn::mojom::ReluPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Relu::DataView input, ::webnn::mojom::ReluPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Reshape::DataView,
                                         ::webnn::mojom::ReshapePtr> {
  static bool IsNull(const ::webnn::mojom::ReshapePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReshapePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Reshape::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ReshapePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Reshape::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ReshapePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Reshape::label)& label(
      const ::webnn::mojom::ReshapePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Reshape::DataView input, ::webnn::mojom::ReshapePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Reverse::DataView,
                                         ::webnn::mojom::ReversePtr> {
  static bool IsNull(const ::webnn::mojom::ReversePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ReversePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Reverse::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ReversePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Reverse::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ReversePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Reverse::axes)& axes(
      const ::webnn::mojom::ReversePtr& input) {
    return input->axes;
  }

  static const decltype(::webnn::mojom::Reverse::label)& label(
      const ::webnn::mojom::ReversePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Reverse::DataView input, ::webnn::mojom::ReversePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ScatterElements::DataView,
                                         ::webnn::mojom::ScatterElementsPtr> {
  static bool IsNull(const ::webnn::mojom::ScatterElementsPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ScatterElementsPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::ScatterElements::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterElements::indices_operand_id)& indices_operand_id(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->indices_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterElements::updates_operand_id)& updates_operand_id(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->updates_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterElements::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::ScatterElements::axis) axis(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::ScatterElements::label)& label(
      const ::webnn::mojom::ScatterElementsPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::ScatterElements::DataView input, ::webnn::mojom::ScatterElementsPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::ScatterND::DataView,
                                         ::webnn::mojom::ScatterNDPtr> {
  static bool IsNull(const ::webnn::mojom::ScatterNDPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::ScatterNDPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::ScatterND::input_operand_id)& input_operand_id(
      const ::webnn::mojom::ScatterNDPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterND::indices_operand_id)& indices_operand_id(
      const ::webnn::mojom::ScatterNDPtr& input) {
    return input->indices_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterND::updates_operand_id)& updates_operand_id(
      const ::webnn::mojom::ScatterNDPtr& input) {
    return input->updates_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterND::output_operand_id)& output_operand_id(
      const ::webnn::mojom::ScatterNDPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::ScatterND::label)& label(
      const ::webnn::mojom::ScatterNDPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::ScatterND::DataView input, ::webnn::mojom::ScatterNDPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Sigmoid::DataView,
                                         ::webnn::mojom::SigmoidPtr> {
  static bool IsNull(const ::webnn::mojom::SigmoidPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SigmoidPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Sigmoid::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SigmoidPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Sigmoid::output_operand_id)& output_operand_id(
      const ::webnn::mojom::SigmoidPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Sigmoid::label)& label(
      const ::webnn::mojom::SigmoidPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Sigmoid::DataView input, ::webnn::mojom::SigmoidPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Softmax::DataView,
                                         ::webnn::mojom::SoftmaxPtr> {
  static bool IsNull(const ::webnn::mojom::SoftmaxPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SoftmaxPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Softmax::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SoftmaxPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Softmax::output_operand_id)& output_operand_id(
      const ::webnn::mojom::SoftmaxPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Softmax::axis) axis(
      const ::webnn::mojom::SoftmaxPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::Softmax::label)& label(
      const ::webnn::mojom::SoftmaxPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Softmax::DataView input, ::webnn::mojom::SoftmaxPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Softplus::DataView,
                                         ::webnn::mojom::SoftplusPtr> {
  static bool IsNull(const ::webnn::mojom::SoftplusPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SoftplusPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Softplus::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SoftplusPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Softplus::output_operand_id)& output_operand_id(
      const ::webnn::mojom::SoftplusPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Softplus::label)& label(
      const ::webnn::mojom::SoftplusPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Softplus::DataView input, ::webnn::mojom::SoftplusPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Softsign::DataView,
                                         ::webnn::mojom::SoftsignPtr> {
  static bool IsNull(const ::webnn::mojom::SoftsignPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SoftsignPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Softsign::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SoftsignPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Softsign::output_operand_id)& output_operand_id(
      const ::webnn::mojom::SoftsignPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Softsign::label)& label(
      const ::webnn::mojom::SoftsignPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Softsign::DataView input, ::webnn::mojom::SoftsignPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Split::DataView,
                                         ::webnn::mojom::SplitPtr> {
  static bool IsNull(const ::webnn::mojom::SplitPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::SplitPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Split::input_operand_id)& input_operand_id(
      const ::webnn::mojom::SplitPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Split::output_operand_ids)& output_operand_ids(
      const ::webnn::mojom::SplitPtr& input) {
    return input->output_operand_ids;
  }

  static decltype(::webnn::mojom::Split::axis) axis(
      const ::webnn::mojom::SplitPtr& input) {
    return input->axis;
  }

  static const decltype(::webnn::mojom::Split::label)& label(
      const ::webnn::mojom::SplitPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Split::DataView input, ::webnn::mojom::SplitPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Tanh::DataView,
                                         ::webnn::mojom::TanhPtr> {
  static bool IsNull(const ::webnn::mojom::TanhPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TanhPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Tanh::input_operand_id)& input_operand_id(
      const ::webnn::mojom::TanhPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Tanh::output_operand_id)& output_operand_id(
      const ::webnn::mojom::TanhPtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Tanh::label)& label(
      const ::webnn::mojom::TanhPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Tanh::DataView input, ::webnn::mojom::TanhPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Tile::DataView,
                                         ::webnn::mojom::TilePtr> {
  static bool IsNull(const ::webnn::mojom::TilePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TilePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Tile::input_operand_id)& input_operand_id(
      const ::webnn::mojom::TilePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Tile::output_operand_id)& output_operand_id(
      const ::webnn::mojom::TilePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Tile::repetitions)& repetitions(
      const ::webnn::mojom::TilePtr& input) {
    return input->repetitions;
  }

  static const decltype(::webnn::mojom::Tile::label)& label(
      const ::webnn::mojom::TilePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Tile::DataView input, ::webnn::mojom::TilePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Transpose::DataView,
                                         ::webnn::mojom::TransposePtr> {
  static bool IsNull(const ::webnn::mojom::TransposePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TransposePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Transpose::input_operand_id)& input_operand_id(
      const ::webnn::mojom::TransposePtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Transpose::output_operand_id)& output_operand_id(
      const ::webnn::mojom::TransposePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Transpose::permutation)& permutation(
      const ::webnn::mojom::TransposePtr& input) {
    return input->permutation;
  }

  static const decltype(::webnn::mojom::Transpose::label)& label(
      const ::webnn::mojom::TransposePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Transpose::DataView input, ::webnn::mojom::TransposePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Triangular::DataView,
                                         ::webnn::mojom::TriangularPtr> {
  static bool IsNull(const ::webnn::mojom::TriangularPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::TriangularPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Triangular::input_operand_id)& input_operand_id(
      const ::webnn::mojom::TriangularPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Triangular::output_operand_id)& output_operand_id(
      const ::webnn::mojom::TriangularPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Triangular::upper) upper(
      const ::webnn::mojom::TriangularPtr& input) {
    return input->upper;
  }

  static decltype(::webnn::mojom::Triangular::diagonal) diagonal(
      const ::webnn::mojom::TriangularPtr& input) {
    return input->diagonal;
  }

  static const decltype(::webnn::mojom::Triangular::label)& label(
      const ::webnn::mojom::TriangularPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Triangular::DataView input, ::webnn::mojom::TriangularPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Resample2d::DataView,
                                         ::webnn::mojom::Resample2dPtr> {
  static bool IsNull(const ::webnn::mojom::Resample2dPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::Resample2dPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Resample2d::input_operand_id)& input_operand_id(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->input_operand_id;
  }

  static const decltype(::webnn::mojom::Resample2d::output_operand_id)& output_operand_id(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->output_operand_id;
  }

  static decltype(::webnn::mojom::Resample2d::mode) mode(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->mode;
  }

  static const decltype(::webnn::mojom::Resample2d::scales)& scales(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->scales;
  }

  static const decltype(::webnn::mojom::Resample2d::axes)& axes(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->axes;
  }

  static const decltype(::webnn::mojom::Resample2d::label)& label(
      const ::webnn::mojom::Resample2dPtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Resample2d::DataView input, ::webnn::mojom::Resample2dPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::Where::DataView,
                                         ::webnn::mojom::WherePtr> {
  static bool IsNull(const ::webnn::mojom::WherePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::WherePtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::Where::condition_operand_id)& condition_operand_id(
      const ::webnn::mojom::WherePtr& input) {
    return input->condition_operand_id;
  }

  static const decltype(::webnn::mojom::Where::true_value_operand_id)& true_value_operand_id(
      const ::webnn::mojom::WherePtr& input) {
    return input->true_value_operand_id;
  }

  static const decltype(::webnn::mojom::Where::false_value_operand_id)& false_value_operand_id(
      const ::webnn::mojom::WherePtr& input) {
    return input->false_value_operand_id;
  }

  static const decltype(::webnn::mojom::Where::output_operand_id)& output_operand_id(
      const ::webnn::mojom::WherePtr& input) {
    return input->output_operand_id;
  }

  static const decltype(::webnn::mojom::Where::label)& label(
      const ::webnn::mojom::WherePtr& input) {
    return input->label;
  }

  static bool Read(::webnn::mojom::Where::DataView input, ::webnn::mojom::WherePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::GraphInfo::DataView,
                                         ::webnn::mojom::GraphInfoPtr> {
  static bool IsNull(const ::webnn::mojom::GraphInfoPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::GraphInfoPtr* output) { output->reset(); }

  static const decltype(::webnn::mojom::GraphInfo::operands)& operands(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->operands;
  }

  static const decltype(::webnn::mojom::GraphInfo::input_operands)& input_operands(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->input_operands;
  }

  static const decltype(::webnn::mojom::GraphInfo::output_operands)& output_operands(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->output_operands;
  }

  static const decltype(::webnn::mojom::GraphInfo::operations)& operations(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->operations;
  }

  static const decltype(::webnn::mojom::GraphInfo::constant_operand_ids_to_handles)& constant_operand_ids_to_handles(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->constant_operand_ids_to_handles;
  }

  static const decltype(::webnn::mojom::GraphInfo::id_to_constant_tensor_operand_map)& id_to_constant_tensor_operand_map(
      const ::webnn::mojom::GraphInfoPtr& input) {
    return input->id_to_constant_tensor_operand_map;
  }

  static bool Read(::webnn::mojom::GraphInfo::DataView input, ::webnn::mojom::GraphInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::Number::DataView,
                                        ::webnn::mojom::NumberPtr> {
  static bool IsNull(const ::webnn::mojom::NumberPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::NumberPtr* output) { output->reset(); }

  static ::webnn::mojom::Number::Tag GetTag(const ::webnn::mojom::NumberPtr& input) {
    return input->which();
  }

  static  double floating_point(const ::webnn::mojom::NumberPtr& input) {
    return input->get_floating_point();
  }

  static  int64_t signed_integer(const ::webnn::mojom::NumberPtr& input) {
    return input->get_signed_integer();
  }

  static  uint64_t unsigned_integer(const ::webnn::mojom::NumberPtr& input) {
    return input->get_unsigned_integer();
  }

  static bool Read(::webnn::mojom::Number::DataView input, ::webnn::mojom::NumberPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::PaddingMode::DataView,
                                        ::webnn::mojom::PaddingModePtr> {
  static bool IsNull(const ::webnn::mojom::PaddingModePtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::PaddingModePtr* output) { output->reset(); }

  static ::webnn::mojom::PaddingMode::Tag GetTag(const ::webnn::mojom::PaddingModePtr& input) {
    return input->which();
  }

  static const ::webnn::mojom::ConstantPaddingPtr& constant(const ::webnn::mojom::PaddingModePtr& input) {
    return input->get_constant();
  }

  static const ::webnn::mojom::EdgePaddingPtr& edge(const ::webnn::mojom::PaddingModePtr& input) {
    return input->get_edge();
  }

  static const ::webnn::mojom::ReflectionPaddingPtr& reflection(const ::webnn::mojom::PaddingModePtr& input) {
    return input->get_reflection();
  }

  static bool Read(::webnn::mojom::PaddingMode::DataView input, ::webnn::mojom::PaddingModePtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::Operation::DataView,
                                        ::webnn::mojom::OperationPtr> {
  static bool IsNull(const ::webnn::mojom::OperationPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::OperationPtr* output) { output->reset(); }

  static ::webnn::mojom::Operation::Tag GetTag(const ::webnn::mojom::OperationPtr& input) {
    return input->which();
  }

  static const ::webnn::mojom::ArgMinMaxPtr& arg_min_max(const ::webnn::mojom::OperationPtr& input) {
    return input->get_arg_min_max();
  }

  static const ::webnn::mojom::BatchNormalizationPtr& batch_normalization(const ::webnn::mojom::OperationPtr& input) {
    return input->get_batch_normalization();
  }

  static const ::webnn::mojom::ClampPtr& clamp(const ::webnn::mojom::OperationPtr& input) {
    return input->get_clamp();
  }

  static const ::webnn::mojom::ConcatPtr& concat(const ::webnn::mojom::OperationPtr& input) {
    return input->get_concat();
  }

  static const ::webnn::mojom::Conv2dPtr& conv2d(const ::webnn::mojom::OperationPtr& input) {
    return input->get_conv2d();
  }

  static const ::webnn::mojom::CumulativeSumPtr& cumulative_sum(const ::webnn::mojom::OperationPtr& input) {
    return input->get_cumulative_sum();
  }

  static const ::webnn::mojom::DequantizeLinearPtr& dequantize_linear(const ::webnn::mojom::OperationPtr& input) {
    return input->get_dequantize_linear();
  }

  static const ::webnn::mojom::ElementWiseBinaryPtr& element_wise_binary(const ::webnn::mojom::OperationPtr& input) {
    return input->get_element_wise_binary();
  }

  static const ::webnn::mojom::EluPtr& elu(const ::webnn::mojom::OperationPtr& input) {
    return input->get_elu();
  }

  static const ::webnn::mojom::ElementWiseUnaryPtr& element_wise_unary(const ::webnn::mojom::OperationPtr& input) {
    return input->get_element_wise_unary();
  }

  static const ::webnn::mojom::ExpandPtr& expand(const ::webnn::mojom::OperationPtr& input) {
    return input->get_expand();
  }

  static const ::webnn::mojom::GatherPtr& gather(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gather();
  }

  static const ::webnn::mojom::GatherElementsPtr& gather_elements(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gather_elements();
  }

  static const ::webnn::mojom::GatherNDPtr& gather_nd(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gather_nd();
  }

  static const ::webnn::mojom::GeluPtr& gelu(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gelu();
  }

  static const ::webnn::mojom::GemmPtr& gemm(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gemm();
  }

  static const ::webnn::mojom::GruPtr& gru(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gru();
  }

  static const ::webnn::mojom::GruCellPtr& gru_cell(const ::webnn::mojom::OperationPtr& input) {
    return input->get_gru_cell();
  }

  static const ::webnn::mojom::HardSigmoidPtr& hard_sigmoid(const ::webnn::mojom::OperationPtr& input) {
    return input->get_hard_sigmoid();
  }

  static const ::webnn::mojom::HardSwishPtr& hard_swish(const ::webnn::mojom::OperationPtr& input) {
    return input->get_hard_swish();
  }

  static const ::webnn::mojom::LayerNormalizationPtr& layer_normalization(const ::webnn::mojom::OperationPtr& input) {
    return input->get_layer_normalization();
  }

  static const ::webnn::mojom::InstanceNormalizationPtr& instance_normalization(const ::webnn::mojom::OperationPtr& input) {
    return input->get_instance_normalization();
  }

  static const ::webnn::mojom::LeakyReluPtr& leaky_relu(const ::webnn::mojom::OperationPtr& input) {
    return input->get_leaky_relu();
  }

  static const ::webnn::mojom::LinearPtr& linear(const ::webnn::mojom::OperationPtr& input) {
    return input->get_linear();
  }

  static const ::webnn::mojom::LstmPtr& lstm(const ::webnn::mojom::OperationPtr& input) {
    return input->get_lstm();
  }

  static const ::webnn::mojom::LstmCellPtr& lstm_cell(const ::webnn::mojom::OperationPtr& input) {
    return input->get_lstm_cell();
  }

  static const ::webnn::mojom::MatmulPtr& matmul(const ::webnn::mojom::OperationPtr& input) {
    return input->get_matmul();
  }

  static const ::webnn::mojom::PadPtr& pad(const ::webnn::mojom::OperationPtr& input) {
    return input->get_pad();
  }

  static const ::webnn::mojom::Pool2dPtr& pool2d(const ::webnn::mojom::OperationPtr& input) {
    return input->get_pool2d();
  }

  static const ::webnn::mojom::PreluPtr& prelu(const ::webnn::mojom::OperationPtr& input) {
    return input->get_prelu();
  }

  static const ::webnn::mojom::QuantizeLinearPtr& quantize_linear(const ::webnn::mojom::OperationPtr& input) {
    return input->get_quantize_linear();
  }

  static const ::webnn::mojom::ReducePtr& reduce(const ::webnn::mojom::OperationPtr& input) {
    return input->get_reduce();
  }

  static const ::webnn::mojom::ReluPtr& relu(const ::webnn::mojom::OperationPtr& input) {
    return input->get_relu();
  }

  static const ::webnn::mojom::Resample2dPtr& resample2d(const ::webnn::mojom::OperationPtr& input) {
    return input->get_resample2d();
  }

  static const ::webnn::mojom::ReshapePtr& reshape(const ::webnn::mojom::OperationPtr& input) {
    return input->get_reshape();
  }

  static const ::webnn::mojom::ReversePtr& reverse(const ::webnn::mojom::OperationPtr& input) {
    return input->get_reverse();
  }

  static const ::webnn::mojom::ScatterElementsPtr& scatter_elements(const ::webnn::mojom::OperationPtr& input) {
    return input->get_scatter_elements();
  }

  static const ::webnn::mojom::ScatterNDPtr& scatter_nd(const ::webnn::mojom::OperationPtr& input) {
    return input->get_scatter_nd();
  }

  static const ::webnn::mojom::SigmoidPtr& sigmoid(const ::webnn::mojom::OperationPtr& input) {
    return input->get_sigmoid();
  }

  static const ::webnn::mojom::SlicePtr& slice(const ::webnn::mojom::OperationPtr& input) {
    return input->get_slice();
  }

  static const ::webnn::mojom::SoftmaxPtr& softmax(const ::webnn::mojom::OperationPtr& input) {
    return input->get_softmax();
  }

  static const ::webnn::mojom::SoftplusPtr& softplus(const ::webnn::mojom::OperationPtr& input) {
    return input->get_softplus();
  }

  static const ::webnn::mojom::SoftsignPtr& softsign(const ::webnn::mojom::OperationPtr& input) {
    return input->get_softsign();
  }

  static const ::webnn::mojom::SplitPtr& split(const ::webnn::mojom::OperationPtr& input) {
    return input->get_split();
  }

  static const ::webnn::mojom::TanhPtr& tanh(const ::webnn::mojom::OperationPtr& input) {
    return input->get_tanh();
  }

  static const ::webnn::mojom::TilePtr& tile(const ::webnn::mojom::OperationPtr& input) {
    return input->get_tile();
  }

  static const ::webnn::mojom::TransposePtr& transpose(const ::webnn::mojom::OperationPtr& input) {
    return input->get_transpose();
  }

  static const ::webnn::mojom::TriangularPtr& triangular(const ::webnn::mojom::OperationPtr& input) {
    return input->get_triangular();
  }

  static const ::webnn::mojom::WherePtr& where(const ::webnn::mojom::OperationPtr& input) {
    return input->get_where();
  }

  static bool Read(::webnn::mojom::Operation::DataView input, ::webnn::mojom::OperationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_H_