// services/webnn/public/mojom/webnn_graph.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-shared-internal.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/webnn/public/mojom/webnn_graph.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::webnn::mojom::DataType>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::DataType> {};

template <>
struct hash<::webnn::mojom::RecurrentNetworkActivation>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::RecurrentNetworkActivation> {};

template <>
struct hash<::webnn::mojom::RecurrentNetworkDirection>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::RecurrentNetworkDirection> {};

template <>
struct hash<::webnn::mojom::GruWeightLayout>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::GruWeightLayout> {};

template <>
struct hash<::webnn::mojom::LstmWeightLayout>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::LstmWeightLayout> {};

template <>
struct hash<::webnn::mojom::Operand_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::Operand_Kind> {};

template <>
struct hash<::webnn::mojom::ArgMinMax_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::ArgMinMax_Kind> {};

template <>
struct hash<::webnn::mojom::Conv2d_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::Conv2d_Kind> {};

template <>
struct hash<::webnn::mojom::ElementWiseBinary_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::ElementWiseBinary_Kind> {};

template <>
struct hash<::webnn::mojom::ElementWiseUnary_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::ElementWiseUnary_Kind> {};

template <>
struct hash<::webnn::mojom::Reduce_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::Reduce_Kind> {};

template <>
struct hash<::webnn::mojom::Pool2d_Kind>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::Pool2d_Kind> {};

template <>
struct hash<::webnn::mojom::Resample2d_InterpolationMode>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::Resample2d_InterpolationMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::DataType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::DataType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::DataType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::RecurrentNetworkActivation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::RecurrentNetworkActivation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::RecurrentNetworkActivation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::RecurrentNetworkDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::RecurrentNetworkDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::RecurrentNetworkDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GruWeightLayout, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::GruWeightLayout, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::GruWeightLayout>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LstmWeightLayout, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::LstmWeightLayout, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::LstmWeightLayout>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Operand_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::Operand_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::Operand_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ArgMinMax_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::ArgMinMax_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::ArgMinMax_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Conv2d_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::Conv2d_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::Conv2d_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ElementWiseBinary_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::ElementWiseBinary_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::ElementWiseBinary_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ElementWiseUnary_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::ElementWiseUnary_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::ElementWiseUnary_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Reduce_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::Reduce_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::Reduce_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Pool2d_Kind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::Pool2d_Kind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::Pool2d_Kind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Resample2d_InterpolationMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::Resample2d_InterpolationMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::Resample2d_InterpolationMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::OperandDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::OperandDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::OperandDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::DataType>(
      Traits::data_type(input),
      &fragment->data_type);

    decltype(Traits::shape(input)) in_shape = Traits::shape(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shape)::BaseType>
        shape_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_shape,
      shape_fragment,
      &shape_validate_params);

    fragment->shape.Set(
        shape_fragment.is_null() ? nullptr : shape_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shape.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shape in OperandDescriptor struct");

    decltype(Traits::pending_permutation(input)) in_pending_permutation = Traits::pending_permutation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pending_permutation)::BaseType>
        pending_permutation_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pending_permutation_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_pending_permutation,
      pending_permutation_fragment,
      &pending_permutation_validate_params);

    fragment->pending_permutation.Set(
        pending_permutation_fragment.is_null() ? nullptr : pending_permutation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pending_permutation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pending_permutation in OperandDescriptor struct");
  }

  static bool Deserialize(::webnn::mojom::internal::OperandDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::OperandDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::OperandIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::OperandIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::OperandId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::webnn::mojom::internal::OperandId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::OperandIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::OperandDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::OperandDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Operand_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::Operand_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandDescriptorDataView>(
      in_descriptor,
      descriptor_fragment);

    fragment->descriptor.Set(
        descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->descriptor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptor in Operand struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
  }

  static bool Deserialize(::webnn::mojom::internal::Operand_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::OperandDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ArgMinMaxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ArgMinMaxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ArgMinMax_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::ArgMinMax_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in ArgMinMax struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in ArgMinMax struct");

    fragment->axis = Traits::axis(input);

    fragment->keep_dimensions = Traits::keep_dimensions(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ArgMinMax struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ArgMinMax_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ArgMinMaxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::BatchNormalizationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::BatchNormalizationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::BatchNormalization_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in BatchNormalization struct");

    decltype(Traits::mean_operand_id(input)) in_mean_operand_id = Traits::mean_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mean_operand_id)::BaseType> mean_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_mean_operand_id,
      mean_operand_id_fragment);

    fragment->mean_operand_id.Set(
        mean_operand_id_fragment.is_null() ? nullptr : mean_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mean_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mean_operand_id in BatchNormalization struct");

    decltype(Traits::variance_operand_id(input)) in_variance_operand_id = Traits::variance_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->variance_operand_id)::BaseType> variance_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_variance_operand_id,
      variance_operand_id_fragment);

    fragment->variance_operand_id.Set(
        variance_operand_id_fragment.is_null() ? nullptr : variance_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->variance_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null variance_operand_id in BatchNormalization struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in BatchNormalization struct");

    decltype(Traits::scale_operand_id(input)) in_scale_operand_id = Traits::scale_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_operand_id)::BaseType> scale_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_scale_operand_id,
      scale_operand_id_fragment);

    fragment->scale_operand_id.Set(
        scale_operand_id_fragment.is_null() ? nullptr : scale_operand_id_fragment.data());

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    fragment->axis = Traits::axis(input);

    fragment->epsilon = Traits::epsilon(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in BatchNormalization struct");
  }

  static bool Deserialize(::webnn::mojom::internal::BatchNormalization_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::BatchNormalizationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ClampDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ClampDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Clamp_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Clamp struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Clamp struct");

    decltype(Traits::min_value(input)) in_min_value = Traits::min_value(input);
    mojo::internal::MessageFragment<decltype(fragment->min_value)>
        min_value_fragment(fragment.message());
    min_value_fragment.Claim(&fragment->min_value);
    
    mojo::internal::Serialize<::webnn::mojom::NumberDataView>(
      in_min_value,
      min_value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_value in Clamp struct");

    decltype(Traits::max_value(input)) in_max_value = Traits::max_value(input);
    mojo::internal::MessageFragment<decltype(fragment->max_value)>
        max_value_fragment(fragment.message());
    max_value_fragment.Claim(&fragment->max_value);
    
    mojo::internal::Serialize<::webnn::mojom::NumberDataView>(
      in_max_value,
      max_value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_value in Clamp struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Clamp struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Clamp_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ClampDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ConcatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ConcatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Concat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_ids(input)) in_input_operand_ids = Traits::input_operand_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_ids)::BaseType>
        input_operand_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_operand_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_input_operand_ids,
      input_operand_ids_fragment,
      &input_operand_ids_validate_params);

    fragment->input_operand_ids.Set(
        input_operand_ids_fragment.is_null() ? nullptr : input_operand_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_ids in Concat struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Concat struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Concat struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Concat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ConcatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Size2dDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::Size2dDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Size2d_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->height = Traits::height(input);

    fragment->width = Traits::width(input);
  }

  static bool Deserialize(::webnn::mojom::internal::Size2d_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::Size2dDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Padding2dDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::Padding2dDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Padding2d_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::beginning(input)) in_beginning = Traits::beginning(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->beginning)::BaseType> beginning_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_beginning,
      beginning_fragment);

    fragment->beginning.Set(
        beginning_fragment.is_null() ? nullptr : beginning_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->beginning.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null beginning in Padding2d struct");

    decltype(Traits::ending(input)) in_ending = Traits::ending(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ending)::BaseType> ending_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_ending,
      ending_fragment);

    fragment->ending.Set(
        ending_fragment.is_null() ? nullptr : ending_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ending.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ending in Padding2d struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Padding2d_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::Padding2dDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Conv2dDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::Conv2dDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Conv2d_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::Conv2d_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Conv2d struct");

    decltype(Traits::filter_operand_id(input)) in_filter_operand_id = Traits::filter_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filter_operand_id)::BaseType> filter_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_filter_operand_id,
      filter_operand_id_fragment);

    fragment->filter_operand_id.Set(
        filter_operand_id_fragment.is_null() ? nullptr : filter_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filter_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter_operand_id in Conv2d struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Conv2d struct");

    decltype(Traits::padding(input)) in_padding = Traits::padding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->padding)::BaseType> padding_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Padding2dDataView>(
      in_padding,
      padding_fragment);

    fragment->padding.Set(
        padding_fragment.is_null() ? nullptr : padding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->padding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null padding in Conv2d struct");

    decltype(Traits::strides(input)) in_strides = Traits::strides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->strides)::BaseType> strides_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_strides,
      strides_fragment);

    fragment->strides.Set(
        strides_fragment.is_null() ? nullptr : strides_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->strides.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null strides in Conv2d struct");

    decltype(Traits::dilations(input)) in_dilations = Traits::dilations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dilations)::BaseType> dilations_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_dilations,
      dilations_fragment);

    fragment->dilations.Set(
        dilations_fragment.is_null() ? nullptr : dilations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dilations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dilations in Conv2d struct");

    fragment->groups = Traits::groups(input);

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Conv2d struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Conv2d_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::Conv2dDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CumulativeSumDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CumulativeSumDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CumulativeSum_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in CumulativeSum struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in CumulativeSum struct");

    fragment->axis = Traits::axis(input);

    fragment->exclusive = Traits::exclusive(input);

    fragment->reversed = Traits::reversed(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in CumulativeSum struct");
  }

  static bool Deserialize(::webnn::mojom::internal::CumulativeSum_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CumulativeSumDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::DequantizeLinearDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::DequantizeLinearDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::DequantizeLinear_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in DequantizeLinear struct");

    decltype(Traits::scale_operand_id(input)) in_scale_operand_id = Traits::scale_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_operand_id)::BaseType> scale_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_scale_operand_id,
      scale_operand_id_fragment);

    fragment->scale_operand_id.Set(
        scale_operand_id_fragment.is_null() ? nullptr : scale_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scale_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scale_operand_id in DequantizeLinear struct");

    decltype(Traits::zero_point_operand_id(input)) in_zero_point_operand_id = Traits::zero_point_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->zero_point_operand_id)::BaseType> zero_point_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_zero_point_operand_id,
      zero_point_operand_id_fragment);

    fragment->zero_point_operand_id.Set(
        zero_point_operand_id_fragment.is_null() ? nullptr : zero_point_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->zero_point_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zero_point_operand_id in DequantizeLinear struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in DequantizeLinear struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in DequantizeLinear struct");
  }

  static bool Deserialize(::webnn::mojom::internal::DequantizeLinear_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::DequantizeLinearDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ElementWiseBinaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ElementWiseBinaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ElementWiseBinary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::ElementWiseBinary_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::lhs_operand_id(input)) in_lhs_operand_id = Traits::lhs_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lhs_operand_id)::BaseType> lhs_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_lhs_operand_id,
      lhs_operand_id_fragment);

    fragment->lhs_operand_id.Set(
        lhs_operand_id_fragment.is_null() ? nullptr : lhs_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lhs_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lhs_operand_id in ElementWiseBinary struct");

    decltype(Traits::rhs_operand_id(input)) in_rhs_operand_id = Traits::rhs_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rhs_operand_id)::BaseType> rhs_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_rhs_operand_id,
      rhs_operand_id_fragment);

    fragment->rhs_operand_id.Set(
        rhs_operand_id_fragment.is_null() ? nullptr : rhs_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rhs_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rhs_operand_id in ElementWiseBinary struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in ElementWiseBinary struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ElementWiseBinary struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ElementWiseBinary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ElementWiseBinaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ElementWiseUnaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ElementWiseUnaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ElementWiseUnary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::ElementWiseUnary_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in ElementWiseUnary struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in ElementWiseUnary struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ElementWiseUnary struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ElementWiseUnary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ElementWiseUnaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ExpandDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ExpandDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Expand_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Expand struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Expand struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Expand struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Expand_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ExpandDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ConstantPaddingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ConstantPaddingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ConstantPadding_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    
    mojo::internal::Serialize<::webnn::mojom::NumberDataView>(
      in_value,
      value_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ConstantPadding struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ConstantPadding_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ConstantPaddingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::EdgePaddingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::EdgePaddingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::EdgePadding_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::webnn::mojom::internal::EdgePadding_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::EdgePaddingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReflectionPaddingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ReflectionPaddingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ReflectionPadding_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::webnn::mojom::internal::ReflectionPadding_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReflectionPaddingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::InstanceNormalizationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::InstanceNormalizationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::InstanceNormalization_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in InstanceNormalization struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in InstanceNormalization struct");

    decltype(Traits::scale_operand_id(input)) in_scale_operand_id = Traits::scale_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_operand_id)::BaseType> scale_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_scale_operand_id,
      scale_operand_id_fragment);

    fragment->scale_operand_id.Set(
        scale_operand_id_fragment.is_null() ? nullptr : scale_operand_id_fragment.data());

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    fragment->epsilon = Traits::epsilon(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in InstanceNormalization struct");
  }

  static bool Deserialize(::webnn::mojom::internal::InstanceNormalization_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::InstanceNormalizationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::MatmulDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::MatmulDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Matmul_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::a_operand_id(input)) in_a_operand_id = Traits::a_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->a_operand_id)::BaseType> a_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_a_operand_id,
      a_operand_id_fragment);

    fragment->a_operand_id.Set(
        a_operand_id_fragment.is_null() ? nullptr : a_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->a_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null a_operand_id in Matmul struct");

    decltype(Traits::b_operand_id(input)) in_b_operand_id = Traits::b_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->b_operand_id)::BaseType> b_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_b_operand_id,
      b_operand_id_fragment);

    fragment->b_operand_id.Set(
        b_operand_id_fragment.is_null() ? nullptr : b_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->b_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null b_operand_id in Matmul struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Matmul struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Matmul struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Matmul_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::MatmulDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::PadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::PadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Pad_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Pad struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Pad struct");

    decltype(Traits::beginning_padding(input)) in_beginning_padding = Traits::beginning_padding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->beginning_padding)::BaseType>
        beginning_padding_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& beginning_padding_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_beginning_padding,
      beginning_padding_fragment,
      &beginning_padding_validate_params);

    fragment->beginning_padding.Set(
        beginning_padding_fragment.is_null() ? nullptr : beginning_padding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->beginning_padding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null beginning_padding in Pad struct");

    decltype(Traits::ending_padding(input)) in_ending_padding = Traits::ending_padding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ending_padding)::BaseType>
        ending_padding_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ending_padding_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_ending_padding,
      ending_padding_fragment,
      &ending_padding_validate_params);

    fragment->ending_padding.Set(
        ending_padding_fragment.is_null() ? nullptr : ending_padding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ending_padding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ending_padding in Pad struct");

    decltype(Traits::mode(input)) in_mode = Traits::mode(input);
    mojo::internal::MessageFragment<decltype(fragment->mode)>
        mode_fragment(fragment.message());
    mode_fragment.Claim(&fragment->mode);
    
    mojo::internal::Serialize<::webnn::mojom::PaddingModeDataView>(
      in_mode,
      mode_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mode.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mode in Pad struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Pad struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Pad_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::PadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReduceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ReduceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Reduce_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::Reduce_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Reduce struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Reduce struct");

    decltype(Traits::axes(input)) in_axes = Traits::axes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axes)::BaseType>
        axes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_axes,
      axes_fragment,
      &axes_validate_params);

    fragment->axes.Set(
        axes_fragment.is_null() ? nullptr : axes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axes in Reduce struct");

    fragment->keep_dimensions = Traits::keep_dimensions(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Reduce struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Reduce_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReduceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Pool2dDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::Pool2dDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Pool2d_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::Pool2d_Kind>(
      Traits::kind(input),
      &fragment->kind);

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Pool2d struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Pool2d struct");

    decltype(Traits::window_dimensions(input)) in_window_dimensions = Traits::window_dimensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_dimensions)::BaseType> window_dimensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_window_dimensions,
      window_dimensions_fragment);

    fragment->window_dimensions.Set(
        window_dimensions_fragment.is_null() ? nullptr : window_dimensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->window_dimensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_dimensions in Pool2d struct");

    decltype(Traits::padding(input)) in_padding = Traits::padding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->padding)::BaseType> padding_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Padding2dDataView>(
      in_padding,
      padding_fragment);

    fragment->padding.Set(
        padding_fragment.is_null() ? nullptr : padding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->padding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null padding in Pool2d struct");

    decltype(Traits::strides(input)) in_strides = Traits::strides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->strides)::BaseType> strides_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_strides,
      strides_fragment);

    fragment->strides.Set(
        strides_fragment.is_null() ? nullptr : strides_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->strides.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null strides in Pool2d struct");

    decltype(Traits::dilations(input)) in_dilations = Traits::dilations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dilations)::BaseType> dilations_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::Size2dDataView>(
      in_dilations,
      dilations_fragment);

    fragment->dilations.Set(
        dilations_fragment.is_null() ? nullptr : dilations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dilations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dilations in Pool2d struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Pool2d struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Pool2d_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::Pool2dDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::RangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::RangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Range_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->start = Traits::start(input);

    fragment->size = Traits::size(input);

    fragment->stride = Traits::stride(input);
  }

  static bool Deserialize(::webnn::mojom::internal::Range_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::RangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SliceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SliceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Slice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Slice struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Slice struct");

    decltype(Traits::ranges(input)) in_ranges = Traits::ranges(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ranges)::BaseType>
        ranges_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ranges_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::RangeDataView>>(
      in_ranges,
      ranges_fragment,
      &ranges_validate_params);

    fragment->ranges.Set(
        ranges_fragment.is_null() ? nullptr : ranges_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ranges.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ranges in Slice struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Slice struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Slice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SliceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::EluDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::EluDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Elu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Elu struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Elu struct");

    fragment->alpha = Traits::alpha(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Elu struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Elu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::EluDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GatherDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GatherDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Gather_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Gather struct");

    decltype(Traits::indices_operand_id(input)) in_indices_operand_id = Traits::indices_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices_operand_id)::BaseType> indices_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_indices_operand_id,
      indices_operand_id_fragment);

    fragment->indices_operand_id.Set(
        indices_operand_id_fragment.is_null() ? nullptr : indices_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices_operand_id in Gather struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Gather struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Gather struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Gather_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GatherDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GatherElementsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GatherElementsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::GatherElements_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in GatherElements struct");

    decltype(Traits::indices_operand_id(input)) in_indices_operand_id = Traits::indices_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices_operand_id)::BaseType> indices_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_indices_operand_id,
      indices_operand_id_fragment);

    fragment->indices_operand_id.Set(
        indices_operand_id_fragment.is_null() ? nullptr : indices_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices_operand_id in GatherElements struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in GatherElements struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in GatherElements struct");
  }

  static bool Deserialize(::webnn::mojom::internal::GatherElements_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GatherElementsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GatherNDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GatherNDDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::GatherND_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in GatherND struct");

    decltype(Traits::indices_operand_id(input)) in_indices_operand_id = Traits::indices_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices_operand_id)::BaseType> indices_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_indices_operand_id,
      indices_operand_id_fragment);

    fragment->indices_operand_id.Set(
        indices_operand_id_fragment.is_null() ? nullptr : indices_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices_operand_id in GatherND struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in GatherND struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in GatherND struct");
  }

  static bool Deserialize(::webnn::mojom::internal::GatherND_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GatherNDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GeluDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GeluDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Gelu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Gelu struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Gelu struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Gelu struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Gelu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GeluDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GruDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GruDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Gru_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Gru struct");

    decltype(Traits::weight_operand_id(input)) in_weight_operand_id = Traits::weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weight_operand_id)::BaseType> weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_weight_operand_id,
      weight_operand_id_fragment);

    fragment->weight_operand_id.Set(
        weight_operand_id_fragment.is_null() ? nullptr : weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null weight_operand_id in Gru struct");

    decltype(Traits::recurrent_weight_operand_id(input)) in_recurrent_weight_operand_id = Traits::recurrent_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_weight_operand_id)::BaseType> recurrent_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_weight_operand_id,
      recurrent_weight_operand_id_fragment);

    fragment->recurrent_weight_operand_id.Set(
        recurrent_weight_operand_id_fragment.is_null() ? nullptr : recurrent_weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recurrent_weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recurrent_weight_operand_id in Gru struct");

    fragment->steps = Traits::steps(input);

    fragment->hidden_size = Traits::hidden_size(input);

    decltype(Traits::output_operand_ids(input)) in_output_operand_ids = Traits::output_operand_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_ids)::BaseType>
        output_operand_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_output_operand_ids,
      output_operand_ids_fragment,
      &output_operand_ids_validate_params);

    fragment->output_operand_ids.Set(
        output_operand_ids_fragment.is_null() ? nullptr : output_operand_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_ids in Gru struct");

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::recurrent_bias_operand_id(input)) in_recurrent_bias_operand_id = Traits::recurrent_bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_bias_operand_id)::BaseType> recurrent_bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_bias_operand_id,
      recurrent_bias_operand_id_fragment);

    fragment->recurrent_bias_operand_id.Set(
        recurrent_bias_operand_id_fragment.is_null() ? nullptr : recurrent_bias_operand_id_fragment.data());

    decltype(Traits::initial_hidden_state_operand_id(input)) in_initial_hidden_state_operand_id = Traits::initial_hidden_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_hidden_state_operand_id)::BaseType> initial_hidden_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_initial_hidden_state_operand_id,
      initial_hidden_state_operand_id_fragment);

    fragment->initial_hidden_state_operand_id.Set(
        initial_hidden_state_operand_id_fragment.is_null() ? nullptr : initial_hidden_state_operand_id_fragment.data());

    fragment->reset_after = Traits::reset_after(input);

    fragment->return_sequence = Traits::return_sequence(input);

    
    mojo::internal::Serialize<::webnn::mojom::RecurrentNetworkDirection>(
      Traits::direction(input),
      &fragment->direction);

    
    mojo::internal::Serialize<::webnn::mojom::GruWeightLayout>(
      Traits::layout(input),
      &fragment->layout);

    decltype(Traits::activations(input)) in_activations = Traits::activations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activations)::BaseType>
        activations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<2, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
      in_activations,
      activations_fragment,
      &activations_validate_params);

    fragment->activations.Set(
        activations_fragment.is_null() ? nullptr : activations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activations in Gru struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Gru struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Gru_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GruDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GruCellDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GruCellDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::GruCell_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in GruCell struct");

    decltype(Traits::weight_operand_id(input)) in_weight_operand_id = Traits::weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weight_operand_id)::BaseType> weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_weight_operand_id,
      weight_operand_id_fragment);

    fragment->weight_operand_id.Set(
        weight_operand_id_fragment.is_null() ? nullptr : weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null weight_operand_id in GruCell struct");

    decltype(Traits::recurrent_weight_operand_id(input)) in_recurrent_weight_operand_id = Traits::recurrent_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_weight_operand_id)::BaseType> recurrent_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_weight_operand_id,
      recurrent_weight_operand_id_fragment);

    fragment->recurrent_weight_operand_id.Set(
        recurrent_weight_operand_id_fragment.is_null() ? nullptr : recurrent_weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recurrent_weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recurrent_weight_operand_id in GruCell struct");

    decltype(Traits::hidden_state_operand_id(input)) in_hidden_state_operand_id = Traits::hidden_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hidden_state_operand_id)::BaseType> hidden_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_hidden_state_operand_id,
      hidden_state_operand_id_fragment);

    fragment->hidden_state_operand_id.Set(
        hidden_state_operand_id_fragment.is_null() ? nullptr : hidden_state_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hidden_state_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hidden_state_operand_id in GruCell struct");

    fragment->hidden_size = Traits::hidden_size(input);

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in GruCell struct");

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::recurrent_bias_operand_id(input)) in_recurrent_bias_operand_id = Traits::recurrent_bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_bias_operand_id)::BaseType> recurrent_bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_bias_operand_id,
      recurrent_bias_operand_id_fragment);

    fragment->recurrent_bias_operand_id.Set(
        recurrent_bias_operand_id_fragment.is_null() ? nullptr : recurrent_bias_operand_id_fragment.data());

    fragment->reset_after = Traits::reset_after(input);

    
    mojo::internal::Serialize<::webnn::mojom::GruWeightLayout>(
      Traits::layout(input),
      &fragment->layout);

    decltype(Traits::activations(input)) in_activations = Traits::activations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activations)::BaseType>
        activations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<2, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
      in_activations,
      activations_fragment,
      &activations_validate_params);

    fragment->activations.Set(
        activations_fragment.is_null() ? nullptr : activations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activations in GruCell struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in GruCell struct");
  }

  static bool Deserialize(::webnn::mojom::internal::GruCell_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GruCellDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GemmDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GemmDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Gemm_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::a_operand_id(input)) in_a_operand_id = Traits::a_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->a_operand_id)::BaseType> a_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_a_operand_id,
      a_operand_id_fragment);

    fragment->a_operand_id.Set(
        a_operand_id_fragment.is_null() ? nullptr : a_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->a_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null a_operand_id in Gemm struct");

    decltype(Traits::b_operand_id(input)) in_b_operand_id = Traits::b_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->b_operand_id)::BaseType> b_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_b_operand_id,
      b_operand_id_fragment);

    fragment->b_operand_id.Set(
        b_operand_id_fragment.is_null() ? nullptr : b_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->b_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null b_operand_id in Gemm struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Gemm struct");

    decltype(Traits::c_operand_id(input)) in_c_operand_id = Traits::c_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->c_operand_id)::BaseType> c_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_c_operand_id,
      c_operand_id_fragment);

    fragment->c_operand_id.Set(
        c_operand_id_fragment.is_null() ? nullptr : c_operand_id_fragment.data());

    fragment->alpha = Traits::alpha(input);

    fragment->beta = Traits::beta(input);

    fragment->a_transpose = Traits::a_transpose(input);

    fragment->b_transpose = Traits::b_transpose(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Gemm struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Gemm_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GemmDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::HardSigmoidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::HardSigmoidDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::HardSigmoid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in HardSigmoid struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in HardSigmoid struct");

    fragment->alpha = Traits::alpha(input);

    fragment->beta = Traits::beta(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in HardSigmoid struct");
  }

  static bool Deserialize(::webnn::mojom::internal::HardSigmoid_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::HardSigmoidDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::HardSwishDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::HardSwishDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::HardSwish_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in HardSwish struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in HardSwish struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in HardSwish struct");
  }

  static bool Deserialize(::webnn::mojom::internal::HardSwish_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::HardSwishDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LayerNormalizationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::LayerNormalizationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::LayerNormalization_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in LayerNormalization struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in LayerNormalization struct");

    decltype(Traits::scale_operand_id(input)) in_scale_operand_id = Traits::scale_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_operand_id)::BaseType> scale_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_scale_operand_id,
      scale_operand_id_fragment);

    fragment->scale_operand_id.Set(
        scale_operand_id_fragment.is_null() ? nullptr : scale_operand_id_fragment.data());

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::axes(input)) in_axes = Traits::axes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axes)::BaseType>
        axes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_axes,
      axes_fragment,
      &axes_validate_params);

    fragment->axes.Set(
        axes_fragment.is_null() ? nullptr : axes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axes in LayerNormalization struct");

    fragment->epsilon = Traits::epsilon(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in LayerNormalization struct");
  }

  static bool Deserialize(::webnn::mojom::internal::LayerNormalization_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::LayerNormalizationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LeakyReluDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::LeakyReluDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::LeakyRelu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in LeakyRelu struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in LeakyRelu struct");

    fragment->alpha = Traits::alpha(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in LeakyRelu struct");
  }

  static bool Deserialize(::webnn::mojom::internal::LeakyRelu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::LeakyReluDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LinearDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::LinearDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Linear_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Linear struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Linear struct");

    fragment->alpha = Traits::alpha(input);

    fragment->beta = Traits::beta(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Linear struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Linear_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::LinearDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LstmDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::LstmDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Lstm_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Lstm struct");

    decltype(Traits::weight_operand_id(input)) in_weight_operand_id = Traits::weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weight_operand_id)::BaseType> weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_weight_operand_id,
      weight_operand_id_fragment);

    fragment->weight_operand_id.Set(
        weight_operand_id_fragment.is_null() ? nullptr : weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null weight_operand_id in Lstm struct");

    decltype(Traits::recurrent_weight_operand_id(input)) in_recurrent_weight_operand_id = Traits::recurrent_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_weight_operand_id)::BaseType> recurrent_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_weight_operand_id,
      recurrent_weight_operand_id_fragment);

    fragment->recurrent_weight_operand_id.Set(
        recurrent_weight_operand_id_fragment.is_null() ? nullptr : recurrent_weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recurrent_weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recurrent_weight_operand_id in Lstm struct");

    decltype(Traits::output_operand_ids(input)) in_output_operand_ids = Traits::output_operand_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_ids)::BaseType>
        output_operand_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_output_operand_ids,
      output_operand_ids_fragment,
      &output_operand_ids_validate_params);

    fragment->output_operand_ids.Set(
        output_operand_ids_fragment.is_null() ? nullptr : output_operand_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_ids in Lstm struct");

    fragment->steps = Traits::steps(input);

    fragment->hidden_size = Traits::hidden_size(input);

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::recurrent_bias_operand_id(input)) in_recurrent_bias_operand_id = Traits::recurrent_bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_bias_operand_id)::BaseType> recurrent_bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_bias_operand_id,
      recurrent_bias_operand_id_fragment);

    fragment->recurrent_bias_operand_id.Set(
        recurrent_bias_operand_id_fragment.is_null() ? nullptr : recurrent_bias_operand_id_fragment.data());

    decltype(Traits::peephole_weight_operand_id(input)) in_peephole_weight_operand_id = Traits::peephole_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->peephole_weight_operand_id)::BaseType> peephole_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_peephole_weight_operand_id,
      peephole_weight_operand_id_fragment);

    fragment->peephole_weight_operand_id.Set(
        peephole_weight_operand_id_fragment.is_null() ? nullptr : peephole_weight_operand_id_fragment.data());

    decltype(Traits::initial_hidden_state_operand_id(input)) in_initial_hidden_state_operand_id = Traits::initial_hidden_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_hidden_state_operand_id)::BaseType> initial_hidden_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_initial_hidden_state_operand_id,
      initial_hidden_state_operand_id_fragment);

    fragment->initial_hidden_state_operand_id.Set(
        initial_hidden_state_operand_id_fragment.is_null() ? nullptr : initial_hidden_state_operand_id_fragment.data());

    decltype(Traits::initial_cell_state_operand_id(input)) in_initial_cell_state_operand_id = Traits::initial_cell_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_cell_state_operand_id)::BaseType> initial_cell_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_initial_cell_state_operand_id,
      initial_cell_state_operand_id_fragment);

    fragment->initial_cell_state_operand_id.Set(
        initial_cell_state_operand_id_fragment.is_null() ? nullptr : initial_cell_state_operand_id_fragment.data());

    fragment->return_sequence = Traits::return_sequence(input);

    
    mojo::internal::Serialize<::webnn::mojom::RecurrentNetworkDirection>(
      Traits::direction(input),
      &fragment->direction);

    
    mojo::internal::Serialize<::webnn::mojom::LstmWeightLayout>(
      Traits::layout(input),
      &fragment->layout);

    decltype(Traits::activations(input)) in_activations = Traits::activations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activations)::BaseType>
        activations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<3, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
      in_activations,
      activations_fragment,
      &activations_validate_params);

    fragment->activations.Set(
        activations_fragment.is_null() ? nullptr : activations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activations in Lstm struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Lstm struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Lstm_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::LstmDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::LstmCellDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::LstmCellDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::LstmCell_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in LstmCell struct");

    decltype(Traits::weight_operand_id(input)) in_weight_operand_id = Traits::weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->weight_operand_id)::BaseType> weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_weight_operand_id,
      weight_operand_id_fragment);

    fragment->weight_operand_id.Set(
        weight_operand_id_fragment.is_null() ? nullptr : weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null weight_operand_id in LstmCell struct");

    decltype(Traits::recurrent_weight_operand_id(input)) in_recurrent_weight_operand_id = Traits::recurrent_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_weight_operand_id)::BaseType> recurrent_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_weight_operand_id,
      recurrent_weight_operand_id_fragment);

    fragment->recurrent_weight_operand_id.Set(
        recurrent_weight_operand_id_fragment.is_null() ? nullptr : recurrent_weight_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->recurrent_weight_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recurrent_weight_operand_id in LstmCell struct");

    decltype(Traits::hidden_state_operand_id(input)) in_hidden_state_operand_id = Traits::hidden_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hidden_state_operand_id)::BaseType> hidden_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_hidden_state_operand_id,
      hidden_state_operand_id_fragment);

    fragment->hidden_state_operand_id.Set(
        hidden_state_operand_id_fragment.is_null() ? nullptr : hidden_state_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hidden_state_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hidden_state_operand_id in LstmCell struct");

    decltype(Traits::cell_state_operand_id(input)) in_cell_state_operand_id = Traits::cell_state_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cell_state_operand_id)::BaseType> cell_state_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_cell_state_operand_id,
      cell_state_operand_id_fragment);

    fragment->cell_state_operand_id.Set(
        cell_state_operand_id_fragment.is_null() ? nullptr : cell_state_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cell_state_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cell_state_operand_id in LstmCell struct");

    decltype(Traits::output_operand_ids(input)) in_output_operand_ids = Traits::output_operand_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_ids)::BaseType>
        output_operand_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_output_operand_ids,
      output_operand_ids_fragment,
      &output_operand_ids_validate_params);

    fragment->output_operand_ids.Set(
        output_operand_ids_fragment.is_null() ? nullptr : output_operand_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_ids in LstmCell struct");

    fragment->hidden_size = Traits::hidden_size(input);

    decltype(Traits::bias_operand_id(input)) in_bias_operand_id = Traits::bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bias_operand_id)::BaseType> bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_bias_operand_id,
      bias_operand_id_fragment);

    fragment->bias_operand_id.Set(
        bias_operand_id_fragment.is_null() ? nullptr : bias_operand_id_fragment.data());

    decltype(Traits::recurrent_bias_operand_id(input)) in_recurrent_bias_operand_id = Traits::recurrent_bias_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recurrent_bias_operand_id)::BaseType> recurrent_bias_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_recurrent_bias_operand_id,
      recurrent_bias_operand_id_fragment);

    fragment->recurrent_bias_operand_id.Set(
        recurrent_bias_operand_id_fragment.is_null() ? nullptr : recurrent_bias_operand_id_fragment.data());

    decltype(Traits::peephole_weight_operand_id(input)) in_peephole_weight_operand_id = Traits::peephole_weight_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->peephole_weight_operand_id)::BaseType> peephole_weight_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_peephole_weight_operand_id,
      peephole_weight_operand_id_fragment);

    fragment->peephole_weight_operand_id.Set(
        peephole_weight_operand_id_fragment.is_null() ? nullptr : peephole_weight_operand_id_fragment.data());

    
    mojo::internal::Serialize<::webnn::mojom::LstmWeightLayout>(
      Traits::layout(input),
      &fragment->layout);

    decltype(Traits::activations(input)) in_activations = Traits::activations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activations)::BaseType>
        activations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& activations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<3, false, ::webnn::mojom::internal::RecurrentNetworkActivation_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
      in_activations,
      activations_fragment,
      &activations_validate_params);

    fragment->activations.Set(
        activations_fragment.is_null() ? nullptr : activations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activations in LstmCell struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in LstmCell struct");
  }

  static bool Deserialize(::webnn::mojom::internal::LstmCell_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::LstmCellDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::PreluDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::PreluDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Prelu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Prelu struct");

    decltype(Traits::slope_operand_id(input)) in_slope_operand_id = Traits::slope_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->slope_operand_id)::BaseType> slope_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_slope_operand_id,
      slope_operand_id_fragment);

    fragment->slope_operand_id.Set(
        slope_operand_id_fragment.is_null() ? nullptr : slope_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->slope_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null slope_operand_id in Prelu struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Prelu struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Prelu struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Prelu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::PreluDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::QuantizeLinearDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::QuantizeLinearDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::QuantizeLinear_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in QuantizeLinear struct");

    decltype(Traits::scale_operand_id(input)) in_scale_operand_id = Traits::scale_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scale_operand_id)::BaseType> scale_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_scale_operand_id,
      scale_operand_id_fragment);

    fragment->scale_operand_id.Set(
        scale_operand_id_fragment.is_null() ? nullptr : scale_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scale_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scale_operand_id in QuantizeLinear struct");

    decltype(Traits::zero_point_operand_id(input)) in_zero_point_operand_id = Traits::zero_point_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->zero_point_operand_id)::BaseType> zero_point_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_zero_point_operand_id,
      zero_point_operand_id_fragment);

    fragment->zero_point_operand_id.Set(
        zero_point_operand_id_fragment.is_null() ? nullptr : zero_point_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->zero_point_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zero_point_operand_id in QuantizeLinear struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in QuantizeLinear struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in QuantizeLinear struct");
  }

  static bool Deserialize(::webnn::mojom::internal::QuantizeLinear_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::QuantizeLinearDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReluDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ReluDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Relu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Relu struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Relu struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Relu struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Relu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReluDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReshapeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ReshapeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Reshape_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Reshape struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Reshape struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Reshape struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Reshape_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReshapeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReverseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ReverseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Reverse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Reverse struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Reverse struct");

    decltype(Traits::axes(input)) in_axes = Traits::axes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axes)::BaseType>
        axes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_axes,
      axes_fragment,
      &axes_validate_params);

    fragment->axes.Set(
        axes_fragment.is_null() ? nullptr : axes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axes in Reverse struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Reverse struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Reverse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReverseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ScatterElementsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ScatterElementsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ScatterElements_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in ScatterElements struct");

    decltype(Traits::indices_operand_id(input)) in_indices_operand_id = Traits::indices_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices_operand_id)::BaseType> indices_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_indices_operand_id,
      indices_operand_id_fragment);

    fragment->indices_operand_id.Set(
        indices_operand_id_fragment.is_null() ? nullptr : indices_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices_operand_id in ScatterElements struct");

    decltype(Traits::updates_operand_id(input)) in_updates_operand_id = Traits::updates_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updates_operand_id)::BaseType> updates_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_updates_operand_id,
      updates_operand_id_fragment);

    fragment->updates_operand_id.Set(
        updates_operand_id_fragment.is_null() ? nullptr : updates_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->updates_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updates_operand_id in ScatterElements struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in ScatterElements struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ScatterElements struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ScatterElements_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ScatterElementsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ScatterNDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ScatterNDDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ScatterND_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in ScatterND struct");

    decltype(Traits::indices_operand_id(input)) in_indices_operand_id = Traits::indices_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices_operand_id)::BaseType> indices_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_indices_operand_id,
      indices_operand_id_fragment);

    fragment->indices_operand_id.Set(
        indices_operand_id_fragment.is_null() ? nullptr : indices_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices_operand_id in ScatterND struct");

    decltype(Traits::updates_operand_id(input)) in_updates_operand_id = Traits::updates_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updates_operand_id)::BaseType> updates_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_updates_operand_id,
      updates_operand_id_fragment);

    fragment->updates_operand_id.Set(
        updates_operand_id_fragment.is_null() ? nullptr : updates_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->updates_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updates_operand_id in ScatterND struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in ScatterND struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ScatterND struct");
  }

  static bool Deserialize(::webnn::mojom::internal::ScatterND_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ScatterNDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SigmoidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SigmoidDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Sigmoid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Sigmoid struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Sigmoid struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Sigmoid struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Sigmoid_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SigmoidDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SoftmaxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SoftmaxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Softmax_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Softmax struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Softmax struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Softmax struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Softmax_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SoftmaxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SoftplusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SoftplusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Softplus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Softplus struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Softplus struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Softplus struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Softplus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SoftplusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SoftsignDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SoftsignDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Softsign_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Softsign struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Softsign struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Softsign struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Softsign_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SoftsignDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::SplitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SplitDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Split_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Split struct");

    decltype(Traits::output_operand_ids(input)) in_output_operand_ids = Traits::output_operand_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_ids)::BaseType>
        output_operand_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_operand_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_output_operand_ids,
      output_operand_ids_fragment,
      &output_operand_ids_validate_params);

    fragment->output_operand_ids.Set(
        output_operand_ids_fragment.is_null() ? nullptr : output_operand_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_ids in Split struct");

    fragment->axis = Traits::axis(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Split struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Split_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::SplitDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TanhDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TanhDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Tanh_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Tanh struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Tanh struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Tanh struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Tanh_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TanhDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Tile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Tile struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Tile struct");

    decltype(Traits::repetitions(input)) in_repetitions = Traits::repetitions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->repetitions)::BaseType>
        repetitions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& repetitions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_repetitions,
      repetitions_fragment,
      &repetitions_validate_params);

    fragment->repetitions.Set(
        repetitions_fragment.is_null() ? nullptr : repetitions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->repetitions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null repetitions in Tile struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Tile struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Tile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TransposeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TransposeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Transpose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Transpose struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Transpose struct");

    decltype(Traits::permutation(input)) in_permutation = Traits::permutation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permutation)::BaseType>
        permutation_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permutation_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_permutation,
      permutation_fragment,
      &permutation_validate_params);

    fragment->permutation.Set(
        permutation_fragment.is_null() ? nullptr : permutation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permutation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permutation in Transpose struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Transpose struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Transpose_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TransposeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TriangularDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TriangularDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Triangular_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Triangular struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Triangular struct");

    fragment->upper = Traits::upper(input);

    fragment->diagonal = Traits::diagonal(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Triangular struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Triangular_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TriangularDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::Resample2dDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::Resample2dDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Resample2d_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input_operand_id(input)) in_input_operand_id = Traits::input_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operand_id)::BaseType> input_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_input_operand_id,
      input_operand_id_fragment);

    fragment->input_operand_id.Set(
        input_operand_id_fragment.is_null() ? nullptr : input_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operand_id in Resample2d struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Resample2d struct");

    
    mojo::internal::Serialize<::webnn::mojom::Resample2d_InterpolationMode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::scales(input)) in_scales = Traits::scales(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scales)::BaseType>
        scales_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scales_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_scales,
      scales_fragment,
      &scales_validate_params);

    fragment->scales.Set(
        scales_fragment.is_null() ? nullptr : scales_fragment.data());

    decltype(Traits::axes(input)) in_axes = Traits::axes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axes)::BaseType>
        axes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axes_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_axes,
      axes_fragment,
      &axes_validate_params);

    fragment->axes.Set(
        axes_fragment.is_null() ? nullptr : axes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axes in Resample2d struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Resample2d struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Resample2d_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::Resample2dDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::WhereDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::WhereDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::Where_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::condition_operand_id(input)) in_condition_operand_id = Traits::condition_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->condition_operand_id)::BaseType> condition_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_condition_operand_id,
      condition_operand_id_fragment);

    fragment->condition_operand_id.Set(
        condition_operand_id_fragment.is_null() ? nullptr : condition_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->condition_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null condition_operand_id in Where struct");

    decltype(Traits::true_value_operand_id(input)) in_true_value_operand_id = Traits::true_value_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->true_value_operand_id)::BaseType> true_value_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_true_value_operand_id,
      true_value_operand_id_fragment);

    fragment->true_value_operand_id.Set(
        true_value_operand_id_fragment.is_null() ? nullptr : true_value_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->true_value_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null true_value_operand_id in Where struct");

    decltype(Traits::false_value_operand_id(input)) in_false_value_operand_id = Traits::false_value_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->false_value_operand_id)::BaseType> false_value_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_false_value_operand_id,
      false_value_operand_id_fragment);

    fragment->false_value_operand_id.Set(
        false_value_operand_id_fragment.is_null() ? nullptr : false_value_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->false_value_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null false_value_operand_id in Where struct");

    decltype(Traits::output_operand_id(input)) in_output_operand_id = Traits::output_operand_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operand_id)::BaseType> output_operand_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandIdDataView>(
      in_output_operand_id,
      output_operand_id_fragment);

    fragment->output_operand_id.Set(
        output_operand_id_fragment.is_null() ? nullptr : output_operand_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operand_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operand_id in Where struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Where struct");
  }

  static bool Deserialize(::webnn::mojom::internal::Where_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::WhereDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::GraphInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::GraphInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::GraphInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::operands(input)) in_operands = Traits::operands(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->operands)::BaseType>
        operands_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& operands_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandDataView>>(
      in_operands,
      operands_fragment,
      &operands_validate_params);

    fragment->operands.Set(
        operands_fragment.is_null() ? nullptr : operands_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->operands.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null operands in GraphInfo struct");

    decltype(Traits::input_operands(input)) in_input_operands = Traits::input_operands(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_operands)::BaseType>
        input_operands_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_operands_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_input_operands,
      input_operands_fragment,
      &input_operands_validate_params);

    fragment->input_operands.Set(
        input_operands_fragment.is_null() ? nullptr : input_operands_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_operands.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_operands in GraphInfo struct");

    decltype(Traits::output_operands(input)) in_output_operands = Traits::output_operands(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_operands)::BaseType>
        output_operands_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_operands_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
      in_output_operands,
      output_operands_fragment,
      &output_operands_validate_params);

    fragment->output_operands.Set(
        output_operands_fragment.is_null() ? nullptr : output_operands_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_operands.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_operands in GraphInfo struct");

    decltype(Traits::operations(input)) in_operations = Traits::operations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->operations)::BaseType>
        operations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& operations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::OperationDataView>>(
      in_operations,
      operations_fragment,
      &operations_validate_params);

    fragment->operations.Set(
        operations_fragment.is_null() ? nullptr : operations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->operations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null operations in GraphInfo struct");

    decltype(Traits::constant_operand_ids_to_handles(input)) in_constant_operand_ids_to_handles = Traits::constant_operand_ids_to_handles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->constant_operand_ids_to_handles)::BaseType>
        constant_operand_ids_to_handles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& constant_operand_ids_to_handles_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::webnn::mojom::OperandIdDataView, ::blink::mojom::WebNNPendingConstantTokenDataView>>(
      in_constant_operand_ids_to_handles,
      constant_operand_ids_to_handles_fragment,
      &constant_operand_ids_to_handles_validate_params);

    fragment->constant_operand_ids_to_handles.Set(
        constant_operand_ids_to_handles_fragment.is_null() ? nullptr : constant_operand_ids_to_handles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->constant_operand_ids_to_handles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null constant_operand_ids_to_handles in GraphInfo struct");

    decltype(Traits::id_to_constant_tensor_operand_map(input)) in_id_to_constant_tensor_operand_map = Traits::id_to_constant_tensor_operand_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id_to_constant_tensor_operand_map)::BaseType>
        id_to_constant_tensor_operand_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_to_constant_tensor_operand_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::webnn::mojom::OperandIdDataView, ::blink::mojom::WebNNTensorTokenDataView>>(
      in_id_to_constant_tensor_operand_map,
      id_to_constant_tensor_operand_map_fragment,
      &id_to_constant_tensor_operand_map_validate_params);

    fragment->id_to_constant_tensor_operand_map.Set(
        id_to_constant_tensor_operand_map_fragment.is_null() ? nullptr : id_to_constant_tensor_operand_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id_to_constant_tensor_operand_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id_to_constant_tensor_operand_map in GraphInfo struct");
  }

  static bool Deserialize(::webnn::mojom::internal::GraphInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::GraphInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::NumberDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::NumberDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::Number_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::NumberDataView::Tag::kFloatingPoint: {
    decltype(Traits::floating_point(input))
    in_floating_point = Traits::floating_point(input);
    fragment->data.f_floating_point = in_floating_point;
    break;
  }
  case ::webnn::mojom::NumberDataView::Tag::kSignedInteger: {
    decltype(Traits::signed_integer(input))
    in_signed_integer = Traits::signed_integer(input);
    fragment->data.f_signed_integer = in_signed_integer;
    break;
  }
  case ::webnn::mojom::NumberDataView::Tag::kUnsignedInteger: {
    decltype(Traits::unsigned_integer(input))
    in_unsigned_integer = Traits::unsigned_integer(input);
    fragment->data.f_unsigned_integer = in_unsigned_integer;
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::Number_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::NumberDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::PaddingModeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::PaddingModeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::PaddingMode_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::PaddingModeDataView::Tag::kConstant: {
    decltype(Traits::constant(input))
    in_constant = Traits::constant(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_constant)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ConstantPaddingDataView>(
  in_constant,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null constant in PaddingMode union");
    fragment->data.f_constant.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::PaddingModeDataView::Tag::kEdge: {
    decltype(Traits::edge(input))
    in_edge = Traits::edge(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_edge)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::EdgePaddingDataView>(
  in_edge,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null edge in PaddingMode union");
    fragment->data.f_edge.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::PaddingModeDataView::Tag::kReflection: {
    decltype(Traits::reflection(input))
    in_reflection = Traits::reflection(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reflection)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ReflectionPaddingDataView>(
  in_reflection,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reflection in PaddingMode union");
    fragment->data.f_reflection.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::PaddingMode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::PaddingModeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::OperationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::OperationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::Operation_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::OperationDataView::Tag::kArgMinMax: {
    decltype(Traits::arg_min_max(input))
    in_arg_min_max = Traits::arg_min_max(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_arg_min_max)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ArgMinMaxDataView>(
  in_arg_min_max,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null arg_min_max in Operation union");
    fragment->data.f_arg_min_max.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kBatchNormalization: {
    decltype(Traits::batch_normalization(input))
    in_batch_normalization = Traits::batch_normalization(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_batch_normalization)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::BatchNormalizationDataView>(
  in_batch_normalization,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null batch_normalization in Operation union");
    fragment->data.f_batch_normalization.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kClamp: {
    decltype(Traits::clamp(input))
    in_clamp = Traits::clamp(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_clamp)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ClampDataView>(
  in_clamp,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null clamp in Operation union");
    fragment->data.f_clamp.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kConcat: {
    decltype(Traits::concat(input))
    in_concat = Traits::concat(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_concat)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ConcatDataView>(
  in_concat,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null concat in Operation union");
    fragment->data.f_concat.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kConv2d: {
    decltype(Traits::conv2d(input))
    in_conv2d = Traits::conv2d(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_conv2d)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::Conv2dDataView>(
  in_conv2d,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null conv2d in Operation union");
    fragment->data.f_conv2d.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kCumulativeSum: {
    decltype(Traits::cumulative_sum(input))
    in_cumulative_sum = Traits::cumulative_sum(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cumulative_sum)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CumulativeSumDataView>(
  in_cumulative_sum,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cumulative_sum in Operation union");
    fragment->data.f_cumulative_sum.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kDequantizeLinear: {
    decltype(Traits::dequantize_linear(input))
    in_dequantize_linear = Traits::dequantize_linear(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dequantize_linear)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::DequantizeLinearDataView>(
  in_dequantize_linear,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dequantize_linear in Operation union");
    fragment->data.f_dequantize_linear.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kElementWiseBinary: {
    decltype(Traits::element_wise_binary(input))
    in_element_wise_binary = Traits::element_wise_binary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_element_wise_binary)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ElementWiseBinaryDataView>(
  in_element_wise_binary,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null element_wise_binary in Operation union");
    fragment->data.f_element_wise_binary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kElu: {
    decltype(Traits::elu(input))
    in_elu = Traits::elu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_elu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::EluDataView>(
  in_elu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null elu in Operation union");
    fragment->data.f_elu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kElementWiseUnary: {
    decltype(Traits::element_wise_unary(input))
    in_element_wise_unary = Traits::element_wise_unary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_element_wise_unary)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ElementWiseUnaryDataView>(
  in_element_wise_unary,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null element_wise_unary in Operation union");
    fragment->data.f_element_wise_unary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kExpand: {
    decltype(Traits::expand(input))
    in_expand = Traits::expand(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_expand)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ExpandDataView>(
  in_expand,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null expand in Operation union");
    fragment->data.f_expand.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGather: {
    decltype(Traits::gather(input))
    in_gather = Traits::gather(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gather)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GatherDataView>(
  in_gather,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gather in Operation union");
    fragment->data.f_gather.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGatherElements: {
    decltype(Traits::gather_elements(input))
    in_gather_elements = Traits::gather_elements(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gather_elements)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GatherElementsDataView>(
  in_gather_elements,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gather_elements in Operation union");
    fragment->data.f_gather_elements.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGatherNd: {
    decltype(Traits::gather_nd(input))
    in_gather_nd = Traits::gather_nd(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gather_nd)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GatherNDDataView>(
  in_gather_nd,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gather_nd in Operation union");
    fragment->data.f_gather_nd.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGelu: {
    decltype(Traits::gelu(input))
    in_gelu = Traits::gelu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gelu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GeluDataView>(
  in_gelu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gelu in Operation union");
    fragment->data.f_gelu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGemm: {
    decltype(Traits::gemm(input))
    in_gemm = Traits::gemm(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gemm)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GemmDataView>(
  in_gemm,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gemm in Operation union");
    fragment->data.f_gemm.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGru: {
    decltype(Traits::gru(input))
    in_gru = Traits::gru(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gru)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GruDataView>(
  in_gru,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gru in Operation union");
    fragment->data.f_gru.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kGruCell: {
    decltype(Traits::gru_cell(input))
    in_gru_cell = Traits::gru_cell(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gru_cell)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::GruCellDataView>(
  in_gru_cell,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gru_cell in Operation union");
    fragment->data.f_gru_cell.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kHardSigmoid: {
    decltype(Traits::hard_sigmoid(input))
    in_hard_sigmoid = Traits::hard_sigmoid(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_hard_sigmoid)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::HardSigmoidDataView>(
  in_hard_sigmoid,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null hard_sigmoid in Operation union");
    fragment->data.f_hard_sigmoid.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kHardSwish: {
    decltype(Traits::hard_swish(input))
    in_hard_swish = Traits::hard_swish(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_hard_swish)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::HardSwishDataView>(
  in_hard_swish,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null hard_swish in Operation union");
    fragment->data.f_hard_swish.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kLayerNormalization: {
    decltype(Traits::layer_normalization(input))
    in_layer_normalization = Traits::layer_normalization(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_layer_normalization)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::LayerNormalizationDataView>(
  in_layer_normalization,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null layer_normalization in Operation union");
    fragment->data.f_layer_normalization.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kInstanceNormalization: {
    decltype(Traits::instance_normalization(input))
    in_instance_normalization = Traits::instance_normalization(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_instance_normalization)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::InstanceNormalizationDataView>(
  in_instance_normalization,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null instance_normalization in Operation union");
    fragment->data.f_instance_normalization.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kLeakyRelu: {
    decltype(Traits::leaky_relu(input))
    in_leaky_relu = Traits::leaky_relu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_leaky_relu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::LeakyReluDataView>(
  in_leaky_relu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null leaky_relu in Operation union");
    fragment->data.f_leaky_relu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kLinear: {
    decltype(Traits::linear(input))
    in_linear = Traits::linear(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_linear)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::LinearDataView>(
  in_linear,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null linear in Operation union");
    fragment->data.f_linear.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kLstm: {
    decltype(Traits::lstm(input))
    in_lstm = Traits::lstm(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_lstm)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::LstmDataView>(
  in_lstm,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null lstm in Operation union");
    fragment->data.f_lstm.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kLstmCell: {
    decltype(Traits::lstm_cell(input))
    in_lstm_cell = Traits::lstm_cell(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_lstm_cell)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::LstmCellDataView>(
  in_lstm_cell,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null lstm_cell in Operation union");
    fragment->data.f_lstm_cell.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kMatmul: {
    decltype(Traits::matmul(input))
    in_matmul = Traits::matmul(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_matmul)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::MatmulDataView>(
  in_matmul,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null matmul in Operation union");
    fragment->data.f_matmul.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kPad: {
    decltype(Traits::pad(input))
    in_pad = Traits::pad(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pad)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::PadDataView>(
  in_pad,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pad in Operation union");
    fragment->data.f_pad.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kPool2d: {
    decltype(Traits::pool2d(input))
    in_pool2d = Traits::pool2d(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pool2d)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::Pool2dDataView>(
  in_pool2d,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pool2d in Operation union");
    fragment->data.f_pool2d.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kPrelu: {
    decltype(Traits::prelu(input))
    in_prelu = Traits::prelu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_prelu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::PreluDataView>(
  in_prelu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null prelu in Operation union");
    fragment->data.f_prelu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kQuantizeLinear: {
    decltype(Traits::quantize_linear(input))
    in_quantize_linear = Traits::quantize_linear(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_quantize_linear)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::QuantizeLinearDataView>(
  in_quantize_linear,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null quantize_linear in Operation union");
    fragment->data.f_quantize_linear.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kReduce: {
    decltype(Traits::reduce(input))
    in_reduce = Traits::reduce(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reduce)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ReduceDataView>(
  in_reduce,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reduce in Operation union");
    fragment->data.f_reduce.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kRelu: {
    decltype(Traits::relu(input))
    in_relu = Traits::relu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_relu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ReluDataView>(
  in_relu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null relu in Operation union");
    fragment->data.f_relu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kResample2d: {
    decltype(Traits::resample2d(input))
    in_resample2d = Traits::resample2d(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_resample2d)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::Resample2dDataView>(
  in_resample2d,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null resample2d in Operation union");
    fragment->data.f_resample2d.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kReshape: {
    decltype(Traits::reshape(input))
    in_reshape = Traits::reshape(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reshape)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ReshapeDataView>(
  in_reshape,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reshape in Operation union");
    fragment->data.f_reshape.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kReverse: {
    decltype(Traits::reverse(input))
    in_reverse = Traits::reverse(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reverse)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ReverseDataView>(
  in_reverse,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reverse in Operation union");
    fragment->data.f_reverse.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kScatterElements: {
    decltype(Traits::scatter_elements(input))
    in_scatter_elements = Traits::scatter_elements(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scatter_elements)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ScatterElementsDataView>(
  in_scatter_elements,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scatter_elements in Operation union");
    fragment->data.f_scatter_elements.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kScatterNd: {
    decltype(Traits::scatter_nd(input))
    in_scatter_nd = Traits::scatter_nd(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scatter_nd)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ScatterNDDataView>(
  in_scatter_nd,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scatter_nd in Operation union");
    fragment->data.f_scatter_nd.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSigmoid: {
    decltype(Traits::sigmoid(input))
    in_sigmoid = Traits::sigmoid(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_sigmoid)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SigmoidDataView>(
  in_sigmoid,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null sigmoid in Operation union");
    fragment->data.f_sigmoid.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSlice: {
    decltype(Traits::slice(input))
    in_slice = Traits::slice(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_slice)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SliceDataView>(
  in_slice,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null slice in Operation union");
    fragment->data.f_slice.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSoftmax: {
    decltype(Traits::softmax(input))
    in_softmax = Traits::softmax(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_softmax)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SoftmaxDataView>(
  in_softmax,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null softmax in Operation union");
    fragment->data.f_softmax.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSoftplus: {
    decltype(Traits::softplus(input))
    in_softplus = Traits::softplus(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_softplus)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SoftplusDataView>(
  in_softplus,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null softplus in Operation union");
    fragment->data.f_softplus.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSoftsign: {
    decltype(Traits::softsign(input))
    in_softsign = Traits::softsign(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_softsign)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SoftsignDataView>(
  in_softsign,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null softsign in Operation union");
    fragment->data.f_softsign.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kSplit: {
    decltype(Traits::split(input))
    in_split = Traits::split(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_split)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::SplitDataView>(
  in_split,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null split in Operation union");
    fragment->data.f_split.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kTanh: {
    decltype(Traits::tanh(input))
    in_tanh = Traits::tanh(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tanh)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::TanhDataView>(
  in_tanh,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tanh in Operation union");
    fragment->data.f_tanh.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kTile: {
    decltype(Traits::tile(input))
    in_tile = Traits::tile(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tile)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::TileDataView>(
  in_tile,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tile in Operation union");
    fragment->data.f_tile.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kTranspose: {
    decltype(Traits::transpose(input))
    in_transpose = Traits::transpose(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_transpose)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::TransposeDataView>(
  in_transpose,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null transpose in Operation union");
    fragment->data.f_transpose.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kTriangular: {
    decltype(Traits::triangular(input))
    in_triangular = Traits::triangular(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_triangular)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::TriangularDataView>(
  in_triangular,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null triangular in Operation union");
    fragment->data.f_triangular.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::OperationDataView::Tag::kWhere: {
    decltype(Traits::where(input))
    in_where = Traits::where(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_where)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::WhereDataView>(
  in_where,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null where in Operation union");
    fragment->data.f_where.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::Operation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::OperationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webnn::mojom {

inline void OperandDescriptorDataView::GetShapeDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->shape.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void OperandDescriptorDataView::GetPendingPermutationDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->pending_permutation.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}




inline void OperandDataView::GetDescriptorDataView(
    OperandDescriptorDataView* output) {
  auto pointer = data_->descriptor.Get();
  *output = OperandDescriptorDataView(pointer, message_);
}
inline void OperandDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ArgMinMaxDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ArgMinMaxDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ArgMinMaxDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BatchNormalizationDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetMeanOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->mean_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetVarianceOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->variance_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetScaleOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->scale_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void BatchNormalizationDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ClampDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ClampDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ClampDataView::GetMinValueDataView(
    NumberDataView* output) {
  auto pointer = &data_->min_value;
  *output = NumberDataView(pointer, message_);
}
inline void ClampDataView::GetMaxValueDataView(
    NumberDataView* output) {
  auto pointer = &data_->max_value;
  *output = NumberDataView(pointer, message_);
}
inline void ClampDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ConcatDataView::GetInputOperandIdsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->input_operand_ids.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void ConcatDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ConcatDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Padding2dDataView::GetBeginningDataView(
    Size2dDataView* output) {
  auto pointer = data_->beginning.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Padding2dDataView::GetEndingDataView(
    Size2dDataView* output) {
  auto pointer = data_->ending.Get();
  *output = Size2dDataView(pointer, message_);
}


inline void Conv2dDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Conv2dDataView::GetFilterOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->filter_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Conv2dDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Conv2dDataView::GetPaddingDataView(
    Padding2dDataView* output) {
  auto pointer = data_->padding.Get();
  *output = Padding2dDataView(pointer, message_);
}
inline void Conv2dDataView::GetStridesDataView(
    Size2dDataView* output) {
  auto pointer = data_->strides.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Conv2dDataView::GetDilationsDataView(
    Size2dDataView* output) {
  auto pointer = data_->dilations.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Conv2dDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Conv2dDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CumulativeSumDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void CumulativeSumDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void CumulativeSumDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DequantizeLinearDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void DequantizeLinearDataView::GetScaleOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->scale_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void DequantizeLinearDataView::GetZeroPointOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->zero_point_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void DequantizeLinearDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void DequantizeLinearDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ElementWiseBinaryDataView::GetLhsOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->lhs_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ElementWiseBinaryDataView::GetRhsOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->rhs_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ElementWiseBinaryDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ElementWiseBinaryDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ElementWiseUnaryDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ElementWiseUnaryDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ElementWiseUnaryDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ExpandDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ExpandDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ExpandDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ConstantPaddingDataView::GetValueDataView(
    NumberDataView* output) {
  auto pointer = &data_->value;
  *output = NumberDataView(pointer, message_);
}






inline void InstanceNormalizationDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void InstanceNormalizationDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void InstanceNormalizationDataView::GetScaleOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->scale_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void InstanceNormalizationDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void InstanceNormalizationDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MatmulDataView::GetAOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->a_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void MatmulDataView::GetBOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->b_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void MatmulDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void MatmulDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PadDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void PadDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void PadDataView::GetBeginningPaddingDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->beginning_padding.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void PadDataView::GetEndingPaddingDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->ending_padding.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void PadDataView::GetModeDataView(
    PaddingModeDataView* output) {
  auto pointer = &data_->mode;
  *output = PaddingModeDataView(pointer, message_);
}
inline void PadDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReduceDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReduceDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReduceDataView::GetAxesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->axes.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void ReduceDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Pool2dDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Pool2dDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Pool2dDataView::GetWindowDimensionsDataView(
    Size2dDataView* output) {
  auto pointer = data_->window_dimensions.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Pool2dDataView::GetPaddingDataView(
    Padding2dDataView* output) {
  auto pointer = data_->padding.Get();
  *output = Padding2dDataView(pointer, message_);
}
inline void Pool2dDataView::GetStridesDataView(
    Size2dDataView* output) {
  auto pointer = data_->strides.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Pool2dDataView::GetDilationsDataView(
    Size2dDataView* output) {
  auto pointer = data_->dilations.Get();
  *output = Size2dDataView(pointer, message_);
}
inline void Pool2dDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void SliceDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SliceDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SliceDataView::GetRangesDataView(
    mojo::ArrayDataView<RangeDataView>* output) {
  auto pointer = data_->ranges.Get();
  *output = mojo::ArrayDataView<RangeDataView>(pointer, message_);
}
inline void SliceDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void EluDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void EluDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void EluDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GatherDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherDataView::GetIndicesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->indices_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GatherElementsDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherElementsDataView::GetIndicesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->indices_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherElementsDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherElementsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GatherNDDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherNDDataView::GetIndicesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->indices_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherNDDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GatherNDDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GeluDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GeluDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GeluDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GruDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetRecurrentWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetOutputOperandIdsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->output_operand_ids.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void GruDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetRecurrentBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetInitialHiddenStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->initial_hidden_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruDataView::GetActivationsDataView(
    mojo::ArrayDataView<RecurrentNetworkActivation>* output) {
  auto pointer = data_->activations.Get();
  *output = mojo::ArrayDataView<RecurrentNetworkActivation>(pointer, message_);
}
inline void GruDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GruCellDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetRecurrentWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetHiddenStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->hidden_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetRecurrentBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GruCellDataView::GetActivationsDataView(
    mojo::ArrayDataView<RecurrentNetworkActivation>* output) {
  auto pointer = data_->activations.Get();
  *output = mojo::ArrayDataView<RecurrentNetworkActivation>(pointer, message_);
}
inline void GruCellDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GemmDataView::GetAOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->a_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GemmDataView::GetBOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->b_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GemmDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GemmDataView::GetCOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->c_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void GemmDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HardSigmoidDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void HardSigmoidDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void HardSigmoidDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HardSwishDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void HardSwishDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void HardSwishDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LayerNormalizationDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LayerNormalizationDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LayerNormalizationDataView::GetScaleOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->scale_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LayerNormalizationDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LayerNormalizationDataView::GetAxesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->axes.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void LayerNormalizationDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LeakyReluDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LeakyReluDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LeakyReluDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LinearDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LinearDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LinearDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LstmDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetRecurrentWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetOutputOperandIdsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->output_operand_ids.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void LstmDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetRecurrentBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetPeepholeWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->peephole_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetInitialHiddenStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->initial_hidden_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetInitialCellStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->initial_cell_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmDataView::GetActivationsDataView(
    mojo::ArrayDataView<RecurrentNetworkActivation>* output) {
  auto pointer = data_->activations.Get();
  *output = mojo::ArrayDataView<RecurrentNetworkActivation>(pointer, message_);
}
inline void LstmDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void LstmCellDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetRecurrentWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetHiddenStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->hidden_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetCellStateOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->cell_state_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetOutputOperandIdsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->output_operand_ids.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void LstmCellDataView::GetBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetRecurrentBiasOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->recurrent_bias_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetPeepholeWeightOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->peephole_weight_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void LstmCellDataView::GetActivationsDataView(
    mojo::ArrayDataView<RecurrentNetworkActivation>* output) {
  auto pointer = data_->activations.Get();
  *output = mojo::ArrayDataView<RecurrentNetworkActivation>(pointer, message_);
}
inline void LstmCellDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PreluDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void PreluDataView::GetSlopeOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->slope_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void PreluDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void PreluDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void QuantizeLinearDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void QuantizeLinearDataView::GetScaleOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->scale_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void QuantizeLinearDataView::GetZeroPointOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->zero_point_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void QuantizeLinearDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void QuantizeLinearDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReluDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReluDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReluDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReshapeDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReshapeDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReshapeDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReverseDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReverseDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ReverseDataView::GetAxesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->axes.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void ReverseDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ScatterElementsDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterElementsDataView::GetIndicesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->indices_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterElementsDataView::GetUpdatesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->updates_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterElementsDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterElementsDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ScatterNDDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterNDDataView::GetIndicesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->indices_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterNDDataView::GetUpdatesOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->updates_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterNDDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void ScatterNDDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SigmoidDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SigmoidDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SigmoidDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SoftmaxDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftmaxDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftmaxDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SoftplusDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftplusDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftplusDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SoftsignDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftsignDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SoftsignDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SplitDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void SplitDataView::GetOutputOperandIdsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->output_operand_ids.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void SplitDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TanhDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TanhDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TanhDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TileDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TileDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TileDataView::GetRepetitionsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->repetitions.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void TileDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TransposeDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TransposeDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TransposeDataView::GetPermutationDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->permutation.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void TransposeDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TriangularDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TriangularDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void TriangularDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Resample2dDataView::GetInputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->input_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Resample2dDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void Resample2dDataView::GetScalesDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->scales.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void Resample2dDataView::GetAxesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->axes.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void Resample2dDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WhereDataView::GetConditionOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->condition_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void WhereDataView::GetTrueValueOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->true_value_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void WhereDataView::GetFalseValueOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->false_value_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void WhereDataView::GetOutputOperandIdDataView(
    OperandIdDataView* output) {
  auto pointer = data_->output_operand_id.Get();
  *output = OperandIdDataView(pointer, message_);
}
inline void WhereDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GraphInfoDataView::GetOperandsDataView(
    mojo::ArrayDataView<OperandDataView>* output) {
  auto pointer = data_->operands.Get();
  *output = mojo::ArrayDataView<OperandDataView>(pointer, message_);
}
inline void GraphInfoDataView::GetInputOperandsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->input_operands.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void GraphInfoDataView::GetOutputOperandsDataView(
    mojo::ArrayDataView<OperandIdDataView>* output) {
  auto pointer = data_->output_operands.Get();
  *output = mojo::ArrayDataView<OperandIdDataView>(pointer, message_);
}
inline void GraphInfoDataView::GetOperationsDataView(
    mojo::ArrayDataView<OperationDataView>* output) {
  auto pointer = data_->operations.Get();
  *output = mojo::ArrayDataView<OperationDataView>(pointer, message_);
}
inline void GraphInfoDataView::GetConstantOperandIdsToHandlesDataView(
    mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNPendingConstantTokenDataView>* output) {
  auto pointer = data_->constant_operand_ids_to_handles.Get();
  *output = mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNPendingConstantTokenDataView>(pointer, message_);
}
inline void GraphInfoDataView::GetIdToConstantTensorOperandMapDataView(
    mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNTensorTokenDataView>* output) {
  auto pointer = data_->id_to_constant_tensor_operand_map.Get();
  *output = mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNTensorTokenDataView>(pointer, message_);
}



inline void PaddingModeDataView::GetConstantDataView(
    ConstantPaddingDataView* output) const {
  CHECK(is_constant());
  *output = ConstantPaddingDataView(data_->data.f_constant.Get(), message_);
}
inline void PaddingModeDataView::GetEdgeDataView(
    EdgePaddingDataView* output) const {
  CHECK(is_edge());
  *output = EdgePaddingDataView(data_->data.f_edge.Get(), message_);
}
inline void PaddingModeDataView::GetReflectionDataView(
    ReflectionPaddingDataView* output) const {
  CHECK(is_reflection());
  *output = ReflectionPaddingDataView(data_->data.f_reflection.Get(), message_);
}

inline void OperationDataView::GetArgMinMaxDataView(
    ArgMinMaxDataView* output) const {
  CHECK(is_arg_min_max());
  *output = ArgMinMaxDataView(data_->data.f_arg_min_max.Get(), message_);
}
inline void OperationDataView::GetBatchNormalizationDataView(
    BatchNormalizationDataView* output) const {
  CHECK(is_batch_normalization());
  *output = BatchNormalizationDataView(data_->data.f_batch_normalization.Get(), message_);
}
inline void OperationDataView::GetClampDataView(
    ClampDataView* output) const {
  CHECK(is_clamp());
  *output = ClampDataView(data_->data.f_clamp.Get(), message_);
}
inline void OperationDataView::GetConcatDataView(
    ConcatDataView* output) const {
  CHECK(is_concat());
  *output = ConcatDataView(data_->data.f_concat.Get(), message_);
}
inline void OperationDataView::GetConv2dDataView(
    Conv2dDataView* output) const {
  CHECK(is_conv2d());
  *output = Conv2dDataView(data_->data.f_conv2d.Get(), message_);
}
inline void OperationDataView::GetCumulativeSumDataView(
    CumulativeSumDataView* output) const {
  CHECK(is_cumulative_sum());
  *output = CumulativeSumDataView(data_->data.f_cumulative_sum.Get(), message_);
}
inline void OperationDataView::GetDequantizeLinearDataView(
    DequantizeLinearDataView* output) const {
  CHECK(is_dequantize_linear());
  *output = DequantizeLinearDataView(data_->data.f_dequantize_linear.Get(), message_);
}
inline void OperationDataView::GetElementWiseBinaryDataView(
    ElementWiseBinaryDataView* output) const {
  CHECK(is_element_wise_binary());
  *output = ElementWiseBinaryDataView(data_->data.f_element_wise_binary.Get(), message_);
}
inline void OperationDataView::GetEluDataView(
    EluDataView* output) const {
  CHECK(is_elu());
  *output = EluDataView(data_->data.f_elu.Get(), message_);
}
inline void OperationDataView::GetElementWiseUnaryDataView(
    ElementWiseUnaryDataView* output) const {
  CHECK(is_element_wise_unary());
  *output = ElementWiseUnaryDataView(data_->data.f_element_wise_unary.Get(), message_);
}
inline void OperationDataView::GetExpandDataView(
    ExpandDataView* output) const {
  CHECK(is_expand());
  *output = ExpandDataView(data_->data.f_expand.Get(), message_);
}
inline void OperationDataView::GetGatherDataView(
    GatherDataView* output) const {
  CHECK(is_gather());
  *output = GatherDataView(data_->data.f_gather.Get(), message_);
}
inline void OperationDataView::GetGatherElementsDataView(
    GatherElementsDataView* output) const {
  CHECK(is_gather_elements());
  *output = GatherElementsDataView(data_->data.f_gather_elements.Get(), message_);
}
inline void OperationDataView::GetGatherNdDataView(
    GatherNDDataView* output) const {
  CHECK(is_gather_nd());
  *output = GatherNDDataView(data_->data.f_gather_nd.Get(), message_);
}
inline void OperationDataView::GetGeluDataView(
    GeluDataView* output) const {
  CHECK(is_gelu());
  *output = GeluDataView(data_->data.f_gelu.Get(), message_);
}
inline void OperationDataView::GetGemmDataView(
    GemmDataView* output) const {
  CHECK(is_gemm());
  *output = GemmDataView(data_->data.f_gemm.Get(), message_);
}
inline void OperationDataView::GetGruDataView(
    GruDataView* output) const {
  CHECK(is_gru());
  *output = GruDataView(data_->data.f_gru.Get(), message_);
}
inline void OperationDataView::GetGruCellDataView(
    GruCellDataView* output) const {
  CHECK(is_gru_cell());
  *output = GruCellDataView(data_->data.f_gru_cell.Get(), message_);
}
inline void OperationDataView::GetHardSigmoidDataView(
    HardSigmoidDataView* output) const {
  CHECK(is_hard_sigmoid());
  *output = HardSigmoidDataView(data_->data.f_hard_sigmoid.Get(), message_);
}
inline void OperationDataView::GetHardSwishDataView(
    HardSwishDataView* output) const {
  CHECK(is_hard_swish());
  *output = HardSwishDataView(data_->data.f_hard_swish.Get(), message_);
}
inline void OperationDataView::GetLayerNormalizationDataView(
    LayerNormalizationDataView* output) const {
  CHECK(is_layer_normalization());
  *output = LayerNormalizationDataView(data_->data.f_layer_normalization.Get(), message_);
}
inline void OperationDataView::GetInstanceNormalizationDataView(
    InstanceNormalizationDataView* output) const {
  CHECK(is_instance_normalization());
  *output = InstanceNormalizationDataView(data_->data.f_instance_normalization.Get(), message_);
}
inline void OperationDataView::GetLeakyReluDataView(
    LeakyReluDataView* output) const {
  CHECK(is_leaky_relu());
  *output = LeakyReluDataView(data_->data.f_leaky_relu.Get(), message_);
}
inline void OperationDataView::GetLinearDataView(
    LinearDataView* output) const {
  CHECK(is_linear());
  *output = LinearDataView(data_->data.f_linear.Get(), message_);
}
inline void OperationDataView::GetLstmDataView(
    LstmDataView* output) const {
  CHECK(is_lstm());
  *output = LstmDataView(data_->data.f_lstm.Get(), message_);
}
inline void OperationDataView::GetLstmCellDataView(
    LstmCellDataView* output) const {
  CHECK(is_lstm_cell());
  *output = LstmCellDataView(data_->data.f_lstm_cell.Get(), message_);
}
inline void OperationDataView::GetMatmulDataView(
    MatmulDataView* output) const {
  CHECK(is_matmul());
  *output = MatmulDataView(data_->data.f_matmul.Get(), message_);
}
inline void OperationDataView::GetPadDataView(
    PadDataView* output) const {
  CHECK(is_pad());
  *output = PadDataView(data_->data.f_pad.Get(), message_);
}
inline void OperationDataView::GetPool2dDataView(
    Pool2dDataView* output) const {
  CHECK(is_pool2d());
  *output = Pool2dDataView(data_->data.f_pool2d.Get(), message_);
}
inline void OperationDataView::GetPreluDataView(
    PreluDataView* output) const {
  CHECK(is_prelu());
  *output = PreluDataView(data_->data.f_prelu.Get(), message_);
}
inline void OperationDataView::GetQuantizeLinearDataView(
    QuantizeLinearDataView* output) const {
  CHECK(is_quantize_linear());
  *output = QuantizeLinearDataView(data_->data.f_quantize_linear.Get(), message_);
}
inline void OperationDataView::GetReduceDataView(
    ReduceDataView* output) const {
  CHECK(is_reduce());
  *output = ReduceDataView(data_->data.f_reduce.Get(), message_);
}
inline void OperationDataView::GetReluDataView(
    ReluDataView* output) const {
  CHECK(is_relu());
  *output = ReluDataView(data_->data.f_relu.Get(), message_);
}
inline void OperationDataView::GetResample2dDataView(
    Resample2dDataView* output) const {
  CHECK(is_resample2d());
  *output = Resample2dDataView(data_->data.f_resample2d.Get(), message_);
}
inline void OperationDataView::GetReshapeDataView(
    ReshapeDataView* output) const {
  CHECK(is_reshape());
  *output = ReshapeDataView(data_->data.f_reshape.Get(), message_);
}
inline void OperationDataView::GetReverseDataView(
    ReverseDataView* output) const {
  CHECK(is_reverse());
  *output = ReverseDataView(data_->data.f_reverse.Get(), message_);
}
inline void OperationDataView::GetScatterElementsDataView(
    ScatterElementsDataView* output) const {
  CHECK(is_scatter_elements());
  *output = ScatterElementsDataView(data_->data.f_scatter_elements.Get(), message_);
}
inline void OperationDataView::GetScatterNdDataView(
    ScatterNDDataView* output) const {
  CHECK(is_scatter_nd());
  *output = ScatterNDDataView(data_->data.f_scatter_nd.Get(), message_);
}
inline void OperationDataView::GetSigmoidDataView(
    SigmoidDataView* output) const {
  CHECK(is_sigmoid());
  *output = SigmoidDataView(data_->data.f_sigmoid.Get(), message_);
}
inline void OperationDataView::GetSliceDataView(
    SliceDataView* output) const {
  CHECK(is_slice());
  *output = SliceDataView(data_->data.f_slice.Get(), message_);
}
inline void OperationDataView::GetSoftmaxDataView(
    SoftmaxDataView* output) const {
  CHECK(is_softmax());
  *output = SoftmaxDataView(data_->data.f_softmax.Get(), message_);
}
inline void OperationDataView::GetSoftplusDataView(
    SoftplusDataView* output) const {
  CHECK(is_softplus());
  *output = SoftplusDataView(data_->data.f_softplus.Get(), message_);
}
inline void OperationDataView::GetSoftsignDataView(
    SoftsignDataView* output) const {
  CHECK(is_softsign());
  *output = SoftsignDataView(data_->data.f_softsign.Get(), message_);
}
inline void OperationDataView::GetSplitDataView(
    SplitDataView* output) const {
  CHECK(is_split());
  *output = SplitDataView(data_->data.f_split.Get(), message_);
}
inline void OperationDataView::GetTanhDataView(
    TanhDataView* output) const {
  CHECK(is_tanh());
  *output = TanhDataView(data_->data.f_tanh.Get(), message_);
}
inline void OperationDataView::GetTileDataView(
    TileDataView* output) const {
  CHECK(is_tile());
  *output = TileDataView(data_->data.f_tile.Get(), message_);
}
inline void OperationDataView::GetTransposeDataView(
    TransposeDataView* output) const {
  CHECK(is_transpose());
  *output = TransposeDataView(data_->data.f_transpose.Get(), message_);
}
inline void OperationDataView::GetTriangularDataView(
    TriangularDataView* output) const {
  CHECK(is_triangular());
  *output = TriangularDataView(data_->data.f_triangular.Get(), message_);
}
inline void OperationDataView::GetWhereDataView(
    WhereDataView* output) const {
  CHECK(is_where());
  *output = WhereDataView(data_->data.f_where.Get(), message_);
}


}  // webnn::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::DataType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::DataType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::RecurrentNetworkActivation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::RecurrentNetworkActivation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::RecurrentNetworkDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::RecurrentNetworkDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::GruWeightLayout> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::GruWeightLayout value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::LstmWeightLayout> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::LstmWeightLayout value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::Operand_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::Operand_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::ArgMinMax_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::ArgMinMax_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::Conv2d_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::Conv2d_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::ElementWiseBinary_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::ElementWiseBinary_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::ElementWiseUnary_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::ElementWiseUnary_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::Reduce_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::Reduce_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::Pool2d_Kind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::Pool2d_Kind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::Resample2d_InterpolationMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::Resample2d_InterpolationMode value);
};

} // namespace perfetto

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_H_