// services/webnn/public/mojom/webnn_context_provider.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SEND_VALIDATION_H_

#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared-internal.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateContextOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateContextOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateContextOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::webnn::mojom::Device>(
        Traits::device(input),
        &fragment->device);

      
      mojo::internal::Serialize<::webnn::mojom::CreateContextOptions_PowerPreference>(
        Traits::power_preference(input),
        &fragment->power_preference);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateContextSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateContextSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateContextSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::context_remote(input)) in_context_remote = Traits::context_remote(input);

      
      mojo::internal::Serialize<::webnn::mojom::WebNNContextAssociatedPtrInfoDataView>(
        in_context_remote,
        &fragment->context_remote,
        &fragment.message());

      decltype(Traits::context_properties(input)) in_context_properties = Traits::context_properties(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->context_properties)::BaseType> context_properties_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::ContextPropertiesDataView, send_validation>(
        in_context_properties,
        context_properties_fragment);

      fragment->context_properties.Set(
          context_properties_fragment.is_null() ? nullptr : context_properties_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->context_properties.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null context_properties in CreateContextSuccess struct");

      decltype(Traits::context_handle(input)) in_context_handle = Traits::context_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->context_handle)::BaseType> context_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebNNContextTokenDataView, send_validation>(
        in_context_handle,
        context_handle_fragment);

      fragment->context_handle.Set(
          context_handle_fragment.is_null() ? nullptr : context_handle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->context_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null context_handle in CreateContextSuccess struct");

      decltype(Traits::write_tensor_producer(input)) in_write_tensor_producer = Traits::write_tensor_producer(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
        in_write_tensor_producer,
        &fragment->write_tensor_producer,
        &fragment.message());

      decltype(Traits::read_tensor_consumer(input)) in_read_tensor_consumer = Traits::read_tensor_consumer(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_read_tensor_consumer,
        &fragment->read_tensor_consumer,
        &fragment.message());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateContextResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::CreateContextResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::CreateContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::CreateContextResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateContextSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in CreateContextResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::CreateContextResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in CreateContextResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SEND_VALIDATION_H_