// services/webnn/public/mojom/webnn_context_properties.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_SEND_VALIDATION_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_SEND_VALIDATION_H_

#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared-internal.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::webnn::mojom::InputOperandLayout, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::webnn::mojom::Resample2DAxes, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::webnn::mojom::BatchNormalizationAxis, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::SupportedDataTypesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SupportedDataTypesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::SupportedDataTypes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->float32 = Traits::float32(input);

      fragment->float16 = Traits::float16(input);

      fragment->int32 = Traits::int32(input);

      fragment->uint32 = Traits::uint32(input);

      fragment->int64 = Traits::int64(input);

      fragment->uint64 = Traits::uint64(input);

      fragment->int8 = Traits::int8(input);

      fragment->uint8 = Traits::uint8(input);

      fragment->int4 = Traits::int4(input);

      fragment->uint4 = Traits::uint4(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::SupportedRanksDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SupportedRanksDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::SupportedRanks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->min = Traits::min(input);

      fragment->max = Traits::max(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::SupportedTensorsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::SupportedTensorsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::SupportedTensors_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data_types(input)) in_data_types = Traits::data_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data_types)::BaseType> data_types_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedDataTypesDataView, send_validation>(
        in_data_types,
        data_types_fragment);

      fragment->data_types.Set(
          data_types_fragment.is_null() ? nullptr : data_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_types in SupportedTensors struct");

      decltype(Traits::ranks(input)) in_ranks = Traits::ranks(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ranks)::BaseType> ranks_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedRanksDataView, send_validation>(
        in_ranks,
        ranks_fragment);

      fragment->ranks.Set(
          ranks_fragment.is_null() ? nullptr : ranks_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ranks.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ranks in SupportedTensors struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::DataTypeLimitsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::DataTypeLimitsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::DataTypeLimits_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input)::BaseType> input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_input,
        input_fragment);

      fragment->input.Set(
          input_fragment.is_null() ? nullptr : input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in DataTypeLimits struct");

      decltype(Traits::constant(input)) in_constant = Traits::constant(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->constant)::BaseType> constant_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_constant,
        constant_fragment);

      fragment->constant.Set(
          constant_fragment.is_null() ? nullptr : constant_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->constant.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null constant in DataTypeLimits struct");

      decltype(Traits::arg_min_max_input(input)) in_arg_min_max_input = Traits::arg_min_max_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->arg_min_max_input)::BaseType> arg_min_max_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_arg_min_max_input,
        arg_min_max_input_fragment);

      fragment->arg_min_max_input.Set(
          arg_min_max_input_fragment.is_null() ? nullptr : arg_min_max_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->arg_min_max_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null arg_min_max_input in DataTypeLimits struct");

      decltype(Traits::arg_min_max_output(input)) in_arg_min_max_output = Traits::arg_min_max_output(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->arg_min_max_output)::BaseType> arg_min_max_output_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_arg_min_max_output,
        arg_min_max_output_fragment);

      fragment->arg_min_max_output.Set(
          arg_min_max_output_fragment.is_null() ? nullptr : arg_min_max_output_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->arg_min_max_output.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null arg_min_max_output in DataTypeLimits struct");

      decltype(Traits::batch_normalization_input(input)) in_batch_normalization_input = Traits::batch_normalization_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->batch_normalization_input)::BaseType> batch_normalization_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_batch_normalization_input,
        batch_normalization_input_fragment);

      fragment->batch_normalization_input.Set(
          batch_normalization_input_fragment.is_null() ? nullptr : batch_normalization_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->batch_normalization_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null batch_normalization_input in DataTypeLimits struct");

      decltype(Traits::batch_normalization_mean(input)) in_batch_normalization_mean = Traits::batch_normalization_mean(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->batch_normalization_mean)::BaseType> batch_normalization_mean_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_batch_normalization_mean,
        batch_normalization_mean_fragment);

      fragment->batch_normalization_mean.Set(
          batch_normalization_mean_fragment.is_null() ? nullptr : batch_normalization_mean_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->batch_normalization_mean.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null batch_normalization_mean in DataTypeLimits struct");

      decltype(Traits::cast_input(input)) in_cast_input = Traits::cast_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cast_input)::BaseType> cast_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_cast_input,
        cast_input_fragment);

      fragment->cast_input.Set(
          cast_input_fragment.is_null() ? nullptr : cast_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cast_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cast_input in DataTypeLimits struct");

      decltype(Traits::clamp_input(input)) in_clamp_input = Traits::clamp_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->clamp_input)::BaseType> clamp_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_clamp_input,
        clamp_input_fragment);

      fragment->clamp_input.Set(
          clamp_input_fragment.is_null() ? nullptr : clamp_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->clamp_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clamp_input in DataTypeLimits struct");

      decltype(Traits::concat_inputs(input)) in_concat_inputs = Traits::concat_inputs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->concat_inputs)::BaseType> concat_inputs_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_concat_inputs,
        concat_inputs_fragment);

      fragment->concat_inputs.Set(
          concat_inputs_fragment.is_null() ? nullptr : concat_inputs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->concat_inputs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null concat_inputs in DataTypeLimits struct");

      decltype(Traits::conv2d_input(input)) in_conv2d_input = Traits::conv2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conv2d_input)::BaseType> conv2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_conv2d_input,
        conv2d_input_fragment);

      fragment->conv2d_input.Set(
          conv2d_input_fragment.is_null() ? nullptr : conv2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conv2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conv2d_input in DataTypeLimits struct");

      decltype(Traits::conv2d_bias(input)) in_conv2d_bias = Traits::conv2d_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conv2d_bias)::BaseType> conv2d_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_conv2d_bias,
        conv2d_bias_fragment);

      fragment->conv2d_bias.Set(
          conv2d_bias_fragment.is_null() ? nullptr : conv2d_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conv2d_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conv2d_bias in DataTypeLimits struct");

      decltype(Traits::conv_transpose2d_input(input)) in_conv_transpose2d_input = Traits::conv_transpose2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conv_transpose2d_input)::BaseType> conv_transpose2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_conv_transpose2d_input,
        conv_transpose2d_input_fragment);

      fragment->conv_transpose2d_input.Set(
          conv_transpose2d_input_fragment.is_null() ? nullptr : conv_transpose2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conv_transpose2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conv_transpose2d_input in DataTypeLimits struct");

      decltype(Traits::conv_transpose2d_bias(input)) in_conv_transpose2d_bias = Traits::conv_transpose2d_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conv_transpose2d_bias)::BaseType> conv_transpose2d_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_conv_transpose2d_bias,
        conv_transpose2d_bias_fragment);

      fragment->conv_transpose2d_bias.Set(
          conv_transpose2d_bias_fragment.is_null() ? nullptr : conv_transpose2d_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conv_transpose2d_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conv_transpose2d_bias in DataTypeLimits struct");

      decltype(Traits::cumulative_sum_input(input)) in_cumulative_sum_input = Traits::cumulative_sum_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cumulative_sum_input)::BaseType> cumulative_sum_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_cumulative_sum_input,
        cumulative_sum_input_fragment);

      fragment->cumulative_sum_input.Set(
          cumulative_sum_input_fragment.is_null() ? nullptr : cumulative_sum_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cumulative_sum_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cumulative_sum_input in DataTypeLimits struct");

      decltype(Traits::dequantize_linear_input(input)) in_dequantize_linear_input = Traits::dequantize_linear_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dequantize_linear_input)::BaseType> dequantize_linear_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_dequantize_linear_input,
        dequantize_linear_input_fragment);

      fragment->dequantize_linear_input.Set(
          dequantize_linear_input_fragment.is_null() ? nullptr : dequantize_linear_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dequantize_linear_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dequantize_linear_input in DataTypeLimits struct");

      decltype(Traits::dequantize_linear_scale(input)) in_dequantize_linear_scale = Traits::dequantize_linear_scale(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dequantize_linear_scale)::BaseType> dequantize_linear_scale_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_dequantize_linear_scale,
        dequantize_linear_scale_fragment);

      fragment->dequantize_linear_scale.Set(
          dequantize_linear_scale_fragment.is_null() ? nullptr : dequantize_linear_scale_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dequantize_linear_scale.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dequantize_linear_scale in DataTypeLimits struct");

      decltype(Traits::dequantize_linear_zero_point(input)) in_dequantize_linear_zero_point = Traits::dequantize_linear_zero_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dequantize_linear_zero_point)::BaseType> dequantize_linear_zero_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_dequantize_linear_zero_point,
        dequantize_linear_zero_point_fragment);

      fragment->dequantize_linear_zero_point.Set(
          dequantize_linear_zero_point_fragment.is_null() ? nullptr : dequantize_linear_zero_point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dequantize_linear_zero_point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dequantize_linear_zero_point in DataTypeLimits struct");

      decltype(Traits::add_input(input)) in_add_input = Traits::add_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->add_input)::BaseType> add_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_add_input,
        add_input_fragment);

      fragment->add_input.Set(
          add_input_fragment.is_null() ? nullptr : add_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->add_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null add_input in DataTypeLimits struct");

      decltype(Traits::sub_input(input)) in_sub_input = Traits::sub_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sub_input)::BaseType> sub_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_sub_input,
        sub_input_fragment);

      fragment->sub_input.Set(
          sub_input_fragment.is_null() ? nullptr : sub_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sub_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sub_input in DataTypeLimits struct");

      decltype(Traits::mul_input(input)) in_mul_input = Traits::mul_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mul_input)::BaseType> mul_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_mul_input,
        mul_input_fragment);

      fragment->mul_input.Set(
          mul_input_fragment.is_null() ? nullptr : mul_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mul_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mul_input in DataTypeLimits struct");

      decltype(Traits::div_input(input)) in_div_input = Traits::div_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->div_input)::BaseType> div_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_div_input,
        div_input_fragment);

      fragment->div_input.Set(
          div_input_fragment.is_null() ? nullptr : div_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->div_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null div_input in DataTypeLimits struct");

      decltype(Traits::max_input(input)) in_max_input = Traits::max_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_input)::BaseType> max_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_max_input,
        max_input_fragment);

      fragment->max_input.Set(
          max_input_fragment.is_null() ? nullptr : max_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_input in DataTypeLimits struct");

      decltype(Traits::min_input(input)) in_min_input = Traits::min_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_input)::BaseType> min_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_min_input,
        min_input_fragment);

      fragment->min_input.Set(
          min_input_fragment.is_null() ? nullptr : min_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_input in DataTypeLimits struct");

      decltype(Traits::pow_input(input)) in_pow_input = Traits::pow_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pow_input)::BaseType> pow_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_pow_input,
        pow_input_fragment);

      fragment->pow_input.Set(
          pow_input_fragment.is_null() ? nullptr : pow_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pow_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pow_input in DataTypeLimits struct");

      decltype(Traits::equal_input(input)) in_equal_input = Traits::equal_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->equal_input)::BaseType> equal_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_equal_input,
        equal_input_fragment);

      fragment->equal_input.Set(
          equal_input_fragment.is_null() ? nullptr : equal_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->equal_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null equal_input in DataTypeLimits struct");

      decltype(Traits::greater_input(input)) in_greater_input = Traits::greater_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->greater_input)::BaseType> greater_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_greater_input,
        greater_input_fragment);

      fragment->greater_input.Set(
          greater_input_fragment.is_null() ? nullptr : greater_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->greater_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null greater_input in DataTypeLimits struct");

      decltype(Traits::greater_or_equal_input(input)) in_greater_or_equal_input = Traits::greater_or_equal_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->greater_or_equal_input)::BaseType> greater_or_equal_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_greater_or_equal_input,
        greater_or_equal_input_fragment);

      fragment->greater_or_equal_input.Set(
          greater_or_equal_input_fragment.is_null() ? nullptr : greater_or_equal_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->greater_or_equal_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null greater_or_equal_input in DataTypeLimits struct");

      decltype(Traits::lesser_input(input)) in_lesser_input = Traits::lesser_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lesser_input)::BaseType> lesser_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lesser_input,
        lesser_input_fragment);

      fragment->lesser_input.Set(
          lesser_input_fragment.is_null() ? nullptr : lesser_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lesser_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lesser_input in DataTypeLimits struct");

      decltype(Traits::lesser_or_equal_input(input)) in_lesser_or_equal_input = Traits::lesser_or_equal_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lesser_or_equal_input)::BaseType> lesser_or_equal_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lesser_or_equal_input,
        lesser_or_equal_input_fragment);

      fragment->lesser_or_equal_input.Set(
          lesser_or_equal_input_fragment.is_null() ? nullptr : lesser_or_equal_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lesser_or_equal_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lesser_or_equal_input in DataTypeLimits struct");

      decltype(Traits::not_equal_input(input)) in_not_equal_input = Traits::not_equal_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->not_equal_input)::BaseType> not_equal_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_not_equal_input,
        not_equal_input_fragment);

      fragment->not_equal_input.Set(
          not_equal_input_fragment.is_null() ? nullptr : not_equal_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->not_equal_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null not_equal_input in DataTypeLimits struct");

      decltype(Traits::logical_and_input(input)) in_logical_and_input = Traits::logical_and_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->logical_and_input)::BaseType> logical_and_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_logical_and_input,
        logical_and_input_fragment);

      fragment->logical_and_input.Set(
          logical_and_input_fragment.is_null() ? nullptr : logical_and_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->logical_and_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null logical_and_input in DataTypeLimits struct");

      decltype(Traits::logical_or_input(input)) in_logical_or_input = Traits::logical_or_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->logical_or_input)::BaseType> logical_or_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_logical_or_input,
        logical_or_input_fragment);

      fragment->logical_or_input.Set(
          logical_or_input_fragment.is_null() ? nullptr : logical_or_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->logical_or_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null logical_or_input in DataTypeLimits struct");

      decltype(Traits::logical_xor_input(input)) in_logical_xor_input = Traits::logical_xor_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->logical_xor_input)::BaseType> logical_xor_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_logical_xor_input,
        logical_xor_input_fragment);

      fragment->logical_xor_input.Set(
          logical_xor_input_fragment.is_null() ? nullptr : logical_xor_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->logical_xor_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null logical_xor_input in DataTypeLimits struct");

      decltype(Traits::logical_not_input(input)) in_logical_not_input = Traits::logical_not_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->logical_not_input)::BaseType> logical_not_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_logical_not_input,
        logical_not_input_fragment);

      fragment->logical_not_input.Set(
          logical_not_input_fragment.is_null() ? nullptr : logical_not_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->logical_not_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null logical_not_input in DataTypeLimits struct");

      decltype(Traits::is_nan_input(input)) in_is_nan_input = Traits::is_nan_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->is_nan_input)::BaseType> is_nan_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_is_nan_input,
        is_nan_input_fragment);

      fragment->is_nan_input.Set(
          is_nan_input_fragment.is_null() ? nullptr : is_nan_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->is_nan_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null is_nan_input in DataTypeLimits struct");

      decltype(Traits::is_infinite_input(input)) in_is_infinite_input = Traits::is_infinite_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->is_infinite_input)::BaseType> is_infinite_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_is_infinite_input,
        is_infinite_input_fragment);

      fragment->is_infinite_input.Set(
          is_infinite_input_fragment.is_null() ? nullptr : is_infinite_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->is_infinite_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null is_infinite_input in DataTypeLimits struct");

      decltype(Traits::logical_output(input)) in_logical_output = Traits::logical_output(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->logical_output)::BaseType> logical_output_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedDataTypesDataView, send_validation>(
        in_logical_output,
        logical_output_fragment);

      fragment->logical_output.Set(
          logical_output_fragment.is_null() ? nullptr : logical_output_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->logical_output.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null logical_output in DataTypeLimits struct");

      decltype(Traits::abs_input(input)) in_abs_input = Traits::abs_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->abs_input)::BaseType> abs_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_abs_input,
        abs_input_fragment);

      fragment->abs_input.Set(
          abs_input_fragment.is_null() ? nullptr : abs_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->abs_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null abs_input in DataTypeLimits struct");

      decltype(Traits::ceil_input(input)) in_ceil_input = Traits::ceil_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ceil_input)::BaseType> ceil_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_ceil_input,
        ceil_input_fragment);

      fragment->ceil_input.Set(
          ceil_input_fragment.is_null() ? nullptr : ceil_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ceil_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ceil_input in DataTypeLimits struct");

      decltype(Traits::cos_input(input)) in_cos_input = Traits::cos_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cos_input)::BaseType> cos_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_cos_input,
        cos_input_fragment);

      fragment->cos_input.Set(
          cos_input_fragment.is_null() ? nullptr : cos_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cos_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cos_input in DataTypeLimits struct");

      decltype(Traits::erf_input(input)) in_erf_input = Traits::erf_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->erf_input)::BaseType> erf_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_erf_input,
        erf_input_fragment);

      fragment->erf_input.Set(
          erf_input_fragment.is_null() ? nullptr : erf_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->erf_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null erf_input in DataTypeLimits struct");

      decltype(Traits::exp_input(input)) in_exp_input = Traits::exp_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->exp_input)::BaseType> exp_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_exp_input,
        exp_input_fragment);

      fragment->exp_input.Set(
          exp_input_fragment.is_null() ? nullptr : exp_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->exp_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exp_input in DataTypeLimits struct");

      decltype(Traits::floor_input(input)) in_floor_input = Traits::floor_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->floor_input)::BaseType> floor_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_floor_input,
        floor_input_fragment);

      fragment->floor_input.Set(
          floor_input_fragment.is_null() ? nullptr : floor_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->floor_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null floor_input in DataTypeLimits struct");

      decltype(Traits::identity_input(input)) in_identity_input = Traits::identity_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->identity_input)::BaseType> identity_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_identity_input,
        identity_input_fragment);

      fragment->identity_input.Set(
          identity_input_fragment.is_null() ? nullptr : identity_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->identity_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null identity_input in DataTypeLimits struct");

      decltype(Traits::log_input(input)) in_log_input = Traits::log_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->log_input)::BaseType> log_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_log_input,
        log_input_fragment);

      fragment->log_input.Set(
          log_input_fragment.is_null() ? nullptr : log_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->log_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null log_input in DataTypeLimits struct");

      decltype(Traits::neg_input(input)) in_neg_input = Traits::neg_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->neg_input)::BaseType> neg_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_neg_input,
        neg_input_fragment);

      fragment->neg_input.Set(
          neg_input_fragment.is_null() ? nullptr : neg_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->neg_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null neg_input in DataTypeLimits struct");

      decltype(Traits::reciprocal_input(input)) in_reciprocal_input = Traits::reciprocal_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reciprocal_input)::BaseType> reciprocal_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reciprocal_input,
        reciprocal_input_fragment);

      fragment->reciprocal_input.Set(
          reciprocal_input_fragment.is_null() ? nullptr : reciprocal_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reciprocal_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reciprocal_input in DataTypeLimits struct");

      decltype(Traits::round_even_input(input)) in_round_even_input = Traits::round_even_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->round_even_input)::BaseType> round_even_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_round_even_input,
        round_even_input_fragment);

      fragment->round_even_input.Set(
          round_even_input_fragment.is_null() ? nullptr : round_even_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->round_even_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null round_even_input in DataTypeLimits struct");

      decltype(Traits::sign_input(input)) in_sign_input = Traits::sign_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sign_input)::BaseType> sign_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_sign_input,
        sign_input_fragment);

      fragment->sign_input.Set(
          sign_input_fragment.is_null() ? nullptr : sign_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sign_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sign_input in DataTypeLimits struct");

      decltype(Traits::sin_input(input)) in_sin_input = Traits::sin_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sin_input)::BaseType> sin_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_sin_input,
        sin_input_fragment);

      fragment->sin_input.Set(
          sin_input_fragment.is_null() ? nullptr : sin_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sin_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sin_input in DataTypeLimits struct");

      decltype(Traits::sqrt_input(input)) in_sqrt_input = Traits::sqrt_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sqrt_input)::BaseType> sqrt_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_sqrt_input,
        sqrt_input_fragment);

      fragment->sqrt_input.Set(
          sqrt_input_fragment.is_null() ? nullptr : sqrt_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sqrt_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sqrt_input in DataTypeLimits struct");

      decltype(Traits::tan_input(input)) in_tan_input = Traits::tan_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tan_input)::BaseType> tan_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_tan_input,
        tan_input_fragment);

      fragment->tan_input.Set(
          tan_input_fragment.is_null() ? nullptr : tan_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tan_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tan_input in DataTypeLimits struct");

      decltype(Traits::elu_input(input)) in_elu_input = Traits::elu_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->elu_input)::BaseType> elu_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_elu_input,
        elu_input_fragment);

      fragment->elu_input.Set(
          elu_input_fragment.is_null() ? nullptr : elu_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->elu_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elu_input in DataTypeLimits struct");

      decltype(Traits::expand_input(input)) in_expand_input = Traits::expand_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expand_input)::BaseType> expand_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_expand_input,
        expand_input_fragment);

      fragment->expand_input.Set(
          expand_input_fragment.is_null() ? nullptr : expand_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expand_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expand_input in DataTypeLimits struct");

      decltype(Traits::gather_input(input)) in_gather_input = Traits::gather_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_input)::BaseType> gather_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_input,
        gather_input_fragment);

      fragment->gather_input.Set(
          gather_input_fragment.is_null() ? nullptr : gather_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_input in DataTypeLimits struct");

      decltype(Traits::gather_indices(input)) in_gather_indices = Traits::gather_indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_indices)::BaseType> gather_indices_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_indices,
        gather_indices_fragment);

      fragment->gather_indices.Set(
          gather_indices_fragment.is_null() ? nullptr : gather_indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_indices in DataTypeLimits struct");

      decltype(Traits::gather_elements_input(input)) in_gather_elements_input = Traits::gather_elements_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_elements_input)::BaseType> gather_elements_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_elements_input,
        gather_elements_input_fragment);

      fragment->gather_elements_input.Set(
          gather_elements_input_fragment.is_null() ? nullptr : gather_elements_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_elements_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_elements_input in DataTypeLimits struct");

      decltype(Traits::gather_elements_indices(input)) in_gather_elements_indices = Traits::gather_elements_indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_elements_indices)::BaseType> gather_elements_indices_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_elements_indices,
        gather_elements_indices_fragment);

      fragment->gather_elements_indices.Set(
          gather_elements_indices_fragment.is_null() ? nullptr : gather_elements_indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_elements_indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_elements_indices in DataTypeLimits struct");

      decltype(Traits::gather_nd_input(input)) in_gather_nd_input = Traits::gather_nd_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_nd_input)::BaseType> gather_nd_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_nd_input,
        gather_nd_input_fragment);

      fragment->gather_nd_input.Set(
          gather_nd_input_fragment.is_null() ? nullptr : gather_nd_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_nd_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_nd_input in DataTypeLimits struct");

      decltype(Traits::gather_nd_indices(input)) in_gather_nd_indices = Traits::gather_nd_indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gather_nd_indices)::BaseType> gather_nd_indices_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gather_nd_indices,
        gather_nd_indices_fragment);

      fragment->gather_nd_indices.Set(
          gather_nd_indices_fragment.is_null() ? nullptr : gather_nd_indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gather_nd_indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gather_nd_indices in DataTypeLimits struct");

      decltype(Traits::gelu_input(input)) in_gelu_input = Traits::gelu_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gelu_input)::BaseType> gelu_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gelu_input,
        gelu_input_fragment);

      fragment->gelu_input.Set(
          gelu_input_fragment.is_null() ? nullptr : gelu_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gelu_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gelu_input in DataTypeLimits struct");

      decltype(Traits::gemm_a(input)) in_gemm_a = Traits::gemm_a(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gemm_a)::BaseType> gemm_a_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gemm_a,
        gemm_a_fragment);

      fragment->gemm_a.Set(
          gemm_a_fragment.is_null() ? nullptr : gemm_a_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gemm_a.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gemm_a in DataTypeLimits struct");

      decltype(Traits::gemm_c(input)) in_gemm_c = Traits::gemm_c(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gemm_c)::BaseType> gemm_c_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gemm_c,
        gemm_c_fragment);

      fragment->gemm_c.Set(
          gemm_c_fragment.is_null() ? nullptr : gemm_c_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gemm_c.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gemm_c in DataTypeLimits struct");

      decltype(Traits::gru_input(input)) in_gru_input = Traits::gru_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gru_input)::BaseType> gru_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gru_input,
        gru_input_fragment);

      fragment->gru_input.Set(
          gru_input_fragment.is_null() ? nullptr : gru_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gru_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gru_input in DataTypeLimits struct");

      decltype(Traits::gru_bias(input)) in_gru_bias = Traits::gru_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gru_bias)::BaseType> gru_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gru_bias,
        gru_bias_fragment);

      fragment->gru_bias.Set(
          gru_bias_fragment.is_null() ? nullptr : gru_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gru_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gru_bias in DataTypeLimits struct");

      decltype(Traits::gru_output_sequence(input)) in_gru_output_sequence = Traits::gru_output_sequence(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gru_output_sequence)::BaseType> gru_output_sequence_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gru_output_sequence,
        gru_output_sequence_fragment);

      fragment->gru_output_sequence.Set(
          gru_output_sequence_fragment.is_null() ? nullptr : gru_output_sequence_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gru_output_sequence.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gru_output_sequence in DataTypeLimits struct");

      decltype(Traits::gru_cell_input(input)) in_gru_cell_input = Traits::gru_cell_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gru_cell_input)::BaseType> gru_cell_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gru_cell_input,
        gru_cell_input_fragment);

      fragment->gru_cell_input.Set(
          gru_cell_input_fragment.is_null() ? nullptr : gru_cell_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gru_cell_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gru_cell_input in DataTypeLimits struct");

      decltype(Traits::gru_cell_bias(input)) in_gru_cell_bias = Traits::gru_cell_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gru_cell_bias)::BaseType> gru_cell_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_gru_cell_bias,
        gru_cell_bias_fragment);

      fragment->gru_cell_bias.Set(
          gru_cell_bias_fragment.is_null() ? nullptr : gru_cell_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gru_cell_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gru_cell_bias in DataTypeLimits struct");

      decltype(Traits::hard_sigmoid_input(input)) in_hard_sigmoid_input = Traits::hard_sigmoid_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hard_sigmoid_input)::BaseType> hard_sigmoid_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_hard_sigmoid_input,
        hard_sigmoid_input_fragment);

      fragment->hard_sigmoid_input.Set(
          hard_sigmoid_input_fragment.is_null() ? nullptr : hard_sigmoid_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hard_sigmoid_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hard_sigmoid_input in DataTypeLimits struct");

      decltype(Traits::hard_swish_input(input)) in_hard_swish_input = Traits::hard_swish_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hard_swish_input)::BaseType> hard_swish_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_hard_swish_input,
        hard_swish_input_fragment);

      fragment->hard_swish_input.Set(
          hard_swish_input_fragment.is_null() ? nullptr : hard_swish_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hard_swish_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hard_swish_input in DataTypeLimits struct");

      decltype(Traits::instance_normalization_input(input)) in_instance_normalization_input = Traits::instance_normalization_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->instance_normalization_input)::BaseType> instance_normalization_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_instance_normalization_input,
        instance_normalization_input_fragment);

      fragment->instance_normalization_input.Set(
          instance_normalization_input_fragment.is_null() ? nullptr : instance_normalization_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->instance_normalization_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_normalization_input in DataTypeLimits struct");

      decltype(Traits::instance_normalization_scale(input)) in_instance_normalization_scale = Traits::instance_normalization_scale(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->instance_normalization_scale)::BaseType> instance_normalization_scale_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_instance_normalization_scale,
        instance_normalization_scale_fragment);

      fragment->instance_normalization_scale.Set(
          instance_normalization_scale_fragment.is_null() ? nullptr : instance_normalization_scale_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->instance_normalization_scale.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_normalization_scale in DataTypeLimits struct");

      decltype(Traits::layer_normalization_input(input)) in_layer_normalization_input = Traits::layer_normalization_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->layer_normalization_input)::BaseType> layer_normalization_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_layer_normalization_input,
        layer_normalization_input_fragment);

      fragment->layer_normalization_input.Set(
          layer_normalization_input_fragment.is_null() ? nullptr : layer_normalization_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->layer_normalization_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layer_normalization_input in DataTypeLimits struct");

      decltype(Traits::leaky_relu_input(input)) in_leaky_relu_input = Traits::leaky_relu_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->leaky_relu_input)::BaseType> leaky_relu_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_leaky_relu_input,
        leaky_relu_input_fragment);

      fragment->leaky_relu_input.Set(
          leaky_relu_input_fragment.is_null() ? nullptr : leaky_relu_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->leaky_relu_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null leaky_relu_input in DataTypeLimits struct");

      decltype(Traits::linear_input(input)) in_linear_input = Traits::linear_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->linear_input)::BaseType> linear_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_linear_input,
        linear_input_fragment);

      fragment->linear_input.Set(
          linear_input_fragment.is_null() ? nullptr : linear_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->linear_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null linear_input in DataTypeLimits struct");

      decltype(Traits::lstm_input(input)) in_lstm_input = Traits::lstm_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lstm_input)::BaseType> lstm_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lstm_input,
        lstm_input_fragment);

      fragment->lstm_input.Set(
          lstm_input_fragment.is_null() ? nullptr : lstm_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lstm_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lstm_input in DataTypeLimits struct");

      decltype(Traits::lstm_bias(input)) in_lstm_bias = Traits::lstm_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lstm_bias)::BaseType> lstm_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lstm_bias,
        lstm_bias_fragment);

      fragment->lstm_bias.Set(
          lstm_bias_fragment.is_null() ? nullptr : lstm_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lstm_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lstm_bias in DataTypeLimits struct");

      decltype(Traits::lstm_output_sequence(input)) in_lstm_output_sequence = Traits::lstm_output_sequence(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lstm_output_sequence)::BaseType> lstm_output_sequence_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lstm_output_sequence,
        lstm_output_sequence_fragment);

      fragment->lstm_output_sequence.Set(
          lstm_output_sequence_fragment.is_null() ? nullptr : lstm_output_sequence_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lstm_output_sequence.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lstm_output_sequence in DataTypeLimits struct");

      decltype(Traits::lstm_cell_input(input)) in_lstm_cell_input = Traits::lstm_cell_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lstm_cell_input)::BaseType> lstm_cell_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lstm_cell_input,
        lstm_cell_input_fragment);

      fragment->lstm_cell_input.Set(
          lstm_cell_input_fragment.is_null() ? nullptr : lstm_cell_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lstm_cell_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lstm_cell_input in DataTypeLimits struct");

      decltype(Traits::lstm_cell_bias(input)) in_lstm_cell_bias = Traits::lstm_cell_bias(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lstm_cell_bias)::BaseType> lstm_cell_bias_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_lstm_cell_bias,
        lstm_cell_bias_fragment);

      fragment->lstm_cell_bias.Set(
          lstm_cell_bias_fragment.is_null() ? nullptr : lstm_cell_bias_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lstm_cell_bias.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lstm_cell_bias in DataTypeLimits struct");

      decltype(Traits::matmul_input(input)) in_matmul_input = Traits::matmul_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->matmul_input)::BaseType> matmul_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_matmul_input,
        matmul_input_fragment);

      fragment->matmul_input.Set(
          matmul_input_fragment.is_null() ? nullptr : matmul_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->matmul_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null matmul_input in DataTypeLimits struct");

      decltype(Traits::pad_input(input)) in_pad_input = Traits::pad_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pad_input)::BaseType> pad_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_pad_input,
        pad_input_fragment);

      fragment->pad_input.Set(
          pad_input_fragment.is_null() ? nullptr : pad_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pad_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pad_input in DataTypeLimits struct");

      decltype(Traits::average_pool2d_input(input)) in_average_pool2d_input = Traits::average_pool2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->average_pool2d_input)::BaseType> average_pool2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_average_pool2d_input,
        average_pool2d_input_fragment);

      fragment->average_pool2d_input.Set(
          average_pool2d_input_fragment.is_null() ? nullptr : average_pool2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->average_pool2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null average_pool2d_input in DataTypeLimits struct");

      decltype(Traits::l2_pool2d_input(input)) in_l2_pool2d_input = Traits::l2_pool2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->l2_pool2d_input)::BaseType> l2_pool2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_l2_pool2d_input,
        l2_pool2d_input_fragment);

      fragment->l2_pool2d_input.Set(
          l2_pool2d_input_fragment.is_null() ? nullptr : l2_pool2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->l2_pool2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null l2_pool2d_input in DataTypeLimits struct");

      decltype(Traits::max_pool2d_input(input)) in_max_pool2d_input = Traits::max_pool2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_pool2d_input)::BaseType> max_pool2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_max_pool2d_input,
        max_pool2d_input_fragment);

      fragment->max_pool2d_input.Set(
          max_pool2d_input_fragment.is_null() ? nullptr : max_pool2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_pool2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_pool2d_input in DataTypeLimits struct");

      decltype(Traits::prelu_input(input)) in_prelu_input = Traits::prelu_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->prelu_input)::BaseType> prelu_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_prelu_input,
        prelu_input_fragment);

      fragment->prelu_input.Set(
          prelu_input_fragment.is_null() ? nullptr : prelu_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->prelu_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prelu_input in DataTypeLimits struct");

      decltype(Traits::quantize_linear_input(input)) in_quantize_linear_input = Traits::quantize_linear_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quantize_linear_input)::BaseType> quantize_linear_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_quantize_linear_input,
        quantize_linear_input_fragment);

      fragment->quantize_linear_input.Set(
          quantize_linear_input_fragment.is_null() ? nullptr : quantize_linear_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quantize_linear_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quantize_linear_input in DataTypeLimits struct");

      decltype(Traits::quantize_linear_zero_point(input)) in_quantize_linear_zero_point = Traits::quantize_linear_zero_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quantize_linear_zero_point)::BaseType> quantize_linear_zero_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_quantize_linear_zero_point,
        quantize_linear_zero_point_fragment);

      fragment->quantize_linear_zero_point.Set(
          quantize_linear_zero_point_fragment.is_null() ? nullptr : quantize_linear_zero_point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quantize_linear_zero_point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quantize_linear_zero_point in DataTypeLimits struct");

      decltype(Traits::reduce_l1_input(input)) in_reduce_l1_input = Traits::reduce_l1_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_l1_input)::BaseType> reduce_l1_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_l1_input,
        reduce_l1_input_fragment);

      fragment->reduce_l1_input.Set(
          reduce_l1_input_fragment.is_null() ? nullptr : reduce_l1_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_l1_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_l1_input in DataTypeLimits struct");

      decltype(Traits::reduce_l2_input(input)) in_reduce_l2_input = Traits::reduce_l2_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_l2_input)::BaseType> reduce_l2_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_l2_input,
        reduce_l2_input_fragment);

      fragment->reduce_l2_input.Set(
          reduce_l2_input_fragment.is_null() ? nullptr : reduce_l2_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_l2_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_l2_input in DataTypeLimits struct");

      decltype(Traits::reduce_log_sum_input(input)) in_reduce_log_sum_input = Traits::reduce_log_sum_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_log_sum_input)::BaseType> reduce_log_sum_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_log_sum_input,
        reduce_log_sum_input_fragment);

      fragment->reduce_log_sum_input.Set(
          reduce_log_sum_input_fragment.is_null() ? nullptr : reduce_log_sum_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_log_sum_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_log_sum_input in DataTypeLimits struct");

      decltype(Traits::reduce_log_sum_exp_input(input)) in_reduce_log_sum_exp_input = Traits::reduce_log_sum_exp_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_log_sum_exp_input)::BaseType> reduce_log_sum_exp_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_log_sum_exp_input,
        reduce_log_sum_exp_input_fragment);

      fragment->reduce_log_sum_exp_input.Set(
          reduce_log_sum_exp_input_fragment.is_null() ? nullptr : reduce_log_sum_exp_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_log_sum_exp_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_log_sum_exp_input in DataTypeLimits struct");

      decltype(Traits::reduce_max_input(input)) in_reduce_max_input = Traits::reduce_max_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_max_input)::BaseType> reduce_max_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_max_input,
        reduce_max_input_fragment);

      fragment->reduce_max_input.Set(
          reduce_max_input_fragment.is_null() ? nullptr : reduce_max_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_max_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_max_input in DataTypeLimits struct");

      decltype(Traits::reduce_mean_input(input)) in_reduce_mean_input = Traits::reduce_mean_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_mean_input)::BaseType> reduce_mean_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_mean_input,
        reduce_mean_input_fragment);

      fragment->reduce_mean_input.Set(
          reduce_mean_input_fragment.is_null() ? nullptr : reduce_mean_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_mean_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_mean_input in DataTypeLimits struct");

      decltype(Traits::reduce_min_input(input)) in_reduce_min_input = Traits::reduce_min_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_min_input)::BaseType> reduce_min_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_min_input,
        reduce_min_input_fragment);

      fragment->reduce_min_input.Set(
          reduce_min_input_fragment.is_null() ? nullptr : reduce_min_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_min_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_min_input in DataTypeLimits struct");

      decltype(Traits::reduce_product_input(input)) in_reduce_product_input = Traits::reduce_product_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_product_input)::BaseType> reduce_product_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_product_input,
        reduce_product_input_fragment);

      fragment->reduce_product_input.Set(
          reduce_product_input_fragment.is_null() ? nullptr : reduce_product_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_product_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_product_input in DataTypeLimits struct");

      decltype(Traits::reduce_sum_input(input)) in_reduce_sum_input = Traits::reduce_sum_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_sum_input)::BaseType> reduce_sum_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_sum_input,
        reduce_sum_input_fragment);

      fragment->reduce_sum_input.Set(
          reduce_sum_input_fragment.is_null() ? nullptr : reduce_sum_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_sum_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_sum_input in DataTypeLimits struct");

      decltype(Traits::reduce_sum_square_input(input)) in_reduce_sum_square_input = Traits::reduce_sum_square_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reduce_sum_square_input)::BaseType> reduce_sum_square_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reduce_sum_square_input,
        reduce_sum_square_input_fragment);

      fragment->reduce_sum_square_input.Set(
          reduce_sum_square_input_fragment.is_null() ? nullptr : reduce_sum_square_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reduce_sum_square_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reduce_sum_square_input in DataTypeLimits struct");

      decltype(Traits::relu_input(input)) in_relu_input = Traits::relu_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->relu_input)::BaseType> relu_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_relu_input,
        relu_input_fragment);

      fragment->relu_input.Set(
          relu_input_fragment.is_null() ? nullptr : relu_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->relu_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relu_input in DataTypeLimits struct");

      decltype(Traits::resample2d_input(input)) in_resample2d_input = Traits::resample2d_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resample2d_input)::BaseType> resample2d_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_resample2d_input,
        resample2d_input_fragment);

      fragment->resample2d_input.Set(
          resample2d_input_fragment.is_null() ? nullptr : resample2d_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resample2d_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resample2d_input in DataTypeLimits struct");

      decltype(Traits::reshape_input(input)) in_reshape_input = Traits::reshape_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reshape_input)::BaseType> reshape_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reshape_input,
        reshape_input_fragment);

      fragment->reshape_input.Set(
          reshape_input_fragment.is_null() ? nullptr : reshape_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reshape_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reshape_input in DataTypeLimits struct");

      decltype(Traits::reverse_input(input)) in_reverse_input = Traits::reverse_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reverse_input)::BaseType> reverse_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_reverse_input,
        reverse_input_fragment);

      fragment->reverse_input.Set(
          reverse_input_fragment.is_null() ? nullptr : reverse_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reverse_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reverse_input in DataTypeLimits struct");

      decltype(Traits::scatter_elements_input(input)) in_scatter_elements_input = Traits::scatter_elements_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scatter_elements_input)::BaseType> scatter_elements_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_scatter_elements_input,
        scatter_elements_input_fragment);

      fragment->scatter_elements_input.Set(
          scatter_elements_input_fragment.is_null() ? nullptr : scatter_elements_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scatter_elements_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scatter_elements_input in DataTypeLimits struct");

      decltype(Traits::scatter_elements_indices(input)) in_scatter_elements_indices = Traits::scatter_elements_indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scatter_elements_indices)::BaseType> scatter_elements_indices_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_scatter_elements_indices,
        scatter_elements_indices_fragment);

      fragment->scatter_elements_indices.Set(
          scatter_elements_indices_fragment.is_null() ? nullptr : scatter_elements_indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scatter_elements_indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scatter_elements_indices in DataTypeLimits struct");

      decltype(Traits::scatter_nd_input(input)) in_scatter_nd_input = Traits::scatter_nd_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scatter_nd_input)::BaseType> scatter_nd_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_scatter_nd_input,
        scatter_nd_input_fragment);

      fragment->scatter_nd_input.Set(
          scatter_nd_input_fragment.is_null() ? nullptr : scatter_nd_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scatter_nd_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scatter_nd_input in DataTypeLimits struct");

      decltype(Traits::scatter_nd_indices(input)) in_scatter_nd_indices = Traits::scatter_nd_indices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scatter_nd_indices)::BaseType> scatter_nd_indices_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_scatter_nd_indices,
        scatter_nd_indices_fragment);

      fragment->scatter_nd_indices.Set(
          scatter_nd_indices_fragment.is_null() ? nullptr : scatter_nd_indices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scatter_nd_indices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scatter_nd_indices in DataTypeLimits struct");

      decltype(Traits::scatter_nd_updates(input)) in_scatter_nd_updates = Traits::scatter_nd_updates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scatter_nd_updates)::BaseType> scatter_nd_updates_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_scatter_nd_updates,
        scatter_nd_updates_fragment);

      fragment->scatter_nd_updates.Set(
          scatter_nd_updates_fragment.is_null() ? nullptr : scatter_nd_updates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scatter_nd_updates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scatter_nd_updates in DataTypeLimits struct");

      decltype(Traits::sigmoid_input(input)) in_sigmoid_input = Traits::sigmoid_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sigmoid_input)::BaseType> sigmoid_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_sigmoid_input,
        sigmoid_input_fragment);

      fragment->sigmoid_input.Set(
          sigmoid_input_fragment.is_null() ? nullptr : sigmoid_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sigmoid_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sigmoid_input in DataTypeLimits struct");

      decltype(Traits::slice_input(input)) in_slice_input = Traits::slice_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->slice_input)::BaseType> slice_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_slice_input,
        slice_input_fragment);

      fragment->slice_input.Set(
          slice_input_fragment.is_null() ? nullptr : slice_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->slice_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null slice_input in DataTypeLimits struct");

      decltype(Traits::softmax_input(input)) in_softmax_input = Traits::softmax_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->softmax_input)::BaseType> softmax_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_softmax_input,
        softmax_input_fragment);

      fragment->softmax_input.Set(
          softmax_input_fragment.is_null() ? nullptr : softmax_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->softmax_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null softmax_input in DataTypeLimits struct");

      decltype(Traits::softplus_input(input)) in_softplus_input = Traits::softplus_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->softplus_input)::BaseType> softplus_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_softplus_input,
        softplus_input_fragment);

      fragment->softplus_input.Set(
          softplus_input_fragment.is_null() ? nullptr : softplus_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->softplus_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null softplus_input in DataTypeLimits struct");

      decltype(Traits::softsign_input(input)) in_softsign_input = Traits::softsign_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->softsign_input)::BaseType> softsign_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_softsign_input,
        softsign_input_fragment);

      fragment->softsign_input.Set(
          softsign_input_fragment.is_null() ? nullptr : softsign_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->softsign_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null softsign_input in DataTypeLimits struct");

      decltype(Traits::split_input(input)) in_split_input = Traits::split_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->split_input)::BaseType> split_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_split_input,
        split_input_fragment);

      fragment->split_input.Set(
          split_input_fragment.is_null() ? nullptr : split_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->split_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null split_input in DataTypeLimits struct");

      decltype(Traits::tanh_input(input)) in_tanh_input = Traits::tanh_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tanh_input)::BaseType> tanh_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_tanh_input,
        tanh_input_fragment);

      fragment->tanh_input.Set(
          tanh_input_fragment.is_null() ? nullptr : tanh_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tanh_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tanh_input in DataTypeLimits struct");

      decltype(Traits::tile_input(input)) in_tile_input = Traits::tile_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tile_input)::BaseType> tile_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_tile_input,
        tile_input_fragment);

      fragment->tile_input.Set(
          tile_input_fragment.is_null() ? nullptr : tile_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tile_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tile_input in DataTypeLimits struct");

      decltype(Traits::transpose_input(input)) in_transpose_input = Traits::transpose_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transpose_input)::BaseType> transpose_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_transpose_input,
        transpose_input_fragment);

      fragment->transpose_input.Set(
          transpose_input_fragment.is_null() ? nullptr : transpose_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transpose_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transpose_input in DataTypeLimits struct");

      decltype(Traits::triangular_input(input)) in_triangular_input = Traits::triangular_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->triangular_input)::BaseType> triangular_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_triangular_input,
        triangular_input_fragment);

      fragment->triangular_input.Set(
          triangular_input_fragment.is_null() ? nullptr : triangular_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->triangular_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null triangular_input in DataTypeLimits struct");

      decltype(Traits::where_condition(input)) in_where_condition = Traits::where_condition(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->where_condition)::BaseType> where_condition_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_where_condition,
        where_condition_fragment);

      fragment->where_condition.Set(
          where_condition_fragment.is_null() ? nullptr : where_condition_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->where_condition.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null where_condition in DataTypeLimits struct");

      decltype(Traits::where_value(input)) in_where_value = Traits::where_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->where_value)::BaseType> where_value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::SupportedTensorsDataView, send_validation>(
        in_where_value,
        where_value_fragment);

      fragment->where_value.Set(
          where_value_fragment.is_null() ? nullptr : where_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->where_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null where_value in DataTypeLimits struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::ContextPropertiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::ContextPropertiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::ContextProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::webnn::mojom::InputOperandLayout>(
        Traits::input_operand_layout(input),
        &fragment->input_operand_layout);

      
      mojo::internal::Serialize<::webnn::mojom::Resample2DAxes>(
        Traits::resample_2d_axes(input),
        &fragment->resample_2d_axes);

      
      mojo::internal::Serialize<::webnn::mojom::BatchNormalizationAxis>(
        Traits::batch_normalization_axis(input),
        &fragment->batch_normalization_axis);

      fragment->tensor_byte_length_limit = Traits::tensor_byte_length_limit(input);

      decltype(Traits::data_type_limits(input)) in_data_type_limits = Traits::data_type_limits(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data_type_limits)::BaseType> data_type_limits_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::DataTypeLimitsDataView, send_validation>(
        in_data_type_limits,
        data_type_limits_fragment);

      fragment->data_type_limits.Set(
          data_type_limits_fragment.is_null() ? nullptr : data_type_limits_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_type_limits.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_type_limits in ContextProperties struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_SEND_VALIDATION_H_