// services/webnn/public/mojom/webnn_context.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SEND_VALIDATION_H_

#include "services/webnn/public/mojom/webnn_context.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

#include "services/webnn/public/mojom/webnn_context.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateTensorSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateTensorSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateTensorSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tensor_remote(input)) in_tensor_remote = Traits::tensor_remote(input);

      
      mojo::internal::Serialize<::webnn::mojom::WebNNTensorAssociatedPtrInfoDataView>(
        in_tensor_remote,
        &fragment->tensor_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->tensor_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid tensor_remote in CreateTensorSuccess struct");

      decltype(Traits::tensor_handle(input)) in_tensor_handle = Traits::tensor_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tensor_handle)::BaseType> tensor_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WebNNTensorTokenDataView, send_validation>(
        in_tensor_handle,
        tensor_handle_fragment);

      fragment->tensor_handle.Set(
          tensor_handle_fragment.is_null() ? nullptr : tensor_handle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tensor_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tensor_handle in CreateTensorSuccess struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::CreateTensorResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::CreateTensorResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::CreateTensorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::CreateTensorResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateTensorSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in CreateTensorResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::CreateTensorResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in CreateTensorResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SEND_VALIDATION_H_