// services/viz/public/mojom/hit_test/hit_test_region_list.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::HitTestRegionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::HitTestRegionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::HitTestRegion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->flags = Traits::flags(input);

      fragment->async_hit_test_reasons = Traits::async_hit_test_reasons(input);

      decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView, send_validation>(
        in_frame_sink_id,
        frame_sink_id_fragment);

      fragment->frame_sink_id.Set(
          frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in HitTestRegion struct");

      decltype(Traits::rect(input)) in_rect = Traits::rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rect)::BaseType> rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_rect,
        rect_fragment);

      fragment->rect.Set(
          rect_fragment.is_null() ? nullptr : rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in HitTestRegion struct");

      decltype(Traits::transform(input)) in_transform = Traits::transform(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transform)::BaseType> transform_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_transform,
        transform_fragment);

      fragment->transform.Set(
          transform_fragment.is_null() ? nullptr : transform_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transform.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform in HitTestRegion struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::HitTestRegionListDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::HitTestRegionListDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::HitTestRegionList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->flags = Traits::flags(input);

      fragment->async_hit_test_reasons = Traits::async_hit_test_reasons(input);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in HitTestRegionList struct");

      decltype(Traits::transform(input)) in_transform = Traits::transform(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transform)::BaseType> transform_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_transform,
        transform_fragment);

      fragment->transform.Set(
          transform_fragment.is_null() ? nullptr : transform_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transform.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform in HitTestRegionList struct");

      decltype(Traits::regions(input)) in_regions = Traits::regions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->regions)::BaseType>
          regions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& regions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::HitTestRegionDataView>, send_validation>(
        in_regions,
        regions_fragment,
        &regions_validate_params);

      fragment->regions.Set(
          regions_fragment.is_null() ? nullptr : regions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->regions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null regions in HitTestRegionList struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_SEND_VALIDATION_H_