// services/viz/public/mojom/gpu.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('viz.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.GpuPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.Gpu.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { viz.mojom.GpuInterface }
 */
viz.mojom.GpuRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.GpuPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.GpuPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.GpuPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        clientId: !number,
        channelHandle: ?MojoHandle,
        gpuInfo: !gpu.mojom.GpuInfo,
        gpuFeatureInfo: !gpu.mojom.GpuFeatureInfo,
        sharedImageCapabilities: !gpu.mojom.SharedImageCapabilities,
   *  }>}
   */

  establishGpuChannel() {
    return this.proxy.sendMessage(
        0,
        viz.mojom.Gpu_EstablishGpuChannel_ParamsSpec.$,
        viz.mojom.Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoEncodeAcceleratorProviderPendingReceiver } veaProvider
   */

  createVideoEncodeAcceleratorProvider(
      veaProvider) {
    this.proxy.sendMessage(
        1,
        viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        [
          veaProvider
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Gpu
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.GpuReceiver = class {
  /**
   * @param {!viz.mojom.GpuInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.GpuRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.GpuRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.GpuRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.Gpu_EstablishGpuChannel_ParamsSpec.$,
        viz.mojom.Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        impl.establishGpuChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        impl.createVideoEncodeAcceleratorProvider.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.Gpu = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.Gpu";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.GpuRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.GpuRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Gpu
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.GpuCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.GpuRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.GpuRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.establishGpuChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.Gpu_EstablishGpuChannel_ParamsSpec.$,
        viz.mojom.Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
        this.establishGpuChannel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoEncodeAcceleratorProvider =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
        null,
        this.createVideoEncodeAcceleratorProvider.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.Gpu_EstablishGpuChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.Gpu_EstablishGpuChannel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    viz.mojom.Gpu_EstablishGpuChannel_ParamsSpec.$,
    'Gpu_EstablishGpuChannel_Params',
    [
    ],
    [[0, 8],]);





/** @record */
viz.mojom.Gpu_EstablishGpuChannel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    viz.mojom.Gpu_EstablishGpuChannel_ResponseParamsSpec.$,
    'Gpu_EstablishGpuChannel_ResponseParams',
    [
      mojo.internal.StructField(
        'clientId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelHandle', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gpuInfo', 8,
        0,
        gpu.mojom.GpuInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gpuFeatureInfo', 16,
        0,
        gpu.mojom.GpuFeatureInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedImageCapabilities', 24,
        0,
        gpu.mojom.SharedImageCapabilitiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
viz.mojom.Gpu_EstablishGpuChannel_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.clientId;
    /** @export { (MojoHandle|undefined) } */
    this.channelHandle;
    /** @export { !gpu.mojom.GpuInfo } */
    this.gpuInfo;
    /** @export { !gpu.mojom.GpuFeatureInfo } */
    this.gpuFeatureInfo;
    /** @export { !gpu.mojom.SharedImageCapabilities } */
    this.sharedImageCapabilities;
  }
};



mojo.internal.Struct(
    viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_ParamsSpec.$,
    'Gpu_CreateVideoEncodeAcceleratorProvider_Params',
    [
      mojo.internal.StructField(
        'veaProvider', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.VideoEncodeAcceleratorProviderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
viz.mojom.Gpu_CreateVideoEncodeAcceleratorProvider_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoEncodeAcceleratorProviderPendingReceiver } */
    this.veaProvider;
  }
};

