// services/viz/public/mojom/compositing/texture_releaser.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace viz::mojom::blink {
// The declaration includes the definition on other builds.

TextureReleaser::IPCStableHashFunction TextureReleaser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextureReleaser>(message.name())) {
    case messages::TextureReleaser::kRelease: {
      return &TextureReleaser::Release_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextureReleaser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextureReleaser>(message.name())) {
      case messages::TextureReleaser::kRelease:
            return "Receive viz::mojom::TextureReleaser::Release";
    }
  } else {
    switch (static_cast<messages::TextureReleaser>(message.name())) {
      case messages::TextureReleaser::kRelease:
            return "Receive reply viz::mojom::TextureReleaser::Release";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextureReleaser::Release_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c876e3a;  // IPCStableHash for viz::mojom::TextureReleaser::Release
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextureReleaserProxy::TextureReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextureReleaserProxy::Release(
    const ::gpu::SyncToken& in_sync_token, bool in_is_lost) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::TextureReleaser::Release", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_lost"), in_is_lost,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextureReleaser::kRelease), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::TextureReleaser_Release_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_sync_token,
    sync_token_fragment);

  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sync_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sync_token in TextureReleaser.Release request");

  params->is_lost = in_is_lost;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureReleaser::Name_);
  message.set_method_name("Release");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextureReleaserStubDispatch::Accept(
    TextureReleaser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextureReleaser>(message->header()->name)) {
    case messages::TextureReleaser::kRelease: {
      DCHECK(message->is_serialized());
      internal::TextureReleaser_Release_Params_Data* params =
          reinterpret_cast<internal::TextureReleaser_Release_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextureReleaser.0
      bool success = true;
      ::gpu::SyncToken p_sync_token{};
      bool p_is_lost{};
      TextureReleaser_Release_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success)
        p_is_lost = input_data_view.is_lost();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureReleaser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Release(        
        std::move(p_sync_token), 
        std::move(p_is_lost));
      return true;
    }
  }
  return false;
}

// static
bool TextureReleaserStubDispatch::AcceptWithResponder(
    TextureReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextureReleaser>(message->header()->name)) {
    case messages::TextureReleaser::kRelease: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextureReleaserValidationInfo[] = {
    { &internal::TextureReleaser_Release_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextureReleaserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::TextureReleaser::Name_,
    kTextureReleaserValidationInfo);
}



}  // viz::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {


void TextureReleaserInterceptorForTesting::Release(const ::gpu::SyncToken& sync_token, bool is_lost) {
  GetForwardingInterface()->Release(
    std::move(sync_token)
    , 
    std::move(is_lost)
    );
}
TextureReleaserAsyncWaiter::TextureReleaserAsyncWaiter(
    TextureReleaser* proxy) : proxy_(proxy) {}

TextureReleaserAsyncWaiter::~TextureReleaserAsyncWaiter() = default;







}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif