// services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/internal/singleplanar_format.mojom-shared.h"




#include "services/viz/public/mojom/compositing/shared_image_format.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::PlaneConfig>
    : public mojo::internal::EnumHashImpl<::viz::mojom::PlaneConfig> {};

template <>
struct hash<::viz::mojom::Subsampling>
    : public mojo::internal::EnumHashImpl<::viz::mojom::Subsampling> {};

template <>
struct hash<::viz::mojom::ChannelFormat>
    : public mojo::internal::EnumHashImpl<::viz::mojom::ChannelFormat> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::PlaneConfig, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::PlaneConfig, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::PlaneConfig>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::Subsampling, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::Subsampling, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::Subsampling>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ChannelFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::ChannelFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::ChannelFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::MultiplanarFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::MultiplanarFormatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::MultiplanarFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::viz::mojom::PlaneConfig>(
      Traits::plane_config(input),
      &fragment->plane_config);

    
    mojo::internal::Serialize<::viz::mojom::Subsampling>(
      Traits::subsampling(input),
      &fragment->subsampling);

    
    mojo::internal::Serialize<::viz::mojom::ChannelFormat>(
      Traits::channel_format(input),
      &fragment->channel_format);
  }

  static bool Deserialize(::viz::mojom::internal::MultiplanarFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::MultiplanarFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SharedImageFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::SharedImageFormatDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::SharedImageFormat_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::SharedImageFormatDataView::Tag::kSingleplanarFormat: {
    decltype(Traits::singleplanar_format(input))
    in_singleplanar_format = Traits::singleplanar_format(input);
        
mojo::internal::Serialize<::viz::mojom::SingleplanarFormat>(
  in_singleplanar_format,
  &fragment->data.f_singleplanar_format);
    break;
  }
  case ::viz::mojom::SharedImageFormatDataView::Tag::kMultiplanarFormat: {
    decltype(Traits::multiplanar_format(input))
    in_multiplanar_format = Traits::multiplanar_format(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_multiplanar_format)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::MultiplanarFormatDataView>(
  in_multiplanar_format,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null multiplanar_format in SharedImageFormat union");
    fragment->data.f_multiplanar_format.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::viz::mojom::internal::SharedImageFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SharedImageFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {



inline void SharedImageFormatDataView::GetMultiplanarFormatDataView(
    MultiplanarFormatDataView* output) const {
  CHECK(is_multiplanar_format());
  *output = MultiplanarFormatDataView(data_->data.f_multiplanar_format.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::PlaneConfig> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::PlaneConfig value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::Subsampling> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::Subsampling value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::ChannelFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::ChannelFormat value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SHARED_H_