// services/viz/public/mojom/compositing/layer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {
// static
bool LayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const LayerExtra_Data* object = static_cast<const LayerExtra_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case LayerExtra_Tag::kMirrorLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_mirror_layer_extra, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_mirror_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kNinePatchThumbScrollbarLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_nine_patch_thumb_scrollbar_layer_extra, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_nine_patch_thumb_scrollbar_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kPaintedScrollbarLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_painted_scrollbar_layer_extra, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_painted_scrollbar_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kSolidColorScrollbarLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_solid_color_scrollbar_layer_extra, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_solid_color_scrollbar_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kSurfaceLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_surface_layer_extra, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_surface_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kTextureLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_texture_layer_extra, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_texture_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kUiResourceLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ui_resource_layer_extra, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_ui_resource_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kTileDisplayLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tile_display_layer_extra, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tile_display_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kViewTransitionContentLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_view_transition_content_layer_extra, 9, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_view_transition_content_layer_extra, validation_context))
        return false;
      return true;
    }
    case LayerExtra_Tag::kNinePatchLayerExtra: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_nine_patch_layer_extra, 10, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_nine_patch_layer_extra, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in LayerExtra");
      return false;
    }
  }
}


// static
bool RareProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RareProperties_Data* object =
      static_cast<const RareProperties_Data*>(data);


  if (!::cc::mojom::internal::FilterQuality_Data
        ::Validate(object->filter_quality, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dynamic_range_limit, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dynamic_range_limit, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_bounds, validation_context))
    return false;

  return true;
}

RareProperties_Data::RareProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MirrorLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MirrorLayerExtra_Data* object =
      static_cast<const MirrorLayerExtra_Data*>(data);

  return true;
}

MirrorLayerExtra_Data::MirrorLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SurfaceLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SurfaceLayerExtra_Data* object =
      static_cast<const SurfaceLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_range, validation_context))
    return false;

  return true;
}

SurfaceLayerExtra_Data::SurfaceLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextureLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextureLayerExtra_Data* object =
      static_cast<const TextureLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_top_left, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_top_left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_bottom_right, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_bottom_right, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->transferable_resource, validation_context))
    return false;

  return true;
}

TextureLayerExtra_Data::TextureLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UIResourceLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UIResourceLayerExtra_Data* object =
      static_cast<const UIResourceLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ui_resource_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ui_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_top_left, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_top_left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_bottom_right, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_bottom_right, validation_context))
    return false;

  return true;
}

UIResourceLayerExtra_Data::UIResourceLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TileDisplayLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TileDisplayLayerExtra_Data* object =
      static_cast<const TileDisplayLayerExtra_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->solid_color, validation_context))
    return false;


  if (!::gfx::mojom::internal::ContentColorUsage_Data
        ::Validate(object->content_color_usage, validation_context))
    return false;

  return true;
}

TileDisplayLayerExtra_Data::TileDisplayLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollbarLayerBaseExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollbarLayerBaseExtra_Data* object =
      static_cast<const ScrollbarLayerBaseExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_element_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_element_id, validation_context))
    return false;

  return true;
}

ScrollbarLayerBaseExtra_Data::ScrollbarLayerBaseExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NinePatchThumbScrollbarLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NinePatchThumbScrollbarLayerExtra_Data* object =
      static_cast<const NinePatchThumbScrollbarLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrollbar_base_extra, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrollbar_base_extra, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_bounds, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aperture, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aperture, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumb_ui_resource_id, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumb_ui_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->track_and_buttons_ui_resource_id, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->track_and_buttons_ui_resource_id, validation_context))
    return false;

  return true;
}

NinePatchThumbScrollbarLayerExtra_Data::NinePatchThumbScrollbarLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintedScrollbarLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintedScrollbarLayerExtra_Data* object =
      static_cast<const PaintedScrollbarLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrollbar_base_extra, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrollbar_base_extra, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->internal_content_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->internal_content_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->back_button_rect, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->back_button_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->forward_button_rect, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->forward_button_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->track_rect, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->track_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->thumb_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->track_and_buttons_image_bounds, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->track_and_buttons_image_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->track_and_buttons_aperture, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->track_and_buttons_aperture, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->track_and_buttons_ui_resource_id, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->track_and_buttons_ui_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumb_ui_resource_id, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumb_ui_resource_id, validation_context))
    return false;

  return true;
}

PaintedScrollbarLayerExtra_Data::PaintedScrollbarLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SolidColorScrollbarLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SolidColorScrollbarLayerExtra_Data* object =
      static_cast<const SolidColorScrollbarLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrollbar_base_extra, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrollbar_base_extra, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;

  return true;
}

SolidColorScrollbarLayerExtra_Data::SolidColorScrollbarLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewTransitionContentLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewTransitionContentLayerExtra_Data* object =
      static_cast<const ViewTransitionContentLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_extents_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_extents_rect, validation_context))
    return false;

  return true;
}

ViewTransitionContentLayerExtra_Data::ViewTransitionContentLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NinePatchLayerExtra_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NinePatchLayerExtra_Data* object =
      static_cast<const NinePatchLayerExtra_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_aperture, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_aperture, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->border, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->border, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layer_occlusion, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->layer_occlusion, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ui_resource_id, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ui_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_bounds, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_top_left, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_top_left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uv_bottom_right, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uv_bottom_right, validation_context))
    return false;

  return true;
}

NinePatchLayerExtra_Data::NinePatchLayerExtra_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Layer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Layer_Data* object =
      static_cast<const Layer_Data*>(data);


  if (!::cc::mojom::internal::LayerType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;


  if (!::cc::mojom::internal::HitTestOpaqueness_Data
        ::Validate(object->hit_test_opaqueness, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->safe_opaque_background_color, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->safe_opaque_background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_rect, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offset_to_transform_parent, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->offset_to_transform_parent, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->rare_properties, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->layer_extra, validation_context))
    return false;

  return true;
}

Layer_Data::Layer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnchorPositionScrollData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnchorPositionScrollData_Data* object =
      static_cast<const AnchorPositionScrollData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->adjustment_container_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& adjustment_container_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->adjustment_container_ids, validation_context,
                                         &adjustment_container_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accumulated_scroll_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accumulated_scroll_origin, validation_context))
    return false;

  return true;
}

AnchorPositionScrollData_Data::AnchorPositionScrollData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StickyPositionNodeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StickyPositionNodeData_Data* object =
      static_cast<const StickyPositionNodeData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constraint_box_rect, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constraint_box_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_container_relative_sticky_box_rect, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_container_relative_sticky_box_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_container_relative_containing_block_rect, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_container_relative_containing_block_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_snap_offset, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pixel_snap_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_sticky_box_sticky_offset, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_sticky_box_sticky_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_containing_block_sticky_offset, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_containing_block_sticky_offset, validation_context))
    return false;

  return true;
}

StickyPositionNodeData_Data::StickyPositionNodeData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TransformTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransformTreeUpdate_Data* object =
      static_cast<const TransformTreeUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes_affected_by_outer_viewport_bounds_delta, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_outer_viewport_bounds_delta_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nodes_affected_by_outer_viewport_bounds_delta, validation_context,
                                         &nodes_affected_by_outer_viewport_bounds_delta_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes_affected_by_safe_area_bottom, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_safe_area_bottom_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nodes_affected_by_safe_area_bottom, validation_context,
                                         &nodes_affected_by_safe_area_bottom_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sticky_position_data, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sticky_position_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sticky_position_data, validation_context,
                                         &sticky_position_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor_position_scroll_data, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& anchor_position_scroll_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->anchor_position_scroll_data, validation_context,
                                         &anchor_position_scroll_data_validate_params)) {
    return false;
  }

  return true;
}

TransformTreeUpdate_Data::TransformTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TransformNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransformNode_Data* object =
      static_cast<const TransformNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->post_translation, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->post_translation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->to_parent, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->to_parent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offset, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snap_amount, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snap_amount, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_frame_element_id, 33, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_frame_element_id, validation_context))
    return false;

  return true;
}

TransformNode_Data::TransformNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipNode_Data* object =
      static_cast<const ClipNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip, validation_context))
    return false;

  return true;
}

ClipNode_Data::ClipNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EffectNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EffectNode_Data* object =
      static_cast<const EffectNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;


  if (!::cc::mojom::internal::RenderSurfaceReason_Data
        ::Validate(object->render_surface_reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_contents_scale, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_contents_scale, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subtree_capture_id, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subtree_capture_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subtree_size, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subtree_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_transition_element_resource_id, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_transition_element_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->backdrop_filters, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->backdrop_filters, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->backdrop_filter_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->backdrop_mask_element_id, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->backdrop_mask_element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mask_filter_info, 24, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mask_filter_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->copy_output_requests, 36, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& copy_output_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->copy_output_requests, validation_context,
                                         &copy_output_requests_validate_params)) {
    return false;
  }

  return true;
}

EffectNode_Data::EffectNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollTreeUpdate_Data* object =
      static_cast<const ScrollTreeUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->synced_scroll_offsets, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& synced_scroll_offsets_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->synced_scroll_offsets, validation_context,
                                         &synced_scroll_offsets_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrolling_contents_cull_rects, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scrolling_contents_cull_rects_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->scrolling_contents_cull_rects, validation_context,
                                         &scrolling_contents_cull_rects_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elastic_overscroll, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& elastic_overscroll_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->elastic_overscroll, validation_context,
                                         &elastic_overscroll_validate_params)) {
    return false;
  }

  return true;
}

ScrollTreeUpdate_Data::ScrollTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollNode_Data* object =
      static_cast<const ScrollNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->container_bounds, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->container_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  return true;
}

ScrollNode_Data::ScrollNode_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz