// services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');



  function FrameSinkBundleId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundleId.prototype.initDefaults_ = function() {
    this.clientId = 0;
    this.bundleId = 0;
  };
  FrameSinkBundleId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundleId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameSinkBundleId.encodedSize = codec.kStructHeaderSize + 8;

  FrameSinkBundleId.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundleId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.clientId =
        decoder.decodeStruct(codec.Uint32);
    val.bundleId =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  FrameSinkBundleId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundleId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.clientId);
    encoder.encodeStruct(codec.Uint32, val.bundleId);
  };
  exports.FrameSinkBundleId = FrameSinkBundleId;
})();