// services/viz/public/mojom/compositing/copy_output_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Vector2d as gfx_mojom_Vector2d,
  Vector2dSpec as gfx_mojom_Vector2dSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  BlitRequest as viz_mojom_BlitRequest,
  BlitRequestSpec as viz_mojom_BlitRequestSpec
} from './blit_request.mojom.m.js';

import {
  CopyOutputResultDestination as viz_mojom_CopyOutputResultDestination,
  CopyOutputResultDestinationSpec as viz_mojom_CopyOutputResultDestinationSpec,
  CopyOutputResultFormat as viz_mojom_CopyOutputResultFormat,
  CopyOutputResultFormatSpec as viz_mojom_CopyOutputResultFormatSpec,
  CopyOutputResult as viz_mojom_CopyOutputResult,
  CopyOutputResultSpec as viz_mojom_CopyOutputResultSpec
} from './copy_output_result.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CopyOutputResultSenderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.CopyOutputResultSender', scope);
  }
}

/** @interface */
export class CopyOutputResultSenderInterface {
  
  /**
   * @param { !viz_mojom_CopyOutputResult } result
   */

  sendResult(result) {}
}

/**
 * @implements { CopyOutputResultSenderInterface }
 */
export class CopyOutputResultSenderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CopyOutputResultSenderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CopyOutputResultSenderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CopyOutputResultSenderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !viz_mojom_CopyOutputResult } result
   */

  sendResult(
      result) {
    this.proxy.sendMessage(
        0,
        CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CopyOutputResultSender
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CopyOutputResultSenderReceiver {
  /**
   * @param {!CopyOutputResultSenderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CopyOutputResultSenderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CopyOutputResultSenderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CopyOutputResultSenderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        impl.sendResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CopyOutputResultSender {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CopyOutputResultSender";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CopyOutputResultSenderRemote}
   */
  static getRemote() {
    let remote = new CopyOutputResultSenderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CopyOutputResultSender
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CopyOutputResultSenderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CopyOutputResultSenderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CopyOutputResultSenderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        this.sendResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CopyOutputRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CopyOutputResultSender_SendResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CopyOutputRequestSpec.$,
    'CopyOutputRequest',
    [
      mojo.internal.StructField(
        'resultFormat', 0,
        0,
        viz_mojom_CopyOutputResultFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultDestination', 4,
        0,
        viz_mojom_CopyOutputResultDestinationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendResultDelay', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scaleFrom', 16,
        0,
        gfx_mojom_Vector2dSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scaleTo', 24,
        0,
        gfx_mojom_Vector2dSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'area', 40,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultSelection', 48,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blitRequest', 56,
        0,
        viz_mojom_BlitRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultSender', 64,
        0,
        mojo.internal.InterfaceProxy(CopyOutputResultSenderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class CopyOutputRequest {
  constructor() {
    /** @type { !viz_mojom_CopyOutputResultFormat } */
    this.resultFormat;
    /** @type { !viz_mojom_CopyOutputResultDestination } */
    this.resultDestination;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.sendResultDelay;
    /** @type { !gfx_mojom_Vector2d } */
    this.scaleFrom;
    /** @type { !gfx_mojom_Vector2d } */
    this.scaleTo;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.source;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.area;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.resultSelection;
    /** @type { (viz_mojom_BlitRequest|undefined) } */
    this.blitRequest;
    /** @type { !CopyOutputResultSenderRemote } */
    this.resultSender;
  }
}



mojo.internal.Struct(
    CopyOutputResultSender_SendResult_ParamsSpec.$,
    'CopyOutputResultSender_SendResult_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        viz_mojom_CopyOutputResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CopyOutputResultSender_SendResult_Params {
  constructor() {
    /** @type { !viz_mojom_CopyOutputResult } */
    this.result;
  }
}

